/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.imsphone;

import android.content.Context;
import android.net.Uri;
import android.telephony.PhoneNumberUtils;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.imsphone.ImsExternalCall;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ImsExternalConnection
extends Connection
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String CONFERENCE_PREFIX = "conf";
    private Context mContext;
    private Set<Listener> mListeners;
    private int mCallId;
    private ImsExternalCall mCall;
    private Uri mOriginalAddress;
    private boolean mIsPullable;

    private void $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$__constructor__(Phone phone, int callId, Uri address, boolean isPullable) {
        this.mListeners = Collections.newSetFromMap(new ConcurrentHashMap(8, 0.9f, 1));
        this.mContext = phone.getContext();
        this.mCall = new ImsExternalCall(phone, this);
        this.mCallId = callId;
        this.setExternalConnectionAddress(address);
        this.mNumberPresentation = 1;
        this.mIsPullable = isPullable;
        this.rebuildCapabilities();
        this.setActive();
    }

    private final int $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$getCallId() {
        return this.mCallId;
    }

    private final Call $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$getCall() {
        return this.mCall;
    }

    private final long $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$getDisconnectTime() {
        return 0L;
    }

    private final long $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$getHoldDurationMillis() {
        return 0L;
    }

    private final String $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$getVendorDisconnectCause() {
        return null;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$hangup() throws CallStateException {
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$deflect(String number) throws CallStateException {
        throw new CallStateException("Deflect is not supported for external calls");
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$separate() throws CallStateException {
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$proceedAfterWaitChar() {
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$proceedAfterWildChar(String str) {
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$cancelPostDial() {
    }

    private final int $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$getNumberPresentation() {
        return this.mNumberPresentation;
    }

    private final UUSInfo $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$getUUSInfo() {
        return null;
    }

    private final int $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$getPreciseDisconnectCause() {
        return 0;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$isMultiparty() {
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$pullExternalCall() {
        for (Listener listener : this.mListeners) {
            listener.onPullExternalCall(this);
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$setActive() {
        if (this.mCall == null) {
            return;
        }
        this.mCall.setActive();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$setTerminated() {
        if (this.mCall == null) {
            return;
        }
        this.mCall.setTerminated();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$setIsPullable(boolean isPullable) {
        this.mIsPullable = isPullable;
        this.rebuildCapabilities();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$setExternalConnectionAddress(Uri address) {
        this.mOriginalAddress = address;
        if ("sip".equals(address.getScheme()) && address.getSchemeSpecificPart().startsWith("conf")) {
            this.mCnapName = this.mContext.getString(17039631);
            this.mCnapNamePresentation = 1;
            this.mAddress = "";
            this.mNumberPresentation = 2;
            return;
        }
        Uri telUri = PhoneNumberUtils.convertSipUriToTelUri(address);
        this.mAddress = telUri.getSchemeSpecificPart();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$addListener(Listener listener) {
        this.mListeners.add(listener);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$removeListener(Listener listener) {
        this.mListeners.remove(listener);
    }

    private final String $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$toString() {
        StringBuilder str = new StringBuilder(128);
        str.append("[ImsExternalConnection dialogCallId:");
        str.append(this.mCallId);
        str.append(" state:");
        if (this.mCall.getState() == Call.State.ACTIVE) {
            str.append("Active");
        } else if (this.mCall.getState() == Call.State.DISCONNECTED) {
            str.append("Disconnected");
        }
        str.append("]");
        return str.toString();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$rebuildCapabilities() {
        int capabilities = 16;
        if (this.mIsPullable) {
            capabilities |= 0x20;
        }
        this.setConnectionCapabilities(capabilities);
    }

    private void __constructor__(Phone phone, int n, Uri uri, boolean bl) {
        this.$$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$__constructor__(phone, n, uri, bl);
    }

    protected ImsExternalConnection(Phone phone, int n, Uri uri, boolean bl) {
        super(phone.getPhoneType());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$__constructor__(com.android.internal.telephony.Phone int android.net.Uri boolean ), 0, this, phone, n, uri, bl);
    }

    public int getCallId() {
        return (int)InvokeDynamicSupport.bootstrap("getCallId", $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$getCallId(), 0, this);
    }

    @Override
    public Call getCall() {
        return InvokeDynamicSupport.bootstrap("getCall", $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$getCall(), 0, this);
    }

    @Override
    public long getDisconnectTime() {
        return (long)InvokeDynamicSupport.bootstrap("getDisconnectTime", $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$getDisconnectTime(), 0, this);
    }

    @Override
    public long getHoldDurationMillis() {
        return (long)InvokeDynamicSupport.bootstrap("getHoldDurationMillis", $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$getHoldDurationMillis(), 0, this);
    }

    @Override
    public String getVendorDisconnectCause() {
        return InvokeDynamicSupport.bootstrap("getVendorDisconnectCause", $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$getVendorDisconnectCause(), 0, this);
    }

    @Override
    public void hangup() throws CallStateException {
        InvokeDynamicSupport.bootstrap("hangup", $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$hangup(), 0, this);
    }

    @Override
    public void deflect(String string2) throws CallStateException {
        InvokeDynamicSupport.bootstrap("deflect", $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$deflect(java.lang.String ), 0, this, string2);
    }

    @Override
    public void separate() throws CallStateException {
        InvokeDynamicSupport.bootstrap("separate", $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$separate(), 0, this);
    }

    @Override
    public void proceedAfterWaitChar() {
        InvokeDynamicSupport.bootstrap("proceedAfterWaitChar", $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$proceedAfterWaitChar(), 0, this);
    }

    @Override
    public void proceedAfterWildChar(String string2) {
        InvokeDynamicSupport.bootstrap("proceedAfterWildChar", $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$proceedAfterWildChar(java.lang.String ), 0, this, string2);
    }

    @Override
    public void cancelPostDial() {
        InvokeDynamicSupport.bootstrap("cancelPostDial", $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$cancelPostDial(), 0, this);
    }

    @Override
    public int getNumberPresentation() {
        return (int)InvokeDynamicSupport.bootstrap("getNumberPresentation", $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$getNumberPresentation(), 0, this);
    }

    @Override
    public UUSInfo getUUSInfo() {
        return InvokeDynamicSupport.bootstrap("getUUSInfo", $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$getUUSInfo(), 0, this);
    }

    @Override
    public int getPreciseDisconnectCause() {
        return (int)InvokeDynamicSupport.bootstrap("getPreciseDisconnectCause", $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$getPreciseDisconnectCause(), 0, this);
    }

    @Override
    public boolean isMultiparty() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMultiparty", $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$isMultiparty(), 0, this);
    }

    @Override
    public void pullExternalCall() {
        InvokeDynamicSupport.bootstrap("pullExternalCall", $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$pullExternalCall(), 0, this);
    }

    public void setActive() {
        InvokeDynamicSupport.bootstrap("setActive", $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$setActive(), 0, this);
    }

    public void setTerminated() {
        InvokeDynamicSupport.bootstrap("setTerminated", $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$setTerminated(), 0, this);
    }

    public void setIsPullable(boolean bl) {
        InvokeDynamicSupport.bootstrap("setIsPullable", $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$setIsPullable(boolean ), 0, this, bl);
    }

    public void setExternalConnectionAddress(Uri uri) {
        InvokeDynamicSupport.bootstrap("setExternalConnectionAddress", $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$setExternalConnectionAddress(android.net.Uri ), 0, this, uri);
    }

    public void addListener(Listener listener) {
        InvokeDynamicSupport.bootstrap("addListener", $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$addListener(com.android.internal.telephony.imsphone.ImsExternalConnection$Listener ), 0, this, listener);
    }

    public void removeListener(Listener listener) {
        InvokeDynamicSupport.bootstrap("removeListener", $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$removeListener(com.android.internal.telephony.imsphone.ImsExternalConnection$Listener ), 0, this, listener);
    }

    @Override
    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$toString(), 0, this);
    }

    private void rebuildCapabilities() {
        InvokeDynamicSupport.bootstrap("rebuildCapabilities", $$robo$$com_android_internal_telephony_imsphone_ImsExternalConnection$rebuildCapabilities(), 0, this);
    }

    public /* synthetic */ ImsExternalConnection() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsExternalConnection)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface Listener
    extends InstrumentedInterface {
        public void onPullExternalCall(ImsExternalConnection var1);
    }
}

