/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.imsphone;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.telecom.Connection;
import android.telephony.Rlog;
import com.android.internal.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.CountDownLatch;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ImsRttTextHandler
extends Handler
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "ImsRttTextHandler";
    public static int MAX_CODEPOINTS_PER_SECOND = 30;
    public static int MAX_BUFFERING_DELAY_MILLIS = 200;
    public static int MAX_BUFFERED_CHARACTER_COUNT = 5;
    private static int MILLIS_PER_SECOND = 1000;
    private static int INITIALIZE = 1;
    private static int APPEND_TO_NETWORK_BUFFER = 2;
    private static int SEND_TO_INCALL = 3;
    private static int ATTEMPT_SEND_TO_NETWORK = 4;
    private static int EXPIRE_SENT_CODEPOINT_COUNT = 5;
    private static int TEARDOWN = 9999;
    private Connection.RttTextStream mRttTextStream;
    private CountDownLatch mReadNotifier;
    private int mCodepointsAvailableForTransmission;
    private StringBuffer mBufferedTextToNetwork;
    private InCallReaderThread mReaderThread;
    private StringBuffer mBufferedTextToIncall;
    private NetworkWriter mNetworkWriter;

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsRttTextHandler$handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                if (this.mRttTextStream != null || this.mReaderThread != null) {
                    Rlog.e("ImsRttTextHandler", "RTT text stream already initialized. Ignoring.");
                    return;
                }
                this.mRttTextStream = (Connection.RttTextStream)msg.obj;
                this.mReaderThread = new InCallReaderThread(this, this.mRttTextStream);
                this.mReaderThread.start();
                break;
            }
            case 3: {
                String messageToIncall = (String)msg.obj;
                try {
                    this.mRttTextStream.write(messageToIncall);
                }
                catch (IOException e) {
                    Rlog.e("ImsRttTextHandler", "IOException encountered writing to in-call: %s", e);
                    this.obtainMessage(9999).sendToTarget();
                    this.mBufferedTextToIncall.append(messageToIncall);
                }
                break;
            }
            case 2: {
                this.mBufferedTextToNetwork.append((String)msg.obj);
                int numCodepointsBuffered = this.mBufferedTextToNetwork.codePointCount(0, this.mBufferedTextToNetwork.length());
                if (numCodepointsBuffered >= 5) {
                    this.sendMessage(this.obtainMessage(4));
                    break;
                }
                this.sendEmptyMessageDelayed(4, 200L);
                break;
            }
            case 4: {
                int numCodePointsAvailableInBuffer = this.mBufferedTextToNetwork.codePointCount(0, this.mBufferedTextToNetwork.length());
                int numCodePointsSent = Math.min(numCodePointsAvailableInBuffer, this.mCodepointsAvailableForTransmission);
                if (numCodePointsSent == 0) break;
                int endSendIndex = this.mBufferedTextToNetwork.offsetByCodePoints(0, numCodePointsSent);
                String stringToSend = this.mBufferedTextToNetwork.substring(0, endSendIndex);
                this.mBufferedTextToNetwork.delete(0, endSendIndex);
                this.mNetworkWriter.write(stringToSend);
                this.mCodepointsAvailableForTransmission -= numCodePointsSent;
                this.sendMessageDelayed(this.obtainMessage(5, numCodePointsSent, 0), 1000L);
                break;
            }
            case 5: {
                this.mCodepointsAvailableForTransmission += msg.arg1;
                if (this.mCodepointsAvailableForTransmission <= 0) break;
                this.sendMessage(this.obtainMessage(4));
                break;
            }
            case 9999: {
                try {
                    if (this.mReaderThread != null) {
                        this.mReaderThread.interrupt();
                        this.mReaderThread.join(1000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.mReaderThread = null;
                this.mRttTextStream = null;
            }
        }
    }

    private void $$robo$$com_android_internal_telephony_imsphone_ImsRttTextHandler$__constructor__(Looper looper, NetworkWriter networkWriter) {
        this.mCodepointsAvailableForTransmission = 30;
        this.mBufferedTextToNetwork = new StringBuffer();
        this.mBufferedTextToIncall = new StringBuffer();
        this.mNetworkWriter = networkWriter;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsRttTextHandler$sendToInCall(String msg) {
        this.obtainMessage(3, msg).sendToTarget();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsRttTextHandler$initialize(Connection.RttTextStream rttTextStream) {
        Rlog.i("ImsRttTextHandler", "Initializing: " + this);
        this.obtainMessage(1, rttTextStream).sendToTarget();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsRttTextHandler$tearDown() {
        this.obtainMessage(9999).sendToTarget();
    }

    @VisibleForTesting
    private final void $$robo$$com_android_internal_telephony_imsphone_ImsRttTextHandler$setReadNotifier(CountDownLatch latch) {
        this.mReadNotifier = latch;
    }

    private final String $$robo$$com_android_internal_telephony_imsphone_ImsRttTextHandler$getNetworkBufferText() {
        return this.mBufferedTextToNetwork.toString();
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_imsphone_ImsRttTextHandler$handleMessage(android.os.Message ), 0, this, message);
    }

    private void __constructor__(Looper looper, NetworkWriter networkWriter) {
        this.$$robo$$com_android_internal_telephony_imsphone_ImsRttTextHandler$__constructor__(looper, networkWriter);
    }

    public ImsRttTextHandler(Looper looper, NetworkWriter networkWriter) {
        super(looper);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsRttTextHandler$__constructor__(android.os.Looper com.android.internal.telephony.imsphone.ImsRttTextHandler$NetworkWriter ), 0, this, looper, networkWriter);
    }

    public void sendToInCall(String string2) {
        InvokeDynamicSupport.bootstrap("sendToInCall", $$robo$$com_android_internal_telephony_imsphone_ImsRttTextHandler$sendToInCall(java.lang.String ), 0, this, string2);
    }

    public void initialize(Connection.RttTextStream rttTextStream) {
        InvokeDynamicSupport.bootstrap("initialize", $$robo$$com_android_internal_telephony_imsphone_ImsRttTextHandler$initialize(android.telecom.Connection$RttTextStream ), 0, this, rttTextStream);
    }

    public void tearDown() {
        InvokeDynamicSupport.bootstrap("tearDown", $$robo$$com_android_internal_telephony_imsphone_ImsRttTextHandler$tearDown(), 0, this);
    }

    public void setReadNotifier(CountDownLatch countDownLatch) {
        InvokeDynamicSupport.bootstrap("setReadNotifier", $$robo$$com_android_internal_telephony_imsphone_ImsRttTextHandler$setReadNotifier(java.util.concurrent.CountDownLatch ), 0, this, countDownLatch);
    }

    public String getNetworkBufferText() {
        return InvokeDynamicSupport.bootstrap("getNetworkBufferText", $$robo$$com_android_internal_telephony_imsphone_ImsRttTextHandler$getNetworkBufferText(), 0, this);
    }

    public /* synthetic */ ImsRttTextHandler() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsRttTextHandler)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class InCallReaderThread
    extends Thread
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Connection.RttTextStream mReaderThreadRttTextStream;
        /* synthetic */ ImsRttTextHandler this$0;

        private void $$robo$$com_android_internal_telephony_imsphone_ImsRttTextHandler_InCallReaderThread$__constructor__(ImsRttTextHandler imsRttTextHandler, Connection.RttTextStream textStream) {
            this.mReaderThreadRttTextStream = textStream;
        }

        private final void $$robo$$com_android_internal_telephony_imsphone_ImsRttTextHandler_InCallReaderThread$run() {
            while (true) {
                String charsReceived;
                try {
                    charsReceived = this.mReaderThreadRttTextStream.read();
                }
                catch (ClosedByInterruptException e) {
                    Rlog.i("ImsRttTextHandler", "RttReaderThread - Thread interrupted. Finishing.");
                    break;
                }
                catch (IOException e) {
                    Rlog.e("ImsRttTextHandler", "RttReaderThread - IOException encountered reading from in-call: ", e);
                    this.this$0.obtainMessage(9999).sendToTarget();
                    break;
                }
                if (charsReceived == null) {
                    Rlog.e("ImsRttTextHandler", "RttReaderThread - Stream closed unexpectedly. Attempt to reinitialize.");
                    this.this$0.obtainMessage(9999).sendToTarget();
                    break;
                }
                if (charsReceived.length() == 0) continue;
                this.this$0.obtainMessage(2, charsReceived).sendToTarget();
                if (this.this$0.mReadNotifier == null) continue;
                this.this$0.mReadNotifier.countDown();
            }
        }

        private void __constructor__(ImsRttTextHandler imsRttTextHandler, Connection.RttTextStream rttTextStream) {
            this.$$robo$$com_android_internal_telephony_imsphone_ImsRttTextHandler_InCallReaderThread$__constructor__(imsRttTextHandler, rttTextStream);
        }

        public InCallReaderThread(ImsRttTextHandler imsRttTextHandler, Connection.RttTextStream rttTextStream) {
            this.this$0 = imsRttTextHandler;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsRttTextHandler_InCallReaderThread$__constructor__(com.android.internal.telephony.imsphone.ImsRttTextHandler android.telecom.Connection$RttTextStream ), 0, this, imsRttTextHandler, rttTextStream);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_telephony_imsphone_ImsRttTextHandler_InCallReaderThread$run(), 0, this);
        }

        public /* synthetic */ InCallReaderThread() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InCallReaderThread)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface NetworkWriter
    extends InstrumentedInterface {
        public void write(String var1);
    }
}

