/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.telephony.Rlog;
import android.util.ArrayMap;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.uicc.IccUtils;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AnswerToReset
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "AnswerToReset";
    private static boolean VDBG = false;
    private static int TAG_CARD_CAPABILITIES = 7;
    private static int EXTENDED_APDU_INDEX = 2;
    private static int B7_MASK = 64;
    private static int B2_MASK = 2;
    public static byte EUICC_SUPPORTED = -126;
    public static byte DIRECT_CONVENTION = 59;
    public static byte INVERSE_CONVENTION = 63;
    public static int INTERFACE_BYTES_MASK = 240;
    public static int T_MASK = 15;
    public static int T_VALUE_FOR_GLOBAL_INTERFACE = 15;
    public static int TA_MASK = 16;
    public static int TB_MASK = 32;
    public static int TC_MASK = 64;
    public static int TD_MASK = 128;
    private boolean mIsDirectConvention;
    private boolean mOnlyTEqualsZero;
    private boolean mIsEuiccSupported;
    private byte mFormatByte;
    private ArrayList<InterfaceByte> mInterfaceBytes;
    private HistoricalBytes mHistoricalBytes;
    private Byte mCheckByte;

    private static final AnswerToReset $$robo$$com_android_internal_telephony_uicc_AnswerToReset$parseAtr(String atr) {
        AnswerToReset answerToReset = new AnswerToReset();
        if (answerToReset.parseAtrString(atr)) {
            return answerToReset;
        }
        return null;
    }

    private void $$robo$$com_android_internal_telephony_uicc_AnswerToReset$__constructor__() {
        this.mOnlyTEqualsZero = true;
        this.mInterfaceBytes = new ArrayList();
    }

    private static final String $$robo$$com_android_internal_telephony_uicc_AnswerToReset$byteToStringHex(Byte b) {
        return b == null ? null : IccUtils.byteToHex(b);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_AnswerToReset$checkIsEuiccSupported() {
        for (int i = 0; i < this.mInterfaceBytes.size() - 1; ++i) {
            if (this.mInterfaceBytes.get(i).getTD() == null || (this.mInterfaceBytes.get(i).getTD() & 0xF) != 15 || this.mInterfaceBytes.get(i + 1).getTB() == null || this.mInterfaceBytes.get(i + 1).getTB() != -126) continue;
            this.mIsEuiccSupported = true;
            return;
        }
    }

    private final int $$robo$$com_android_internal_telephony_uicc_AnswerToReset$parseConventionByte(byte[] atrBytes, int index) {
        if (index >= atrBytes.length) {
            AnswerToReset.loge("Failed to read the convention byte.");
            return -1;
        }
        byte value = atrBytes[index];
        if (value == 59) {
            this.mIsDirectConvention = true;
        } else if (value == 63) {
            this.mIsDirectConvention = false;
        } else {
            AnswerToReset.loge("Unrecognized convention byte " + IccUtils.byteToHex(value));
            return -1;
        }
        return index + 1;
    }

    private final int $$robo$$com_android_internal_telephony_uicc_AnswerToReset$parseFormatByte(byte[] atrBytes, int index) {
        if (index >= atrBytes.length) {
            AnswerToReset.loge("Failed to read the format byte.");
            return -1;
        }
        this.mFormatByte = atrBytes[index];
        return index + 1;
    }

    private final int $$robo$$com_android_internal_telephony_uicc_AnswerToReset$parseInterfaceBytes(byte[] atrBytes, int index) {
        byte lastTD = this.mFormatByte;
        while ((lastTD & 0xF0) != 0) {
            InterfaceByte interfaceByte = new InterfaceByte();
            if ((lastTD & 0x10) != 0) {
                if (index >= atrBytes.length) {
                    AnswerToReset.loge("Failed to read the byte for TA.");
                    return -1;
                }
                interfaceByte.setTA(atrBytes[index]);
                ++index;
            }
            if ((lastTD & 0x20) != 0) {
                if (index >= atrBytes.length) {
                    AnswerToReset.loge("Failed to read the byte for TB.");
                    return -1;
                }
                interfaceByte.setTB(atrBytes[index]);
                ++index;
            }
            if ((lastTD & 0x40) != 0) {
                if (index >= atrBytes.length) {
                    AnswerToReset.loge("Failed to read the byte for TC.");
                    return -1;
                }
                interfaceByte.setTC(atrBytes[index]);
                ++index;
            }
            if ((lastTD & 0x80) != 0) {
                if (index >= atrBytes.length) {
                    AnswerToReset.loge("Failed to read the byte for TD.");
                    return -1;
                }
                interfaceByte.setTD(atrBytes[index]);
                ++index;
            }
            this.mInterfaceBytes.add(interfaceByte);
            Byte newTD = interfaceByte.getTD();
            if (newTD == null) break;
            lastTD = newTD;
            if ((lastTD & 0xF) == 0) continue;
            this.mOnlyTEqualsZero = false;
        }
        return index;
    }

    private final int $$robo$$com_android_internal_telephony_uicc_AnswerToReset$parseHistoricalBytes(byte[] atrBytes, int index) {
        int length = this.mFormatByte & 0xF;
        if (length + index > atrBytes.length) {
            AnswerToReset.loge("Failed to read the historical bytes.");
            return -1;
        }
        if (length > 0) {
            this.mHistoricalBytes = HistoricalBytes.parseHistoricalBytes(atrBytes, index, length);
        }
        return index + length;
    }

    private final int $$robo$$com_android_internal_telephony_uicc_AnswerToReset$parseCheckBytes(byte[] atrBytes, int index) {
        if (index < atrBytes.length) {
            this.mCheckByte = atrBytes[index];
            ++index;
        } else {
            if (!this.mOnlyTEqualsZero) {
                AnswerToReset.loge("Check byte must be present because T equals to values other than 0.");
                return -1;
            }
            AnswerToReset.log("Check byte can be absent because T=0.");
        }
        return index;
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_AnswerToReset$parseAtrString(String atr) {
        if (atr == null) {
            AnswerToReset.loge("The input ATR string can not be null");
            return false;
        }
        if (atr.length() % 2 != 0) {
            AnswerToReset.loge("The length of input ATR string " + atr.length() + " is not even.");
            return false;
        }
        if (atr.length() < 4) {
            AnswerToReset.loge("Valid ATR string must at least contains TS and T0.");
            return false;
        }
        byte[] atrBytes = IccUtils.hexStringToBytes(atr);
        if (atrBytes == null) {
            return false;
        }
        int index = this.parseConventionByte(atrBytes, 0);
        if (index == -1) {
            return false;
        }
        if ((index = this.parseFormatByte(atrBytes, index)) == -1) {
            return false;
        }
        if ((index = this.parseInterfaceBytes(atrBytes, index)) == -1) {
            return false;
        }
        if ((index = this.parseHistoricalBytes(atrBytes, index)) == -1) {
            return false;
        }
        if ((index = this.parseCheckBytes(atrBytes, index)) == -1) {
            return false;
        }
        if (index != atrBytes.length) {
            AnswerToReset.loge("Unexpected bytes after the check byte.");
            return false;
        }
        AnswerToReset.log("Successfully parsed the ATR string " + atr + " into " + this.toString());
        this.checkIsEuiccSupported();
        return true;
    }

    private static final void $$robo$$com_android_internal_telephony_uicc_AnswerToReset$log(String msg) {
        Rlog.d("AnswerToReset", msg);
    }

    private static final void $$robo$$com_android_internal_telephony_uicc_AnswerToReset$loge(String msg) {
        Rlog.e("AnswerToReset", msg);
    }

    private final byte $$robo$$com_android_internal_telephony_uicc_AnswerToReset$getConventionByte() {
        return this.mIsDirectConvention ? (byte)59 : 63;
    }

    private final byte $$robo$$com_android_internal_telephony_uicc_AnswerToReset$getFormatByte() {
        return this.mFormatByte;
    }

    private final List<InterfaceByte> $$robo$$com_android_internal_telephony_uicc_AnswerToReset$getInterfaceBytes() {
        return this.mInterfaceBytes;
    }

    private final HistoricalBytes $$robo$$com_android_internal_telephony_uicc_AnswerToReset$getHistoricalBytes() {
        return this.mHistoricalBytes;
    }

    private final Byte $$robo$$com_android_internal_telephony_uicc_AnswerToReset$getCheckByte() {
        return this.mCheckByte;
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_AnswerToReset$isEuiccSupported() {
        return this.mIsEuiccSupported;
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_AnswerToReset$isExtendedApduSupported() {
        if (this.mHistoricalBytes == null) {
            return false;
        }
        byte[] cardCapabilities = this.mHistoricalBytes.getValue(7);
        if (cardCapabilities == null || cardCapabilities.length < 3) {
            return false;
        }
        if (this.mIsDirectConvention) {
            return (cardCapabilities[2] & 0x40) > 0;
        }
        return (cardCapabilities[2] & 2) > 0;
    }

    private final String $$robo$$com_android_internal_telephony_uicc_AnswerToReset$toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("AnswerToReset:{");
        sb.append("mConventionByte=").append(IccUtils.byteToHex(this.getConventionByte())).append(",");
        sb.append("mFormatByte=").append(AnswerToReset.byteToStringHex(this.mFormatByte)).append(",");
        sb.append("mInterfaceBytes={");
        for (InterfaceByte ib : this.mInterfaceBytes) {
            sb.append(ib.toString());
        }
        sb.append("},");
        sb.append("mHistoricalBytes={");
        if (this.mHistoricalBytes != null) {
            for (Object b : (Object)this.mHistoricalBytes.getRawData()) {
                sb.append(IccUtils.byteToHex((byte)b)).append(",");
            }
        }
        sb.append("},");
        sb.append("mCheckByte=").append(AnswerToReset.byteToStringHex(this.mCheckByte));
        sb.append("}");
        return sb.toString();
    }

    private final void $$robo$$com_android_internal_telephony_uicc_AnswerToReset$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("AnswerToReset:");
        pw.println(this.toString());
        pw.flush();
    }

    public static AnswerToReset parseAtr(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("parseAtr", $$robo$$com_android_internal_telephony_uicc_AnswerToReset$parseAtr(java.lang.String ), 0, (String)string2);
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_uicc_AnswerToReset$__constructor__();
    }

    private AnswerToReset() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_AnswerToReset$__constructor__(), 0, this);
    }

    private static String byteToStringHex(Byte by) {
        return InvokeDynamicSupport.bootstrapStatic("byteToStringHex", $$robo$$com_android_internal_telephony_uicc_AnswerToReset$byteToStringHex(java.lang.Byte ), 0, (Byte)by);
    }

    private void checkIsEuiccSupported() {
        InvokeDynamicSupport.bootstrap("checkIsEuiccSupported", $$robo$$com_android_internal_telephony_uicc_AnswerToReset$checkIsEuiccSupported(), 0, this);
    }

    private int parseConventionByte(byte[] byArray, int n) {
        return (int)InvokeDynamicSupport.bootstrap("parseConventionByte", $$robo$$com_android_internal_telephony_uicc_AnswerToReset$parseConventionByte(byte[] int ), 0, this, byArray, n);
    }

    private int parseFormatByte(byte[] byArray, int n) {
        return (int)InvokeDynamicSupport.bootstrap("parseFormatByte", $$robo$$com_android_internal_telephony_uicc_AnswerToReset$parseFormatByte(byte[] int ), 0, this, byArray, n);
    }

    private int parseInterfaceBytes(byte[] byArray, int n) {
        return (int)InvokeDynamicSupport.bootstrap("parseInterfaceBytes", $$robo$$com_android_internal_telephony_uicc_AnswerToReset$parseInterfaceBytes(byte[] int ), 0, this, byArray, n);
    }

    private int parseHistoricalBytes(byte[] byArray, int n) {
        return (int)InvokeDynamicSupport.bootstrap("parseHistoricalBytes", $$robo$$com_android_internal_telephony_uicc_AnswerToReset$parseHistoricalBytes(byte[] int ), 0, this, byArray, n);
    }

    private int parseCheckBytes(byte[] byArray, int n) {
        return (int)InvokeDynamicSupport.bootstrap("parseCheckBytes", $$robo$$com_android_internal_telephony_uicc_AnswerToReset$parseCheckBytes(byte[] int ), 0, this, byArray, n);
    }

    private boolean parseAtrString(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("parseAtrString", $$robo$$com_android_internal_telephony_uicc_AnswerToReset$parseAtrString(java.lang.String ), 0, this, string2);
    }

    private static void log(String string2) {
        InvokeDynamicSupport.bootstrapStatic("log", $$robo$$com_android_internal_telephony_uicc_AnswerToReset$log(java.lang.String ), 0, (String)string2);
    }

    private static void loge(String string2) {
        InvokeDynamicSupport.bootstrapStatic("loge", $$robo$$com_android_internal_telephony_uicc_AnswerToReset$loge(java.lang.String ), 0, (String)string2);
    }

    public byte getConventionByte() {
        return (byte)InvokeDynamicSupport.bootstrap("getConventionByte", $$robo$$com_android_internal_telephony_uicc_AnswerToReset$getConventionByte(), 0, this);
    }

    public byte getFormatByte() {
        return (byte)InvokeDynamicSupport.bootstrap("getFormatByte", $$robo$$com_android_internal_telephony_uicc_AnswerToReset$getFormatByte(), 0, this);
    }

    public List<InterfaceByte> getInterfaceBytes() {
        return InvokeDynamicSupport.bootstrap("getInterfaceBytes", $$robo$$com_android_internal_telephony_uicc_AnswerToReset$getInterfaceBytes(), 0, this);
    }

    public HistoricalBytes getHistoricalBytes() {
        return InvokeDynamicSupport.bootstrap("getHistoricalBytes", $$robo$$com_android_internal_telephony_uicc_AnswerToReset$getHistoricalBytes(), 0, this);
    }

    public Byte getCheckByte() {
        return InvokeDynamicSupport.bootstrap("getCheckByte", $$robo$$com_android_internal_telephony_uicc_AnswerToReset$getCheckByte(), 0, this);
    }

    public boolean isEuiccSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEuiccSupported", $$robo$$com_android_internal_telephony_uicc_AnswerToReset$isEuiccSupported(), 0, this);
    }

    public boolean isExtendedApduSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isExtendedApduSupported", $$robo$$com_android_internal_telephony_uicc_AnswerToReset$isExtendedApduSupported(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_uicc_AnswerToReset$toString(), 0, this);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_uicc_AnswerToReset$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnswerToReset)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class InterfaceByte
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Byte mTA;
        private Byte mTB;
        private Byte mTC;
        private Byte mTD;

        private final Byte $$robo$$com_android_internal_telephony_uicc_AnswerToReset_InterfaceByte$getTA() {
            return this.mTA;
        }

        private final Byte $$robo$$com_android_internal_telephony_uicc_AnswerToReset_InterfaceByte$getTB() {
            return this.mTB;
        }

        private final Byte $$robo$$com_android_internal_telephony_uicc_AnswerToReset_InterfaceByte$getTC() {
            return this.mTC;
        }

        private final Byte $$robo$$com_android_internal_telephony_uicc_AnswerToReset_InterfaceByte$getTD() {
            return this.mTD;
        }

        private final void $$robo$$com_android_internal_telephony_uicc_AnswerToReset_InterfaceByte$setTA(Byte tA) {
            this.mTA = tA;
        }

        private final void $$robo$$com_android_internal_telephony_uicc_AnswerToReset_InterfaceByte$setTB(Byte tB) {
            this.mTB = tB;
        }

        private final void $$robo$$com_android_internal_telephony_uicc_AnswerToReset_InterfaceByte$setTC(Byte tC) {
            this.mTC = tC;
        }

        private final void $$robo$$com_android_internal_telephony_uicc_AnswerToReset_InterfaceByte$setTD(Byte tD) {
            this.mTD = tD;
        }

        private void $$robo$$com_android_internal_telephony_uicc_AnswerToReset_InterfaceByte$__constructor__() {
            this.mTA = null;
            this.mTB = null;
            this.mTC = null;
            this.mTD = null;
        }

        @VisibleForTesting
        private void $$robo$$com_android_internal_telephony_uicc_AnswerToReset_InterfaceByte$__constructor__(Byte tA, Byte tB, Byte tC, Byte tD) {
            this.mTA = tA;
            this.mTB = tB;
            this.mTC = tC;
            this.mTD = tD;
        }

        private final boolean $$robo$$com_android_internal_telephony_uicc_AnswerToReset_InterfaceByte$equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InterfaceByte ib = (InterfaceByte)o;
            return Objects.equals(this.mTA, ib.getTA()) && Objects.equals(this.mTB, ib.getTB()) && Objects.equals(this.mTC, ib.getTC()) && Objects.equals(this.mTD, ib.getTD());
        }

        private final int $$robo$$com_android_internal_telephony_uicc_AnswerToReset_InterfaceByte$hashCode() {
            return Objects.hash(this.mTA, this.mTB, this.mTC, this.mTD);
        }

        private final String $$robo$$com_android_internal_telephony_uicc_AnswerToReset_InterfaceByte$toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("{");
            sb.append("TA=").append(AnswerToReset.byteToStringHex(this.mTA)).append(",");
            sb.append("TB=").append(AnswerToReset.byteToStringHex(this.mTB)).append(",");
            sb.append("TC=").append(AnswerToReset.byteToStringHex(this.mTC)).append(",");
            sb.append("TD=").append(AnswerToReset.byteToStringHex(this.mTD));
            sb.append("}");
            return sb.toString();
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_uicc_AnswerToReset_InterfaceByte$__constructor__(1 x0) {
        }

        public Byte getTA() {
            return InvokeDynamicSupport.bootstrap("getTA", $$robo$$com_android_internal_telephony_uicc_AnswerToReset_InterfaceByte$getTA(), 0, this);
        }

        public Byte getTB() {
            return InvokeDynamicSupport.bootstrap("getTB", $$robo$$com_android_internal_telephony_uicc_AnswerToReset_InterfaceByte$getTB(), 0, this);
        }

        public Byte getTC() {
            return InvokeDynamicSupport.bootstrap("getTC", $$robo$$com_android_internal_telephony_uicc_AnswerToReset_InterfaceByte$getTC(), 0, this);
        }

        public Byte getTD() {
            return InvokeDynamicSupport.bootstrap("getTD", $$robo$$com_android_internal_telephony_uicc_AnswerToReset_InterfaceByte$getTD(), 0, this);
        }

        public void setTA(Byte by) {
            InvokeDynamicSupport.bootstrap("setTA", $$robo$$com_android_internal_telephony_uicc_AnswerToReset_InterfaceByte$setTA(java.lang.Byte ), 0, this, by);
        }

        public void setTB(Byte by) {
            InvokeDynamicSupport.bootstrap("setTB", $$robo$$com_android_internal_telephony_uicc_AnswerToReset_InterfaceByte$setTB(java.lang.Byte ), 0, this, by);
        }

        public void setTC(Byte by) {
            InvokeDynamicSupport.bootstrap("setTC", $$robo$$com_android_internal_telephony_uicc_AnswerToReset_InterfaceByte$setTC(java.lang.Byte ), 0, this, by);
        }

        public void setTD(Byte by) {
            InvokeDynamicSupport.bootstrap("setTD", $$robo$$com_android_internal_telephony_uicc_AnswerToReset_InterfaceByte$setTD(java.lang.Byte ), 0, this, by);
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_telephony_uicc_AnswerToReset_InterfaceByte$__constructor__();
        }

        private InterfaceByte() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_AnswerToReset_InterfaceByte$__constructor__(), 0, this);
        }

        private void __constructor__(Byte by, Byte by2, Byte by3, Byte by4) {
            this.$$robo$$com_android_internal_telephony_uicc_AnswerToReset_InterfaceByte$__constructor__(by, by2, by3, by4);
        }

        public InterfaceByte(Byte by, Byte by2, Byte by3, Byte by4) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_AnswerToReset_InterfaceByte$__constructor__(java.lang.Byte java.lang.Byte java.lang.Byte java.lang.Byte ), 0, this, by, by2, by3, by4);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$com_android_internal_telephony_uicc_AnswerToReset_InterfaceByte$equals(java.lang.Object ), 0, this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$com_android_internal_telephony_uicc_AnswerToReset_InterfaceByte$hashCode(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_uicc_AnswerToReset_InterfaceByte$toString(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$com_android_internal_telephony_uicc_AnswerToReset_InterfaceByte$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InterfaceByte)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class HistoricalBytes
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int TAG_MASK = 240;
        private static int LENGTH_MASK = 15;
        private byte[] mRawData;
        private ArrayMap<Integer, byte[]> mNodes;
        private byte mCategory;

        private final byte $$robo$$com_android_internal_telephony_uicc_AnswerToReset_HistoricalBytes$getCategory() {
            return this.mCategory;
        }

        private final byte[] $$robo$$com_android_internal_telephony_uicc_AnswerToReset_HistoricalBytes$getRawData() {
            return this.mRawData;
        }

        private final byte[] $$robo$$com_android_internal_telephony_uicc_AnswerToReset_HistoricalBytes$getValue(int tag) {
            return this.mNodes.get(tag);
        }

        private static final HistoricalBytes $$robo$$com_android_internal_telephony_uicc_AnswerToReset_HistoricalBytes$parseHistoricalBytes(byte[] originalData, int startIndex, int length) {
            if (length <= 0 || startIndex + length > originalData.length) {
                return null;
            }
            ArrayMap<Integer, byte[]> nodes = new ArrayMap<Integer, byte[]>();
            int index = startIndex + 1;
            while (index < startIndex + length && index > 0) {
                index = HistoricalBytes.parseLtvNode(index, nodes, originalData, startIndex + length - 1);
            }
            if (index < 0) {
                return null;
            }
            byte[] rawData = new byte[length];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])originalData, (int)startIndex, (byte[])rawData, (int)0, (int)length);
            return new HistoricalBytes(rawData, nodes, rawData[0]);
        }

        private void $$robo$$com_android_internal_telephony_uicc_AnswerToReset_HistoricalBytes$__constructor__(byte[] rawData, ArrayMap<Integer, byte[]> nodes, byte category) {
            this.mRawData = rawData;
            this.mNodes = nodes;
            this.mCategory = category;
        }

        private static final int $$robo$$com_android_internal_telephony_uicc_AnswerToReset_HistoricalBytes$parseLtvNode(int index, ArrayMap<Integer, byte[]> nodes, byte[] data, int lastByteIndex) {
            int length;
            if (index > lastByteIndex) {
                return -1;
            }
            int tag = (data[index] & 0xF0) >> 4;
            if (index + (length = data[index++] & 0xF) > lastByteIndex + 1 || length == 0) {
                return -1;
            }
            byte[] value = new byte[length];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])data, (int)index, (byte[])value, (int)0, (int)length);
            nodes.put(tag, value);
            return index + length;
        }

        public byte getCategory() {
            return (byte)InvokeDynamicSupport.bootstrap("getCategory", $$robo$$com_android_internal_telephony_uicc_AnswerToReset_HistoricalBytes$getCategory(), 0, this);
        }

        public byte[] getRawData() {
            return InvokeDynamicSupport.bootstrap("getRawData", $$robo$$com_android_internal_telephony_uicc_AnswerToReset_HistoricalBytes$getRawData(), 0, this);
        }

        public byte[] getValue(int n) {
            return InvokeDynamicSupport.bootstrap("getValue", $$robo$$com_android_internal_telephony_uicc_AnswerToReset_HistoricalBytes$getValue(int ), 0, this, n);
        }

        private static HistoricalBytes parseHistoricalBytes(byte[] byArray, int n, int n2) {
            return InvokeDynamicSupport.bootstrapStatic("parseHistoricalBytes", $$robo$$com_android_internal_telephony_uicc_AnswerToReset_HistoricalBytes$parseHistoricalBytes(byte[] int int ), 0, (byte[])byArray, (int)n, (int)n2);
        }

        private void __constructor__(byte[] byArray, ArrayMap<Integer, byte[]> arrayMap, byte by) {
            this.$$robo$$com_android_internal_telephony_uicc_AnswerToReset_HistoricalBytes$__constructor__(byArray, arrayMap, by);
        }

        private HistoricalBytes(byte[] byArray, ArrayMap<Integer, byte[]> arrayMap, byte by) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_AnswerToReset_HistoricalBytes$__constructor__(byte[] android.util.ArrayMap<java.lang.Integer, byte[]> byte ), 0, this, byArray, arrayMap, by);
        }

        private static int parseLtvNode(int n, ArrayMap<Integer, byte[]> arrayMap, byte[] byArray, int n2) {
            return (int)InvokeDynamicSupport.bootstrapStatic("parseLtvNode", $$robo$$com_android_internal_telephony_uicc_AnswerToReset_HistoricalBytes$parseLtvNode(int android.util.ArrayMap<java.lang.Integer, byte[]> byte[] int ), 0, (int)n, arrayMap, (byte[])byArray, (int)n2);
        }

        public /* synthetic */ HistoricalBytes() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HistoricalBytes)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

