/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.app.AlarmManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.net.Uri;
import android.os.SystemClock;
import android.provider.Settings;
import android.service.notification.StatusBarNotification;
import android.text.TextUtils;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.uicc.CarrierAppInstallReceiver;
import com.android.internal.telephony.uicc.ShowInstallAppNotificationReceiver;
import java.util.Arrays;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@VisibleForTesting
public class InstallCarrierAppUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int ACTIVATE_CELL_SERVICE_NOTIFICATION_ID = 12;
    private static CarrierAppInstallReceiver sCarrierAppInstallReceiver;

    private void $$robo$$com_android_internal_telephony_uicc_InstallCarrierAppUtils$__constructor__() {
    }

    private static final void $$robo$$com_android_internal_telephony_uicc_InstallCarrierAppUtils$showNotification(Context context, String pkgName) {
        Resources res = Resources.getSystem();
        String title = res.getString(17040034);
        String appName = InstallCarrierAppUtils.getAppNameFromPackageName(context, pkgName);
        String message = TextUtils.isEmpty(appName) ? res.getString(17040032) : res.getString(17040033, appName);
        String downloadButtonText = res.getString(17040031);
        boolean persistent = Settings.Global.getInt(context.getContentResolver(), "install_carrier_app_notification_persistent", 1) == 1;
        PendingIntent goToStore = PendingIntent.getActivity(context, 0, InstallCarrierAppUtils.getPlayStoreIntent(pkgName), 0x8000000);
        Notification.Action goToStoreAction = new Notification.Action.Builder(null, (CharSequence)downloadButtonText, goToStore).build();
        Notification notification = new Notification.Builder(context, "sim").setContentTitle(title).setContentText(message).setSmallIcon(17302740).addAction(goToStoreAction).setOngoing(persistent).setVisibility(-1).build();
        InstallCarrierAppUtils.getNotificationManager(context).notify(pkgName, 12, notification);
    }

    private static final void $$robo$$com_android_internal_telephony_uicc_InstallCarrierAppUtils$hideAllNotifications(Context context) {
        NotificationManager notificationManager = InstallCarrierAppUtils.getNotificationManager(context);
        StatusBarNotification[] activeNotifications = notificationManager.getActiveNotifications();
        if (activeNotifications == null) {
            return;
        }
        for (StatusBarNotification notification : activeNotifications) {
            if (notification.getId() != 12) continue;
            notificationManager.cancel(notification.getTag(), notification.getId());
        }
    }

    private static final void $$robo$$com_android_internal_telephony_uicc_InstallCarrierAppUtils$hideNotification(Context context, String pkgName) {
        InstallCarrierAppUtils.getNotificationManager(context).cancel(pkgName, 12);
    }

    private static final Intent $$robo$$com_android_internal_telephony_uicc_InstallCarrierAppUtils$getPlayStoreIntent(String pkgName) {
        Intent storeIntent = new Intent("android.intent.action.VIEW");
        storeIntent.setData(Uri.parse("market://details?id=" + pkgName));
        storeIntent.addFlags(0x10000000);
        return storeIntent;
    }

    private static final void $$robo$$com_android_internal_telephony_uicc_InstallCarrierAppUtils$showNotificationIfNotInstalledDelayed(Context context, String pkgName, long delayMillis) {
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        PendingIntent pendingIntent = PendingIntent.getBroadcast(context, 0, ShowInstallAppNotificationReceiver.get(context, pkgName), 0);
        alarmManager.set(3, SystemClock.elapsedRealtime() + delayMillis, pendingIntent);
    }

    private static final void $$robo$$com_android_internal_telephony_uicc_InstallCarrierAppUtils$registerPackageInstallReceiver(Context context) {
        if (sCarrierAppInstallReceiver == null) {
            sCarrierAppInstallReceiver = new CarrierAppInstallReceiver();
            context = context.getApplicationContext();
            IntentFilter intentFilter = new IntentFilter("android.intent.action.PACKAGE_ADDED");
            intentFilter.addDataScheme("package");
            context.registerReceiver(sCarrierAppInstallReceiver, intentFilter);
        }
    }

    private static final void $$robo$$com_android_internal_telephony_uicc_InstallCarrierAppUtils$unregisterPackageInstallReceiver(Context context) {
        if (sCarrierAppInstallReceiver == null) {
            return;
        }
        context = context.getApplicationContext();
        context.unregisterReceiver(sCarrierAppInstallReceiver);
        sCarrierAppInstallReceiver = null;
    }

    private static final boolean $$robo$$com_android_internal_telephony_uicc_InstallCarrierAppUtils$isPackageInstallNotificationActive(Context context) {
        StatusBarNotification[] activeNotifications;
        for (StatusBarNotification notification : activeNotifications = InstallCarrierAppUtils.getNotificationManager(context).getActiveNotifications()) {
            if (notification.getId() != 12) continue;
            return true;
        }
        return false;
    }

    private static final String $$robo$$com_android_internal_telephony_uicc_InstallCarrierAppUtils$getAppNameFromPackageName(Context context, String packageName) {
        String whitelistSetting = Settings.Global.getString(context.getContentResolver(), "carrier_app_names");
        return InstallCarrierAppUtils.getAppNameFromPackageName(packageName, whitelistSetting);
    }

    @VisibleForTesting
    private static final String $$robo$$com_android_internal_telephony_uicc_InstallCarrierAppUtils$getAppNameFromPackageName(String packageName, String mapString) {
        packageName = packageName.toLowerCase();
        String pairDelim = "\\s*;\\s*";
        String keyValueDelim = "\\s*:\\s*";
        if (TextUtils.isEmpty(mapString)) {
            return null;
        }
        List<String> keyValuePairList = Arrays.asList(mapString.split("\\s*;\\s*"));
        if (keyValuePairList.isEmpty()) {
            return null;
        }
        for (String keyValueString : keyValuePairList) {
            String[] keyValue = keyValueString.split("\\s*:\\s*");
            if (keyValue.length != 2 || !keyValue[0].equals(packageName)) continue;
            return keyValue[1];
        }
        return null;
    }

    private static final NotificationManager $$robo$$com_android_internal_telephony_uicc_InstallCarrierAppUtils$getNotificationManager(Context context) {
        return (NotificationManager)context.getSystemService("notification");
    }

    static void __staticInitializer__() {
        sCarrierAppInstallReceiver = null;
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_uicc_InstallCarrierAppUtils$__constructor__();
    }

    public InstallCarrierAppUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_InstallCarrierAppUtils$__constructor__(), 0, this);
    }

    static void showNotification(Context context, String string2) {
        InvokeDynamicSupport.bootstrapStatic("showNotification", $$robo$$com_android_internal_telephony_uicc_InstallCarrierAppUtils$showNotification(android.content.Context java.lang.String ), 0, (Context)context, (String)string2);
    }

    static void hideAllNotifications(Context context) {
        InvokeDynamicSupport.bootstrapStatic("hideAllNotifications", $$robo$$com_android_internal_telephony_uicc_InstallCarrierAppUtils$hideAllNotifications(android.content.Context ), 0, (Context)context);
    }

    static void hideNotification(Context context, String string2) {
        InvokeDynamicSupport.bootstrapStatic("hideNotification", $$robo$$com_android_internal_telephony_uicc_InstallCarrierAppUtils$hideNotification(android.content.Context java.lang.String ), 0, (Context)context, (String)string2);
    }

    static Intent getPlayStoreIntent(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getPlayStoreIntent", $$robo$$com_android_internal_telephony_uicc_InstallCarrierAppUtils$getPlayStoreIntent(java.lang.String ), 0, (String)string2);
    }

    static void showNotificationIfNotInstalledDelayed(Context context, String string2, long l) {
        InvokeDynamicSupport.bootstrapStatic("showNotificationIfNotInstalledDelayed", $$robo$$com_android_internal_telephony_uicc_InstallCarrierAppUtils$showNotificationIfNotInstalledDelayed(android.content.Context java.lang.String long ), 0, (Context)context, (String)string2, (long)l);
    }

    static void registerPackageInstallReceiver(Context context) {
        InvokeDynamicSupport.bootstrapStatic("registerPackageInstallReceiver", $$robo$$com_android_internal_telephony_uicc_InstallCarrierAppUtils$registerPackageInstallReceiver(android.content.Context ), 0, (Context)context);
    }

    static void unregisterPackageInstallReceiver(Context context) {
        InvokeDynamicSupport.bootstrapStatic("unregisterPackageInstallReceiver", $$robo$$com_android_internal_telephony_uicc_InstallCarrierAppUtils$unregisterPackageInstallReceiver(android.content.Context ), 0, (Context)context);
    }

    static boolean isPackageInstallNotificationActive(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPackageInstallNotificationActive", $$robo$$com_android_internal_telephony_uicc_InstallCarrierAppUtils$isPackageInstallNotificationActive(android.content.Context ), 0, (Context)context);
    }

    static String getAppNameFromPackageName(Context context, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getAppNameFromPackageName", $$robo$$com_android_internal_telephony_uicc_InstallCarrierAppUtils$getAppNameFromPackageName(android.content.Context java.lang.String ), 0, (Context)context, (String)string2);
    }

    public static String getAppNameFromPackageName(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getAppNameFromPackageName", $$robo$$com_android_internal_telephony_uicc_InstallCarrierAppUtils$getAppNameFromPackageName(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    private static NotificationManager getNotificationManager(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getNotificationManager", $$robo$$com_android_internal_telephony_uicc_InstallCarrierAppUtils$getNotificationManager(android.content.Context ), 0, (Context)context);
    }

    static {
        RobolectricInternals.classInitializing(InstallCarrierAppUtils.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InstallCarrierAppUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

