/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.Rlog;
import com.android.internal.telephony.uicc.IccUtils;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PlmnActRecord
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "PlmnActRecord";
    public static int ACCESS_TECH_UTRAN = 32768;
    public static int ACCESS_TECH_EUTRAN = 16384;
    public static int ACCESS_TECH_GSM = 128;
    public static int ACCESS_TECH_GSM_COMPACT = 64;
    public static int ACCESS_TECH_CDMA2000_HRPD = 32;
    public static int ACCESS_TECH_CDMA2000_1XRTT = 16;
    public static int ACCESS_TECH_RESERVED = 16143;
    public static int ENCODED_LENGTH = 5;
    public String plmn;
    public int accessTechs;
    private static boolean VDBG = false;
    public static Parcelable.Creator<PlmnActRecord> CREATOR;

    private void $$robo$$com_android_internal_telephony_uicc_PlmnActRecord$__constructor__(byte[] bytes, int offset) {
        this.plmn = IccUtils.bcdPlmnToString(bytes, offset);
        this.accessTechs = Byte.toUnsignedInt(bytes[offset + 3]) << 8 | Byte.toUnsignedInt(bytes[offset + 4]);
    }

    private void $$robo$$com_android_internal_telephony_uicc_PlmnActRecord$__constructor__(String plmn, int accessTechs) {
        this.plmn = plmn;
        this.accessTechs = accessTechs;
    }

    private final String $$robo$$com_android_internal_telephony_uicc_PlmnActRecord$accessTechString() {
        if (this.accessTechs == 0) {
            return "NONE";
        }
        StringBuilder sb = new StringBuilder();
        if ((this.accessTechs & 0x8000) != 0) {
            sb.append("UTRAN|");
        }
        if ((this.accessTechs & 0x4000) != 0) {
            sb.append("EUTRAN|");
        }
        if ((this.accessTechs & 0x80) != 0) {
            sb.append("GSM|");
        }
        if ((this.accessTechs & 0x40) != 0) {
            sb.append("GSM_COMPACT|");
        }
        if ((this.accessTechs & 0x20) != 0) {
            sb.append("CDMA2000_HRPD|");
        }
        if ((this.accessTechs & 0x10) != 0) {
            sb.append("CDMA2000_1XRTT|");
        }
        if ((this.accessTechs & 0x3F0F) != 0) {
            sb.append(String.format("UNKNOWN:%x|", this.accessTechs & 0x3F0F));
        }
        return sb.substring(0, sb.length() - 1);
    }

    private final String $$robo$$com_android_internal_telephony_uicc_PlmnActRecord$toString() {
        return String.format("{PLMN=%s,AccessTechs=%s}", this.plmn, this.accessTechString());
    }

    private static final PlmnActRecord[] $$robo$$com_android_internal_telephony_uicc_PlmnActRecord$getRecords(byte[] recordBytes) {
        if (recordBytes == null || recordBytes.length == 0 || recordBytes.length % 5 != 0) {
            Rlog.e("PlmnActRecord", "Malformed PlmnActRecord, bytes: " + (recordBytes != null ? Arrays.toString(recordBytes) : null));
            return null;
        }
        int numRecords = recordBytes.length / 5;
        PlmnActRecord[] records = new PlmnActRecord[numRecords];
        for (int i = 0; i < numRecords; ++i) {
            records[i] = new PlmnActRecord(recordBytes, i * 5);
        }
        return records;
    }

    private final int $$robo$$com_android_internal_telephony_uicc_PlmnActRecord$describeContents() {
        return 0;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_PlmnActRecord$writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.plmn);
        dest.writeInt(this.accessTechs);
    }

    private /* synthetic */ void $$robo$$com_android_internal_telephony_uicc_PlmnActRecord$__constructor__(String x0, int x1, 1 x2) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<PlmnActRecord>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$com_android_internal_telephony_uicc_PlmnActRecord_1$__constructor__() {
            }

            private final PlmnActRecord $$robo$$com_android_internal_telephony_uicc_PlmnActRecord_1$createFromParcel(Parcel source) {
                return new PlmnActRecord(source.readString(), source.readInt());
            }

            private final PlmnActRecord[] $$robo$$com_android_internal_telephony_uicc_PlmnActRecord_1$newArray(int size) {
                return new PlmnActRecord[size];
            }

            private void __constructor__() {
                this.$$robo$$com_android_internal_telephony_uicc_PlmnActRecord_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_PlmnActRecord_1$__constructor__(), 0, this);
            }

            @Override
            public PlmnActRecord createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$com_android_internal_telephony_uicc_PlmnActRecord_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public PlmnActRecord[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$com_android_internal_telephony_uicc_PlmnActRecord_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(byte[] byArray, int n) {
        this.$$robo$$com_android_internal_telephony_uicc_PlmnActRecord$__constructor__(byArray, n);
    }

    public PlmnActRecord(byte[] byArray, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_PlmnActRecord$__constructor__(byte[] int ), 0, this, byArray, n);
    }

    private void __constructor__(String string2, int n) {
        this.$$robo$$com_android_internal_telephony_uicc_PlmnActRecord$__constructor__(string2, n);
    }

    private PlmnActRecord(String string2, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_PlmnActRecord$__constructor__(java.lang.String int ), 0, this, string2, n);
    }

    private String accessTechString() {
        return InvokeDynamicSupport.bootstrap("accessTechString", $$robo$$com_android_internal_telephony_uicc_PlmnActRecord$accessTechString(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_uicc_PlmnActRecord$toString(), 0, this);
    }

    public static PlmnActRecord[] getRecords(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("getRecords", $$robo$$com_android_internal_telephony_uicc_PlmnActRecord$getRecords(byte[] ), 0, (byte[])byArray);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$com_android_internal_telephony_uicc_PlmnActRecord$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$com_android_internal_telephony_uicc_PlmnActRecord$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private /* synthetic */ void __constructor__(String string2, int n, 1 var3_3) {
        this.$$robo$$com_android_internal_telephony_uicc_PlmnActRecord$__constructor__(string2, n, var3_3);
    }

    static {
        RobolectricInternals.classInitializing(PlmnActRecord.class);
    }

    public /* synthetic */ PlmnActRecord() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PlmnActRecord)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

