/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.content.Context;
import android.content.res.Resources;
import android.os.AsyncResult;
import android.os.Message;
import android.os.SystemProperties;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.uicc.AdnRecordCache;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccException;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.android.internal.util.BitwiseInputStream;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RuimRecords
extends IccRecords
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String LOG_TAG = "RuimRecords";
    private boolean mOtaCommited;
    private String mMyMobileNumber;
    private String mMin2Min1;
    private String mPrlVersion;
    private byte[] mEFpl;
    private byte[] mEFli;
    boolean mCsimSpnDisplayCondition;
    private String mMdn;
    private String mMin;
    private String mHomeSystemId;
    private String mHomeNetworkId;
    private String mNai;
    private static int EVENT_GET_IMSI_DONE = 3;
    private static int EVENT_GET_DEVICE_IDENTITY_DONE = 4;
    private static int EVENT_GET_ICCID_DONE = 5;
    private static int EVENT_GET_CDMA_SUBSCRIPTION_DONE = 10;
    private static int EVENT_UPDATE_DONE = 14;
    private static int EVENT_GET_SST_DONE = 17;
    private static int EVENT_GET_ALL_SMS_DONE = 18;
    private static int EVENT_MARK_SMS_READ_DONE = 19;
    private static int EVENT_SMS_ON_RUIM = 21;
    private static int EVENT_GET_SMS_DONE = 22;
    private static int EVENT_APP_LOCKED = 32;
    private static int EVENT_APP_NETWORK_LOCKED = 33;

    private final String $$robo$$com_android_internal_telephony_uicc_RuimRecords$toString() {
        return "RuimRecords: " + super.toString() + " m_ota_commited" + this.mOtaCommited + " mMyMobileNumber=xxxx mMin2Min1=" + this.mMin2Min1 + " mPrlVersion=" + this.mPrlVersion + " mEFpl=" + this.mEFpl + " mEFli=" + this.mEFli + " mCsimSpnDisplayCondition=" + this.mCsimSpnDisplayCondition + " mMdn=" + this.mMdn + " mMin=" + this.mMin + " mHomeSystemId=" + this.mHomeSystemId + " mHomeNetworkId=" + this.mHomeNetworkId;
    }

    private void $$robo$$com_android_internal_telephony_uicc_RuimRecords$__constructor__(UiccCardApplication app, Context c, CommandsInterface ci) {
        this.mOtaCommited = false;
        this.mEFpl = null;
        this.mEFli = null;
        this.mCsimSpnDisplayCondition = false;
        this.mAdnCache = new AdnRecordCache(this.mFh);
        this.mRecordsRequested = false;
        this.mLockedRecordsReqReason = 0;
        this.mRecordsToLoad = 0;
        this.resetRecords();
        this.mParentApp.registerForReady(this, 1, null);
        this.mParentApp.registerForLocked(this, 32, null);
        this.mParentApp.registerForNetworkLocked(this, 33, null);
        this.log("RuimRecords X ctor this=" + this);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords$dispose() {
        this.log("Disposing RuimRecords " + this);
        this.mParentApp.unregisterForReady(this);
        this.mParentApp.unregisterForLocked(this);
        this.mParentApp.unregisterForNetworkLocked(this);
        this.resetRecords();
        super.dispose();
    }

    private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords$finalize() {
        this.log("RuimRecords finalized");
    }

    private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords$resetRecords() {
        this.mMncLength = -1;
        this.log("setting0 mMncLength" + this.mMncLength);
        this.mIccId = null;
        this.mFullIccId = null;
        this.mAdnCache.reset();
        this.mRecordsRequested = false;
        this.mLockedRecordsReqReason = 0;
        this.mLoaded.set(false);
    }

    private final String $$robo$$com_android_internal_telephony_uicc_RuimRecords$getMdnNumber() {
        return this.mMyMobileNumber;
    }

    private final String $$robo$$com_android_internal_telephony_uicc_RuimRecords$getCdmaMin() {
        return this.mMin2Min1;
    }

    private final String $$robo$$com_android_internal_telephony_uicc_RuimRecords$getPrlVersion() {
        return this.mPrlVersion;
    }

    private final String $$robo$$com_android_internal_telephony_uicc_RuimRecords$getNAI() {
        return this.mNai;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords$setVoiceMailNumber(String alphaTag, String voiceNumber, Message onComplete) {
        AsyncResult.forMessage((Message)onComplete).exception = new IccException("setVoiceMailNumber not implemented");
        onComplete.sendToTarget();
        this.loge("method setVoiceMailNumber is not implemented");
    }

    private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords$onRefresh(boolean fileChanged, int[] fileList) {
        if (fileChanged) {
            this.fetchRuimRecords();
        }
    }

    private final int $$robo$$com_android_internal_telephony_uicc_RuimRecords$adjstMinDigits(int digits) {
        digits = (digits += 111) % 10 == 0 ? digits - 10 : digits;
        digits = digits / 10 % 10 == 0 ? digits - 100 : digits;
        digits = digits / 100 % 10 == 0 ? digits - 1000 : digits;
        return digits;
    }

    private final String $$robo$$com_android_internal_telephony_uicc_RuimRecords$getRUIMOperatorNumeric() {
        String imsi = this.getIMSI();
        if (imsi == null) {
            return null;
        }
        if (this.mMncLength != -1 && this.mMncLength != 0) {
            return imsi.substring(0, 3 + this.mMncLength);
        }
        int mcc = Integer.parseInt(imsi.substring(0, 3));
        return imsi.substring(0, 3 + MccTable.smallestDigitsMccForMnc(mcc));
    }

    private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords$onGetCSimEprlDone(AsyncResult ar) {
        byte[] data = (byte[])ar.result;
        this.log("CSIM_EPRL=" + IccUtils.bytesToHexString(data));
        if (data.length > 3) {
            int prlId = (data[2] & 0xFF) << 8 | data[3] & 0xFF;
            this.mPrlVersion = Integer.toString(prlId);
        }
        this.log("CSIM PRL version=" + this.mPrlVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords$handleMessage(Message msg) {
        boolean isRecordLoadResponse = false;
        if (this.mDestroyed.get()) {
            this.loge("Received message " + msg + "[" + msg.what + "] while being destroyed. Ignoring.");
            return;
        }
        try {
            switch (msg.what) {
                case 1: {
                    this.onReady();
                    return;
                }
                case 32: 
                case 33: {
                    this.onLocked(msg.what);
                    return;
                }
                case 4: {
                    this.log("Event EVENT_GET_DEVICE_IDENTITY_DONE Received");
                    return;
                }
                case 3: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        this.loge("Exception querying IMSI, Exception:" + ar.exception);
                        return;
                    } else {
                        this.mImsi = (String)ar.result;
                        if (this.mImsi != null && (this.mImsi.length() < 6 || this.mImsi.length() > 15)) {
                            this.loge("invalid IMSI " + this.mImsi);
                            this.mImsi = null;
                        }
                        String operatorNumeric = this.getRUIMOperatorNumeric();
                        this.log("NO update mccmnc=" + operatorNumeric);
                        return;
                    }
                }
                case 10: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    String[] localTemp = (String[])ar.result;
                    if (ar.exception != null) {
                        return;
                    } else {
                        this.mMyMobileNumber = localTemp[0];
                        this.mMin2Min1 = localTemp[3];
                        this.mPrlVersion = localTemp[4];
                        this.log("MDN: " + this.mMyMobileNumber + " MIN: " + this.mMin2Min1);
                        return;
                    }
                }
                case 5: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception != null) {
                        return;
                    } else {
                        this.mIccId = IccUtils.bcdToString(data, 0, data.length);
                        this.mFullIccId = IccUtils.bchToString(data, 0, data.length);
                        this.log("iccid: " + SubscriptionInfo.givePrintableIccid(this.mFullIccId));
                        return;
                    }
                }
                case 14: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception == null) return;
                    Rlog.i("RuimRecords", "RuimRecords update failed", ar.exception);
                    return;
                }
                case 18: 
                case 19: 
                case 21: 
                case 22: {
                    Rlog.w("RuimRecords", "Event not supported: " + msg.what);
                    return;
                }
                case 17: {
                    this.log("Event EVENT_GET_SST_DONE Received");
                    return;
                }
                default: {
                    super.handleMessage(msg);
                    return;
                }
            }
        }
        catch (RuntimeException exc) {
            Rlog.w("RuimRecords", "Exception parsing RUIM record", exc);
            return;
        }
        finally {
            if (isRecordLoadResponse) {
                this.onRecordLoaded();
            }
        }
    }

    private static final String[] $$robo$$com_android_internal_telephony_uicc_RuimRecords$getAssetLanguages(Context ctx) {
        String[] locales = ctx.getAssets().getLocales();
        String[] localeLangs = new String[locales.length];
        for (int i = 0; i < locales.length; ++i) {
            String localeStr = locales[i];
            int separator = localeStr.indexOf(45);
            localeLangs[i] = separator < 0 ? localeStr : localeStr.substring(0, separator);
        }
        return localeLangs;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords$onRecordLoaded() {
        --this.mRecordsToLoad;
        this.log("onRecordLoaded " + this.mRecordsToLoad + " requested: " + this.mRecordsRequested);
        if (this.getRecordsLoaded()) {
            this.onAllRecordsLoaded();
        } else if (this.getLockedRecordsLoaded() || this.getNetworkLockedRecordsLoaded()) {
            this.onLockedAllRecordsLoaded();
        } else if (this.mRecordsToLoad < 0) {
            this.loge("recordsToLoad <0, programmer error suspected");
            this.mRecordsToLoad = 0;
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords$onLockedAllRecordsLoaded() {
        if (this.mLockedRecordsReqReason == 1) {
            this.mLockedRecordsLoadedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        } else if (this.mLockedRecordsReqReason == 2) {
            this.mNetworkLockedRecordsLoadedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        } else {
            this.loge("onLockedAllRecordsLoaded: unexpected mLockedRecordsReqReason " + this.mLockedRecordsReqReason);
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords$onAllRecordsLoaded() {
        this.log("record load complete");
        Resources resource = Resources.getSystem();
        if (resource.getBoolean(17957067)) {
            this.setSimLanguage(this.mEFli, this.mEFpl);
        }
        this.mLoaded.set(true);
        this.mRecordsLoadedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        if (!TextUtils.isEmpty(this.mMdn)) {
            int phoneId = this.mParentApp.getUiccProfile().getPhoneId();
            int subId = SubscriptionController.getInstance().getSubIdUsingPhoneId(phoneId);
            if (SubscriptionManager.isValidSubscriptionId(subId)) {
                SubscriptionManager.from(this.mContext).setDisplayNumber(this.mMdn, subId);
            } else {
                this.log("Cannot call setDisplayNumber: invalid subId");
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords$onReady() {
        this.fetchRuimRecords();
        this.mCi.getCDMASubscription(this.obtainMessage(10));
    }

    private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords$onLocked(int msg) {
        this.log("only fetch EF_ICCID in locked state");
        this.mLockedRecordsReqReason = msg == 32 ? 1 : 2;
        this.mFh.loadEFTransparent(12258, this.obtainMessage(5));
        ++this.mRecordsToLoad;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords$fetchRuimRecords() {
        this.mRecordsRequested = true;
        this.log("fetchRuimRecords " + this.mRecordsToLoad);
        this.mCi.getIMSIForApp(this.mParentApp.getAid(), this.obtainMessage(3));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(12258, this.obtainMessage(5));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(12037, this.obtainMessage(100, new EfPlLoaded(this)));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28474, this.obtainMessage(100, new EfCsimLiLoaded(this)));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28481, this.obtainMessage(100, new EfCsimSpnLoaded(this)));
        ++this.mRecordsToLoad;
        this.mFh.loadEFLinearFixed(28484, 1, this.obtainMessage(100, new EfCsimMdnLoaded(this)));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28450, this.obtainMessage(100, new EfCsimImsimLoaded(this)));
        ++this.mRecordsToLoad;
        this.mFh.loadEFLinearFixedAll(28456, this.obtainMessage(100, new EfCsimCdmaHomeLoaded(this)));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28506, 4, this.obtainMessage(100, new EfCsimEprlLoaded(this)));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28493, this.obtainMessage(100, new EfCsimMipUppLoaded(this)));
        ++this.mRecordsToLoad;
        this.log("fetchRuimRecords " + this.mRecordsToLoad + " requested: " + this.mRecordsRequested);
    }

    private final int $$robo$$com_android_internal_telephony_uicc_RuimRecords$getDisplayRule(ServiceState serviceState) {
        return 0;
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_RuimRecords$isProvisioned() {
        if (SystemProperties.getBoolean("persist.radio.test-csim", false)) {
            return true;
        }
        if (this.mParentApp == null) {
            return false;
        }
        return this.mParentApp.getType() != IccCardApplicationStatus.AppType.APPTYPE_CSIM || this.mMdn != null && this.mMin != null;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords$setVoiceMessageWaiting(int line, int countWaiting) {
        this.log("RuimRecords:setVoiceMessageWaiting - NOP for CDMA");
    }

    private final int $$robo$$com_android_internal_telephony_uicc_RuimRecords$getVoiceMessageCount() {
        this.log("RuimRecords:getVoiceMessageCount - NOP for CDMA");
        return 0;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords$handleFileUpdate(int efid) {
        this.mAdnCache.reset();
        this.fetchRuimRecords();
    }

    private final String $$robo$$com_android_internal_telephony_uicc_RuimRecords$getMdn() {
        return this.mMdn;
    }

    private final String $$robo$$com_android_internal_telephony_uicc_RuimRecords$getMin() {
        return this.mMin;
    }

    private final String $$robo$$com_android_internal_telephony_uicc_RuimRecords$getSid() {
        return this.mHomeSystemId;
    }

    private final String $$robo$$com_android_internal_telephony_uicc_RuimRecords$getNid() {
        return this.mHomeNetworkId;
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_RuimRecords$getCsimSpnDisplayCondition() {
        return this.mCsimSpnDisplayCondition;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords$log(String s) {
        Rlog.d("RuimRecords", "[RuimRecords] " + s);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords$loge(String s) {
        Rlog.e("RuimRecords", "[RuimRecords] " + s);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("RuimRecords: " + this);
        pw.println(" extends:");
        super.dump(fd, pw, args);
        pw.println(" mOtaCommited=" + this.mOtaCommited);
        pw.println(" mMyMobileNumber=" + this.mMyMobileNumber);
        pw.println(" mMin2Min1=" + this.mMin2Min1);
        pw.println(" mPrlVersion=" + this.mPrlVersion);
        pw.println(" mEFpl[]=" + Arrays.toString(this.mEFpl));
        pw.println(" mEFli[]=" + Arrays.toString(this.mEFli));
        pw.println(" mCsimSpnDisplayCondition=" + this.mCsimSpnDisplayCondition);
        pw.println(" mMdn=" + this.mMdn);
        pw.println(" mMin=" + this.mMin);
        pw.println(" mHomeSystemId=" + this.mHomeSystemId);
        pw.println(" mHomeNetworkId=" + this.mHomeNetworkId);
        pw.flush();
    }

    static /* synthetic */ byte[] access$002(RuimRecords x0, byte[] x1) {
        x0.mEFpl = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$102(RuimRecords x0, byte[] x1) {
        x0.mEFli = x1;
        return x1;
    }

    @Override
    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_uicc_RuimRecords$toString(), 0, this);
    }

    private void __constructor__(UiccCardApplication uiccCardApplication, Context context, CommandsInterface commandsInterface) {
        this.$$robo$$com_android_internal_telephony_uicc_RuimRecords$__constructor__(uiccCardApplication, context, commandsInterface);
    }

    public RuimRecords(UiccCardApplication uiccCardApplication, Context context, CommandsInterface commandsInterface) {
        super(uiccCardApplication, context, commandsInterface);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_RuimRecords$__constructor__(com.android.internal.telephony.uicc.UiccCardApplication android.content.Context com.android.internal.telephony.CommandsInterface ), 0, this, uiccCardApplication, context, commandsInterface);
    }

    @Override
    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_uicc_RuimRecords$dispose(), 0, this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$com_android_internal_telephony_uicc_RuimRecords$finalize(), 0, this);
    }

    protected void resetRecords() {
        InvokeDynamicSupport.bootstrap("resetRecords", $$robo$$com_android_internal_telephony_uicc_RuimRecords$resetRecords(), 0, this);
    }

    public String getMdnNumber() {
        return InvokeDynamicSupport.bootstrap("getMdnNumber", $$robo$$com_android_internal_telephony_uicc_RuimRecords$getMdnNumber(), 0, this);
    }

    public String getCdmaMin() {
        return InvokeDynamicSupport.bootstrap("getCdmaMin", $$robo$$com_android_internal_telephony_uicc_RuimRecords$getCdmaMin(), 0, this);
    }

    public String getPrlVersion() {
        return InvokeDynamicSupport.bootstrap("getPrlVersion", $$robo$$com_android_internal_telephony_uicc_RuimRecords$getPrlVersion(), 0, this);
    }

    @Override
    public String getNAI() {
        return InvokeDynamicSupport.bootstrap("getNAI", $$robo$$com_android_internal_telephony_uicc_RuimRecords$getNAI(), 0, this);
    }

    @Override
    public void setVoiceMailNumber(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("setVoiceMailNumber", $$robo$$com_android_internal_telephony_uicc_RuimRecords$setVoiceMailNumber(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    @Override
    public void onRefresh(boolean bl, int[] nArray) {
        InvokeDynamicSupport.bootstrap("onRefresh", $$robo$$com_android_internal_telephony_uicc_RuimRecords$onRefresh(boolean int[] ), 0, this, bl, nArray);
    }

    private int adjstMinDigits(int n) {
        return (int)InvokeDynamicSupport.bootstrap("adjstMinDigits", $$robo$$com_android_internal_telephony_uicc_RuimRecords$adjstMinDigits(int ), 0, this, n);
    }

    public String getRUIMOperatorNumeric() {
        return InvokeDynamicSupport.bootstrap("getRUIMOperatorNumeric", $$robo$$com_android_internal_telephony_uicc_RuimRecords$getRUIMOperatorNumeric(), 0, this);
    }

    private void onGetCSimEprlDone(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("onGetCSimEprlDone", $$robo$$com_android_internal_telephony_uicc_RuimRecords$onGetCSimEprlDone(android.os.AsyncResult ), 0, this, asyncResult);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_uicc_RuimRecords$handleMessage(android.os.Message ), 0, this, message);
    }

    private static String[] getAssetLanguages(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getAssetLanguages", $$robo$$com_android_internal_telephony_uicc_RuimRecords$getAssetLanguages(android.content.Context ), 0, (Context)context);
    }

    @Override
    protected void onRecordLoaded() {
        InvokeDynamicSupport.bootstrap("onRecordLoaded", $$robo$$com_android_internal_telephony_uicc_RuimRecords$onRecordLoaded(), 0, this);
    }

    private void onLockedAllRecordsLoaded() {
        InvokeDynamicSupport.bootstrap("onLockedAllRecordsLoaded", $$robo$$com_android_internal_telephony_uicc_RuimRecords$onLockedAllRecordsLoaded(), 0, this);
    }

    @Override
    protected void onAllRecordsLoaded() {
        InvokeDynamicSupport.bootstrap("onAllRecordsLoaded", $$robo$$com_android_internal_telephony_uicc_RuimRecords$onAllRecordsLoaded(), 0, this);
    }

    @Override
    public void onReady() {
        InvokeDynamicSupport.bootstrap("onReady", $$robo$$com_android_internal_telephony_uicc_RuimRecords$onReady(), 0, this);
    }

    private void onLocked(int n) {
        InvokeDynamicSupport.bootstrap("onLocked", $$robo$$com_android_internal_telephony_uicc_RuimRecords$onLocked(int ), 0, this, n);
    }

    private void fetchRuimRecords() {
        InvokeDynamicSupport.bootstrap("fetchRuimRecords", $$robo$$com_android_internal_telephony_uicc_RuimRecords$fetchRuimRecords(), 0, this);
    }

    @Override
    public int getDisplayRule(ServiceState serviceState) {
        return (int)InvokeDynamicSupport.bootstrap("getDisplayRule", $$robo$$com_android_internal_telephony_uicc_RuimRecords$getDisplayRule(android.telephony.ServiceState ), 0, this, serviceState);
    }

    @Override
    public boolean isProvisioned() {
        return (boolean)InvokeDynamicSupport.bootstrap("isProvisioned", $$robo$$com_android_internal_telephony_uicc_RuimRecords$isProvisioned(), 0, this);
    }

    @Override
    public void setVoiceMessageWaiting(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setVoiceMessageWaiting", $$robo$$com_android_internal_telephony_uicc_RuimRecords$setVoiceMessageWaiting(int int ), 0, this, n, n2);
    }

    @Override
    public int getVoiceMessageCount() {
        return (int)InvokeDynamicSupport.bootstrap("getVoiceMessageCount", $$robo$$com_android_internal_telephony_uicc_RuimRecords$getVoiceMessageCount(), 0, this);
    }

    @Override
    protected void handleFileUpdate(int n) {
        InvokeDynamicSupport.bootstrap("handleFileUpdate", $$robo$$com_android_internal_telephony_uicc_RuimRecords$handleFileUpdate(int ), 0, this, n);
    }

    public String getMdn() {
        return InvokeDynamicSupport.bootstrap("getMdn", $$robo$$com_android_internal_telephony_uicc_RuimRecords$getMdn(), 0, this);
    }

    public String getMin() {
        return InvokeDynamicSupport.bootstrap("getMin", $$robo$$com_android_internal_telephony_uicc_RuimRecords$getMin(), 0, this);
    }

    public String getSid() {
        return InvokeDynamicSupport.bootstrap("getSid", $$robo$$com_android_internal_telephony_uicc_RuimRecords$getSid(), 0, this);
    }

    public String getNid() {
        return InvokeDynamicSupport.bootstrap("getNid", $$robo$$com_android_internal_telephony_uicc_RuimRecords$getNid(), 0, this);
    }

    public boolean getCsimSpnDisplayCondition() {
        return (boolean)InvokeDynamicSupport.bootstrap("getCsimSpnDisplayCondition", $$robo$$com_android_internal_telephony_uicc_RuimRecords$getCsimSpnDisplayCondition(), 0, this);
    }

    @Override
    protected void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_uicc_RuimRecords$log(java.lang.String ), 0, this, string2);
    }

    @Override
    protected void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_uicc_RuimRecords$loge(java.lang.String ), 0, this, string2);
    }

    @Override
    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_uicc_RuimRecords$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    public /* synthetic */ RuimRecords() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RuimRecords)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class EfCsimMipUppLoaded
    implements IccRecords.IccRecordLoaded,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ RuimRecords this$0;

        private void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimMipUppLoaded$__constructor__(RuimRecords ruimRecords) {
        }

        private final String $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimMipUppLoaded$getEfName() {
            return "EF_CSIM_MIPUPP";
        }

        private final boolean $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimMipUppLoaded$checkLengthLegal(int length, int expectLength) {
            if (length < expectLength) {
                Log.e("RuimRecords", "CSIM MIPUPP format error, length = " + length + "expected length at least =" + expectLength);
                return false;
            }
            return true;
        }

        private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimMipUppLoaded$onRecordLoaded(AsyncResult ar) {
            byte[] data = (byte[])ar.result;
            if (data.length < 1) {
                Log.e("RuimRecords", "MIPUPP read error");
                return;
            }
            BitwiseInputStream bitStream = new BitwiseInputStream(data);
            try {
                int mipUppLength = bitStream.read(8);
                if (!this.checkLengthLegal(mipUppLength <<= 3, 1)) {
                    return;
                }
                int retryInfoInclude = bitStream.read(1);
                --mipUppLength;
                if (retryInfoInclude == 1) {
                    if (!this.checkLengthLegal(mipUppLength, 11)) {
                        return;
                    }
                    bitStream.skip(11);
                    mipUppLength -= 11;
                }
                if (!this.checkLengthLegal(mipUppLength, 4)) {
                    return;
                }
                int numNai = bitStream.read(4);
                mipUppLength -= 4;
                for (int index = 0; index < numNai; ++index) {
                    if (!this.checkLengthLegal(mipUppLength, 4)) {
                        return;
                    }
                    int naiEntryIndex = bitStream.read(4);
                    if (!this.checkLengthLegal(mipUppLength -= 4, 8)) {
                        return;
                    }
                    int naiLength = bitStream.read(8);
                    mipUppLength -= 8;
                    if (naiEntryIndex == 0) {
                        if (!this.checkLengthLegal(mipUppLength, naiLength << 3)) {
                            return;
                        }
                        char[] naiCharArray = new char[naiLength];
                        for (int index1 = 0; index1 < naiLength; ++index1) {
                            naiCharArray[index1] = (char)(bitStream.read(8) & 0xFF);
                        }
                        this.this$0.mNai = new String(naiCharArray);
                        if (Log.isLoggable("RuimRecords", 2)) {
                            Log.v("RuimRecords", "MIPUPP Nai = " + this.this$0.mNai);
                        }
                        return;
                    }
                    if (!this.checkLengthLegal(mipUppLength, (naiLength << 3) + 102)) {
                        return;
                    }
                    bitStream.skip((naiLength << 3) + 101);
                    int mnAaaSpiIndicator = bitStream.read(1);
                    mipUppLength -= (naiLength << 3) + 102;
                    if (mnAaaSpiIndicator == 1) {
                        if (!this.checkLengthLegal(mipUppLength, 32)) {
                            return;
                        }
                        bitStream.skip(32);
                        mipUppLength -= 32;
                    }
                    if (!this.checkLengthLegal(mipUppLength, 5)) {
                        return;
                    }
                    bitStream.skip(4);
                    mipUppLength -= 4;
                    int mnHaSpiIndicator = bitStream.read(1);
                    --mipUppLength;
                    if (mnHaSpiIndicator != 1) continue;
                    if (!this.checkLengthLegal(mipUppLength, 32)) {
                        return;
                    }
                    bitStream.skip(32);
                    mipUppLength -= 32;
                }
            }
            catch (Exception e) {
                Log.e("RuimRecords", "MIPUPP read Exception error!");
                return;
            }
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimMipUppLoaded$__constructor__(RuimRecords x0, 1 x1) {
        }

        private void __constructor__(RuimRecords ruimRecords) {
            this.$$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimMipUppLoaded$__constructor__(ruimRecords);
        }

        private EfCsimMipUppLoaded(RuimRecords ruimRecords) {
            this.this$0 = ruimRecords;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimMipUppLoaded$__constructor__(com.android.internal.telephony.uicc.RuimRecords ), 0, this, ruimRecords);
        }

        @Override
        public String getEfName() {
            return InvokeDynamicSupport.bootstrap("getEfName", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimMipUppLoaded$getEfName(), 0, this);
        }

        boolean checkLengthLegal(int n, int n2) {
            return (boolean)InvokeDynamicSupport.bootstrap("checkLengthLegal", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimMipUppLoaded$checkLengthLegal(int int ), 0, this, n, n2);
        }

        @Override
        public void onRecordLoaded(AsyncResult asyncResult) {
            InvokeDynamicSupport.bootstrap("onRecordLoaded", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimMipUppLoaded$onRecordLoaded(android.os.AsyncResult ), 0, this, asyncResult);
        }

        private /* synthetic */ void __constructor__(RuimRecords ruimRecords, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimMipUppLoaded$__constructor__(ruimRecords, var2_2);
        }

        public /* synthetic */ EfCsimMipUppLoaded() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EfCsimMipUppLoaded)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class EfCsimEprlLoaded
    implements IccRecords.IccRecordLoaded,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ RuimRecords this$0;

        private void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimEprlLoaded$__constructor__(RuimRecords ruimRecords) {
        }

        private final String $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimEprlLoaded$getEfName() {
            return "EF_CSIM_EPRL";
        }

        private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimEprlLoaded$onRecordLoaded(AsyncResult ar) {
            this.this$0.onGetCSimEprlDone(ar);
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimEprlLoaded$__constructor__(RuimRecords x0, 1 x1) {
        }

        private void __constructor__(RuimRecords ruimRecords) {
            this.$$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimEprlLoaded$__constructor__(ruimRecords);
        }

        private EfCsimEprlLoaded(RuimRecords ruimRecords) {
            this.this$0 = ruimRecords;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimEprlLoaded$__constructor__(com.android.internal.telephony.uicc.RuimRecords ), 0, this, ruimRecords);
        }

        @Override
        public String getEfName() {
            return InvokeDynamicSupport.bootstrap("getEfName", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimEprlLoaded$getEfName(), 0, this);
        }

        @Override
        public void onRecordLoaded(AsyncResult asyncResult) {
            InvokeDynamicSupport.bootstrap("onRecordLoaded", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimEprlLoaded$onRecordLoaded(android.os.AsyncResult ), 0, this, asyncResult);
        }

        private /* synthetic */ void __constructor__(RuimRecords ruimRecords, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimEprlLoaded$__constructor__(ruimRecords, var2_2);
        }

        public /* synthetic */ EfCsimEprlLoaded() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EfCsimEprlLoaded)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class EfCsimCdmaHomeLoaded
    implements IccRecords.IccRecordLoaded,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ RuimRecords this$0;

        private void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimCdmaHomeLoaded$__constructor__(RuimRecords ruimRecords) {
        }

        private final String $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimCdmaHomeLoaded$getEfName() {
            return "EF_CSIM_CDMAHOME";
        }

        private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimCdmaHomeLoaded$onRecordLoaded(AsyncResult ar) {
            ArrayList dataList = (ArrayList)ar.result;
            this.this$0.log("CSIM_CDMAHOME data size=" + dataList.size());
            if (dataList.isEmpty()) {
                return;
            }
            StringBuilder sidBuf = new StringBuilder();
            StringBuilder nidBuf = new StringBuilder();
            for (byte[] data : dataList) {
                if (data.length != 5) continue;
                int sid = (data[1] & 0xFF) << 8 | data[0] & 0xFF;
                int nid = (data[3] & 0xFF) << 8 | data[2] & 0xFF;
                sidBuf.append(sid).append(',');
                nidBuf.append(nid).append(',');
            }
            sidBuf.setLength(sidBuf.length() - 1);
            nidBuf.setLength(nidBuf.length() - 1);
            this.this$0.mHomeSystemId = sidBuf.toString();
            this.this$0.mHomeNetworkId = nidBuf.toString();
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimCdmaHomeLoaded$__constructor__(RuimRecords x0, 1 x1) {
        }

        private void __constructor__(RuimRecords ruimRecords) {
            this.$$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimCdmaHomeLoaded$__constructor__(ruimRecords);
        }

        private EfCsimCdmaHomeLoaded(RuimRecords ruimRecords) {
            this.this$0 = ruimRecords;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimCdmaHomeLoaded$__constructor__(com.android.internal.telephony.uicc.RuimRecords ), 0, this, ruimRecords);
        }

        @Override
        public String getEfName() {
            return InvokeDynamicSupport.bootstrap("getEfName", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimCdmaHomeLoaded$getEfName(), 0, this);
        }

        @Override
        public void onRecordLoaded(AsyncResult asyncResult) {
            InvokeDynamicSupport.bootstrap("onRecordLoaded", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimCdmaHomeLoaded$onRecordLoaded(android.os.AsyncResult ), 0, this, asyncResult);
        }

        private /* synthetic */ void __constructor__(RuimRecords ruimRecords, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimCdmaHomeLoaded$__constructor__(ruimRecords, var2_2);
        }

        public /* synthetic */ EfCsimCdmaHomeLoaded() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EfCsimCdmaHomeLoaded)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class EfCsimImsimLoaded
    implements IccRecords.IccRecordLoaded,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ RuimRecords this$0;

        private void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimImsimLoaded$__constructor__(RuimRecords ruimRecords) {
        }

        private final String $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimImsimLoaded$getEfName() {
            return "EF_CSIM_IMSIM";
        }

        private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimImsimLoaded$onRecordLoaded(AsyncResult ar) {
            boolean provisioned;
            byte[] data = (byte[])ar.result;
            boolean bl = provisioned = (data[7] & 0x80) == 128;
            if (provisioned) {
                int first3digits = ((3 & data[2]) << 8) + (0xFF & data[1]);
                int second3digits = ((0xFF & data[5]) << 8 | 0xFF & data[4]) >> 6;
                int digit7 = 0xF & data[4] >> 2;
                if (digit7 > 9) {
                    digit7 = 0;
                }
                int last3digits = (3 & data[4]) << 8 | 0xFF & data[3];
                first3digits = this.this$0.adjstMinDigits(first3digits);
                second3digits = this.this$0.adjstMinDigits(second3digits);
                last3digits = this.this$0.adjstMinDigits(last3digits);
                StringBuilder builder = new StringBuilder();
                builder.append(String.format(Locale.US, "%03d", first3digits));
                builder.append(String.format(Locale.US, "%03d", second3digits));
                builder.append(String.format(Locale.US, "%d", digit7));
                builder.append(String.format(Locale.US, "%03d", last3digits));
                this.this$0.mMin = builder.toString();
                this.this$0.log("min present=" + this.this$0.mMin);
            } else {
                this.this$0.log("min not present");
            }
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimImsimLoaded$__constructor__(RuimRecords x0, 1 x1) {
        }

        private void __constructor__(RuimRecords ruimRecords) {
            this.$$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimImsimLoaded$__constructor__(ruimRecords);
        }

        private EfCsimImsimLoaded(RuimRecords ruimRecords) {
            this.this$0 = ruimRecords;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimImsimLoaded$__constructor__(com.android.internal.telephony.uicc.RuimRecords ), 0, this, ruimRecords);
        }

        @Override
        public String getEfName() {
            return InvokeDynamicSupport.bootstrap("getEfName", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimImsimLoaded$getEfName(), 0, this);
        }

        @Override
        public void onRecordLoaded(AsyncResult asyncResult) {
            InvokeDynamicSupport.bootstrap("onRecordLoaded", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimImsimLoaded$onRecordLoaded(android.os.AsyncResult ), 0, this, asyncResult);
        }

        private /* synthetic */ void __constructor__(RuimRecords ruimRecords, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimImsimLoaded$__constructor__(ruimRecords, var2_2);
        }

        public /* synthetic */ EfCsimImsimLoaded() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EfCsimImsimLoaded)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class EfCsimMdnLoaded
    implements IccRecords.IccRecordLoaded,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ RuimRecords this$0;

        private void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimMdnLoaded$__constructor__(RuimRecords ruimRecords) {
        }

        private final String $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimMdnLoaded$getEfName() {
            return "EF_CSIM_MDN";
        }

        private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimMdnLoaded$onRecordLoaded(AsyncResult ar) {
            byte[] data = (byte[])ar.result;
            this.this$0.log("CSIM_MDN=" + IccUtils.bytesToHexString(data));
            int mdnDigitsNum = 0xF & data[0];
            this.this$0.mMdn = IccUtils.cdmaBcdToString(data, 1, mdnDigitsNum);
            this.this$0.log("CSIM MDN=" + this.this$0.mMdn);
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimMdnLoaded$__constructor__(RuimRecords x0, 1 x1) {
        }

        private void __constructor__(RuimRecords ruimRecords) {
            this.$$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimMdnLoaded$__constructor__(ruimRecords);
        }

        private EfCsimMdnLoaded(RuimRecords ruimRecords) {
            this.this$0 = ruimRecords;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimMdnLoaded$__constructor__(com.android.internal.telephony.uicc.RuimRecords ), 0, this, ruimRecords);
        }

        @Override
        public String getEfName() {
            return InvokeDynamicSupport.bootstrap("getEfName", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimMdnLoaded$getEfName(), 0, this);
        }

        @Override
        public void onRecordLoaded(AsyncResult asyncResult) {
            InvokeDynamicSupport.bootstrap("onRecordLoaded", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimMdnLoaded$onRecordLoaded(android.os.AsyncResult ), 0, this, asyncResult);
        }

        private /* synthetic */ void __constructor__(RuimRecords ruimRecords, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimMdnLoaded$__constructor__(ruimRecords, var2_2);
        }

        public /* synthetic */ EfCsimMdnLoaded() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EfCsimMdnLoaded)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class EfCsimSpnLoaded
    implements IccRecords.IccRecordLoaded,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ RuimRecords this$0;

        private void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimSpnLoaded$__constructor__(RuimRecords ruimRecords) {
        }

        private final String $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimSpnLoaded$getEfName() {
            return "EF_CSIM_SPN";
        }

        private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimSpnLoaded$onRecordLoaded(AsyncResult ar) {
            int numBytes;
            byte[] data = (byte[])ar.result;
            this.this$0.log("CSIM_SPN=" + IccUtils.bytesToHexString(data));
            this.this$0.mCsimSpnDisplayCondition = (1 & data[0]) != 0;
            byte encoding = data[1];
            byte language = data[2];
            byte[] spnData = new byte[32];
            int len = data.length - 3 < 32 ? data.length - 3 : 32;
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])data, (int)3, (byte[])spnData, (int)0, (int)len);
            for (numBytes = 0; numBytes < spnData.length && (spnData[numBytes] & 0xFF) != 255; ++numBytes) {
            }
            if (numBytes == 0) {
                this.this$0.setServiceProviderName("");
                return;
            }
            try {
                switch (encoding) {
                    case 0: 
                    case 8: {
                        this.this$0.setServiceProviderName(new String(spnData, 0, numBytes, "ISO-8859-1"));
                        break;
                    }
                    case 3: 
                    case 9: {
                        this.this$0.setServiceProviderName(GsmAlphabet.gsm7BitPackedToString(spnData, 0, numBytes * 8 / 7));
                        break;
                    }
                    case 2: {
                        String spn = new String(spnData, 0, numBytes, "US-ASCII");
                        if (TextUtils.isPrintableAsciiOnly(spn)) {
                            this.this$0.setServiceProviderName(spn);
                            break;
                        }
                        this.this$0.log("Some corruption in SPN decoding = " + spn);
                        this.this$0.log("Using ENCODING_GSM_7BIT_ALPHABET scheme...");
                        this.this$0.setServiceProviderName(GsmAlphabet.gsm7BitPackedToString(spnData, 0, numBytes * 8 / 7));
                        break;
                    }
                    case 4: {
                        this.this$0.setServiceProviderName(new String(spnData, 0, numBytes, "utf-16"));
                        break;
                    }
                    default: {
                        this.this$0.log("SPN encoding not supported");
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.this$0.log("spn decode error: " + e);
            }
            this.this$0.log("spn=" + this.this$0.getServiceProviderName());
            this.this$0.log("spnCondition=" + this.this$0.mCsimSpnDisplayCondition);
            this.this$0.mTelephonyManager.setSimOperatorNameForPhone(this.this$0.mParentApp.getPhoneId(), this.this$0.getServiceProviderName());
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimSpnLoaded$__constructor__(RuimRecords x0, 1 x1) {
        }

        private void __constructor__(RuimRecords ruimRecords) {
            this.$$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimSpnLoaded$__constructor__(ruimRecords);
        }

        private EfCsimSpnLoaded(RuimRecords ruimRecords) {
            this.this$0 = ruimRecords;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimSpnLoaded$__constructor__(com.android.internal.telephony.uicc.RuimRecords ), 0, this, ruimRecords);
        }

        @Override
        public String getEfName() {
            return InvokeDynamicSupport.bootstrap("getEfName", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimSpnLoaded$getEfName(), 0, this);
        }

        @Override
        public void onRecordLoaded(AsyncResult asyncResult) {
            InvokeDynamicSupport.bootstrap("onRecordLoaded", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimSpnLoaded$onRecordLoaded(android.os.AsyncResult ), 0, this, asyncResult);
        }

        private /* synthetic */ void __constructor__(RuimRecords ruimRecords, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimSpnLoaded$__constructor__(ruimRecords, var2_2);
        }

        public /* synthetic */ EfCsimSpnLoaded() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EfCsimSpnLoaded)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class EfCsimLiLoaded
    implements IccRecords.IccRecordLoaded,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ RuimRecords this$0;

        private void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimLiLoaded$__constructor__(RuimRecords ruimRecords) {
        }

        private final String $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimLiLoaded$getEfName() {
            return "EF_CSIM_LI";
        }

        private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimLiLoaded$onRecordLoaded(AsyncResult ar) {
            RuimRecords.access$102(this.this$0, (byte[])ar.result);
            block9: for (int i = 0; i < this.this$0.mEFli.length; i += 2) {
                switch (this.this$0.mEFli[i + 1]) {
                    case 1: {
                        ((RuimRecords)this.this$0).mEFli[i] = 101;
                        ((RuimRecords)this.this$0).mEFli[i + 1] = 110;
                        continue block9;
                    }
                    case 2: {
                        ((RuimRecords)this.this$0).mEFli[i] = 102;
                        ((RuimRecords)this.this$0).mEFli[i + 1] = 114;
                        continue block9;
                    }
                    case 3: {
                        ((RuimRecords)this.this$0).mEFli[i] = 101;
                        ((RuimRecords)this.this$0).mEFli[i + 1] = 115;
                        continue block9;
                    }
                    case 4: {
                        ((RuimRecords)this.this$0).mEFli[i] = 106;
                        ((RuimRecords)this.this$0).mEFli[i + 1] = 97;
                        continue block9;
                    }
                    case 5: {
                        ((RuimRecords)this.this$0).mEFli[i] = 107;
                        ((RuimRecords)this.this$0).mEFli[i + 1] = 111;
                        continue block9;
                    }
                    case 6: {
                        ((RuimRecords)this.this$0).mEFli[i] = 122;
                        ((RuimRecords)this.this$0).mEFli[i + 1] = 104;
                        continue block9;
                    }
                    case 7: {
                        ((RuimRecords)this.this$0).mEFli[i] = 104;
                        ((RuimRecords)this.this$0).mEFli[i + 1] = 101;
                        continue block9;
                    }
                    default: {
                        ((RuimRecords)this.this$0).mEFli[i] = 32;
                        ((RuimRecords)this.this$0).mEFli[i + 1] = 32;
                    }
                }
            }
            this.this$0.log("EF_LI=" + IccUtils.bytesToHexString(this.this$0.mEFli));
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimLiLoaded$__constructor__(RuimRecords x0, 1 x1) {
        }

        private void __constructor__(RuimRecords ruimRecords) {
            this.$$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimLiLoaded$__constructor__(ruimRecords);
        }

        private EfCsimLiLoaded(RuimRecords ruimRecords) {
            this.this$0 = ruimRecords;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimLiLoaded$__constructor__(com.android.internal.telephony.uicc.RuimRecords ), 0, this, ruimRecords);
        }

        @Override
        public String getEfName() {
            return InvokeDynamicSupport.bootstrap("getEfName", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimLiLoaded$getEfName(), 0, this);
        }

        @Override
        public void onRecordLoaded(AsyncResult asyncResult) {
            InvokeDynamicSupport.bootstrap("onRecordLoaded", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimLiLoaded$onRecordLoaded(android.os.AsyncResult ), 0, this, asyncResult);
        }

        private /* synthetic */ void __constructor__(RuimRecords ruimRecords, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_uicc_RuimRecords_EfCsimLiLoaded$__constructor__(ruimRecords, var2_2);
        }

        public /* synthetic */ EfCsimLiLoaded() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EfCsimLiLoaded)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class EfPlLoaded
    implements IccRecords.IccRecordLoaded,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ RuimRecords this$0;

        private void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfPlLoaded$__constructor__(RuimRecords ruimRecords) {
        }

        private final String $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfPlLoaded$getEfName() {
            return "EF_PL";
        }

        private final void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfPlLoaded$onRecordLoaded(AsyncResult ar) {
            RuimRecords.access$002(this.this$0, (byte[])ar.result);
            this.this$0.log("EF_PL=" + IccUtils.bytesToHexString(this.this$0.mEFpl));
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfPlLoaded$__constructor__(RuimRecords x0, 1 x1) {
        }

        private void __constructor__(RuimRecords ruimRecords) {
            this.$$robo$$com_android_internal_telephony_uicc_RuimRecords_EfPlLoaded$__constructor__(ruimRecords);
        }

        private EfPlLoaded(RuimRecords ruimRecords) {
            this.this$0 = ruimRecords;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfPlLoaded$__constructor__(com.android.internal.telephony.uicc.RuimRecords ), 0, this, ruimRecords);
        }

        @Override
        public String getEfName() {
            return InvokeDynamicSupport.bootstrap("getEfName", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfPlLoaded$getEfName(), 0, this);
        }

        @Override
        public void onRecordLoaded(AsyncResult asyncResult) {
            InvokeDynamicSupport.bootstrap("onRecordLoaded", $$robo$$com_android_internal_telephony_uicc_RuimRecords_EfPlLoaded$onRecordLoaded(android.os.AsyncResult ), 0, this, asyncResult);
        }

        private /* synthetic */ void __constructor__(RuimRecords ruimRecords, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_uicc_RuimRecords_EfPlLoaded$__constructor__(ruimRecords, var2_2);
        }

        public /* synthetic */ EfPlLoaded() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EfPlLoaded)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

