/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.telephony.Rlog;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.uicc.CsimFileHandler;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccCardStatus;
import com.android.internal.telephony.uicc.IccFileHandler;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.IsimFileHandler;
import com.android.internal.telephony.uicc.IsimUiccRecords;
import com.android.internal.telephony.uicc.RuimFileHandler;
import com.android.internal.telephony.uicc.RuimRecords;
import com.android.internal.telephony.uicc.SIMFileHandler;
import com.android.internal.telephony.uicc.SIMRecords;
import com.android.internal.telephony.uicc.UiccProfile;
import com.android.internal.telephony.uicc.UsimFileHandler;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class UiccCardApplication
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "UiccCardApplication";
    private static boolean DBG = true;
    private static int EVENT_PIN1_PUK1_DONE = 1;
    private static int EVENT_CHANGE_PIN1_DONE = 2;
    private static int EVENT_CHANGE_PIN2_DONE = 3;
    private static int EVENT_QUERY_FACILITY_FDN_DONE = 4;
    private static int EVENT_CHANGE_FACILITY_FDN_DONE = 5;
    private static int EVENT_QUERY_FACILITY_LOCK_DONE = 6;
    private static int EVENT_CHANGE_FACILITY_LOCK_DONE = 7;
    private static int EVENT_PIN2_PUK2_DONE = 8;
    private static int EVENT_RADIO_UNAVAILABLE = 9;
    public static int AUTH_CONTEXT_EAP_SIM = 128;
    public static int AUTH_CONTEXT_EAP_AKA = 129;
    public static int AUTH_CONTEXT_UNDEFINED = -1;
    private Object mLock;
    private UiccProfile mUiccProfile;
    private IccCardApplicationStatus.AppState mAppState;
    private IccCardApplicationStatus.AppType mAppType;
    private int mAuthContext;
    private IccCardApplicationStatus.PersoSubState mPersoSubState;
    private String mAid;
    private String mAppLabel;
    private boolean mPin1Replaced;
    private IccCardStatus.PinState mPin1State;
    private IccCardStatus.PinState mPin2State;
    private boolean mIccFdnEnabled;
    private boolean mDesiredFdnEnabled;
    private boolean mIccLockEnabled;
    private boolean mDesiredPinLocked;
    private boolean mIgnoreApp;
    private boolean mIccFdnAvailable;
    private CommandsInterface mCi;
    private Context mContext;
    private IccRecords mIccRecords;
    private IccFileHandler mIccFh;
    private boolean mDestroyed;
    private RegistrantList mReadyRegistrants;
    private RegistrantList mPinLockedRegistrants;
    private RegistrantList mNetworkLockedRegistrants;
    private Handler mHandler;

    private void $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$__constructor__(UiccProfile uiccProfile, IccCardApplicationStatus as, Context c, CommandsInterface ci) {
        this.mLock = new Object();
        this.mIccFdnAvailable = true;
        this.mReadyRegistrants = new RegistrantList();
        this.mPinLockedRegistrants = new RegistrantList();
        this.mNetworkLockedRegistrants = new RegistrantList();
        this.mHandler = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ UiccCardApplication this$0;

            private void $$robo$$com_android_internal_telephony_uicc_UiccCardApplication_1$__constructor__(UiccCardApplication this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_uicc_UiccCardApplication_1$handleMessage(Message msg) {
                if (this.this$0.mDestroyed) {
                    this.this$0.loge("Received message " + msg + "[" + msg.what + "] while being destroyed. Ignoring.");
                    return;
                }
                switch (msg.what) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 8: {
                        AsyncResult ar = (AsyncResult)msg.obj;
                        int attemptsRemaining = this.this$0.parsePinPukErrorResult(ar);
                        Message response = (Message)ar.userObj;
                        AsyncResult.forMessage((Message)response).exception = ar.exception;
                        response.arg1 = attemptsRemaining;
                        response.sendToTarget();
                        break;
                    }
                    case 4: {
                        AsyncResult ar = (AsyncResult)msg.obj;
                        this.this$0.onQueryFdnEnabled(ar);
                        break;
                    }
                    case 5: {
                        AsyncResult ar = (AsyncResult)msg.obj;
                        this.this$0.onChangeFdnDone(ar);
                        break;
                    }
                    case 6: {
                        AsyncResult ar = (AsyncResult)msg.obj;
                        this.this$0.onQueryFacilityLock(ar);
                        break;
                    }
                    case 7: {
                        AsyncResult ar = (AsyncResult)msg.obj;
                        this.this$0.onChangeFacilityLock(ar);
                        break;
                    }
                    case 9: {
                        this.this$0.log("handleMessage (EVENT_RADIO_UNAVAILABLE)");
                        this.this$0.mAppState = IccCardApplicationStatus.AppState.APPSTATE_UNKNOWN;
                        break;
                    }
                    default: {
                        this.this$0.loge("Unknown Event " + msg.what);
                    }
                }
            }

            private void __constructor__(UiccCardApplication uiccCardApplication) {
                this.$$robo$$com_android_internal_telephony_uicc_UiccCardApplication_1$__constructor__(uiccCardApplication);
            }
            {
                this.this$0 = uiccCardApplication;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication_1$__constructor__(com.android.internal.telephony.uicc.UiccCardApplication ), 0, this, uiccCardApplication);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication_1$handleMessage(android.os.Message ), 0, this, message);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.log("Creating UiccApp: " + as);
        this.mUiccProfile = uiccProfile;
        this.mAppState = as.app_state;
        this.mAppType = as.app_type;
        this.mAuthContext = UiccCardApplication.getAuthContext(this.mAppType);
        this.mPersoSubState = as.perso_substate;
        this.mAid = as.aid;
        this.mAppLabel = as.app_label;
        this.mPin1Replaced = as.pin1_replaced != 0;
        this.mPin1State = as.pin1;
        this.mPin2State = as.pin2;
        this.mIgnoreApp = false;
        this.mContext = c;
        this.mCi = ci;
        this.mIccFh = this.createIccFileHandler(as.app_type);
        this.mIccRecords = this.createIccRecords(as.app_type, this.mContext, this.mCi);
        if (this.mAppState == IccCardApplicationStatus.AppState.APPSTATE_READY) {
            this.queryFdn();
            this.queryPin1State();
        }
        this.mCi.registerForNotAvailable(this.mHandler, 9, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$update(IccCardApplicationStatus as, Context c, CommandsInterface ci) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                this.loge("Application updated after destroyed! Fix me!");
                return;
            }
            this.log((Object)((Object)this.mAppType) + " update. New " + as);
            this.mContext = c;
            this.mCi = ci;
            IccCardApplicationStatus.AppType oldAppType = this.mAppType;
            IccCardApplicationStatus.AppState oldAppState = this.mAppState;
            IccCardApplicationStatus.PersoSubState oldPersoSubState = this.mPersoSubState;
            this.mAppType = as.app_type;
            this.mAuthContext = UiccCardApplication.getAuthContext(this.mAppType);
            this.mAppState = as.app_state;
            this.mPersoSubState = as.perso_substate;
            this.mAid = as.aid;
            this.mAppLabel = as.app_label;
            this.mPin1Replaced = as.pin1_replaced != 0;
            this.mPin1State = as.pin1;
            this.mPin2State = as.pin2;
            if (this.mAppType != oldAppType) {
                if (this.mIccFh != null) {
                    this.mIccFh.dispose();
                }
                if (this.mIccRecords != null) {
                    this.mIccRecords.dispose();
                }
                this.mIccFh = this.createIccFileHandler(as.app_type);
                this.mIccRecords = this.createIccRecords(as.app_type, c, ci);
            }
            if (this.mPersoSubState != oldPersoSubState && this.mPersoSubState == IccCardApplicationStatus.PersoSubState.PERSOSUBSTATE_SIM_NETWORK) {
                this.notifyNetworkLockedRegistrantsIfNeeded(null);
            }
            if (this.mAppState != oldAppState) {
                this.log((Object)((Object)oldAppType) + " changed state: " + (Object)((Object)oldAppState) + " -> " + (Object)((Object)this.mAppState));
                if (this.mAppState == IccCardApplicationStatus.AppState.APPSTATE_READY) {
                    this.queryFdn();
                    this.queryPin1State();
                }
                this.notifyPinLockedRegistrantsIfNeeded(null);
                this.notifyReadyRegistrantsIfNeeded(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$dispose() {
        Object object = this.mLock;
        synchronized (object) {
            this.log((Object)((Object)this.mAppType) + " being Disposed");
            this.mDestroyed = true;
            if (this.mIccRecords != null) {
                this.mIccRecords.dispose();
            }
            if (this.mIccFh != null) {
                this.mIccFh.dispose();
            }
            this.mIccRecords = null;
            this.mIccFh = null;
            this.mCi.unregisterForNotAvailable(this.mHandler);
        }
    }

    private final IccRecords $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$createIccRecords(IccCardApplicationStatus.AppType type, Context c, CommandsInterface ci) {
        if (type == IccCardApplicationStatus.AppType.APPTYPE_USIM || type == IccCardApplicationStatus.AppType.APPTYPE_SIM) {
            return new SIMRecords(this, c, ci);
        }
        if (type == IccCardApplicationStatus.AppType.APPTYPE_RUIM || type == IccCardApplicationStatus.AppType.APPTYPE_CSIM) {
            return new RuimRecords(this, c, ci);
        }
        if (type == IccCardApplicationStatus.AppType.APPTYPE_ISIM) {
            return new IsimUiccRecords(this, c, ci);
        }
        return null;
    }

    private final IccFileHandler $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$createIccFileHandler(IccCardApplicationStatus.AppType type) {
        switch (2.$SwitchMap$com$android$internal$telephony$uicc$IccCardApplicationStatus$AppType[type.ordinal()]) {
            case 1: {
                return new SIMFileHandler(this, this.mAid, this.mCi);
            }
            case 2: {
                return new RuimFileHandler(this, this.mAid, this.mCi);
            }
            case 3: {
                return new UsimFileHandler(this, this.mAid, this.mCi);
            }
            case 4: {
                return new CsimFileHandler(this, this.mAid, this.mCi);
            }
            case 5: {
                return new IsimFileHandler(this, this.mAid, this.mCi);
            }
        }
        return null;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$queryFdn() {
        int serviceClassX = 7;
        this.mCi.queryFacilityLockForApp("FD", "", serviceClassX, this.mAid, this.mHandler.obtainMessage(4));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$onQueryFdnEnabled(AsyncResult ar) {
        Object object = this.mLock;
        synchronized (object) {
            if (ar.exception != null) {
                this.log("Error in querying facility lock:" + ar.exception);
                return;
            }
            int[] result = (int[])ar.result;
            if (result.length != 0) {
                if (result[0] == 2) {
                    this.mIccFdnEnabled = false;
                    this.mIccFdnAvailable = false;
                } else {
                    this.mIccFdnEnabled = result[0] == 1;
                    this.mIccFdnAvailable = true;
                }
                this.log("Query facility FDN : FDN service available: " + this.mIccFdnAvailable + " enabled: " + this.mIccFdnEnabled);
            } else {
                this.loge("Bogus facility lock response");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$onChangeFdnDone(AsyncResult ar) {
        Object object = this.mLock;
        synchronized (object) {
            int attemptsRemaining = -1;
            if (ar.exception == null) {
                this.mIccFdnEnabled = this.mDesiredFdnEnabled;
                this.log("EVENT_CHANGE_FACILITY_FDN_DONE: mIccFdnEnabled=" + this.mIccFdnEnabled);
            } else {
                attemptsRemaining = this.parsePinPukErrorResult(ar);
                this.loge("Error change facility fdn with exception " + ar.exception);
            }
            Message response = (Message)ar.userObj;
            response.arg1 = attemptsRemaining;
            AsyncResult.forMessage((Message)response).exception = ar.exception;
            response.sendToTarget();
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$queryPin1State() {
        int serviceClassX = 7;
        this.mCi.queryFacilityLockForApp("SC", "", serviceClassX, this.mAid, this.mHandler.obtainMessage(6));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$onQueryFacilityLock(AsyncResult ar) {
        block12: {
            Object object = this.mLock;
            synchronized (object) {
                block11: {
                    if (ar.exception != null) {
                        this.log("Error in querying facility lock:" + ar.exception);
                        return;
                    }
                    int[] ints = (int[])ar.result;
                    if (ints.length == 0) break block11;
                    this.log("Query facility lock : " + ints[0]);
                    boolean bl = this.mIccLockEnabled = ints[0] != 0;
                    if (this.mIccLockEnabled) {
                        this.mPinLockedRegistrants.notifyRegistrants();
                    }
                    switch (2.$SwitchMap$com$android$internal$telephony$uicc$IccCardStatus$PinState[this.mPin1State.ordinal()]) {
                        case 1: {
                            if (this.mIccLockEnabled) {
                                this.loge("QUERY_FACILITY_LOCK:enabled GET_SIM_STATUS.Pin1:disabled. Fixme");
                                break;
                            }
                            break block12;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            if (!this.mIccLockEnabled) {
                                this.loge("QUERY_FACILITY_LOCK:disabled GET_SIM_STATUS.Pin1:enabled. Fixme");
                            }
                        }
                        default: {
                            this.log("Ignoring: pin1state=" + (Object)((Object)this.mPin1State));
                            break;
                        }
                    }
                    break block12;
                }
                this.loge("Bogus facility lock response");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$onChangeFacilityLock(AsyncResult ar) {
        Object object = this.mLock;
        synchronized (object) {
            int attemptsRemaining = -1;
            if (ar.exception == null) {
                this.mIccLockEnabled = this.mDesiredPinLocked;
                this.log("EVENT_CHANGE_FACILITY_LOCK_DONE: mIccLockEnabled= " + this.mIccLockEnabled);
            } else {
                attemptsRemaining = this.parsePinPukErrorResult(ar);
                this.loge("Error change facility lock with exception " + ar.exception);
            }
            Message response = (Message)ar.userObj;
            AsyncResult.forMessage((Message)response).exception = ar.exception;
            response.arg1 = attemptsRemaining;
            response.sendToTarget();
        }
    }

    private final int $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$parsePinPukErrorResult(AsyncResult ar) {
        int[] result = (int[])ar.result;
        if (result == null) {
            return -1;
        }
        int length = result.length;
        int attemptsRemaining = -1;
        if (length > 0) {
            attemptsRemaining = result[0];
        }
        this.log("parsePinPukErrorResult: attemptsRemaining=" + attemptsRemaining);
        return attemptsRemaining;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$registerForReady(Handler h, int what, Object obj) {
        Object object = this.mLock;
        synchronized (object) {
            Registrant r = new Registrant(h, what, obj);
            this.mReadyRegistrants.add(r);
            this.notifyReadyRegistrantsIfNeeded(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$unregisterForReady(Handler h) {
        Object object = this.mLock;
        synchronized (object) {
            this.mReadyRegistrants.remove(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$registerForLocked(Handler h, int what, Object obj) {
        Object object = this.mLock;
        synchronized (object) {
            Registrant r = new Registrant(h, what, obj);
            this.mPinLockedRegistrants.add(r);
            this.notifyPinLockedRegistrantsIfNeeded(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$unregisterForLocked(Handler h) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPinLockedRegistrants.remove(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$registerForNetworkLocked(Handler h, int what, Object obj) {
        Object object = this.mLock;
        synchronized (object) {
            Registrant r = new Registrant(h, what, obj);
            this.mNetworkLockedRegistrants.add(r);
            this.notifyNetworkLockedRegistrantsIfNeeded(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$unregisterForNetworkLocked(Handler h) {
        Object object = this.mLock;
        synchronized (object) {
            this.mNetworkLockedRegistrants.remove(h);
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$notifyReadyRegistrantsIfNeeded(Registrant r) {
        if (this.mDestroyed) {
            return;
        }
        if (this.mAppState == IccCardApplicationStatus.AppState.APPSTATE_READY) {
            if (this.mPin1State == IccCardStatus.PinState.PINSTATE_ENABLED_NOT_VERIFIED || this.mPin1State == IccCardStatus.PinState.PINSTATE_ENABLED_BLOCKED || this.mPin1State == IccCardStatus.PinState.PINSTATE_ENABLED_PERM_BLOCKED) {
                this.loge("Sanity check failed! APPSTATE is ready while PIN1 is not verified!!!");
                return;
            }
            if (r == null) {
                this.log("Notifying registrants: READY");
                this.mReadyRegistrants.notifyRegistrants();
            } else {
                this.log("Notifying 1 registrant: READY");
                r.notifyRegistrant(new AsyncResult(null, null, null));
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$notifyPinLockedRegistrantsIfNeeded(Registrant r) {
        if (this.mDestroyed) {
            return;
        }
        if (this.mAppState == IccCardApplicationStatus.AppState.APPSTATE_PIN || this.mAppState == IccCardApplicationStatus.AppState.APPSTATE_PUK) {
            if (this.mPin1State == IccCardStatus.PinState.PINSTATE_ENABLED_VERIFIED || this.mPin1State == IccCardStatus.PinState.PINSTATE_DISABLED) {
                this.loge("Sanity check failed! APPSTATE is locked while PIN1 is not!!!");
                return;
            }
            if (r == null) {
                this.log("Notifying registrants: LOCKED");
                this.mPinLockedRegistrants.notifyRegistrants();
            } else {
                this.log("Notifying 1 registrant: LOCKED");
                r.notifyRegistrant(new AsyncResult(null, null, null));
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$notifyNetworkLockedRegistrantsIfNeeded(Registrant r) {
        if (this.mDestroyed) {
            return;
        }
        if (this.mAppState == IccCardApplicationStatus.AppState.APPSTATE_SUBSCRIPTION_PERSO && this.mPersoSubState == IccCardApplicationStatus.PersoSubState.PERSOSUBSTATE_SIM_NETWORK) {
            if (r == null) {
                this.log("Notifying registrants: NETWORK_LOCKED");
                this.mNetworkLockedRegistrants.notifyRegistrants();
            } else {
                this.log("Notifying 1 registrant: NETWORK_LOCED");
                r.notifyRegistrant(new AsyncResult(null, null, null));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IccCardApplicationStatus.AppState $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$getState() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mAppState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IccCardApplicationStatus.AppType $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$getType() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mAppType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$getAuthContext() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mAuthContext;
        }
    }

    private static final int $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$getAuthContext(IccCardApplicationStatus.AppType appType) {
        int authContext;
        switch (2.$SwitchMap$com$android$internal$telephony$uicc$IccCardApplicationStatus$AppType[appType.ordinal()]) {
            case 1: {
                authContext = 128;
                break;
            }
            case 3: {
                authContext = 129;
                break;
            }
            default: {
                authContext = -1;
            }
        }
        return authContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IccCardApplicationStatus.PersoSubState $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$getPersoSubState() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPersoSubState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$getAid() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mAid;
        }
    }

    private final String $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$getAppLabel() {
        return this.mAppLabel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IccCardStatus.PinState $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$getPin1State() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPin1Replaced) {
                return this.mUiccProfile.getUniversalPinState();
            }
            return this.mPin1State;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IccFileHandler $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$getIccFileHandler() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mIccFh;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IccRecords $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$getIccRecords() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mIccRecords;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$supplyPin(String pin, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCi.supplyIccPinForApp(pin, this.mAid, this.mHandler.obtainMessage(1, onComplete));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$supplyPuk(String puk, String newPin, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCi.supplyIccPukForApp(puk, newPin, this.mAid, this.mHandler.obtainMessage(1, onComplete));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$supplyPin2(String pin2, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCi.supplyIccPin2ForApp(pin2, this.mAid, this.mHandler.obtainMessage(8, onComplete));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$supplyPuk2(String puk2, String newPin2, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCi.supplyIccPuk2ForApp(puk2, newPin2, this.mAid, this.mHandler.obtainMessage(8, onComplete));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$supplyNetworkDepersonalization(String pin, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            this.log("supplyNetworkDepersonalization");
            this.mCi.supplyNetworkDepersonalization(pin, onComplete);
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$getIccLockEnabled() {
        return this.mIccLockEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$getIccFdnEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mIccFdnEnabled;
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$getIccFdnAvailable() {
        return this.mIccFdnAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$setIccLockEnabled(boolean enabled, String password, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            int serviceClassX = 7;
            this.mDesiredPinLocked = enabled;
            this.mCi.setFacilityLockForApp("SC", enabled, password, serviceClassX, this.mAid, this.mHandler.obtainMessage(7, onComplete));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$setIccFdnEnabled(boolean enabled, String password, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            int serviceClassX = 15;
            this.mDesiredFdnEnabled = enabled;
            this.mCi.setFacilityLockForApp("FD", enabled, password, serviceClassX, this.mAid, this.mHandler.obtainMessage(5, onComplete));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$changeIccLockPassword(String oldPassword, String newPassword, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            this.log("changeIccLockPassword");
            this.mCi.changeIccPinForApp(oldPassword, newPassword, this.mAid, this.mHandler.obtainMessage(2, onComplete));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$changeIccFdnPassword(String oldPassword, String newPassword, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            this.log("changeIccFdnPassword");
            this.mCi.changeIccPin2ForApp(oldPassword, newPassword, this.mAid, this.mHandler.obtainMessage(3, onComplete));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$isReady() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAppState != IccCardApplicationStatus.AppState.APPSTATE_READY) {
                return false;
            }
            if (this.mPin1State == IccCardStatus.PinState.PINSTATE_ENABLED_NOT_VERIFIED || this.mPin1State == IccCardStatus.PinState.PINSTATE_ENABLED_BLOCKED || this.mPin1State == IccCardStatus.PinState.PINSTATE_ENABLED_PERM_BLOCKED) {
                this.loge("Sanity check failed! APPSTATE is ready while PIN1 is not verified!!!");
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$getIccPin2Blocked() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPin2State == IccCardStatus.PinState.PINSTATE_ENABLED_BLOCKED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$getIccPuk2Blocked() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPin2State == IccCardStatus.PinState.PINSTATE_ENABLED_PERM_BLOCKED;
        }
    }

    private final int $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$getPhoneId() {
        return this.mUiccProfile.getPhoneId();
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$isAppIgnored() {
        return this.mIgnoreApp;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$setAppIgnoreState(boolean ignore) {
        this.mIgnoreApp = ignore;
    }

    private final UiccProfile $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$getUiccProfile() {
        return this.mUiccProfile;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$log(String msg) {
        Rlog.d("UiccCardApplication", msg);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$loge(String msg) {
        Rlog.e("UiccCardApplication", msg);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        int i;
        pw.println("UiccCardApplication: " + this);
        pw.println(" mUiccProfile=" + this.mUiccProfile);
        pw.println(" mAppState=" + (Object)((Object)this.mAppState));
        pw.println(" mAppType=" + (Object)((Object)this.mAppType));
        pw.println(" mPersoSubState=" + (Object)((Object)this.mPersoSubState));
        pw.println(" mAid=" + this.mAid);
        pw.println(" mAppLabel=" + this.mAppLabel);
        pw.println(" mPin1Replaced=" + this.mPin1Replaced);
        pw.println(" mPin1State=" + (Object)((Object)this.mPin1State));
        pw.println(" mPin2State=" + (Object)((Object)this.mPin2State));
        pw.println(" mIccFdnEnabled=" + this.mIccFdnEnabled);
        pw.println(" mDesiredFdnEnabled=" + this.mDesiredFdnEnabled);
        pw.println(" mIccLockEnabled=" + this.mIccLockEnabled);
        pw.println(" mDesiredPinLocked=" + this.mDesiredPinLocked);
        pw.println(" mCi=" + this.mCi);
        pw.println(" mIccRecords=" + this.mIccRecords);
        pw.println(" mIccFh=" + this.mIccFh);
        pw.println(" mDestroyed=" + this.mDestroyed);
        pw.println(" mReadyRegistrants: size=" + this.mReadyRegistrants.size());
        for (i = 0; i < this.mReadyRegistrants.size(); ++i) {
            pw.println("  mReadyRegistrants[" + i + "]=" + ((Registrant)this.mReadyRegistrants.get(i)).getHandler());
        }
        pw.println(" mPinLockedRegistrants: size=" + this.mPinLockedRegistrants.size());
        for (i = 0; i < this.mPinLockedRegistrants.size(); ++i) {
            pw.println("  mPinLockedRegistrants[" + i + "]=" + ((Registrant)this.mPinLockedRegistrants.get(i)).getHandler());
        }
        pw.println(" mNetworkLockedRegistrants: size=" + this.mNetworkLockedRegistrants.size());
        for (i = 0; i < this.mNetworkLockedRegistrants.size(); ++i) {
            pw.println("  mNetworkLockedRegistrants[" + i + "]=" + ((Registrant)this.mNetworkLockedRegistrants.get(i)).getHandler());
        }
        pw.flush();
    }

    private void __constructor__(UiccProfile uiccProfile, IccCardApplicationStatus iccCardApplicationStatus, Context context, CommandsInterface commandsInterface) {
        this.$$robo$$com_android_internal_telephony_uicc_UiccCardApplication$__constructor__(uiccProfile, iccCardApplicationStatus, context, commandsInterface);
    }

    public UiccCardApplication(UiccProfile uiccProfile, IccCardApplicationStatus iccCardApplicationStatus, Context context, CommandsInterface commandsInterface) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$__constructor__(com.android.internal.telephony.uicc.UiccProfile com.android.internal.telephony.uicc.IccCardApplicationStatus android.content.Context com.android.internal.telephony.CommandsInterface ), 0, this, uiccProfile, iccCardApplicationStatus, context, commandsInterface);
    }

    public void update(IccCardApplicationStatus iccCardApplicationStatus, Context context, CommandsInterface commandsInterface) {
        InvokeDynamicSupport.bootstrap("update", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$update(com.android.internal.telephony.uicc.IccCardApplicationStatus android.content.Context com.android.internal.telephony.CommandsInterface ), 0, this, iccCardApplicationStatus, context, commandsInterface);
    }

    void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$dispose(), 0, this);
    }

    private IccRecords createIccRecords(IccCardApplicationStatus.AppType appType, Context context, CommandsInterface commandsInterface) {
        return InvokeDynamicSupport.bootstrap("createIccRecords", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$createIccRecords(com.android.internal.telephony.uicc.IccCardApplicationStatus$AppType android.content.Context com.android.internal.telephony.CommandsInterface ), 0, this, appType, context, commandsInterface);
    }

    private IccFileHandler createIccFileHandler(IccCardApplicationStatus.AppType appType) {
        return InvokeDynamicSupport.bootstrap("createIccFileHandler", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$createIccFileHandler(com.android.internal.telephony.uicc.IccCardApplicationStatus$AppType ), 0, this, appType);
    }

    public void queryFdn() {
        InvokeDynamicSupport.bootstrap("queryFdn", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$queryFdn(), 0, this);
    }

    private void onQueryFdnEnabled(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("onQueryFdnEnabled", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$onQueryFdnEnabled(android.os.AsyncResult ), 0, this, asyncResult);
    }

    private void onChangeFdnDone(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("onChangeFdnDone", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$onChangeFdnDone(android.os.AsyncResult ), 0, this, asyncResult);
    }

    private void queryPin1State() {
        InvokeDynamicSupport.bootstrap("queryPin1State", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$queryPin1State(), 0, this);
    }

    private void onQueryFacilityLock(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("onQueryFacilityLock", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$onQueryFacilityLock(android.os.AsyncResult ), 0, this, asyncResult);
    }

    private void onChangeFacilityLock(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("onChangeFacilityLock", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$onChangeFacilityLock(android.os.AsyncResult ), 0, this, asyncResult);
    }

    private int parsePinPukErrorResult(AsyncResult asyncResult) {
        return (int)InvokeDynamicSupport.bootstrap("parsePinPukErrorResult", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$parsePinPukErrorResult(android.os.AsyncResult ), 0, this, asyncResult);
    }

    public void registerForReady(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForReady", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$registerForReady(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForReady(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForReady", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$unregisterForReady(android.os.Handler ), 0, this, handler);
    }

    protected void registerForLocked(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForLocked", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$registerForLocked(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    protected void unregisterForLocked(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForLocked", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$unregisterForLocked(android.os.Handler ), 0, this, handler);
    }

    protected void registerForNetworkLocked(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForNetworkLocked", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$registerForNetworkLocked(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    protected void unregisterForNetworkLocked(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForNetworkLocked", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$unregisterForNetworkLocked(android.os.Handler ), 0, this, handler);
    }

    private void notifyReadyRegistrantsIfNeeded(Registrant registrant) {
        InvokeDynamicSupport.bootstrap("notifyReadyRegistrantsIfNeeded", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$notifyReadyRegistrantsIfNeeded(android.os.Registrant ), 0, this, registrant);
    }

    private void notifyPinLockedRegistrantsIfNeeded(Registrant registrant) {
        InvokeDynamicSupport.bootstrap("notifyPinLockedRegistrantsIfNeeded", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$notifyPinLockedRegistrantsIfNeeded(android.os.Registrant ), 0, this, registrant);
    }

    private void notifyNetworkLockedRegistrantsIfNeeded(Registrant registrant) {
        InvokeDynamicSupport.bootstrap("notifyNetworkLockedRegistrantsIfNeeded", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$notifyNetworkLockedRegistrantsIfNeeded(android.os.Registrant ), 0, this, registrant);
    }

    public IccCardApplicationStatus.AppState getState() {
        return InvokeDynamicSupport.bootstrap("getState", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$getState(), 0, this);
    }

    public IccCardApplicationStatus.AppType getType() {
        return InvokeDynamicSupport.bootstrap("getType", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$getType(), 0, this);
    }

    public int getAuthContext() {
        return (int)InvokeDynamicSupport.bootstrap("getAuthContext", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$getAuthContext(), 0, this);
    }

    private static int getAuthContext(IccCardApplicationStatus.AppType appType) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getAuthContext", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$getAuthContext(com.android.internal.telephony.uicc.IccCardApplicationStatus$AppType ), 0, (IccCardApplicationStatus.AppType)appType);
    }

    public IccCardApplicationStatus.PersoSubState getPersoSubState() {
        return InvokeDynamicSupport.bootstrap("getPersoSubState", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$getPersoSubState(), 0, this);
    }

    public String getAid() {
        return InvokeDynamicSupport.bootstrap("getAid", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$getAid(), 0, this);
    }

    public String getAppLabel() {
        return InvokeDynamicSupport.bootstrap("getAppLabel", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$getAppLabel(), 0, this);
    }

    public IccCardStatus.PinState getPin1State() {
        return InvokeDynamicSupport.bootstrap("getPin1State", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$getPin1State(), 0, this);
    }

    public IccFileHandler getIccFileHandler() {
        return InvokeDynamicSupport.bootstrap("getIccFileHandler", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$getIccFileHandler(), 0, this);
    }

    public IccRecords getIccRecords() {
        return InvokeDynamicSupport.bootstrap("getIccRecords", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$getIccRecords(), 0, this);
    }

    public void supplyPin(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("supplyPin", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$supplyPin(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    public void supplyPuk(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("supplyPuk", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$supplyPuk(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    public void supplyPin2(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("supplyPin2", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$supplyPin2(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    public void supplyPuk2(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("supplyPuk2", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$supplyPuk2(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    public void supplyNetworkDepersonalization(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("supplyNetworkDepersonalization", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$supplyNetworkDepersonalization(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    public boolean getIccLockEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("getIccLockEnabled", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$getIccLockEnabled(), 0, this);
    }

    public boolean getIccFdnEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("getIccFdnEnabled", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$getIccFdnEnabled(), 0, this);
    }

    public boolean getIccFdnAvailable() {
        return (boolean)InvokeDynamicSupport.bootstrap("getIccFdnAvailable", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$getIccFdnAvailable(), 0, this);
    }

    public void setIccLockEnabled(boolean bl, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("setIccLockEnabled", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$setIccLockEnabled(boolean java.lang.String android.os.Message ), 0, this, bl, string2, message);
    }

    public void setIccFdnEnabled(boolean bl, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("setIccFdnEnabled", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$setIccFdnEnabled(boolean java.lang.String android.os.Message ), 0, this, bl, string2, message);
    }

    public void changeIccLockPassword(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("changeIccLockPassword", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$changeIccLockPassword(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    public void changeIccFdnPassword(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("changeIccFdnPassword", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$changeIccFdnPassword(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    public boolean isReady() {
        return (boolean)InvokeDynamicSupport.bootstrap("isReady", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$isReady(), 0, this);
    }

    public boolean getIccPin2Blocked() {
        return (boolean)InvokeDynamicSupport.bootstrap("getIccPin2Blocked", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$getIccPin2Blocked(), 0, this);
    }

    public boolean getIccPuk2Blocked() {
        return (boolean)InvokeDynamicSupport.bootstrap("getIccPuk2Blocked", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$getIccPuk2Blocked(), 0, this);
    }

    public int getPhoneId() {
        return (int)InvokeDynamicSupport.bootstrap("getPhoneId", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$getPhoneId(), 0, this);
    }

    public boolean isAppIgnored() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAppIgnored", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$isAppIgnored(), 0, this);
    }

    public void setAppIgnoreState(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAppIgnoreState", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$setAppIgnoreState(boolean ), 0, this, bl);
    }

    protected UiccProfile getUiccProfile() {
        return InvokeDynamicSupport.bootstrap("getUiccProfile", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$getUiccProfile(), 0, this);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$log(java.lang.String ), 0, this, string2);
    }

    private void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$loge(java.lang.String ), 0, this, string2);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_uicc_UiccCardApplication$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    public /* synthetic */ UiccCardApplication() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UiccCardApplication)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

