/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.os.AsyncResult;
import android.os.Binder;
import android.os.Handler;
import android.os.Message;
import android.telephony.Rlog;
import android.telephony.UiccAccessRule;
import android.text.TextUtils;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.uicc.IccIoResult;
import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.telephony.uicc.UiccPkcs15;
import com.android.internal.telephony.uicc.UiccProfile;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class UiccCarrierPrivilegeRules
extends Handler
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "UiccCarrierPrivilegeRules";
    private static boolean DBG = false;
    private static String ARAM_AID = "A00000015141434C00";
    private static String ARAD_AID = "A00000015144414300";
    private static int ARAM = 1;
    private static int ARAD = 0;
    private static int CLA = 128;
    private static int COMMAND = 202;
    private static int P1 = 255;
    private static int P2 = 64;
    private static int P2_EXTENDED_DATA = 96;
    private static int P3 = 0;
    private static String DATA = "";
    private static String TAG_ALL_REF_AR_DO = "FF40";
    private static String TAG_REF_AR_DO = "E2";
    private static String TAG_REF_DO = "E1";
    private static String TAG_DEVICE_APP_ID_REF_DO = "C1";
    private static String TAG_PKG_REF_DO = "CA";
    private static String TAG_AR_DO = "E3";
    private static String TAG_PERM_AR_DO = "DB";
    private static String TAG_AID_REF_DO = "4F";
    private static String CARRIER_PRIVILEGE_AID = "FFFFFFFFFFFF";
    private static int EVENT_OPEN_LOGICAL_CHANNEL_DONE = 1;
    private static int EVENT_TRANSMIT_LOGICAL_CHANNEL_DONE = 2;
    private static int EVENT_CLOSE_LOGICAL_CHANNEL_DONE = 3;
    private static int EVENT_PKCS15_READ_DONE = 4;
    private static int STATE_LOADING = 0;
    private static int STATE_LOADED = 1;
    private static int STATE_ERROR = 2;
    private static int MAX_RETRY = 1;
    private static int RETRY_INTERVAL_MS = 10000;
    private UiccProfile mUiccProfile;
    private UiccPkcs15 mUiccPkcs15;
    private AtomicInteger mState;
    private List<UiccAccessRule> mAccessRules;
    private String mRules;
    private Message mLoadedCallback;
    private String mStatusMessage;
    private int mChannelId;
    private int mRetryCount;
    private boolean mCheckedRules;
    private int mAIDInUse;
    private Runnable mRetryRunnable;

    private final void $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$openChannel(int aidId) {
        String aid = aidId == 0 ? "A00000015144414300" : "A00000015141434C00";
        int p2 = 0;
        this.mUiccProfile.iccOpenLogicalChannel(aid, p2, this.obtainMessage(1, 0, aidId, null));
    }

    private void $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$__constructor__(UiccProfile uiccProfile, Message loadedCallback) {
        this.mCheckedRules = false;
        this.mRetryRunnable = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ UiccCarrierPrivilegeRules this$0;

            private void $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules_1$__constructor__(UiccCarrierPrivilegeRules this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules_1$run() {
                this.this$0.openChannel(this.this$0.mAIDInUse);
            }

            private void __constructor__(UiccCarrierPrivilegeRules uiccCarrierPrivilegeRules) {
                this.$$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules_1$__constructor__(uiccCarrierPrivilegeRules);
            }
            {
                this.this$0 = uiccCarrierPrivilegeRules;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules_1$__constructor__(com.android.internal.telephony.uicc.UiccCarrierPrivilegeRules ), 0, this, uiccCarrierPrivilegeRules);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules_1$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        UiccCarrierPrivilegeRules.log("Creating UiccCarrierPrivilegeRules");
        this.mUiccProfile = uiccProfile;
        this.mState = new AtomicInteger(0);
        this.mStatusMessage = "Not loaded.";
        this.mLoadedCallback = loadedCallback;
        this.mRules = "";
        this.mAccessRules = new ArrayList<UiccAccessRule>();
        this.mAIDInUse = 0;
        this.openChannel(this.mAIDInUse);
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$areCarrierPriviligeRulesLoaded() {
        return this.mState.get() != 0;
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$hasCarrierPrivilegeRules() {
        return this.mState.get() != 0 && this.mAccessRules != null && this.mAccessRules.size() > 0;
    }

    private final List<String> $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$getPackageNames() {
        ArrayList<String> pkgNames = new ArrayList<String>();
        if (this.mAccessRules != null) {
            for (UiccAccessRule ar : this.mAccessRules) {
                if (TextUtils.isEmpty(ar.getPackageName())) continue;
                pkgNames.add(ar.getPackageName());
            }
        }
        return pkgNames;
    }

    private final List<UiccAccessRule> $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$getAccessRules() {
        if (this.mAccessRules == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.mAccessRules);
    }

    private final int $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$getCarrierPrivilegeStatus(Signature signature, String packageName) {
        int state = this.mState.get();
        if (state == 0) {
            return -1;
        }
        if (state == 2) {
            return -2;
        }
        for (UiccAccessRule ar : this.mAccessRules) {
            int accessStatus = ar.getCarrierPrivilegeStatus(signature, packageName);
            if (accessStatus == 0) continue;
            return accessStatus;
        }
        return 0;
    }

    private final int $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$getCarrierPrivilegeStatus(PackageManager packageManager, String packageName) {
        try {
            if (!this.hasCarrierPrivilegeRules()) {
                int state = this.mState.get();
                if (state == 0) {
                    return -1;
                }
                if (state == 2) {
                    return -2;
                }
                return 0;
            }
            PackageInfo pInfo = packageManager.getPackageInfo(packageName, 536903744);
            return this.getCarrierPrivilegeStatus(pInfo);
        }
        catch (PackageManager.NameNotFoundException ex) {
            UiccCarrierPrivilegeRules.log("Package " + packageName + " not found for carrier privilege status check");
            return 0;
        }
    }

    private final int $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$getCarrierPrivilegeStatus(PackageInfo packageInfo) {
        int state = this.mState.get();
        if (state == 0) {
            return -1;
        }
        if (state == 2) {
            return -2;
        }
        for (UiccAccessRule ar : this.mAccessRules) {
            int accessStatus = ar.getCarrierPrivilegeStatus(packageInfo);
            if (accessStatus == 0) continue;
            return accessStatus;
        }
        return 0;
    }

    private final int $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$getCarrierPrivilegeStatusForCurrentTransaction(PackageManager packageManager) {
        return this.getCarrierPrivilegeStatusForUid(packageManager, Binder.getCallingUid());
    }

    private final int $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$getCarrierPrivilegeStatusForUid(PackageManager packageManager, int uid) {
        String[] packages;
        for (String pkg : packages = packageManager.getPackagesForUid(uid)) {
            int accessStatus = this.getCarrierPrivilegeStatus(packageManager, pkg);
            if (accessStatus == 0) continue;
            return accessStatus;
        }
        return 0;
    }

    private final List<String> $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$getCarrierPackageNamesForIntent(PackageManager packageManager, Intent intent) {
        ArrayList<String> packages = new ArrayList<String>();
        ArrayList<ResolveInfo> receivers = new ArrayList<ResolveInfo>();
        receivers.addAll(packageManager.queryBroadcastReceivers(intent, 0));
        receivers.addAll(packageManager.queryIntentContentProviders(intent, 0));
        receivers.addAll(packageManager.queryIntentActivities(intent, 0));
        receivers.addAll(packageManager.queryIntentServices(intent, 0));
        for (ResolveInfo resolveInfo : receivers) {
            String packageName = this.getPackageName(resolveInfo);
            if (packageName == null) continue;
            int status = this.getCarrierPrivilegeStatus(packageManager, packageName);
            if (status == 1) {
                packages.add(packageName);
                continue;
            }
            if (status == 0) continue;
            return null;
        }
        return packages;
    }

    private final String $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$getPackageName(ResolveInfo resolveInfo) {
        if (resolveInfo.activityInfo != null) {
            return resolveInfo.activityInfo.packageName;
        }
        if (resolveInfo.serviceInfo != null) {
            return resolveInfo.serviceInfo.packageName;
        }
        if (resolveInfo.providerInfo != null) {
            return resolveInfo.providerInfo.packageName;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$handleMessage(Message msg) {
        this.mAIDInUse = msg.arg2;
        switch (msg.what) {
            case 1: {
                UiccCarrierPrivilegeRules.log("EVENT_OPEN_LOGICAL_CHANNEL_DONE");
                ar = (AsyncResult)msg.obj;
                if (ar.exception == null && ar.result != null) {
                    this.mChannelId = ((int[])ar.result)[0];
                    this.mUiccProfile.iccTransmitApduLogicalChannel(this.mChannelId, 128, 202, 255, 64, 0, "", this.obtainMessage(2, this.mChannelId, this.mAIDInUse));
                    break;
                }
                if (ar.exception instanceof CommandException && this.mRetryCount < 1 && ((CommandException)ar.exception).getCommandError() == CommandException.Error.MISSING_RESOURCE) {
                    ++this.mRetryCount;
                    this.removeCallbacks(this.mRetryRunnable);
                    this.postDelayed(this.mRetryRunnable, 10000L);
                    break;
                }
                if (this.mAIDInUse == 0) {
                    this.mRules = "";
                    this.openChannel(1);
                }
                if (this.mAIDInUse != 1) break;
                if (this.mCheckedRules) {
                    this.updateState(1, "Success!");
                    break;
                }
                UiccCarrierPrivilegeRules.log("No ARA, try ARF next.");
                this.mUiccPkcs15 = new UiccPkcs15(this.mUiccProfile, this.obtainMessage(4));
                break;
            }
            case 2: {
                UiccCarrierPrivilegeRules.log("EVENT_TRANSMIT_LOGICAL_CHANNEL_DONE");
                ar = (AsyncResult)msg.obj;
                if (ar.exception != null || ar.result == null) ** GOTO lbl52
                response = (IccIoResult)ar.result;
                if (response.sw1 != 144 || response.sw2 != 0 || response.payload == null || response.payload.length <= 0) ** GOTO lbl48
                try {
                    this.mRules = this.mRules + IccUtils.bytesToHexString(response.payload).toUpperCase(Locale.US);
                    if (!this.isDataComplete()) ** GOTO lbl42
                    this.mAccessRules.addAll(UiccCarrierPrivilegeRules.parseRules(this.mRules));
                    if (this.mAIDInUse == 0) {
                        this.mCheckedRules = true;
                    } else {
                        this.updateState(1, "Success!");
                    }
                    ** GOTO lbl54
lbl42:
                    // 1 sources

                    this.mUiccProfile.iccTransmitApduLogicalChannel(this.mChannelId, 128, 202, 255, 96, 0, "", this.obtainMessage(2, this.mChannelId, this.mAIDInUse));
                    break;
                }
                catch (IllegalArgumentException | IndexOutOfBoundsException ex) {
                    if (this.mAIDInUse == 1) {
                        this.updateState(2, "Error parsing rules: " + ex);
                    }
                    ** GOTO lbl54
                }
lbl48:
                // 1 sources

                if (this.mAIDInUse == 1) {
                    errorMsg = "Invalid response: payload=" + response.payload + " sw1=" + response.sw1 + " sw2=" + response.sw2;
                    this.updateState(2, errorMsg);
                }
                ** GOTO lbl54
lbl52:
                // 1 sources

                if (this.mAIDInUse == 1) {
                    this.updateState(2, "Error reading value from SIM.");
                }
lbl54:
                // 7 sources

                this.mUiccProfile.iccCloseLogicalChannel(this.mChannelId, this.obtainMessage(3, 0, this.mAIDInUse));
                this.mChannelId = -1;
                break;
            }
            case 3: {
                UiccCarrierPrivilegeRules.log("EVENT_CLOSE_LOGICAL_CHANNEL_DONE");
                if (this.mAIDInUse != 0) break;
                this.mRules = "";
                this.openChannel(1);
                break;
            }
            case 4: {
                UiccCarrierPrivilegeRules.log("EVENT_PKCS15_READ_DONE");
                if (this.mUiccPkcs15 == null || this.mUiccPkcs15.getRules() == null) {
                    this.updateState(2, "No ARA or ARF.");
                    break;
                }
                for (String cert : this.mUiccPkcs15.getRules()) {
                    accessRule = new UiccAccessRule(IccUtils.hexStringToBytes(cert), "", 0L);
                    this.mAccessRules.add(accessRule);
                }
                this.updateState(1, "Success!");
                break;
            }
            default: {
                Rlog.e("UiccCarrierPrivilegeRules", "Unknown event " + msg.what);
            }
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$isDataComplete() {
        UiccCarrierPrivilegeRules.log("isDataComplete mRules:" + this.mRules);
        if (this.mRules.startsWith("FF40")) {
            TLV allRules = new TLV("FF40");
            String lengthBytes = allRules.parseLength(this.mRules);
            UiccCarrierPrivilegeRules.log("isDataComplete lengthBytes: " + lengthBytes);
            if (this.mRules.length() == "FF40".length() + lengthBytes.length() + allRules.length) {
                UiccCarrierPrivilegeRules.log("isDataComplete yes");
                return true;
            }
            UiccCarrierPrivilegeRules.log("isDataComplete no");
            return false;
        }
        throw new IllegalArgumentException("Tags don't match.");
    }

    private static final List<UiccAccessRule> $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$parseRules(String rules) {
        UiccCarrierPrivilegeRules.log("Got rules: " + rules);
        TLV allRefArDo = new TLV("FF40");
        allRefArDo.parse(rules, true);
        String arDos = allRefArDo.value;
        ArrayList<UiccAccessRule> accessRules = new ArrayList<UiccAccessRule>();
        while (!arDos.isEmpty()) {
            TLV refArDo = new TLV("E2");
            arDos = refArDo.parse(arDos, false);
            UiccAccessRule accessRule = UiccCarrierPrivilegeRules.parseRefArdo(refArDo.value);
            if (accessRule != null) {
                accessRules.add(accessRule);
                continue;
            }
            Rlog.e("UiccCarrierPrivilegeRules", "Skip unrecognized rule." + refArDo.value);
        }
        return accessRules;
    }

    private static final UiccAccessRule $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$parseRefArdo(String rule) {
        UiccCarrierPrivilegeRules.log("Got rule: " + rule);
        String certificateHash = null;
        String packageName = null;
        String tmp = null;
        long accessType = 0L;
        while (!rule.isEmpty()) {
            if (rule.startsWith("E1")) {
                TLV refDo = new TLV("E1");
                rule = refDo.parse(rule, false);
                TLV deviceDo = new TLV("C1");
                if (refDo.value.startsWith("4F")) {
                    TLV cpDo = new TLV("4F");
                    String remain = cpDo.parse(refDo.value, false);
                    if (!cpDo.lengthBytes.equals("06") || !cpDo.value.equals("FFFFFFFFFFFF") || remain.isEmpty() || !remain.startsWith("C1")) {
                        return null;
                    }
                    tmp = deviceDo.parse(remain, false);
                    certificateHash = deviceDo.value;
                } else if (refDo.value.startsWith("C1")) {
                    tmp = deviceDo.parse(refDo.value, false);
                    certificateHash = deviceDo.value;
                } else {
                    return null;
                }
                if (!tmp.isEmpty()) {
                    if (!tmp.startsWith("CA")) {
                        return null;
                    }
                    TLV pkgDo = new TLV("CA");
                    pkgDo.parse(tmp, true);
                    packageName = new String(IccUtils.hexStringToBytes(pkgDo.value));
                    continue;
                }
                packageName = null;
                continue;
            }
            if (rule.startsWith("E3")) {
                TLV arDo = new TLV("E3");
                rule = arDo.parse(rule, false);
                String remain = arDo.value;
                while (!remain.isEmpty() && !remain.startsWith("DB")) {
                    TLV tmpDo = new TLV(remain.substring(0, 2));
                    remain = tmpDo.parse(remain, false);
                }
                if (remain.isEmpty()) {
                    return null;
                }
                TLV permDo = new TLV("DB");
                permDo.parse(remain, true);
                continue;
            }
            throw new RuntimeException("Invalid Rule type");
        }
        UiccAccessRule accessRule = new UiccAccessRule(IccUtils.hexStringToBytes(certificateHash), packageName, accessType);
        return accessRule;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$updateState(int newState, String statusMessage) {
        this.mState.set(newState);
        if (this.mLoadedCallback != null) {
            this.mLoadedCallback.sendToTarget();
        }
        this.mStatusMessage = statusMessage;
    }

    private static final void $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$log(String msg) {
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("UiccCarrierPrivilegeRules: " + this);
        pw.println(" mState=" + this.getStateString(this.mState.get()));
        pw.println(" mStatusMessage='" + this.mStatusMessage + "'");
        if (this.mAccessRules != null) {
            pw.println(" mAccessRules: ");
            for (UiccAccessRule ar : this.mAccessRules) {
                pw.println("  rule='" + ar + "'");
            }
        } else {
            pw.println(" mAccessRules: null");
        }
        if (this.mUiccPkcs15 != null) {
            pw.println(" mUiccPkcs15: " + this.mUiccPkcs15);
            this.mUiccPkcs15.dump(fd, pw, args);
        } else {
            pw.println(" mUiccPkcs15: null");
        }
        pw.flush();
    }

    private final String $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$getStateString(int state) {
        switch (state) {
            case 0: {
                return "STATE_LOADING";
            }
            case 1: {
                return "STATE_LOADED";
            }
            case 2: {
                return "STATE_ERROR";
            }
        }
        return "UNKNOWN";
    }

    private void openChannel(int n) {
        InvokeDynamicSupport.bootstrap("openChannel", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$openChannel(int ), 0, this, n);
    }

    private void __constructor__(UiccProfile uiccProfile, Message message) {
        this.$$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$__constructor__(uiccProfile, message);
    }

    public UiccCarrierPrivilegeRules(UiccProfile uiccProfile, Message message) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$__constructor__(com.android.internal.telephony.uicc.UiccProfile android.os.Message ), 0, this, uiccProfile, message);
    }

    public boolean areCarrierPriviligeRulesLoaded() {
        return (boolean)InvokeDynamicSupport.bootstrap("areCarrierPriviligeRulesLoaded", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$areCarrierPriviligeRulesLoaded(), 0, this);
    }

    public boolean hasCarrierPrivilegeRules() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCarrierPrivilegeRules", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$hasCarrierPrivilegeRules(), 0, this);
    }

    public List<String> getPackageNames() {
        return InvokeDynamicSupport.bootstrap("getPackageNames", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$getPackageNames(), 0, this);
    }

    public List<UiccAccessRule> getAccessRules() {
        return InvokeDynamicSupport.bootstrap("getAccessRules", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$getAccessRules(), 0, this);
    }

    public int getCarrierPrivilegeStatus(Signature signature, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getCarrierPrivilegeStatus", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$getCarrierPrivilegeStatus(android.content.pm.Signature java.lang.String ), 0, this, signature, string2);
    }

    public int getCarrierPrivilegeStatus(PackageManager packageManager, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getCarrierPrivilegeStatus", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$getCarrierPrivilegeStatus(android.content.pm.PackageManager java.lang.String ), 0, this, packageManager, string2);
    }

    public int getCarrierPrivilegeStatus(PackageInfo packageInfo) {
        return (int)InvokeDynamicSupport.bootstrap("getCarrierPrivilegeStatus", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$getCarrierPrivilegeStatus(android.content.pm.PackageInfo ), 0, this, packageInfo);
    }

    public int getCarrierPrivilegeStatusForCurrentTransaction(PackageManager packageManager) {
        return (int)InvokeDynamicSupport.bootstrap("getCarrierPrivilegeStatusForCurrentTransaction", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$getCarrierPrivilegeStatusForCurrentTransaction(android.content.pm.PackageManager ), 0, this, packageManager);
    }

    public int getCarrierPrivilegeStatusForUid(PackageManager packageManager, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getCarrierPrivilegeStatusForUid", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$getCarrierPrivilegeStatusForUid(android.content.pm.PackageManager int ), 0, this, packageManager, n);
    }

    public List<String> getCarrierPackageNamesForIntent(PackageManager packageManager, Intent intent) {
        return InvokeDynamicSupport.bootstrap("getCarrierPackageNamesForIntent", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$getCarrierPackageNamesForIntent(android.content.pm.PackageManager android.content.Intent ), 0, this, packageManager, intent);
    }

    private String getPackageName(ResolveInfo resolveInfo) {
        return InvokeDynamicSupport.bootstrap("getPackageName", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$getPackageName(android.content.pm.ResolveInfo ), 0, this, resolveInfo);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$handleMessage(android.os.Message ), 0, this, message);
    }

    private boolean isDataComplete() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDataComplete", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$isDataComplete(), 0, this);
    }

    private static List<UiccAccessRule> parseRules(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("parseRules", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$parseRules(java.lang.String ), 0, (String)string2);
    }

    private static UiccAccessRule parseRefArdo(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("parseRefArdo", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$parseRefArdo(java.lang.String ), 0, (String)string2);
    }

    private void updateState(int n, String string2) {
        InvokeDynamicSupport.bootstrap("updateState", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$updateState(int java.lang.String ), 0, this, n, string2);
    }

    private static void log(String string2) {
        InvokeDynamicSupport.bootstrapStatic("log", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$log(java.lang.String ), 0, (String)string2);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    private String getStateString(int n) {
        return InvokeDynamicSupport.bootstrap("getStateString", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules$getStateString(int ), 0, this, n);
    }

    public /* synthetic */ UiccCarrierPrivilegeRules() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UiccCarrierPrivilegeRules)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class TLV
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int SINGLE_BYTE_MAX_LENGTH = 128;
        private String tag;
        private String lengthBytes;
        private Integer length;
        private String value;

        private void $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules_TLV$__constructor__(String tag) {
            this.tag = tag;
        }

        private final String $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules_TLV$getValue() {
            if (this.value == null) {
                return "";
            }
            return this.value;
        }

        private final String $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules_TLV$parseLength(String data) {
            int offset = this.tag.length();
            int firstByte = Integer.parseInt(data.substring(offset, offset + 2), 16);
            if (firstByte < 128) {
                this.length = firstByte * 2;
                this.lengthBytes = data.substring(offset, offset + 2);
            } else {
                int numBytes = firstByte - 128;
                this.length = Integer.parseInt(data.substring(offset + 2, offset + 2 + numBytes * 2), 16) * 2;
                this.lengthBytes = data.substring(offset, offset + 2 + numBytes * 2);
            }
            UiccCarrierPrivilegeRules.log("TLV parseLength length=" + this.length + "lenghtBytes: " + this.lengthBytes);
            return this.lengthBytes;
        }

        private final String $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules_TLV$parse(String data, boolean shouldConsumeAll) {
            UiccCarrierPrivilegeRules.log("Parse TLV: " + this.tag);
            if (!data.startsWith(this.tag)) {
                throw new IllegalArgumentException("Tags don't match.");
            }
            int index = this.tag.length();
            if (index + 2 > data.length()) {
                throw new IllegalArgumentException("No length.");
            }
            this.parseLength(data);
            UiccCarrierPrivilegeRules.log("index=" + (index += this.lengthBytes.length()) + " length=" + this.length + "data.length=" + data.length());
            int remainingLength = data.length() - (index + this.length);
            if (remainingLength < 0) {
                throw new IllegalArgumentException("Not enough data.");
            }
            if (shouldConsumeAll && remainingLength != 0) {
                throw new IllegalArgumentException("Did not consume all.");
            }
            this.value = data.substring(index, index + this.length);
            UiccCarrierPrivilegeRules.log("Got TLV: " + this.tag + "," + this.length + "," + this.value);
            return data.substring(index + this.length);
        }

        private void __constructor__(String string2) {
            this.$$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules_TLV$__constructor__(string2);
        }

        public TLV(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules_TLV$__constructor__(java.lang.String ), 0, this, string2);
        }

        public String getValue() {
            return InvokeDynamicSupport.bootstrap("getValue", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules_TLV$getValue(), 0, this);
        }

        public String parseLength(String string2) {
            return InvokeDynamicSupport.bootstrap("parseLength", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules_TLV$parseLength(java.lang.String ), 0, this, string2);
        }

        public String parse(String string2, boolean bl) {
            return InvokeDynamicSupport.bootstrap("parse", $$robo$$com_android_internal_telephony_uicc_UiccCarrierPrivilegeRules_TLV$parse(java.lang.String boolean ), 0, this, string2, bl);
        }

        public /* synthetic */ TLV() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TLV)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

