/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.content.Context;
import android.content.Intent;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.storage.StorageManager;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import android.telephony.TelephonyManager;
import android.util.LocalLog;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.RadioConfig;
import com.android.internal.telephony.SubscriptionInfoUpdater;
import com.android.internal.telephony.uicc.IccCardStatus;
import com.android.internal.telephony.uicc.IccFileHandler;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.IccRefreshResponse;
import com.android.internal.telephony.uicc.IccSlotStatus;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.android.internal.telephony.uicc.UiccProfile;
import com.android.internal.telephony.uicc.UiccSlot;
import com.android.internal.telephony.uicc.UiccStateChangedLauncher;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class UiccController
extends Handler
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DBG = true;
    private static boolean VDBG = false;
    private static String LOG_TAG = "UiccController";
    public static int INVALID_SLOT_ID = -1;
    public static int APP_FAM_3GPP = 1;
    public static int APP_FAM_3GPP2 = 2;
    public static int APP_FAM_IMS = 3;
    private static int EVENT_ICC_STATUS_CHANGED = 1;
    private static int EVENT_SLOT_STATUS_CHANGED = 2;
    private static int EVENT_GET_ICC_STATUS_DONE = 3;
    private static int EVENT_GET_SLOT_STATUS_DONE = 4;
    private static int EVENT_RADIO_ON = 5;
    private static int EVENT_RADIO_AVAILABLE = 6;
    private static int EVENT_RADIO_UNAVAILABLE = 7;
    private static int EVENT_SIM_REFRESH = 8;
    private CommandsInterface[] mCis;
    private UiccSlot[] mUiccSlots;
    private int[] mPhoneIdToSlotId;
    private boolean mIsSlotStatusSupported;
    private static Object mLock;
    private static UiccController mInstance;
    private static ArrayList<IccSlotStatus> sLastSlotStatus;
    private Context mContext;
    protected RegistrantList mIccChangedRegistrants;
    private UiccStateChangedLauncher mLauncher;
    private RadioConfig mRadioConfig;
    static LocalLog sLocalLog;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final UiccController $$robo$$com_android_internal_telephony_uicc_UiccController$make(Context c, CommandsInterface[] ci) {
        Object object = mLock;
        synchronized (object) {
            if (mInstance != null) {
                throw new RuntimeException("UiccController.make() should only be called once");
            }
            mInstance = new UiccController(c, ci);
            return mInstance;
        }
    }

    private void $$robo$$com_android_internal_telephony_uicc_UiccController$__constructor__(Context c, CommandsInterface[] ci) {
        this.mIsSlotStatusSupported = true;
        this.mIccChangedRegistrants = new RegistrantList();
        this.log("Creating UiccController");
        this.mContext = c;
        this.mCis = ci;
        String logStr = "config_num_physical_slots = " + c.getResources().getInteger(17694847);
        this.log(logStr);
        sLocalLog.log(logStr);
        int numPhysicalSlots = c.getResources().getInteger(17694847);
        if (numPhysicalSlots < this.mCis.length) {
            numPhysicalSlots = this.mCis.length;
        }
        this.mUiccSlots = new UiccSlot[numPhysicalSlots];
        this.mPhoneIdToSlotId = new int[ci.length];
        Arrays.fill(this.mPhoneIdToSlotId, -1);
        this.mRadioConfig = RadioConfig.getInstance(this.mContext);
        this.mRadioConfig.registerForSimSlotStatusChanged(this, 2, null);
        for (int i = 0; i < this.mCis.length; ++i) {
            this.mCis[i].registerForIccStatusChanged(this, 1, i);
            if (!StorageManager.inCryptKeeperBounce()) {
                this.mCis[i].registerForAvailable(this, 6, i);
            } else {
                this.mCis[i].registerForOn(this, 5, i);
            }
            this.mCis[i].registerForNotAvailable(this, 7, i);
            this.mCis[i].registerForIccRefresh(this, 8, i);
        }
        this.mLauncher = new UiccStateChangedLauncher(c, this);
    }

    private final int $$robo$$com_android_internal_telephony_uicc_UiccController$getSlotIdFromPhoneId(int phoneId) {
        return this.mPhoneIdToSlotId[phoneId];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final UiccController $$robo$$com_android_internal_telephony_uicc_UiccController$getInstance() {
        Object object = mLock;
        synchronized (object) {
            if (mInstance == null) {
                throw new RuntimeException("UiccController.getInstance can't be called before make()");
            }
            return mInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final UiccCard $$robo$$com_android_internal_telephony_uicc_UiccController$getUiccCard(int phoneId) {
        Object object = mLock;
        synchronized (object) {
            return this.getUiccCardForPhone(phoneId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final UiccCard $$robo$$com_android_internal_telephony_uicc_UiccController$getUiccCardForSlot(int slotId) {
        Object object = mLock;
        synchronized (object) {
            UiccSlot uiccSlot = this.getUiccSlot(slotId);
            if (uiccSlot != null) {
                return uiccSlot.getUiccCard();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final UiccCard $$robo$$com_android_internal_telephony_uicc_UiccController$getUiccCardForPhone(int phoneId) {
        Object object = mLock;
        synchronized (object) {
            UiccSlot uiccSlot;
            if (this.isValidPhoneIndex(phoneId) && (uiccSlot = this.getUiccSlotForPhone(phoneId)) != null) {
                return uiccSlot.getUiccCard();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final UiccProfile $$robo$$com_android_internal_telephony_uicc_UiccController$getUiccProfileForPhone(int phoneId) {
        Object object = mLock;
        synchronized (object) {
            if (this.isValidPhoneIndex(phoneId)) {
                UiccCard uiccCard = this.getUiccCardForPhone(phoneId);
                UiccProfile uiccProfile = uiccCard != null ? uiccCard.getUiccProfile() : null;
                return uiccProfile;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final UiccSlot[] $$robo$$com_android_internal_telephony_uicc_UiccController$getUiccSlots() {
        Object object = mLock;
        synchronized (object) {
            return this.mUiccSlots;
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccController$switchSlots(int[] physicalSlots, Message response) {
        this.mRadioConfig.setSimSlotsMapping(physicalSlots, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final UiccSlot $$robo$$com_android_internal_telephony_uicc_UiccController$getUiccSlot(int slotId) {
        Object object = mLock;
        synchronized (object) {
            if (this.isValidSlotIndex(slotId)) {
                return this.mUiccSlots[slotId];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final UiccSlot $$robo$$com_android_internal_telephony_uicc_UiccController$getUiccSlotForPhone(int phoneId) {
        Object object = mLock;
        synchronized (object) {
            int slotId;
            if (this.isValidPhoneIndex(phoneId) && this.isValidSlotIndex(slotId = this.getSlotIdFromPhoneId(phoneId))) {
                return this.mUiccSlots[slotId];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$com_android_internal_telephony_uicc_UiccController$getUiccSlotForCardId(String cardId) {
        Object object = mLock;
        synchronized (object) {
            int idx;
            for (idx = 0; idx < this.mUiccSlots.length; ++idx) {
                UiccCard uiccCard;
                if (this.mUiccSlots[idx] == null || (uiccCard = this.mUiccSlots[idx].getUiccCard()) == null || !cardId.equals(uiccCard.getCardId())) continue;
                return idx;
            }
            for (idx = 0; idx < this.mUiccSlots.length; ++idx) {
                if (this.mUiccSlots[idx] == null || !cardId.equals(this.mUiccSlots[idx].getIccId())) continue;
                return idx;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IccRecords $$robo$$com_android_internal_telephony_uicc_UiccController$getIccRecords(int phoneId, int family) {
        Object object = mLock;
        synchronized (object) {
            UiccCardApplication app = this.getUiccCardApplication(phoneId, family);
            if (app != null) {
                return app.getIccRecords();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IccFileHandler $$robo$$com_android_internal_telephony_uicc_UiccController$getIccFileHandler(int phoneId, int family) {
        Object object = mLock;
        synchronized (object) {
            UiccCardApplication app = this.getUiccCardApplication(phoneId, family);
            if (app != null) {
                return app.getIccFileHandler();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccController$registerForIccChanged(Handler h, int what, Object obj) {
        Object object = mLock;
        synchronized (object) {
            Registrant r = new Registrant(h, what, obj);
            this.mIccChangedRegistrants.add(r);
            r.notifyRegistrant();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccController$unregisterForIccChanged(Handler h) {
        Object object = mLock;
        synchronized (object) {
            this.mIccChangedRegistrants.remove(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccController$handleMessage(Message msg) {
        Object object = mLock;
        synchronized (object) {
            Integer phoneId = this.getCiIndex(msg);
            if (phoneId < 0 || phoneId >= this.mCis.length) {
                Rlog.e("UiccController", "Invalid phoneId : " + phoneId + " received with event " + msg.what);
                return;
            }
            sLocalLog.log("handleMessage: Received " + msg.what + " for phoneId " + phoneId);
            AsyncResult ar = (AsyncResult)msg.obj;
            switch (msg.what) {
                case 1: {
                    this.log("Received EVENT_ICC_STATUS_CHANGED, calling getIccCardStatus");
                    this.mCis[phoneId].getIccCardStatus(this.obtainMessage(3, phoneId));
                    break;
                }
                case 5: 
                case 6: {
                    this.log("Received EVENT_RADIO_AVAILABLE/EVENT_RADIO_ON, calling getIccCardStatus");
                    this.mCis[phoneId].getIccCardStatus(this.obtainMessage(3, phoneId));
                    if (phoneId != 0) break;
                    this.log("Received EVENT_RADIO_AVAILABLE/EVENT_RADIO_ON for phoneId 0, calling getIccSlotsStatus");
                    this.mRadioConfig.getSimSlotsStatus(this.obtainMessage(4, phoneId));
                    break;
                }
                case 3: {
                    this.log("Received EVENT_GET_ICC_STATUS_DONE");
                    this.onGetIccCardStatusDone(ar, phoneId);
                    break;
                }
                case 2: 
                case 4: {
                    this.log("Received EVENT_SLOT_STATUS_CHANGED or EVENT_GET_SLOT_STATUS_DONE");
                    this.onGetSlotStatusDone(ar);
                    break;
                }
                case 7: {
                    this.log("EVENT_RADIO_UNAVAILABLE, dispose card");
                    UiccSlot uiccSlot = this.getUiccSlotForPhone(phoneId);
                    if (uiccSlot != null) {
                        uiccSlot.onRadioStateUnavailable();
                    }
                    this.mIccChangedRegistrants.notifyRegistrants(new AsyncResult(null, phoneId, null));
                    break;
                }
                case 8: {
                    this.log("Received EVENT_SIM_REFRESH");
                    this.onSimRefresh(ar, phoneId);
                    break;
                }
                default: {
                    Rlog.e("UiccController", " Unknown Event " + msg.what);
                }
            }
        }
    }

    private final Integer $$robo$$com_android_internal_telephony_uicc_UiccController$getCiIndex(Message msg) {
        Integer index = new Integer(0);
        if (msg != null) {
            if (msg.obj != null && msg.obj instanceof Integer) {
                index = (Integer)msg.obj;
            } else if (msg.obj != null && msg.obj instanceof AsyncResult) {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.userObj != null && ar.userObj instanceof Integer) {
                    index = (Integer)ar.userObj;
                }
            }
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final UiccCardApplication $$robo$$com_android_internal_telephony_uicc_UiccController$getUiccCardApplication(int phoneId, int family) {
        Object object = mLock;
        synchronized (object) {
            UiccCard uiccCard = this.getUiccCardForPhone(phoneId);
            if (uiccCard != null) {
                return uiccCard.getApplication(family);
            }
            return null;
        }
    }

    private static final void $$robo$$com_android_internal_telephony_uicc_UiccController$updateInternalIccState(String value, String reason, int phoneId) {
        SubscriptionInfoUpdater subInfoUpdator = PhoneFactory.getSubscriptionInfoUpdater();
        if (subInfoUpdator != null) {
            subInfoUpdator.updateInternalIccState(value, reason, phoneId);
        } else {
            Rlog.e("UiccController", "subInfoUpdate is null.");
        }
    }

    private final synchronized void $$robo$$com_android_internal_telephony_uicc_UiccController$onGetIccCardStatusDone(AsyncResult ar, Integer index) {
        if (ar.exception != null) {
            Rlog.e("UiccController", "Error getting ICC status. RIL_REQUEST_GET_ICC_STATUS should never return an error", ar.exception);
            return;
        }
        if (!this.isValidPhoneIndex(index)) {
            Rlog.e("UiccController", "onGetIccCardStatusDone: invalid index : " + index);
            return;
        }
        IccCardStatus status = (IccCardStatus)ar.result;
        sLocalLog.log("onGetIccCardStatusDone: phoneId " + index + " IccCardStatus: " + status);
        int slotId = status.physicalSlotIndex;
        if (slotId == -1) {
            slotId = index;
        }
        this.mPhoneIdToSlotId[index.intValue()] = slotId;
        if (this.mUiccSlots[slotId] == null) {
            this.mUiccSlots[slotId] = new UiccSlot(this.mContext, true);
        }
        this.mUiccSlots[slotId].update(this.mCis[index], status, index);
        this.log("Notifying IccChangedRegistrants");
        this.mIccChangedRegistrants.notifyRegistrants(new AsyncResult(null, index, null));
    }

    private final synchronized void $$robo$$com_android_internal_telephony_uicc_UiccController$onGetSlotStatusDone(AsyncResult ar) {
        if (!this.mIsSlotStatusSupported) {
            return;
        }
        Throwable e = ar.exception;
        if (e != null) {
            if (!(e instanceof CommandException) || ((CommandException)e).getCommandError() != CommandException.Error.REQUEST_NOT_SUPPORTED) {
                String logStr = "Unexpected error getting slot status: " + ar.exception;
                Rlog.e("UiccController", logStr);
                sLocalLog.log(logStr);
            } else {
                String logStr = "onGetSlotStatusDone: request not supported; marking mIsSlotStatusSupported to false";
                this.log(logStr);
                sLocalLog.log(logStr);
                this.mIsSlotStatusSupported = false;
            }
            return;
        }
        ArrayList status = (ArrayList)ar.result;
        if (!this.slotStatusChanged(status)) {
            this.log("onGetSlotStatusDone: No change in slot status");
            return;
        }
        sLastSlotStatus = status;
        int numActiveSlots = 0;
        for (int i = 0; i < status.size(); ++i) {
            boolean isActive;
            IccSlotStatus iss = (IccSlotStatus)status.get(i);
            boolean bl = isActive = iss.slotState == IccSlotStatus.SlotState.SLOTSTATE_ACTIVE;
            if (isActive) {
                ++numActiveSlots;
                if (!this.isValidPhoneIndex(iss.logicalSlotIndex)) {
                    throw new RuntimeException("Logical slot index " + iss.logicalSlotIndex + " invalid for physical slot " + i);
                }
                this.mPhoneIdToSlotId[iss.logicalSlotIndex] = i;
            }
            if (this.mUiccSlots[i] == null) {
                this.mUiccSlots[i] = new UiccSlot(this.mContext, isActive);
            }
            this.mUiccSlots[i].update(isActive ? this.mCis[iss.logicalSlotIndex] : null, iss);
        }
        if (numActiveSlots != this.mPhoneIdToSlotId.length) {
            throw new RuntimeException("Number of active slots " + numActiveSlots + " does not match the expected value " + this.mPhoneIdToSlotId.length);
        }
        HashSet<Integer> slotIds = new HashSet<Integer>();
        for (Object slotId : (IccSlotStatus)this.mPhoneIdToSlotId) {
            if (slotIds.contains((int)slotId)) {
                throw new RuntimeException("slotId " + (int)slotId + " mapped to multiple phoneIds");
            }
            slotIds.add((int)slotId);
        }
        Intent intent = new Intent("android.telephony.action.SIM_SLOT_STATUS_CHANGED");
        intent.addFlags(0x4000000);
        intent.addFlags(0x1000000);
        this.mContext.sendBroadcast(intent, "android.permission.READ_PRIVILEGED_PHONE_STATE");
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccController$slotStatusChanged(ArrayList<IccSlotStatus> slotStatusList) {
        if (sLastSlotStatus == null || sLastSlotStatus.size() != slotStatusList.size()) {
            return true;
        }
        for (IccSlotStatus iccSlotStatus : slotStatusList) {
            if (sLastSlotStatus.contains(iccSlotStatus)) continue;
            return true;
        }
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccController$logPhoneIdToSlotIdMapping() {
        this.log("mPhoneIdToSlotId mapping:");
        for (int i = 0; i < this.mPhoneIdToSlotId.length; ++i) {
            this.log("    phoneId " + i + " slotId " + this.mPhoneIdToSlotId[i]);
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccController$onSimRefresh(AsyncResult ar, Integer index) {
        if (ar.exception != null) {
            Rlog.e("UiccController", "onSimRefresh: Sim REFRESH with exception: " + ar.exception);
            return;
        }
        if (!this.isValidPhoneIndex(index)) {
            Rlog.e("UiccController", "onSimRefresh: invalid index : " + index);
            return;
        }
        IccRefreshResponse resp = (IccRefreshResponse)ar.result;
        this.log("onSimRefresh: " + resp);
        sLocalLog.log("onSimRefresh: " + resp);
        if (resp == null) {
            Rlog.e("UiccController", "onSimRefresh: received without input");
            return;
        }
        UiccCard uiccCard = this.getUiccCardForPhone(index);
        if (uiccCard == null) {
            Rlog.e("UiccController", "onSimRefresh: refresh on null card : " + index);
            return;
        }
        boolean changed = false;
        switch (resp.refreshResult) {
            case 2: {
                changed = uiccCard.resetAppWithAid(resp.aid, true);
                break;
            }
            case 1: {
                changed = uiccCard.resetAppWithAid(resp.aid, false);
                break;
            }
            default: {
                return;
            }
        }
        if (changed && resp.refreshResult == 2) {
            CarrierConfigManager configManager = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
            configManager.updateConfigForPhoneId(index, "UNKNOWN");
            boolean requirePowerOffOnSimRefreshReset = this.mContext.getResources().getBoolean(17957010);
            if (requirePowerOffOnSimRefreshReset) {
                this.mCis[index].setRadioPower(false, null);
            }
        }
        this.mCis[index].getIccCardStatus(this.obtainMessage(3, index));
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccController$isValidPhoneIndex(int index) {
        return index >= 0 && index < TelephonyManager.getDefault().getPhoneCount();
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccController$isValidSlotIndex(int index) {
        return index >= 0 && index < this.mUiccSlots.length;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccController$log(String string2) {
        Rlog.d("UiccController", string2);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccController$addCardLog(String data) {
        sLocalLog.log(data);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccController$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        int i;
        pw.println("UiccController: " + this);
        pw.println(" mContext=" + this.mContext);
        pw.println(" mInstance=" + mInstance);
        pw.println(" mIccChangedRegistrants: size=" + this.mIccChangedRegistrants.size());
        for (i = 0; i < this.mIccChangedRegistrants.size(); ++i) {
            pw.println("  mIccChangedRegistrants[" + i + "]=" + ((Registrant)this.mIccChangedRegistrants.get(i)).getHandler());
        }
        pw.println();
        pw.flush();
        pw.println(" mUiccSlots: size=" + this.mUiccSlots.length);
        for (i = 0; i < this.mUiccSlots.length; ++i) {
            if (this.mUiccSlots[i] == null) {
                pw.println("  mUiccSlots[" + i + "]=null");
                continue;
            }
            pw.println("  mUiccSlots[" + i + "]=" + this.mUiccSlots[i]);
            this.mUiccSlots[i].dump(fd, pw, args);
        }
        pw.println(" sLocalLog= ");
        sLocalLog.dump(fd, pw, args);
    }

    static void __staticInitializer__() {
        mLock = new Object();
        sLocalLog = new LocalLog(100);
    }

    public static UiccController make(Context context, CommandsInterface[] commandsInterfaceArray) {
        return InvokeDynamicSupport.bootstrapStatic("make", $$robo$$com_android_internal_telephony_uicc_UiccController$make(android.content.Context com.android.internal.telephony.CommandsInterface[] ), 0, (Context)context, (CommandsInterface[])commandsInterfaceArray);
    }

    private void __constructor__(Context context, CommandsInterface[] commandsInterfaceArray) {
        this.$$robo$$com_android_internal_telephony_uicc_UiccController$__constructor__(context, commandsInterfaceArray);
    }

    private UiccController(Context context, CommandsInterface[] commandsInterfaceArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_UiccController$__constructor__(android.content.Context com.android.internal.telephony.CommandsInterface[] ), 0, this, context, commandsInterfaceArray);
    }

    private int getSlotIdFromPhoneId(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getSlotIdFromPhoneId", $$robo$$com_android_internal_telephony_uicc_UiccController$getSlotIdFromPhoneId(int ), 0, this, n);
    }

    public static UiccController getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$com_android_internal_telephony_uicc_UiccController$getInstance(), 0);
    }

    public UiccCard getUiccCard(int n) {
        return InvokeDynamicSupport.bootstrap("getUiccCard", $$robo$$com_android_internal_telephony_uicc_UiccController$getUiccCard(int ), 0, this, n);
    }

    public UiccCard getUiccCardForSlot(int n) {
        return InvokeDynamicSupport.bootstrap("getUiccCardForSlot", $$robo$$com_android_internal_telephony_uicc_UiccController$getUiccCardForSlot(int ), 0, this, n);
    }

    public UiccCard getUiccCardForPhone(int n) {
        return InvokeDynamicSupport.bootstrap("getUiccCardForPhone", $$robo$$com_android_internal_telephony_uicc_UiccController$getUiccCardForPhone(int ), 0, this, n);
    }

    public UiccProfile getUiccProfileForPhone(int n) {
        return InvokeDynamicSupport.bootstrap("getUiccProfileForPhone", $$robo$$com_android_internal_telephony_uicc_UiccController$getUiccProfileForPhone(int ), 0, this, n);
    }

    public UiccSlot[] getUiccSlots() {
        return InvokeDynamicSupport.bootstrap("getUiccSlots", $$robo$$com_android_internal_telephony_uicc_UiccController$getUiccSlots(), 0, this);
    }

    public void switchSlots(int[] nArray, Message message) {
        InvokeDynamicSupport.bootstrap("switchSlots", $$robo$$com_android_internal_telephony_uicc_UiccController$switchSlots(int[] android.os.Message ), 0, this, nArray, message);
    }

    public UiccSlot getUiccSlot(int n) {
        return InvokeDynamicSupport.bootstrap("getUiccSlot", $$robo$$com_android_internal_telephony_uicc_UiccController$getUiccSlot(int ), 0, this, n);
    }

    public UiccSlot getUiccSlotForPhone(int n) {
        return InvokeDynamicSupport.bootstrap("getUiccSlotForPhone", $$robo$$com_android_internal_telephony_uicc_UiccController$getUiccSlotForPhone(int ), 0, this, n);
    }

    public int getUiccSlotForCardId(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getUiccSlotForCardId", $$robo$$com_android_internal_telephony_uicc_UiccController$getUiccSlotForCardId(java.lang.String ), 0, this, string2);
    }

    public IccRecords getIccRecords(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getIccRecords", $$robo$$com_android_internal_telephony_uicc_UiccController$getIccRecords(int int ), 0, this, n, n2);
    }

    public IccFileHandler getIccFileHandler(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getIccFileHandler", $$robo$$com_android_internal_telephony_uicc_UiccController$getIccFileHandler(int int ), 0, this, n, n2);
    }

    public void registerForIccChanged(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForIccChanged", $$robo$$com_android_internal_telephony_uicc_UiccController$registerForIccChanged(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForIccChanged(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForIccChanged", $$robo$$com_android_internal_telephony_uicc_UiccController$unregisterForIccChanged(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_uicc_UiccController$handleMessage(android.os.Message ), 0, this, message);
    }

    private Integer getCiIndex(Message message) {
        return InvokeDynamicSupport.bootstrap("getCiIndex", $$robo$$com_android_internal_telephony_uicc_UiccController$getCiIndex(android.os.Message ), 0, this, message);
    }

    public UiccCardApplication getUiccCardApplication(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getUiccCardApplication", $$robo$$com_android_internal_telephony_uicc_UiccController$getUiccCardApplication(int int ), 0, this, n, n2);
    }

    static void updateInternalIccState(String string2, String string3, int n) {
        InvokeDynamicSupport.bootstrapStatic("updateInternalIccState", $$robo$$com_android_internal_telephony_uicc_UiccController$updateInternalIccState(java.lang.String java.lang.String int ), 0, (String)string2, (String)string3, (int)n);
    }

    private synchronized void onGetIccCardStatusDone(AsyncResult asyncResult, Integer n) {
        InvokeDynamicSupport.bootstrap("onGetIccCardStatusDone", $$robo$$com_android_internal_telephony_uicc_UiccController$onGetIccCardStatusDone(android.os.AsyncResult java.lang.Integer ), 0, this, asyncResult, n);
    }

    private synchronized void onGetSlotStatusDone(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("onGetSlotStatusDone", $$robo$$com_android_internal_telephony_uicc_UiccController$onGetSlotStatusDone(android.os.AsyncResult ), 0, this, asyncResult);
    }

    private boolean slotStatusChanged(ArrayList<IccSlotStatus> arrayList) {
        return (boolean)InvokeDynamicSupport.bootstrap("slotStatusChanged", $$robo$$com_android_internal_telephony_uicc_UiccController$slotStatusChanged(java.util.ArrayList<com.android.internal.telephony.uicc.IccSlotStatus> ), 0, this, arrayList);
    }

    private void logPhoneIdToSlotIdMapping() {
        InvokeDynamicSupport.bootstrap("logPhoneIdToSlotIdMapping", $$robo$$com_android_internal_telephony_uicc_UiccController$logPhoneIdToSlotIdMapping(), 0, this);
    }

    private void onSimRefresh(AsyncResult asyncResult, Integer n) {
        InvokeDynamicSupport.bootstrap("onSimRefresh", $$robo$$com_android_internal_telephony_uicc_UiccController$onSimRefresh(android.os.AsyncResult java.lang.Integer ), 0, this, asyncResult, n);
    }

    private boolean isValidPhoneIndex(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isValidPhoneIndex", $$robo$$com_android_internal_telephony_uicc_UiccController$isValidPhoneIndex(int ), 0, this, n);
    }

    private boolean isValidSlotIndex(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isValidSlotIndex", $$robo$$com_android_internal_telephony_uicc_UiccController$isValidSlotIndex(int ), 0, this, n);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_uicc_UiccController$log(java.lang.String ), 0, this, string2);
    }

    public void addCardLog(String string2) {
        InvokeDynamicSupport.bootstrap("addCardLog", $$robo$$com_android_internal_telephony_uicc_UiccController$addCardLog(java.lang.String ), 0, this, string2);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_uicc_UiccController$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    static {
        RobolectricInternals.classInitializing(UiccController.class);
    }

    public /* synthetic */ UiccController() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UiccController)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

