/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.telephony.Rlog;
import com.android.internal.telephony.uicc.IccException;
import com.android.internal.telephony.uicc.IccIoResult;
import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.telephony.uicc.UiccCarrierPrivilegeRules;
import com.android.internal.telephony.uicc.UiccProfile;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class UiccPkcs15
extends Handler
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "UiccPkcs15";
    private static boolean DBG = true;
    private UiccProfile mUiccProfile;
    private Message mLoadedCallback;
    private int mChannelId;
    private List<String> mRules;
    private Pkcs15Selector mPkcs15Selector;
    private FileHandler mFh;
    private static int EVENT_SELECT_PKCS15_DONE = 1;
    private static int EVENT_LOAD_ODF_DONE = 2;
    private static int EVENT_LOAD_DODF_DONE = 3;
    private static int EVENT_LOAD_ACMF_DONE = 4;
    private static int EVENT_LOAD_ACRF_DONE = 5;
    private static int EVENT_LOAD_ACCF_DONE = 6;
    private static int EVENT_CLOSE_LOGICAL_CHANNEL_DONE = 7;
    private static String CARRIER_RULE_AID = "FFFFFFFFFFFF";
    private static String ID_ACRF = "4300";
    private static String TAG_ASN_SEQUENCE = "30";
    private static String TAG_ASN_OCTET_STRING = "04";
    private static String TAG_TARGET_AID = "A0";

    private void $$robo$$com_android_internal_telephony_uicc_UiccPkcs15$__constructor__(UiccProfile uiccProfile, Message loadedCallback) {
        this.mChannelId = -1;
        this.mRules = new ArrayList<String>();
        UiccPkcs15.log("Creating UiccPkcs15");
        this.mUiccProfile = uiccProfile;
        this.mLoadedCallback = loadedCallback;
        this.mPkcs15Selector = new Pkcs15Selector(this, this.obtainMessage(1));
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccPkcs15$handleMessage(Message msg) {
        UiccPkcs15.log("handleMessage: " + msg.what);
        AsyncResult ar = (AsyncResult)msg.obj;
        switch (msg.what) {
            case 1: {
                if (ar.exception == null) {
                    this.mFh = new FileHandler(this, (String)ar.result);
                    if (this.mFh.loadFile("4300", this.obtainMessage(5))) break;
                    this.cleanUp();
                    break;
                }
                UiccPkcs15.log("select pkcs15 failed: " + ar.exception);
                this.mLoadedCallback.sendToTarget();
                break;
            }
            case 5: {
                if (ar.exception == null && ar.result != null) {
                    String idAccf = this.parseAcrf((String)ar.result);
                    if (this.mFh.loadFile(idAccf, this.obtainMessage(6))) break;
                    this.cleanUp();
                    break;
                }
                this.cleanUp();
                break;
            }
            case 6: {
                if (ar.exception == null && ar.result != null) {
                    this.parseAccf((String)ar.result);
                }
                this.cleanUp();
                break;
            }
            case 7: {
                break;
            }
            default: {
                Rlog.e("UiccPkcs15", "Unknown event " + msg.what);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccPkcs15$cleanUp() {
        UiccPkcs15.log("cleanUp");
        if (this.mChannelId >= 0) {
            this.mUiccProfile.iccCloseLogicalChannel(this.mChannelId, this.obtainMessage(7));
            this.mChannelId = -1;
        }
        this.mLoadedCallback.sendToTarget();
    }

    private final String $$robo$$com_android_internal_telephony_uicc_UiccPkcs15$parseAcrf(String data) {
        String ret = null;
        String acRules = data;
        while (!acRules.isEmpty()) {
            UiccCarrierPrivilegeRules.TLV tlvRule = new UiccCarrierPrivilegeRules.TLV("30");
            try {
                acRules = tlvRule.parse(acRules, false);
                String ruleString = tlvRule.getValue();
                if (!ruleString.startsWith("A0")) continue;
                UiccCarrierPrivilegeRules.TLV tlvTarget = new UiccCarrierPrivilegeRules.TLV("A0");
                UiccCarrierPrivilegeRules.TLV tlvAid = new UiccCarrierPrivilegeRules.TLV("04");
                UiccCarrierPrivilegeRules.TLV tlvAsnPath = new UiccCarrierPrivilegeRules.TLV("30");
                UiccCarrierPrivilegeRules.TLV tlvPath = new UiccCarrierPrivilegeRules.TLV("04");
                ruleString = tlvTarget.parse(ruleString, false);
                tlvAid.parse(tlvTarget.getValue(), true);
                if (!"FFFFFFFFFFFF".equals(tlvAid.getValue())) continue;
                tlvAsnPath.parse(ruleString, true);
                tlvPath.parse(tlvAsnPath.getValue(), true);
                ret = tlvPath.getValue();
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException ex) {
                UiccPkcs15.log("Error: " + ex);
                break;
            }
        }
        return ret;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccPkcs15$parseAccf(String data) {
        String acCondition = data;
        while (!acCondition.isEmpty()) {
            UiccCarrierPrivilegeRules.TLV tlvCondition = new UiccCarrierPrivilegeRules.TLV("30");
            UiccCarrierPrivilegeRules.TLV tlvCert = new UiccCarrierPrivilegeRules.TLV("04");
            try {
                acCondition = tlvCondition.parse(acCondition, false);
                tlvCert.parse(tlvCondition.getValue(), true);
                if (tlvCert.getValue().isEmpty()) continue;
                this.mRules.add(tlvCert.getValue());
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException ex) {
                UiccPkcs15.log("Error: " + ex);
                break;
            }
        }
    }

    private final List<String> $$robo$$com_android_internal_telephony_uicc_UiccPkcs15$getRules() {
        return this.mRules;
    }

    private static final void $$robo$$com_android_internal_telephony_uicc_UiccPkcs15$log(String msg) {
        Rlog.d("UiccPkcs15", msg);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccPkcs15$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mRules != null) {
            pw.println(" mRules:");
            for (String cert : this.mRules) {
                pw.println("  " + cert);
            }
        }
    }

    private void __constructor__(UiccProfile uiccProfile, Message message) {
        this.$$robo$$com_android_internal_telephony_uicc_UiccPkcs15$__constructor__(uiccProfile, message);
    }

    public UiccPkcs15(UiccProfile uiccProfile, Message message) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_UiccPkcs15$__constructor__(com.android.internal.telephony.uicc.UiccProfile android.os.Message ), 0, this, uiccProfile, message);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_uicc_UiccPkcs15$handleMessage(android.os.Message ), 0, this, message);
    }

    private void cleanUp() {
        InvokeDynamicSupport.bootstrap("cleanUp", $$robo$$com_android_internal_telephony_uicc_UiccPkcs15$cleanUp(), 0, this);
    }

    private String parseAcrf(String string2) {
        return InvokeDynamicSupport.bootstrap("parseAcrf", $$robo$$com_android_internal_telephony_uicc_UiccPkcs15$parseAcrf(java.lang.String ), 0, this, string2);
    }

    private void parseAccf(String string2) {
        InvokeDynamicSupport.bootstrap("parseAccf", $$robo$$com_android_internal_telephony_uicc_UiccPkcs15$parseAccf(java.lang.String ), 0, this, string2);
    }

    public List<String> getRules() {
        return InvokeDynamicSupport.bootstrap("getRules", $$robo$$com_android_internal_telephony_uicc_UiccPkcs15$getRules(), 0, this);
    }

    private static void log(String string2) {
        InvokeDynamicSupport.bootstrapStatic("log", $$robo$$com_android_internal_telephony_uicc_UiccPkcs15$log(java.lang.String ), 0, (String)string2);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_uicc_UiccPkcs15$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    public /* synthetic */ UiccPkcs15() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UiccPkcs15)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class Pkcs15Selector
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String PKCS15_AID = "A000000063504B43532D3135";
        private Message mCallback;
        private static int EVENT_OPEN_LOGICAL_CHANNEL_DONE = 201;
        /* synthetic */ UiccPkcs15 this$0;

        private void $$robo$$com_android_internal_telephony_uicc_UiccPkcs15_Pkcs15Selector$__constructor__(UiccPkcs15 uiccPkcs15, Message callBack) {
            this.mCallback = callBack;
            int p2 = 4;
            uiccPkcs15.mUiccProfile.iccOpenLogicalChannel("A000000063504B43532D3135", p2, this.obtainMessage(201));
        }

        private final void $$robo$$com_android_internal_telephony_uicc_UiccPkcs15_Pkcs15Selector$handleMessage(Message msg) {
            UiccPkcs15.log("handleMessage: " + msg.what);
            switch (msg.what) {
                case 201: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception == null && ar.result != null) {
                        this.this$0.mChannelId = ((int[])ar.result)[0];
                        UiccPkcs15.log("mChannelId: " + this.this$0.mChannelId);
                        AsyncResult.forMessage(this.mCallback, null, null);
                    } else {
                        UiccPkcs15.log("error: " + ar.exception);
                        AsyncResult.forMessage(this.mCallback, null, ar.exception);
                    }
                    this.mCallback.sendToTarget();
                    break;
                }
                default: {
                    UiccPkcs15.log("Unknown event" + msg.what);
                }
            }
        }

        private void __constructor__(UiccPkcs15 uiccPkcs15, Message message) {
            this.$$robo$$com_android_internal_telephony_uicc_UiccPkcs15_Pkcs15Selector$__constructor__(uiccPkcs15, message);
        }

        public Pkcs15Selector(UiccPkcs15 uiccPkcs15, Message message) {
            this.this$0 = uiccPkcs15;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_UiccPkcs15_Pkcs15Selector$__constructor__(com.android.internal.telephony.uicc.UiccPkcs15 android.os.Message ), 0, this, uiccPkcs15, message);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_uicc_UiccPkcs15_Pkcs15Selector$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ Pkcs15Selector() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Pkcs15Selector)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class FileHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String mPkcs15Path;
        private Message mCallback;
        private String mFileId;
        protected static int EVENT_SELECT_FILE_DONE = 101;
        protected static int EVENT_READ_BINARY_DONE = 102;
        /* synthetic */ UiccPkcs15 this$0;

        private void $$robo$$com_android_internal_telephony_uicc_UiccPkcs15_FileHandler$__constructor__(UiccPkcs15 uiccPkcs15, String pkcs15Path) {
            UiccPkcs15.log("Creating FileHandler, pkcs15Path: " + pkcs15Path);
            this.mPkcs15Path = pkcs15Path;
        }

        private final boolean $$robo$$com_android_internal_telephony_uicc_UiccPkcs15_FileHandler$loadFile(String fileId, Message callBack) {
            UiccPkcs15.log("loadFile: " + fileId);
            if (fileId == null || callBack == null) {
                return false;
            }
            this.mFileId = fileId;
            this.mCallback = callBack;
            this.selectFile();
            return true;
        }

        private final void $$robo$$com_android_internal_telephony_uicc_UiccPkcs15_FileHandler$selectFile() {
            if (this.this$0.mChannelId >= 0) {
                this.this$0.mUiccProfile.iccTransmitApduLogicalChannel(this.this$0.mChannelId, 0, 164, 0, 4, 2, this.mFileId, this.obtainMessage(101));
            } else {
                UiccPkcs15.log("EF based");
            }
        }

        private final void $$robo$$com_android_internal_telephony_uicc_UiccPkcs15_FileHandler$readBinary() {
            if (this.this$0.mChannelId >= 0) {
                this.this$0.mUiccProfile.iccTransmitApduLogicalChannel(this.this$0.mChannelId, 0, 176, 0, 0, 0, "", this.obtainMessage(102));
            } else {
                UiccPkcs15.log("EF based");
            }
        }

        private final void $$robo$$com_android_internal_telephony_uicc_UiccPkcs15_FileHandler$handleMessage(Message msg) {
            UiccPkcs15.log("handleMessage: " + msg.what);
            AsyncResult ar = (AsyncResult)msg.obj;
            if (ar.exception != null || ar.result == null) {
                UiccPkcs15.log("Error: " + ar.exception);
                AsyncResult.forMessage(this.mCallback, null, ar.exception);
                this.mCallback.sendToTarget();
                return;
            }
            switch (msg.what) {
                case 101: {
                    this.readBinary();
                    break;
                }
                case 102: {
                    IccIoResult response = (IccIoResult)ar.result;
                    String result = IccUtils.bytesToHexString(response.payload).toUpperCase(Locale.US);
                    UiccPkcs15.log("IccIoResult: " + response + " payload: " + result);
                    AsyncResult.forMessage(this.mCallback, result, result == null ? new IccException("Error: null response for " + this.mFileId) : null);
                    this.mCallback.sendToTarget();
                    break;
                }
                default: {
                    UiccPkcs15.log("Unknown event" + msg.what);
                }
            }
        }

        private void __constructor__(UiccPkcs15 uiccPkcs15, String string2) {
            this.$$robo$$com_android_internal_telephony_uicc_UiccPkcs15_FileHandler$__constructor__(uiccPkcs15, string2);
        }

        public FileHandler(UiccPkcs15 uiccPkcs15, String string2) {
            this.this$0 = uiccPkcs15;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_UiccPkcs15_FileHandler$__constructor__(com.android.internal.telephony.uicc.UiccPkcs15 java.lang.String ), 0, this, uiccPkcs15, string2);
        }

        public boolean loadFile(String string2, Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("loadFile", $$robo$$com_android_internal_telephony_uicc_UiccPkcs15_FileHandler$loadFile(java.lang.String android.os.Message ), 0, this, string2, message);
        }

        private void selectFile() {
            InvokeDynamicSupport.bootstrap("selectFile", $$robo$$com_android_internal_telephony_uicc_UiccPkcs15_FileHandler$selectFile(), 0, this);
        }

        private void readBinary() {
            InvokeDynamicSupport.bootstrap("readBinary", $$robo$$com_android_internal_telephony_uicc_UiccPkcs15_FileHandler$readBinary(), 0, this);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_uicc_UiccPkcs15_FileHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ FileHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FileHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

