/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.app.usage.UsageStatsManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Binder;
import android.os.Handler;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.Registrant;
import android.os.RegistrantList;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.telephony.UiccAccessRule;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.IccCardConstants;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.cat.CatService;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccCardStatus;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.InstallCarrierAppTrampolineActivity;
import com.android.internal.telephony.uicc.InstallCarrierAppUtils;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.android.internal.telephony.uicc.UiccCarrierPrivilegeRules;
import com.android.internal.telephony.uicc.UiccController;
import com.android.internal.telephony.uicc.euicc.EuiccCard;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class UiccProfile
extends IccCard
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    protected static String LOG_TAG = "UiccProfile";
    protected static boolean DBG = true;
    private static boolean VDBG = false;
    private static String OPERATOR_BRAND_OVERRIDE_PREFIX = "operator_branding_";
    private Object mLock;
    private IccCardStatus.PinState mUniversalPinState;
    private int mGsmUmtsSubscriptionAppIndex;
    private int mCdmaSubscriptionAppIndex;
    private int mImsSubscriptionAppIndex;
    private UiccCardApplication[] mUiccApplications;
    private Context mContext;
    private CommandsInterface mCi;
    private UiccCard mUiccCard;
    private CatService mCatService;
    private UiccCarrierPrivilegeRules mCarrierPrivilegeRules;
    private boolean mDisposed;
    private RegistrantList mCarrierPrivilegeRegistrants;
    private RegistrantList mOperatorBrandOverrideRegistrants;
    private int mPhoneId;
    private static int EVENT_RADIO_OFF_OR_UNAVAILABLE = 1;
    private static int EVENT_ICC_LOCKED = 2;
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public static int EVENT_APP_READY = 3;
    private static int EVENT_RECORDS_LOADED = 4;
    private static int EVENT_NETWORK_LOCKED = 5;
    private static int EVENT_EID_READY = 6;
    private static int EVENT_ICC_RECORD_EVENTS = 7;
    private static int EVENT_OPEN_LOGICAL_CHANNEL_DONE = 8;
    private static int EVENT_CLOSE_LOGICAL_CHANNEL_DONE = 9;
    private static int EVENT_TRANSMIT_APDU_LOGICAL_CHANNEL_DONE = 10;
    private static int EVENT_TRANSMIT_APDU_BASIC_CHANNEL_DONE = 11;
    private static int EVENT_SIM_IO_DONE = 12;
    private static int EVENT_CARRIER_PRIVILEGES_LOADED = 13;
    private static int EVENT_CARRIER_CONFIG_CHANGED = 14;
    private TelephonyManager mTelephonyManager;
    private RegistrantList mNetworkLockedRegistrants;
    private int mCurrentAppType;
    private UiccCardApplication mUiccApplication;
    private IccRecords mIccRecords;
    private IccCardConstants.State mExternalState;
    private ContentObserver mProvisionCompleteContentObserver;
    private BroadcastReceiver mReceiver;
    @VisibleForTesting
    public Handler mHandler;

    private void $$robo$$com_android_internal_telephony_uicc_UiccProfile$__constructor__(Context c, CommandsInterface ci, IccCardStatus ics, int phoneId, UiccCard uiccCard, Object lock) {
        this.mUiccApplications = new UiccCardApplication[8];
        this.mDisposed = false;
        this.mCarrierPrivilegeRegistrants = new RegistrantList();
        this.mOperatorBrandOverrideRegistrants = new RegistrantList();
        this.mNetworkLockedRegistrants = new RegistrantList();
        this.mCurrentAppType = 1;
        this.mUiccApplication = null;
        this.mIccRecords = null;
        this.mExternalState = IccCardConstants.State.UNKNOWN;
        this.mProvisionCompleteContentObserver = new ShadowedObject(this, new Handler()){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ UiccProfile this$0;

            private void $$robo$$com_android_internal_telephony_uicc_UiccProfile_1$__constructor__(UiccProfile this$0, Handler x0) {
            }

            private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile_1$onChange(boolean selfChange) {
                this.this$0.mContext.getContentResolver().unregisterContentObserver(this);
                for (String pkgName : this.this$0.getUninstalledCarrierPackages()) {
                    InstallCarrierAppUtils.showNotification(this.this$0.mContext, pkgName);
                    InstallCarrierAppUtils.registerPackageInstallReceiver(this.this$0.mContext);
                }
            }

            private void __constructor__(UiccProfile uiccProfile, Handler handler) {
                this.$$robo$$com_android_internal_telephony_uicc_UiccProfile_1$__constructor__(uiccProfile, handler);
            }
            {
                this.this$0 = uiccProfile;
                super(handler);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_UiccProfile_1$__constructor__(com.android.internal.telephony.uicc.UiccProfile android.os.Handler ), 0, this, uiccProfile, handler);
            }

            @Override
            public void onChange(boolean bl) {
                InvokeDynamicSupport.bootstrap("onChange", $$robo$$com_android_internal_telephony_uicc_UiccProfile_1$onChange(boolean ), 0, this, bl);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mReceiver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ UiccProfile this$0;

            private void $$robo$$com_android_internal_telephony_uicc_UiccProfile_2$__constructor__(UiccProfile this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile_2$onReceive(Context context, Intent intent) {
                if (intent.getAction().equals("android.telephony.action.CARRIER_CONFIG_CHANGED")) {
                    this.this$0.mHandler.sendMessage(this.this$0.mHandler.obtainMessage(14));
                }
            }

            private void __constructor__(UiccProfile uiccProfile) {
                this.$$robo$$com_android_internal_telephony_uicc_UiccProfile_2$__constructor__(uiccProfile);
            }
            {
                this.this$0 = uiccProfile;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_UiccProfile_2$__constructor__(com.android.internal.telephony.uicc.UiccProfile ), 0, this, uiccProfile);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_uicc_UiccProfile_2$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mHandler = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ UiccProfile this$0;

            private void $$robo$$com_android_internal_telephony_uicc_UiccProfile_3$__constructor__(UiccProfile this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile_3$handleMessage(Message msg) {
                if (this.this$0.mDisposed && msg.what != 8 && msg.what != 9 && msg.what != 10 && msg.what != 11 && msg.what != 12) {
                    UiccProfile.loge("handleMessage: Received " + msg.what + " after dispose(); ignoring the message");
                    return;
                }
                this.this$0.loglocal("handleMessage: Received " + msg.what + " for phoneId " + this.this$0.mPhoneId);
                switch (msg.what) {
                    case 5: {
                        this.this$0.mNetworkLockedRegistrants.notifyRegistrants();
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: {
                        this.this$0.updateExternalState();
                        break;
                    }
                    case 7: {
                        if (this.this$0.mCurrentAppType != 1 || this.this$0.mIccRecords == null) break;
                        AsyncResult ar = (AsyncResult)msg.obj;
                        int eventCode = (Integer)ar.result;
                        if (eventCode != 2) break;
                        this.this$0.mTelephonyManager.setSimOperatorNameForPhone(this.this$0.mPhoneId, this.this$0.mIccRecords.getServiceProviderName());
                        break;
                    }
                    case 13: {
                        this.this$0.onCarrierPrivilegesLoadedMessage();
                        this.this$0.updateExternalState();
                        break;
                    }
                    case 14: {
                        this.this$0.handleCarrierNameOverride();
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        AsyncResult ar = (AsyncResult)msg.obj;
                        if (ar.exception != null) {
                            this.this$0.loglocal("handleMessage: Exception " + ar.exception);
                            UiccProfile.log("handleMessage: Error in SIM access with exception" + ar.exception);
                        }
                        AsyncResult.forMessage((Message)ar.userObj, ar.result, ar.exception);
                        ((Message)ar.userObj).sendToTarget();
                        break;
                    }
                    default: {
                        UiccProfile.loge("handleMessage: Unhandled message with number: " + msg.what);
                    }
                }
            }

            private void __constructor__(UiccProfile uiccProfile) {
                this.$$robo$$com_android_internal_telephony_uicc_UiccProfile_3$__constructor__(uiccProfile);
            }
            {
                this.this$0 = uiccProfile;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_UiccProfile_3$__constructor__(com.android.internal.telephony.uicc.UiccProfile ), 0, this, uiccProfile);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_uicc_UiccProfile_3$handleMessage(android.os.Message ), 0, this, message);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        UiccProfile.log("Creating profile");
        this.mLock = lock;
        this.mUiccCard = uiccCard;
        this.mPhoneId = phoneId;
        Phone phone = PhoneFactory.getPhone(phoneId);
        if (phone != null) {
            this.setCurrentAppType(phone.getPhoneType() == 1);
        }
        if (this.mUiccCard instanceof EuiccCard) {
            ((EuiccCard)this.mUiccCard).registerForEidReady(this.mHandler, 6, null);
        }
        this.update(c, ci, ics);
        ci.registerForOffOrNotAvailable(this.mHandler, 1, null);
        this.resetProperties();
        IntentFilter intentfilter = new IntentFilter();
        intentfilter.addAction("android.telephony.action.CARRIER_CONFIG_CHANGED");
        c.registerReceiver(this.mReceiver, intentfilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$dispose() {
        UiccProfile.log("Disposing profile");
        if (this.mUiccCard instanceof EuiccCard) {
            ((EuiccCard)this.mUiccCard).unregisterForEidReady(this.mHandler);
        }
        Object object = this.mLock;
        synchronized (object) {
            this.unregisterAllAppEvents();
            this.unregisterCurrAppEvents();
            InstallCarrierAppUtils.hideAllNotifications(this.mContext);
            InstallCarrierAppUtils.unregisterPackageInstallReceiver(this.mContext);
            this.mCi.unregisterForOffOrNotAvailable(this.mHandler);
            this.mContext.unregisterReceiver(this.mReceiver);
            if (this.mCatService != null) {
                this.mCatService.dispose();
            }
            for (UiccCardApplication app : this.mUiccApplications) {
                if (app == null) continue;
                app.dispose();
            }
            this.mCatService = null;
            this.mUiccApplications = null;
            this.mCarrierPrivilegeRules = null;
            this.mDisposed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$setVoiceRadioTech(int radioTech) {
        Object object = this.mLock;
        synchronized (object) {
            UiccProfile.log("Setting radio tech " + ServiceState.rilRadioTechnologyToString(radioTech));
            this.setCurrentAppType(ServiceState.isGsm(radioTech));
            this.updateIccAvailability(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$setCurrentAppType(boolean isGsm) {
        Object object = this.mLock;
        synchronized (object) {
            boolean isLteOnCdmaMode = TelephonyManager.getLteOnCdmaModeStatic() == 1;
            this.mCurrentAppType = isGsm || isLteOnCdmaMode ? 1 : 2;
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$handleCarrierNameOverride() {
        SubscriptionController subCon = SubscriptionController.getInstance();
        int subId = subCon.getSubIdUsingPhoneId(this.mPhoneId);
        if (subId == -1) {
            UiccProfile.loge("subId not valid for Phone " + this.mPhoneId);
            return;
        }
        CarrierConfigManager configLoader = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
        if (configLoader == null) {
            UiccProfile.loge("Failed to load a Carrier Config");
            return;
        }
        PersistableBundle config = configLoader.getConfigForSubId(subId);
        boolean preferCcName = config.getBoolean("carrier_name_override_bool", false);
        String ccName = config.getString("carrier_name_string");
        if (preferCcName || TextUtils.isEmpty(this.getServiceProviderName()) && !TextUtils.isEmpty(ccName)) {
            if (this.mIccRecords != null) {
                this.mIccRecords.setServiceProviderName(ccName);
            }
            this.mTelephonyManager.setSimOperatorNameForPhone(this.mPhoneId, ccName);
            this.mOperatorBrandOverrideRegistrants.notifyRegistrants();
        }
        this.updateCarrierNameForSubscription(subCon, subId);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$updateCarrierNameForSubscription(SubscriptionController subCon, int subId) {
        SubscriptionInfo subInfo = subCon.getActiveSubscriptionInfo(subId, this.mContext.getOpPackageName());
        if (subInfo == null || subInfo.getNameSource() == 2) {
            return;
        }
        CharSequence oldSubName = subInfo.getDisplayName();
        String newCarrierName = this.mTelephonyManager.getSimOperatorName(subId);
        if (!TextUtils.isEmpty(newCarrierName) && !newCarrierName.equals(oldSubName)) {
            UiccProfile.log("sim name[" + this.mPhoneId + "] = " + newCarrierName);
            subCon.setDisplayName(newCarrierName, subId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$updateIccAvailability(boolean allAppsChanged) {
        Object object = this.mLock;
        synchronized (object) {
            IccRecords newRecords = null;
            UiccCardApplication newApp = this.getApplication(this.mCurrentAppType);
            if (newApp != null) {
                newRecords = newApp.getIccRecords();
            }
            if (allAppsChanged) {
                this.unregisterAllAppEvents();
                this.registerAllAppEvents();
            }
            if (this.mIccRecords != newRecords || this.mUiccApplication != newApp) {
                UiccProfile.log("Icc changed. Reregistering.");
                this.unregisterCurrAppEvents();
                this.mUiccApplication = newApp;
                this.mIccRecords = newRecords;
                this.registerCurrAppEvents();
            }
            this.updateExternalState();
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$resetProperties() {
        if (this.mCurrentAppType == 1) {
            UiccProfile.log("update icc_operator_numeric=");
            this.mTelephonyManager.setSimOperatorNumericForPhone(this.mPhoneId, "");
            this.mTelephonyManager.setSimCountryIsoForPhone(this.mPhoneId, "");
            this.mTelephonyManager.setSimOperatorNameForPhone(this.mPhoneId, "");
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$updateExternalState() {
        if (this.mUiccCard.getCardState() == IccCardStatus.CardState.CARDSTATE_ERROR) {
            this.setExternalState(IccCardConstants.State.CARD_IO_ERROR);
            return;
        }
        if (this.mUiccCard.getCardState() == IccCardStatus.CardState.CARDSTATE_RESTRICTED) {
            this.setExternalState(IccCardConstants.State.CARD_RESTRICTED);
            return;
        }
        if (this.mUiccCard instanceof EuiccCard && ((EuiccCard)this.mUiccCard).getEid() == null) {
            UiccProfile.log("EID is not ready yet.");
            return;
        }
        if (this.mUiccApplication == null) {
            UiccProfile.loge("updateExternalState: setting state to NOT_READY because mUiccApplication is null");
            this.setExternalState(IccCardConstants.State.NOT_READY);
            return;
        }
        boolean cardLocked = false;
        IccCardConstants.State lockedState = null;
        IccCardApplicationStatus.AppState appState = this.mUiccApplication.getState();
        IccCardStatus.PinState pin1State = this.mUiccApplication.getPin1State();
        if (pin1State == IccCardStatus.PinState.PINSTATE_ENABLED_PERM_BLOCKED) {
            cardLocked = true;
            lockedState = IccCardConstants.State.PERM_DISABLED;
        } else if (appState == IccCardApplicationStatus.AppState.APPSTATE_PIN) {
            cardLocked = true;
            lockedState = IccCardConstants.State.PIN_REQUIRED;
        } else if (appState == IccCardApplicationStatus.AppState.APPSTATE_PUK) {
            cardLocked = true;
            lockedState = IccCardConstants.State.PUK_REQUIRED;
        } else if (appState == IccCardApplicationStatus.AppState.APPSTATE_SUBSCRIPTION_PERSO && this.mUiccApplication.getPersoSubState() == IccCardApplicationStatus.PersoSubState.PERSOSUBSTATE_SIM_NETWORK) {
            cardLocked = true;
            lockedState = IccCardConstants.State.NETWORK_LOCKED;
        }
        if (cardLocked) {
            if (this.mIccRecords != null && (this.mIccRecords.getLockedRecordsLoaded() || this.mIccRecords.getNetworkLockedRecordsLoaded())) {
                this.setExternalState(lockedState);
            } else {
                this.setExternalState(IccCardConstants.State.NOT_READY);
            }
            return;
        }
        switch (4.$SwitchMap$com$android$internal$telephony$uicc$IccCardApplicationStatus$AppState[appState.ordinal()]) {
            case 1: {
                this.setExternalState(IccCardConstants.State.NOT_READY);
                break;
            }
            case 2: {
                this.checkAndUpdateIfAnyAppToBeIgnored();
                if (this.areAllApplicationsReady()) {
                    if (this.areAllRecordsLoaded() && this.areCarrierPriviligeRulesLoaded()) {
                        this.setExternalState(IccCardConstants.State.LOADED);
                        break;
                    }
                    this.setExternalState(IccCardConstants.State.READY);
                    break;
                }
                this.setExternalState(IccCardConstants.State.NOT_READY);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$registerAllAppEvents() {
        for (UiccCardApplication app : this.mUiccApplications) {
            if (app == null) continue;
            app.registerForReady(this.mHandler, 3, null);
            IccRecords ir = app.getIccRecords();
            if (ir == null) continue;
            ir.registerForRecordsLoaded(this.mHandler, 4, null);
            ir.registerForRecordsEvents(this.mHandler, 7, null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$unregisterAllAppEvents() {
        for (UiccCardApplication app : this.mUiccApplications) {
            if (app == null) continue;
            app.unregisterForReady(this.mHandler);
            IccRecords ir = app.getIccRecords();
            if (ir == null) continue;
            ir.unregisterForRecordsLoaded(this.mHandler);
            ir.unregisterForRecordsEvents(this.mHandler);
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$registerCurrAppEvents() {
        if (this.mIccRecords != null) {
            this.mIccRecords.registerForLockedRecordsLoaded(this.mHandler, 2, null);
            this.mIccRecords.registerForNetworkLockedRecordsLoaded(this.mHandler, 5, null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$unregisterCurrAppEvents() {
        if (this.mIccRecords != null) {
            this.mIccRecords.unregisterForLockedRecordsLoaded(this.mHandler);
            this.mIccRecords.unregisterForNetworkLockedRecordsLoaded(this.mHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$setExternalState(IccCardConstants.State newState, boolean override) {
        Object object = this.mLock;
        synchronized (object) {
            if (!SubscriptionManager.isValidSlotIndex(this.mPhoneId)) {
                UiccProfile.loge("setExternalState: mPhoneId=" + this.mPhoneId + " is invalid; Return!!");
                return;
            }
            if (!override && newState == this.mExternalState) {
                UiccProfile.log("setExternalState: !override and newstate unchanged from " + (Object)((Object)newState));
                return;
            }
            this.mExternalState = newState;
            if (this.mExternalState == IccCardConstants.State.LOADED && this.mIccRecords != null) {
                String operator = this.mIccRecords.getOperatorNumeric();
                UiccProfile.log("setExternalState: operator=" + operator + " mPhoneId=" + this.mPhoneId);
                if (!TextUtils.isEmpty(operator)) {
                    this.mTelephonyManager.setSimOperatorNumericForPhone(this.mPhoneId, operator);
                    String countryCode = operator.substring(0, 3);
                    if (countryCode != null) {
                        this.mTelephonyManager.setSimCountryIsoForPhone(this.mPhoneId, MccTable.countryCodeForMcc(Integer.parseInt(countryCode)));
                    } else {
                        UiccProfile.loge("setExternalState: state LOADED; Country code is null");
                    }
                } else {
                    UiccProfile.loge("setExternalState: state LOADED; Operator name is null");
                }
            }
            UiccProfile.log("setExternalState: set mPhoneId=" + this.mPhoneId + " mExternalState=" + (Object)((Object)this.mExternalState));
            this.mTelephonyManager.setSimStateForPhone(this.mPhoneId, this.getState().toString());
            UiccController.updateInternalIccState(this.getIccStateIntentString(this.mExternalState), this.getIccStateReason(this.mExternalState), this.mPhoneId);
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$setExternalState(IccCardConstants.State newState) {
        this.setExternalState(newState, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccProfile$getIccRecordsLoaded() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIccRecords != null) {
                return this.mIccRecords.getRecordsLoaded();
            }
            return false;
        }
    }

    private final String $$robo$$com_android_internal_telephony_uicc_UiccProfile$getIccStateIntentString(IccCardConstants.State state) {
        switch (4.$SwitchMap$com$android$internal$telephony$IccCardConstants$State[state.ordinal()]) {
            case 1: {
                return "ABSENT";
            }
            case 2: {
                return "LOCKED";
            }
            case 3: {
                return "LOCKED";
            }
            case 4: {
                return "LOCKED";
            }
            case 5: {
                return "READY";
            }
            case 6: {
                return "NOT_READY";
            }
            case 7: {
                return "LOCKED";
            }
            case 8: {
                return "CARD_IO_ERROR";
            }
            case 9: {
                return "CARD_RESTRICTED";
            }
            case 10: {
                return "LOADED";
            }
        }
        return "UNKNOWN";
    }

    private final String $$robo$$com_android_internal_telephony_uicc_UiccProfile$getIccStateReason(IccCardConstants.State state) {
        switch (4.$SwitchMap$com$android$internal$telephony$IccCardConstants$State[state.ordinal()]) {
            case 2: {
                return "PIN";
            }
            case 3: {
                return "PUK";
            }
            case 4: {
                return "NETWORK";
            }
            case 7: {
                return "PERM_DISABLED";
            }
            case 8: {
                return "CARD_IO_ERROR";
            }
            case 9: {
                return "CARD_RESTRICTED";
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IccCardConstants.State $$robo$$com_android_internal_telephony_uicc_UiccProfile$getState() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mExternalState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IccRecords $$robo$$com_android_internal_telephony_uicc_UiccProfile$getIccRecords() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mIccRecords;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$registerForNetworkLocked(Handler h, int what, Object obj) {
        Object object = this.mLock;
        synchronized (object) {
            Registrant r = new Registrant(h, what, obj);
            this.mNetworkLockedRegistrants.add(r);
            if (this.getState() == IccCardConstants.State.NETWORK_LOCKED) {
                r.notifyRegistrant();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$unregisterForNetworkLocked(Handler h) {
        Object object = this.mLock;
        synchronized (object) {
            this.mNetworkLockedRegistrants.remove(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$supplyPin(String pin, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.supplyPin(pin, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$supplyPuk(String puk, String newPin, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.supplyPuk(puk, newPin, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$supplyPin2(String pin2, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.supplyPin2(pin2, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$supplyPuk2(String puk2, String newPin2, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.supplyPuk2(puk2, newPin2, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$supplyNetworkDepersonalization(String pin, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.supplyNetworkDepersonalization(pin, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("CommandsInterface is not set.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccProfile$getIccLockEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mUiccApplication != null && this.mUiccApplication.getIccLockEnabled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccProfile$getIccFdnEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mUiccApplication != null && this.mUiccApplication.getIccFdnEnabled();
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccProfile$getIccPin2Blocked() {
        return this.mUiccApplication != null && this.mUiccApplication.getIccPin2Blocked();
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccProfile$getIccPuk2Blocked() {
        return this.mUiccApplication != null && this.mUiccApplication.getIccPuk2Blocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$setIccLockEnabled(boolean enabled, String password, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.setIccLockEnabled(enabled, password, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$setIccFdnEnabled(boolean enabled, String password, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.setIccFdnEnabled(enabled, password, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$changeIccLockPassword(String oldPassword, String newPassword, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.changeIccLockPassword(oldPassword, newPassword, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$changeIccFdnPassword(String oldPassword, String newPassword, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.changeIccFdnPassword(oldPassword, newPassword, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$com_android_internal_telephony_uicc_UiccProfile$getServiceProviderName() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIccRecords != null) {
                return this.mIccRecords.getServiceProviderName();
            }
            return null;
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccProfile$hasIccCard() {
        if (this.mUiccCard.getCardState() != IccCardStatus.CardState.CARDSTATE_ABSENT) {
            return true;
        }
        UiccProfile.loge("hasIccCard: UiccProfile is not null but UiccCard is null or card state is ABSENT");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$update(Context c, CommandsInterface ci, IccCardStatus ics) {
        Object object = this.mLock;
        synchronized (object) {
            this.mUniversalPinState = ics.mUniversalPinState;
            this.mGsmUmtsSubscriptionAppIndex = ics.mGsmUmtsSubscriptionAppIndex;
            this.mCdmaSubscriptionAppIndex = ics.mCdmaSubscriptionAppIndex;
            this.mImsSubscriptionAppIndex = ics.mImsSubscriptionAppIndex;
            this.mContext = c;
            this.mCi = ci;
            this.mTelephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
            UiccProfile.log(ics.mApplications.length + " applications");
            for (int i = 0; i < this.mUiccApplications.length; ++i) {
                if (this.mUiccApplications[i] == null) {
                    if (i >= ics.mApplications.length) continue;
                    this.mUiccApplications[i] = new UiccCardApplication(this, ics.mApplications[i], this.mContext, this.mCi);
                    continue;
                }
                if (i >= ics.mApplications.length) {
                    this.mUiccApplications[i].dispose();
                    this.mUiccApplications[i] = null;
                    continue;
                }
                this.mUiccApplications[i].update(ics.mApplications[i], this.mContext, this.mCi);
            }
            this.createAndUpdateCatServiceLocked();
            UiccProfile.log("Before privilege rules: " + this.mCarrierPrivilegeRules + " : " + (Object)((Object)ics.mCardState));
            if (this.mCarrierPrivilegeRules == null && ics.mCardState == IccCardStatus.CardState.CARDSTATE_PRESENT) {
                this.mCarrierPrivilegeRules = new UiccCarrierPrivilegeRules(this, this.mHandler.obtainMessage(13));
            } else if (this.mCarrierPrivilegeRules != null && ics.mCardState != IccCardStatus.CardState.CARDSTATE_PRESENT) {
                this.mCarrierPrivilegeRules = null;
            }
            this.sanitizeApplicationIndexesLocked();
            this.updateIccAvailability(true);
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$createAndUpdateCatServiceLocked() {
        if (this.mUiccApplications.length > 0 && this.mUiccApplications[0] != null) {
            if (this.mCatService == null) {
                this.mCatService = CatService.getInstance(this.mCi, this.mContext, this, this.mPhoneId);
            } else {
                this.mCatService.update(this.mCi, this.mContext, this);
            }
        } else {
            if (this.mCatService != null) {
                this.mCatService.dispose();
            }
            this.mCatService = null;
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$finalize() {
        UiccProfile.log("UiccProfile finalized");
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$sanitizeApplicationIndexesLocked() {
        this.mGsmUmtsSubscriptionAppIndex = this.checkIndexLocked(this.mGsmUmtsSubscriptionAppIndex, IccCardApplicationStatus.AppType.APPTYPE_SIM, IccCardApplicationStatus.AppType.APPTYPE_USIM);
        this.mCdmaSubscriptionAppIndex = this.checkIndexLocked(this.mCdmaSubscriptionAppIndex, IccCardApplicationStatus.AppType.APPTYPE_RUIM, IccCardApplicationStatus.AppType.APPTYPE_CSIM);
        this.mImsSubscriptionAppIndex = this.checkIndexLocked(this.mImsSubscriptionAppIndex, IccCardApplicationStatus.AppType.APPTYPE_ISIM, null);
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccProfile$isSupportedApplication(UiccCardApplication app) {
        return app.getType() == IccCardApplicationStatus.AppType.APPTYPE_USIM || app.getType() == IccCardApplicationStatus.AppType.APPTYPE_CSIM || app.getType() == IccCardApplicationStatus.AppType.APPTYPE_SIM || app.getType() == IccCardApplicationStatus.AppType.APPTYPE_RUIM;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$checkAndUpdateIfAnyAppToBeIgnored() {
        boolean[] appReadyStateTracker = new boolean[IccCardApplicationStatus.AppType.APPTYPE_ISIM.ordinal() + 1];
        for (UiccCardApplication app : this.mUiccApplications) {
            if (app == null || !this.isSupportedApplication(app) || !app.isReady()) continue;
            appReadyStateTracker[app.getType().ordinal()] = true;
        }
        for (UiccCardApplication app : this.mUiccApplications) {
            if (app == null || !this.isSupportedApplication(app) || app.isReady() || !appReadyStateTracker[app.getType().ordinal()]) continue;
            app.setAppIgnoreState(true);
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccProfile$areAllApplicationsReady() {
        for (UiccCardApplication app : this.mUiccApplications) {
            if (app == null || !this.isSupportedApplication(app) || app.isReady() || app.isAppIgnored()) continue;
            return false;
        }
        return this.mUiccApplication != null;
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccProfile$areAllRecordsLoaded() {
        for (UiccCardApplication app : this.mUiccApplications) {
            IccRecords ir;
            if (app == null || !this.isSupportedApplication(app) || app.isAppIgnored() || (ir = app.getIccRecords()) != null && ir.isLoaded()) continue;
            return false;
        }
        return this.mUiccApplication != null;
    }

    private final int $$robo$$com_android_internal_telephony_uicc_UiccProfile$checkIndexLocked(int index, IccCardApplicationStatus.AppType expectedAppType, IccCardApplicationStatus.AppType altExpectedAppType) {
        if (this.mUiccApplications == null || index >= this.mUiccApplications.length) {
            UiccProfile.loge("App index " + index + " is invalid since there are no applications");
            return -1;
        }
        if (index < 0) {
            return -1;
        }
        if (this.mUiccApplications[index].getType() != expectedAppType && this.mUiccApplications[index].getType() != altExpectedAppType) {
            UiccProfile.loge("App index " + index + " is invalid since it's not " + (Object)((Object)expectedAppType) + " and not " + (Object)((Object)altExpectedAppType));
            return -1;
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$registerForOpertorBrandOverride(Handler h, int what, Object obj) {
        Object object = this.mLock;
        synchronized (object) {
            Registrant r = new Registrant(h, what, obj);
            this.mOperatorBrandOverrideRegistrants.add(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$registerForCarrierPrivilegeRulesLoaded(Handler h, int what, Object obj) {
        Object object = this.mLock;
        synchronized (object) {
            Registrant r = new Registrant(h, what, obj);
            this.mCarrierPrivilegeRegistrants.add(r);
            if (this.areCarrierPriviligeRulesLoaded()) {
                r.notifyRegistrant();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$unregisterForCarrierPrivilegeRulesLoaded(Handler h) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCarrierPrivilegeRegistrants.remove(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$unregisterForOperatorBrandOverride(Handler h) {
        Object object = this.mLock;
        synchronized (object) {
            this.mOperatorBrandOverrideRegistrants.remove(h);
        }
    }

    private static final boolean $$robo$$com_android_internal_telephony_uicc_UiccProfile$isPackageInstalled(Context context, String pkgName) {
        PackageManager pm = context.getPackageManager();
        try {
            pm.getPackageInfo(pkgName, 1);
            UiccProfile.log(pkgName + " is installed.");
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            UiccProfile.log(pkgName + " is not installed.");
            return false;
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$promptInstallCarrierApp(String pkgName) {
        Intent showDialogIntent = InstallCarrierAppTrampolineActivity.get(this.mContext, pkgName);
        this.mContext.startActivity(showDialogIntent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$onCarrierPrivilegesLoadedMessage() {
        UsageStatsManager usm = (UsageStatsManager)this.mContext.getSystemService("usagestats");
        if (usm != null) {
            usm.onCarrierPrivilegedAppsChanged();
        }
        InstallCarrierAppUtils.hideAllNotifications(this.mContext);
        InstallCarrierAppUtils.unregisterPackageInstallReceiver(this.mContext);
        Object object = this.mLock;
        synchronized (object) {
            boolean isProvisioned;
            this.mCarrierPrivilegeRegistrants.notifyRegistrants();
            boolean bl = isProvisioned = Settings.Global.getInt(this.mContext.getContentResolver(), "device_provisioned", 1) == 1;
            if (isProvisioned) {
                for (String pkgName : this.getUninstalledCarrierPackages()) {
                    this.promptInstallCarrierApp(pkgName);
                }
            } else {
                Uri uri = Settings.Global.getUriFor("device_provisioned");
                this.mContext.getContentResolver().registerContentObserver(uri, false, this.mProvisionCompleteContentObserver);
            }
        }
    }

    private final Set<String> $$robo$$com_android_internal_telephony_uicc_UiccProfile$getUninstalledCarrierPackages() {
        String whitelistSetting = Settings.Global.getString(this.mContext.getContentResolver(), "carrier_app_whitelist");
        if (TextUtils.isEmpty(whitelistSetting)) {
            return Collections.emptySet();
        }
        Map<String, String> certPackageMap = UiccProfile.parseToCertificateToPackageMap(whitelistSetting);
        if (certPackageMap.isEmpty()) {
            return Collections.emptySet();
        }
        ArraySet<String> uninstalledCarrierPackages = new ArraySet<String>();
        List<UiccAccessRule> accessRules = this.mCarrierPrivilegeRules.getAccessRules();
        for (UiccAccessRule accessRule : accessRules) {
            String certHexString = accessRule.getCertificateHexString().toUpperCase();
            String pkgName = certPackageMap.get(certHexString);
            if (TextUtils.isEmpty(pkgName) || UiccProfile.isPackageInstalled(this.mContext, pkgName)) continue;
            uninstalledCarrierPackages.add(pkgName);
        }
        return uninstalledCarrierPackages;
    }

    @VisibleForTesting
    private static final Map<String, String> $$robo$$com_android_internal_telephony_uicc_UiccProfile$parseToCertificateToPackageMap(String whitelistSetting) {
        String pairDelim = "\\s*;\\s*";
        String keyValueDelim = "\\s*:\\s*";
        List<String> keyValuePairList = Arrays.asList(whitelistSetting.split("\\s*;\\s*"));
        if (keyValuePairList.isEmpty()) {
            return Collections.emptyMap();
        }
        ArrayMap<String, String> map = new ArrayMap<String, String>(keyValuePairList.size());
        for (String keyValueString : keyValuePairList) {
            String[] keyValue = keyValueString.split("\\s*:\\s*");
            if (keyValue.length == 2) {
                map.put(keyValue[0].toUpperCase(), keyValue[1]);
                continue;
            }
            UiccProfile.loge("Incorrect length of key-value pair in carrier app whitelist map.  Length should be exactly 2");
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccProfile$isApplicationOnIcc(IccCardApplicationStatus.AppType type) {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < this.mUiccApplications.length; ++i) {
                if (this.mUiccApplications[i] == null || this.mUiccApplications[i].getType() != type) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IccCardStatus.PinState $$robo$$com_android_internal_telephony_uicc_UiccProfile$getUniversalPinState() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mUniversalPinState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final UiccCardApplication $$robo$$com_android_internal_telephony_uicc_UiccProfile$getApplication(int family) {
        Object object = this.mLock;
        synchronized (object) {
            int index = 8;
            switch (family) {
                case 1: {
                    index = this.mGsmUmtsSubscriptionAppIndex;
                    break;
                }
                case 2: {
                    index = this.mCdmaSubscriptionAppIndex;
                    break;
                }
                case 3: {
                    index = this.mImsSubscriptionAppIndex;
                }
            }
            if (index >= 0 && index < this.mUiccApplications.length) {
                return this.mUiccApplications[index];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final UiccCardApplication $$robo$$com_android_internal_telephony_uicc_UiccProfile$getApplicationIndex(int index) {
        Object object = this.mLock;
        synchronized (object) {
            if (index >= 0 && index < this.mUiccApplications.length) {
                return this.mUiccApplications[index];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final UiccCardApplication $$robo$$com_android_internal_telephony_uicc_UiccProfile$getApplicationByType(int type) {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < this.mUiccApplications.length; ++i) {
                if (this.mUiccApplications[i] == null || this.mUiccApplications[i].getType().ordinal() != type) continue;
                return this.mUiccApplications[i];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccProfile$resetAppWithAid(String aid, boolean disposeCatService) {
        Object object = this.mLock;
        synchronized (object) {
            boolean changed = false;
            for (int i = 0; i < this.mUiccApplications.length; ++i) {
                if (this.mUiccApplications[i] == null || !TextUtils.isEmpty(aid) && !aid.equals(this.mUiccApplications[i].getAid())) continue;
                this.mUiccApplications[i].dispose();
                this.mUiccApplications[i] = null;
                changed = true;
            }
            if (TextUtils.isEmpty(aid)) {
                if (this.mCarrierPrivilegeRules != null) {
                    this.mCarrierPrivilegeRules = null;
                    changed = true;
                }
                if (disposeCatService && this.mCatService != null) {
                    this.mCatService.dispose();
                    this.mCatService = null;
                    changed = true;
                }
            }
            return changed;
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$iccOpenLogicalChannel(String aid, int p2, Message response) {
        this.loglocal("iccOpenLogicalChannel: " + aid + " , " + p2 + " by pid:" + Binder.getCallingPid() + " uid:" + Binder.getCallingUid());
        this.mCi.iccOpenLogicalChannel(aid, p2, this.mHandler.obtainMessage(8, response));
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$iccCloseLogicalChannel(int channel, Message response) {
        this.loglocal("iccCloseLogicalChannel: " + channel);
        this.mCi.iccCloseLogicalChannel(channel, this.mHandler.obtainMessage(9, response));
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$iccTransmitApduLogicalChannel(int channel, int cla, int command, int p1, int p2, int p3, String data, Message response) {
        this.mCi.iccTransmitApduLogicalChannel(channel, cla, command, p1, p2, p3, data, this.mHandler.obtainMessage(10, response));
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$iccTransmitApduBasicChannel(int cla, int command, int p1, int p2, int p3, String data, Message response) {
        this.mCi.iccTransmitApduBasicChannel(cla, command, p1, p2, p3, data, this.mHandler.obtainMessage(11, response));
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$iccExchangeSimIO(int fileID, int command, int p1, int p2, int p3, String pathID, Message response) {
        this.mCi.iccIO(command, fileID, pathID, p1, p2, p3, null, null, this.mHandler.obtainMessage(12, response));
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$sendEnvelopeWithStatus(String contents, Message response) {
        this.mCi.sendEnvelopeWithStatus(contents, response);
    }

    private final int $$robo$$com_android_internal_telephony_uicc_UiccProfile$getNumApplications() {
        int count = 0;
        for (UiccCardApplication a : this.mUiccApplications) {
            if (a == null) continue;
            ++count;
        }
        return count;
    }

    private final int $$robo$$com_android_internal_telephony_uicc_UiccProfile$getPhoneId() {
        return this.mPhoneId;
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccProfile$areCarrierPriviligeRulesLoaded() {
        UiccCarrierPrivilegeRules carrierPrivilegeRules = this.getCarrierPrivilegeRules();
        return carrierPrivilegeRules == null || carrierPrivilegeRules.areCarrierPriviligeRulesLoaded();
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccProfile$hasCarrierPrivilegeRules() {
        UiccCarrierPrivilegeRules carrierPrivilegeRules = this.getCarrierPrivilegeRules();
        return carrierPrivilegeRules != null && carrierPrivilegeRules.hasCarrierPrivilegeRules();
    }

    private final int $$robo$$com_android_internal_telephony_uicc_UiccProfile$getCarrierPrivilegeStatus(Signature signature, String packageName) {
        UiccCarrierPrivilegeRules carrierPrivilegeRules = this.getCarrierPrivilegeRules();
        return carrierPrivilegeRules == null ? -1 : carrierPrivilegeRules.getCarrierPrivilegeStatus(signature, packageName);
    }

    private final int $$robo$$com_android_internal_telephony_uicc_UiccProfile$getCarrierPrivilegeStatus(PackageManager packageManager, String packageName) {
        UiccCarrierPrivilegeRules carrierPrivilegeRules = this.getCarrierPrivilegeRules();
        return carrierPrivilegeRules == null ? -1 : carrierPrivilegeRules.getCarrierPrivilegeStatus(packageManager, packageName);
    }

    private final int $$robo$$com_android_internal_telephony_uicc_UiccProfile$getCarrierPrivilegeStatus(PackageInfo packageInfo) {
        UiccCarrierPrivilegeRules carrierPrivilegeRules = this.getCarrierPrivilegeRules();
        return carrierPrivilegeRules == null ? -1 : carrierPrivilegeRules.getCarrierPrivilegeStatus(packageInfo);
    }

    private final int $$robo$$com_android_internal_telephony_uicc_UiccProfile$getCarrierPrivilegeStatusForCurrentTransaction(PackageManager packageManager) {
        UiccCarrierPrivilegeRules carrierPrivilegeRules = this.getCarrierPrivilegeRules();
        return carrierPrivilegeRules == null ? -1 : carrierPrivilegeRules.getCarrierPrivilegeStatusForCurrentTransaction(packageManager);
    }

    private final int $$robo$$com_android_internal_telephony_uicc_UiccProfile$getCarrierPrivilegeStatusForUid(PackageManager packageManager, int uid) {
        UiccCarrierPrivilegeRules carrierPrivilegeRules = this.getCarrierPrivilegeRules();
        return carrierPrivilegeRules == null ? -1 : carrierPrivilegeRules.getCarrierPrivilegeStatusForUid(packageManager, uid);
    }

    private final List<String> $$robo$$com_android_internal_telephony_uicc_UiccProfile$getCarrierPackageNamesForIntent(PackageManager packageManager, Intent intent) {
        UiccCarrierPrivilegeRules carrierPrivilegeRules = this.getCarrierPrivilegeRules();
        return carrierPrivilegeRules == null ? null : carrierPrivilegeRules.getCarrierPackageNamesForIntent(packageManager, intent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final UiccCarrierPrivilegeRules $$robo$$com_android_internal_telephony_uicc_UiccProfile$getCarrierPrivilegeRules() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCarrierPrivilegeRules;
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccProfile$setOperatorBrandOverride(String brand) {
        UiccProfile.log("setOperatorBrandOverride: " + brand);
        UiccProfile.log("current iccId: " + SubscriptionInfo.givePrintableIccid(this.getIccId()));
        String iccId = this.getIccId();
        if (TextUtils.isEmpty(iccId)) {
            return false;
        }
        SharedPreferences.Editor spEditor = PreferenceManager.getDefaultSharedPreferences(this.mContext).edit();
        String key = "operator_branding_" + iccId;
        if (brand == null) {
            spEditor.remove(key).commit();
        } else {
            spEditor.putString(key, brand).commit();
        }
        this.mOperatorBrandOverrideRegistrants.notifyRegistrants();
        return true;
    }

    private final String $$robo$$com_android_internal_telephony_uicc_UiccProfile$getOperatorBrandOverride() {
        String iccId = this.getIccId();
        if (TextUtils.isEmpty(iccId)) {
            return null;
        }
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.mContext);
        return sp.getString("operator_branding_" + iccId, null);
    }

    private final String $$robo$$com_android_internal_telephony_uicc_UiccProfile$getIccId() {
        for (UiccCardApplication app : this.mUiccApplications) {
            IccRecords ir;
            if (app == null || (ir = app.getIccRecords()) == null || ir.getIccId() == null) continue;
            return ir.getIccId();
        }
        return null;
    }

    private static final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$log(String msg) {
        Rlog.d("UiccProfile", msg);
    }

    private static final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$loge(String msg) {
        Rlog.e("UiccProfile", msg);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$loglocal(String msg) {
        UiccController.sLocalLog.log("UiccProfile[" + this.mPhoneId + "]: " + msg);
    }

    @VisibleForTesting
    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$refresh() {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(13));
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccProfile$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        int i;
        int i2;
        pw.println("UiccProfile:");
        pw.println(" mCi=" + this.mCi);
        pw.println(" mCatService=" + this.mCatService);
        for (i2 = 0; i2 < this.mCarrierPrivilegeRegistrants.size(); ++i2) {
            pw.println("  mCarrierPrivilegeRegistrants[" + i2 + "]=" + ((Registrant)this.mCarrierPrivilegeRegistrants.get(i2)).getHandler());
        }
        for (i2 = 0; i2 < this.mOperatorBrandOverrideRegistrants.size(); ++i2) {
            pw.println("  mOperatorBrandOverrideRegistrants[" + i2 + "]=" + ((Registrant)this.mOperatorBrandOverrideRegistrants.get(i2)).getHandler());
        }
        pw.println(" mUniversalPinState=" + (Object)((Object)this.mUniversalPinState));
        pw.println(" mGsmUmtsSubscriptionAppIndex=" + this.mGsmUmtsSubscriptionAppIndex);
        pw.println(" mCdmaSubscriptionAppIndex=" + this.mCdmaSubscriptionAppIndex);
        pw.println(" mImsSubscriptionAppIndex=" + this.mImsSubscriptionAppIndex);
        pw.println(" mUiccApplications: length=" + this.mUiccApplications.length);
        for (i2 = 0; i2 < this.mUiccApplications.length; ++i2) {
            if (this.mUiccApplications[i2] == null) {
                pw.println("  mUiccApplications[" + i2 + "]=" + null);
                continue;
            }
            pw.println("  mUiccApplications[" + i2 + "]=" + (Object)((Object)this.mUiccApplications[i2].getType()) + " " + this.mUiccApplications[i2]);
        }
        pw.println();
        for (UiccCardApplication app : this.mUiccApplications) {
            if (app == null) continue;
            app.dump(fd, pw, args);
            pw.println();
        }
        for (UiccCardApplication app : this.mUiccApplications) {
            IccRecords ir;
            if (app == null || (ir = app.getIccRecords()) == null) continue;
            ir.dump(fd, pw, args);
            pw.println();
        }
        if (this.mCarrierPrivilegeRules == null) {
            pw.println(" mCarrierPrivilegeRules: null");
        } else {
            pw.println(" mCarrierPrivilegeRules: " + this.mCarrierPrivilegeRules);
            this.mCarrierPrivilegeRules.dump(fd, pw, args);
        }
        pw.println(" mCarrierPrivilegeRegistrants: size=" + this.mCarrierPrivilegeRegistrants.size());
        for (i = 0; i < this.mCarrierPrivilegeRegistrants.size(); ++i) {
            pw.println("  mCarrierPrivilegeRegistrants[" + i + "]=" + ((Registrant)this.mCarrierPrivilegeRegistrants.get(i)).getHandler());
        }
        pw.flush();
        pw.println(" mNetworkLockedRegistrants: size=" + this.mNetworkLockedRegistrants.size());
        for (i = 0; i < this.mNetworkLockedRegistrants.size(); ++i) {
            pw.println("  mNetworkLockedRegistrants[" + i + "]=" + ((Registrant)this.mNetworkLockedRegistrants.get(i)).getHandler());
        }
        pw.println(" mCurrentAppType=" + this.mCurrentAppType);
        pw.println(" mUiccCard=" + this.mUiccCard);
        pw.println(" mUiccApplication=" + this.mUiccApplication);
        pw.println(" mIccRecords=" + this.mIccRecords);
        pw.println(" mExternalState=" + (Object)((Object)this.mExternalState));
        pw.flush();
    }

    private void __constructor__(Context context, CommandsInterface commandsInterface, IccCardStatus iccCardStatus, int n, UiccCard uiccCard, Object object) {
        this.$$robo$$com_android_internal_telephony_uicc_UiccProfile$__constructor__(context, commandsInterface, iccCardStatus, n, uiccCard, object);
    }

    public UiccProfile(Context context, CommandsInterface commandsInterface, IccCardStatus iccCardStatus, int n, UiccCard uiccCard, Object object) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_UiccProfile$__constructor__(android.content.Context com.android.internal.telephony.CommandsInterface com.android.internal.telephony.uicc.IccCardStatus int com.android.internal.telephony.uicc.UiccCard java.lang.Object ), 0, this, context, commandsInterface, iccCardStatus, n, uiccCard, object);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_uicc_UiccProfile$dispose(), 0, this);
    }

    public void setVoiceRadioTech(int n) {
        InvokeDynamicSupport.bootstrap("setVoiceRadioTech", $$robo$$com_android_internal_telephony_uicc_UiccProfile$setVoiceRadioTech(int ), 0, this, n);
    }

    private void setCurrentAppType(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCurrentAppType", $$robo$$com_android_internal_telephony_uicc_UiccProfile$setCurrentAppType(boolean ), 0, this, bl);
    }

    private void handleCarrierNameOverride() {
        InvokeDynamicSupport.bootstrap("handleCarrierNameOverride", $$robo$$com_android_internal_telephony_uicc_UiccProfile$handleCarrierNameOverride(), 0, this);
    }

    private void updateCarrierNameForSubscription(SubscriptionController subscriptionController, int n) {
        InvokeDynamicSupport.bootstrap("updateCarrierNameForSubscription", $$robo$$com_android_internal_telephony_uicc_UiccProfile$updateCarrierNameForSubscription(com.android.internal.telephony.SubscriptionController int ), 0, this, subscriptionController, n);
    }

    private void updateIccAvailability(boolean bl) {
        InvokeDynamicSupport.bootstrap("updateIccAvailability", $$robo$$com_android_internal_telephony_uicc_UiccProfile$updateIccAvailability(boolean ), 0, this, bl);
    }

    void resetProperties() {
        InvokeDynamicSupport.bootstrap("resetProperties", $$robo$$com_android_internal_telephony_uicc_UiccProfile$resetProperties(), 0, this);
    }

    public void updateExternalState() {
        InvokeDynamicSupport.bootstrap("updateExternalState", $$robo$$com_android_internal_telephony_uicc_UiccProfile$updateExternalState(), 0, this);
    }

    private void registerAllAppEvents() {
        InvokeDynamicSupport.bootstrap("registerAllAppEvents", $$robo$$com_android_internal_telephony_uicc_UiccProfile$registerAllAppEvents(), 0, this);
    }

    private void unregisterAllAppEvents() {
        InvokeDynamicSupport.bootstrap("unregisterAllAppEvents", $$robo$$com_android_internal_telephony_uicc_UiccProfile$unregisterAllAppEvents(), 0, this);
    }

    private void registerCurrAppEvents() {
        InvokeDynamicSupport.bootstrap("registerCurrAppEvents", $$robo$$com_android_internal_telephony_uicc_UiccProfile$registerCurrAppEvents(), 0, this);
    }

    private void unregisterCurrAppEvents() {
        InvokeDynamicSupport.bootstrap("unregisterCurrAppEvents", $$robo$$com_android_internal_telephony_uicc_UiccProfile$unregisterCurrAppEvents(), 0, this);
    }

    private void setExternalState(IccCardConstants.State state, boolean bl) {
        InvokeDynamicSupport.bootstrap("setExternalState", $$robo$$com_android_internal_telephony_uicc_UiccProfile$setExternalState(com.android.internal.telephony.IccCardConstants$State boolean ), 0, this, state, bl);
    }

    private void setExternalState(IccCardConstants.State state) {
        InvokeDynamicSupport.bootstrap("setExternalState", $$robo$$com_android_internal_telephony_uicc_UiccProfile$setExternalState(com.android.internal.telephony.IccCardConstants$State ), 0, this, state);
    }

    public boolean getIccRecordsLoaded() {
        return (boolean)InvokeDynamicSupport.bootstrap("getIccRecordsLoaded", $$robo$$com_android_internal_telephony_uicc_UiccProfile$getIccRecordsLoaded(), 0, this);
    }

    private String getIccStateIntentString(IccCardConstants.State state) {
        return InvokeDynamicSupport.bootstrap("getIccStateIntentString", $$robo$$com_android_internal_telephony_uicc_UiccProfile$getIccStateIntentString(com.android.internal.telephony.IccCardConstants$State ), 0, this, state);
    }

    private String getIccStateReason(IccCardConstants.State state) {
        return InvokeDynamicSupport.bootstrap("getIccStateReason", $$robo$$com_android_internal_telephony_uicc_UiccProfile$getIccStateReason(com.android.internal.telephony.IccCardConstants$State ), 0, this, state);
    }

    @Override
    public IccCardConstants.State getState() {
        return InvokeDynamicSupport.bootstrap("getState", $$robo$$com_android_internal_telephony_uicc_UiccProfile$getState(), 0, this);
    }

    @Override
    public IccRecords getIccRecords() {
        return InvokeDynamicSupport.bootstrap("getIccRecords", $$robo$$com_android_internal_telephony_uicc_UiccProfile$getIccRecords(), 0, this);
    }

    @Override
    public void registerForNetworkLocked(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForNetworkLocked", $$robo$$com_android_internal_telephony_uicc_UiccProfile$registerForNetworkLocked(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForNetworkLocked(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForNetworkLocked", $$robo$$com_android_internal_telephony_uicc_UiccProfile$unregisterForNetworkLocked(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void supplyPin(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("supplyPin", $$robo$$com_android_internal_telephony_uicc_UiccProfile$supplyPin(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    @Override
    public void supplyPuk(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("supplyPuk", $$robo$$com_android_internal_telephony_uicc_UiccProfile$supplyPuk(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    @Override
    public void supplyPin2(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("supplyPin2", $$robo$$com_android_internal_telephony_uicc_UiccProfile$supplyPin2(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    @Override
    public void supplyPuk2(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("supplyPuk2", $$robo$$com_android_internal_telephony_uicc_UiccProfile$supplyPuk2(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    @Override
    public void supplyNetworkDepersonalization(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("supplyNetworkDepersonalization", $$robo$$com_android_internal_telephony_uicc_UiccProfile$supplyNetworkDepersonalization(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    @Override
    public boolean getIccLockEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("getIccLockEnabled", $$robo$$com_android_internal_telephony_uicc_UiccProfile$getIccLockEnabled(), 0, this);
    }

    @Override
    public boolean getIccFdnEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("getIccFdnEnabled", $$robo$$com_android_internal_telephony_uicc_UiccProfile$getIccFdnEnabled(), 0, this);
    }

    @Override
    public boolean getIccPin2Blocked() {
        return (boolean)InvokeDynamicSupport.bootstrap("getIccPin2Blocked", $$robo$$com_android_internal_telephony_uicc_UiccProfile$getIccPin2Blocked(), 0, this);
    }

    @Override
    public boolean getIccPuk2Blocked() {
        return (boolean)InvokeDynamicSupport.bootstrap("getIccPuk2Blocked", $$robo$$com_android_internal_telephony_uicc_UiccProfile$getIccPuk2Blocked(), 0, this);
    }

    @Override
    public void setIccLockEnabled(boolean bl, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("setIccLockEnabled", $$robo$$com_android_internal_telephony_uicc_UiccProfile$setIccLockEnabled(boolean java.lang.String android.os.Message ), 0, this, bl, string2, message);
    }

    @Override
    public void setIccFdnEnabled(boolean bl, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("setIccFdnEnabled", $$robo$$com_android_internal_telephony_uicc_UiccProfile$setIccFdnEnabled(boolean java.lang.String android.os.Message ), 0, this, bl, string2, message);
    }

    @Override
    public void changeIccLockPassword(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("changeIccLockPassword", $$robo$$com_android_internal_telephony_uicc_UiccProfile$changeIccLockPassword(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    @Override
    public void changeIccFdnPassword(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("changeIccFdnPassword", $$robo$$com_android_internal_telephony_uicc_UiccProfile$changeIccFdnPassword(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    @Override
    public String getServiceProviderName() {
        return InvokeDynamicSupport.bootstrap("getServiceProviderName", $$robo$$com_android_internal_telephony_uicc_UiccProfile$getServiceProviderName(), 0, this);
    }

    @Override
    public boolean hasIccCard() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasIccCard", $$robo$$com_android_internal_telephony_uicc_UiccProfile$hasIccCard(), 0, this);
    }

    public void update(Context context, CommandsInterface commandsInterface, IccCardStatus iccCardStatus) {
        InvokeDynamicSupport.bootstrap("update", $$robo$$com_android_internal_telephony_uicc_UiccProfile$update(android.content.Context com.android.internal.telephony.CommandsInterface com.android.internal.telephony.uicc.IccCardStatus ), 0, this, context, commandsInterface, iccCardStatus);
    }

    private void createAndUpdateCatServiceLocked() {
        InvokeDynamicSupport.bootstrap("createAndUpdateCatServiceLocked", $$robo$$com_android_internal_telephony_uicc_UiccProfile$createAndUpdateCatServiceLocked(), 0, this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$com_android_internal_telephony_uicc_UiccProfile$finalize(), 0, this);
    }

    private void sanitizeApplicationIndexesLocked() {
        InvokeDynamicSupport.bootstrap("sanitizeApplicationIndexesLocked", $$robo$$com_android_internal_telephony_uicc_UiccProfile$sanitizeApplicationIndexesLocked(), 0, this);
    }

    private boolean isSupportedApplication(UiccCardApplication uiccCardApplication) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSupportedApplication", $$robo$$com_android_internal_telephony_uicc_UiccProfile$isSupportedApplication(com.android.internal.telephony.uicc.UiccCardApplication ), 0, this, uiccCardApplication);
    }

    private void checkAndUpdateIfAnyAppToBeIgnored() {
        InvokeDynamicSupport.bootstrap("checkAndUpdateIfAnyAppToBeIgnored", $$robo$$com_android_internal_telephony_uicc_UiccProfile$checkAndUpdateIfAnyAppToBeIgnored(), 0, this);
    }

    private boolean areAllApplicationsReady() {
        return (boolean)InvokeDynamicSupport.bootstrap("areAllApplicationsReady", $$robo$$com_android_internal_telephony_uicc_UiccProfile$areAllApplicationsReady(), 0, this);
    }

    private boolean areAllRecordsLoaded() {
        return (boolean)InvokeDynamicSupport.bootstrap("areAllRecordsLoaded", $$robo$$com_android_internal_telephony_uicc_UiccProfile$areAllRecordsLoaded(), 0, this);
    }

    private int checkIndexLocked(int n, IccCardApplicationStatus.AppType appType, IccCardApplicationStatus.AppType appType2) {
        return (int)InvokeDynamicSupport.bootstrap("checkIndexLocked", $$robo$$com_android_internal_telephony_uicc_UiccProfile$checkIndexLocked(int com.android.internal.telephony.uicc.IccCardApplicationStatus$AppType com.android.internal.telephony.uicc.IccCardApplicationStatus$AppType ), 0, this, n, appType, appType2);
    }

    public void registerForOpertorBrandOverride(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForOpertorBrandOverride", $$robo$$com_android_internal_telephony_uicc_UiccProfile$registerForOpertorBrandOverride(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void registerForCarrierPrivilegeRulesLoaded(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForCarrierPrivilegeRulesLoaded", $$robo$$com_android_internal_telephony_uicc_UiccProfile$registerForCarrierPrivilegeRulesLoaded(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForCarrierPrivilegeRulesLoaded(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForCarrierPrivilegeRulesLoaded", $$robo$$com_android_internal_telephony_uicc_UiccProfile$unregisterForCarrierPrivilegeRulesLoaded(android.os.Handler ), 0, this, handler);
    }

    public void unregisterForOperatorBrandOverride(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForOperatorBrandOverride", $$robo$$com_android_internal_telephony_uicc_UiccProfile$unregisterForOperatorBrandOverride(android.os.Handler ), 0, this, handler);
    }

    static boolean isPackageInstalled(Context context, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPackageInstalled", $$robo$$com_android_internal_telephony_uicc_UiccProfile$isPackageInstalled(android.content.Context java.lang.String ), 0, (Context)context, (String)string2);
    }

    private void promptInstallCarrierApp(String string2) {
        InvokeDynamicSupport.bootstrap("promptInstallCarrierApp", $$robo$$com_android_internal_telephony_uicc_UiccProfile$promptInstallCarrierApp(java.lang.String ), 0, this, string2);
    }

    private void onCarrierPrivilegesLoadedMessage() {
        InvokeDynamicSupport.bootstrap("onCarrierPrivilegesLoadedMessage", $$robo$$com_android_internal_telephony_uicc_UiccProfile$onCarrierPrivilegesLoadedMessage(), 0, this);
    }

    private Set<String> getUninstalledCarrierPackages() {
        return InvokeDynamicSupport.bootstrap("getUninstalledCarrierPackages", $$robo$$com_android_internal_telephony_uicc_UiccProfile$getUninstalledCarrierPackages(), 0, this);
    }

    public static Map<String, String> parseToCertificateToPackageMap(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("parseToCertificateToPackageMap", $$robo$$com_android_internal_telephony_uicc_UiccProfile$parseToCertificateToPackageMap(java.lang.String ), 0, (String)string2);
    }

    @Override
    public boolean isApplicationOnIcc(IccCardApplicationStatus.AppType appType) {
        return (boolean)InvokeDynamicSupport.bootstrap("isApplicationOnIcc", $$robo$$com_android_internal_telephony_uicc_UiccProfile$isApplicationOnIcc(com.android.internal.telephony.uicc.IccCardApplicationStatus$AppType ), 0, this, appType);
    }

    public IccCardStatus.PinState getUniversalPinState() {
        return InvokeDynamicSupport.bootstrap("getUniversalPinState", $$robo$$com_android_internal_telephony_uicc_UiccProfile$getUniversalPinState(), 0, this);
    }

    public UiccCardApplication getApplication(int n) {
        return InvokeDynamicSupport.bootstrap("getApplication", $$robo$$com_android_internal_telephony_uicc_UiccProfile$getApplication(int ), 0, this, n);
    }

    public UiccCardApplication getApplicationIndex(int n) {
        return InvokeDynamicSupport.bootstrap("getApplicationIndex", $$robo$$com_android_internal_telephony_uicc_UiccProfile$getApplicationIndex(int ), 0, this, n);
    }

    public UiccCardApplication getApplicationByType(int n) {
        return InvokeDynamicSupport.bootstrap("getApplicationByType", $$robo$$com_android_internal_telephony_uicc_UiccProfile$getApplicationByType(int ), 0, this, n);
    }

    public boolean resetAppWithAid(String string2, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("resetAppWithAid", $$robo$$com_android_internal_telephony_uicc_UiccProfile$resetAppWithAid(java.lang.String boolean ), 0, this, string2, bl);
    }

    public void iccOpenLogicalChannel(String string2, int n, Message message) {
        InvokeDynamicSupport.bootstrap("iccOpenLogicalChannel", $$robo$$com_android_internal_telephony_uicc_UiccProfile$iccOpenLogicalChannel(java.lang.String int android.os.Message ), 0, this, string2, n, message);
    }

    public void iccCloseLogicalChannel(int n, Message message) {
        InvokeDynamicSupport.bootstrap("iccCloseLogicalChannel", $$robo$$com_android_internal_telephony_uicc_UiccProfile$iccCloseLogicalChannel(int android.os.Message ), 0, this, n, message);
    }

    public void iccTransmitApduLogicalChannel(int n, int n2, int n3, int n4, int n5, int n6, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("iccTransmitApduLogicalChannel", $$robo$$com_android_internal_telephony_uicc_UiccProfile$iccTransmitApduLogicalChannel(int int int int int int java.lang.String android.os.Message ), 0, this, n, n2, n3, n4, n5, n6, string2, message);
    }

    public void iccTransmitApduBasicChannel(int n, int n2, int n3, int n4, int n5, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("iccTransmitApduBasicChannel", $$robo$$com_android_internal_telephony_uicc_UiccProfile$iccTransmitApduBasicChannel(int int int int int java.lang.String android.os.Message ), 0, this, n, n2, n3, n4, n5, string2, message);
    }

    public void iccExchangeSimIO(int n, int n2, int n3, int n4, int n5, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("iccExchangeSimIO", $$robo$$com_android_internal_telephony_uicc_UiccProfile$iccExchangeSimIO(int int int int int java.lang.String android.os.Message ), 0, this, n, n2, n3, n4, n5, string2, message);
    }

    public void sendEnvelopeWithStatus(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("sendEnvelopeWithStatus", $$robo$$com_android_internal_telephony_uicc_UiccProfile$sendEnvelopeWithStatus(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    public int getNumApplications() {
        return (int)InvokeDynamicSupport.bootstrap("getNumApplications", $$robo$$com_android_internal_telephony_uicc_UiccProfile$getNumApplications(), 0, this);
    }

    public int getPhoneId() {
        return (int)InvokeDynamicSupport.bootstrap("getPhoneId", $$robo$$com_android_internal_telephony_uicc_UiccProfile$getPhoneId(), 0, this);
    }

    public boolean areCarrierPriviligeRulesLoaded() {
        return (boolean)InvokeDynamicSupport.bootstrap("areCarrierPriviligeRulesLoaded", $$robo$$com_android_internal_telephony_uicc_UiccProfile$areCarrierPriviligeRulesLoaded(), 0, this);
    }

    public boolean hasCarrierPrivilegeRules() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCarrierPrivilegeRules", $$robo$$com_android_internal_telephony_uicc_UiccProfile$hasCarrierPrivilegeRules(), 0, this);
    }

    public int getCarrierPrivilegeStatus(Signature signature, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getCarrierPrivilegeStatus", $$robo$$com_android_internal_telephony_uicc_UiccProfile$getCarrierPrivilegeStatus(android.content.pm.Signature java.lang.String ), 0, this, signature, string2);
    }

    public int getCarrierPrivilegeStatus(PackageManager packageManager, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getCarrierPrivilegeStatus", $$robo$$com_android_internal_telephony_uicc_UiccProfile$getCarrierPrivilegeStatus(android.content.pm.PackageManager java.lang.String ), 0, this, packageManager, string2);
    }

    public int getCarrierPrivilegeStatus(PackageInfo packageInfo) {
        return (int)InvokeDynamicSupport.bootstrap("getCarrierPrivilegeStatus", $$robo$$com_android_internal_telephony_uicc_UiccProfile$getCarrierPrivilegeStatus(android.content.pm.PackageInfo ), 0, this, packageInfo);
    }

    public int getCarrierPrivilegeStatusForCurrentTransaction(PackageManager packageManager) {
        return (int)InvokeDynamicSupport.bootstrap("getCarrierPrivilegeStatusForCurrentTransaction", $$robo$$com_android_internal_telephony_uicc_UiccProfile$getCarrierPrivilegeStatusForCurrentTransaction(android.content.pm.PackageManager ), 0, this, packageManager);
    }

    public int getCarrierPrivilegeStatusForUid(PackageManager packageManager, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getCarrierPrivilegeStatusForUid", $$robo$$com_android_internal_telephony_uicc_UiccProfile$getCarrierPrivilegeStatusForUid(android.content.pm.PackageManager int ), 0, this, packageManager, n);
    }

    public List<String> getCarrierPackageNamesForIntent(PackageManager packageManager, Intent intent) {
        return InvokeDynamicSupport.bootstrap("getCarrierPackageNamesForIntent", $$robo$$com_android_internal_telephony_uicc_UiccProfile$getCarrierPackageNamesForIntent(android.content.pm.PackageManager android.content.Intent ), 0, this, packageManager, intent);
    }

    private UiccCarrierPrivilegeRules getCarrierPrivilegeRules() {
        return InvokeDynamicSupport.bootstrap("getCarrierPrivilegeRules", $$robo$$com_android_internal_telephony_uicc_UiccProfile$getCarrierPrivilegeRules(), 0, this);
    }

    public boolean setOperatorBrandOverride(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setOperatorBrandOverride", $$robo$$com_android_internal_telephony_uicc_UiccProfile$setOperatorBrandOverride(java.lang.String ), 0, this, string2);
    }

    public String getOperatorBrandOverride() {
        return InvokeDynamicSupport.bootstrap("getOperatorBrandOverride", $$robo$$com_android_internal_telephony_uicc_UiccProfile$getOperatorBrandOverride(), 0, this);
    }

    public String getIccId() {
        return InvokeDynamicSupport.bootstrap("getIccId", $$robo$$com_android_internal_telephony_uicc_UiccProfile$getIccId(), 0, this);
    }

    private static void log(String string2) {
        InvokeDynamicSupport.bootstrapStatic("log", $$robo$$com_android_internal_telephony_uicc_UiccProfile$log(java.lang.String ), 0, (String)string2);
    }

    private static void loge(String string2) {
        InvokeDynamicSupport.bootstrapStatic("loge", $$robo$$com_android_internal_telephony_uicc_UiccProfile$loge(java.lang.String ), 0, (String)string2);
    }

    private void loglocal(String string2) {
        InvokeDynamicSupport.bootstrap("loglocal", $$robo$$com_android_internal_telephony_uicc_UiccProfile$loglocal(java.lang.String ), 0, this, string2);
    }

    public void refresh() {
        InvokeDynamicSupport.bootstrap("refresh", $$robo$$com_android_internal_telephony_uicc_UiccProfile$refresh(), 0, this);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_uicc_UiccProfile$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    public /* synthetic */ UiccProfile() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UiccProfile)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

