/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.telephony.Rlog;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.uicc.AnswerToReset;
import com.android.internal.telephony.uicc.IccCardStatus;
import com.android.internal.telephony.uicc.IccSlotStatus;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccController;
import com.android.internal.telephony.uicc.euicc.EuiccCard;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class UiccSlot
extends Handler
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "UiccSlot";
    private static boolean DBG = true;
    public static String EXTRA_ICC_CARD_ADDED = "com.android.internal.telephony.uicc.ICC_CARD_ADDED";
    public static int INVALID_PHONE_ID = -1;
    private Object mLock;
    private boolean mActive;
    private boolean mStateIsUnknown;
    private IccCardStatus.CardState mCardState;
    private Context mContext;
    private CommandsInterface mCi;
    private UiccCard mUiccCard;
    private CommandsInterface.RadioState mLastRadioState;
    private boolean mIsEuicc;
    private String mIccId;
    private AnswerToReset mAtr;
    private int mPhoneId;
    private static int EVENT_CARD_REMOVED = 13;
    private static int EVENT_CARD_ADDED = 14;

    private void $$robo$$com_android_internal_telephony_uicc_UiccSlot$__constructor__(Context c, boolean isActive) {
        this.mLock = new Object();
        this.mStateIsUnknown = true;
        this.mLastRadioState = CommandsInterface.RadioState.RADIO_UNAVAILABLE;
        this.mPhoneId = -1;
        this.log("Creating");
        this.mContext = c;
        this.mActive = isActive;
        this.mCardState = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccSlot$update(CommandsInterface ci, IccCardStatus ics, int phoneId) {
        this.log("cardStatus update: " + ics.toString());
        Object object = this.mLock;
        synchronized (object) {
            IccCardStatus.CardState oldState = this.mCardState;
            this.mCardState = ics.mCardState;
            this.mIccId = ics.iccid;
            this.mPhoneId = phoneId;
            this.parseAtr(ics.atr);
            this.mCi = ci;
            CommandsInterface.RadioState radioState = this.mCi.getRadioState();
            this.log("update: radioState=" + (Object)((Object)radioState) + " mLastRadioState=" + (Object)((Object)this.mLastRadioState));
            if (this.absentStateUpdateNeeded(oldState)) {
                this.updateCardStateAbsent();
            } else if ((oldState == null || oldState == IccCardStatus.CardState.CARDSTATE_ABSENT || this.mUiccCard == null) && this.mCardState != IccCardStatus.CardState.CARDSTATE_ABSENT) {
                if (radioState == CommandsInterface.RadioState.RADIO_ON && this.mLastRadioState == CommandsInterface.RadioState.RADIO_ON) {
                    this.log("update: notify card added");
                    this.sendMessage(this.obtainMessage(14, null));
                }
                if (this.mUiccCard != null) {
                    this.loge("update: mUiccCard != null when card was present; disposing it now");
                    this.mUiccCard.dispose();
                }
                this.mUiccCard = !this.mIsEuicc ? new UiccCard(this.mContext, this.mCi, ics, this.mPhoneId, this.mLock) : new EuiccCard(this.mContext, this.mCi, ics, phoneId, this.mLock);
            } else if (this.mUiccCard != null) {
                this.mUiccCard.update(this.mContext, this.mCi, ics);
            }
            this.mLastRadioState = radioState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccSlot$update(CommandsInterface ci, IccSlotStatus iss) {
        this.log("slotStatus update: " + iss.toString());
        Object object = this.mLock;
        synchronized (object) {
            IccCardStatus.CardState oldState = this.mCardState;
            this.mCi = ci;
            this.parseAtr(iss.atr);
            this.mCardState = iss.cardState;
            this.mIccId = iss.iccid;
            if (iss.slotState == IccSlotStatus.SlotState.SLOTSTATE_INACTIVE) {
                if (this.mActive) {
                    this.mActive = false;
                    this.mLastRadioState = CommandsInterface.RadioState.RADIO_UNAVAILABLE;
                    this.mPhoneId = -1;
                    if (this.mUiccCard != null) {
                        this.mUiccCard.dispose();
                    }
                    this.nullifyUiccCard(true);
                }
            } else {
                this.mActive = true;
                this.mPhoneId = iss.logicalSlotIndex;
                if (this.absentStateUpdateNeeded(oldState)) {
                    this.updateCardStateAbsent();
                }
            }
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccSlot$absentStateUpdateNeeded(IccCardStatus.CardState oldState) {
        return (oldState != IccCardStatus.CardState.CARDSTATE_ABSENT || this.mUiccCard != null) && this.mCardState == IccCardStatus.CardState.CARDSTATE_ABSENT;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccSlot$updateCardStateAbsent() {
        CommandsInterface.RadioState radioState;
        CommandsInterface.RadioState radioState2 = radioState = this.mCi == null ? CommandsInterface.RadioState.RADIO_UNAVAILABLE : this.mCi.getRadioState();
        if (radioState == CommandsInterface.RadioState.RADIO_ON && this.mLastRadioState == CommandsInterface.RadioState.RADIO_ON) {
            this.log("update: notify card removed");
            this.sendMessage(this.obtainMessage(13, null));
        }
        UiccController.updateInternalIccState("ABSENT", null, this.mPhoneId);
        if (this.mUiccCard != null) {
            this.mUiccCard.dispose();
        }
        this.nullifyUiccCard(false);
        this.mLastRadioState = radioState;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccSlot$nullifyUiccCard(boolean stateUnknown) {
        this.mStateIsUnknown = stateUnknown;
        this.mUiccCard = null;
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccSlot$isStateUnknown() {
        return (this.mCardState == null || this.mCardState == IccCardStatus.CardState.CARDSTATE_ABSENT) && this.mStateIsUnknown;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccSlot$checkIsEuiccSupported() {
        this.mIsEuicc = this.mAtr != null && this.mAtr.isEuiccSupported();
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccSlot$parseAtr(String atr) {
        this.mAtr = AnswerToReset.parseAtr(atr);
        if (this.mAtr == null) {
            return;
        }
        this.checkIsEuiccSupported();
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccSlot$isEuicc() {
        return this.mIsEuicc;
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccSlot$isActive() {
        return this.mActive;
    }

    private final int $$robo$$com_android_internal_telephony_uicc_UiccSlot$getPhoneId() {
        return this.mPhoneId;
    }

    private final String $$robo$$com_android_internal_telephony_uicc_UiccSlot$getIccId() {
        if (this.mIccId != null) {
            return this.mIccId;
        }
        if (this.mUiccCard != null) {
            return this.mUiccCard.getIccId();
        }
        return null;
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_UiccSlot$isExtendedApduSupported() {
        return this.mAtr != null && this.mAtr.isExtendedApduSupported();
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccSlot$finalize() {
        this.log("UiccSlot finalized");
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccSlot$onIccSwap(boolean isAdded) {
        boolean isHotSwapSupported = this.mContext.getResources().getBoolean(17956985);
        if (isHotSwapSupported) {
            this.log("onIccSwap: isHotSwapSupported is true, don't prompt for rebooting");
            return;
        }
        this.log("onIccSwap: isHotSwapSupported is false, prompt for rebooting");
        this.promptForRestart(isAdded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_UiccSlot$promptForRestart(boolean isAdded) {
        Object object = this.mLock;
        synchronized (object) {
            Resources res = this.mContext.getResources();
            String dialogComponent = res.getString(17039687);
            if (dialogComponent != null) {
                Intent intent = new Intent().setComponent(ComponentName.unflattenFromString(dialogComponent)).addFlags(0x10000000).putExtra("com.android.internal.telephony.uicc.ICC_CARD_ADDED", isAdded);
                try {
                    this.mContext.startActivity(intent);
                    return;
                }
                catch (ActivityNotFoundException e) {
                    this.loge("Unable to find ICC hotswap prompt for restart activity: " + e);
                }
            }
            DialogInterface.OnClickListener listener = null;
            listener = new DialogInterface.OnClickListener(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ UiccSlot this$0;

                private void $$robo$$com_android_internal_telephony_uicc_UiccSlot_1$__constructor__(UiccSlot this$0) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$com_android_internal_telephony_uicc_UiccSlot_1$onClick(DialogInterface dialog, int which) {
                    Object object = this.this$0.mLock;
                    synchronized (object) {
                        if (which == -1) {
                            this.this$0.log("Reboot due to SIM swap");
                            PowerManager pm = (PowerManager)this.this$0.mContext.getSystemService("power");
                            pm.reboot("SIM is added.");
                        }
                    }
                }

                private void __constructor__(UiccSlot uiccSlot) {
                    this.$$robo$$com_android_internal_telephony_uicc_UiccSlot_1$__constructor__(uiccSlot);
                }
                {
                    this.this$0 = uiccSlot;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_UiccSlot_1$__constructor__(com.android.internal.telephony.uicc.UiccSlot ), 0, this, uiccSlot);
                }

                @Override
                public void onClick(DialogInterface dialogInterface, int n) {
                    InvokeDynamicSupport.bootstrap("onClick", $$robo$$com_android_internal_telephony_uicc_UiccSlot_1$onClick(android.content.DialogInterface int ), 0, this, dialogInterface, n);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            Resources r = Resources.getSystem();
            String title = isAdded ? r.getString(17040874) : r.getString(17040877);
            String message = isAdded ? r.getString(17040873) : r.getString(17040876);
            String buttonTxt = r.getString(17040878);
            AlertDialog dialog = new AlertDialog.Builder(this.mContext).setTitle(title).setMessage(message).setPositiveButton(buttonTxt, listener).create();
            dialog.getWindow().setType(2003);
            dialog.show();
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccSlot$handleMessage(Message msg) {
        switch (msg.what) {
            case 13: {
                this.onIccSwap(false);
                break;
            }
            case 14: {
                this.onIccSwap(true);
                break;
            }
            default: {
                this.loge("Unknown Event " + msg.what);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IccCardStatus.CardState $$robo$$com_android_internal_telephony_uicc_UiccSlot$getCardState() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCardState == null) {
                return IccCardStatus.CardState.CARDSTATE_ABSENT;
            }
            return this.mCardState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final UiccCard $$robo$$com_android_internal_telephony_uicc_UiccSlot$getUiccCard() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mUiccCard;
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccSlot$onRadioStateUnavailable() {
        if (this.mUiccCard != null) {
            this.mUiccCard.dispose();
        }
        this.nullifyUiccCard(true);
        if (this.mPhoneId != -1) {
            UiccController.updateInternalIccState("UNKNOWN", null, this.mPhoneId);
        }
        this.mCardState = IccCardStatus.CardState.CARDSTATE_ABSENT;
        this.mLastRadioState = CommandsInterface.RadioState.RADIO_UNAVAILABLE;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccSlot$log(String msg) {
        Rlog.d("UiccSlot", msg);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccSlot$loge(String msg) {
        Rlog.e("UiccSlot", msg);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_UiccSlot$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("UiccSlot:");
        pw.println(" mCi=" + this.mCi);
        pw.println(" mActive=" + this.mActive);
        pw.println(" mLastRadioState=" + (Object)((Object)this.mLastRadioState));
        pw.println(" mCardState=" + (Object)((Object)this.mCardState));
        if (this.mUiccCard != null) {
            pw.println(" mUiccCard=" + this.mUiccCard);
            this.mUiccCard.dump(fd, pw, args);
        } else {
            pw.println(" mUiccCard=null");
        }
        pw.println();
        pw.flush();
        pw.flush();
    }

    private void __constructor__(Context context, boolean bl) {
        this.$$robo$$com_android_internal_telephony_uicc_UiccSlot$__constructor__(context, bl);
    }

    public UiccSlot(Context context, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_UiccSlot$__constructor__(android.content.Context boolean ), 0, this, context, bl);
    }

    public void update(CommandsInterface commandsInterface, IccCardStatus iccCardStatus, int n) {
        InvokeDynamicSupport.bootstrap("update", $$robo$$com_android_internal_telephony_uicc_UiccSlot$update(com.android.internal.telephony.CommandsInterface com.android.internal.telephony.uicc.IccCardStatus int ), 0, this, commandsInterface, iccCardStatus, n);
    }

    public void update(CommandsInterface commandsInterface, IccSlotStatus iccSlotStatus) {
        InvokeDynamicSupport.bootstrap("update", $$robo$$com_android_internal_telephony_uicc_UiccSlot$update(com.android.internal.telephony.CommandsInterface com.android.internal.telephony.uicc.IccSlotStatus ), 0, this, commandsInterface, iccSlotStatus);
    }

    private boolean absentStateUpdateNeeded(IccCardStatus.CardState cardState) {
        return (boolean)InvokeDynamicSupport.bootstrap("absentStateUpdateNeeded", $$robo$$com_android_internal_telephony_uicc_UiccSlot$absentStateUpdateNeeded(com.android.internal.telephony.uicc.IccCardStatus$CardState ), 0, this, cardState);
    }

    private void updateCardStateAbsent() {
        InvokeDynamicSupport.bootstrap("updateCardStateAbsent", $$robo$$com_android_internal_telephony_uicc_UiccSlot$updateCardStateAbsent(), 0, this);
    }

    private void nullifyUiccCard(boolean bl) {
        InvokeDynamicSupport.bootstrap("nullifyUiccCard", $$robo$$com_android_internal_telephony_uicc_UiccSlot$nullifyUiccCard(boolean ), 0, this, bl);
    }

    public boolean isStateUnknown() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStateUnknown", $$robo$$com_android_internal_telephony_uicc_UiccSlot$isStateUnknown(), 0, this);
    }

    private void checkIsEuiccSupported() {
        InvokeDynamicSupport.bootstrap("checkIsEuiccSupported", $$robo$$com_android_internal_telephony_uicc_UiccSlot$checkIsEuiccSupported(), 0, this);
    }

    private void parseAtr(String string2) {
        InvokeDynamicSupport.bootstrap("parseAtr", $$robo$$com_android_internal_telephony_uicc_UiccSlot$parseAtr(java.lang.String ), 0, this, string2);
    }

    public boolean isEuicc() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEuicc", $$robo$$com_android_internal_telephony_uicc_UiccSlot$isEuicc(), 0, this);
    }

    public boolean isActive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isActive", $$robo$$com_android_internal_telephony_uicc_UiccSlot$isActive(), 0, this);
    }

    public int getPhoneId() {
        return (int)InvokeDynamicSupport.bootstrap("getPhoneId", $$robo$$com_android_internal_telephony_uicc_UiccSlot$getPhoneId(), 0, this);
    }

    public String getIccId() {
        return InvokeDynamicSupport.bootstrap("getIccId", $$robo$$com_android_internal_telephony_uicc_UiccSlot$getIccId(), 0, this);
    }

    public boolean isExtendedApduSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isExtendedApduSupported", $$robo$$com_android_internal_telephony_uicc_UiccSlot$isExtendedApduSupported(), 0, this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$com_android_internal_telephony_uicc_UiccSlot$finalize(), 0, this);
    }

    private void onIccSwap(boolean bl) {
        InvokeDynamicSupport.bootstrap("onIccSwap", $$robo$$com_android_internal_telephony_uicc_UiccSlot$onIccSwap(boolean ), 0, this, bl);
    }

    private void promptForRestart(boolean bl) {
        InvokeDynamicSupport.bootstrap("promptForRestart", $$robo$$com_android_internal_telephony_uicc_UiccSlot$promptForRestart(boolean ), 0, this, bl);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_uicc_UiccSlot$handleMessage(android.os.Message ), 0, this, message);
    }

    public IccCardStatus.CardState getCardState() {
        return InvokeDynamicSupport.bootstrap("getCardState", $$robo$$com_android_internal_telephony_uicc_UiccSlot$getCardState(), 0, this);
    }

    public UiccCard getUiccCard() {
        return InvokeDynamicSupport.bootstrap("getUiccCard", $$robo$$com_android_internal_telephony_uicc_UiccSlot$getUiccCard(), 0, this);
    }

    public void onRadioStateUnavailable() {
        InvokeDynamicSupport.bootstrap("onRadioStateUnavailable", $$robo$$com_android_internal_telephony_uicc_UiccSlot$onRadioStateUnavailable(), 0, this);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_uicc_UiccSlot$log(java.lang.String ), 0, this, string2);
    }

    private void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_uicc_UiccSlot$loge(java.lang.String ), 0, this, string2);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_uicc_UiccSlot$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    public /* synthetic */ UiccSlot() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UiccSlot)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

