/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc.asn1;

import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.telephony.uicc.asn1.Asn1Node;
import com.android.internal.telephony.uicc.asn1.InvalidAsn1DataException;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Asn1Decoder
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private byte[] mSrc;
    private int mPosition;
    private int mEnd;

    private void $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Decoder$__constructor__(String hex) {
    }

    private void $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Decoder$__constructor__(byte[] src) {
    }

    private void $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Decoder$__constructor__(byte[] bytes, int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > bytes.length) {
            throw new IndexOutOfBoundsException("Out of the bounds: bytes=[" + bytes.length + "], offset=" + offset + ", length=" + length);
        }
        this.mSrc = bytes;
        this.mPosition = offset;
        this.mEnd = offset + length;
    }

    private final int $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Decoder$getPosition() {
        return this.mPosition;
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Decoder$hasNextNode() {
        return this.mPosition < this.mEnd;
    }

    private final Asn1Node $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Decoder$nextNode() throws InvalidAsn1DataException {
        int dataLen;
        int tag;
        int b;
        int offset;
        if (this.mPosition >= this.mEnd) {
            throw new IllegalStateException("No bytes to parse.");
        }
        int tagStart = offset = this.mPosition;
        if (((b = this.mSrc[offset++]) & 0x1F) == 31) {
            while (offset < this.mEnd && (this.mSrc[offset++] & 0x80) != 0) {
            }
        }
        if (offset >= this.mEnd) {
            throw new InvalidAsn1DataException(0, "Invalid length at position: " + offset);
        }
        try {
            tag = IccUtils.bytesToInt(this.mSrc, tagStart, offset - tagStart);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidAsn1DataException(0, "Cannot parse tag at position: " + tagStart, e);
        }
        b = this.mSrc[offset++];
        if ((b & 0x80) == 0) {
            dataLen = b;
        } else {
            int lenLen = b & 0x7F;
            if (offset + lenLen > this.mEnd) {
                throw new InvalidAsn1DataException(tag, "Cannot parse length at position: " + offset);
            }
            try {
                dataLen = IccUtils.bytesToInt(this.mSrc, offset, lenLen);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidAsn1DataException(tag, "Cannot parse length at position: " + offset, e);
            }
            offset += lenLen;
        }
        if (offset + dataLen > this.mEnd) {
            throw new InvalidAsn1DataException(tag, "Incomplete data at position: " + offset + ", expected bytes: " + dataLen + ", actual bytes: " + (this.mEnd - offset));
        }
        Asn1Node root = new Asn1Node(tag, this.mSrc, offset, dataLen);
        this.mPosition = offset + dataLen;
        return root;
    }

    private void __constructor__(String string2) {
        this.$$robo$$com_android_internal_telephony_uicc_asn1_Asn1Decoder$__constructor__(string2);
    }

    public Asn1Decoder(String string2) {
        this(IccUtils.hexStringToBytes(string2));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Decoder$__constructor__(java.lang.String ), 0, this, string2);
    }

    private void __constructor__(byte[] byArray) {
        this.$$robo$$com_android_internal_telephony_uicc_asn1_Asn1Decoder$__constructor__(byArray);
    }

    public Asn1Decoder(byte[] byArray) {
        this(byArray, 0, byArray.length);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Decoder$__constructor__(byte[] ), 0, this, byArray);
    }

    private void __constructor__(byte[] byArray, int n, int n2) {
        this.$$robo$$com_android_internal_telephony_uicc_asn1_Asn1Decoder$__constructor__(byArray, n, n2);
    }

    public Asn1Decoder(byte[] byArray, int n, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Decoder$__constructor__(byte[] int int ), 0, this, byArray, n, n2);
    }

    public int getPosition() {
        return (int)InvokeDynamicSupport.bootstrap("getPosition", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Decoder$getPosition(), 0, this);
    }

    public boolean hasNextNode() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasNextNode", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Decoder$hasNextNode(), 0, this);
    }

    public Asn1Node nextNode() throws InvalidAsn1DataException {
        return InvokeDynamicSupport.bootstrap("nextNode", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Decoder$nextNode(), 0, this);
    }

    public /* synthetic */ Asn1Decoder() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Asn1Decoder)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

