/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc.asn1;

import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.telephony.uicc.asn1.Asn1Decoder;
import com.android.internal.telephony.uicc.asn1.InvalidAsn1DataException;
import com.android.internal.telephony.uicc.asn1.TagNotFoundException;
import com.google.errorprone.annotations.DoNotMock;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Asn1Node
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int INT_BYTES = 4;
    private static List<Asn1Node> EMPTY_NODE_LIST;
    private static byte[] TRUE_BYTES;
    private static byte[] FALSE_BYTES;
    private int mTag;
    private boolean mConstructed;
    private List<Asn1Node> mChildren;
    private byte[] mDataBytes;
    private int mDataOffset;
    private int mDataLength;
    private int mEncodedLength;

    private static final Builder $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$newBuilder(int tag) {
        return new Builder(tag);
    }

    private static final boolean $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$isConstructedTag(int tag) {
        byte[] tagBytes = IccUtils.unsignedIntToBytes(tag);
        return (tagBytes[0] & 0x20) != 0;
    }

    private static final int $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$calculateEncodedBytesNumForLength(int length) {
        int len = 1;
        if (length > 127) {
            len += IccUtils.byteNumForUnsignedInt(length);
        }
        return len;
    }

    private void $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$__constructor__(int tag, byte[] src, int offset, int length) {
        this.mTag = tag;
        this.mConstructed = Asn1Node.isConstructedTag(tag);
        this.mDataBytes = src;
        this.mDataOffset = offset;
        this.mDataLength = length;
        this.mChildren = this.mConstructed ? new ArrayList() : EMPTY_NODE_LIST;
        this.mEncodedLength = IccUtils.byteNumForUnsignedInt(this.mTag) + Asn1Node.calculateEncodedBytesNumForLength(this.mDataLength) + this.mDataLength;
    }

    private void $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$__constructor__(int tag, List<Asn1Node> children) {
        this.mTag = tag;
        this.mConstructed = true;
        this.mChildren = children;
        this.mDataLength = 0;
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            this.mDataLength += children.get((int)i).mEncodedLength;
        }
        this.mEncodedLength = IccUtils.byteNumForUnsignedInt(this.mTag) + Asn1Node.calculateEncodedBytesNumForLength(this.mDataLength) + this.mDataLength;
    }

    private final int $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$getTag() {
        return this.mTag;
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$isConstructed() {
        return this.mConstructed;
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$hasChild(int tag, int ... tags) throws InvalidAsn1DataException {
        try {
            this.getChild(tag, tags);
        }
        catch (TagNotFoundException e) {
            return false;
        }
        return true;
    }

    private final Asn1Node $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$getChild(int tag, int ... tags) throws TagNotFoundException, InvalidAsn1DataException {
        if (!this.mConstructed) {
            throw new TagNotFoundException(tag);
        }
        int index = 0;
        Asn1Node node = this;
        while (node != null) {
            List<Asn1Node> children = node.getChildren();
            int size = children.size();
            Asn1Node foundChild = null;
            for (int i = 0; i < size; ++i) {
                Asn1Node child = children.get(i);
                if (child.getTag() != tag) continue;
                foundChild = child;
                break;
            }
            node = foundChild;
            if (index >= tags.length) break;
            tag = tags[index++];
        }
        if (node == null) {
            throw new TagNotFoundException(tag);
        }
        return node;
    }

    private final List<Asn1Node> $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$getChildren(int tag) throws TagNotFoundException, InvalidAsn1DataException {
        if (!this.mConstructed) {
            return EMPTY_NODE_LIST;
        }
        List<Asn1Node> children = this.getChildren();
        if (children.isEmpty()) {
            return EMPTY_NODE_LIST;
        }
        ArrayList<Asn1Node> output = new ArrayList<Asn1Node>();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            Asn1Node child = children.get(i);
            if (child.getTag() != tag) continue;
            output.add(child);
        }
        return output.isEmpty() ? EMPTY_NODE_LIST : output;
    }

    private final List<Asn1Node> $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$getChildren() throws InvalidAsn1DataException {
        if (!this.mConstructed) {
            return EMPTY_NODE_LIST;
        }
        if (this.mDataBytes != null) {
            Asn1Decoder subDecoder = new Asn1Decoder(this.mDataBytes, this.mDataOffset, this.mDataLength);
            while (subDecoder.hasNextNode()) {
                this.mChildren.add(subDecoder.nextNode());
            }
            this.mDataBytes = null;
            this.mDataOffset = 0;
        }
        return this.mChildren;
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$hasValue() {
        return !this.mConstructed && this.mDataBytes != null;
    }

    private final int $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$asInteger() throws InvalidAsn1DataException {
        if (this.mConstructed) {
            throw new IllegalStateException("Cannot get value of a constructed node.");
        }
        if (this.mDataBytes == null) {
            throw new InvalidAsn1DataException(this.mTag, "Data bytes cannot be null.");
        }
        try {
            return IccUtils.bytesToInt(this.mDataBytes, this.mDataOffset, this.mDataLength);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new InvalidAsn1DataException(this.mTag, "Cannot parse data bytes.", e);
        }
    }

    private final long $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$asRawLong() throws InvalidAsn1DataException {
        if (this.mConstructed) {
            throw new IllegalStateException("Cannot get value of a constructed node.");
        }
        if (this.mDataBytes == null) {
            throw new InvalidAsn1DataException(this.mTag, "Data bytes cannot be null.");
        }
        try {
            return IccUtils.bytesToRawLong(this.mDataBytes, this.mDataOffset, this.mDataLength);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new InvalidAsn1DataException(this.mTag, "Cannot parse data bytes.", e);
        }
    }

    private final String $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$asString() throws InvalidAsn1DataException {
        if (this.mConstructed) {
            throw new IllegalStateException("Cannot get value of a constructed node.");
        }
        if (this.mDataBytes == null) {
            throw new InvalidAsn1DataException(this.mTag, "Data bytes cannot be null.");
        }
        try {
            return new String(this.mDataBytes, this.mDataOffset, this.mDataLength, StandardCharsets.UTF_8);
        }
        catch (IndexOutOfBoundsException e) {
            throw new InvalidAsn1DataException(this.mTag, "Cannot parse data bytes.", e);
        }
    }

    private final byte[] $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$asBytes() throws InvalidAsn1DataException {
        if (this.mConstructed) {
            throw new IllegalStateException("Cannot get value of a constructed node.");
        }
        if (this.mDataBytes == null) {
            throw new InvalidAsn1DataException(this.mTag, "Data bytes cannot be null.");
        }
        byte[] output = new byte[this.mDataLength];
        try {
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])this.mDataBytes, (int)this.mDataOffset, (byte[])output, (int)0, (int)this.mDataLength);
        }
        catch (IndexOutOfBoundsException e) {
            throw new InvalidAsn1DataException(this.mTag, "Cannot parse data bytes.", e);
        }
        return output;
    }

    private final int $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$asBits() throws InvalidAsn1DataException {
        int bits;
        if (this.mConstructed) {
            throw new IllegalStateException("Cannot get value of a constructed node.");
        }
        if (this.mDataBytes == null) {
            throw new InvalidAsn1DataException(this.mTag, "Data bytes cannot be null.");
        }
        try {
            bits = IccUtils.bytesToInt(this.mDataBytes, this.mDataOffset + 1, this.mDataLength - 1);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new InvalidAsn1DataException(this.mTag, "Cannot parse data bytes.", e);
        }
        for (int i = this.mDataLength - 1; i < 4; ++i) {
            bits <<= 8;
        }
        return Integer.reverse(bits);
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$asBoolean() throws InvalidAsn1DataException {
        if (this.mConstructed) {
            throw new IllegalStateException("Cannot get value of a constructed node.");
        }
        if (this.mDataBytes == null) {
            throw new InvalidAsn1DataException(this.mTag, "Data bytes cannot be null.");
        }
        if (this.mDataLength != 1) {
            throw new InvalidAsn1DataException(this.mTag, "Cannot parse data bytes as boolean: length=" + this.mDataLength);
        }
        if (this.mDataOffset < 0 || this.mDataOffset >= this.mDataBytes.length) {
            throw new InvalidAsn1DataException(this.mTag, "Cannot parse data bytes.", new ArrayIndexOutOfBoundsException(this.mDataOffset));
        }
        if (this.mDataBytes[this.mDataOffset] == -1) {
            return Boolean.TRUE;
        }
        if (this.mDataBytes[this.mDataOffset] == 0) {
            return Boolean.FALSE;
        }
        throw new InvalidAsn1DataException(this.mTag, "Cannot parse data bytes as boolean: " + this.mDataBytes[this.mDataOffset]);
    }

    private final int $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$getEncodedLength() {
        return this.mEncodedLength;
    }

    private final int $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$getDataLength() {
        return this.mDataLength;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$writeToBytes(byte[] dest, int offset) {
        if (offset < 0 || offset + this.mEncodedLength > dest.length) {
            throw new IndexOutOfBoundsException("Not enough space to write. Required bytes: " + this.mEncodedLength);
        }
        this.write(dest, offset);
    }

    private final byte[] $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$toBytes() {
        byte[] dest = new byte[this.mEncodedLength];
        this.write(dest, 0);
        return dest;
    }

    private final String $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$toHex() {
        return IccUtils.bytesToHexString(this.toBytes());
    }

    private final String $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$getHeadAsHex() {
        String headHex = IccUtils.bytesToHexString(IccUtils.unsignedIntToBytes(this.mTag));
        if (this.mDataLength <= 127) {
            headHex = headHex + IccUtils.byteToHex((byte)this.mDataLength);
        } else {
            byte[] lenBytes = IccUtils.unsignedIntToBytes(this.mDataLength);
            headHex = headHex + IccUtils.byteToHex((byte)(lenBytes.length | 0x80));
            headHex = headHex + IccUtils.bytesToHexString(lenBytes);
        }
        return headHex;
    }

    private final int $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$write(byte[] dest, int offset) {
        offset += IccUtils.unsignedIntToBytes(this.mTag, dest, offset);
        if (this.mDataLength <= 127) {
            dest[offset++] = (byte)this.mDataLength;
        } else {
            int lenLen = IccUtils.unsignedIntToBytes(this.mDataLength, dest, ++offset);
            dest[offset - 1] = (byte)(lenLen | 0x80);
            offset += lenLen;
        }
        if (this.mConstructed && this.mDataBytes == null) {
            int size = this.mChildren.size();
            for (int i = 0; i < size; ++i) {
                Asn1Node child = this.mChildren.get(i);
                offset = child.write(dest, offset);
            }
        } else if (this.mDataBytes != null) {
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])this.mDataBytes, (int)this.mDataOffset, (byte[])dest, (int)offset, (int)this.mDataLength);
            offset += this.mDataLength;
        }
        return offset;
    }

    private /* synthetic */ void $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$__constructor__(int x0, List x1, 1 x2) {
    }

    static void __staticInitializer__() {
        EMPTY_NODE_LIST = Collections.emptyList();
        TRUE_BYTES = new byte[]{-1};
        FALSE_BYTES = new byte[]{0};
    }

    public static Builder newBuilder(int n) {
        return InvokeDynamicSupport.bootstrapStatic("newBuilder", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$newBuilder(int ), 0, (int)n);
    }

    private static boolean isConstructedTag(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isConstructedTag", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$isConstructedTag(int ), 0, (int)n);
    }

    private static int calculateEncodedBytesNumForLength(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("calculateEncodedBytesNumForLength", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$calculateEncodedBytesNumForLength(int ), 0, (int)n);
    }

    private void __constructor__(int n, byte[] byArray, int n2, int n3) {
        this.$$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$__constructor__(n, byArray, n2, n3);
    }

    Asn1Node(int n, byte[] byArray, int n2, int n3) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$__constructor__(int byte[] int int ), 0, this, n, byArray, n2, n3);
    }

    private void __constructor__(int n, List<Asn1Node> list) {
        this.$$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$__constructor__(n, list);
    }

    private Asn1Node(int n, List<Asn1Node> list) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$__constructor__(int java.util.List<com.android.internal.telephony.uicc.asn1.Asn1Node> ), 0, this, n, list);
    }

    public int getTag() {
        return (int)InvokeDynamicSupport.bootstrap("getTag", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$getTag(), 0, this);
    }

    public boolean isConstructed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isConstructed", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$isConstructed(), 0, this);
    }

    public boolean hasChild(int n, int ... nArray) throws InvalidAsn1DataException {
        return (boolean)InvokeDynamicSupport.bootstrap("hasChild", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$hasChild(int int[] ), 0, this, n, nArray);
    }

    public Asn1Node getChild(int n, int ... nArray) throws TagNotFoundException, InvalidAsn1DataException {
        return InvokeDynamicSupport.bootstrap("getChild", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$getChild(int int[] ), 0, this, n, nArray);
    }

    public List<Asn1Node> getChildren(int n) throws TagNotFoundException, InvalidAsn1DataException {
        return InvokeDynamicSupport.bootstrap("getChildren", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$getChildren(int ), 0, this, n);
    }

    public List<Asn1Node> getChildren() throws InvalidAsn1DataException {
        return InvokeDynamicSupport.bootstrap("getChildren", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$getChildren(), 0, this);
    }

    public boolean hasValue() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasValue", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$hasValue(), 0, this);
    }

    public int asInteger() throws InvalidAsn1DataException {
        return (int)InvokeDynamicSupport.bootstrap("asInteger", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$asInteger(), 0, this);
    }

    public long asRawLong() throws InvalidAsn1DataException {
        return (long)InvokeDynamicSupport.bootstrap("asRawLong", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$asRawLong(), 0, this);
    }

    public String asString() throws InvalidAsn1DataException {
        return InvokeDynamicSupport.bootstrap("asString", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$asString(), 0, this);
    }

    public byte[] asBytes() throws InvalidAsn1DataException {
        return InvokeDynamicSupport.bootstrap("asBytes", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$asBytes(), 0, this);
    }

    public int asBits() throws InvalidAsn1DataException {
        return (int)InvokeDynamicSupport.bootstrap("asBits", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$asBits(), 0, this);
    }

    public boolean asBoolean() throws InvalidAsn1DataException {
        return (boolean)InvokeDynamicSupport.bootstrap("asBoolean", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$asBoolean(), 0, this);
    }

    public int getEncodedLength() {
        return (int)InvokeDynamicSupport.bootstrap("getEncodedLength", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$getEncodedLength(), 0, this);
    }

    public int getDataLength() {
        return (int)InvokeDynamicSupport.bootstrap("getDataLength", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$getDataLength(), 0, this);
    }

    public void writeToBytes(byte[] byArray, int n) {
        InvokeDynamicSupport.bootstrap("writeToBytes", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$writeToBytes(byte[] int ), 0, this, byArray, n);
    }

    public byte[] toBytes() {
        return InvokeDynamicSupport.bootstrap("toBytes", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$toBytes(), 0, this);
    }

    public String toHex() {
        return InvokeDynamicSupport.bootstrap("toHex", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$toHex(), 0, this);
    }

    public String getHeadAsHex() {
        return InvokeDynamicSupport.bootstrap("getHeadAsHex", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$getHeadAsHex(), 0, this);
    }

    private int write(byte[] byArray, int n) {
        return (int)InvokeDynamicSupport.bootstrap("write", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$write(byte[] int ), 0, this, byArray, n);
    }

    private /* synthetic */ void __constructor__(int n, List list, 1 var3_3) {
        this.$$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node$__constructor__(n, list, var3_3);
    }

    static {
        RobolectricInternals.classInitializing(Asn1Node.class);
    }

    public /* synthetic */ Asn1Node() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Asn1Node)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mTag;
        private List<Asn1Node> mChildren;

        private void $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node_Builder$__constructor__(int tag) {
            if (!Asn1Node.isConstructedTag(tag)) {
                throw new IllegalArgumentException("Builder should be created for a constructed tag: " + tag);
            }
            this.mTag = tag;
            this.mChildren = new ArrayList<Asn1Node>();
        }

        private final Builder $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node_Builder$addChild(Asn1Node child) {
            this.mChildren.add(child);
            return this;
        }

        private final Builder $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node_Builder$addChild(Builder child) {
            this.mChildren.add(child.build());
            return this;
        }

        private final Builder $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node_Builder$addChildren(byte[] encodedBytes) throws InvalidAsn1DataException {
            Asn1Decoder subDecoder = new Asn1Decoder(encodedBytes, 0, encodedBytes.length);
            while (subDecoder.hasNextNode()) {
                this.mChildren.add(subDecoder.nextNode());
            }
            return this;
        }

        private final Builder $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node_Builder$addChildAsInteger(int tag, int value) {
            if (Asn1Node.isConstructedTag(tag)) {
                throw new IllegalStateException("Cannot set value of a constructed tag: " + tag);
            }
            byte[] dataBytes = IccUtils.signedIntToBytes(value);
            this.addChild(new Asn1Node(tag, dataBytes, 0, dataBytes.length));
            return this;
        }

        private final Builder $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node_Builder$addChildAsString(int tag, String value) {
            if (Asn1Node.isConstructedTag(tag)) {
                throw new IllegalStateException("Cannot set value of a constructed tag: " + tag);
            }
            byte[] dataBytes = value.getBytes(StandardCharsets.UTF_8);
            this.addChild(new Asn1Node(tag, dataBytes, 0, dataBytes.length));
            return this;
        }

        private final Builder $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node_Builder$addChildAsBytes(int tag, byte[] value) {
            if (Asn1Node.isConstructedTag(tag)) {
                throw new IllegalStateException("Cannot set value of a constructed tag: " + tag);
            }
            this.addChild(new Asn1Node(tag, value, 0, value.length));
            return this;
        }

        private final Builder $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node_Builder$addChildAsBytesFromHex(int tag, String hex) {
            return this.addChildAsBytes(tag, IccUtils.hexStringToBytes(hex));
        }

        private final Builder $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node_Builder$addChildAsBits(int tag, int value) {
            if (Asn1Node.isConstructedTag(tag)) {
                throw new IllegalStateException("Cannot set value of a constructed tag: " + tag);
            }
            byte[] dataBytes = new byte[5];
            value = Integer.reverse(value);
            int dataLength = 0;
            for (int i = 1; i < dataBytes.length; ++i) {
                dataBytes[i] = (byte)(value >> (4 - i) * 8);
                if (dataBytes[i] == 0) continue;
                dataLength = i;
            }
            dataBytes[0] = IccUtils.countTrailingZeros(dataBytes[++dataLength - 1]);
            this.addChild(new Asn1Node(tag, dataBytes, 0, dataLength));
            return this;
        }

        private final Builder $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node_Builder$addChildAsBoolean(int tag, boolean value) {
            if (Asn1Node.isConstructedTag(tag)) {
                throw new IllegalStateException("Cannot set value of a constructed tag: " + tag);
            }
            this.addChild(new Asn1Node(tag, value ? TRUE_BYTES : FALSE_BYTES, 0, 1));
            return this;
        }

        private final Asn1Node $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node_Builder$build() {
            return new Asn1Node(this.mTag, this.mChildren);
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node_Builder$__constructor__(int x0, 1 x1) {
        }

        private void __constructor__(int n) {
            this.$$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node_Builder$__constructor__(n);
        }

        private Builder(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node_Builder$__constructor__(int ), 0, this, n);
        }

        public Builder addChild(Asn1Node asn1Node) {
            return InvokeDynamicSupport.bootstrap("addChild", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node_Builder$addChild(com.android.internal.telephony.uicc.asn1.Asn1Node ), 0, this, asn1Node);
        }

        public Builder addChild(Builder builder) {
            return InvokeDynamicSupport.bootstrap("addChild", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node_Builder$addChild(com.android.internal.telephony.uicc.asn1.Asn1Node$Builder ), 0, this, builder);
        }

        public Builder addChildren(byte[] byArray) throws InvalidAsn1DataException {
            return InvokeDynamicSupport.bootstrap("addChildren", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node_Builder$addChildren(byte[] ), 0, this, byArray);
        }

        public Builder addChildAsInteger(int n, int n2) {
            return InvokeDynamicSupport.bootstrap("addChildAsInteger", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node_Builder$addChildAsInteger(int int ), 0, this, n, n2);
        }

        public Builder addChildAsString(int n, String string2) {
            return InvokeDynamicSupport.bootstrap("addChildAsString", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node_Builder$addChildAsString(int java.lang.String ), 0, this, n, string2);
        }

        public Builder addChildAsBytes(int n, byte[] byArray) {
            return InvokeDynamicSupport.bootstrap("addChildAsBytes", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node_Builder$addChildAsBytes(int byte[] ), 0, this, n, byArray);
        }

        public Builder addChildAsBytesFromHex(int n, String string2) {
            return InvokeDynamicSupport.bootstrap("addChildAsBytesFromHex", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node_Builder$addChildAsBytesFromHex(int java.lang.String ), 0, this, n, string2);
        }

        public Builder addChildAsBits(int n, int n2) {
            return InvokeDynamicSupport.bootstrap("addChildAsBits", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node_Builder$addChildAsBits(int int ), 0, this, n, n2);
        }

        public Builder addChildAsBoolean(int n, boolean bl) {
            return InvokeDynamicSupport.bootstrap("addChildAsBoolean", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node_Builder$addChildAsBoolean(int boolean ), 0, this, n, bl);
        }

        public Asn1Node build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node_Builder$build(), 0, this);
        }

        private /* synthetic */ void __constructor__(int n, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_uicc_asn1_Asn1Node_Builder$__constructor__(n, var2_2);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

