/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.text.TextUtils;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import java.util.function.IntFunction;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class BitUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;

    private void $$robo$$com_android_internal_util_BitUtils$__constructor__() {
    }

    private static final boolean $$robo$$com_android_internal_util_BitUtils$maskedEquals(long a, long b, long mask) {
        return (a & mask) == (b & mask);
    }

    private static final boolean $$robo$$com_android_internal_util_BitUtils$maskedEquals(byte a, byte b, byte mask) {
        return (a & mask) == (b & mask);
    }

    private static final boolean $$robo$$com_android_internal_util_BitUtils$maskedEquals(byte[] a, byte[] b, byte[] mask) {
        if (a == null || b == null) {
            return a == b;
        }
        Preconditions.checkArgument(a.length == b.length, "Inputs must be of same size");
        if (mask == null) {
            return Arrays.equals(a, b);
        }
        Preconditions.checkArgument(a.length == mask.length, "Mask must be of same size as inputs");
        for (int i = 0; i < mask.length; ++i) {
            if (BitUtils.maskedEquals(a[i], b[i], mask[i])) continue;
            return false;
        }
        return true;
    }

    private static final boolean $$robo$$com_android_internal_util_BitUtils$maskedEquals(UUID a, UUID b, UUID mask) {
        if (mask == null) {
            return Objects.equals(a, b);
        }
        return BitUtils.maskedEquals(a.getLeastSignificantBits(), b.getLeastSignificantBits(), mask.getLeastSignificantBits()) && BitUtils.maskedEquals(a.getMostSignificantBits(), b.getMostSignificantBits(), mask.getMostSignificantBits());
    }

    private static final int[] $$robo$$com_android_internal_util_BitUtils$unpackBits(long val) {
        int size = Long.bitCount(val);
        int[] result = new int[size];
        int index = 0;
        int bitPos = 0;
        while (val > 0L) {
            if ((val & 1L) == 1L) {
                result[index++] = bitPos;
            }
            val >>= 1;
            ++bitPos;
        }
        return result;
    }

    private static final long $$robo$$com_android_internal_util_BitUtils$packBits(int[] bits) {
        long packed = 0L;
        for (int b : bits) {
            packed |= (long)(1 << b);
        }
        return packed;
    }

    private static final int $$robo$$com_android_internal_util_BitUtils$uint8(byte b) {
        return b & 0xFF;
    }

    private static final int $$robo$$com_android_internal_util_BitUtils$uint16(short s) {
        return s & 0xFFFF;
    }

    private static final int $$robo$$com_android_internal_util_BitUtils$uint16(byte hi, byte lo) {
        return (hi & 0xFF) << 8 | lo & 0xFF;
    }

    private static final long $$robo$$com_android_internal_util_BitUtils$uint32(int i) {
        return (long)i & 0xFFFFFFFFL;
    }

    private static final int $$robo$$com_android_internal_util_BitUtils$bytesToBEInt(byte[] bytes) {
        return (BitUtils.uint8(bytes[0]) << 24) + (BitUtils.uint8(bytes[1]) << 16) + (BitUtils.uint8(bytes[2]) << 8) + BitUtils.uint8(bytes[3]);
    }

    private static final int $$robo$$com_android_internal_util_BitUtils$bytesToLEInt(byte[] bytes) {
        return Integer.reverseBytes(BitUtils.bytesToBEInt(bytes));
    }

    private static final int $$robo$$com_android_internal_util_BitUtils$getUint8(ByteBuffer buffer, int position) {
        return BitUtils.uint8(buffer.get(position));
    }

    private static final int $$robo$$com_android_internal_util_BitUtils$getUint16(ByteBuffer buffer, int position) {
        return BitUtils.uint16(buffer.getShort(position));
    }

    private static final long $$robo$$com_android_internal_util_BitUtils$getUint32(ByteBuffer buffer, int position) {
        return BitUtils.uint32(buffer.getInt(position));
    }

    private static final void $$robo$$com_android_internal_util_BitUtils$put(ByteBuffer buffer, int position, byte[] bytes) {
        int original = buffer.position();
        buffer.position(position);
        buffer.put(bytes);
        buffer.position(original);
    }

    private static final boolean $$robo$$com_android_internal_util_BitUtils$isBitSet(long flags, int bitIndex) {
        return (flags & BitUtils.bitAt(bitIndex)) != 0L;
    }

    private static final long $$robo$$com_android_internal_util_BitUtils$bitAt(int bitIndex) {
        return 1L << bitIndex;
    }

    private static final String $$robo$$com_android_internal_util_BitUtils$flagsToString(int flags, IntFunction<String> getFlagName) {
        StringBuilder builder = new StringBuilder();
        int count = 0;
        while (flags != 0) {
            int flag = 1 << Integer.numberOfTrailingZeros(flags);
            flags &= ~flag;
            if (count > 0) {
                builder.append(", ");
            }
            builder.append(getFlagName.apply(flag));
            ++count;
        }
        TextUtils.wrap(builder, "[", "]");
        return builder.toString();
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_util_BitUtils$__constructor__();
    }

    private BitUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_BitUtils$__constructor__(), 0, this);
    }

    public static boolean maskedEquals(long l, long l2, long l3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("maskedEquals", $$robo$$com_android_internal_util_BitUtils$maskedEquals(long long long ), 0, (long)l, (long)l2, (long)l3);
    }

    public static boolean maskedEquals(byte by, byte by2, byte by3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("maskedEquals", $$robo$$com_android_internal_util_BitUtils$maskedEquals(byte byte byte ), 0, (byte)by, (byte)by2, (byte)by3);
    }

    public static boolean maskedEquals(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("maskedEquals", $$robo$$com_android_internal_util_BitUtils$maskedEquals(byte[] byte[] byte[] ), 0, (byte[])byArray, (byte[])byArray2, (byte[])byArray3);
    }

    public static boolean maskedEquals(UUID uUID, UUID uUID2, UUID uUID3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("maskedEquals", $$robo$$com_android_internal_util_BitUtils$maskedEquals(java.util.UUID java.util.UUID java.util.UUID ), 0, (UUID)uUID, (UUID)uUID2, (UUID)uUID3);
    }

    public static int[] unpackBits(long l) {
        return InvokeDynamicSupport.bootstrapStatic("unpackBits", $$robo$$com_android_internal_util_BitUtils$unpackBits(long ), 0, (long)l);
    }

    public static long packBits(int[] nArray) {
        return (long)InvokeDynamicSupport.bootstrapStatic("packBits", $$robo$$com_android_internal_util_BitUtils$packBits(int[] ), 0, (int[])nArray);
    }

    public static int uint8(byte by) {
        return (int)InvokeDynamicSupport.bootstrapStatic("uint8", $$robo$$com_android_internal_util_BitUtils$uint8(byte ), 0, (byte)by);
    }

    public static int uint16(short s) {
        return (int)InvokeDynamicSupport.bootstrapStatic("uint16", $$robo$$com_android_internal_util_BitUtils$uint16(short ), 0, (short)s);
    }

    public static int uint16(byte by, byte by2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("uint16", $$robo$$com_android_internal_util_BitUtils$uint16(byte byte ), 0, (byte)by, (byte)by2);
    }

    public static long uint32(int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("uint32", $$robo$$com_android_internal_util_BitUtils$uint32(int ), 0, (int)n);
    }

    public static int bytesToBEInt(byte[] byArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("bytesToBEInt", $$robo$$com_android_internal_util_BitUtils$bytesToBEInt(byte[] ), 0, (byte[])byArray);
    }

    public static int bytesToLEInt(byte[] byArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("bytesToLEInt", $$robo$$com_android_internal_util_BitUtils$bytesToLEInt(byte[] ), 0, (byte[])byArray);
    }

    public static int getUint8(ByteBuffer byteBuffer, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getUint8", $$robo$$com_android_internal_util_BitUtils$getUint8(java.nio.ByteBuffer int ), 0, (ByteBuffer)byteBuffer, (int)n);
    }

    public static int getUint16(ByteBuffer byteBuffer, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getUint16", $$robo$$com_android_internal_util_BitUtils$getUint16(java.nio.ByteBuffer int ), 0, (ByteBuffer)byteBuffer, (int)n);
    }

    public static long getUint32(ByteBuffer byteBuffer, int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("getUint32", $$robo$$com_android_internal_util_BitUtils$getUint32(java.nio.ByteBuffer int ), 0, (ByteBuffer)byteBuffer, (int)n);
    }

    public static void put(ByteBuffer byteBuffer, int n, byte[] byArray) {
        InvokeDynamicSupport.bootstrapStatic("put", $$robo$$com_android_internal_util_BitUtils$put(java.nio.ByteBuffer int byte[] ), 0, (ByteBuffer)byteBuffer, (int)n, (byte[])byArray);
    }

    public static boolean isBitSet(long l, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isBitSet", $$robo$$com_android_internal_util_BitUtils$isBitSet(long int ), 0, (long)l, (int)n);
    }

    public static long bitAt(int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("bitAt", $$robo$$com_android_internal_util_BitUtils$bitAt(int ), 0, (int)n);
    }

    public static String flagsToString(int n, IntFunction<String> intFunction) {
        return InvokeDynamicSupport.bootstrapStatic("flagsToString", $$robo$$com_android_internal_util_BitUtils$flagsToString(int java.util.function.IntFunction<java.lang.String> ), 0, (int)n, intFunction);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BitUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

