/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;

public class CallbackRegistry<C, T, A>
implements Cloneable {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "CallbackRegistry";
    private List<C> mCallbacks;
    private long mFirst64Removed;
    private long[] mRemainderRemoved;
    private int mNotificationLevel;
    private NotifierCallback<C, T, A> mNotifier;

    private void $$robo$$com_android_internal_util_CallbackRegistry$__constructor__(NotifierCallback<C, T, A> notifier) {
        this.mCallbacks = new ArrayList<C>();
        this.mFirst64Removed = 0L;
        this.mNotifier = notifier;
    }

    private final synchronized void $$robo$$com_android_internal_util_CallbackRegistry$notifyCallbacks(T sender, int arg, A arg2) {
        ++this.mNotificationLevel;
        this.notifyRecurseLocked(sender, arg, arg2);
        --this.mNotificationLevel;
        if (this.mNotificationLevel == 0) {
            if (this.mRemainderRemoved != null) {
                for (int i = this.mRemainderRemoved.length - 1; i >= 0; --i) {
                    long removedBits = this.mRemainderRemoved[i];
                    if (removedBits == 0L) continue;
                    this.removeRemovedCallbacks((i + 1) * 64, removedBits);
                    this.mRemainderRemoved[i] = 0L;
                }
            }
            if (this.mFirst64Removed != 0L) {
                this.removeRemovedCallbacks(0, this.mFirst64Removed);
                this.mFirst64Removed = 0L;
            }
        }
    }

    private final void $$robo$$com_android_internal_util_CallbackRegistry$notifyFirst64Locked(T sender, int arg, A arg2) {
        int maxNotified = Math.min(64, this.mCallbacks.size());
        this.notifyCallbacksLocked(sender, arg, arg2, 0, maxNotified, this.mFirst64Removed);
    }

    private final void $$robo$$com_android_internal_util_CallbackRegistry$notifyRecurseLocked(T sender, int arg, A arg2) {
        int callbackCount = this.mCallbacks.size();
        int remainderIndex = this.mRemainderRemoved == null ? -1 : this.mRemainderRemoved.length - 1;
        this.notifyRemainderLocked(sender, arg, arg2, remainderIndex);
        int startCallbackIndex = (remainderIndex + 2) * 64;
        this.notifyCallbacksLocked(sender, arg, arg2, startCallbackIndex, callbackCount, 0L);
    }

    private final void $$robo$$com_android_internal_util_CallbackRegistry$notifyRemainderLocked(T sender, int arg, A arg2, int remainderIndex) {
        if (remainderIndex < 0) {
            this.notifyFirst64Locked(sender, arg, arg2);
        } else {
            long bits = this.mRemainderRemoved[remainderIndex];
            int startIndex = (remainderIndex + 1) * 64;
            int endIndex = Math.min(this.mCallbacks.size(), startIndex + 64);
            this.notifyRemainderLocked(sender, arg, arg2, remainderIndex - 1);
            this.notifyCallbacksLocked(sender, arg, arg2, startIndex, endIndex, bits);
        }
    }

    private final void $$robo$$com_android_internal_util_CallbackRegistry$notifyCallbacksLocked(T sender, int arg, A arg2, int startIndex, int endIndex, long bits) {
        long bitMask = 1L;
        for (int i = startIndex; i < endIndex; ++i) {
            if ((bits & bitMask) == 0L) {
                this.mNotifier.onNotifyCallback(this.mCallbacks.get(i), sender, arg, arg2);
            }
            bitMask <<= 1;
        }
    }

    private final synchronized void $$robo$$com_android_internal_util_CallbackRegistry$add(C callback) {
        int index = this.mCallbacks.lastIndexOf(callback);
        if (index < 0 || this.isRemovedLocked(index)) {
            this.mCallbacks.add(callback);
        }
    }

    private final boolean $$robo$$com_android_internal_util_CallbackRegistry$isRemovedLocked(int index) {
        if (index < 64) {
            long bitMask = 1L << index;
            return (this.mFirst64Removed & bitMask) != 0L;
        }
        if (this.mRemainderRemoved == null) {
            return false;
        }
        int maskIndex = index / 64 - 1;
        if (maskIndex >= this.mRemainderRemoved.length) {
            return false;
        }
        long bits = this.mRemainderRemoved[maskIndex];
        long bitMask = 1L << index % 64;
        return (bits & bitMask) != 0L;
    }

    private final void $$robo$$com_android_internal_util_CallbackRegistry$removeRemovedCallbacks(int startIndex, long removed) {
        int endIndex = startIndex + 64;
        long bitMask = Long.MIN_VALUE;
        for (int i = endIndex - 1; i >= startIndex; --i) {
            if ((removed & bitMask) != 0L) {
                this.mCallbacks.remove(i);
            }
            bitMask >>>= 1;
        }
    }

    private final synchronized void $$robo$$com_android_internal_util_CallbackRegistry$remove(C callback) {
        if (this.mNotificationLevel == 0) {
            this.mCallbacks.remove(callback);
        } else {
            int index = this.mCallbacks.lastIndexOf(callback);
            if (index >= 0) {
                this.setRemovalBitLocked(index);
            }
        }
    }

    private final void $$robo$$com_android_internal_util_CallbackRegistry$setRemovalBitLocked(int index) {
        if (index < 64) {
            long bitMask = 1L << index;
            this.mFirst64Removed |= bitMask;
        } else {
            int remainderIndex = index / 64 - 1;
            if (this.mRemainderRemoved == null) {
                this.mRemainderRemoved = new long[this.mCallbacks.size() / 64];
            } else if (this.mRemainderRemoved.length < remainderIndex) {
                long[] newRemainders = new long[this.mCallbacks.size() / 64];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mRemainderRemoved, (int)0, (Object)newRemainders, (int)0, (int)this.mRemainderRemoved.length);
                this.mRemainderRemoved = newRemainders;
            }
            long bitMask = 1L << index % 64;
            int n = remainderIndex;
            this.mRemainderRemoved[n] = this.mRemainderRemoved[n] | bitMask;
        }
    }

    private final synchronized ArrayList<C> $$robo$$com_android_internal_util_CallbackRegistry$copyListeners() {
        ArrayList<C> callbacks = new ArrayList<C>(this.mCallbacks.size());
        int numListeners = this.mCallbacks.size();
        for (int i = 0; i < numListeners; ++i) {
            if (this.isRemovedLocked(i)) continue;
            callbacks.add(this.mCallbacks.get(i));
        }
        return callbacks;
    }

    private final synchronized boolean $$robo$$com_android_internal_util_CallbackRegistry$isEmpty() {
        if (this.mCallbacks.isEmpty()) {
            return true;
        }
        if (this.mNotificationLevel == 0) {
            return false;
        }
        int numListeners = this.mCallbacks.size();
        for (int i = 0; i < numListeners; ++i) {
            if (this.isRemovedLocked(i)) continue;
            return false;
        }
        return true;
    }

    private final synchronized void $$robo$$com_android_internal_util_CallbackRegistry$clear() {
        if (this.mNotificationLevel == 0) {
            this.mCallbacks.clear();
        } else if (!this.mCallbacks.isEmpty()) {
            for (int i = this.mCallbacks.size() - 1; i >= 0; --i) {
                this.setRemovalBitLocked(i);
            }
        }
    }

    private final synchronized CallbackRegistry<C, T, A> $$robo$$com_android_internal_util_CallbackRegistry$clone() {
        CallbackRegistry clone = null;
        try {
            clone = (CallbackRegistry)super.clone();
            clone.mFirst64Removed = 0L;
            clone.mRemainderRemoved = null;
            clone.mNotificationLevel = 0;
            clone.mCallbacks = new ArrayList<C>();
            int numListeners = this.mCallbacks.size();
            for (int i = 0; i < numListeners; ++i) {
                if (this.isRemovedLocked(i)) continue;
                clone.mCallbacks.add(this.mCallbacks.get(i));
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return clone;
    }

    private void __constructor__(NotifierCallback<C, T, A> notifierCallback) {
        this.$$robo$$com_android_internal_util_CallbackRegistry$__constructor__(notifierCallback);
    }

    public CallbackRegistry(NotifierCallback<C, T, A> notifierCallback) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_CallbackRegistry$__constructor__(com.android.internal.util.CallbackRegistry$NotifierCallback<C, T, A> ), 0, this, notifierCallback);
    }

    public synchronized void notifyCallbacks(T t, int n, A a) {
        InvokeDynamicSupport.bootstrap("notifyCallbacks", $$robo$$com_android_internal_util_CallbackRegistry$notifyCallbacks(T int A ), 0, this, t, n, a);
    }

    private void notifyFirst64Locked(T t, int n, A a) {
        InvokeDynamicSupport.bootstrap("notifyFirst64Locked", $$robo$$com_android_internal_util_CallbackRegistry$notifyFirst64Locked(T int A ), 0, this, t, n, a);
    }

    private void notifyRecurseLocked(T t, int n, A a) {
        InvokeDynamicSupport.bootstrap("notifyRecurseLocked", $$robo$$com_android_internal_util_CallbackRegistry$notifyRecurseLocked(T int A ), 0, this, t, n, a);
    }

    private void notifyRemainderLocked(T t, int n, A a, int n2) {
        InvokeDynamicSupport.bootstrap("notifyRemainderLocked", $$robo$$com_android_internal_util_CallbackRegistry$notifyRemainderLocked(T int A int ), 0, this, t, n, a, n2);
    }

    private void notifyCallbacksLocked(T t, int n, A a, int n2, int n3, long l) {
        InvokeDynamicSupport.bootstrap("notifyCallbacksLocked", $$robo$$com_android_internal_util_CallbackRegistry$notifyCallbacksLocked(T int A int int long ), 0, this, t, n, a, n2, n3, l);
    }

    public synchronized void add(C c) {
        InvokeDynamicSupport.bootstrap("add", $$robo$$com_android_internal_util_CallbackRegistry$add(C ), 0, this, c);
    }

    private boolean isRemovedLocked(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isRemovedLocked", $$robo$$com_android_internal_util_CallbackRegistry$isRemovedLocked(int ), 0, this, n);
    }

    private void removeRemovedCallbacks(int n, long l) {
        InvokeDynamicSupport.bootstrap("removeRemovedCallbacks", $$robo$$com_android_internal_util_CallbackRegistry$removeRemovedCallbacks(int long ), 0, this, n, l);
    }

    public synchronized void remove(C c) {
        InvokeDynamicSupport.bootstrap("remove", $$robo$$com_android_internal_util_CallbackRegistry$remove(C ), 0, this, c);
    }

    private void setRemovalBitLocked(int n) {
        InvokeDynamicSupport.bootstrap("setRemovalBitLocked", $$robo$$com_android_internal_util_CallbackRegistry$setRemovalBitLocked(int ), 0, this, n);
    }

    public synchronized ArrayList<C> copyListeners() {
        return InvokeDynamicSupport.bootstrap("copyListeners", $$robo$$com_android_internal_util_CallbackRegistry$copyListeners(), 0, this);
    }

    public synchronized boolean isEmpty() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$com_android_internal_util_CallbackRegistry$isEmpty(), 0, this);
    }

    public synchronized void clear() {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$com_android_internal_util_CallbackRegistry$clear(), 0, this);
    }

    public synchronized CallbackRegistry<C, T, A> clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$com_android_internal_util_CallbackRegistry$clone(), 0, this);
    }

    public /* synthetic */ CallbackRegistry() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallbackRegistry)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static abstract class NotifierCallback<C, T, A> {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$com_android_internal_util_CallbackRegistry_NotifierCallback$__constructor__() {
        }

        public abstract void onNotifyCallback(C var1, T var2, int var3, A var4);

        private void __constructor__() {
            this.$$robo$$com_android_internal_util_CallbackRegistry_NotifierCallback$__constructor__();
        }

        public NotifierCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_CallbackRegistry_NotifierCallback$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NotifierCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

