/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.app.AppOpsManager;
import android.content.ComponentName;
import android.content.Context;
import android.os.Binder;
import android.os.Handler;
import android.text.TextUtils;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.util.ParseUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Objects;
import java.util.function.Predicate;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class DumpUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "DumpUtils";
    private static boolean DEBUG = false;

    private void $$robo$$com_android_internal_util_DumpUtils$__constructor__() {
    }

    private static final void $$robo$$com_android_internal_util_DumpUtils$dumpAsync(Handler handler, Dump dump, PrintWriter pw, String prefix, long timeout) {
        StringWriter sw = new StringWriter();
        if (handler.runWithScissors(new Runnable(sw, dump, prefix){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ StringWriter val$sw;
            /* synthetic */ Dump val$dump;
            /* synthetic */ String val$prefix;

            private void $$robo$$com_android_internal_util_DumpUtils_1$__constructor__(StringWriter stringWriter, Dump dump, String string2) {
            }

            private final void $$robo$$com_android_internal_util_DumpUtils_1$run() {
                FastPrintWriter lpw = new FastPrintWriter(this.val$sw);
                this.val$dump.dump(lpw, this.val$prefix);
                ((PrintWriter)lpw).close();
            }

            private void __constructor__(StringWriter stringWriter, Dump dump, String string2) {
                this.$$robo$$com_android_internal_util_DumpUtils_1$__constructor__(stringWriter, dump, string2);
            }
            {
                this.val$sw = stringWriter;
                this.val$dump = dump;
                this.val$prefix = string2;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_DumpUtils_1$__constructor__(java.io.StringWriter com.android.internal.util.DumpUtils$Dump java.lang.String ), 0, this, stringWriter, dump, string2);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_util_DumpUtils_1$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }, timeout)) {
            pw.print(sw.toString());
        } else {
            pw.println("... timed out");
        }
    }

    private static final void $$robo$$com_android_internal_util_DumpUtils$logMessage(PrintWriter pw, String msg) {
        pw.println(msg);
    }

    private static final boolean $$robo$$com_android_internal_util_DumpUtils$checkDumpPermission(Context context, String tag, PrintWriter pw) {
        if (context.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            DumpUtils.logMessage(pw, "Permission Denial: can't dump " + tag + " from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " due to missing android.permission.DUMP permission");
            return false;
        }
        return true;
    }

    private static final boolean $$robo$$com_android_internal_util_DumpUtils$checkUsageStatsPermission(Context context, String tag, PrintWriter pw) {
        int uid = Binder.getCallingUid();
        switch (uid) {
            case 0: 
            case 1000: 
            case 1067: 
            case 2000: {
                return true;
            }
        }
        if (context.checkCallingOrSelfPermission("android.permission.PACKAGE_USAGE_STATS") != 0) {
            DumpUtils.logMessage(pw, "Permission Denial: can't dump " + tag + " from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " due to missing android.permission.PACKAGE_USAGE_STATS permission");
            return false;
        }
        AppOpsManager appOps = context.getSystemService(AppOpsManager.class);
        String[] pkgs = context.getPackageManager().getPackagesForUid(uid);
        if (pkgs != null) {
            for (String pkg : pkgs) {
                switch (appOps.noteOpNoThrow(43, uid, pkg)) {
                    case 0: {
                        return true;
                    }
                    case 3: {
                        return true;
                    }
                }
            }
        }
        DumpUtils.logMessage(pw, "Permission Denial: can't dump " + tag + " from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " due to android:get_usage_stats app-op not allowed");
        return false;
    }

    private static final boolean $$robo$$com_android_internal_util_DumpUtils$checkDumpAndUsageStatsPermission(Context context, String tag, PrintWriter pw) {
        return DumpUtils.checkDumpPermission(context, tag, pw) && DumpUtils.checkUsageStatsPermission(context, tag, pw);
    }

    private static final boolean $$robo$$com_android_internal_util_DumpUtils$isPlatformPackage(String packageName) {
        return packageName != null && (packageName.equals("android") || packageName.startsWith("android.") || packageName.startsWith("com.android."));
    }

    private static final boolean $$robo$$com_android_internal_util_DumpUtils$isPlatformPackage(ComponentName cname) {
        return cname != null && DumpUtils.isPlatformPackage(cname.getPackageName());
    }

    private static final boolean $$robo$$com_android_internal_util_DumpUtils$isPlatformPackage(ComponentName.WithComponentName wcn) {
        return wcn != null && DumpUtils.isPlatformPackage(wcn.getComponentName());
    }

    private static final boolean $$robo$$com_android_internal_util_DumpUtils$isNonPlatformPackage(String packageName) {
        return packageName != null && !DumpUtils.isPlatformPackage(packageName);
    }

    private static final boolean $$robo$$com_android_internal_util_DumpUtils$isNonPlatformPackage(ComponentName cname) {
        return cname != null && DumpUtils.isNonPlatformPackage(cname.getPackageName());
    }

    private static final boolean $$robo$$com_android_internal_util_DumpUtils$isNonPlatformPackage(ComponentName.WithComponentName wcn) {
        return wcn != null && !DumpUtils.isPlatformPackage(wcn.getComponentName());
    }

    private static final <TRec extends ComponentName.WithComponentName> Predicate<TRec> $$robo$$com_android_internal_util_DumpUtils$filterRecord(String filterString) {
        if (TextUtils.isEmpty(filterString)) {
            return rec -> false;
        }
        if ("all".equals(filterString)) {
            return Objects::nonNull;
        }
        if ("all-platform".equals(filterString)) {
            return DumpUtils::isPlatformPackage;
        }
        if ("all-non-platform".equals(filterString)) {
            return DumpUtils::isNonPlatformPackage;
        }
        ComponentName filterCname = ComponentName.unflattenFromString(filterString);
        if (filterCname != null) {
            return rec -> rec != null && filterCname.equals(rec.getComponentName());
        }
        int id2 = ParseUtils.parseIntWithBase(filterString, 16, -1);
        return rec -> {
            ComponentName cn = rec.getComponentName();
            return id2 != -1 && System.identityHashCode(rec) == id2 || cn.flattenToString().toLowerCase().contains(filterString.toLowerCase());
        };
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_util_DumpUtils$__constructor__();
    }

    private DumpUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_DumpUtils$__constructor__(), 0, this);
    }

    public static void dumpAsync(Handler handler, Dump dump, PrintWriter printWriter, String string2, long l) {
        InvokeDynamicSupport.bootstrapStatic("dumpAsync", $$robo$$com_android_internal_util_DumpUtils$dumpAsync(android.os.Handler com.android.internal.util.DumpUtils$Dump java.io.PrintWriter java.lang.String long ), 0, (Handler)handler, (Dump)dump, (PrintWriter)printWriter, (String)string2, (long)l);
    }

    private static void logMessage(PrintWriter printWriter, String string2) {
        InvokeDynamicSupport.bootstrapStatic("logMessage", $$robo$$com_android_internal_util_DumpUtils$logMessage(java.io.PrintWriter java.lang.String ), 0, (PrintWriter)printWriter, (String)string2);
    }

    public static boolean checkDumpPermission(Context context, String string2, PrintWriter printWriter) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkDumpPermission", $$robo$$com_android_internal_util_DumpUtils$checkDumpPermission(android.content.Context java.lang.String java.io.PrintWriter ), 0, (Context)context, (String)string2, (PrintWriter)printWriter);
    }

    public static boolean checkUsageStatsPermission(Context context, String string2, PrintWriter printWriter) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkUsageStatsPermission", $$robo$$com_android_internal_util_DumpUtils$checkUsageStatsPermission(android.content.Context java.lang.String java.io.PrintWriter ), 0, (Context)context, (String)string2, (PrintWriter)printWriter);
    }

    public static boolean checkDumpAndUsageStatsPermission(Context context, String string2, PrintWriter printWriter) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkDumpAndUsageStatsPermission", $$robo$$com_android_internal_util_DumpUtils$checkDumpAndUsageStatsPermission(android.content.Context java.lang.String java.io.PrintWriter ), 0, (Context)context, (String)string2, (PrintWriter)printWriter);
    }

    public static boolean isPlatformPackage(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPlatformPackage", $$robo$$com_android_internal_util_DumpUtils$isPlatformPackage(java.lang.String ), 0, (String)string2);
    }

    public static boolean isPlatformPackage(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPlatformPackage", $$robo$$com_android_internal_util_DumpUtils$isPlatformPackage(android.content.ComponentName ), 0, (ComponentName)componentName);
    }

    public static boolean isPlatformPackage(ComponentName.WithComponentName withComponentName) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPlatformPackage", $$robo$$com_android_internal_util_DumpUtils$isPlatformPackage(android.content.ComponentName$WithComponentName ), 0, (ComponentName.WithComponentName)withComponentName);
    }

    public static boolean isNonPlatformPackage(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isNonPlatformPackage", $$robo$$com_android_internal_util_DumpUtils$isNonPlatformPackage(java.lang.String ), 0, (String)string2);
    }

    public static boolean isNonPlatformPackage(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isNonPlatformPackage", $$robo$$com_android_internal_util_DumpUtils$isNonPlatformPackage(android.content.ComponentName ), 0, (ComponentName)componentName);
    }

    public static boolean isNonPlatformPackage(ComponentName.WithComponentName withComponentName) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isNonPlatformPackage", $$robo$$com_android_internal_util_DumpUtils$isNonPlatformPackage(android.content.ComponentName$WithComponentName ), 0, (ComponentName.WithComponentName)withComponentName);
    }

    public static <TRec extends ComponentName.WithComponentName> Predicate<TRec> filterRecord(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("filterRecord", $$robo$$com_android_internal_util_DumpUtils$filterRecord(java.lang.String ), 0, (String)string2);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DumpUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface Dump
    extends InstrumentedInterface {
        public void dump(PrintWriter var1, String var2);
    }
}

