/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.util.Log;
import com.android.internal.util.Preconditions;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ExponentiallyBucketedHistogram
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private int[] mData;

    private void $$robo$$com_android_internal_util_ExponentiallyBucketedHistogram$__constructor__(int numBuckets) {
        numBuckets = Preconditions.checkArgumentInRange(numBuckets, 1, 31, "numBuckets");
        this.mData = new int[numBuckets];
    }

    private final void $$robo$$com_android_internal_util_ExponentiallyBucketedHistogram$add(int value) {
        if (value <= 0) {
            this.mData[0] = this.mData[0] + 1;
        } else {
            int n = Math.min(this.mData.length - 1, 32 - Integer.numberOfLeadingZeros(value));
            this.mData[n] = this.mData[n] + 1;
        }
    }

    private final void $$robo$$com_android_internal_util_ExponentiallyBucketedHistogram$reset() {
        Arrays.fill(this.mData, 0);
    }

    private final void $$robo$$com_android_internal_util_ExponentiallyBucketedHistogram$log(String tag, CharSequence prefix) {
        StringBuilder builder = new StringBuilder(prefix);
        builder.append('[');
        for (int i = 0; i < this.mData.length; ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            if (i < this.mData.length - 1) {
                builder.append("<");
                builder.append(1 << i);
            } else {
                builder.append(">=");
                builder.append(1 << i - 1);
            }
            builder.append(": ");
            builder.append(this.mData[i]);
        }
        builder.append("]");
        Log.d(tag, builder.toString());
    }

    private void __constructor__(int n) {
        this.$$robo$$com_android_internal_util_ExponentiallyBucketedHistogram$__constructor__(n);
    }

    public ExponentiallyBucketedHistogram(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_ExponentiallyBucketedHistogram$__constructor__(int ), 0, this, n);
    }

    public void add(int n) {
        InvokeDynamicSupport.bootstrap("add", $$robo$$com_android_internal_util_ExponentiallyBucketedHistogram$add(int ), 0, this, n);
    }

    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_util_ExponentiallyBucketedHistogram$reset(), 0, this);
    }

    public void log(String string2, CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_util_ExponentiallyBucketedHistogram$log(java.lang.String java.lang.CharSequence ), 0, this, string2, charSequence);
    }

    public /* synthetic */ ExponentiallyBucketedHistogram() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ExponentiallyBucketedHistogram)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

