/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.util.Log;
import android.util.Printer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class FastPrintWriter
extends PrintWriter
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private int mBufferLen;
    private char[] mText;
    private int mPos;
    private OutputStream mOutputStream;
    private boolean mAutoFlush;
    private String mSeparator;
    private Writer mWriter;
    private Printer mPrinter;
    private CharsetEncoder mCharset;
    private ByteBuffer mBytes;
    private boolean mIoError;

    private void $$robo$$com_android_internal_util_FastPrintWriter$__constructor__(OutputStream out) {
    }

    private void $$robo$$com_android_internal_util_FastPrintWriter$__constructor__(OutputStream out, boolean autoFlush) {
    }

    private void $$robo$$com_android_internal_util_FastPrintWriter$__constructor__(OutputStream out, boolean autoFlush, int bufferLen) {
        if (out == null) {
            throw new NullPointerException("out is null");
        }
        this.mBufferLen = bufferLen;
        this.mText = new char[bufferLen];
        this.mBytes = ByteBuffer.allocate(this.mBufferLen);
        this.mOutputStream = out;
        this.mWriter = null;
        this.mPrinter = null;
        this.mAutoFlush = autoFlush;
        this.mSeparator = System.lineSeparator();
        this.initDefaultEncoder();
    }

    private void $$robo$$com_android_internal_util_FastPrintWriter$__constructor__(Writer wr) {
    }

    private void $$robo$$com_android_internal_util_FastPrintWriter$__constructor__(Writer wr, boolean autoFlush) {
    }

    private void $$robo$$com_android_internal_util_FastPrintWriter$__constructor__(Writer wr, boolean autoFlush, int bufferLen) {
        if (wr == null) {
            throw new NullPointerException("wr is null");
        }
        this.mBufferLen = bufferLen;
        this.mText = new char[bufferLen];
        this.mBytes = null;
        this.mOutputStream = null;
        this.mWriter = wr;
        this.mPrinter = null;
        this.mAutoFlush = autoFlush;
        this.mSeparator = System.lineSeparator();
        this.initDefaultEncoder();
    }

    private void $$robo$$com_android_internal_util_FastPrintWriter$__constructor__(Printer pr) {
    }

    private void $$robo$$com_android_internal_util_FastPrintWriter$__constructor__(Printer pr, int bufferLen) {
        if (pr == null) {
            throw new NullPointerException("pr is null");
        }
        this.mBufferLen = bufferLen;
        this.mText = new char[bufferLen];
        this.mBytes = null;
        this.mOutputStream = null;
        this.mWriter = null;
        this.mPrinter = pr;
        this.mAutoFlush = true;
        this.mSeparator = System.lineSeparator();
        this.initDefaultEncoder();
    }

    private final void $$robo$$com_android_internal_util_FastPrintWriter$initEncoder(String csn) throws UnsupportedEncodingException {
        try {
            this.mCharset = Charset.forName(csn).newEncoder();
        }
        catch (Exception e) {
            throw new UnsupportedEncodingException(csn);
        }
        this.mCharset.onMalformedInput(CodingErrorAction.REPLACE);
        this.mCharset.onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_util_FastPrintWriter$checkError() {
        this.flush();
        Object object = this.lock;
        synchronized (object) {
            return this.mIoError;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_util_FastPrintWriter$clearError() {
        Object object = this.lock;
        synchronized (object) {
            this.mIoError = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_util_FastPrintWriter$setError() {
        Object object = this.lock;
        synchronized (object) {
            this.mIoError = true;
        }
    }

    private final void $$robo$$com_android_internal_util_FastPrintWriter$initDefaultEncoder() {
        this.mCharset = Charset.defaultCharset().newEncoder();
        this.mCharset.onMalformedInput(CodingErrorAction.REPLACE);
        this.mCharset.onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    private final void $$robo$$com_android_internal_util_FastPrintWriter$appendLocked(char c) throws IOException {
        int pos = this.mPos;
        if (pos >= this.mBufferLen - 1) {
            this.flushLocked();
            pos = this.mPos;
        }
        this.mText[pos] = c;
        this.mPos = pos + 1;
    }

    private final void $$robo$$com_android_internal_util_FastPrintWriter$appendLocked(String str, int i, int length) throws IOException {
        int BUFFER_LEN = this.mBufferLen;
        if (length > BUFFER_LEN) {
            int end = i + length;
            while (i < end) {
                int next = i + BUFFER_LEN;
                this.appendLocked(str, i, next < end ? BUFFER_LEN : end - i);
                i = next;
            }
            return;
        }
        int pos = this.mPos;
        if (pos + length > BUFFER_LEN) {
            this.flushLocked();
            pos = this.mPos;
        }
        str.getChars(i, i + length, this.mText, pos);
        this.mPos = pos + length;
    }

    private final void $$robo$$com_android_internal_util_FastPrintWriter$appendLocked(char[] buf, int i, int length) throws IOException {
        int BUFFER_LEN = this.mBufferLen;
        if (length > BUFFER_LEN) {
            int end = i + length;
            while (i < end) {
                int next = i + BUFFER_LEN;
                this.appendLocked(buf, i, next < end ? BUFFER_LEN : end - i);
                i = next;
            }
            return;
        }
        int pos = this.mPos;
        if (pos + length > BUFFER_LEN) {
            this.flushLocked();
            pos = this.mPos;
        }
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)buf, (int)i, (Object)this.mText, (int)pos, (int)length);
        this.mPos = pos + length;
    }

    private final void $$robo$$com_android_internal_util_FastPrintWriter$flushBytesLocked() throws IOException {
        int position;
        if (!this.mIoError && (position = this.mBytes.position()) > 0) {
            this.mBytes.flip();
            this.mOutputStream.write(this.mBytes.array(), 0, position);
            this.mBytes.clear();
        }
    }

    private final void $$robo$$com_android_internal_util_FastPrintWriter$flushLocked() throws IOException {
        if (this.mPos > 0) {
            if (this.mOutputStream != null) {
                CharBuffer charBuffer = CharBuffer.wrap(this.mText, 0, this.mPos);
                CoderResult result = this.mCharset.encode(charBuffer, this.mBytes, true);
                while (!this.mIoError) {
                    if (result.isError()) {
                        throw new IOException(result.toString());
                    }
                    if (!result.isOverflow()) break;
                    this.flushBytesLocked();
                    result = this.mCharset.encode(charBuffer, this.mBytes, true);
                }
                if (!this.mIoError) {
                    this.flushBytesLocked();
                    this.mOutputStream.flush();
                }
            } else if (this.mWriter != null) {
                if (!this.mIoError) {
                    this.mWriter.write(this.mText, 0, this.mPos);
                    this.mWriter.flush();
                }
            } else {
                int nonEolOff;
                int len;
                int sepLen = this.mSeparator.length();
                int n = len = sepLen < this.mPos ? sepLen : this.mPos;
                for (nonEolOff = 0; nonEolOff < len && this.mText[this.mPos - 1 - nonEolOff] == this.mSeparator.charAt(this.mSeparator.length() - 1 - nonEolOff); ++nonEolOff) {
                }
                if (nonEolOff >= this.mPos) {
                    this.mPrinter.println("");
                } else {
                    this.mPrinter.println(new String(this.mText, 0, this.mPos - nonEolOff));
                }
            }
            this.mPos = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_util_FastPrintWriter$flush() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.flushLocked();
                if (!this.mIoError) {
                    if (this.mOutputStream != null) {
                        this.mOutputStream.flush();
                    } else if (this.mWriter != null) {
                        this.mWriter.flush();
                    }
                }
            }
            catch (IOException e) {
                Log.w("FastPrintWriter", "Write failure", e);
                this.setError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_util_FastPrintWriter$close() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.flushLocked();
                if (this.mOutputStream != null) {
                    this.mOutputStream.close();
                } else if (this.mWriter != null) {
                    this.mWriter.close();
                }
            }
            catch (IOException e) {
                Log.w("FastPrintWriter", "Write failure", e);
                this.setError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_util_FastPrintWriter$print(char[] charArray) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.appendLocked(charArray, 0, charArray.length);
            }
            catch (IOException e) {
                Log.w("FastPrintWriter", "Write failure", e);
                this.setError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_util_FastPrintWriter$print(char ch) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.appendLocked(ch);
            }
            catch (IOException e) {
                Log.w("FastPrintWriter", "Write failure", e);
                this.setError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_util_FastPrintWriter$print(String str) {
        if (str == null) {
            str = String.valueOf(null);
        }
        Object object = this.lock;
        synchronized (object) {
            try {
                this.appendLocked(str, 0, str.length());
            }
            catch (IOException e) {
                Log.w("FastPrintWriter", "Write failure", e);
                this.setError();
            }
        }
    }

    private final void $$robo$$com_android_internal_util_FastPrintWriter$print(int inum) {
        if (inum == 0) {
            this.print("0");
        } else {
            super.print(inum);
        }
    }

    private final void $$robo$$com_android_internal_util_FastPrintWriter$print(long lnum) {
        if (lnum == 0L) {
            this.print("0");
        } else {
            super.print(lnum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_util_FastPrintWriter$println() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.appendLocked(this.mSeparator, 0, this.mSeparator.length());
                if (this.mAutoFlush) {
                    this.flushLocked();
                }
            }
            catch (IOException e) {
                Log.w("FastPrintWriter", "Write failure", e);
                this.setError();
            }
        }
    }

    private final void $$robo$$com_android_internal_util_FastPrintWriter$println(int inum) {
        if (inum == 0) {
            this.println("0");
        } else {
            super.println(inum);
        }
    }

    private final void $$robo$$com_android_internal_util_FastPrintWriter$println(long lnum) {
        if (lnum == 0L) {
            this.println("0");
        } else {
            super.println(lnum);
        }
    }

    private final void $$robo$$com_android_internal_util_FastPrintWriter$println(char[] chars) {
        this.print(chars);
        this.println();
    }

    private final void $$robo$$com_android_internal_util_FastPrintWriter$println(char c) {
        this.print(c);
        this.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_util_FastPrintWriter$write(char[] buf, int offset, int count) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.appendLocked(buf, offset, count);
            }
            catch (IOException e) {
                Log.w("FastPrintWriter", "Write failure", e);
                this.setError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_util_FastPrintWriter$write(int oneChar) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.appendLocked((char)oneChar);
            }
            catch (IOException e) {
                Log.w("FastPrintWriter", "Write failure", e);
                this.setError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_util_FastPrintWriter$write(String str) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.appendLocked(str, 0, str.length());
            }
            catch (IOException e) {
                Log.w("FastPrintWriter", "Write failure", e);
                this.setError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_util_FastPrintWriter$write(String str, int offset, int count) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.appendLocked(str, offset, count);
            }
            catch (IOException e) {
                Log.w("FastPrintWriter", "Write failure", e);
                this.setError();
            }
        }
    }

    private final PrintWriter $$robo$$com_android_internal_util_FastPrintWriter$append(CharSequence csq, int start, int end) {
        if (csq == null) {
            csq = "null";
        }
        String output = csq.subSequence(start, end).toString();
        this.write(output, 0, output.length());
        return this;
    }

    private void __constructor__(OutputStream outputStream) {
        this.$$robo$$com_android_internal_util_FastPrintWriter$__constructor__(outputStream);
    }

    public FastPrintWriter(OutputStream outputStream) {
        this(outputStream, false, 8192);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_FastPrintWriter$__constructor__(java.io.OutputStream ), 0, this, outputStream);
    }

    private void __constructor__(OutputStream outputStream, boolean bl) {
        this.$$robo$$com_android_internal_util_FastPrintWriter$__constructor__(outputStream, bl);
    }

    public FastPrintWriter(OutputStream outputStream, boolean bl) {
        this(outputStream, bl, 8192);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_FastPrintWriter$__constructor__(java.io.OutputStream boolean ), 0, this, outputStream, bl);
    }

    private void __constructor__(OutputStream outputStream, boolean bl, int n) {
        this.$$robo$$com_android_internal_util_FastPrintWriter$__constructor__(outputStream, bl, n);
    }

    public FastPrintWriter(OutputStream outputStream, boolean bl, int n) {
        super((Writer)new DummyWriter(), bl);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_FastPrintWriter$__constructor__(java.io.OutputStream boolean int ), 0, this, outputStream, bl, n);
    }

    private void __constructor__(Writer writer) {
        this.$$robo$$com_android_internal_util_FastPrintWriter$__constructor__(writer);
    }

    public FastPrintWriter(Writer writer) {
        this(writer, false, 8192);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_FastPrintWriter$__constructor__(java.io.Writer ), 0, this, writer);
    }

    private void __constructor__(Writer writer, boolean bl) {
        this.$$robo$$com_android_internal_util_FastPrintWriter$__constructor__(writer, bl);
    }

    public FastPrintWriter(Writer writer, boolean bl) {
        this(writer, bl, 8192);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_FastPrintWriter$__constructor__(java.io.Writer boolean ), 0, this, writer, bl);
    }

    private void __constructor__(Writer writer, boolean bl, int n) {
        this.$$robo$$com_android_internal_util_FastPrintWriter$__constructor__(writer, bl, n);
    }

    public FastPrintWriter(Writer writer, boolean bl, int n) {
        super((Writer)new DummyWriter(), bl);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_FastPrintWriter$__constructor__(java.io.Writer boolean int ), 0, this, writer, bl, n);
    }

    private void __constructor__(Printer printer) {
        this.$$robo$$com_android_internal_util_FastPrintWriter$__constructor__(printer);
    }

    public FastPrintWriter(Printer printer) {
        this(printer, 512);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_FastPrintWriter$__constructor__(android.util.Printer ), 0, this, printer);
    }

    private void __constructor__(Printer printer, int n) {
        this.$$robo$$com_android_internal_util_FastPrintWriter$__constructor__(printer, n);
    }

    public FastPrintWriter(Printer printer, int n) {
        super((Writer)new DummyWriter(), true);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_FastPrintWriter$__constructor__(android.util.Printer int ), 0, this, printer, n);
    }

    private void initEncoder(String string2) throws UnsupportedEncodingException {
        InvokeDynamicSupport.bootstrap("initEncoder", $$robo$$com_android_internal_util_FastPrintWriter$initEncoder(java.lang.String ), 0, this, string2);
    }

    @Override
    public boolean checkError() {
        return (boolean)InvokeDynamicSupport.bootstrap("checkError", $$robo$$com_android_internal_util_FastPrintWriter$checkError(), 0, this);
    }

    @Override
    protected void clearError() {
        InvokeDynamicSupport.bootstrap("clearError", $$robo$$com_android_internal_util_FastPrintWriter$clearError(), 0, this);
    }

    @Override
    protected void setError() {
        InvokeDynamicSupport.bootstrap("setError", $$robo$$com_android_internal_util_FastPrintWriter$setError(), 0, this);
    }

    private void initDefaultEncoder() {
        InvokeDynamicSupport.bootstrap("initDefaultEncoder", $$robo$$com_android_internal_util_FastPrintWriter$initDefaultEncoder(), 0, this);
    }

    private void appendLocked(char c) throws IOException {
        InvokeDynamicSupport.bootstrap("appendLocked", $$robo$$com_android_internal_util_FastPrintWriter$appendLocked(char ), 0, this, c);
    }

    private void appendLocked(String string2, int n, int n2) throws IOException {
        InvokeDynamicSupport.bootstrap("appendLocked", $$robo$$com_android_internal_util_FastPrintWriter$appendLocked(java.lang.String int int ), 0, this, string2, n, n2);
    }

    private void appendLocked(char[] cArray, int n, int n2) throws IOException {
        InvokeDynamicSupport.bootstrap("appendLocked", $$robo$$com_android_internal_util_FastPrintWriter$appendLocked(char[] int int ), 0, this, cArray, n, n2);
    }

    private void flushBytesLocked() throws IOException {
        InvokeDynamicSupport.bootstrap("flushBytesLocked", $$robo$$com_android_internal_util_FastPrintWriter$flushBytesLocked(), 0, this);
    }

    private void flushLocked() throws IOException {
        InvokeDynamicSupport.bootstrap("flushLocked", $$robo$$com_android_internal_util_FastPrintWriter$flushLocked(), 0, this);
    }

    @Override
    public void flush() {
        InvokeDynamicSupport.bootstrap("flush", $$robo$$com_android_internal_util_FastPrintWriter$flush(), 0, this);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$com_android_internal_util_FastPrintWriter$close(), 0, this);
    }

    @Override
    public void print(char[] cArray) {
        InvokeDynamicSupport.bootstrap("print", $$robo$$com_android_internal_util_FastPrintWriter$print(char[] ), 0, this, cArray);
    }

    @Override
    public void print(char c) {
        InvokeDynamicSupport.bootstrap("print", $$robo$$com_android_internal_util_FastPrintWriter$print(char ), 0, this, c);
    }

    @Override
    public void print(String string2) {
        InvokeDynamicSupport.bootstrap("print", $$robo$$com_android_internal_util_FastPrintWriter$print(java.lang.String ), 0, this, string2);
    }

    @Override
    public void print(int n) {
        InvokeDynamicSupport.bootstrap("print", $$robo$$com_android_internal_util_FastPrintWriter$print(int ), 0, this, n);
    }

    @Override
    public void print(long l) {
        InvokeDynamicSupport.bootstrap("print", $$robo$$com_android_internal_util_FastPrintWriter$print(long ), 0, this, l);
    }

    @Override
    public void println() {
        InvokeDynamicSupport.bootstrap("println", $$robo$$com_android_internal_util_FastPrintWriter$println(), 0, this);
    }

    @Override
    public void println(int n) {
        InvokeDynamicSupport.bootstrap("println", $$robo$$com_android_internal_util_FastPrintWriter$println(int ), 0, this, n);
    }

    @Override
    public void println(long l) {
        InvokeDynamicSupport.bootstrap("println", $$robo$$com_android_internal_util_FastPrintWriter$println(long ), 0, this, l);
    }

    @Override
    public void println(char[] cArray) {
        InvokeDynamicSupport.bootstrap("println", $$robo$$com_android_internal_util_FastPrintWriter$println(char[] ), 0, this, cArray);
    }

    @Override
    public void println(char c) {
        InvokeDynamicSupport.bootstrap("println", $$robo$$com_android_internal_util_FastPrintWriter$println(char ), 0, this, c);
    }

    @Override
    public void write(char[] cArray, int n, int n2) {
        InvokeDynamicSupport.bootstrap("write", $$robo$$com_android_internal_util_FastPrintWriter$write(char[] int int ), 0, this, cArray, n, n2);
    }

    @Override
    public void write(int n) {
        InvokeDynamicSupport.bootstrap("write", $$robo$$com_android_internal_util_FastPrintWriter$write(int ), 0, this, n);
    }

    @Override
    public void write(String string2) {
        InvokeDynamicSupport.bootstrap("write", $$robo$$com_android_internal_util_FastPrintWriter$write(java.lang.String ), 0, this, string2);
    }

    @Override
    public void write(String string2, int n, int n2) {
        InvokeDynamicSupport.bootstrap("write", $$robo$$com_android_internal_util_FastPrintWriter$write(java.lang.String int int ), 0, this, string2, n, n2);
    }

    @Override
    public PrintWriter append(CharSequence charSequence, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("append", $$robo$$com_android_internal_util_FastPrintWriter$append(java.lang.CharSequence int int ), 0, this, charSequence, n, n2);
    }

    public /* synthetic */ FastPrintWriter() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FastPrintWriter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class DummyWriter
    extends Writer
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$com_android_internal_util_FastPrintWriter_DummyWriter$__constructor__() {
        }

        private final void $$robo$$com_android_internal_util_FastPrintWriter_DummyWriter$close() throws IOException {
            UnsupportedOperationException ex = new UnsupportedOperationException("Shouldn't be here");
            throw ex;
        }

        private final void $$robo$$com_android_internal_util_FastPrintWriter_DummyWriter$flush() throws IOException {
            this.close();
        }

        private final void $$robo$$com_android_internal_util_FastPrintWriter_DummyWriter$write(char[] buf, int offset, int count) throws IOException {
            this.close();
        }

        private /* synthetic */ void $$robo$$com_android_internal_util_FastPrintWriter_DummyWriter$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_util_FastPrintWriter_DummyWriter$__constructor__();
        }

        private DummyWriter() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_FastPrintWriter_DummyWriter$__constructor__(), 0, this);
        }

        @Override
        public void close() throws IOException {
            InvokeDynamicSupport.bootstrap("close", $$robo$$com_android_internal_util_FastPrintWriter_DummyWriter$close(), 0, this);
        }

        @Override
        public void flush() throws IOException {
            InvokeDynamicSupport.bootstrap("flush", $$robo$$com_android_internal_util_FastPrintWriter_DummyWriter$flush(), 0, this);
        }

        @Override
        public void write(char[] cArray, int n, int n2) throws IOException {
            InvokeDynamicSupport.bootstrap("write", $$robo$$com_android_internal_util_FastPrintWriter_DummyWriter$write(char[] int int ), 0, this, cArray, n, n2);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$com_android_internal_util_FastPrintWriter_DummyWriter$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DummyWriter)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

