/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Trace;
import android.util.EventLog;
import android.util.Log;
import android.util.SparseLongArray;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LatencyTracker
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String ACTION_RELOAD_PROPERTY = "com.android.systemui.RELOAD_LATENCY_TRACKER_PROPERTY";
    private static String TAG = "LatencyTracker";
    public static int ACTION_EXPAND_PANEL = 0;
    public static int ACTION_TOGGLE_RECENTS = 1;
    public static int ACTION_FINGERPRINT_WAKE_AND_UNLOCK = 2;
    public static int ACTION_CHECK_CREDENTIAL = 3;
    public static int ACTION_CHECK_CREDENTIAL_UNLOCKED = 4;
    public static int ACTION_TURN_ON_SCREEN = 5;
    public static int ACTION_ROTATE_SCREEN = 6;
    private static String[] NAMES;
    private static LatencyTracker sLatencyTracker;
    private SparseLongArray mStartRtc;
    private boolean mEnabled;

    private static final LatencyTracker $$robo$$com_android_internal_util_LatencyTracker$getInstance(Context context) {
        if (sLatencyTracker == null) {
            sLatencyTracker = new LatencyTracker(context);
        }
        return sLatencyTracker;
    }

    private void $$robo$$com_android_internal_util_LatencyTracker$__constructor__(Context context) {
        this.mStartRtc = new SparseLongArray();
        context.registerReceiver((BroadcastReceiver)new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ LatencyTracker this$0;

            private void $$robo$$com_android_internal_util_LatencyTracker_1$__constructor__(LatencyTracker this$0) {
            }

            private final void $$robo$$com_android_internal_util_LatencyTracker_1$onReceive(Context context, Intent intent) {
                this.this$0.reloadProperty();
            }

            private void __constructor__(LatencyTracker latencyTracker) {
                this.$$robo$$com_android_internal_util_LatencyTracker_1$__constructor__(latencyTracker);
            }
            {
                this.this$0 = latencyTracker;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_LatencyTracker_1$__constructor__(com.android.internal.util.LatencyTracker ), 0, this, latencyTracker);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_util_LatencyTracker_1$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }, new IntentFilter("com.android.systemui.RELOAD_LATENCY_TRACKER_PROPERTY"));
        this.reloadProperty();
    }

    private final void $$robo$$com_android_internal_util_LatencyTracker$reloadProperty() {
        this.mEnabled = SystemProperties.getBoolean("debug.systemui.latency_tracking", false);
    }

    private static final boolean $$robo$$com_android_internal_util_LatencyTracker$isEnabled(Context ctx) {
        return Build.IS_DEBUGGABLE && LatencyTracker.getInstance((Context)ctx).mEnabled;
    }

    private final void $$robo$$com_android_internal_util_LatencyTracker$onActionStart(int action) {
        if (!this.mEnabled) {
            return;
        }
        Trace.asyncTraceBegin(4096L, NAMES[action], 0);
        this.mStartRtc.put(action, SystemClock.elapsedRealtime());
    }

    private final void $$robo$$com_android_internal_util_LatencyTracker$onActionEnd(int action) {
        if (!this.mEnabled) {
            return;
        }
        long endRtc = SystemClock.elapsedRealtime();
        long startRtc = this.mStartRtc.get(action, -1L);
        if (startRtc == -1L) {
            return;
        }
        this.mStartRtc.delete(action);
        Trace.asyncTraceEnd(4096L, NAMES[action], 0);
        LatencyTracker.logAction(action, (int)(endRtc - startRtc));
    }

    private static final void $$robo$$com_android_internal_util_LatencyTracker$logAction(int action, int duration) {
        Log.i("LatencyTracker", "action=" + action + " latency=" + duration);
        EventLog.writeEvent(36070, action, duration);
    }

    static void __staticInitializer__() {
        NAMES = new String[]{"expand panel", "toggle recents", "fingerprint wake-and-unlock", "check credential", "check credential unlocked", "turn on screen", "rotate the screen"};
    }

    public static LatencyTracker getInstance(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$com_android_internal_util_LatencyTracker$getInstance(android.content.Context ), 0, (Context)context);
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_util_LatencyTracker$__constructor__(context);
    }

    private LatencyTracker(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_LatencyTracker$__constructor__(android.content.Context ), 0, this, context);
    }

    private void reloadProperty() {
        InvokeDynamicSupport.bootstrap("reloadProperty", $$robo$$com_android_internal_util_LatencyTracker$reloadProperty(), 0, this);
    }

    public static boolean isEnabled(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isEnabled", $$robo$$com_android_internal_util_LatencyTracker$isEnabled(android.content.Context ), 0, (Context)context);
    }

    public void onActionStart(int n) {
        InvokeDynamicSupport.bootstrap("onActionStart", $$robo$$com_android_internal_util_LatencyTracker$onActionStart(int ), 0, this, n);
    }

    public void onActionEnd(int n) {
        InvokeDynamicSupport.bootstrap("onActionEnd", $$robo$$com_android_internal_util_LatencyTracker$onActionEnd(int ), 0, this, n);
    }

    public static void logAction(int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("logAction", $$robo$$com_android_internal_util_LatencyTracker$logAction(int int ), 0, (int)n, (int)n2);
    }

    static {
        RobolectricInternals.classInitializing(LatencyTracker.class);
    }

    public /* synthetic */ LatencyTracker() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LatencyTracker)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

