/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.os.Bundle;
import android.os.IProgressListener;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.util.MathUtils;
import com.android.internal.annotations.GuardedBy;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ProgressReporter
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int STATE_INIT = 0;
    private static int STATE_STARTED = 1;
    private static int STATE_FINISHED = 2;
    private int mId;
    @GuardedBy(value="this")
    private RemoteCallbackList<IProgressListener> mListeners;
    @GuardedBy(value="this")
    private int mState;
    @GuardedBy(value="this")
    private int mProgress;
    @GuardedBy(value="this")
    private Bundle mExtras;
    @GuardedBy(value="this")
    private int[] mSegmentRange;

    private void $$robo$$com_android_internal_util_ProgressReporter$__constructor__(int id2) {
        this.mListeners = new RemoteCallbackList();
        this.mState = 0;
        this.mProgress = 0;
        this.mExtras = new Bundle();
        this.mSegmentRange = new int[]{0, 100};
        this.mId = id2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_util_ProgressReporter$addListener(IProgressListener listener) {
        if (listener == null) {
            return;
        }
        ProgressReporter progressReporter = this;
        synchronized (progressReporter) {
            this.mListeners.register(listener);
            switch (this.mState) {
                case 0: {
                    break;
                }
                case 1: {
                    try {
                        listener.onStarted(this.mId, null);
                        listener.onProgress(this.mId, this.mProgress, this.mExtras);
                    }
                    catch (RemoteException remoteException) {}
                    break;
                }
                case 2: {
                    try {
                        listener.onFinished(this.mId, null);
                        break;
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private final void $$robo$$com_android_internal_util_ProgressReporter$setProgress(int progress) {
        this.setProgress(progress, 100, null);
    }

    private final void $$robo$$com_android_internal_util_ProgressReporter$setProgress(int progress, CharSequence title) {
        this.setProgress(progress, 100, title);
    }

    private final void $$robo$$com_android_internal_util_ProgressReporter$setProgress(int n, int m) {
        this.setProgress(n, m, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_util_ProgressReporter$setProgress(int n, int m, CharSequence title) {
        ProgressReporter progressReporter = this;
        synchronized (progressReporter) {
            if (this.mState != 1) {
                throw new IllegalStateException("Must be started to change progress");
            }
            this.mProgress = this.mSegmentRange[0] + MathUtils.constrain(n * this.mSegmentRange[1] / m, 0, this.mSegmentRange[1]);
            if (title != null) {
                this.mExtras.putCharSequence("android.intent.extra.TITLE", title);
            }
            this.notifyProgress(this.mId, this.mProgress, this.mExtras);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int[] $$robo$$com_android_internal_util_ProgressReporter$startSegment(int size) {
        ProgressReporter progressReporter = this;
        synchronized (progressReporter) {
            int[] lastRange = this.mSegmentRange;
            this.mSegmentRange = new int[]{this.mProgress, size * this.mSegmentRange[1] / 100};
            return lastRange;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_util_ProgressReporter$endSegment(int[] lastRange) {
        ProgressReporter progressReporter = this;
        synchronized (progressReporter) {
            this.mProgress = this.mSegmentRange[0] + this.mSegmentRange[1];
            this.mSegmentRange = lastRange;
        }
    }

    private final int $$robo$$com_android_internal_util_ProgressReporter$getProgress() {
        return this.mProgress;
    }

    private final int[] $$robo$$com_android_internal_util_ProgressReporter$getSegmentRange() {
        return this.mSegmentRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_util_ProgressReporter$start() {
        ProgressReporter progressReporter = this;
        synchronized (progressReporter) {
            this.mState = 1;
            this.notifyStarted(this.mId, null);
            this.notifyProgress(this.mId, this.mProgress, this.mExtras);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_util_ProgressReporter$finish() {
        ProgressReporter progressReporter = this;
        synchronized (progressReporter) {
            this.mState = 2;
            this.notifyFinished(this.mId, null);
            this.mListeners.kill();
        }
    }

    private final void $$robo$$com_android_internal_util_ProgressReporter$notifyStarted(int id2, Bundle extras) {
        for (int i = this.mListeners.beginBroadcast() - 1; i >= 0; --i) {
            try {
                this.mListeners.getBroadcastItem(i).onStarted(id2, extras);
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.mListeners.finishBroadcast();
    }

    private final void $$robo$$com_android_internal_util_ProgressReporter$notifyProgress(int id2, int progress, Bundle extras) {
        for (int i = this.mListeners.beginBroadcast() - 1; i >= 0; --i) {
            try {
                this.mListeners.getBroadcastItem(i).onProgress(id2, progress, extras);
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.mListeners.finishBroadcast();
    }

    private final void $$robo$$com_android_internal_util_ProgressReporter$notifyFinished(int id2, Bundle extras) {
        for (int i = this.mListeners.beginBroadcast() - 1; i >= 0; --i) {
            try {
                this.mListeners.getBroadcastItem(i).onFinished(id2, extras);
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.mListeners.finishBroadcast();
    }

    private void __constructor__(int n) {
        this.$$robo$$com_android_internal_util_ProgressReporter$__constructor__(n);
    }

    public ProgressReporter(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_ProgressReporter$__constructor__(int ), 0, this, n);
    }

    public void addListener(IProgressListener iProgressListener) {
        InvokeDynamicSupport.bootstrap("addListener", $$robo$$com_android_internal_util_ProgressReporter$addListener(android.os.IProgressListener ), 0, this, iProgressListener);
    }

    public void setProgress(int n) {
        InvokeDynamicSupport.bootstrap("setProgress", $$robo$$com_android_internal_util_ProgressReporter$setProgress(int ), 0, this, n);
    }

    public void setProgress(int n, CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setProgress", $$robo$$com_android_internal_util_ProgressReporter$setProgress(int java.lang.CharSequence ), 0, this, n, charSequence);
    }

    public void setProgress(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setProgress", $$robo$$com_android_internal_util_ProgressReporter$setProgress(int int ), 0, this, n, n2);
    }

    public void setProgress(int n, int n2, CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setProgress", $$robo$$com_android_internal_util_ProgressReporter$setProgress(int int java.lang.CharSequence ), 0, this, n, n2, charSequence);
    }

    public int[] startSegment(int n) {
        return InvokeDynamicSupport.bootstrap("startSegment", $$robo$$com_android_internal_util_ProgressReporter$startSegment(int ), 0, this, n);
    }

    public void endSegment(int[] nArray) {
        InvokeDynamicSupport.bootstrap("endSegment", $$robo$$com_android_internal_util_ProgressReporter$endSegment(int[] ), 0, this, nArray);
    }

    int getProgress() {
        return (int)InvokeDynamicSupport.bootstrap("getProgress", $$robo$$com_android_internal_util_ProgressReporter$getProgress(), 0, this);
    }

    int[] getSegmentRange() {
        return InvokeDynamicSupport.bootstrap("getSegmentRange", $$robo$$com_android_internal_util_ProgressReporter$getSegmentRange(), 0, this);
    }

    public void start() {
        InvokeDynamicSupport.bootstrap("start", $$robo$$com_android_internal_util_ProgressReporter$start(), 0, this);
    }

    public void finish() {
        InvokeDynamicSupport.bootstrap("finish", $$robo$$com_android_internal_util_ProgressReporter$finish(), 0, this);
    }

    private void notifyStarted(int n, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("notifyStarted", $$robo$$com_android_internal_util_ProgressReporter$notifyStarted(int android.os.Bundle ), 0, this, n, bundle);
    }

    private void notifyProgress(int n, int n2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("notifyProgress", $$robo$$com_android_internal_util_ProgressReporter$notifyProgress(int int android.os.Bundle ), 0, this, n, n2, bundle);
    }

    private void notifyFinished(int n, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("notifyFinished", $$robo$$com_android_internal_util_ProgressReporter$notifyFinished(int android.os.Bundle ), 0, this, n, bundle);
    }

    public /* synthetic */ ProgressReporter() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProgressReporter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

