/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.os.SystemClock;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.IndentingPrintWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class StatLogger
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "StatLogger";
    private Object mLock;
    private int SIZE;
    @GuardedBy(value="mLock")
    private int[] mCountStats;
    @GuardedBy(value="mLock")
    private long[] mDurationStats;
    @GuardedBy(value="mLock")
    private int[] mCallsPerSecond;
    @GuardedBy(value="mLock")
    private long[] mDurationPerSecond;
    @GuardedBy(value="mLock")
    private int[] mMaxCallsPerSecond;
    @GuardedBy(value="mLock")
    private long[] mMaxDurationPerSecond;
    @GuardedBy(value="mLock")
    private long[] mMaxDurationStats;
    @GuardedBy(value="mLock")
    private long mNextTickTime;
    private String[] mLabels;

    private void $$robo$$com_android_internal_util_StatLogger$__constructor__(String[] eventLabels) {
        this.mLock = new Object();
        this.mNextTickTime = SystemClock.elapsedRealtime() + 1000L;
        this.SIZE = eventLabels.length;
        this.mCountStats = new int[this.SIZE];
        this.mDurationStats = new long[this.SIZE];
        this.mCallsPerSecond = new int[this.SIZE];
        this.mMaxCallsPerSecond = new int[this.SIZE];
        this.mDurationPerSecond = new long[this.SIZE];
        this.mMaxDurationPerSecond = new long[this.SIZE];
        this.mMaxDurationStats = new long[this.SIZE];
        this.mLabels = eventLabels;
    }

    private final long $$robo$$com_android_internal_util_StatLogger$getTime() {
        return SystemClock.elapsedRealtimeNanos() / 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long $$robo$$com_android_internal_util_StatLogger$logDurationStat(int eventId, long start) {
        Object object = this.mLock;
        synchronized (object) {
            long nowRealtime;
            long duration = this.getTime() - start;
            if (eventId < 0 || eventId >= this.SIZE) {
                Slog.wtf("StatLogger", "Invalid event ID: " + eventId);
                return duration;
            }
            int n = eventId;
            this.mCountStats[n] = this.mCountStats[n] + 1;
            int n2 = eventId;
            this.mDurationStats[n2] = this.mDurationStats[n2] + duration;
            if (this.mMaxDurationStats[eventId] < duration) {
                this.mMaxDurationStats[eventId] = duration;
            }
            if ((nowRealtime = SystemClock.elapsedRealtime()) > this.mNextTickTime) {
                if (this.mMaxCallsPerSecond[eventId] < this.mCallsPerSecond[eventId]) {
                    this.mMaxCallsPerSecond[eventId] = this.mCallsPerSecond[eventId];
                }
                if (this.mMaxDurationPerSecond[eventId] < this.mDurationPerSecond[eventId]) {
                    this.mMaxDurationPerSecond[eventId] = this.mDurationPerSecond[eventId];
                }
                this.mCallsPerSecond[eventId] = 0;
                this.mDurationPerSecond[eventId] = 0L;
                this.mNextTickTime = nowRealtime + 1000L;
            }
            int n3 = eventId;
            this.mCallsPerSecond[n3] = this.mCallsPerSecond[n3] + 1;
            int n4 = eventId;
            this.mDurationPerSecond[n4] = this.mDurationPerSecond[n4] + duration;
            return duration;
        }
    }

    private final void $$robo$$com_android_internal_util_StatLogger$dump(PrintWriter pw, String prefix) {
        this.dump(new IndentingPrintWriter((Writer)pw, "  ").setIndent(prefix));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_util_StatLogger$dump(IndentingPrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            pw.println("Stats:");
            pw.increaseIndent();
            for (int i = 0; i < this.SIZE; ++i) {
                int count = this.mCountStats[i];
                double durationMs = (double)this.mDurationStats[i] / 1000.0;
                pw.println(String.format("%s: count=%d, total=%.1fms, avg=%.3fms, max calls/s=%d max dur/s=%.1fms max time=%.1fms", this.mLabels[i], count, durationMs, count == 0 ? 0.0 : durationMs / (double)count, this.mMaxCallsPerSecond[i], (double)this.mMaxDurationPerSecond[i] / 1000.0, (double)this.mMaxDurationStats[i] / 1000.0));
            }
            pw.decreaseIndent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_util_StatLogger$dumpProto(ProtoOutputStream proto, long fieldId) {
        Object object = this.mLock;
        synchronized (object) {
            long outer = proto.start(fieldId);
            for (int i = 0; i < this.mLabels.length; ++i) {
                long inner = proto.start(2246267895809L);
                proto.write(0x10500000001L, i);
                proto.write(1138166333442L, this.mLabels[i]);
                proto.write(1120986464259L, this.mCountStats[i]);
                proto.write(1112396529668L, this.mDurationStats[i]);
                proto.end(inner);
            }
            proto.end(outer);
        }
    }

    private void __constructor__(String[] stringArray) {
        this.$$robo$$com_android_internal_util_StatLogger$__constructor__(stringArray);
    }

    public StatLogger(String[] stringArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_StatLogger$__constructor__(java.lang.String[] ), 0, this, stringArray);
    }

    public long getTime() {
        return (long)InvokeDynamicSupport.bootstrap("getTime", $$robo$$com_android_internal_util_StatLogger$getTime(), 0, this);
    }

    public long logDurationStat(int n, long l) {
        return (long)InvokeDynamicSupport.bootstrap("logDurationStat", $$robo$$com_android_internal_util_StatLogger$logDurationStat(int long ), 0, this, n, l);
    }

    public void dump(PrintWriter printWriter, String string2) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_util_StatLogger$dump(java.io.PrintWriter java.lang.String ), 0, this, printWriter, string2);
    }

    public void dump(IndentingPrintWriter indentingPrintWriter) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_util_StatLogger$dump(com.android.internal.util.IndentingPrintWriter ), 0, this, indentingPrintWriter);
    }

    public void dumpProto(ProtoOutputStream protoOutputStream, long l) {
        InvokeDynamicSupport.bootstrap("dumpProto", $$robo$$com_android_internal_util_StatLogger$dumpProto(android.util.proto.ProtoOutputStream long ), 0, this, protoOutputStream, l);
    }

    public /* synthetic */ StatLogger() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StatLogger)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

