/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.view.ActionMode;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowManager;
import android.widget.PopupWindow;
import com.android.internal.util.Preconditions;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.widget.FloatingToolbar;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class FloatingActionMode
extends ActionMode
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int MAX_HIDE_DURATION = 3000;
    private static int MOVING_HIDE_DELAY = 50;
    private Context mContext;
    private ActionMode.Callback2 mCallback;
    private MenuBuilder mMenu;
    private Rect mContentRect;
    private Rect mContentRectOnScreen;
    private Rect mPreviousContentRectOnScreen;
    private int[] mViewPositionOnScreen;
    private int[] mPreviousViewPositionOnScreen;
    private int[] mRootViewPositionOnScreen;
    private Rect mViewRectOnScreen;
    private Rect mPreviousViewRectOnScreen;
    private Rect mScreenRect;
    private View mOriginatingView;
    private Point mDisplaySize;
    private int mBottomAllowance;
    private Runnable mMovingOff;
    private Runnable mHideOff;
    private FloatingToolbar mFloatingToolbar;
    private FloatingToolbarVisibilityHelper mFloatingToolbarVisibilityHelper;

    private void $$robo$$com_android_internal_view_FloatingActionMode$__constructor__(Context context, ActionMode.Callback2 callback, View originatingView, FloatingToolbar floatingToolbar) {
        this.mMovingOff = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ FloatingActionMode this$0;

            private void $$robo$$com_android_internal_view_FloatingActionMode_1$__constructor__(FloatingActionMode this$0) {
            }

            private final void $$robo$$com_android_internal_view_FloatingActionMode_1$run() {
                if (this.this$0.isViewStillActive()) {
                    this.this$0.mFloatingToolbarVisibilityHelper.setMoving(false);
                    this.this$0.mFloatingToolbarVisibilityHelper.updateToolbarVisibility();
                }
            }

            private void __constructor__(FloatingActionMode floatingActionMode) {
                this.$$robo$$com_android_internal_view_FloatingActionMode_1$__constructor__(floatingActionMode);
            }
            {
                this.this$0 = floatingActionMode;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_FloatingActionMode_1$__constructor__(com.android.internal.view.FloatingActionMode ), 0, this, floatingActionMode);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_view_FloatingActionMode_1$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mHideOff = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ FloatingActionMode this$0;

            private void $$robo$$com_android_internal_view_FloatingActionMode_2$__constructor__(FloatingActionMode this$0) {
            }

            private final void $$robo$$com_android_internal_view_FloatingActionMode_2$run() {
                if (this.this$0.isViewStillActive()) {
                    this.this$0.mFloatingToolbarVisibilityHelper.setHideRequested(false);
                    this.this$0.mFloatingToolbarVisibilityHelper.updateToolbarVisibility();
                }
            }

            private void __constructor__(FloatingActionMode floatingActionMode) {
                this.$$robo$$com_android_internal_view_FloatingActionMode_2$__constructor__(floatingActionMode);
            }
            {
                this.this$0 = floatingActionMode;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_FloatingActionMode_2$__constructor__(com.android.internal.view.FloatingActionMode ), 0, this, floatingActionMode);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_view_FloatingActionMode_2$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = Preconditions.checkNotNull(context);
        this.mCallback = Preconditions.checkNotNull(callback);
        this.mMenu = new MenuBuilder(context).setDefaultShowAsAction(1);
        this.setType(1);
        this.mMenu.setCallback(new MenuBuilder.Callback(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ FloatingActionMode this$0;

            private void $$robo$$com_android_internal_view_FloatingActionMode_3$__constructor__(FloatingActionMode this$0) {
            }

            private final void $$robo$$com_android_internal_view_FloatingActionMode_3$onMenuModeChange(MenuBuilder menu2) {
            }

            private final boolean $$robo$$com_android_internal_view_FloatingActionMode_3$onMenuItemSelected(MenuBuilder menu2, MenuItem item) {
                return this.this$0.mCallback.onActionItemClicked(this.this$0, item);
            }

            private void __constructor__(FloatingActionMode floatingActionMode) {
                this.$$robo$$com_android_internal_view_FloatingActionMode_3$__constructor__(floatingActionMode);
            }
            {
                this.this$0 = floatingActionMode;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_FloatingActionMode_3$__constructor__(com.android.internal.view.FloatingActionMode ), 0, this, floatingActionMode);
            }

            @Override
            public void onMenuModeChange(MenuBuilder menuBuilder) {
                InvokeDynamicSupport.bootstrap("onMenuModeChange", $$robo$$com_android_internal_view_FloatingActionMode_3$onMenuModeChange(com.android.internal.view.menu.MenuBuilder ), 0, this, menuBuilder);
            }

            @Override
            public boolean onMenuItemSelected(MenuBuilder menuBuilder, MenuItem menuItem) {
                return (boolean)InvokeDynamicSupport.bootstrap("onMenuItemSelected", $$robo$$com_android_internal_view_FloatingActionMode_3$onMenuItemSelected(com.android.internal.view.menu.MenuBuilder android.view.MenuItem ), 0, this, menuBuilder, menuItem);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        this.mContentRect = new Rect();
        this.mContentRectOnScreen = new Rect();
        this.mPreviousContentRectOnScreen = new Rect();
        this.mViewPositionOnScreen = new int[2];
        this.mPreviousViewPositionOnScreen = new int[2];
        this.mRootViewPositionOnScreen = new int[2];
        this.mViewRectOnScreen = new Rect();
        this.mPreviousViewRectOnScreen = new Rect();
        this.mScreenRect = new Rect();
        this.mOriginatingView = Preconditions.checkNotNull(originatingView);
        this.mOriginatingView.getLocationOnScreen(this.mViewPositionOnScreen);
        this.mBottomAllowance = context.getResources().getDimensionPixelSize(17104982);
        this.mDisplaySize = new Point();
        this.setFloatingToolbar(Preconditions.checkNotNull(floatingToolbar));
    }

    private final void $$robo$$com_android_internal_view_FloatingActionMode$setFloatingToolbar(FloatingToolbar floatingToolbar) {
        this.mFloatingToolbar = floatingToolbar.setMenu(this.mMenu).setOnMenuItemClickListener(item -> this.mMenu.performItemAction(item, 0));
        this.mFloatingToolbarVisibilityHelper = new FloatingToolbarVisibilityHelper(this.mFloatingToolbar);
        this.mFloatingToolbarVisibilityHelper.activate();
    }

    private final void $$robo$$com_android_internal_view_FloatingActionMode$setTitle(CharSequence title) {
    }

    private final void $$robo$$com_android_internal_view_FloatingActionMode$setTitle(int resId) {
    }

    private final void $$robo$$com_android_internal_view_FloatingActionMode$setSubtitle(CharSequence subtitle) {
    }

    private final void $$robo$$com_android_internal_view_FloatingActionMode$setSubtitle(int resId) {
    }

    private final void $$robo$$com_android_internal_view_FloatingActionMode$setCustomView(View view) {
    }

    private final void $$robo$$com_android_internal_view_FloatingActionMode$invalidate() {
        this.mCallback.onPrepareActionMode(this, this.mMenu);
        this.invalidateContentRect();
    }

    private final void $$robo$$com_android_internal_view_FloatingActionMode$invalidateContentRect() {
        this.mCallback.onGetContentRect(this, this.mOriginatingView, this.mContentRect);
        this.repositionToolbar();
    }

    private final void $$robo$$com_android_internal_view_FloatingActionMode$updateViewLocationInWindow() {
        this.mOriginatingView.getLocationOnScreen(this.mViewPositionOnScreen);
        this.mOriginatingView.getRootView().getLocationOnScreen(this.mRootViewPositionOnScreen);
        this.mOriginatingView.getGlobalVisibleRect(this.mViewRectOnScreen);
        this.mViewRectOnScreen.offset(this.mRootViewPositionOnScreen[0], this.mRootViewPositionOnScreen[1]);
        if (!Arrays.equals(this.mViewPositionOnScreen, this.mPreviousViewPositionOnScreen) || !this.mViewRectOnScreen.equals(this.mPreviousViewRectOnScreen)) {
            this.repositionToolbar();
            this.mPreviousViewPositionOnScreen[0] = this.mViewPositionOnScreen[0];
            this.mPreviousViewPositionOnScreen[1] = this.mViewPositionOnScreen[1];
            this.mPreviousViewRectOnScreen.set(this.mViewRectOnScreen);
        }
    }

    private final void $$robo$$com_android_internal_view_FloatingActionMode$repositionToolbar() {
        this.mContentRectOnScreen.set(this.mContentRect);
        ViewParent parent = this.mOriginatingView.getParent();
        if (parent instanceof ViewGroup) {
            ((ViewGroup)parent).getChildVisibleRect(this.mOriginatingView, this.mContentRectOnScreen, null, true);
            this.mContentRectOnScreen.offset(this.mRootViewPositionOnScreen[0], this.mRootViewPositionOnScreen[1]);
        } else {
            this.mContentRectOnScreen.offset(this.mViewPositionOnScreen[0], this.mViewPositionOnScreen[1]);
        }
        if (this.isContentRectWithinBounds()) {
            this.mFloatingToolbarVisibilityHelper.setOutOfBounds(false);
            this.mContentRectOnScreen.set(Math.max(this.mContentRectOnScreen.left, this.mViewRectOnScreen.left), Math.max(this.mContentRectOnScreen.top, this.mViewRectOnScreen.top), Math.min(this.mContentRectOnScreen.right, this.mViewRectOnScreen.right), Math.min(this.mContentRectOnScreen.bottom, this.mViewRectOnScreen.bottom + this.mBottomAllowance));
            if (!this.mContentRectOnScreen.equals(this.mPreviousContentRectOnScreen)) {
                this.mOriginatingView.removeCallbacks(this.mMovingOff);
                this.mFloatingToolbarVisibilityHelper.setMoving(true);
                this.mOriginatingView.postDelayed(this.mMovingOff, 50L);
                this.mFloatingToolbar.setContentRect(this.mContentRectOnScreen);
                this.mFloatingToolbar.updateLayout();
            }
        } else {
            this.mFloatingToolbarVisibilityHelper.setOutOfBounds(true);
            this.mContentRectOnScreen.setEmpty();
        }
        this.mFloatingToolbarVisibilityHelper.updateToolbarVisibility();
        this.mPreviousContentRectOnScreen.set(this.mContentRectOnScreen);
    }

    private final boolean $$robo$$com_android_internal_view_FloatingActionMode$isContentRectWithinBounds() {
        this.mContext.getSystemService(WindowManager.class).getDefaultDisplay().getRealSize(this.mDisplaySize);
        this.mScreenRect.set(0, 0, this.mDisplaySize.x, this.mDisplaySize.y);
        return FloatingActionMode.intersectsClosed(this.mContentRectOnScreen, this.mScreenRect) && FloatingActionMode.intersectsClosed(this.mContentRectOnScreen, this.mViewRectOnScreen);
    }

    private static final boolean $$robo$$com_android_internal_view_FloatingActionMode$intersectsClosed(Rect a, Rect b) {
        return a.left <= b.right && b.left <= a.right && a.top <= b.bottom && b.top <= a.bottom;
    }

    private final void $$robo$$com_android_internal_view_FloatingActionMode$hide(long duration) {
        if (duration == -1L) {
            duration = ViewConfiguration.getDefaultActionModeHideDuration();
        }
        duration = Math.min(3000L, duration);
        this.mOriginatingView.removeCallbacks(this.mHideOff);
        if (duration <= 0L) {
            this.mHideOff.run();
        } else {
            this.mFloatingToolbarVisibilityHelper.setHideRequested(true);
            this.mFloatingToolbarVisibilityHelper.updateToolbarVisibility();
            this.mOriginatingView.postDelayed(this.mHideOff, duration);
        }
    }

    private final void $$robo$$com_android_internal_view_FloatingActionMode$setOutsideTouchable(boolean outsideTouchable, PopupWindow.OnDismissListener onDismiss) {
        this.mFloatingToolbar.setOutsideTouchable(outsideTouchable, onDismiss);
    }

    private final void $$robo$$com_android_internal_view_FloatingActionMode$onWindowFocusChanged(boolean hasWindowFocus) {
        this.mFloatingToolbarVisibilityHelper.setWindowFocused(hasWindowFocus);
        this.mFloatingToolbarVisibilityHelper.updateToolbarVisibility();
    }

    private final void $$robo$$com_android_internal_view_FloatingActionMode$finish() {
        this.reset();
        this.mCallback.onDestroyActionMode(this);
    }

    private final Menu $$robo$$com_android_internal_view_FloatingActionMode$getMenu() {
        return this.mMenu;
    }

    private final CharSequence $$robo$$com_android_internal_view_FloatingActionMode$getTitle() {
        return null;
    }

    private final CharSequence $$robo$$com_android_internal_view_FloatingActionMode$getSubtitle() {
        return null;
    }

    private final View $$robo$$com_android_internal_view_FloatingActionMode$getCustomView() {
        return null;
    }

    private final MenuInflater $$robo$$com_android_internal_view_FloatingActionMode$getMenuInflater() {
        return new MenuInflater(this.mContext);
    }

    private final void $$robo$$com_android_internal_view_FloatingActionMode$reset() {
        this.mFloatingToolbar.dismiss();
        this.mFloatingToolbarVisibilityHelper.deactivate();
        this.mOriginatingView.removeCallbacks(this.mMovingOff);
        this.mOriginatingView.removeCallbacks(this.mHideOff);
    }

    private final boolean $$robo$$com_android_internal_view_FloatingActionMode$isViewStillActive() {
        return this.mOriginatingView.getWindowVisibility() == 0 && this.mOriginatingView.isShown();
    }

    private void __constructor__(Context context, ActionMode.Callback2 callback2, View view, FloatingToolbar floatingToolbar) {
        this.$$robo$$com_android_internal_view_FloatingActionMode$__constructor__(context, callback2, view, floatingToolbar);
    }

    public FloatingActionMode(Context context, ActionMode.Callback2 callback2, View view, FloatingToolbar floatingToolbar) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_FloatingActionMode$__constructor__(android.content.Context android.view.ActionMode$Callback2 android.view.View com.android.internal.widget.FloatingToolbar ), 0, this, context, callback2, view, floatingToolbar);
    }

    private void setFloatingToolbar(FloatingToolbar floatingToolbar) {
        InvokeDynamicSupport.bootstrap("setFloatingToolbar", $$robo$$com_android_internal_view_FloatingActionMode$setFloatingToolbar(com.android.internal.widget.FloatingToolbar ), 0, this, floatingToolbar);
    }

    @Override
    public void setTitle(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setTitle", $$robo$$com_android_internal_view_FloatingActionMode$setTitle(java.lang.CharSequence ), 0, this, charSequence);
    }

    @Override
    public void setTitle(int n) {
        InvokeDynamicSupport.bootstrap("setTitle", $$robo$$com_android_internal_view_FloatingActionMode$setTitle(int ), 0, this, n);
    }

    @Override
    public void setSubtitle(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setSubtitle", $$robo$$com_android_internal_view_FloatingActionMode$setSubtitle(java.lang.CharSequence ), 0, this, charSequence);
    }

    @Override
    public void setSubtitle(int n) {
        InvokeDynamicSupport.bootstrap("setSubtitle", $$robo$$com_android_internal_view_FloatingActionMode$setSubtitle(int ), 0, this, n);
    }

    @Override
    public void setCustomView(View view) {
        InvokeDynamicSupport.bootstrap("setCustomView", $$robo$$com_android_internal_view_FloatingActionMode$setCustomView(android.view.View ), 0, this, view);
    }

    @Override
    public void invalidate() {
        InvokeDynamicSupport.bootstrap("invalidate", $$robo$$com_android_internal_view_FloatingActionMode$invalidate(), 0, this);
    }

    @Override
    public void invalidateContentRect() {
        InvokeDynamicSupport.bootstrap("invalidateContentRect", $$robo$$com_android_internal_view_FloatingActionMode$invalidateContentRect(), 0, this);
    }

    public void updateViewLocationInWindow() {
        InvokeDynamicSupport.bootstrap("updateViewLocationInWindow", $$robo$$com_android_internal_view_FloatingActionMode$updateViewLocationInWindow(), 0, this);
    }

    private void repositionToolbar() {
        InvokeDynamicSupport.bootstrap("repositionToolbar", $$robo$$com_android_internal_view_FloatingActionMode$repositionToolbar(), 0, this);
    }

    private boolean isContentRectWithinBounds() {
        return (boolean)InvokeDynamicSupport.bootstrap("isContentRectWithinBounds", $$robo$$com_android_internal_view_FloatingActionMode$isContentRectWithinBounds(), 0, this);
    }

    private static boolean intersectsClosed(Rect rect, Rect rect2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("intersectsClosed", $$robo$$com_android_internal_view_FloatingActionMode$intersectsClosed(android.graphics.Rect android.graphics.Rect ), 0, (Rect)rect, (Rect)rect2);
    }

    @Override
    public void hide(long l) {
        InvokeDynamicSupport.bootstrap("hide", $$robo$$com_android_internal_view_FloatingActionMode$hide(long ), 0, this, l);
    }

    public void setOutsideTouchable(boolean bl, PopupWindow.OnDismissListener onDismissListener) {
        InvokeDynamicSupport.bootstrap("setOutsideTouchable", $$robo$$com_android_internal_view_FloatingActionMode$setOutsideTouchable(boolean android.widget.PopupWindow$OnDismissListener ), 0, this, bl, onDismissListener);
    }

    @Override
    public void onWindowFocusChanged(boolean bl) {
        InvokeDynamicSupport.bootstrap("onWindowFocusChanged", $$robo$$com_android_internal_view_FloatingActionMode$onWindowFocusChanged(boolean ), 0, this, bl);
    }

    @Override
    public void finish() {
        InvokeDynamicSupport.bootstrap("finish", $$robo$$com_android_internal_view_FloatingActionMode$finish(), 0, this);
    }

    @Override
    public Menu getMenu() {
        return InvokeDynamicSupport.bootstrap("getMenu", $$robo$$com_android_internal_view_FloatingActionMode$getMenu(), 0, this);
    }

    @Override
    public CharSequence getTitle() {
        return InvokeDynamicSupport.bootstrap("getTitle", $$robo$$com_android_internal_view_FloatingActionMode$getTitle(), 0, this);
    }

    @Override
    public CharSequence getSubtitle() {
        return InvokeDynamicSupport.bootstrap("getSubtitle", $$robo$$com_android_internal_view_FloatingActionMode$getSubtitle(), 0, this);
    }

    @Override
    public View getCustomView() {
        return InvokeDynamicSupport.bootstrap("getCustomView", $$robo$$com_android_internal_view_FloatingActionMode$getCustomView(), 0, this);
    }

    @Override
    public MenuInflater getMenuInflater() {
        return InvokeDynamicSupport.bootstrap("getMenuInflater", $$robo$$com_android_internal_view_FloatingActionMode$getMenuInflater(), 0, this);
    }

    private void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_view_FloatingActionMode$reset(), 0, this);
    }

    private boolean isViewStillActive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isViewStillActive", $$robo$$com_android_internal_view_FloatingActionMode$isViewStillActive(), 0, this);
    }

    public /* synthetic */ FloatingActionMode() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FloatingActionMode)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class FloatingToolbarVisibilityHelper
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static long MIN_SHOW_DURATION_FOR_MOVE_HIDE = 500L;
        private FloatingToolbar mToolbar;
        private boolean mHideRequested;
        private boolean mMoving;
        private boolean mOutOfBounds;
        private boolean mWindowFocused;
        private boolean mActive;
        private long mLastShowTime;

        private void $$robo$$com_android_internal_view_FloatingActionMode_FloatingToolbarVisibilityHelper$__constructor__(FloatingToolbar toolbar) {
            this.mWindowFocused = true;
            this.mToolbar = Preconditions.checkNotNull(toolbar);
        }

        private final void $$robo$$com_android_internal_view_FloatingActionMode_FloatingToolbarVisibilityHelper$activate() {
            this.mHideRequested = false;
            this.mMoving = false;
            this.mOutOfBounds = false;
            this.mWindowFocused = true;
            this.mActive = true;
        }

        private final void $$robo$$com_android_internal_view_FloatingActionMode_FloatingToolbarVisibilityHelper$deactivate() {
            this.mActive = false;
            this.mToolbar.dismiss();
        }

        private final void $$robo$$com_android_internal_view_FloatingActionMode_FloatingToolbarVisibilityHelper$setHideRequested(boolean hide) {
            this.mHideRequested = hide;
        }

        private final void $$robo$$com_android_internal_view_FloatingActionMode_FloatingToolbarVisibilityHelper$setMoving(boolean moving) {
            boolean showingLongEnough;
            boolean bl = showingLongEnough = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System") - this.mLastShowTime > 500L;
            if (!moving || showingLongEnough) {
                this.mMoving = moving;
            }
        }

        private final void $$robo$$com_android_internal_view_FloatingActionMode_FloatingToolbarVisibilityHelper$setOutOfBounds(boolean outOfBounds) {
            this.mOutOfBounds = outOfBounds;
        }

        private final void $$robo$$com_android_internal_view_FloatingActionMode_FloatingToolbarVisibilityHelper$setWindowFocused(boolean windowFocused) {
            this.mWindowFocused = windowFocused;
        }

        private final void $$robo$$com_android_internal_view_FloatingActionMode_FloatingToolbarVisibilityHelper$updateToolbarVisibility() {
            if (!this.mActive) {
                return;
            }
            if (this.mHideRequested || this.mMoving || this.mOutOfBounds || !this.mWindowFocused) {
                this.mToolbar.hide();
            } else {
                this.mToolbar.show();
                this.mLastShowTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
            }
        }

        private void __constructor__(FloatingToolbar floatingToolbar) {
            this.$$robo$$com_android_internal_view_FloatingActionMode_FloatingToolbarVisibilityHelper$__constructor__(floatingToolbar);
        }

        public FloatingToolbarVisibilityHelper(FloatingToolbar floatingToolbar) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_FloatingActionMode_FloatingToolbarVisibilityHelper$__constructor__(com.android.internal.widget.FloatingToolbar ), 0, this, floatingToolbar);
        }

        public void activate() {
            InvokeDynamicSupport.bootstrap("activate", $$robo$$com_android_internal_view_FloatingActionMode_FloatingToolbarVisibilityHelper$activate(), 0, this);
        }

        public void deactivate() {
            InvokeDynamicSupport.bootstrap("deactivate", $$robo$$com_android_internal_view_FloatingActionMode_FloatingToolbarVisibilityHelper$deactivate(), 0, this);
        }

        public void setHideRequested(boolean bl) {
            InvokeDynamicSupport.bootstrap("setHideRequested", $$robo$$com_android_internal_view_FloatingActionMode_FloatingToolbarVisibilityHelper$setHideRequested(boolean ), 0, this, bl);
        }

        public void setMoving(boolean bl) {
            InvokeDynamicSupport.bootstrap("setMoving", $$robo$$com_android_internal_view_FloatingActionMode_FloatingToolbarVisibilityHelper$setMoving(boolean ), 0, this, bl);
        }

        public void setOutOfBounds(boolean bl) {
            InvokeDynamicSupport.bootstrap("setOutOfBounds", $$robo$$com_android_internal_view_FloatingActionMode_FloatingToolbarVisibilityHelper$setOutOfBounds(boolean ), 0, this, bl);
        }

        public void setWindowFocused(boolean bl) {
            InvokeDynamicSupport.bootstrap("setWindowFocused", $$robo$$com_android_internal_view_FloatingActionMode_FloatingToolbarVisibilityHelper$setWindowFocused(boolean ), 0, this, bl);
        }

        public void updateToolbarVisibility() {
            InvokeDynamicSupport.bootstrap("updateToolbarVisibility", $$robo$$com_android_internal_view_FloatingActionMode_FloatingToolbarVisibilityHelper$updateToolbarVisibility(), 0, this);
        }

        public /* synthetic */ FloatingToolbarVisibilityHelper() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FloatingToolbarVisibilityHelper)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

