/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.content.Context;
import android.content.pm.PackageManager;
import android.database.ContentObserver;
import android.graphics.Point;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.RemoteException;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.Log;
import android.view.IWindowManager;
import android.view.WindowManagerGlobal;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class RotationPolicy
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "RotationPolicy";
    private static int CURRENT_ROTATION = -1;
    public static int NATURAL_ROTATION = 0;

    private void $$robo$$com_android_internal_view_RotationPolicy$__constructor__() {
    }

    private static final boolean $$robo$$com_android_internal_view_RotationPolicy$isRotationSupported(Context context) {
        PackageManager pm = context.getPackageManager();
        return pm.hasSystemFeature("android.hardware.sensor.accelerometer") && pm.hasSystemFeature("android.hardware.screen.portrait") && pm.hasSystemFeature("android.hardware.screen.landscape") && context.getResources().getBoolean(17957036);
    }

    private static final int $$robo$$com_android_internal_view_RotationPolicy$getRotationLockOrientation(Context context) {
        if (!RotationPolicy.areAllRotationsAllowed(context)) {
            Point size = new Point();
            IWindowManager wm = WindowManagerGlobal.getWindowManagerService();
            try {
                wm.getInitialDisplaySize(0, size);
                return size.x < size.y ? 1 : 2;
            }
            catch (RemoteException e) {
                Log.w("RotationPolicy", "Unable to get the display size");
            }
        }
        return 0;
    }

    private static final boolean $$robo$$com_android_internal_view_RotationPolicy$isRotationLockToggleVisible(Context context) {
        return RotationPolicy.isRotationSupported(context) && Settings.System.getIntForUser(context.getContentResolver(), "hide_rotation_lock_toggle_for_accessibility", 0, -2) == 0;
    }

    private static final boolean $$robo$$com_android_internal_view_RotationPolicy$isRotationLocked(Context context) {
        return Settings.System.getIntForUser(context.getContentResolver(), "accelerometer_rotation", 0, -2) == 0;
    }

    private static final void $$robo$$com_android_internal_view_RotationPolicy$setRotationLock(Context context, boolean enabled) {
        int rotation = RotationPolicy.areAllRotationsAllowed(context) ? -1 : 0;
        RotationPolicy.setRotationLockAtAngle(context, enabled, rotation);
    }

    private static final void $$robo$$com_android_internal_view_RotationPolicy$setRotationLockAtAngle(Context context, boolean enabled, int rotation) {
        Settings.System.putIntForUser(context.getContentResolver(), "hide_rotation_lock_toggle_for_accessibility", 0, -2);
        RotationPolicy.setRotationLock(enabled, rotation);
    }

    private static final void $$robo$$com_android_internal_view_RotationPolicy$setRotationLockForAccessibility(Context context, boolean enabled) {
        Settings.System.putIntForUser(context.getContentResolver(), "hide_rotation_lock_toggle_for_accessibility", enabled ? 1 : 0, -2);
        RotationPolicy.setRotationLock(enabled, 0);
    }

    private static final boolean $$robo$$com_android_internal_view_RotationPolicy$areAllRotationsAllowed(Context context) {
        return context.getResources().getBoolean(17956870);
    }

    private static final void $$robo$$com_android_internal_view_RotationPolicy$setRotationLock(boolean enabled, int rotation) {
        AsyncTask.execute(new Runnable(enabled, rotation){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ boolean val$enabled;
            /* synthetic */ int val$rotation;

            private void $$robo$$com_android_internal_view_RotationPolicy_1$__constructor__(boolean bl, int n) {
            }

            private final void $$robo$$com_android_internal_view_RotationPolicy_1$run() {
                try {
                    IWindowManager wm = WindowManagerGlobal.getWindowManagerService();
                    if (this.val$enabled) {
                        wm.freezeRotation(this.val$rotation);
                    } else {
                        wm.thawRotation();
                    }
                }
                catch (RemoteException exc) {
                    Log.w("RotationPolicy", "Unable to save auto-rotate setting");
                }
            }

            private void __constructor__(boolean bl, int n) {
                this.$$robo$$com_android_internal_view_RotationPolicy_1$__constructor__(bl, n);
            }
            {
                this.val$enabled = bl;
                this.val$rotation = n;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_RotationPolicy_1$__constructor__(boolean int ), 0, this, bl, n);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_view_RotationPolicy_1$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private static final void $$robo$$com_android_internal_view_RotationPolicy$registerRotationPolicyListener(Context context, RotationPolicyListener listener) {
        RotationPolicy.registerRotationPolicyListener(context, listener, UserHandle.getCallingUserId());
    }

    private static final void $$robo$$com_android_internal_view_RotationPolicy$registerRotationPolicyListener(Context context, RotationPolicyListener listener, int userHandle) {
        context.getContentResolver().registerContentObserver(Settings.System.getUriFor("accelerometer_rotation"), false, listener.mObserver, userHandle);
        context.getContentResolver().registerContentObserver(Settings.System.getUriFor("hide_rotation_lock_toggle_for_accessibility"), false, listener.mObserver, userHandle);
    }

    private static final void $$robo$$com_android_internal_view_RotationPolicy$unregisterRotationPolicyListener(Context context, RotationPolicyListener listener) {
        context.getContentResolver().unregisterContentObserver(listener.mObserver);
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_view_RotationPolicy$__constructor__();
    }

    private RotationPolicy() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_RotationPolicy$__constructor__(), 0, this);
    }

    public static boolean isRotationSupported(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isRotationSupported", $$robo$$com_android_internal_view_RotationPolicy$isRotationSupported(android.content.Context ), 0, (Context)context);
    }

    public static int getRotationLockOrientation(Context context) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getRotationLockOrientation", $$robo$$com_android_internal_view_RotationPolicy$getRotationLockOrientation(android.content.Context ), 0, (Context)context);
    }

    public static boolean isRotationLockToggleVisible(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isRotationLockToggleVisible", $$robo$$com_android_internal_view_RotationPolicy$isRotationLockToggleVisible(android.content.Context ), 0, (Context)context);
    }

    public static boolean isRotationLocked(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isRotationLocked", $$robo$$com_android_internal_view_RotationPolicy$isRotationLocked(android.content.Context ), 0, (Context)context);
    }

    public static void setRotationLock(Context context, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("setRotationLock", $$robo$$com_android_internal_view_RotationPolicy$setRotationLock(android.content.Context boolean ), 0, (Context)context, (boolean)bl);
    }

    public static void setRotationLockAtAngle(Context context, boolean bl, int n) {
        InvokeDynamicSupport.bootstrapStatic("setRotationLockAtAngle", $$robo$$com_android_internal_view_RotationPolicy$setRotationLockAtAngle(android.content.Context boolean int ), 0, (Context)context, (boolean)bl, (int)n);
    }

    public static void setRotationLockForAccessibility(Context context, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("setRotationLockForAccessibility", $$robo$$com_android_internal_view_RotationPolicy$setRotationLockForAccessibility(android.content.Context boolean ), 0, (Context)context, (boolean)bl);
    }

    private static boolean areAllRotationsAllowed(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("areAllRotationsAllowed", $$robo$$com_android_internal_view_RotationPolicy$areAllRotationsAllowed(android.content.Context ), 0, (Context)context);
    }

    private static void setRotationLock(boolean bl, int n) {
        InvokeDynamicSupport.bootstrapStatic("setRotationLock", $$robo$$com_android_internal_view_RotationPolicy$setRotationLock(boolean int ), 0, (boolean)bl, (int)n);
    }

    public static void registerRotationPolicyListener(Context context, RotationPolicyListener rotationPolicyListener) {
        InvokeDynamicSupport.bootstrapStatic("registerRotationPolicyListener", $$robo$$com_android_internal_view_RotationPolicy$registerRotationPolicyListener(android.content.Context com.android.internal.view.RotationPolicy$RotationPolicyListener ), 0, (Context)context, (RotationPolicyListener)rotationPolicyListener);
    }

    public static void registerRotationPolicyListener(Context context, RotationPolicyListener rotationPolicyListener, int n) {
        InvokeDynamicSupport.bootstrapStatic("registerRotationPolicyListener", $$robo$$com_android_internal_view_RotationPolicy$registerRotationPolicyListener(android.content.Context com.android.internal.view.RotationPolicy$RotationPolicyListener int ), 0, (Context)context, (RotationPolicyListener)rotationPolicyListener, (int)n);
    }

    public static void unregisterRotationPolicyListener(Context context, RotationPolicyListener rotationPolicyListener) {
        InvokeDynamicSupport.bootstrapStatic("unregisterRotationPolicyListener", $$robo$$com_android_internal_view_RotationPolicy$unregisterRotationPolicyListener(android.content.Context com.android.internal.view.RotationPolicy$RotationPolicyListener ), 0, (Context)context, (RotationPolicyListener)rotationPolicyListener);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RotationPolicy)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static abstract class RotationPolicyListener
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        ContentObserver mObserver;

        private void $$robo$$com_android_internal_view_RotationPolicy_RotationPolicyListener$__constructor__() {
            this.mObserver = new ShadowedObject(this, new Handler()){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ RotationPolicyListener this$0;

                private void $$robo$$com_android_internal_view_RotationPolicy_RotationPolicyListener_1$__constructor__(RotationPolicyListener this$0, Handler x0) {
                }

                private final void $$robo$$com_android_internal_view_RotationPolicy_RotationPolicyListener_1$onChange(boolean selfChange, Uri uri) {
                    this.this$0.onChange();
                }

                private void __constructor__(RotationPolicyListener rotationPolicyListener, Handler handler) {
                    this.$$robo$$com_android_internal_view_RotationPolicy_RotationPolicyListener_1$__constructor__(rotationPolicyListener, handler);
                }
                {
                    this.this$0 = rotationPolicyListener;
                    super(handler);
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_RotationPolicy_RotationPolicyListener_1$__constructor__(com.android.internal.view.RotationPolicy$RotationPolicyListener android.os.Handler ), 0, this, rotationPolicyListener, handler);
                }

                @Override
                public void onChange(boolean bl, Uri uri) {
                    InvokeDynamicSupport.bootstrap("onChange", $$robo$$com_android_internal_view_RotationPolicy_RotationPolicyListener_1$onChange(boolean android.net.Uri ), 0, this, bl, uri);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        public abstract void onChange();

        private void __constructor__() {
            this.$$robo$$com_android_internal_view_RotationPolicy_RotationPolicyListener$__constructor__();
        }

        public RotationPolicyListener() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_RotationPolicy_RotationPolicyListener$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RotationPolicyListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

