/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.ActionMode;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.android.internal.R;
import com.android.internal.widget.ScrollingTabContainerView;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ActionBarContainer
extends FrameLayout
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private boolean mIsTransitioning;
    private View mTabContainer;
    private View mActionBarView;
    private View mActionContextView;
    private Drawable mBackground;
    private Drawable mStackedBackground;
    private Drawable mSplitBackground;
    private boolean mIsSplit;
    private boolean mIsStacked;
    private int mHeight;

    private void $$robo$$com_android_internal_widget_ActionBarContainer$__constructor__(Context context) {
    }

    private void $$robo$$com_android_internal_widget_ActionBarContainer$__constructor__(Context context, AttributeSet attrs) {
        this.setBackground(new ActionBarBackgroundDrawable(this));
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ActionBar);
        this.mBackground = a.getDrawable(2);
        this.mStackedBackground = a.getDrawable(18);
        this.mHeight = a.getDimensionPixelSize(4, -1);
        if (this.getId() == 16909335) {
            this.mIsSplit = true;
            this.mSplitBackground = a.getDrawable(19);
        }
        a.recycle();
        this.setWillNotDraw(this.mIsSplit ? this.mSplitBackground == null : this.mBackground == null && this.mStackedBackground == null);
    }

    private final void $$robo$$com_android_internal_widget_ActionBarContainer$onFinishInflate() {
        super.onFinishInflate();
        this.mActionBarView = this.findViewById(16908672);
        this.mActionContextView = this.findViewById(16908677);
    }

    private final void $$robo$$com_android_internal_widget_ActionBarContainer$setPrimaryBackground(Drawable bg) {
        if (this.mBackground != null) {
            this.mBackground.setCallback(null);
            this.unscheduleDrawable(this.mBackground);
        }
        this.mBackground = bg;
        if (bg != null) {
            bg.setCallback(this);
            if (this.mActionBarView != null) {
                this.mBackground.setBounds(this.mActionBarView.getLeft(), this.mActionBarView.getTop(), this.mActionBarView.getRight(), this.mActionBarView.getBottom());
            }
        }
        this.setWillNotDraw(this.mIsSplit ? this.mSplitBackground == null : this.mBackground == null && this.mStackedBackground == null);
        this.invalidate();
    }

    private final void $$robo$$com_android_internal_widget_ActionBarContainer$setStackedBackground(Drawable bg) {
        if (this.mStackedBackground != null) {
            this.mStackedBackground.setCallback(null);
            this.unscheduleDrawable(this.mStackedBackground);
        }
        this.mStackedBackground = bg;
        if (bg != null) {
            bg.setCallback(this);
            if (this.mIsStacked && this.mStackedBackground != null) {
                this.mStackedBackground.setBounds(this.mTabContainer.getLeft(), this.mTabContainer.getTop(), this.mTabContainer.getRight(), this.mTabContainer.getBottom());
            }
        }
        this.setWillNotDraw(this.mIsSplit ? this.mSplitBackground == null : this.mBackground == null && this.mStackedBackground == null);
        this.invalidate();
    }

    private final void $$robo$$com_android_internal_widget_ActionBarContainer$setSplitBackground(Drawable bg) {
        if (this.mSplitBackground != null) {
            this.mSplitBackground.setCallback(null);
            this.unscheduleDrawable(this.mSplitBackground);
        }
        this.mSplitBackground = bg;
        if (bg != null) {
            bg.setCallback(this);
            if (this.mIsSplit && this.mSplitBackground != null) {
                this.mSplitBackground.setBounds(0, 0, this.getMeasuredWidth(), this.getMeasuredHeight());
            }
        }
        this.setWillNotDraw(this.mIsSplit ? this.mSplitBackground == null : this.mBackground == null && this.mStackedBackground == null);
        this.invalidate();
    }

    private final void $$robo$$com_android_internal_widget_ActionBarContainer$setVisibility(int visibility) {
        boolean isVisible;
        super.setVisibility(visibility);
        boolean bl = isVisible = visibility == 0;
        if (this.mBackground != null) {
            this.mBackground.setVisible(isVisible, false);
        }
        if (this.mStackedBackground != null) {
            this.mStackedBackground.setVisible(isVisible, false);
        }
        if (this.mSplitBackground != null) {
            this.mSplitBackground.setVisible(isVisible, false);
        }
    }

    private final boolean $$robo$$com_android_internal_widget_ActionBarContainer$verifyDrawable(Drawable who) {
        return who == this.mBackground && !this.mIsSplit || who == this.mStackedBackground && this.mIsStacked || who == this.mSplitBackground && this.mIsSplit || super.verifyDrawable(who);
    }

    private final void $$robo$$com_android_internal_widget_ActionBarContainer$drawableStateChanged() {
        Drawable splitBackground;
        Drawable stackedBackground;
        super.drawableStateChanged();
        int[] state = this.getDrawableState();
        boolean changed = false;
        Drawable background = this.mBackground;
        if (background != null && background.isStateful()) {
            changed |= background.setState(state);
        }
        if ((stackedBackground = this.mStackedBackground) != null && stackedBackground.isStateful()) {
            changed |= stackedBackground.setState(state);
        }
        if ((splitBackground = this.mSplitBackground) != null && splitBackground.isStateful()) {
            changed |= splitBackground.setState(state);
        }
        if (changed) {
            this.invalidate();
        }
    }

    private final void $$robo$$com_android_internal_widget_ActionBarContainer$jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mBackground != null) {
            this.mBackground.jumpToCurrentState();
        }
        if (this.mStackedBackground != null) {
            this.mStackedBackground.jumpToCurrentState();
        }
        if (this.mSplitBackground != null) {
            this.mSplitBackground.jumpToCurrentState();
        }
    }

    private final void $$robo$$com_android_internal_widget_ActionBarContainer$onResolveDrawables(int layoutDirection) {
        super.onResolveDrawables(layoutDirection);
        if (this.mBackground != null) {
            this.mBackground.setLayoutDirection(layoutDirection);
        }
        if (this.mStackedBackground != null) {
            this.mStackedBackground.setLayoutDirection(layoutDirection);
        }
        if (this.mSplitBackground != null) {
            this.mSplitBackground.setLayoutDirection(layoutDirection);
        }
    }

    private final void $$robo$$com_android_internal_widget_ActionBarContainer$setTransitioning(boolean isTransitioning) {
        this.mIsTransitioning = isTransitioning;
        this.setDescendantFocusability(isTransitioning ? 393216 : 262144);
    }

    private final boolean $$robo$$com_android_internal_widget_ActionBarContainer$onInterceptTouchEvent(MotionEvent ev) {
        return this.mIsTransitioning || super.onInterceptTouchEvent(ev);
    }

    private final boolean $$robo$$com_android_internal_widget_ActionBarContainer$onTouchEvent(MotionEvent ev) {
        super.onTouchEvent(ev);
        return true;
    }

    private final boolean $$robo$$com_android_internal_widget_ActionBarContainer$onHoverEvent(MotionEvent ev) {
        super.onHoverEvent(ev);
        return true;
    }

    private final void $$robo$$com_android_internal_widget_ActionBarContainer$setTabContainer(ScrollingTabContainerView tabView) {
        if (this.mTabContainer != null) {
            this.removeView(this.mTabContainer);
        }
        this.mTabContainer = tabView;
        if (tabView != null) {
            this.addView(tabView);
            ViewGroup.LayoutParams lp = tabView.getLayoutParams();
            lp.width = -1;
            lp.height = -2;
            tabView.setAllowCollapse(false);
        }
    }

    private final View $$robo$$com_android_internal_widget_ActionBarContainer$getTabContainer() {
        return this.mTabContainer;
    }

    private final ActionMode $$robo$$com_android_internal_widget_ActionBarContainer$startActionModeForChild(View child, ActionMode.Callback callback, int type) {
        if (type != 0) {
            return super.startActionModeForChild(child, callback, type);
        }
        return null;
    }

    private static final boolean $$robo$$com_android_internal_widget_ActionBarContainer$isCollapsed(View view) {
        return view == null || view.getVisibility() == 8 || view.getMeasuredHeight() == 0;
    }

    private final int $$robo$$com_android_internal_widget_ActionBarContainer$getMeasuredHeightWithMargins(View view) {
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)view.getLayoutParams();
        return view.getMeasuredHeight() + lp.topMargin + lp.bottomMargin;
    }

    private final void $$robo$$com_android_internal_widget_ActionBarContainer$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mActionBarView == null && View.MeasureSpec.getMode(heightMeasureSpec) == Integer.MIN_VALUE && this.mHeight >= 0) {
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(Math.min(this.mHeight, View.MeasureSpec.getSize(heightMeasureSpec)), Integer.MIN_VALUE);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mActionBarView == null) {
            return;
        }
        if (this.mTabContainer != null && this.mTabContainer.getVisibility() != 8) {
            int nonTabMaxHeight = 0;
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                if (child == this.mTabContainer) continue;
                nonTabMaxHeight = Math.max(nonTabMaxHeight, ActionBarContainer.isCollapsed(child) ? 0 : this.getMeasuredHeightWithMargins(child));
            }
            int mode = View.MeasureSpec.getMode(heightMeasureSpec);
            int maxHeight = mode == Integer.MIN_VALUE ? View.MeasureSpec.getSize(heightMeasureSpec) : Integer.MAX_VALUE;
            this.setMeasuredDimension(this.getMeasuredWidth(), Math.min(nonTabMaxHeight + this.getMeasuredHeightWithMargins(this.mTabContainer), maxHeight));
        }
    }

    private final void $$robo$$com_android_internal_widget_ActionBarContainer$onLayout(boolean changed, int l, int t, int r, int b) {
        boolean hasTabs;
        super.onLayout(changed, l, t, r, b);
        View tabContainer = this.mTabContainer;
        boolean bl = hasTabs = tabContainer != null && tabContainer.getVisibility() != 8;
        if (tabContainer != null && tabContainer.getVisibility() != 8) {
            int containerHeight = this.getMeasuredHeight();
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)tabContainer.getLayoutParams();
            int tabHeight = tabContainer.getMeasuredHeight();
            tabContainer.layout(l, containerHeight - tabHeight - lp.bottomMargin, r, containerHeight - lp.bottomMargin);
        }
        boolean needsInvalidate = false;
        if (this.mIsSplit) {
            if (this.mSplitBackground != null) {
                this.mSplitBackground.setBounds(0, 0, this.getMeasuredWidth(), this.getMeasuredHeight());
                needsInvalidate = true;
            }
        } else {
            if (this.mBackground != null) {
                if (this.mActionBarView.getVisibility() == 0) {
                    this.mBackground.setBounds(this.mActionBarView.getLeft(), this.mActionBarView.getTop(), this.mActionBarView.getRight(), this.mActionBarView.getBottom());
                } else if (this.mActionContextView != null && this.mActionContextView.getVisibility() == 0) {
                    this.mBackground.setBounds(this.mActionContextView.getLeft(), this.mActionContextView.getTop(), this.mActionContextView.getRight(), this.mActionContextView.getBottom());
                } else {
                    this.mBackground.setBounds(0, 0, 0, 0);
                }
                needsInvalidate = true;
            }
            this.mIsStacked = hasTabs;
            if (hasTabs && this.mStackedBackground != null) {
                this.mStackedBackground.setBounds(tabContainer.getLeft(), tabContainer.getTop(), tabContainer.getRight(), tabContainer.getBottom());
                needsInvalidate = true;
            }
        }
        if (needsInvalidate) {
            this.invalidate();
        }
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_widget_ActionBarContainer$__constructor__(context);
    }

    public ActionBarContainer(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ActionBarContainer$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$com_android_internal_widget_ActionBarContainer$__constructor__(context, attributeSet);
    }

    public ActionBarContainer(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ActionBarContainer$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    @Override
    public void onFinishInflate() {
        InvokeDynamicSupport.bootstrap("onFinishInflate", $$robo$$com_android_internal_widget_ActionBarContainer$onFinishInflate(), 0, this);
    }

    public void setPrimaryBackground(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setPrimaryBackground", $$robo$$com_android_internal_widget_ActionBarContainer$setPrimaryBackground(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public void setStackedBackground(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setStackedBackground", $$robo$$com_android_internal_widget_ActionBarContainer$setStackedBackground(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public void setSplitBackground(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setSplitBackground", $$robo$$com_android_internal_widget_ActionBarContainer$setSplitBackground(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    @Override
    public void setVisibility(int n) {
        InvokeDynamicSupport.bootstrap("setVisibility", $$robo$$com_android_internal_widget_ActionBarContainer$setVisibility(int ), 0, this, n);
    }

    @Override
    protected boolean verifyDrawable(Drawable drawable2) {
        return (boolean)InvokeDynamicSupport.bootstrap("verifyDrawable", $$robo$$com_android_internal_widget_ActionBarContainer$verifyDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    @Override
    protected void drawableStateChanged() {
        InvokeDynamicSupport.bootstrap("drawableStateChanged", $$robo$$com_android_internal_widget_ActionBarContainer$drawableStateChanged(), 0, this);
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        InvokeDynamicSupport.bootstrap("jumpDrawablesToCurrentState", $$robo$$com_android_internal_widget_ActionBarContainer$jumpDrawablesToCurrentState(), 0, this);
    }

    @Override
    public void onResolveDrawables(int n) {
        InvokeDynamicSupport.bootstrap("onResolveDrawables", $$robo$$com_android_internal_widget_ActionBarContainer$onResolveDrawables(int ), 0, this, n);
    }

    public void setTransitioning(boolean bl) {
        InvokeDynamicSupport.bootstrap("setTransitioning", $$robo$$com_android_internal_widget_ActionBarContainer$setTransitioning(boolean ), 0, this, bl);
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onInterceptTouchEvent", $$robo$$com_android_internal_widget_ActionBarContainer$onInterceptTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$com_android_internal_widget_ActionBarContainer$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean onHoverEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onHoverEvent", $$robo$$com_android_internal_widget_ActionBarContainer$onHoverEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    public void setTabContainer(ScrollingTabContainerView scrollingTabContainerView) {
        InvokeDynamicSupport.bootstrap("setTabContainer", $$robo$$com_android_internal_widget_ActionBarContainer$setTabContainer(com.android.internal.widget.ScrollingTabContainerView ), 0, this, scrollingTabContainerView);
    }

    public View getTabContainer() {
        return InvokeDynamicSupport.bootstrap("getTabContainer", $$robo$$com_android_internal_widget_ActionBarContainer$getTabContainer(), 0, this);
    }

    @Override
    public ActionMode startActionModeForChild(View view, ActionMode.Callback callback, int n) {
        return InvokeDynamicSupport.bootstrap("startActionModeForChild", $$robo$$com_android_internal_widget_ActionBarContainer$startActionModeForChild(android.view.View android.view.ActionMode$Callback int ), 0, this, view, callback, n);
    }

    private static boolean isCollapsed(View view) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isCollapsed", $$robo$$com_android_internal_widget_ActionBarContainer$isCollapsed(android.view.View ), 0, (View)view);
    }

    private int getMeasuredHeightWithMargins(View view) {
        return (int)InvokeDynamicSupport.bootstrap("getMeasuredHeightWithMargins", $$robo$$com_android_internal_widget_ActionBarContainer$getMeasuredHeightWithMargins(android.view.View ), 0, this, view);
    }

    @Override
    public void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$com_android_internal_widget_ActionBarContainer$onMeasure(int int ), 0, this, n, n2);
    }

    @Override
    public void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$com_android_internal_widget_ActionBarContainer$onLayout(boolean int int int int ), 0, this, bl, n, n2, n3, n4);
    }

    public /* synthetic */ ActionBarContainer() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActionBarContainer)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class ActionBarBackgroundDrawable
    extends Drawable
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ActionBarContainer this$0;

        private void $$robo$$com_android_internal_widget_ActionBarContainer_ActionBarBackgroundDrawable$__constructor__(ActionBarContainer actionBarContainer) {
        }

        private final void $$robo$$com_android_internal_widget_ActionBarContainer_ActionBarBackgroundDrawable$draw(Canvas canvas) {
            if (this.this$0.mIsSplit) {
                if (this.this$0.mSplitBackground != null) {
                    this.this$0.mSplitBackground.draw(canvas);
                }
            } else {
                if (this.this$0.mBackground != null) {
                    this.this$0.mBackground.draw(canvas);
                }
                if (this.this$0.mStackedBackground != null && this.this$0.mIsStacked) {
                    this.this$0.mStackedBackground.draw(canvas);
                }
            }
        }

        private final void $$robo$$com_android_internal_widget_ActionBarContainer_ActionBarBackgroundDrawable$getOutline(Outline outline) {
            if (this.this$0.mIsSplit) {
                if (this.this$0.mSplitBackground != null) {
                    this.this$0.mSplitBackground.getOutline(outline);
                }
            } else if (this.this$0.mBackground != null) {
                this.this$0.mBackground.getOutline(outline);
            }
        }

        private final void $$robo$$com_android_internal_widget_ActionBarContainer_ActionBarBackgroundDrawable$setAlpha(int alpha) {
        }

        private final void $$robo$$com_android_internal_widget_ActionBarContainer_ActionBarBackgroundDrawable$setColorFilter(ColorFilter colorFilter) {
        }

        private final int $$robo$$com_android_internal_widget_ActionBarContainer_ActionBarBackgroundDrawable$getOpacity() {
            if (this.this$0.mIsSplit) {
                if (this.this$0.mSplitBackground != null && this.this$0.mSplitBackground.getOpacity() == -1) {
                    return -1;
                }
            } else {
                if (this.this$0.mIsStacked && (this.this$0.mStackedBackground == null || this.this$0.mStackedBackground.getOpacity() != -1)) {
                    return 0;
                }
                if (!ActionBarContainer.isCollapsed(this.this$0.mActionBarView) && this.this$0.mBackground != null && this.this$0.mBackground.getOpacity() == -1) {
                    return -1;
                }
            }
            return 0;
        }

        private /* synthetic */ void $$robo$$com_android_internal_widget_ActionBarContainer_ActionBarBackgroundDrawable$__constructor__(ActionBarContainer x0, 1 x1) {
        }

        private void __constructor__(ActionBarContainer actionBarContainer) {
            this.$$robo$$com_android_internal_widget_ActionBarContainer_ActionBarBackgroundDrawable$__constructor__(actionBarContainer);
        }

        private ActionBarBackgroundDrawable(ActionBarContainer actionBarContainer) {
            this.this$0 = actionBarContainer;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ActionBarContainer_ActionBarBackgroundDrawable$__constructor__(com.android.internal.widget.ActionBarContainer ), 0, this, actionBarContainer);
        }

        @Override
        public void draw(Canvas canvas) {
            InvokeDynamicSupport.bootstrap("draw", $$robo$$com_android_internal_widget_ActionBarContainer_ActionBarBackgroundDrawable$draw(android.graphics.Canvas ), 0, this, canvas);
        }

        @Override
        public void getOutline(Outline outline) {
            InvokeDynamicSupport.bootstrap("getOutline", $$robo$$com_android_internal_widget_ActionBarContainer_ActionBarBackgroundDrawable$getOutline(android.graphics.Outline ), 0, this, outline);
        }

        @Override
        public void setAlpha(int n) {
            InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$com_android_internal_widget_ActionBarContainer_ActionBarBackgroundDrawable$setAlpha(int ), 0, this, n);
        }

        @Override
        public void setColorFilter(ColorFilter colorFilter) {
            InvokeDynamicSupport.bootstrap("setColorFilter", $$robo$$com_android_internal_widget_ActionBarContainer_ActionBarBackgroundDrawable$setColorFilter(android.graphics.ColorFilter ), 0, this, colorFilter);
        }

        @Override
        public int getOpacity() {
            return (int)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$com_android_internal_widget_ActionBarContainer_ActionBarBackgroundDrawable$getOpacity(), 0, this);
        }

        private /* synthetic */ void __constructor__(ActionBarContainer actionBarContainer, 1 var2_2) {
            this.$$robo$$com_android_internal_widget_ActionBarContainer_ActionBarBackgroundDrawable$__constructor__(actionBarContainer, var2_2);
        }

        public /* synthetic */ ActionBarBackgroundDrawable() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActionBarBackgroundDrawable)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

