/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.util.Pools;
import com.android.internal.widget.OpReorderer;
import com.android.internal.widget.RecyclerView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AdapterHelper
implements OpReorderer.Callback,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static int POSITION_TYPE_INVISIBLE = 0;
    static int POSITION_TYPE_NEW_OR_LAID_OUT = 1;
    private static boolean DEBUG = false;
    private static String TAG = "AHT";
    private Pools.Pool<UpdateOp> mUpdateOpPool;
    ArrayList<UpdateOp> mPendingUpdates;
    ArrayList<UpdateOp> mPostponedList;
    Callback mCallback;
    Runnable mOnItemProcessedCallback;
    boolean mDisableRecycler;
    OpReorderer mOpReorderer;
    private int mExistingUpdateTypes;

    private void $$robo$$com_android_internal_widget_AdapterHelper$__constructor__(Callback callback) {
    }

    private void $$robo$$com_android_internal_widget_AdapterHelper$__constructor__(Callback callback, boolean disableRecycler) {
        this.mUpdateOpPool = new Pools.SimplePool<UpdateOp>(30);
        this.mPendingUpdates = new ArrayList();
        this.mPostponedList = new ArrayList();
        this.mExistingUpdateTypes = 0;
        this.mCallback = callback;
        this.mDisableRecycler = disableRecycler;
        this.mOpReorderer = new OpReorderer(this);
    }

    private final AdapterHelper $$robo$$com_android_internal_widget_AdapterHelper$addUpdateOp(UpdateOp ... ops) {
        Collections.addAll(this.mPendingUpdates, ops);
        return this;
    }

    private final void $$robo$$com_android_internal_widget_AdapterHelper$reset() {
        this.recycleUpdateOpsAndClearList(this.mPendingUpdates);
        this.recycleUpdateOpsAndClearList(this.mPostponedList);
        this.mExistingUpdateTypes = 0;
    }

    private final void $$robo$$com_android_internal_widget_AdapterHelper$preProcess() {
        this.mOpReorderer.reorderOps(this.mPendingUpdates);
        int count = this.mPendingUpdates.size();
        for (int i = 0; i < count; ++i) {
            UpdateOp op = this.mPendingUpdates.get(i);
            switch (op.cmd) {
                case 1: {
                    this.applyAdd(op);
                    break;
                }
                case 2: {
                    this.applyRemove(op);
                    break;
                }
                case 4: {
                    this.applyUpdate(op);
                    break;
                }
                case 8: {
                    this.applyMove(op);
                }
            }
            if (this.mOnItemProcessedCallback == null) continue;
            this.mOnItemProcessedCallback.run();
        }
        this.mPendingUpdates.clear();
    }

    private final void $$robo$$com_android_internal_widget_AdapterHelper$consumePostponedUpdates() {
        int count = this.mPostponedList.size();
        for (int i = 0; i < count; ++i) {
            this.mCallback.onDispatchSecondPass(this.mPostponedList.get(i));
        }
        this.recycleUpdateOpsAndClearList(this.mPostponedList);
        this.mExistingUpdateTypes = 0;
    }

    private final void $$robo$$com_android_internal_widget_AdapterHelper$applyMove(UpdateOp op) {
        this.postponeAndUpdateViewHolders(op);
    }

    private final void $$robo$$com_android_internal_widget_AdapterHelper$applyRemove(UpdateOp op) {
        int tmpStart = op.positionStart;
        int tmpCount = 0;
        int tmpEnd = op.positionStart + op.itemCount;
        int type = -1;
        for (int position = op.positionStart; position < tmpEnd; ++position) {
            UpdateOp newOp;
            boolean typeChanged = false;
            RecyclerView.ViewHolder vh = this.mCallback.findViewHolder(position);
            if (vh != null || this.canFindInPreLayout(position)) {
                if (type == 0) {
                    newOp = this.obtainUpdateOp(2, tmpStart, tmpCount, null);
                    this.dispatchAndUpdateViewHolders(newOp);
                    typeChanged = true;
                }
                type = 1;
            } else {
                if (type == 1) {
                    newOp = this.obtainUpdateOp(2, tmpStart, tmpCount, null);
                    this.postponeAndUpdateViewHolders(newOp);
                    typeChanged = true;
                }
                type = 0;
            }
            if (typeChanged) {
                position -= tmpCount;
                tmpEnd -= tmpCount;
                tmpCount = 1;
                continue;
            }
            ++tmpCount;
        }
        if (tmpCount != op.itemCount) {
            this.recycleUpdateOp(op);
            op = this.obtainUpdateOp(2, tmpStart, tmpCount, null);
        }
        if (type == 0) {
            this.dispatchAndUpdateViewHolders(op);
        } else {
            this.postponeAndUpdateViewHolders(op);
        }
    }

    private final void $$robo$$com_android_internal_widget_AdapterHelper$applyUpdate(UpdateOp op) {
        int tmpStart = op.positionStart;
        int tmpCount = 0;
        int tmpEnd = op.positionStart + op.itemCount;
        int type = -1;
        for (int position = op.positionStart; position < tmpEnd; ++position) {
            UpdateOp newOp;
            RecyclerView.ViewHolder vh = this.mCallback.findViewHolder(position);
            if (vh != null || this.canFindInPreLayout(position)) {
                if (type == 0) {
                    newOp = this.obtainUpdateOp(4, tmpStart, tmpCount, op.payload);
                    this.dispatchAndUpdateViewHolders(newOp);
                    tmpCount = 0;
                    tmpStart = position;
                }
                type = 1;
            } else {
                if (type == 1) {
                    newOp = this.obtainUpdateOp(4, tmpStart, tmpCount, op.payload);
                    this.postponeAndUpdateViewHolders(newOp);
                    tmpCount = 0;
                    tmpStart = position;
                }
                type = 0;
            }
            ++tmpCount;
        }
        if (tmpCount != op.itemCount) {
            Object payload = op.payload;
            this.recycleUpdateOp(op);
            op = this.obtainUpdateOp(4, tmpStart, tmpCount, payload);
        }
        if (type == 0) {
            this.dispatchAndUpdateViewHolders(op);
        } else {
            this.postponeAndUpdateViewHolders(op);
        }
    }

    private final void $$robo$$com_android_internal_widget_AdapterHelper$dispatchAndUpdateViewHolders(UpdateOp op) {
        int positionMultiplier;
        if (op.cmd == 1 || op.cmd == 8) {
            throw new IllegalArgumentException("should not dispatch add or move for pre layout");
        }
        int tmpStart = this.updatePositionWithPostponed(op.positionStart, op.cmd);
        int tmpCnt = 1;
        int offsetPositionForPartial = op.positionStart;
        switch (op.cmd) {
            case 4: {
                positionMultiplier = 1;
                break;
            }
            case 2: {
                positionMultiplier = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("op should be remove or update." + op);
            }
        }
        for (int p = 1; p < op.itemCount; ++p) {
            int pos = op.positionStart + positionMultiplier * p;
            int updatedPos = this.updatePositionWithPostponed(pos, op.cmd);
            boolean continuous = false;
            switch (op.cmd) {
                case 4: {
                    continuous = updatedPos == tmpStart + 1;
                    break;
                }
                case 2: {
                    boolean bl = continuous = updatedPos == tmpStart;
                }
            }
            if (continuous) {
                ++tmpCnt;
                continue;
            }
            UpdateOp tmp = this.obtainUpdateOp(op.cmd, tmpStart, tmpCnt, op.payload);
            this.dispatchFirstPassAndUpdateViewHolders(tmp, offsetPositionForPartial);
            this.recycleUpdateOp(tmp);
            if (op.cmd == 4) {
                offsetPositionForPartial += tmpCnt;
            }
            tmpStart = updatedPos;
            tmpCnt = 1;
        }
        Object payload = op.payload;
        this.recycleUpdateOp(op);
        if (tmpCnt > 0) {
            UpdateOp tmp = this.obtainUpdateOp(op.cmd, tmpStart, tmpCnt, payload);
            this.dispatchFirstPassAndUpdateViewHolders(tmp, offsetPositionForPartial);
            this.recycleUpdateOp(tmp);
        }
    }

    private final void $$robo$$com_android_internal_widget_AdapterHelper$dispatchFirstPassAndUpdateViewHolders(UpdateOp op, int offsetStart) {
        this.mCallback.onDispatchFirstPass(op);
        switch (op.cmd) {
            case 2: {
                this.mCallback.offsetPositionsForRemovingInvisible(offsetStart, op.itemCount);
                break;
            }
            case 4: {
                this.mCallback.markViewHoldersUpdated(offsetStart, op.itemCount, op.payload);
                break;
            }
            default: {
                throw new IllegalArgumentException("only remove and update ops can be dispatched in first pass");
            }
        }
    }

    private final int $$robo$$com_android_internal_widget_AdapterHelper$updatePositionWithPostponed(int pos, int cmd) {
        int i;
        int count = this.mPostponedList.size();
        for (i = count - 1; i >= 0; --i) {
            UpdateOp postponed = this.mPostponedList.get(i);
            if (postponed.cmd == 8) {
                int end;
                int start;
                if (postponed.positionStart < postponed.itemCount) {
                    start = postponed.positionStart;
                    end = postponed.itemCount;
                } else {
                    start = postponed.itemCount;
                    end = postponed.positionStart;
                }
                if (pos >= start && pos <= end) {
                    if (start == postponed.positionStart) {
                        if (cmd == 1) {
                            ++postponed.itemCount;
                        } else if (cmd == 2) {
                            --postponed.itemCount;
                        }
                        ++pos;
                        continue;
                    }
                    if (cmd == 1) {
                        ++postponed.positionStart;
                    } else if (cmd == 2) {
                        --postponed.positionStart;
                    }
                    --pos;
                    continue;
                }
                if (pos >= postponed.positionStart) continue;
                if (cmd == 1) {
                    ++postponed.positionStart;
                    ++postponed.itemCount;
                    continue;
                }
                if (cmd != 2) continue;
                --postponed.positionStart;
                --postponed.itemCount;
                continue;
            }
            if (postponed.positionStart <= pos) {
                if (postponed.cmd == 1) {
                    pos -= postponed.itemCount;
                    continue;
                }
                if (postponed.cmd != 2) continue;
                pos += postponed.itemCount;
                continue;
            }
            if (cmd == 1) {
                ++postponed.positionStart;
                continue;
            }
            if (cmd != 2) continue;
            --postponed.positionStart;
        }
        for (i = this.mPostponedList.size() - 1; i >= 0; --i) {
            UpdateOp op = this.mPostponedList.get(i);
            if (op.cmd == 8) {
                if (op.itemCount != op.positionStart && op.itemCount >= 0) continue;
                this.mPostponedList.remove(i);
                this.recycleUpdateOp(op);
                continue;
            }
            if (op.itemCount > 0) continue;
            this.mPostponedList.remove(i);
            this.recycleUpdateOp(op);
        }
        return pos;
    }

    private final boolean $$robo$$com_android_internal_widget_AdapterHelper$canFindInPreLayout(int position) {
        int count = this.mPostponedList.size();
        for (int i = 0; i < count; ++i) {
            UpdateOp op = this.mPostponedList.get(i);
            if (op.cmd == 8) {
                if (this.findPositionOffset(op.itemCount, i + 1) != position) continue;
                return true;
            }
            if (op.cmd != 1) continue;
            int end = op.positionStart + op.itemCount;
            for (int pos = op.positionStart; pos < end; ++pos) {
                if (this.findPositionOffset(pos, i + 1) != position) continue;
                return true;
            }
        }
        return false;
    }

    private final void $$robo$$com_android_internal_widget_AdapterHelper$applyAdd(UpdateOp op) {
        this.postponeAndUpdateViewHolders(op);
    }

    private final void $$robo$$com_android_internal_widget_AdapterHelper$postponeAndUpdateViewHolders(UpdateOp op) {
        this.mPostponedList.add(op);
        switch (op.cmd) {
            case 1: {
                this.mCallback.offsetPositionsForAdd(op.positionStart, op.itemCount);
                break;
            }
            case 8: {
                this.mCallback.offsetPositionsForMove(op.positionStart, op.itemCount);
                break;
            }
            case 2: {
                this.mCallback.offsetPositionsForRemovingLaidOutOrNewView(op.positionStart, op.itemCount);
                break;
            }
            case 4: {
                this.mCallback.markViewHoldersUpdated(op.positionStart, op.itemCount, op.payload);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown update op type for " + op);
            }
        }
    }

    private final boolean $$robo$$com_android_internal_widget_AdapterHelper$hasPendingUpdates() {
        return this.mPendingUpdates.size() > 0;
    }

    private final boolean $$robo$$com_android_internal_widget_AdapterHelper$hasAnyUpdateTypes(int updateTypes) {
        return (this.mExistingUpdateTypes & updateTypes) != 0;
    }

    private final int $$robo$$com_android_internal_widget_AdapterHelper$findPositionOffset(int position) {
        return this.findPositionOffset(position, 0);
    }

    private final int $$robo$$com_android_internal_widget_AdapterHelper$findPositionOffset(int position, int firstPostponedItem) {
        int count = this.mPostponedList.size();
        for (int i = firstPostponedItem; i < count; ++i) {
            UpdateOp op = this.mPostponedList.get(i);
            if (op.cmd == 8) {
                if (op.positionStart == position) {
                    position = op.itemCount;
                    continue;
                }
                if (op.positionStart < position) {
                    --position;
                }
                if (op.itemCount > position) continue;
                ++position;
                continue;
            }
            if (op.positionStart > position) continue;
            if (op.cmd == 2) {
                if (position < op.positionStart + op.itemCount) {
                    return -1;
                }
                position -= op.itemCount;
                continue;
            }
            if (op.cmd != 1) continue;
            position += op.itemCount;
        }
        return position;
    }

    private final boolean $$robo$$com_android_internal_widget_AdapterHelper$onItemRangeChanged(int positionStart, int itemCount, Object payload) {
        if (itemCount < 1) {
            return false;
        }
        this.mPendingUpdates.add(this.obtainUpdateOp(4, positionStart, itemCount, payload));
        this.mExistingUpdateTypes |= 4;
        return this.mPendingUpdates.size() == 1;
    }

    private final boolean $$robo$$com_android_internal_widget_AdapterHelper$onItemRangeInserted(int positionStart, int itemCount) {
        if (itemCount < 1) {
            return false;
        }
        this.mPendingUpdates.add(this.obtainUpdateOp(1, positionStart, itemCount, null));
        this.mExistingUpdateTypes |= 1;
        return this.mPendingUpdates.size() == 1;
    }

    private final boolean $$robo$$com_android_internal_widget_AdapterHelper$onItemRangeRemoved(int positionStart, int itemCount) {
        if (itemCount < 1) {
            return false;
        }
        this.mPendingUpdates.add(this.obtainUpdateOp(2, positionStart, itemCount, null));
        this.mExistingUpdateTypes |= 2;
        return this.mPendingUpdates.size() == 1;
    }

    private final boolean $$robo$$com_android_internal_widget_AdapterHelper$onItemRangeMoved(int from, int to, int itemCount) {
        if (from == to) {
            return false;
        }
        if (itemCount != 1) {
            throw new IllegalArgumentException("Moving more than 1 item is not supported yet");
        }
        this.mPendingUpdates.add(this.obtainUpdateOp(8, from, to, null));
        this.mExistingUpdateTypes |= 8;
        return this.mPendingUpdates.size() == 1;
    }

    private final void $$robo$$com_android_internal_widget_AdapterHelper$consumeUpdatesInOnePass() {
        this.consumePostponedUpdates();
        int count = this.mPendingUpdates.size();
        for (int i = 0; i < count; ++i) {
            UpdateOp op = this.mPendingUpdates.get(i);
            switch (op.cmd) {
                case 1: {
                    this.mCallback.onDispatchSecondPass(op);
                    this.mCallback.offsetPositionsForAdd(op.positionStart, op.itemCount);
                    break;
                }
                case 2: {
                    this.mCallback.onDispatchSecondPass(op);
                    this.mCallback.offsetPositionsForRemovingInvisible(op.positionStart, op.itemCount);
                    break;
                }
                case 4: {
                    this.mCallback.onDispatchSecondPass(op);
                    this.mCallback.markViewHoldersUpdated(op.positionStart, op.itemCount, op.payload);
                    break;
                }
                case 8: {
                    this.mCallback.onDispatchSecondPass(op);
                    this.mCallback.offsetPositionsForMove(op.positionStart, op.itemCount);
                }
            }
            if (this.mOnItemProcessedCallback == null) continue;
            this.mOnItemProcessedCallback.run();
        }
        this.recycleUpdateOpsAndClearList(this.mPendingUpdates);
        this.mExistingUpdateTypes = 0;
    }

    private final int $$robo$$com_android_internal_widget_AdapterHelper$applyPendingUpdatesToPosition(int position) {
        int size = this.mPendingUpdates.size();
        block5: for (int i = 0; i < size; ++i) {
            UpdateOp op = this.mPendingUpdates.get(i);
            switch (op.cmd) {
                case 1: {
                    if (op.positionStart > position) continue block5;
                    position += op.itemCount;
                    continue block5;
                }
                case 2: {
                    if (op.positionStart > position) continue block5;
                    int end = op.positionStart + op.itemCount;
                    if (end > position) {
                        return -1;
                    }
                    position -= op.itemCount;
                    continue block5;
                }
                case 8: {
                    if (op.positionStart == position) {
                        position = op.itemCount;
                        continue block5;
                    }
                    if (op.positionStart < position) {
                        --position;
                    }
                    if (op.itemCount > position) continue block5;
                    ++position;
                }
            }
        }
        return position;
    }

    private final boolean $$robo$$com_android_internal_widget_AdapterHelper$hasUpdates() {
        return !this.mPostponedList.isEmpty() && !this.mPendingUpdates.isEmpty();
    }

    private final UpdateOp $$robo$$com_android_internal_widget_AdapterHelper$obtainUpdateOp(int cmd, int positionStart, int itemCount, Object payload) {
        UpdateOp op = this.mUpdateOpPool.acquire();
        if (op == null) {
            op = new UpdateOp(cmd, positionStart, itemCount, payload);
        } else {
            op.cmd = cmd;
            op.positionStart = positionStart;
            op.itemCount = itemCount;
            op.payload = payload;
        }
        return op;
    }

    private final void $$robo$$com_android_internal_widget_AdapterHelper$recycleUpdateOp(UpdateOp op) {
        if (!this.mDisableRecycler) {
            op.payload = null;
            this.mUpdateOpPool.release(op);
        }
    }

    private final void $$robo$$com_android_internal_widget_AdapterHelper$recycleUpdateOpsAndClearList(List<UpdateOp> ops) {
        int count = ops.size();
        for (int i = 0; i < count; ++i) {
            this.recycleUpdateOp(ops.get(i));
        }
        ops.clear();
    }

    private void __constructor__(Callback callback) {
        this.$$robo$$com_android_internal_widget_AdapterHelper$__constructor__(callback);
    }

    AdapterHelper(Callback callback) {
        this(callback, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_AdapterHelper$__constructor__(com.android.internal.widget.AdapterHelper$Callback ), 0, this, callback);
    }

    private void __constructor__(Callback callback, boolean bl) {
        this.$$robo$$com_android_internal_widget_AdapterHelper$__constructor__(callback, bl);
    }

    AdapterHelper(Callback callback, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_AdapterHelper$__constructor__(com.android.internal.widget.AdapterHelper$Callback boolean ), 0, this, callback, bl);
    }

    AdapterHelper addUpdateOp(UpdateOp ... updateOpArray) {
        return InvokeDynamicSupport.bootstrap("addUpdateOp", $$robo$$com_android_internal_widget_AdapterHelper$addUpdateOp(com.android.internal.widget.AdapterHelper$UpdateOp[] ), 0, this, updateOpArray);
    }

    void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_widget_AdapterHelper$reset(), 0, this);
    }

    void preProcess() {
        InvokeDynamicSupport.bootstrap("preProcess", $$robo$$com_android_internal_widget_AdapterHelper$preProcess(), 0, this);
    }

    void consumePostponedUpdates() {
        InvokeDynamicSupport.bootstrap("consumePostponedUpdates", $$robo$$com_android_internal_widget_AdapterHelper$consumePostponedUpdates(), 0, this);
    }

    private void applyMove(UpdateOp updateOp) {
        InvokeDynamicSupport.bootstrap("applyMove", $$robo$$com_android_internal_widget_AdapterHelper$applyMove(com.android.internal.widget.AdapterHelper$UpdateOp ), 0, this, updateOp);
    }

    private void applyRemove(UpdateOp updateOp) {
        InvokeDynamicSupport.bootstrap("applyRemove", $$robo$$com_android_internal_widget_AdapterHelper$applyRemove(com.android.internal.widget.AdapterHelper$UpdateOp ), 0, this, updateOp);
    }

    private void applyUpdate(UpdateOp updateOp) {
        InvokeDynamicSupport.bootstrap("applyUpdate", $$robo$$com_android_internal_widget_AdapterHelper$applyUpdate(com.android.internal.widget.AdapterHelper$UpdateOp ), 0, this, updateOp);
    }

    private void dispatchAndUpdateViewHolders(UpdateOp updateOp) {
        InvokeDynamicSupport.bootstrap("dispatchAndUpdateViewHolders", $$robo$$com_android_internal_widget_AdapterHelper$dispatchAndUpdateViewHolders(com.android.internal.widget.AdapterHelper$UpdateOp ), 0, this, updateOp);
    }

    void dispatchFirstPassAndUpdateViewHolders(UpdateOp updateOp, int n) {
        InvokeDynamicSupport.bootstrap("dispatchFirstPassAndUpdateViewHolders", $$robo$$com_android_internal_widget_AdapterHelper$dispatchFirstPassAndUpdateViewHolders(com.android.internal.widget.AdapterHelper$UpdateOp int ), 0, this, updateOp, n);
    }

    private int updatePositionWithPostponed(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("updatePositionWithPostponed", $$robo$$com_android_internal_widget_AdapterHelper$updatePositionWithPostponed(int int ), 0, this, n, n2);
    }

    private boolean canFindInPreLayout(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("canFindInPreLayout", $$robo$$com_android_internal_widget_AdapterHelper$canFindInPreLayout(int ), 0, this, n);
    }

    private void applyAdd(UpdateOp updateOp) {
        InvokeDynamicSupport.bootstrap("applyAdd", $$robo$$com_android_internal_widget_AdapterHelper$applyAdd(com.android.internal.widget.AdapterHelper$UpdateOp ), 0, this, updateOp);
    }

    private void postponeAndUpdateViewHolders(UpdateOp updateOp) {
        InvokeDynamicSupport.bootstrap("postponeAndUpdateViewHolders", $$robo$$com_android_internal_widget_AdapterHelper$postponeAndUpdateViewHolders(com.android.internal.widget.AdapterHelper$UpdateOp ), 0, this, updateOp);
    }

    boolean hasPendingUpdates() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasPendingUpdates", $$robo$$com_android_internal_widget_AdapterHelper$hasPendingUpdates(), 0, this);
    }

    boolean hasAnyUpdateTypes(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasAnyUpdateTypes", $$robo$$com_android_internal_widget_AdapterHelper$hasAnyUpdateTypes(int ), 0, this, n);
    }

    int findPositionOffset(int n) {
        return (int)InvokeDynamicSupport.bootstrap("findPositionOffset", $$robo$$com_android_internal_widget_AdapterHelper$findPositionOffset(int ), 0, this, n);
    }

    int findPositionOffset(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("findPositionOffset", $$robo$$com_android_internal_widget_AdapterHelper$findPositionOffset(int int ), 0, this, n, n2);
    }

    boolean onItemRangeChanged(int n, int n2, Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("onItemRangeChanged", $$robo$$com_android_internal_widget_AdapterHelper$onItemRangeChanged(int int java.lang.Object ), 0, this, n, n2, object);
    }

    boolean onItemRangeInserted(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("onItemRangeInserted", $$robo$$com_android_internal_widget_AdapterHelper$onItemRangeInserted(int int ), 0, this, n, n2);
    }

    boolean onItemRangeRemoved(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("onItemRangeRemoved", $$robo$$com_android_internal_widget_AdapterHelper$onItemRangeRemoved(int int ), 0, this, n, n2);
    }

    boolean onItemRangeMoved(int n, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrap("onItemRangeMoved", $$robo$$com_android_internal_widget_AdapterHelper$onItemRangeMoved(int int int ), 0, this, n, n2, n3);
    }

    void consumeUpdatesInOnePass() {
        InvokeDynamicSupport.bootstrap("consumeUpdatesInOnePass", $$robo$$com_android_internal_widget_AdapterHelper$consumeUpdatesInOnePass(), 0, this);
    }

    public int applyPendingUpdatesToPosition(int n) {
        return (int)InvokeDynamicSupport.bootstrap("applyPendingUpdatesToPosition", $$robo$$com_android_internal_widget_AdapterHelper$applyPendingUpdatesToPosition(int ), 0, this, n);
    }

    boolean hasUpdates() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasUpdates", $$robo$$com_android_internal_widget_AdapterHelper$hasUpdates(), 0, this);
    }

    @Override
    public UpdateOp obtainUpdateOp(int n, int n2, int n3, Object object) {
        return InvokeDynamicSupport.bootstrap("obtainUpdateOp", $$robo$$com_android_internal_widget_AdapterHelper$obtainUpdateOp(int int int java.lang.Object ), 0, this, n, n2, n3, object);
    }

    @Override
    public void recycleUpdateOp(UpdateOp updateOp) {
        InvokeDynamicSupport.bootstrap("recycleUpdateOp", $$robo$$com_android_internal_widget_AdapterHelper$recycleUpdateOp(com.android.internal.widget.AdapterHelper$UpdateOp ), 0, this, updateOp);
    }

    void recycleUpdateOpsAndClearList(List<UpdateOp> list) {
        InvokeDynamicSupport.bootstrap("recycleUpdateOpsAndClearList", $$robo$$com_android_internal_widget_AdapterHelper$recycleUpdateOpsAndClearList(java.util.List<com.android.internal.widget.AdapterHelper$UpdateOp> ), 0, this, list);
    }

    public /* synthetic */ AdapterHelper() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AdapterHelper)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    static interface Callback
    extends InstrumentedInterface {
        public RecyclerView.ViewHolder findViewHolder(int var1);

        public void offsetPositionsForRemovingInvisible(int var1, int var2);

        public void offsetPositionsForRemovingLaidOutOrNewView(int var1, int var2);

        public void markViewHoldersUpdated(int var1, int var2, Object var3);

        public void onDispatchFirstPass(UpdateOp var1);

        public void onDispatchSecondPass(UpdateOp var1);

        public void offsetPositionsForAdd(int var1, int var2);

        public void offsetPositionsForMove(int var1, int var2);
    }

    public static class UpdateOp
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static int ADD = 1;
        static int REMOVE = 2;
        static int UPDATE = 4;
        static int MOVE = 8;
        static int POOL_SIZE = 30;
        int cmd;
        int positionStart;
        Object payload;
        int itemCount;

        private void $$robo$$com_android_internal_widget_AdapterHelper_UpdateOp$__constructor__(int cmd, int positionStart, int itemCount, Object payload) {
            this.cmd = cmd;
            this.positionStart = positionStart;
            this.itemCount = itemCount;
            this.payload = payload;
        }

        private final String $$robo$$com_android_internal_widget_AdapterHelper_UpdateOp$cmdToString() {
            switch (this.cmd) {
                case 1: {
                    return "add";
                }
                case 2: {
                    return "rm";
                }
                case 4: {
                    return "up";
                }
                case 8: {
                    return "mv";
                }
            }
            return "??";
        }

        private final String $$robo$$com_android_internal_widget_AdapterHelper_UpdateOp$toString() {
            return Integer.toHexString(System.identityHashCode(this)) + "[" + this.cmdToString() + ",s:" + this.positionStart + "c:" + this.itemCount + ",p:" + this.payload + "]";
        }

        private final boolean $$robo$$com_android_internal_widget_AdapterHelper_UpdateOp$equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UpdateOp op = (UpdateOp)o;
            if (this.cmd != op.cmd) {
                return false;
            }
            if (this.cmd == 8 && Math.abs(this.itemCount - this.positionStart) == 1 && this.itemCount == op.positionStart && this.positionStart == op.itemCount) {
                return true;
            }
            if (this.itemCount != op.itemCount) {
                return false;
            }
            if (this.positionStart != op.positionStart) {
                return false;
            }
            return !(this.payload != null ? !this.payload.equals(op.payload) : op.payload != null);
        }

        private final int $$robo$$com_android_internal_widget_AdapterHelper_UpdateOp$hashCode() {
            int result = this.cmd;
            result = 31 * result + this.positionStart;
            result = 31 * result + this.itemCount;
            return result;
        }

        private void __constructor__(int n, int n2, int n3, Object object) {
            this.$$robo$$com_android_internal_widget_AdapterHelper_UpdateOp$__constructor__(n, n2, n3, object);
        }

        UpdateOp(int n, int n2, int n3, Object object) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_AdapterHelper_UpdateOp$__constructor__(int int int java.lang.Object ), 0, this, n, n2, n3, object);
        }

        String cmdToString() {
            return InvokeDynamicSupport.bootstrap("cmdToString", $$robo$$com_android_internal_widget_AdapterHelper_UpdateOp$cmdToString(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_widget_AdapterHelper_UpdateOp$toString(), 0, this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$com_android_internal_widget_AdapterHelper_UpdateOp$equals(java.lang.Object ), 0, this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$com_android_internal_widget_AdapterHelper_UpdateOp$hashCode(), 0, this);
        }

        public /* synthetic */ UpdateOp() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UpdateOp)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

