/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RemoteViews;
import com.android.internal.R;
import com.android.internal.widget.MessagingLayout;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@RemoteViews.RemoteView
public class MessagingLinearLayout
extends ViewGroup
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private int mSpacing;
    private int mMaxDisplayedLines;
    private MessagingLayout mMessagingLayout;

    private void $$robo$$com_android_internal_widget_MessagingLinearLayout$__constructor__(Context context, AttributeSet attrs) {
        this.mMaxDisplayedLines = Integer.MAX_VALUE;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MessagingLinearLayout, 0, 0);
        int N = a.getIndexCount();
        for (int i = 0; i < N; ++i) {
            int attr2 = a.getIndex(i);
            switch (attr2) {
                case 0: {
                    this.mSpacing = a.getDimensionPixelSize(i, 0);
                }
            }
        }
        a.recycle();
    }

    private final void $$robo$$com_android_internal_widget_MessagingLinearLayout$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int targetHeight = View.MeasureSpec.getSize(heightMeasureSpec);
        switch (View.MeasureSpec.getMode(heightMeasureSpec)) {
            case 0: {
                targetHeight = Integer.MAX_VALUE;
            }
        }
        int measuredWidth = this.mPaddingLeft + this.mPaddingRight;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            lp.hide = true;
        }
        int totalHeight = this.mPaddingTop + this.mPaddingBottom;
        boolean first = true;
        int linesRemaining = this.mMaxDisplayedLines;
        for (int i = count - 1; i >= 0 && totalHeight < targetHeight; --i) {
            boolean isTooSmall;
            if (this.getChildAt(i).getVisibility() == 8) continue;
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)this.getChildAt(i).getLayoutParams();
            MessagingChild messagingChild = null;
            int spacing = this.mSpacing;
            if (child instanceof MessagingChild) {
                messagingChild = (MessagingChild)((Object)child);
                messagingChild.setMaxDisplayedLines(linesRemaining);
                spacing += messagingChild.getExtraSpacing();
            }
            spacing = first ? 0 : spacing;
            this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, totalHeight - this.mPaddingTop - this.mPaddingBottom + spacing);
            int childHeight = child.getMeasuredHeight();
            int newHeight = Math.max(totalHeight, totalHeight + childHeight + lp.topMargin + lp.bottomMargin + spacing);
            first = false;
            int measureType = 0;
            if (messagingChild != null) {
                measureType = messagingChild.getMeasuredType();
                linesRemaining -= messagingChild.getConsumedLines();
            }
            boolean isShortened = measureType == 1;
            boolean bl = isTooSmall = measureType == 2;
            if (newHeight > targetHeight || isTooSmall) break;
            totalHeight = newHeight;
            measuredWidth = Math.max(measuredWidth, child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin + this.mPaddingLeft + this.mPaddingRight);
            lp.hide = false;
            if (isShortened || linesRemaining <= 0) break;
        }
        this.setMeasuredDimension(MessagingLinearLayout.resolveSize(Math.max(this.getSuggestedMinimumWidth(), measuredWidth), widthMeasureSpec), Math.max(this.getSuggestedMinimumHeight(), totalHeight));
    }

    private final void $$robo$$com_android_internal_widget_MessagingLinearLayout$onLayout(boolean changed, int left, int top, int right, int bottom) {
        int paddingLeft = this.mPaddingLeft;
        int width = right - left;
        int childRight = width - this.mPaddingRight;
        int layoutDirection = this.getLayoutDirection();
        int count = this.getChildCount();
        int childTop = this.mPaddingTop;
        boolean first = true;
        boolean shown = this.isShown();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            MessagingChild messagingChild = (MessagingChild)((Object)child);
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            int childLeft = layoutDirection == 1 ? childRight - childWidth - lp.rightMargin : paddingLeft + lp.leftMargin;
            if (lp.hide) {
                if (shown && lp.visibleBefore) {
                    child.layout(childLeft, childTop, childLeft + childWidth, childTop + lp.lastVisibleHeight);
                    messagingChild.hideAnimated();
                }
                lp.visibleBefore = false;
                continue;
            }
            lp.visibleBefore = true;
            lp.lastVisibleHeight = childHeight;
            if (!first) {
                childTop += this.mSpacing;
            }
            child.layout(childLeft, childTop += lp.topMargin, childLeft + childWidth, childTop + childHeight);
            childTop += childHeight + lp.bottomMargin;
            first = false;
        }
    }

    private final boolean $$robo$$com_android_internal_widget_MessagingLinearLayout$drawChild(Canvas canvas, View child, long drawingTime) {
        MessagingChild messagingChild;
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        if (lp.hide && !(messagingChild = (MessagingChild)((Object)child)).isHidingAnimated()) {
            return true;
        }
        return super.drawChild(canvas, child, drawingTime);
    }

    private final LayoutParams $$robo$$com_android_internal_widget_MessagingLinearLayout$generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.mContext, attrs);
    }

    private final LayoutParams $$robo$$com_android_internal_widget_MessagingLinearLayout$generateDefaultLayoutParams() {
        return new LayoutParams(-1, -2);
    }

    private final LayoutParams $$robo$$com_android_internal_widget_MessagingLinearLayout$generateLayoutParams(ViewGroup.LayoutParams lp) {
        LayoutParams copy = new LayoutParams(lp.width, lp.height);
        if (lp instanceof ViewGroup.MarginLayoutParams) {
            copy.copyMarginsFrom((ViewGroup.MarginLayoutParams)lp);
        }
        return copy;
    }

    private static final boolean $$robo$$com_android_internal_widget_MessagingLinearLayout$isGone(View view) {
        if (view.getVisibility() == 8) {
            return true;
        }
        ViewGroup.LayoutParams lp = view.getLayoutParams();
        return lp instanceof LayoutParams && ((LayoutParams)lp).hide;
    }

    @RemotableViewMethod
    private final void $$robo$$com_android_internal_widget_MessagingLinearLayout$setMaxDisplayedLines(int numberLines) {
        this.mMaxDisplayedLines = numberLines;
    }

    private final void $$robo$$com_android_internal_widget_MessagingLinearLayout$setMessagingLayout(MessagingLayout layout2) {
        this.mMessagingLayout = layout2;
    }

    private final MessagingLayout $$robo$$com_android_internal_widget_MessagingLinearLayout$getMessagingLayout() {
        return this.mMessagingLayout;
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$com_android_internal_widget_MessagingLinearLayout$__constructor__(context, attributeSet);
    }

    public MessagingLinearLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_MessagingLinearLayout$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$com_android_internal_widget_MessagingLinearLayout$onMeasure(int int ), 0, this, n, n2);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$com_android_internal_widget_MessagingLinearLayout$onLayout(boolean int int int int ), 0, this, bl, n, n2, n3, n4);
    }

    @Override
    protected boolean drawChild(Canvas canvas, View view, long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("drawChild", $$robo$$com_android_internal_widget_MessagingLinearLayout$drawChild(android.graphics.Canvas android.view.View long ), 0, this, canvas, view, l);
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$com_android_internal_widget_MessagingLinearLayout$generateLayoutParams(android.util.AttributeSet ), 0, this, attributeSet);
    }

    @Override
    protected LayoutParams generateDefaultLayoutParams() {
        return InvokeDynamicSupport.bootstrap("generateDefaultLayoutParams", $$robo$$com_android_internal_widget_MessagingLinearLayout$generateDefaultLayoutParams(), 0, this);
    }

    @Override
    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$com_android_internal_widget_MessagingLinearLayout$generateLayoutParams(android.view.ViewGroup$LayoutParams ), 0, this, layoutParams);
    }

    public static boolean isGone(View view) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isGone", $$robo$$com_android_internal_widget_MessagingLinearLayout$isGone(android.view.View ), 0, (View)view);
    }

    @RemotableViewMethod
    public void setMaxDisplayedLines(int n) {
        InvokeDynamicSupport.bootstrap("setMaxDisplayedLines", $$robo$$com_android_internal_widget_MessagingLinearLayout$setMaxDisplayedLines(int ), 0, this, n);
    }

    public void setMessagingLayout(MessagingLayout messagingLayout) {
        InvokeDynamicSupport.bootstrap("setMessagingLayout", $$robo$$com_android_internal_widget_MessagingLinearLayout$setMessagingLayout(com.android.internal.widget.MessagingLayout ), 0, this, messagingLayout);
    }

    public MessagingLayout getMessagingLayout() {
        return InvokeDynamicSupport.bootstrap("getMessagingLayout", $$robo$$com_android_internal_widget_MessagingLinearLayout$getMessagingLayout(), 0, this);
    }

    public /* synthetic */ MessagingLinearLayout() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MessagingLinearLayout)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public boolean hide;
        public boolean visibleBefore;
        public int lastVisibleHeight;

        private void $$robo$$com_android_internal_widget_MessagingLinearLayout_LayoutParams$__constructor__(Context c, AttributeSet attrs) {
            this.hide = false;
            this.visibleBefore = false;
        }

        private void $$robo$$com_android_internal_widget_MessagingLinearLayout_LayoutParams$__constructor__(int width, int height) {
            this.hide = false;
            this.visibleBefore = false;
        }

        private void __constructor__(Context context, AttributeSet attributeSet) {
            this.$$robo$$com_android_internal_widget_MessagingLinearLayout_LayoutParams$__constructor__(context, attributeSet);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_MessagingLinearLayout_LayoutParams$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$com_android_internal_widget_MessagingLinearLayout_LayoutParams$__constructor__(n, n2);
        }

        public LayoutParams(int n, int n2) {
            super(n, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_MessagingLinearLayout_LayoutParams$__constructor__(int int ), 0, this, n, n2);
        }

        public /* synthetic */ LayoutParams() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LayoutParams)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface MessagingChild
    extends InstrumentedInterface {
        public static final int MEASURED_NORMAL = 0;
        public static final int MEASURED_SHORTENED = 1;
        public static final int MEASURED_TOO_SMALL = 2;

        public int getMeasuredType();

        public int getConsumedLines();

        public void setMaxDisplayedLines(int var1);

        public void hideAnimated();

        public boolean isHidingAnimated();

        default public int getExtraSpacing() {
            return 0;
        }
    }
}

