/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.app.ActivityManager;
import android.app.Notification;
import android.view.View;
import com.android.internal.widget.MessagingGroup;
import com.android.internal.widget.MessagingImageMessage;
import com.android.internal.widget.MessagingLayout;
import com.android.internal.widget.MessagingLinearLayout;
import com.android.internal.widget.MessagingMessageState;
import com.android.internal.widget.MessagingTextMessage;
import java.util.Objects;
import org.robolectric.internal.bytecode.InstrumentedInterface;

public interface MessagingMessage
extends MessagingLinearLayout.MessagingChild,
InstrumentedInterface {
    public static final String IMAGE_MIME_TYPE_PREFIX = "image/";

    public static MessagingMessage createMessage(MessagingLayout layout2, Notification.MessagingStyle.Message m) {
        if (MessagingMessage.hasImage(m) && !ActivityManager.isLowRamDeviceStatic()) {
            return MessagingImageMessage.createMessage(layout2, m);
        }
        return MessagingTextMessage.createMessage(layout2, m);
    }

    public static void dropCache() {
        MessagingTextMessage.dropCache();
        MessagingImageMessage.dropCache();
    }

    public static boolean hasImage(Notification.MessagingStyle.Message m) {
        return m.getDataUri() != null && m.getDataMimeType() != null && m.getDataMimeType().startsWith(IMAGE_MIME_TYPE_PREFIX);
    }

    default public boolean setMessage(Notification.MessagingStyle.Message message) {
        this.getState().setMessage(message);
        return true;
    }

    default public Notification.MessagingStyle.Message getMessage() {
        return this.getState().getMessage();
    }

    default public boolean sameAs(Notification.MessagingStyle.Message message) {
        boolean hasRemoteInputHistoryChanged;
        Notification.MessagingStyle.Message ownMessage = this.getMessage();
        if (!Objects.equals(message.getText(), ownMessage.getText())) {
            return false;
        }
        if (!Objects.equals(message.getSender(), ownMessage.getSender())) {
            return false;
        }
        boolean bl = hasRemoteInputHistoryChanged = message.isRemoteInputHistory() != ownMessage.isRemoteInputHistory();
        if (!hasRemoteInputHistoryChanged && !Objects.equals(message.getTimestamp(), ownMessage.getTimestamp())) {
            return false;
        }
        if (!Objects.equals(message.getDataMimeType(), ownMessage.getDataMimeType())) {
            return false;
        }
        return Objects.equals(message.getDataUri(), ownMessage.getDataUri());
    }

    default public boolean sameAs(MessagingMessage message) {
        return this.sameAs(message.getMessage());
    }

    default public void removeMessage() {
        this.getGroup().removeMessage(this);
    }

    default public void setMessagingGroup(MessagingGroup group) {
        this.getState().setGroup(group);
    }

    default public void setIsHistoric(boolean isHistoric) {
        this.getState().setIsHistoric(isHistoric);
    }

    default public MessagingGroup getGroup() {
        return this.getState().getGroup();
    }

    default public void setIsHidingAnimated(boolean isHiding) {
        this.getState().setIsHidingAnimated(isHiding);
    }

    @Override
    default public boolean isHidingAnimated() {
        return this.getState().isHidingAnimated();
    }

    @Override
    default public void hideAnimated() {
        this.setIsHidingAnimated(true);
        this.getGroup().performRemoveAnimation(this.getView(), () -> this.setIsHidingAnimated(false));
    }

    default public boolean hasOverlappingRendering() {
        return false;
    }

    default public void recycle() {
        this.getState().recycle();
    }

    default public View getView() {
        return (View)((Object)this);
    }

    default public void setColor(int textColor) {
    }

    public MessagingMessageState getState();

    public void setVisibility(int var1);

    public int getVisibility();
}

