/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.ActionMenuPresenter;
import android.widget.AdapterView;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.Toolbar;
import com.android.internal.R;
import com.android.internal.view.menu.ActionMenuItem;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuPresenter;
import com.android.internal.widget.DecorToolbar;
import com.android.internal.widget.ScrollingTabContainerView;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ToolbarWidgetWrapper
implements DecorToolbar,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ToolbarWidgetWrapper";
    private static int AFFECTS_LOGO_MASK = 3;
    private static long DEFAULT_FADE_DURATION_MS = 200L;
    private Toolbar mToolbar;
    private int mDisplayOpts;
    private View mTabView;
    private Spinner mSpinner;
    private View mCustomView;
    private Drawable mIcon;
    private Drawable mLogo;
    private Drawable mNavIcon;
    private boolean mTitleSet;
    private CharSequence mTitle;
    private CharSequence mSubtitle;
    private CharSequence mHomeDescription;
    private Window.Callback mWindowCallback;
    private boolean mMenuPrepared;
    private ActionMenuPresenter mActionMenuPresenter;
    private int mNavigationMode;
    private int mDefaultNavigationContentDescription;
    private Drawable mDefaultNavigationIcon;

    private void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$__constructor__(Toolbar toolbar, boolean style2) {
    }

    private void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$__constructor__(Toolbar toolbar, boolean style2, int defaultNavigationContentDescription) {
        this.mNavigationMode = 0;
        this.mDefaultNavigationContentDescription = 0;
        this.mToolbar = toolbar;
        this.mTitle = toolbar.getTitle();
        this.mSubtitle = toolbar.getSubtitle();
        this.mTitleSet = this.mTitle != null;
        this.mNavIcon = this.mToolbar.getNavigationIcon();
        TypedArray a = toolbar.getContext().obtainStyledAttributes(null, R.styleable.ActionBar, 16843470, 0);
        this.mDefaultNavigationIcon = a.getDrawable(13);
        if (style2) {
            int popupTheme;
            int subtitleTextStyle;
            int titleTextStyle;
            int height;
            Drawable icon;
            Drawable logo;
            CharSequence subtitle;
            CharSequence title = a.getText(5);
            if (!TextUtils.isEmpty(title)) {
                this.setTitle(title);
            }
            if (!TextUtils.isEmpty(subtitle = a.getText(9))) {
                this.setSubtitle(subtitle);
            }
            if ((logo = a.getDrawable(6)) != null) {
                this.setLogo(logo);
            }
            if ((icon = a.getDrawable(0)) != null) {
                this.setIcon(icon);
            }
            if (this.mNavIcon == null && this.mDefaultNavigationIcon != null) {
                this.setNavigationIcon(this.mDefaultNavigationIcon);
            }
            this.setDisplayOptions(a.getInt(8, 0));
            int customNavId = a.getResourceId(10, 0);
            if (customNavId != 0) {
                this.setCustomView(LayoutInflater.from(this.mToolbar.getContext()).inflate(customNavId, (ViewGroup)this.mToolbar, false));
                this.setDisplayOptions(this.mDisplayOpts | 0x10);
            }
            if ((height = a.getLayoutDimension(4, 0)) > 0) {
                ViewGroup.LayoutParams lp = this.mToolbar.getLayoutParams();
                lp.height = height;
                this.mToolbar.setLayoutParams(lp);
            }
            int contentInsetStart = a.getDimensionPixelOffset(22, -1);
            int contentInsetEnd = a.getDimensionPixelOffset(23, -1);
            if (contentInsetStart >= 0 || contentInsetEnd >= 0) {
                this.mToolbar.setContentInsetsRelative(Math.max(contentInsetStart, 0), Math.max(contentInsetEnd, 0));
            }
            if ((titleTextStyle = a.getResourceId(11, 0)) != 0) {
                this.mToolbar.setTitleTextAppearance(this.mToolbar.getContext(), titleTextStyle);
            }
            if ((subtitleTextStyle = a.getResourceId(12, 0)) != 0) {
                this.mToolbar.setSubtitleTextAppearance(this.mToolbar.getContext(), subtitleTextStyle);
            }
            if ((popupTheme = a.getResourceId(26, 0)) != 0) {
                this.mToolbar.setPopupTheme(popupTheme);
            }
        } else {
            this.mDisplayOpts = this.detectDisplayOptions();
        }
        a.recycle();
        this.setDefaultNavigationContentDescription(defaultNavigationContentDescription);
        this.mHomeDescription = this.mToolbar.getNavigationContentDescription();
        this.mToolbar.setNavigationOnClickListener(new View.OnClickListener(this){
            public transient /* synthetic */ Object __robo_data__;
            ActionMenuItem mNavItem;
            /* synthetic */ ToolbarWidgetWrapper this$0;

            private void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper_1$__constructor__(ToolbarWidgetWrapper this$0) {
                this.mNavItem = new ActionMenuItem(this.this$0.mToolbar.getContext(), 0, 16908332, 0, 0, this.this$0.mTitle);
            }

            private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper_1$onClick(View v) {
                if (this.this$0.mWindowCallback != null && this.this$0.mMenuPrepared) {
                    this.this$0.mWindowCallback.onMenuItemSelected(0, this.mNavItem);
                }
            }

            private void __constructor__(ToolbarWidgetWrapper toolbarWidgetWrapper) {
                this.$$robo$$com_android_internal_widget_ToolbarWidgetWrapper_1$__constructor__(toolbarWidgetWrapper);
            }
            {
                this.this$0 = toolbarWidgetWrapper;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper_1$__constructor__(com.android.internal.widget.ToolbarWidgetWrapper ), 0, this, toolbarWidgetWrapper);
            }

            @Override
            public void onClick(View view) {
                InvokeDynamicSupport.bootstrap("onClick", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper_1$onClick(android.view.View ), 0, this, view);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setDefaultNavigationContentDescription(int defaultNavigationContentDescription) {
        if (defaultNavigationContentDescription == this.mDefaultNavigationContentDescription) {
            return;
        }
        this.mDefaultNavigationContentDescription = defaultNavigationContentDescription;
        if (TextUtils.isEmpty(this.mToolbar.getNavigationContentDescription())) {
            this.setNavigationContentDescription(this.mDefaultNavigationContentDescription);
        }
    }

    private final int $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$detectDisplayOptions() {
        int opts = 11;
        if (this.mToolbar.getNavigationIcon() != null) {
            opts |= 4;
            this.mDefaultNavigationIcon = this.mToolbar.getNavigationIcon();
        }
        return opts;
    }

    private final ViewGroup $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$getViewGroup() {
        return this.mToolbar;
    }

    private final Context $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$getContext() {
        return this.mToolbar.getContext();
    }

    private final boolean $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$isSplit() {
        return false;
    }

    private final boolean $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$hasExpandedActionView() {
        return this.mToolbar.hasExpandedActionView();
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$collapseActionView() {
        this.mToolbar.collapseActionView();
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setWindowCallback(Window.Callback cb) {
        this.mWindowCallback = cb;
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setWindowTitle(CharSequence title) {
        if (!this.mTitleSet) {
            this.setTitleInt(title);
        }
    }

    private final CharSequence $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$getTitle() {
        return this.mToolbar.getTitle();
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setTitle(CharSequence title) {
        this.mTitleSet = true;
        this.setTitleInt(title);
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setTitleInt(CharSequence title) {
        this.mTitle = title;
        if ((this.mDisplayOpts & 8) != 0) {
            this.mToolbar.setTitle(title);
        }
    }

    private final CharSequence $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$getSubtitle() {
        return this.mToolbar.getSubtitle();
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setSubtitle(CharSequence subtitle) {
        this.mSubtitle = subtitle;
        if ((this.mDisplayOpts & 8) != 0) {
            this.mToolbar.setSubtitle(subtitle);
        }
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$initProgress() {
        Log.i("ToolbarWidgetWrapper", "Progress display unsupported");
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$initIndeterminateProgress() {
        Log.i("ToolbarWidgetWrapper", "Progress display unsupported");
    }

    private final boolean $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$canSplit() {
        return false;
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setSplitView(ViewGroup splitView) {
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setSplitToolbar(boolean split) {
        if (split) {
            throw new UnsupportedOperationException("Cannot split an android.widget.Toolbar");
        }
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setSplitWhenNarrow(boolean splitWhenNarrow) {
    }

    private final boolean $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$hasIcon() {
        return this.mIcon != null;
    }

    private final boolean $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$hasLogo() {
        return this.mLogo != null;
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setIcon(int resId) {
        this.setIcon(resId != 0 ? this.getContext().getDrawable(resId) : null);
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setIcon(Drawable d) {
        this.mIcon = d;
        this.updateToolbarLogo();
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setLogo(int resId) {
        this.setLogo(resId != 0 ? this.getContext().getDrawable(resId) : null);
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setLogo(Drawable d) {
        this.mLogo = d;
        this.updateToolbarLogo();
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$updateToolbarLogo() {
        Drawable logo = null;
        if ((this.mDisplayOpts & 2) != 0) {
            logo = (this.mDisplayOpts & 1) != 0 ? (this.mLogo != null ? this.mLogo : this.mIcon) : this.mIcon;
        }
        this.mToolbar.setLogo(logo);
    }

    private final boolean $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$canShowOverflowMenu() {
        return this.mToolbar.canShowOverflowMenu();
    }

    private final boolean $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$isOverflowMenuShowing() {
        return this.mToolbar.isOverflowMenuShowing();
    }

    private final boolean $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$isOverflowMenuShowPending() {
        return this.mToolbar.isOverflowMenuShowPending();
    }

    private final boolean $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$showOverflowMenu() {
        return this.mToolbar.showOverflowMenu();
    }

    private final boolean $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$hideOverflowMenu() {
        return this.mToolbar.hideOverflowMenu();
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setMenuPrepared() {
        this.mMenuPrepared = true;
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setMenu(Menu menu2, MenuPresenter.Callback cb) {
        if (this.mActionMenuPresenter == null) {
            this.mActionMenuPresenter = new ActionMenuPresenter(this.mToolbar.getContext());
            this.mActionMenuPresenter.setId(16908680);
        }
        this.mActionMenuPresenter.setCallback(cb);
        this.mToolbar.setMenu((MenuBuilder)menu2, this.mActionMenuPresenter);
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$dismissPopupMenus() {
        this.mToolbar.dismissPopupMenus();
    }

    private final int $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$getDisplayOptions() {
        return this.mDisplayOpts;
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setDisplayOptions(int newOpts) {
        int oldOpts = this.mDisplayOpts;
        int changed = oldOpts ^ newOpts;
        this.mDisplayOpts = newOpts;
        if (changed != 0) {
            if ((changed & 4) != 0) {
                if ((newOpts & 4) != 0) {
                    this.updateHomeAccessibility();
                }
                this.updateNavigationIcon();
            }
            if ((changed & 3) != 0) {
                this.updateToolbarLogo();
            }
            if ((changed & 8) != 0) {
                if ((newOpts & 8) != 0) {
                    this.mToolbar.setTitle(this.mTitle);
                    this.mToolbar.setSubtitle(this.mSubtitle);
                } else {
                    this.mToolbar.setTitle(null);
                    this.mToolbar.setSubtitle(null);
                }
            }
            if ((changed & 0x10) != 0 && this.mCustomView != null) {
                if ((newOpts & 0x10) != 0) {
                    this.mToolbar.addView(this.mCustomView);
                } else {
                    this.mToolbar.removeView(this.mCustomView);
                }
            }
        }
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setEmbeddedTabView(ScrollingTabContainerView tabView) {
        if (this.mTabView != null && this.mTabView.getParent() == this.mToolbar) {
            this.mToolbar.removeView(this.mTabView);
        }
        this.mTabView = tabView;
        if (tabView != null && this.mNavigationMode == 2) {
            this.mToolbar.addView(this.mTabView, 0);
            Toolbar.LayoutParams lp = (Toolbar.LayoutParams)this.mTabView.getLayoutParams();
            lp.width = -2;
            lp.height = -2;
            lp.gravity = 8388691;
            tabView.setAllowCollapse(true);
        }
    }

    private final boolean $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$hasEmbeddedTabs() {
        return this.mTabView != null;
    }

    private final boolean $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$isTitleTruncated() {
        return this.mToolbar.isTitleTruncated();
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setCollapsible(boolean collapsible) {
        this.mToolbar.setCollapsible(collapsible);
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setHomeButtonEnabled(boolean enable) {
    }

    private final int $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$getNavigationMode() {
        return this.mNavigationMode;
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setNavigationMode(int mode) {
        int oldMode = this.mNavigationMode;
        if (mode != oldMode) {
            switch (oldMode) {
                case 1: {
                    if (this.mSpinner == null || this.mSpinner.getParent() != this.mToolbar) break;
                    this.mToolbar.removeView(this.mSpinner);
                    break;
                }
                case 2: {
                    if (this.mTabView == null || this.mTabView.getParent() != this.mToolbar) break;
                    this.mToolbar.removeView(this.mTabView);
                }
            }
            this.mNavigationMode = mode;
            switch (mode) {
                case 0: {
                    break;
                }
                case 1: {
                    this.ensureSpinner();
                    this.mToolbar.addView((View)this.mSpinner, 0);
                    break;
                }
                case 2: {
                    if (this.mTabView == null) break;
                    this.mToolbar.addView(this.mTabView, 0);
                    Toolbar.LayoutParams lp = (Toolbar.LayoutParams)this.mTabView.getLayoutParams();
                    lp.width = -2;
                    lp.height = -2;
                    lp.gravity = 8388691;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid navigation mode " + mode);
                }
            }
        }
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$ensureSpinner() {
        if (this.mSpinner == null) {
            this.mSpinner = new Spinner(this.getContext(), null, 16843479);
            Toolbar.LayoutParams lp = new Toolbar.LayoutParams(-2, -2, 8388627);
            this.mSpinner.setLayoutParams(lp);
        }
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setDropdownParams(SpinnerAdapter adapter, AdapterView.OnItemSelectedListener listener) {
        this.ensureSpinner();
        this.mSpinner.setAdapter(adapter);
        this.mSpinner.setOnItemSelectedListener(listener);
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setDropdownSelectedPosition(int position) {
        if (this.mSpinner == null) {
            throw new IllegalStateException("Can't set dropdown selected position without an adapter");
        }
        this.mSpinner.setSelection(position);
    }

    private final int $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$getDropdownSelectedPosition() {
        return this.mSpinner != null ? this.mSpinner.getSelectedItemPosition() : 0;
    }

    private final int $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$getDropdownItemCount() {
        return this.mSpinner != null ? this.mSpinner.getCount() : 0;
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setCustomView(View view) {
        if (this.mCustomView != null && (this.mDisplayOpts & 0x10) != 0) {
            this.mToolbar.removeView(this.mCustomView);
        }
        this.mCustomView = view;
        if (view != null && (this.mDisplayOpts & 0x10) != 0) {
            this.mToolbar.addView(this.mCustomView);
        }
    }

    private final View $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$getCustomView() {
        return this.mCustomView;
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$animateToVisibility(int visibility) {
        Animator anim2 = this.setupAnimatorToVisibility(visibility, 200L);
        if (anim2 != null) {
            anim2.start();
        }
    }

    private final Animator $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setupAnimatorToVisibility(int visibility, long duration) {
        if (visibility == 8) {
            ObjectAnimator anim2 = ObjectAnimator.ofFloat(this.mToolbar, View.ALPHA, 1.0f, 0.0f);
            anim2.setDuration(duration);
            anim2.addListener((Animator.AnimatorListener)new ShadowedObject(this){
                public transient /* synthetic */ Object __robo_data__;
                private boolean mCanceled;
                /* synthetic */ ToolbarWidgetWrapper this$0;

                private void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper_2$__constructor__(ToolbarWidgetWrapper this$0) {
                    this.mCanceled = false;
                }

                private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper_2$onAnimationEnd(Animator animation) {
                    if (!this.mCanceled) {
                        this.this$0.mToolbar.setVisibility(8);
                    }
                }

                private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper_2$onAnimationCancel(Animator animation) {
                    this.mCanceled = true;
                }

                private void __constructor__(ToolbarWidgetWrapper toolbarWidgetWrapper) {
                    this.$$robo$$com_android_internal_widget_ToolbarWidgetWrapper_2$__constructor__(toolbarWidgetWrapper);
                }
                {
                    this.this$0 = toolbarWidgetWrapper;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper_2$__constructor__(com.android.internal.widget.ToolbarWidgetWrapper ), 0, this, toolbarWidgetWrapper);
                }

                @Override
                public void onAnimationEnd(Animator animator2) {
                    InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper_2$onAnimationEnd(android.animation.Animator ), 0, this, animator2);
                }

                @Override
                public void onAnimationCancel(Animator animator2) {
                    InvokeDynamicSupport.bootstrap("onAnimationCancel", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper_2$onAnimationCancel(android.animation.Animator ), 0, this, animator2);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            return anim2;
        }
        if (visibility == 0) {
            ObjectAnimator anim3 = ObjectAnimator.ofFloat(this.mToolbar, View.ALPHA, 0.0f, 1.0f);
            anim3.setDuration(duration);
            anim3.addListener((Animator.AnimatorListener)new ShadowedObject(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ ToolbarWidgetWrapper this$0;

                private void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper_3$__constructor__(ToolbarWidgetWrapper this$0) {
                }

                private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper_3$onAnimationStart(Animator animation) {
                    this.this$0.mToolbar.setVisibility(0);
                }

                private void __constructor__(ToolbarWidgetWrapper toolbarWidgetWrapper) {
                    this.$$robo$$com_android_internal_widget_ToolbarWidgetWrapper_3$__constructor__(toolbarWidgetWrapper);
                }
                {
                    this.this$0 = toolbarWidgetWrapper;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper_3$__constructor__(com.android.internal.widget.ToolbarWidgetWrapper ), 0, this, toolbarWidgetWrapper);
                }

                @Override
                public void onAnimationStart(Animator animator2) {
                    InvokeDynamicSupport.bootstrap("onAnimationStart", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper_3$onAnimationStart(android.animation.Animator ), 0, this, animator2);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            return anim3;
        }
        return null;
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setNavigationIcon(Drawable icon) {
        this.mNavIcon = icon;
        this.updateNavigationIcon();
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setNavigationIcon(int resId) {
        this.setNavigationIcon(resId != 0 ? this.mToolbar.getContext().getDrawable(resId) : null);
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setDefaultNavigationIcon(Drawable defaultNavigationIcon) {
        if (this.mDefaultNavigationIcon != defaultNavigationIcon) {
            this.mDefaultNavigationIcon = defaultNavigationIcon;
            this.updateNavigationIcon();
        }
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$updateNavigationIcon() {
        if ((this.mDisplayOpts & 4) != 0) {
            this.mToolbar.setNavigationIcon(this.mNavIcon != null ? this.mNavIcon : this.mDefaultNavigationIcon);
        } else {
            this.mToolbar.setNavigationIcon(null);
        }
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setNavigationContentDescription(CharSequence description) {
        this.mHomeDescription = description;
        this.updateHomeAccessibility();
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setNavigationContentDescription(int resId) {
        this.setNavigationContentDescription(resId == 0 ? null : this.getContext().getString(resId));
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$updateHomeAccessibility() {
        if ((this.mDisplayOpts & 4) != 0) {
            if (TextUtils.isEmpty(this.mHomeDescription)) {
                this.mToolbar.setNavigationContentDescription(this.mDefaultNavigationContentDescription);
            } else {
                this.mToolbar.setNavigationContentDescription(this.mHomeDescription);
            }
        }
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$saveHierarchyState(SparseArray<Parcelable> toolbarStates) {
        this.mToolbar.saveHierarchyState(toolbarStates);
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$restoreHierarchyState(SparseArray<Parcelable> toolbarStates) {
        this.mToolbar.restoreHierarchyState(toolbarStates);
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setBackgroundDrawable(Drawable d) {
        this.mToolbar.setBackgroundDrawable(d);
    }

    private final int $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$getHeight() {
        return this.mToolbar.getHeight();
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setVisibility(int visible) {
        this.mToolbar.setVisibility(visible);
    }

    private final int $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$getVisibility() {
        return this.mToolbar.getVisibility();
    }

    private final void $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setMenuCallbacks(MenuPresenter.Callback presenterCallback, MenuBuilder.Callback menuBuilderCallback) {
        this.mToolbar.setMenuCallbacks(presenterCallback, menuBuilderCallback);
    }

    private final Menu $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$getMenu() {
        return this.mToolbar.getMenu();
    }

    private void __constructor__(Toolbar toolbar, boolean bl) {
        this.$$robo$$com_android_internal_widget_ToolbarWidgetWrapper$__constructor__(toolbar, bl);
    }

    public ToolbarWidgetWrapper(Toolbar toolbar, boolean bl) {
        this(toolbar, bl, 17039432);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$__constructor__(android.widget.Toolbar boolean ), 0, this, toolbar, bl);
    }

    private void __constructor__(Toolbar toolbar, boolean bl, int n) {
        this.$$robo$$com_android_internal_widget_ToolbarWidgetWrapper$__constructor__(toolbar, bl, n);
    }

    public ToolbarWidgetWrapper(Toolbar toolbar, boolean bl, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$__constructor__(android.widget.Toolbar boolean int ), 0, this, toolbar, bl, n);
    }

    @Override
    public void setDefaultNavigationContentDescription(int n) {
        InvokeDynamicSupport.bootstrap("setDefaultNavigationContentDescription", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setDefaultNavigationContentDescription(int ), 0, this, n);
    }

    private int detectDisplayOptions() {
        return (int)InvokeDynamicSupport.bootstrap("detectDisplayOptions", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$detectDisplayOptions(), 0, this);
    }

    @Override
    public ViewGroup getViewGroup() {
        return InvokeDynamicSupport.bootstrap("getViewGroup", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$getViewGroup(), 0, this);
    }

    @Override
    public Context getContext() {
        return InvokeDynamicSupport.bootstrap("getContext", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$getContext(), 0, this);
    }

    @Override
    public boolean isSplit() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSplit", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$isSplit(), 0, this);
    }

    @Override
    public boolean hasExpandedActionView() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasExpandedActionView", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$hasExpandedActionView(), 0, this);
    }

    @Override
    public void collapseActionView() {
        InvokeDynamicSupport.bootstrap("collapseActionView", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$collapseActionView(), 0, this);
    }

    @Override
    public void setWindowCallback(Window.Callback callback) {
        InvokeDynamicSupport.bootstrap("setWindowCallback", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setWindowCallback(android.view.Window$Callback ), 0, this, callback);
    }

    @Override
    public void setWindowTitle(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setWindowTitle", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setWindowTitle(java.lang.CharSequence ), 0, this, charSequence);
    }

    @Override
    public CharSequence getTitle() {
        return InvokeDynamicSupport.bootstrap("getTitle", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$getTitle(), 0, this);
    }

    @Override
    public void setTitle(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setTitle", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setTitle(java.lang.CharSequence ), 0, this, charSequence);
    }

    private void setTitleInt(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setTitleInt", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setTitleInt(java.lang.CharSequence ), 0, this, charSequence);
    }

    @Override
    public CharSequence getSubtitle() {
        return InvokeDynamicSupport.bootstrap("getSubtitle", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$getSubtitle(), 0, this);
    }

    @Override
    public void setSubtitle(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setSubtitle", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setSubtitle(java.lang.CharSequence ), 0, this, charSequence);
    }

    @Override
    public void initProgress() {
        InvokeDynamicSupport.bootstrap("initProgress", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$initProgress(), 0, this);
    }

    @Override
    public void initIndeterminateProgress() {
        InvokeDynamicSupport.bootstrap("initIndeterminateProgress", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$initIndeterminateProgress(), 0, this);
    }

    @Override
    public boolean canSplit() {
        return (boolean)InvokeDynamicSupport.bootstrap("canSplit", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$canSplit(), 0, this);
    }

    @Override
    public void setSplitView(ViewGroup viewGroup) {
        InvokeDynamicSupport.bootstrap("setSplitView", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setSplitView(android.view.ViewGroup ), 0, this, viewGroup);
    }

    @Override
    public void setSplitToolbar(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSplitToolbar", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setSplitToolbar(boolean ), 0, this, bl);
    }

    @Override
    public void setSplitWhenNarrow(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSplitWhenNarrow", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setSplitWhenNarrow(boolean ), 0, this, bl);
    }

    @Override
    public boolean hasIcon() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasIcon", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$hasIcon(), 0, this);
    }

    @Override
    public boolean hasLogo() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasLogo", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$hasLogo(), 0, this);
    }

    @Override
    public void setIcon(int n) {
        InvokeDynamicSupport.bootstrap("setIcon", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setIcon(int ), 0, this, n);
    }

    @Override
    public void setIcon(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setIcon", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setIcon(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    @Override
    public void setLogo(int n) {
        InvokeDynamicSupport.bootstrap("setLogo", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setLogo(int ), 0, this, n);
    }

    @Override
    public void setLogo(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setLogo", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setLogo(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    private void updateToolbarLogo() {
        InvokeDynamicSupport.bootstrap("updateToolbarLogo", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$updateToolbarLogo(), 0, this);
    }

    @Override
    public boolean canShowOverflowMenu() {
        return (boolean)InvokeDynamicSupport.bootstrap("canShowOverflowMenu", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$canShowOverflowMenu(), 0, this);
    }

    @Override
    public boolean isOverflowMenuShowing() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOverflowMenuShowing", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$isOverflowMenuShowing(), 0, this);
    }

    @Override
    public boolean isOverflowMenuShowPending() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOverflowMenuShowPending", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$isOverflowMenuShowPending(), 0, this);
    }

    @Override
    public boolean showOverflowMenu() {
        return (boolean)InvokeDynamicSupport.bootstrap("showOverflowMenu", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$showOverflowMenu(), 0, this);
    }

    @Override
    public boolean hideOverflowMenu() {
        return (boolean)InvokeDynamicSupport.bootstrap("hideOverflowMenu", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$hideOverflowMenu(), 0, this);
    }

    @Override
    public void setMenuPrepared() {
        InvokeDynamicSupport.bootstrap("setMenuPrepared", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setMenuPrepared(), 0, this);
    }

    @Override
    public void setMenu(Menu menu2, MenuPresenter.Callback callback) {
        InvokeDynamicSupport.bootstrap("setMenu", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setMenu(android.view.Menu com.android.internal.view.menu.MenuPresenter$Callback ), 0, this, menu2, callback);
    }

    @Override
    public void dismissPopupMenus() {
        InvokeDynamicSupport.bootstrap("dismissPopupMenus", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$dismissPopupMenus(), 0, this);
    }

    @Override
    public int getDisplayOptions() {
        return (int)InvokeDynamicSupport.bootstrap("getDisplayOptions", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$getDisplayOptions(), 0, this);
    }

    @Override
    public void setDisplayOptions(int n) {
        InvokeDynamicSupport.bootstrap("setDisplayOptions", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setDisplayOptions(int ), 0, this, n);
    }

    @Override
    public void setEmbeddedTabView(ScrollingTabContainerView scrollingTabContainerView) {
        InvokeDynamicSupport.bootstrap("setEmbeddedTabView", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setEmbeddedTabView(com.android.internal.widget.ScrollingTabContainerView ), 0, this, scrollingTabContainerView);
    }

    @Override
    public boolean hasEmbeddedTabs() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasEmbeddedTabs", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$hasEmbeddedTabs(), 0, this);
    }

    @Override
    public boolean isTitleTruncated() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTitleTruncated", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$isTitleTruncated(), 0, this);
    }

    @Override
    public void setCollapsible(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCollapsible", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setCollapsible(boolean ), 0, this, bl);
    }

    @Override
    public void setHomeButtonEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setHomeButtonEnabled", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setHomeButtonEnabled(boolean ), 0, this, bl);
    }

    @Override
    public int getNavigationMode() {
        return (int)InvokeDynamicSupport.bootstrap("getNavigationMode", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$getNavigationMode(), 0, this);
    }

    @Override
    public void setNavigationMode(int n) {
        InvokeDynamicSupport.bootstrap("setNavigationMode", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setNavigationMode(int ), 0, this, n);
    }

    private void ensureSpinner() {
        InvokeDynamicSupport.bootstrap("ensureSpinner", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$ensureSpinner(), 0, this);
    }

    @Override
    public void setDropdownParams(SpinnerAdapter spinnerAdapter, AdapterView.OnItemSelectedListener onItemSelectedListener) {
        InvokeDynamicSupport.bootstrap("setDropdownParams", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setDropdownParams(android.widget.SpinnerAdapter android.widget.AdapterView$OnItemSelectedListener ), 0, this, spinnerAdapter, onItemSelectedListener);
    }

    @Override
    public void setDropdownSelectedPosition(int n) {
        InvokeDynamicSupport.bootstrap("setDropdownSelectedPosition", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setDropdownSelectedPosition(int ), 0, this, n);
    }

    @Override
    public int getDropdownSelectedPosition() {
        return (int)InvokeDynamicSupport.bootstrap("getDropdownSelectedPosition", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$getDropdownSelectedPosition(), 0, this);
    }

    @Override
    public int getDropdownItemCount() {
        return (int)InvokeDynamicSupport.bootstrap("getDropdownItemCount", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$getDropdownItemCount(), 0, this);
    }

    @Override
    public void setCustomView(View view) {
        InvokeDynamicSupport.bootstrap("setCustomView", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setCustomView(android.view.View ), 0, this, view);
    }

    @Override
    public View getCustomView() {
        return InvokeDynamicSupport.bootstrap("getCustomView", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$getCustomView(), 0, this);
    }

    @Override
    public void animateToVisibility(int n) {
        InvokeDynamicSupport.bootstrap("animateToVisibility", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$animateToVisibility(int ), 0, this, n);
    }

    @Override
    public Animator setupAnimatorToVisibility(int n, long l) {
        return InvokeDynamicSupport.bootstrap("setupAnimatorToVisibility", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setupAnimatorToVisibility(int long ), 0, this, n, l);
    }

    @Override
    public void setNavigationIcon(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setNavigationIcon", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setNavigationIcon(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    @Override
    public void setNavigationIcon(int n) {
        InvokeDynamicSupport.bootstrap("setNavigationIcon", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setNavigationIcon(int ), 0, this, n);
    }

    @Override
    public void setDefaultNavigationIcon(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setDefaultNavigationIcon", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setDefaultNavigationIcon(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    private void updateNavigationIcon() {
        InvokeDynamicSupport.bootstrap("updateNavigationIcon", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$updateNavigationIcon(), 0, this);
    }

    @Override
    public void setNavigationContentDescription(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setNavigationContentDescription", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setNavigationContentDescription(java.lang.CharSequence ), 0, this, charSequence);
    }

    @Override
    public void setNavigationContentDescription(int n) {
        InvokeDynamicSupport.bootstrap("setNavigationContentDescription", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setNavigationContentDescription(int ), 0, this, n);
    }

    private void updateHomeAccessibility() {
        InvokeDynamicSupport.bootstrap("updateHomeAccessibility", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$updateHomeAccessibility(), 0, this);
    }

    @Override
    public void saveHierarchyState(SparseArray<Parcelable> sparseArray) {
        InvokeDynamicSupport.bootstrap("saveHierarchyState", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$saveHierarchyState(android.util.SparseArray<android.os.Parcelable> ), 0, this, sparseArray);
    }

    @Override
    public void restoreHierarchyState(SparseArray<Parcelable> sparseArray) {
        InvokeDynamicSupport.bootstrap("restoreHierarchyState", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$restoreHierarchyState(android.util.SparseArray<android.os.Parcelable> ), 0, this, sparseArray);
    }

    @Override
    public void setBackgroundDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setBackgroundDrawable", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setBackgroundDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    @Override
    public int getHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getHeight", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$getHeight(), 0, this);
    }

    @Override
    public void setVisibility(int n) {
        InvokeDynamicSupport.bootstrap("setVisibility", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setVisibility(int ), 0, this, n);
    }

    @Override
    public int getVisibility() {
        return (int)InvokeDynamicSupport.bootstrap("getVisibility", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$getVisibility(), 0, this);
    }

    @Override
    public void setMenuCallbacks(MenuPresenter.Callback callback, MenuBuilder.Callback callback2) {
        InvokeDynamicSupport.bootstrap("setMenuCallbacks", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$setMenuCallbacks(com.android.internal.view.menu.MenuPresenter$Callback com.android.internal.view.menu.MenuBuilder$Callback ), 0, this, callback, callback2);
    }

    @Override
    public Menu getMenu() {
        return InvokeDynamicSupport.bootstrap("getMenu", $$robo$$com_android_internal_widget_ToolbarWidgetWrapper$getMenu(), 0, this);
    }

    public /* synthetic */ ToolbarWidgetWrapper() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ToolbarWidgetWrapper)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

