/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.ConscryptSession;
import com.android.org.conscrypt.SessionDecorator;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;

final class ExternalSession
implements SessionDecorator {
    private final HashMap<String, Object> values = new HashMap(2);
    private final Provider provider;

    public ExternalSession(Provider provider) {
        this.provider = provider;
    }

    @Override
    public ConscryptSession getDelegate() {
        return this.provider.provideSession();
    }

    @Override
    public String getRequestedServerName() {
        return this.getDelegate().getRequestedServerName();
    }

    @Override
    public List<byte[]> getStatusResponses() {
        return this.getDelegate().getStatusResponses();
    }

    @Override
    public byte[] getPeerSignedCertificateTimestamp() {
        return this.getDelegate().getPeerSignedCertificateTimestamp();
    }

    @Override
    public byte[] getId() {
        return this.getDelegate().getId();
    }

    @Override
    public SSLSessionContext getSessionContext() {
        return this.getDelegate().getSessionContext();
    }

    @Override
    public long getCreationTime() {
        return this.getDelegate().getCreationTime();
    }

    @Override
    public long getLastAccessedTime() {
        return this.getDelegate().getLastAccessedTime();
    }

    @Override
    public void invalidate() {
        this.getDelegate().invalidate();
    }

    @Override
    public boolean isValid() {
        return this.getDelegate().isValid();
    }

    @Override
    public X509Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        return this.getDelegate().getPeerCertificates();
    }

    @Override
    public Certificate[] getLocalCertificates() {
        return this.getDelegate().getLocalCertificates();
    }

    @Override
    public javax.security.cert.X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        return this.getDelegate().getPeerCertificateChain();
    }

    @Override
    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        return this.getDelegate().getPeerPrincipal();
    }

    @Override
    public Principal getLocalPrincipal() {
        return this.getDelegate().getLocalPrincipal();
    }

    @Override
    public String getCipherSuite() {
        return this.getDelegate().getCipherSuite();
    }

    @Override
    public String getProtocol() {
        return this.getDelegate().getProtocol();
    }

    @Override
    public String getPeerHost() {
        return this.getDelegate().getPeerHost();
    }

    @Override
    public int getPeerPort() {
        return this.getDelegate().getPeerPort();
    }

    @Override
    public int getPacketBufferSize() {
        return this.getDelegate().getPacketBufferSize();
    }

    @Override
    public int getApplicationBufferSize() {
        return this.getDelegate().getApplicationBufferSize();
    }

    @Override
    public Object getValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        return this.values.get(name);
    }

    @Override
    public String[] getValueNames() {
        return this.values.keySet().toArray(new String[this.values.size()]);
    }

    @Override
    public void putValue(String name, Object value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("name == null || value == null");
        }
        Object old = this.values.put(name, value);
        if (value instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)value).valueBound(new SSLSessionBindingEvent(this, name));
        }
        if (old instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)old).valueUnbound(new SSLSessionBindingEvent(this, name));
        }
    }

    @Override
    public void removeValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        Object old = this.values.remove(name);
        if (old instanceof SSLSessionBindingListener) {
            SSLSessionBindingListener listener = (SSLSessionBindingListener)old;
            listener.valueUnbound(new SSLSessionBindingEvent(this, name));
        }
    }

    static interface Provider {
        public ConscryptSession provideSession();
    }
}

