/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManager;
import android.app.AppGlobals;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.IBluetooth;
import android.bluetooth.IBluetoothCallback;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothHeadset;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothManagerCallback;
import android.bluetooth.IBluetoothProfileServiceConnection;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.database.ContentObserver;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.UserManagerInternal;
import android.provider.Settings;
import android.text.format.DateFormat;
import android.util.Slog;
import android.util.StatsLog;
import com.android.internal.util.DumpUtils;
import com.android.server.IoThread;
import com.android.server.LocalServices;
import com.android.server.pm.UserRestrictionsUtils;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class BluetoothManagerService
extends IBluetoothManager.Stub {
    private static final String TAG = "BluetoothManagerService";
    private static final boolean DBG = true;
    private static final String BLUETOOTH_ADMIN_PERM = "android.permission.BLUETOOTH_ADMIN";
    private static final String BLUETOOTH_PERM = "android.permission.BLUETOOTH";
    private static final String SECURE_SETTINGS_BLUETOOTH_ADDR_VALID = "bluetooth_addr_valid";
    private static final String SECURE_SETTINGS_BLUETOOTH_ADDRESS = "bluetooth_address";
    private static final String SECURE_SETTINGS_BLUETOOTH_NAME = "bluetooth_name";
    private static final int ACTIVE_LOG_MAX_SIZE = 20;
    private static final int CRASH_LOG_MAX_SIZE = 100;
    private static final int TIMEOUT_BIND_MS = 3000;
    private static final int SERVICE_RESTART_TIME_MS = 200;
    private static final int ERROR_RESTART_TIME_MS = 3000;
    private static final int USER_SWITCHED_TIME_MS = 200;
    private static final int ADD_PROXY_DELAY_MS = 100;
    private static final int MESSAGE_ENABLE = 1;
    private static final int MESSAGE_DISABLE = 2;
    private static final int MESSAGE_REGISTER_ADAPTER = 20;
    private static final int MESSAGE_UNREGISTER_ADAPTER = 21;
    private static final int MESSAGE_REGISTER_STATE_CHANGE_CALLBACK = 30;
    private static final int MESSAGE_UNREGISTER_STATE_CHANGE_CALLBACK = 31;
    private static final int MESSAGE_BLUETOOTH_SERVICE_CONNECTED = 40;
    private static final int MESSAGE_BLUETOOTH_SERVICE_DISCONNECTED = 41;
    private static final int MESSAGE_RESTART_BLUETOOTH_SERVICE = 42;
    private static final int MESSAGE_BLUETOOTH_STATE_CHANGE = 60;
    private static final int MESSAGE_TIMEOUT_BIND = 100;
    private static final int MESSAGE_TIMEOUT_UNBIND = 101;
    private static final int MESSAGE_GET_NAME_AND_ADDRESS = 200;
    private static final int MESSAGE_USER_SWITCHED = 300;
    private static final int MESSAGE_USER_UNLOCKED = 301;
    private static final int MESSAGE_ADD_PROXY_DELAYED = 400;
    private static final int MESSAGE_BIND_PROFILE_SERVICE = 401;
    private static final int MESSAGE_RESTORE_USER_SETTING = 500;
    private static final int RESTORE_SETTING_TO_ON = 1;
    private static final int RESTORE_SETTING_TO_OFF = 0;
    private static final int MAX_ERROR_RESTART_RETRIES = 6;
    private static final int BLUETOOTH_OFF = 0;
    private static final int BLUETOOTH_ON_BLUETOOTH = 1;
    private static final int BLUETOOTH_ON_AIRPLANE = 2;
    private static final int SERVICE_IBLUETOOTH = 1;
    private static final int SERVICE_IBLUETOOTHGATT = 2;
    private final Context mContext;
    private String mAddress;
    private String mName;
    private final ContentResolver mContentResolver;
    private final RemoteCallbackList<IBluetoothManagerCallback> mCallbacks;
    private final RemoteCallbackList<IBluetoothStateChangeCallback> mStateChangeCallbacks;
    private IBinder mBluetoothBinder;
    private IBluetooth mBluetooth;
    private IBluetoothGatt mBluetoothGatt;
    private final ReentrantReadWriteLock mBluetoothLock = new ReentrantReadWriteLock();
    private boolean mBinding;
    private boolean mUnbinding;
    private boolean mQuietEnable = false;
    private boolean mEnable;
    private final LinkedList<ActiveLog> mActiveLogs = new LinkedList();
    private final LinkedList<Long> mCrashTimestamps = new LinkedList();
    private int mCrashes;
    private long mLastEnabledTime;
    private boolean mQuietEnableExternal;
    private boolean mEnableExternal;
    private Map<IBinder, ClientDeathRecipient> mBleApps = new ConcurrentHashMap<IBinder, ClientDeathRecipient>();
    private int mState;
    private final BluetoothHandler mHandler;
    private int mErrorRecoveryRetryCounter;
    private final int mSystemUiUid;
    private final Map<Integer, ProfileServiceConnections> mProfileServices = new HashMap<Integer, ProfileServiceConnections>();
    private final boolean mPermissionReviewRequired;
    private final IBluetoothCallback mBluetoothCallback = new IBluetoothCallback.Stub(){

        @Override
        public void onBluetoothStateChange(int prevState, int newState) throws RemoteException {
            Message msg = BluetoothManagerService.this.mHandler.obtainMessage(60, prevState, newState);
            BluetoothManagerService.this.mHandler.sendMessage(msg);
        }
    };
    private final UserManagerInternal.UserRestrictionsListener mUserRestrictionsListener = new UserManagerInternal.UserRestrictionsListener(){

        @Override
        public void onUserRestrictionsChanged(int userId, Bundle newRestrictions, Bundle prevRestrictions) {
            if (UserRestrictionsUtils.restrictionsChanged(prevRestrictions, newRestrictions, "no_bluetooth_sharing")) {
                BluetoothManagerService.this.updateOppLauncherComponentState(userId, newRestrictions.getBoolean("no_bluetooth_sharing"));
            }
            if (userId == 0 && UserRestrictionsUtils.restrictionsChanged(prevRestrictions, newRestrictions, "no_bluetooth")) {
                if (userId == 0 && newRestrictions.getBoolean("no_bluetooth")) {
                    BluetoothManagerService.this.updateOppLauncherComponentState(userId, true);
                    BluetoothManagerService.this.sendDisableMsg(3, BluetoothManagerService.this.mContext.getPackageName());
                } else {
                    BluetoothManagerService.this.updateOppLauncherComponentState(userId, newRestrictions.getBoolean("no_bluetooth_sharing"));
                }
            }
        }
    };
    private final ContentObserver mAirplaneModeObserver = new ContentObserver(null){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void onChange(boolean unused) {
            3 var2_2 = this;
            synchronized (var2_2) {
                if (BluetoothManagerService.this.isBluetoothPersistedStateOn()) {
                    if (BluetoothManagerService.this.isAirplaneModeOn()) {
                        BluetoothManagerService.this.persistBluetoothSetting(2);
                    } else {
                        BluetoothManagerService.this.persistBluetoothSetting(1);
                    }
                }
                int st = 10;
                try {
                    BluetoothManagerService.this.mBluetoothLock.readLock().lock();
                    if (BluetoothManagerService.this.mBluetooth != null) {
                        st = BluetoothManagerService.this.mBluetooth.getState();
                    }
                }
                catch (RemoteException e) {
                    Slog.e(BluetoothManagerService.TAG, "Unable to call getState", e);
                    return;
                }
                finally {
                    BluetoothManagerService.this.mBluetoothLock.readLock().unlock();
                }
                Slog.d(BluetoothManagerService.TAG, "Airplane Mode change - current state:  " + BluetoothAdapter.nameForState(st));
                if (BluetoothManagerService.this.isAirplaneModeOn()) {
                    BluetoothManagerService.this.clearBleApps();
                    if (st == 15) {
                        try {
                            BluetoothManagerService.this.mBluetoothLock.readLock().lock();
                            if (BluetoothManagerService.this.mBluetooth == null) return;
                            BluetoothManagerService.this.addActiveLog(2, BluetoothManagerService.this.mContext.getPackageName(), false);
                            BluetoothManagerService.this.mBluetooth.onBrEdrDown();
                            BluetoothManagerService.this.mEnable = false;
                            BluetoothManagerService.this.mEnableExternal = false;
                        }
                        catch (RemoteException e) {
                            Slog.e(BluetoothManagerService.TAG, "Unable to call onBrEdrDown", e);
                        }
                        finally {
                            BluetoothManagerService.this.mBluetoothLock.readLock().unlock();
                        }
                    } else {
                        if (st != 12) return;
                        BluetoothManagerService.this.sendDisableMsg(2, BluetoothManagerService.this.mContext.getPackageName());
                    }
                } else {
                    if (!BluetoothManagerService.this.mEnableExternal) return;
                    BluetoothManagerService.this.sendEnableMsg(BluetoothManagerService.this.mQuietEnableExternal, 2, BluetoothManagerService.this.mContext.getPackageName());
                }
                return;
            }
        }
    };
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String name;
            String action = intent.getAction();
            if ("android.bluetooth.adapter.action.LOCAL_NAME_CHANGED".equals(action)) {
                String newName = intent.getStringExtra("android.bluetooth.adapter.extra.LOCAL_NAME");
                Slog.d(BluetoothManagerService.TAG, "Bluetooth Adapter name changed to " + newName);
                if (newName != null) {
                    BluetoothManagerService.this.storeNameAndAddress(newName, null);
                }
            } else if ("android.bluetooth.adapter.action.BLUETOOTH_ADDRESS_CHANGED".equals(action)) {
                String newAddress = intent.getStringExtra("android.bluetooth.adapter.extra.BLUETOOTH_ADDRESS");
                if (newAddress != null) {
                    Slog.d(BluetoothManagerService.TAG, "Bluetooth Adapter address changed to " + newAddress);
                    BluetoothManagerService.this.storeNameAndAddress(null, newAddress);
                } else {
                    Slog.e(BluetoothManagerService.TAG, "No Bluetooth Adapter address parameter found");
                }
            } else if ("android.os.action.SETTING_RESTORED".equals(action) && "bluetooth_on".equals(name = intent.getStringExtra("setting_name"))) {
                String prevValue = intent.getStringExtra("previous_value");
                String newValue = intent.getStringExtra("new_value");
                Slog.d(BluetoothManagerService.TAG, "ACTION_SETTING_RESTORED with BLUETOOTH_ON, prevValue=" + prevValue + ", newValue=" + newValue);
                if (newValue != null && prevValue != null && !prevValue.equals(newValue)) {
                    Message msg = BluetoothManagerService.this.mHandler.obtainMessage(500, newValue.equals("0") ? 0 : 1, 0);
                    BluetoothManagerService.this.mHandler.sendMessage(msg);
                }
            }
        }
    };
    private BluetoothServiceConnection mConnection = new BluetoothServiceConnection();

    private static CharSequence timeToLog(long timestamp) {
        return DateFormat.format((CharSequence)"MM-dd HH:mm:ss", timestamp);
    }

    BluetoothManagerService(Context context) {
        String airplaneModeRadios;
        this.mHandler = new BluetoothHandler(IoThread.get().getLooper());
        this.mContext = context;
        this.mPermissionReviewRequired = context.getResources().getBoolean(17957002);
        this.mCrashes = 0;
        this.mBluetooth = null;
        this.mBluetoothBinder = null;
        this.mBluetoothGatt = null;
        this.mBinding = false;
        this.mUnbinding = false;
        this.mEnable = false;
        this.mState = 10;
        this.mQuietEnableExternal = false;
        this.mEnableExternal = false;
        this.mAddress = null;
        this.mName = null;
        this.mErrorRecoveryRetryCounter = 0;
        this.mContentResolver = context.getContentResolver();
        this.registerForBleScanModeChange();
        this.mCallbacks = new RemoteCallbackList();
        this.mStateChangeCallbacks = new RemoteCallbackList();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.bluetooth.adapter.action.LOCAL_NAME_CHANGED");
        filter.addAction("android.bluetooth.adapter.action.BLUETOOTH_ADDRESS_CHANGED");
        filter.addAction("android.os.action.SETTING_RESTORED");
        filter.setPriority(1000);
        this.mContext.registerReceiver(this.mReceiver, filter);
        this.loadStoredNameAndAddress();
        if (this.isBluetoothPersistedStateOn()) {
            Slog.d(TAG, "Startup: Bluetooth persisted state is ON.");
            this.mEnableExternal = true;
        }
        if ((airplaneModeRadios = Settings.Global.getString(this.mContentResolver, "airplane_mode_radios")) == null || airplaneModeRadios.contains("bluetooth")) {
            this.mContentResolver.registerContentObserver(Settings.Global.getUriFor("airplane_mode_on"), true, this.mAirplaneModeObserver);
        }
        int systemUiUid = -1;
        try {
            boolean noHome = this.mContext.getResources().getBoolean(17956998);
            if (!noHome) {
                systemUiUid = this.mContext.getPackageManager().getPackageUidAsUser("com.android.systemui", 0x100000, 0);
            }
            Slog.d(TAG, "Detected SystemUiUid: " + Integer.toString(systemUiUid));
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.w(TAG, "Unable to resolve SystemUI's UID.", e);
        }
        this.mSystemUiUid = systemUiUid;
    }

    private boolean isAirplaneModeOn() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "airplane_mode_on", 0) == 1;
    }

    private boolean supportBluetoothPersistedState() {
        return this.mContext.getResources().getBoolean(17957037);
    }

    private boolean isBluetoothPersistedStateOn() {
        if (!this.supportBluetoothPersistedState()) {
            return false;
        }
        int state = Settings.Global.getInt(this.mContentResolver, "bluetooth_on", -1);
        Slog.d(TAG, "Bluetooth persisted state: " + state);
        return state != 0;
    }

    private boolean isBluetoothPersistedStateOnBluetooth() {
        if (!this.supportBluetoothPersistedState()) {
            return false;
        }
        return Settings.Global.getInt(this.mContentResolver, "bluetooth_on", 1) == 1;
    }

    private void persistBluetoothSetting(int value) {
        Slog.d(TAG, "Persisting Bluetooth Setting: " + value);
        long callingIdentity = Binder.clearCallingIdentity();
        Settings.Global.putInt(this.mContext.getContentResolver(), "bluetooth_on", value);
        Binder.restoreCallingIdentity(callingIdentity);
    }

    private boolean isNameAndAddressSet() {
        return this.mName != null && this.mAddress != null && this.mName.length() > 0 && this.mAddress.length() > 0;
    }

    private void loadStoredNameAndAddress() {
        Slog.d(TAG, "Loading stored name and address");
        if (this.mContext.getResources().getBoolean(17956899) && Settings.Secure.getInt(this.mContentResolver, SECURE_SETTINGS_BLUETOOTH_ADDR_VALID, 0) == 0) {
            Slog.d(TAG, "invalid bluetooth name and address stored");
            return;
        }
        this.mName = Settings.Secure.getString(this.mContentResolver, SECURE_SETTINGS_BLUETOOTH_NAME);
        this.mAddress = Settings.Secure.getString(this.mContentResolver, SECURE_SETTINGS_BLUETOOTH_ADDRESS);
        Slog.d(TAG, "Stored bluetooth Name=" + this.mName + ",Address=" + this.mAddress);
    }

    private void storeNameAndAddress(String name, String address) {
        if (name != null) {
            Settings.Secure.putString(this.mContentResolver, SECURE_SETTINGS_BLUETOOTH_NAME, name);
            this.mName = name;
            Slog.d(TAG, "Stored Bluetooth name: " + Settings.Secure.getString(this.mContentResolver, SECURE_SETTINGS_BLUETOOTH_NAME));
        }
        if (address != null) {
            Settings.Secure.putString(this.mContentResolver, SECURE_SETTINGS_BLUETOOTH_ADDRESS, address);
            this.mAddress = address;
            Slog.d(TAG, "Stored Bluetoothaddress: " + Settings.Secure.getString(this.mContentResolver, SECURE_SETTINGS_BLUETOOTH_ADDRESS));
        }
        if (name != null && address != null) {
            Settings.Secure.putInt(this.mContentResolver, SECURE_SETTINGS_BLUETOOTH_ADDR_VALID, 1);
        }
    }

    @Override
    public IBluetooth registerAdapter(IBluetoothManagerCallback callback) {
        if (callback == null) {
            Slog.w(TAG, "Callback is null in registerAdapter");
            return null;
        }
        Message msg = this.mHandler.obtainMessage(20);
        msg.obj = callback;
        this.mHandler.sendMessage(msg);
        return this.mBluetooth;
    }

    @Override
    public void unregisterAdapter(IBluetoothManagerCallback callback) {
        if (callback == null) {
            Slog.w(TAG, "Callback is null in unregisterAdapter");
            return;
        }
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        Message msg = this.mHandler.obtainMessage(21);
        msg.obj = callback;
        this.mHandler.sendMessage(msg);
    }

    @Override
    public void registerStateChangeCallback(IBluetoothStateChangeCallback callback) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (callback == null) {
            Slog.w(TAG, "registerStateChangeCallback: Callback is null!");
            return;
        }
        Message msg = this.mHandler.obtainMessage(30);
        msg.obj = callback;
        this.mHandler.sendMessage(msg);
    }

    @Override
    public void unregisterStateChangeCallback(IBluetoothStateChangeCallback callback) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (callback == null) {
            Slog.w(TAG, "unregisterStateChangeCallback: Callback is null!");
            return;
        }
        Message msg = this.mHandler.obtainMessage(31);
        msg.obj = callback;
        this.mHandler.sendMessage(msg);
    }

    @Override
    public boolean isEnabled() {
        if (Binder.getCallingUid() != 1000 && !this.checkIfCallerIsForegroundUser()) {
            Slog.w(TAG, "isEnabled(): not allowed for non-active and non system user");
            return false;
        }
        try {
            this.mBluetoothLock.readLock().lock();
            if (this.mBluetooth != null) {
                boolean bl = this.mBluetooth.isEnabled();
                return bl;
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "isEnabled()", e);
        }
        finally {
            this.mBluetoothLock.readLock().unlock();
        }
        return false;
    }

    @Override
    public int getState() {
        if (Binder.getCallingUid() != 1000 && !this.checkIfCallerIsForegroundUser()) {
            Slog.w(TAG, "getState(): report OFF for non-active and non system user");
            return 10;
        }
        try {
            this.mBluetoothLock.readLock().lock();
            if (this.mBluetooth != null) {
                int n = this.mBluetooth.getState();
                return n;
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "getState()", e);
        }
        finally {
            this.mBluetoothLock.readLock().unlock();
        }
        return 10;
    }

    @Override
    public boolean isBleScanAlwaysAvailable() {
        if (this.isAirplaneModeOn() && !this.mEnable) {
            return false;
        }
        try {
            return Settings.Global.getInt(this.mContentResolver, "ble_scan_always_enabled") != 0;
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            return false;
        }
    }

    private void registerForBleScanModeChange() {
        ContentObserver contentObserver = new ContentObserver(null){

            @Override
            public void onChange(boolean selfChange) {
                if (BluetoothManagerService.this.isBleScanAlwaysAvailable()) {
                    return;
                }
                BluetoothManagerService.this.disableBleScanMode();
                BluetoothManagerService.this.clearBleApps();
                try {
                    BluetoothManagerService.this.mBluetoothLock.readLock().lock();
                    if (BluetoothManagerService.this.mBluetooth != null) {
                        BluetoothManagerService.this.addActiveLog(1, BluetoothManagerService.this.mContext.getPackageName(), false);
                        BluetoothManagerService.this.mBluetooth.onBrEdrDown();
                    }
                }
                catch (RemoteException e) {
                    Slog.e(BluetoothManagerService.TAG, "error when disabling bluetooth", e);
                }
                finally {
                    BluetoothManagerService.this.mBluetoothLock.readLock().unlock();
                }
            }
        };
        this.mContentResolver.registerContentObserver(Settings.Global.getUriFor("ble_scan_always_enabled"), false, contentObserver);
    }

    private void disableBleScanMode() {
        try {
            this.mBluetoothLock.writeLock().lock();
            if (this.mBluetooth != null && this.mBluetooth.getState() != 12) {
                Slog.d(TAG, "Reseting the mEnable flag for clean disable");
                this.mEnable = false;
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "getState()", e);
        }
        finally {
            this.mBluetoothLock.writeLock().unlock();
        }
    }

    @Override
    public int updateBleAppCount(IBinder token, boolean enable, String packageName) {
        ClientDeathRecipient r = this.mBleApps.get(token);
        if (r == null && enable) {
            ClientDeathRecipient deathRec = new ClientDeathRecipient(packageName);
            try {
                token.linkToDeath(deathRec, 0);
            }
            catch (RemoteException ex) {
                throw new IllegalArgumentException("BLE app (" + packageName + ") already dead!");
            }
            this.mBleApps.put(token, deathRec);
            Slog.d(TAG, "Registered for death of " + packageName);
        } else if (!enable && r != null) {
            token.unlinkToDeath(r, 0);
            this.mBleApps.remove(token);
            Slog.d(TAG, "Unregistered for death of " + packageName);
        }
        int appCount = this.mBleApps.size();
        Slog.d(TAG, appCount + " registered Ble Apps");
        if (appCount == 0 && this.mEnable) {
            this.disableBleScanMode();
        }
        if (appCount == 0 && !this.mEnableExternal) {
            this.sendBrEdrDownCallback();
        }
        return appCount;
    }

    private void clearBleApps() {
        this.mBleApps.clear();
    }

    @Override
    public boolean isBleAppPresent() {
        Slog.d(TAG, "isBleAppPresent() count: " + this.mBleApps.size());
        return this.mBleApps.size() > 0;
    }

    private void continueFromBleOnState() {
        Slog.d(TAG, "continueFromBleOnState()");
        try {
            this.mBluetoothLock.readLock().lock();
            if (this.mBluetooth == null) {
                Slog.e(TAG, "onBluetoothServiceUp: mBluetooth is null!");
                return;
            }
            if (this.isBluetoothPersistedStateOnBluetooth() || !this.isBleAppPresent()) {
                this.mBluetooth.onLeServiceUp();
                this.persistBluetoothSetting(1);
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Unable to call onServiceUp", e);
        }
        finally {
            this.mBluetoothLock.readLock().unlock();
        }
    }

    private void sendBrEdrDownCallback() {
        Slog.d(TAG, "Calling sendBrEdrDownCallback callbacks");
        if (this.mBluetooth == null) {
            Slog.w(TAG, "Bluetooth handle is null");
            return;
        }
        if (this.isBleAppPresent()) {
            try {
                this.mBluetoothGatt.unregAll();
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Unable to disconnect all apps.", e);
            }
        } else {
            try {
                this.mBluetoothLock.readLock().lock();
                if (this.mBluetooth != null) {
                    this.mBluetooth.onBrEdrDown();
                }
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Call to onBrEdrDown() failed.", e);
            }
            finally {
                this.mBluetoothLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean enableNoAutoConnect(String packageName) {
        if (this.isBluetoothDisallowed()) {
            Slog.d(TAG, "enableNoAutoConnect(): not enabling - bluetooth disallowed");
            return false;
        }
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH ADMIN permission");
        Slog.d(TAG, "enableNoAutoConnect():  mBluetooth =" + this.mBluetooth + " mBinding = " + this.mBinding);
        int callingAppId = UserHandle.getAppId(Binder.getCallingUid());
        if (callingAppId != 1027) {
            throw new SecurityException("no permission to enable Bluetooth quietly");
        }
        BroadcastReceiver broadcastReceiver = this.mReceiver;
        synchronized (broadcastReceiver) {
            this.mQuietEnableExternal = true;
            this.mEnableExternal = true;
            this.sendEnableMsg(true, 1, packageName);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean enable(String packageName) throws RemoteException {
        boolean callerSystem;
        int callingUid = Binder.getCallingUid();
        boolean bl = callerSystem = UserHandle.getAppId(callingUid) == 1000;
        if (this.isBluetoothDisallowed()) {
            Slog.d(TAG, "enable(): not enabling - bluetooth disallowed");
            return false;
        }
        if (!callerSystem) {
            if (!this.checkIfCallerIsForegroundUser()) {
                Slog.w(TAG, "enable(): not allowed for non-active and non system user");
                return false;
            }
            this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH ADMIN permission");
            if (!this.isEnabled() && this.mPermissionReviewRequired && this.startConsentUiIfNeeded(packageName, callingUid, "android.bluetooth.adapter.action.REQUEST_ENABLE")) {
                return false;
            }
        }
        Slog.d(TAG, "enable(" + packageName + "):  mBluetooth =" + this.mBluetooth + " mBinding = " + this.mBinding + " mState = " + BluetoothAdapter.nameForState(this.mState));
        BroadcastReceiver broadcastReceiver = this.mReceiver;
        synchronized (broadcastReceiver) {
            this.mQuietEnableExternal = false;
            this.mEnableExternal = true;
            this.sendEnableMsg(false, 1, packageName);
        }
        Slog.d(TAG, "enable returning");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean disable(String packageName, boolean persist) throws RemoteException {
        boolean callerSystem;
        int callingUid = Binder.getCallingUid();
        boolean bl = callerSystem = UserHandle.getAppId(callingUid) == 1000;
        if (!callerSystem) {
            if (!this.checkIfCallerIsForegroundUser()) {
                Slog.w(TAG, "disable(): not allowed for non-active and non system user");
                return false;
            }
            this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH ADMIN permission");
            if (this.isEnabled() && this.mPermissionReviewRequired && this.startConsentUiIfNeeded(packageName, callingUid, "android.bluetooth.adapter.action.REQUEST_DISABLE")) {
                return false;
            }
        }
        Slog.d(TAG, "disable(): mBluetooth = " + this.mBluetooth + " mBinding = " + this.mBinding);
        BroadcastReceiver broadcastReceiver = this.mReceiver;
        synchronized (broadcastReceiver) {
            if (persist) {
                this.persistBluetoothSetting(0);
            }
            this.mEnableExternal = false;
            this.sendDisableMsg(1, packageName);
        }
        return true;
    }

    private boolean startConsentUiIfNeeded(String packageName, int callingUid, String intentAction) throws RemoteException {
        if (this.checkBluetoothPermissionWhenPermissionReviewRequired()) {
            return false;
        }
        try {
            ApplicationInfo applicationInfo = this.mContext.getPackageManager().getApplicationInfoAsUser(packageName, 0x10000000, UserHandle.getUserId(callingUid));
            if (applicationInfo.uid != callingUid) {
                throw new SecurityException("Package " + packageName + " not in uid " + callingUid);
            }
            Intent intent = new Intent(intentAction);
            intent.putExtra("android.intent.extra.PACKAGE_NAME", packageName);
            intent.setFlags(0x10800000);
            try {
                this.mContext.startActivity(intent);
            }
            catch (ActivityNotFoundException e) {
                Slog.e(TAG, "Intent to handle action " + intentAction + " missing");
                return false;
            }
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    private boolean checkBluetoothPermissionWhenPermissionReviewRequired() {
        if (!this.mPermissionReviewRequired) {
            return false;
        }
        int result = this.mContext.checkCallingPermission("android.permission.MANAGE_BLUETOOTH_WHEN_PERMISSION_REVIEW_REQUIRED");
        return result == 0;
    }

    public void unbindAndFinish() {
        Slog.d(TAG, "unbindAndFinish(): " + this.mBluetooth + " mBinding = " + this.mBinding + " mUnbinding = " + this.mUnbinding);
        try {
            this.mBluetoothLock.writeLock().lock();
            if (this.mUnbinding) {
                return;
            }
            this.mUnbinding = true;
            this.mHandler.removeMessages(60);
            this.mHandler.removeMessages(401);
            if (this.mBluetooth != null) {
                try {
                    this.mBluetooth.unregisterCallback(this.mBluetoothCallback);
                }
                catch (RemoteException re) {
                    Slog.e(TAG, "Unable to unregister BluetoothCallback", re);
                }
                this.mBluetoothBinder = null;
                this.mBluetooth = null;
                this.mContext.unbindService(this.mConnection);
                this.mUnbinding = false;
                this.mBinding = false;
            } else {
                this.mUnbinding = false;
            }
            this.mBluetoothGatt = null;
        }
        finally {
            this.mBluetoothLock.writeLock().unlock();
        }
    }

    @Override
    public IBluetoothGatt getBluetoothGatt() {
        return this.mBluetoothGatt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean bindBluetoothProfileService(int bluetoothProfile, IBluetoothProfileServiceConnection proxy) {
        if (!this.mEnable) {
            Slog.d(TAG, "Trying to bind to profile: " + bluetoothProfile + ", while Bluetooth was disabled");
            return false;
        }
        Map<Integer, ProfileServiceConnections> map = this.mProfileServices;
        synchronized (map) {
            ProfileServiceConnections psc = this.mProfileServices.get(new Integer(bluetoothProfile));
            if (psc == null) {
                Slog.d(TAG, "Creating new ProfileServiceConnections object for profile: " + bluetoothProfile);
                if (bluetoothProfile != 1) {
                    return false;
                }
                Intent intent = new Intent(IBluetoothHeadset.class.getName());
                psc = new ProfileServiceConnections(intent);
                if (!psc.bindService()) {
                    return false;
                }
                this.mProfileServices.put(new Integer(bluetoothProfile), psc);
            }
        }
        Message addProxyMsg = this.mHandler.obtainMessage(400);
        addProxyMsg.arg1 = bluetoothProfile;
        addProxyMsg.obj = proxy;
        this.mHandler.sendMessageDelayed(addProxyMsg, 100L);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbindBluetoothProfileService(int bluetoothProfile, IBluetoothProfileServiceConnection proxy) {
        Map<Integer, ProfileServiceConnections> map = this.mProfileServices;
        synchronized (map) {
            ProfileServiceConnections psc = this.mProfileServices.get(new Integer(bluetoothProfile));
            if (psc == null) {
                return;
            }
            psc.removeProxy(proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbindAllBluetoothProfileServices() {
        Map<Integer, ProfileServiceConnections> map = this.mProfileServices;
        synchronized (map) {
            for (Integer i : this.mProfileServices.keySet()) {
                ProfileServiceConnections psc = this.mProfileServices.get(i);
                try {
                    this.mContext.unbindService(psc);
                }
                catch (IllegalArgumentException e) {
                    Slog.e(TAG, "Unable to unbind service with intent: " + psc.mIntent, e);
                }
                psc.removeAllProxies();
            }
            this.mProfileServices.clear();
        }
    }

    public void handleOnBootPhase() {
        Slog.d(TAG, "Bluetooth boot completed");
        UserManagerInternal userManagerInternal = LocalServices.getService(UserManagerInternal.class);
        userManagerInternal.addUserRestrictionsListener(this.mUserRestrictionsListener);
        boolean isBluetoothDisallowed = this.isBluetoothDisallowed();
        if (isBluetoothDisallowed) {
            return;
        }
        if (this.mEnableExternal && this.isBluetoothPersistedStateOnBluetooth()) {
            Slog.d(TAG, "Auto-enabling Bluetooth.");
            this.sendEnableMsg(this.mQuietEnableExternal, 6, this.mContext.getPackageName());
        } else if (!this.isNameAndAddressSet()) {
            Slog.d(TAG, "Getting adapter name and address");
            Message getMsg = this.mHandler.obtainMessage(200);
            this.mHandler.sendMessage(getMsg);
        }
    }

    public void handleOnSwitchUser(int userHandle) {
        Slog.d(TAG, "User " + userHandle + " switched");
        this.mHandler.obtainMessage(300, userHandle, 0).sendToTarget();
    }

    public void handleOnUnlockUser(int userHandle) {
        Slog.d(TAG, "User " + userHandle + " unlocked");
        this.mHandler.obtainMessage(301, userHandle, 0).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBluetoothStateCallback(boolean isUp) {
        try {
            int n = this.mStateChangeCallbacks.beginBroadcast();
            Slog.d(TAG, "Broadcasting onBluetoothStateChange(" + isUp + ") to " + n + " receivers.");
            for (int i = 0; i < n; ++i) {
                try {
                    this.mStateChangeCallbacks.getBroadcastItem(i).onBluetoothStateChange(isUp);
                    continue;
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "Unable to call onBluetoothStateChange() on callback #" + i, e);
                }
            }
        }
        finally {
            this.mStateChangeCallbacks.finishBroadcast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBluetoothServiceUpCallback() {
        try {
            int n = this.mCallbacks.beginBroadcast();
            Slog.d(TAG, "Broadcasting onBluetoothServiceUp() to " + n + " receivers.");
            for (int i = 0; i < n; ++i) {
                try {
                    this.mCallbacks.getBroadcastItem(i).onBluetoothServiceUp(this.mBluetooth);
                    continue;
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "Unable to call onBluetoothServiceUp() on callback #" + i, e);
                }
            }
        }
        finally {
            this.mCallbacks.finishBroadcast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBluetoothServiceDownCallback() {
        try {
            int n = this.mCallbacks.beginBroadcast();
            Slog.d(TAG, "Broadcasting onBluetoothServiceDown() to " + n + " receivers.");
            for (int i = 0; i < n; ++i) {
                try {
                    this.mCallbacks.getBroadcastItem(i).onBluetoothServiceDown();
                    continue;
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "Unable to call onBluetoothServiceDown() on callback #" + i, e);
                }
            }
        }
        finally {
            this.mCallbacks.finishBroadcast();
        }
    }

    @Override
    public String getAddress() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (Binder.getCallingUid() != 1000 && !this.checkIfCallerIsForegroundUser()) {
            Slog.w(TAG, "getAddress(): not allowed for non-active and non system user");
            return null;
        }
        if (this.mContext.checkCallingOrSelfPermission("android.permission.LOCAL_MAC_ADDRESS") != 0) {
            return "02:00:00:00:00:00";
        }
        try {
            this.mBluetoothLock.readLock().lock();
            if (this.mBluetooth != null) {
                String string2 = this.mBluetooth.getAddress();
                return string2;
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "getAddress(): Unable to retrieve address remotely. Returning cached address", e);
        }
        finally {
            this.mBluetoothLock.readLock().unlock();
        }
        return this.mAddress;
    }

    @Override
    public String getName() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (Binder.getCallingUid() != 1000 && !this.checkIfCallerIsForegroundUser()) {
            Slog.w(TAG, "getName(): not allowed for non-active and non system user");
            return null;
        }
        try {
            this.mBluetoothLock.readLock().lock();
            if (this.mBluetooth != null) {
                String string2 = this.mBluetooth.getName();
                return string2;
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "getName(): Unable to retrieve name remotely. Returning cached name", e);
        }
        finally {
            this.mBluetoothLock.readLock().unlock();
        }
        return this.mName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEnable(boolean quietMode) {
        block12: {
            this.mQuietEnable = quietMode;
            try {
                this.mBluetoothLock.writeLock().lock();
                if (this.mBluetooth == null && !this.mBinding) {
                    Message timeoutMsg = this.mHandler.obtainMessage(100);
                    this.mHandler.sendMessageDelayed(timeoutMsg, 3000L);
                    Intent i = new Intent(IBluetooth.class.getName());
                    if (!this.doBind(i, this.mConnection, 65, UserHandle.CURRENT)) {
                        this.mHandler.removeMessages(100);
                    } else {
                        this.mBinding = true;
                    }
                    break block12;
                }
                if (this.mBluetooth == null) break block12;
                try {
                    if (!this.mQuietEnable) {
                        if (!this.mBluetooth.enable()) {
                            Slog.e(TAG, "IBluetooth.enable() returned false");
                        }
                    } else if (!this.mBluetooth.enableNoAutoConnect()) {
                        Slog.e(TAG, "IBluetooth.enableNoAutoConnect() returned false");
                    }
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "Unable to call enable()", e);
                }
            }
            finally {
                this.mBluetoothLock.writeLock().unlock();
            }
        }
    }

    boolean doBind(Intent intent, ServiceConnection conn, int flags, UserHandle user) {
        ComponentName comp = intent.resolveSystemService(this.mContext.getPackageManager(), 0);
        intent.setComponent(comp);
        if (comp == null || !this.mContext.bindServiceAsUser(intent, conn, flags, user)) {
            Slog.e(TAG, "Fail to bind to: " + intent);
            return false;
        }
        return true;
    }

    private void handleDisable() {
        try {
            this.mBluetoothLock.readLock().lock();
            if (this.mBluetooth != null) {
                Slog.d(TAG, "Sending off request.");
                if (!this.mBluetooth.disable()) {
                    Slog.e(TAG, "IBluetooth.disable() returned false");
                }
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Unable to call disable()", e);
        }
        finally {
            this.mBluetoothLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkIfCallerIsForegroundUser() {
        int callingUser = UserHandle.getCallingUserId();
        int callingUid = Binder.getCallingUid();
        long callingIdentity = Binder.clearCallingIdentity();
        UserManager um = (UserManager)this.mContext.getSystemService("user");
        UserInfo ui = um.getProfileParent(callingUser);
        int parentUser = ui != null ? ui.id : -10000;
        int callingAppId = UserHandle.getAppId(callingUid);
        boolean valid = false;
        try {
            int foregroundUser = ActivityManager.getCurrentUser();
            boolean bl = valid = callingUser == foregroundUser || parentUser == foregroundUser || callingAppId == 1027 || callingAppId == this.mSystemUiUid;
            if (!valid) {
                Slog.d(TAG, "checkIfCallerIsForegroundUser: valid=" + valid + " callingUser=" + callingUser + " parentUser=" + parentUser + " foregroundUser=" + foregroundUser);
            }
        }
        finally {
            Binder.restoreCallingIdentity(callingIdentity);
        }
        return valid;
    }

    private void sendBleStateChanged(int prevState, int newState) {
        Slog.d(TAG, "Sending BLE State Change: " + BluetoothAdapter.nameForState(prevState) + " > " + BluetoothAdapter.nameForState(newState));
        Intent intent = new Intent("android.bluetooth.adapter.action.BLE_STATE_CHANGED");
        intent.putExtra("android.bluetooth.adapter.extra.PREVIOUS_STATE", prevState);
        intent.putExtra("android.bluetooth.adapter.extra.STATE", newState);
        intent.addFlags(0x4000000);
        this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL, BLUETOOTH_PERM);
    }

    private void bluetoothStateChangeHandler(int prevState, int newState) {
        boolean isStandardBroadcast = true;
        if (prevState == newState) {
            return;
        }
        if (newState == 15 || newState == 10) {
            boolean intermediate_off;
            boolean bl = intermediate_off = prevState == 13 && newState == 15;
            if (newState == 10) {
                Slog.d(TAG, "Bluetooth is complete send Service Down");
                this.sendBluetoothServiceDownCallback();
                this.unbindAndFinish();
                this.sendBleStateChanged(prevState, newState);
                isStandardBroadcast = false;
            } else if (!intermediate_off) {
                Slog.d(TAG, "Bluetooth is in LE only mode");
                if (this.mBluetoothGatt != null || !this.mContext.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
                    this.continueFromBleOnState();
                } else {
                    Slog.d(TAG, "Binding Bluetooth GATT service");
                    Intent i = new Intent(IBluetoothGatt.class.getName());
                    this.doBind(i, this.mConnection, 65, UserHandle.CURRENT);
                }
                this.sendBleStateChanged(prevState, newState);
                isStandardBroadcast = false;
            } else if (intermediate_off) {
                Slog.d(TAG, "Intermediate off, back to LE only mode");
                this.sendBleStateChanged(prevState, newState);
                this.sendBluetoothStateCallback(false);
                newState = 10;
                this.sendBrEdrDownCallback();
            }
        } else if (newState == 12) {
            boolean isUp = newState == 12;
            this.sendBluetoothStateCallback(isUp);
            this.sendBleStateChanged(prevState, newState);
        } else if (newState == 14 || newState == 16) {
            this.sendBleStateChanged(prevState, newState);
            isStandardBroadcast = false;
        } else if (newState == 11 || newState == 13) {
            this.sendBleStateChanged(prevState, newState);
        }
        if (isStandardBroadcast) {
            if (prevState == 15) {
                prevState = 10;
            }
            Intent intent = new Intent("android.bluetooth.adapter.action.STATE_CHANGED");
            intent.putExtra("android.bluetooth.adapter.extra.PREVIOUS_STATE", prevState);
            intent.putExtra("android.bluetooth.adapter.extra.STATE", newState);
            intent.addFlags(0x4000000);
            this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL, BLUETOOTH_PERM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForOnOff(boolean on, boolean off) {
        for (int i = 0; i < 10; ++i) {
            try {
                this.mBluetoothLock.readLock().lock();
                if (this.mBluetooth == null) break;
                if (on) {
                    if (this.mBluetooth.getState() == 12) {
                        boolean bl = true;
                        return bl;
                    }
                } else if (off) {
                    if (this.mBluetooth.getState() == 10) {
                        boolean bl = true;
                        return bl;
                    }
                } else if (this.mBluetooth.getState() != 12) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (RemoteException e) {
                Slog.e(TAG, "getState()", e);
                break;
            }
            finally {
                this.mBluetoothLock.readLock().unlock();
            }
            if (on || off) {
                SystemClock.sleep(300L);
                continue;
            }
            SystemClock.sleep(50L);
        }
        Slog.e(TAG, "waitForOnOff time out");
        return false;
    }

    private void sendDisableMsg(int reason, String packageName) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2));
        this.addActiveLog(reason, packageName, false);
    }

    private void sendEnableMsg(boolean quietMode, int reason, String packageName) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, quietMode ? 1 : 0, 0));
        this.addActiveLog(reason, packageName, true);
        this.mLastEnabledTime = SystemClock.elapsedRealtime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addActiveLog(int reason, String packageName, boolean enable) {
        LinkedList<ActiveLog> linkedList = this.mActiveLogs;
        synchronized (linkedList) {
            if (this.mActiveLogs.size() > 20) {
                this.mActiveLogs.remove();
            }
            this.mActiveLogs.add(new ActiveLog(reason, packageName, enable, System.currentTimeMillis()));
        }
        int state = enable ? 1 : 2;
        StatsLog.write_non_chained(67, Binder.getCallingUid(), null, state, reason, packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCrashLog() {
        LinkedList<Long> linkedList = this.mCrashTimestamps;
        synchronized (linkedList) {
            if (this.mCrashTimestamps.size() == 100) {
                this.mCrashTimestamps.removeFirst();
            }
            this.mCrashTimestamps.add(System.currentTimeMillis());
            ++this.mCrashes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverBluetoothServiceFromError(boolean clearBle) {
        Slog.e(TAG, "recoverBluetoothServiceFromError");
        try {
            this.mBluetoothLock.readLock().lock();
            if (this.mBluetooth != null) {
                this.mBluetooth.unregisterCallback(this.mBluetoothCallback);
            }
        }
        catch (RemoteException re) {
            Slog.e(TAG, "Unable to unregister", re);
        }
        finally {
            this.mBluetoothLock.readLock().unlock();
        }
        SystemClock.sleep(500L);
        this.addActiveLog(5, this.mContext.getPackageName(), false);
        this.handleDisable();
        this.waitForOnOff(false, true);
        this.sendBluetoothServiceDownCallback();
        try {
            this.mBluetoothLock.writeLock().lock();
            if (this.mBluetooth != null) {
                this.mBluetooth = null;
                this.mContext.unbindService(this.mConnection);
            }
            this.mBluetoothGatt = null;
        }
        finally {
            this.mBluetoothLock.writeLock().unlock();
        }
        this.mHandler.removeMessages(60);
        this.mState = 10;
        if (clearBle) {
            this.clearBleApps();
        }
        this.mEnable = false;
        if (this.mErrorRecoveryRetryCounter++ < 6) {
            Message restartMsg = this.mHandler.obtainMessage(42);
            this.mHandler.sendMessageDelayed(restartMsg, 3000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBluetoothDisallowed() {
        long callingIdentity = Binder.clearCallingIdentity();
        try {
            boolean bl = this.mContext.getSystemService(UserManager.class).hasUserRestriction("no_bluetooth", UserHandle.SYSTEM);
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(callingIdentity);
        }
    }

    private void updateOppLauncherComponentState(int userId, boolean bluetoothSharingDisallowed) {
        ComponentName oppLauncherComponent = new ComponentName("com.android.bluetooth", "com.android.bluetooth.opp.BluetoothOppLauncherActivity");
        int newState = bluetoothSharingDisallowed ? 2 : 0;
        try {
            IPackageManager imp = AppGlobals.getPackageManager();
            imp.setComponentEnabledSetting(oppLauncherComponent, newState, 1, userId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        boolean protoOut;
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, writer)) {
            return;
        }
        String errorMsg = null;
        boolean bl = protoOut = args.length > 0 && args[0].startsWith("--proto");
        if (!protoOut) {
            writer.println("Bluetooth Status");
            writer.println("  enabled: " + this.isEnabled());
            writer.println("  state: " + BluetoothAdapter.nameForState(this.mState));
            writer.println("  address: " + this.mAddress);
            writer.println("  name: " + this.mName);
            if (this.mEnable) {
                long onDuration = SystemClock.elapsedRealtime() - this.mLastEnabledTime;
                String onDurationString = String.format(Locale.US, "%02d:%02d:%02d.%03d", (int)(onDuration / 3600000L), (int)(onDuration / 60000L % 60L), (int)(onDuration / 1000L % 60L), (int)(onDuration % 1000L));
                writer.println("  time since enabled: " + onDurationString);
            }
            if (this.mActiveLogs.size() == 0) {
                writer.println("\nBluetooth never enabled!");
            } else {
                writer.println("\nEnable log:");
                for (ActiveLog log : this.mActiveLogs) {
                    writer.println("  " + log);
                }
            }
            writer.println("\nBluetooth crashed " + this.mCrashes + " time" + (this.mCrashes == 1 ? "" : "s"));
            if (this.mCrashes == 100) {
                writer.println("(last 100)");
            }
            for (Long time : this.mCrashTimestamps) {
                writer.println("  " + BluetoothManagerService.timeToLog(time));
            }
            writer.println("\n" + this.mBleApps.size() + " BLE app" + (this.mBleApps.size() == 1 ? "" : "s") + "registered");
            for (ClientDeathRecipient app : this.mBleApps.values()) {
                writer.println("  " + app.getPackageName());
            }
            writer.println("");
            writer.flush();
            if (args.length == 0) {
                args = new String[]{"--print"};
            }
        }
        if (this.mBluetoothBinder == null) {
            errorMsg = "Bluetooth Service not connected";
        } else {
            try {
                this.mBluetoothBinder.dump(fd, args);
            }
            catch (RemoteException re) {
                errorMsg = "RemoteException while dumping Bluetooth Service";
            }
        }
        if (errorMsg != null) {
            if (protoOut) {
                return;
            }
            writer.println(errorMsg);
        }
    }

    private static String getEnableDisableReasonString(int reason) {
        switch (reason) {
            case 1: {
                return "APPLICATION_REQUEST";
            }
            case 2: {
                return "AIRPLANE_MODE";
            }
            case 3: {
                return "DISALLOWED";
            }
            case 4: {
                return "RESTARTED";
            }
            case 5: {
                return "START_ERROR";
            }
            case 6: {
                return "SYSTEM_BOOT";
            }
            case 7: {
                return "CRASH";
            }
            case 8: {
                return "USER_SWITCH";
            }
            case 9: {
                return "RESTORE_USER_SETTING";
            }
        }
        return "UNKNOWN[" + reason + "]";
    }

    static /* synthetic */ boolean access$2400(BluetoothManagerService x0) {
        return x0.mBinding;
    }

    static /* synthetic */ BluetoothServiceConnection access$2500(BluetoothManagerService x0) {
        return x0.mConnection;
    }

    static /* synthetic */ boolean access$2402(BluetoothManagerService x0, boolean x1) {
        x0.mBinding = x1;
        return x0.mBinding;
    }

    static /* synthetic */ boolean access$1300(BluetoothManagerService x0) {
        return x0.mEnable;
    }

    static /* synthetic */ boolean access$2602(BluetoothManagerService x0, boolean x1) {
        x0.mQuietEnable = x1;
        return x0.mQuietEnable;
    }

    static /* synthetic */ boolean access$2600(BluetoothManagerService x0) {
        return x0.mQuietEnable;
    }

    static /* synthetic */ void access$2700(BluetoothManagerService x0, boolean x1) {
        x0.handleEnable(x1);
    }

    static /* synthetic */ boolean access$2800(BluetoothManagerService x0, boolean x1, boolean x2) {
        return x0.waitForOnOff(x1, x2);
    }

    static /* synthetic */ void access$2900(BluetoothManagerService x0) {
        x0.handleDisable();
    }

    static /* synthetic */ boolean access$1502(BluetoothManagerService x0, boolean x1) {
        x0.mQuietEnableExternal = x1;
        return x0.mQuietEnableExternal;
    }

    static /* synthetic */ RemoteCallbackList access$3000(BluetoothManagerService x0) {
        return x0.mCallbacks;
    }

    static /* synthetic */ RemoteCallbackList access$3100(BluetoothManagerService x0) {
        return x0.mStateChangeCallbacks;
    }

    static /* synthetic */ Map access$3200(BluetoothManagerService x0) {
        return x0.mProfileServices;
    }

    static /* synthetic */ IBluetoothGatt access$3402(BluetoothManagerService x0, IBluetoothGatt x1) {
        x0.mBluetoothGatt = x1;
        return x0.mBluetoothGatt;
    }

    static /* synthetic */ void access$3500(BluetoothManagerService x0) {
        x0.continueFromBleOnState();
    }

    static /* synthetic */ IBinder access$3602(BluetoothManagerService x0, IBinder x1) {
        x0.mBluetoothBinder = x1;
        return x0.mBluetoothBinder;
    }

    static /* synthetic */ IBluetooth access$1002(BluetoothManagerService x0, IBluetooth x1) {
        x0.mBluetooth = x1;
        return x0.mBluetooth;
    }

    static /* synthetic */ boolean access$3700(BluetoothManagerService x0) {
        return x0.isNameAndAddressSet();
    }

    static /* synthetic */ IBluetoothCallback access$3800(BluetoothManagerService x0) {
        return x0.mBluetoothCallback;
    }

    static /* synthetic */ void access$3900(BluetoothManagerService x0) {
        x0.sendBluetoothServiceUpCallback();
    }

    static /* synthetic */ int access$4002(BluetoothManagerService x0, int x1) {
        x0.mState = x1;
        return x0.mState;
    }

    static /* synthetic */ void access$4100(BluetoothManagerService x0, int x1, int x2) {
        x0.bluetoothStateChangeHandler(x1, x2);
    }

    static /* synthetic */ void access$4200(BluetoothManagerService x0, boolean x1) {
        x0.recoverBluetoothServiceFromError(x1);
    }

    static /* synthetic */ int access$4300(BluetoothManagerService x0) {
        return x0.mErrorRecoveryRetryCounter;
    }

    static /* synthetic */ int access$4302(BluetoothManagerService x0, int x1) {
        x0.mErrorRecoveryRetryCounter = x1;
        return x0.mErrorRecoveryRetryCounter;
    }

    static /* synthetic */ void access$4400(BluetoothManagerService x0) {
        x0.addCrashLog();
    }

    static /* synthetic */ void access$4500(BluetoothManagerService x0) {
        x0.sendBluetoothServiceDownCallback();
    }

    static /* synthetic */ int access$4000(BluetoothManagerService x0) {
        return x0.mState;
    }

    static /* synthetic */ boolean access$4602(BluetoothManagerService x0, boolean x1) {
        x0.mUnbinding = x1;
        return x0.mUnbinding;
    }

    static /* synthetic */ void access$4700(BluetoothManagerService x0) {
        x0.unbindAllBluetoothProfileServices();
    }

    private class BluetoothHandler
    extends Handler {
        boolean mGetNameAddressOnly;

        BluetoothHandler(Looper looper) {
            super(looper);
            this.mGetNameAddressOnly = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 200: {
                    Slog.d("BluetoothManagerService", "MESSAGE_GET_NAME_AND_ADDRESS");
                    try {
                        BluetoothManagerService.access$900(BluetoothManagerService.this).writeLock().lock();
                        if (BluetoothManagerService.access$1000(BluetoothManagerService.this) == null && !BluetoothManagerService.access$2400(BluetoothManagerService.this)) {
                            Slog.d("BluetoothManagerService", "Binding to service to get name and address");
                            this.mGetNameAddressOnly = true;
                            timeoutMsg = BluetoothManagerService.access$200(BluetoothManagerService.this).obtainMessage(100);
                            BluetoothManagerService.access$200(BluetoothManagerService.this).sendMessageDelayed(timeoutMsg, 3000L);
                            i = new Intent(IBluetooth.class.getName());
                            if (!BluetoothManagerService.this.doBind(i, BluetoothManagerService.access$2500(BluetoothManagerService.this), 65, UserHandle.CURRENT)) {
                                BluetoothManagerService.access$200(BluetoothManagerService.this).removeMessages(100);
                                break;
                            }
                            BluetoothManagerService.access$2402(BluetoothManagerService.this, true);
                            break;
                        }
                        if (BluetoothManagerService.access$1000(BluetoothManagerService.this) == null) break;
                        try {
                            BluetoothManagerService.access$1700(BluetoothManagerService.this, BluetoothManagerService.access$1000(BluetoothManagerService.this).getName(), BluetoothManagerService.access$1000(BluetoothManagerService.this).getAddress());
                        }
                        catch (RemoteException re) {
                            Slog.e("BluetoothManagerService", "Unable to grab names", re);
                        }
                        if (this.mGetNameAddressOnly && !BluetoothManagerService.access$1300(BluetoothManagerService.this)) {
                            BluetoothManagerService.this.unbindAndFinish();
                        }
                        this.mGetNameAddressOnly = false;
                        break;
                    }
                    finally {
                        BluetoothManagerService.access$900(BluetoothManagerService.this).writeLock().unlock();
                    }
                }
                case 1: {
                    Slog.d("BluetoothManagerService", "MESSAGE_ENABLE(" + msg.arg1 + "): mBluetooth = " + BluetoothManagerService.access$1000(BluetoothManagerService.this));
                    BluetoothManagerService.access$200(BluetoothManagerService.this).removeMessages(42);
                    BluetoothManagerService.access$1302(BluetoothManagerService.this, true);
                    try {
                        BluetoothManagerService.access$900(BluetoothManagerService.this).readLock().lock();
                        if (BluetoothManagerService.access$1000(BluetoothManagerService.this) != null && (state = BluetoothManagerService.access$1000(BluetoothManagerService.this).getState()) == 15) {
                            Slog.w("BluetoothManagerService", "BT Enable in BLE_ON State, going to ON");
                            BluetoothManagerService.access$1000(BluetoothManagerService.this).onLeServiceUp();
                            BluetoothManagerService.access$800(BluetoothManagerService.this, 1);
                            break;
                        }
                    }
                    catch (RemoteException e) {
                        Slog.e("BluetoothManagerService", "", e);
                    }
                    finally {
                        BluetoothManagerService.access$900(BluetoothManagerService.this).readLock().unlock();
                    }
                    BluetoothManagerService.access$2602(BluetoothManagerService.this, msg.arg1 == 1);
                    if (BluetoothManagerService.access$1000(BluetoothManagerService.this) == null) {
                        BluetoothManagerService.access$2700(BluetoothManagerService.this, BluetoothManagerService.access$2600(BluetoothManagerService.this));
                        break;
                    }
                    BluetoothManagerService.access$2800(BluetoothManagerService.this, false, true);
                    restartMsg = BluetoothManagerService.access$200(BluetoothManagerService.this).obtainMessage(42);
                    BluetoothManagerService.access$200(BluetoothManagerService.this).sendMessageDelayed(restartMsg, 400L);
                    break;
                }
                case 2: {
                    Slog.d("BluetoothManagerService", "MESSAGE_DISABLE: mBluetooth = " + BluetoothManagerService.access$1000(BluetoothManagerService.this));
                    BluetoothManagerService.access$200(BluetoothManagerService.this).removeMessages(42);
                    if (BluetoothManagerService.access$1300(BluetoothManagerService.this) && BluetoothManagerService.access$1000(BluetoothManagerService.this) != null) {
                        BluetoothManagerService.access$2800(BluetoothManagerService.this, true, false);
                        BluetoothManagerService.access$1302(BluetoothManagerService.this, false);
                        BluetoothManagerService.access$2900(BluetoothManagerService.this);
                        BluetoothManagerService.access$2800(BluetoothManagerService.this, false, false);
                        break;
                    }
                    BluetoothManagerService.access$1302(BluetoothManagerService.this, false);
                    BluetoothManagerService.access$2900(BluetoothManagerService.this);
                    break;
                }
                case 500: {
                    if (msg.arg1 == 0 && BluetoothManagerService.access$1300(BluetoothManagerService.this)) {
                        Slog.d("BluetoothManagerService", "Restore Bluetooth state to disabled");
                        BluetoothManagerService.access$800(BluetoothManagerService.this, 0);
                        BluetoothManagerService.access$1402(BluetoothManagerService.this, false);
                        BluetoothManagerService.access$500(BluetoothManagerService.this, 9, BluetoothManagerService.access$400(BluetoothManagerService.this).getPackageName());
                        break;
                    }
                    if (msg.arg1 != 1 || BluetoothManagerService.access$1300(BluetoothManagerService.this)) break;
                    Slog.d("BluetoothManagerService", "Restore Bluetooth state to enabled");
                    BluetoothManagerService.access$1502(BluetoothManagerService.this, false);
                    BluetoothManagerService.access$1402(BluetoothManagerService.this, true);
                    BluetoothManagerService.access$1600(BluetoothManagerService.this, false, 9, BluetoothManagerService.access$400(BluetoothManagerService.this).getPackageName());
                    break;
                }
                case 20: {
                    callback = (IBluetoothManagerCallback)msg.obj;
                    BluetoothManagerService.access$3000(BluetoothManagerService.this).register(callback);
                    break;
                }
                case 21: {
                    callback = (IBluetoothManagerCallback)msg.obj;
                    BluetoothManagerService.access$3000(BluetoothManagerService.this).unregister(callback);
                    break;
                }
                case 30: {
                    callback = (IBluetoothStateChangeCallback)msg.obj;
                    BluetoothManagerService.access$3100(BluetoothManagerService.this).register(callback);
                    break;
                }
                case 31: {
                    callback = (IBluetoothStateChangeCallback)msg.obj;
                    BluetoothManagerService.access$3100(BluetoothManagerService.this).unregister(callback);
                    break;
                }
                case 400: {
                    psc = (ProfileServiceConnections)BluetoothManagerService.access$3200(BluetoothManagerService.this).get(msg.arg1);
                    if (psc == null) break;
                    proxy = (IBluetoothProfileServiceConnection)msg.obj;
                    ProfileServiceConnections.access$3300(psc, proxy);
                    break;
                }
                case 401: {
                    psc = (ProfileServiceConnections)msg.obj;
                    this.removeMessages(401, msg.obj);
                    if (psc == null) break;
                    ProfileServiceConnections.access$2000(psc);
                    break;
                }
                case 40: {
                    Slog.d("BluetoothManagerService", "MESSAGE_BLUETOOTH_SERVICE_CONNECTED: " + msg.arg1);
                    service = (IBinder)msg.obj;
                    try {
                        BluetoothManagerService.access$900(BluetoothManagerService.this).writeLock().lock();
                        if (msg.arg1 == 2) {
                            BluetoothManagerService.access$3402(BluetoothManagerService.this, IBluetoothGatt.Stub.asInterface(Binder.allowBlocking(service)));
                            BluetoothManagerService.access$3500(BluetoothManagerService.this);
                            break;
                        }
                        BluetoothManagerService.access$200(BluetoothManagerService.this).removeMessages(100);
                        BluetoothManagerService.access$2402(BluetoothManagerService.this, false);
                        BluetoothManagerService.access$3602(BluetoothManagerService.this, service);
                        BluetoothManagerService.access$1002(BluetoothManagerService.this, IBluetooth.Stub.asInterface(Binder.allowBlocking(service)));
                        if (!BluetoothManagerService.access$3700(BluetoothManagerService.this)) {
                            getMsg = BluetoothManagerService.access$200(BluetoothManagerService.this).obtainMessage(200);
                            BluetoothManagerService.access$200(BluetoothManagerService.this).sendMessage(getMsg);
                            if (this.mGetNameAddressOnly) {
                                return;
                            }
                        }
                        try {
                            BluetoothManagerService.access$1000(BluetoothManagerService.this).registerCallback(BluetoothManagerService.access$3800(BluetoothManagerService.this));
                        }
                        catch (RemoteException re) {
                            Slog.e("BluetoothManagerService", "Unable to register BluetoothCallback", re);
                        }
                        BluetoothManagerService.access$3900(BluetoothManagerService.this);
                        try {
                            if (!BluetoothManagerService.access$2600(BluetoothManagerService.this)) {
                                if (!BluetoothManagerService.access$1000(BluetoothManagerService.this).enable()) {
                                    Slog.e("BluetoothManagerService", "IBluetooth.enable() returned false");
                                }
                            } else if (!BluetoothManagerService.access$1000(BluetoothManagerService.this).enableNoAutoConnect()) {
                                Slog.e("BluetoothManagerService", "IBluetooth.enableNoAutoConnect() returned false");
                            }
                        }
                        catch (RemoteException e) {
                            Slog.e("BluetoothManagerService", "Unable to call enable()", e);
                        }
                    }
                    finally {
                        BluetoothManagerService.access$900(BluetoothManagerService.this).writeLock().unlock();
                    }
                    if (BluetoothManagerService.access$1300(BluetoothManagerService.this)) break;
                    BluetoothManagerService.access$2800(BluetoothManagerService.this, true, false);
                    BluetoothManagerService.access$2900(BluetoothManagerService.this);
                    BluetoothManagerService.access$2800(BluetoothManagerService.this, false, false);
                    break;
                }
                case 60: {
                    prevState = msg.arg1;
                    newState = msg.arg2;
                    Slog.d("BluetoothManagerService", "MESSAGE_BLUETOOTH_STATE_CHANGE: " + BluetoothAdapter.nameForState(prevState) + " > " + BluetoothAdapter.nameForState(newState));
                    BluetoothManagerService.access$4002(BluetoothManagerService.this, newState);
                    BluetoothManagerService.access$4100(BluetoothManagerService.this, prevState, newState);
                    if (prevState == 14 && newState == 10 && BluetoothManagerService.access$1000(BluetoothManagerService.this) != null && BluetoothManagerService.access$1300(BluetoothManagerService.this)) {
                        BluetoothManagerService.access$4200(BluetoothManagerService.this, false);
                    }
                    if (prevState == 11 && newState == 15 && BluetoothManagerService.access$1000(BluetoothManagerService.this) != null && BluetoothManagerService.access$1300(BluetoothManagerService.this)) {
                        BluetoothManagerService.access$4200(BluetoothManagerService.this, true);
                    }
                    if (prevState == 16 && newState == 10 && BluetoothManagerService.access$1300(BluetoothManagerService.this)) {
                        Slog.d("BluetoothManagerService", "Entering STATE_OFF but mEnabled is true; restarting.");
                        BluetoothManagerService.access$2800(BluetoothManagerService.this, false, true);
                        restartMsg = BluetoothManagerService.access$200(BluetoothManagerService.this).obtainMessage(42);
                        BluetoothManagerService.access$200(BluetoothManagerService.this).sendMessageDelayed(restartMsg, 400L);
                    }
                    if (newState != 12 && newState != 15 || BluetoothManagerService.access$4300(BluetoothManagerService.this) == 0) break;
                    Slog.w("BluetoothManagerService", "bluetooth is recovered from error");
                    BluetoothManagerService.access$4302(BluetoothManagerService.this, 0);
                    break;
                }
                case 41: {
                    Slog.e("BluetoothManagerService", "MESSAGE_BLUETOOTH_SERVICE_DISCONNECTED(" + msg.arg1 + ")");
                    try {
                        BluetoothManagerService.access$900(BluetoothManagerService.this).writeLock().lock();
                        if (msg.arg1 != 1) ** GOTO lbl228
                        if (BluetoothManagerService.access$1000(BluetoothManagerService.this) == null) break;
                        BluetoothManagerService.access$1002(BluetoothManagerService.this, null);
                        ** GOTO lbl238
lbl228:
                        // 1 sources

                        if (msg.arg1 == 2) {
                            BluetoothManagerService.access$3402(BluetoothManagerService.this, null);
                            break;
                        }
                        Slog.e("BluetoothManagerService", "Unknown argument for service disconnect!");
                        break;
                    }
                    finally {
                        BluetoothManagerService.access$900(BluetoothManagerService.this).writeLock().unlock();
                    }
lbl238:
                    // 1 sources

                    BluetoothManagerService.access$4400(BluetoothManagerService.this);
                    BluetoothManagerService.access$1200(BluetoothManagerService.this, 7, BluetoothManagerService.access$400(BluetoothManagerService.this).getPackageName(), false);
                    if (BluetoothManagerService.access$1300(BluetoothManagerService.this)) {
                        BluetoothManagerService.access$1302(BluetoothManagerService.this, false);
                        restartMsg = BluetoothManagerService.access$200(BluetoothManagerService.this).obtainMessage(42);
                        BluetoothManagerService.access$200(BluetoothManagerService.this).sendMessageDelayed(restartMsg, 200L);
                    }
                    BluetoothManagerService.access$4500(BluetoothManagerService.this);
                    if (BluetoothManagerService.access$4000(BluetoothManagerService.this) == 11 || BluetoothManagerService.access$4000(BluetoothManagerService.this) == 12) {
                        BluetoothManagerService.access$4100(BluetoothManagerService.this, 12, 13);
                        BluetoothManagerService.access$4002(BluetoothManagerService.this, 13);
                    }
                    if (BluetoothManagerService.access$4000(BluetoothManagerService.this) == 13) {
                        BluetoothManagerService.access$4100(BluetoothManagerService.this, 13, 10);
                    }
                    BluetoothManagerService.access$200(BluetoothManagerService.this).removeMessages(60);
                    BluetoothManagerService.access$4002(BluetoothManagerService.this, 10);
                    break;
                }
                case 42: {
                    Slog.d("BluetoothManagerService", "MESSAGE_RESTART_BLUETOOTH_SERVICE");
                    BluetoothManagerService.access$1302(BluetoothManagerService.this, true);
                    BluetoothManagerService.access$1200(BluetoothManagerService.this, 4, BluetoothManagerService.access$400(BluetoothManagerService.this).getPackageName(), true);
                    BluetoothManagerService.access$2700(BluetoothManagerService.this, BluetoothManagerService.access$2600(BluetoothManagerService.this));
                    break;
                }
                case 100: {
                    Slog.e("BluetoothManagerService", "MESSAGE_TIMEOUT_BIND");
                    BluetoothManagerService.access$900(BluetoothManagerService.this).writeLock().lock();
                    BluetoothManagerService.access$2402(BluetoothManagerService.this, false);
                    BluetoothManagerService.access$900(BluetoothManagerService.this).writeLock().unlock();
                    break;
                }
                case 101: {
                    Slog.e("BluetoothManagerService", "MESSAGE_TIMEOUT_UNBIND");
                    BluetoothManagerService.access$900(BluetoothManagerService.this).writeLock().lock();
                    BluetoothManagerService.access$4602(BluetoothManagerService.this, false);
                    BluetoothManagerService.access$900(BluetoothManagerService.this).writeLock().unlock();
                    break;
                }
                case 300: {
                    Slog.d("BluetoothManagerService", "MESSAGE_USER_SWITCHED");
                    BluetoothManagerService.access$200(BluetoothManagerService.this).removeMessages(300);
                    if (BluetoothManagerService.access$1000(BluetoothManagerService.this) == null || !BluetoothManagerService.this.isEnabled()) ** GOTO lbl341
                    try {
                        BluetoothManagerService.access$900(BluetoothManagerService.this).readLock().lock();
                        if (BluetoothManagerService.access$1000(BluetoothManagerService.this) != null) {
                            BluetoothManagerService.access$1000(BluetoothManagerService.this).unregisterCallback(BluetoothManagerService.access$3800(BluetoothManagerService.this));
                        }
                    }
                    catch (RemoteException re) {
                        Slog.e("BluetoothManagerService", "Unable to unregister", re);
                    }
                    finally {
                        BluetoothManagerService.access$900(BluetoothManagerService.this).readLock().unlock();
                    }
                    if (BluetoothManagerService.access$4000(BluetoothManagerService.this) == 13) {
                        BluetoothManagerService.access$4100(BluetoothManagerService.this, BluetoothManagerService.access$4000(BluetoothManagerService.this), 10);
                        BluetoothManagerService.access$4002(BluetoothManagerService.this, 10);
                    }
                    if (BluetoothManagerService.access$4000(BluetoothManagerService.this) == 10) {
                        BluetoothManagerService.access$4100(BluetoothManagerService.this, BluetoothManagerService.access$4000(BluetoothManagerService.this), 11);
                        BluetoothManagerService.access$4002(BluetoothManagerService.this, 11);
                    }
                    BluetoothManagerService.access$2800(BluetoothManagerService.this, true, false);
                    if (BluetoothManagerService.access$4000(BluetoothManagerService.this) == 11) {
                        BluetoothManagerService.access$4100(BluetoothManagerService.this, BluetoothManagerService.access$4000(BluetoothManagerService.this), 12);
                    }
                    BluetoothManagerService.access$4700(BluetoothManagerService.this);
                    BluetoothManagerService.access$1200(BluetoothManagerService.this, 8, BluetoothManagerService.access$400(BluetoothManagerService.this).getPackageName(), false);
                    BluetoothManagerService.access$2900(BluetoothManagerService.this);
                    BluetoothManagerService.access$4100(BluetoothManagerService.this, 12, 13);
                    didDisableTimeout = BluetoothManagerService.access$2800(BluetoothManagerService.this, false, true) == false;
                    BluetoothManagerService.access$4100(BluetoothManagerService.this, 13, 10);
                    BluetoothManagerService.access$4500(BluetoothManagerService.this);
                    try {
                        BluetoothManagerService.access$900(BluetoothManagerService.this).writeLock().lock();
                        if (BluetoothManagerService.access$1000(BluetoothManagerService.this) != null) {
                            BluetoothManagerService.access$1002(BluetoothManagerService.this, null);
                            BluetoothManagerService.access$400(BluetoothManagerService.this).unbindService(BluetoothManagerService.access$2500(BluetoothManagerService.this));
                        }
                        BluetoothManagerService.access$3402(BluetoothManagerService.this, null);
                    }
                    finally {
                        BluetoothManagerService.access$900(BluetoothManagerService.this).writeLock().unlock();
                    }
                    if (didDisableTimeout) {
                        SystemClock.sleep(3000L);
                    } else {
                        SystemClock.sleep(100L);
                    }
                    BluetoothManagerService.access$200(BluetoothManagerService.this).removeMessages(60);
                    BluetoothManagerService.access$4002(BluetoothManagerService.this, 10);
                    BluetoothManagerService.access$1200(BluetoothManagerService.this, 8, BluetoothManagerService.access$400(BluetoothManagerService.this).getPackageName(), true);
                    BluetoothManagerService.access$1302(BluetoothManagerService.this, true);
                    BluetoothManagerService.access$2700(BluetoothManagerService.this, BluetoothManagerService.access$2600(BluetoothManagerService.this));
                    break;
lbl341:
                    // 1 sources

                    if (!BluetoothManagerService.access$2400(BluetoothManagerService.this) && BluetoothManagerService.access$1000(BluetoothManagerService.this) == null) break;
                    userMsg = BluetoothManagerService.access$200(BluetoothManagerService.this).obtainMessage(300);
                    userMsg.arg2 = 1 + msg.arg2;
                    BluetoothManagerService.access$200(BluetoothManagerService.this).sendMessageDelayed(userMsg, 200L);
                    Slog.d("BluetoothManagerService", "Retry MESSAGE_USER_SWITCHED " + userMsg.arg2);
                    break;
                }
                case 301: {
                    Slog.d("BluetoothManagerService", "MESSAGE_USER_UNLOCKED");
                    BluetoothManagerService.access$200(BluetoothManagerService.this).removeMessages(300);
                    if (!BluetoothManagerService.access$1300(BluetoothManagerService.this) || BluetoothManagerService.access$2400(BluetoothManagerService.this) || BluetoothManagerService.access$1000(BluetoothManagerService.this) != null) break;
                    Slog.d("BluetoothManagerService", "Enabled but not bound; retrying after unlock");
                    BluetoothManagerService.access$2700(BluetoothManagerService.this, BluetoothManagerService.access$2600(BluetoothManagerService.this));
                }
            }
        }
    }

    private class BluetoothServiceConnection
    implements ServiceConnection {
        private BluetoothServiceConnection() {
        }

        @Override
        public void onServiceConnected(ComponentName componentName, IBinder service) {
            String name = componentName.getClassName();
            Slog.d(BluetoothManagerService.TAG, "BluetoothServiceConnection: " + name);
            Message msg = BluetoothManagerService.this.mHandler.obtainMessage(40);
            if (name.equals("com.android.bluetooth.btservice.AdapterService")) {
                msg.arg1 = 1;
            } else if (name.equals("com.android.bluetooth.gatt.GattService")) {
                msg.arg1 = 2;
            } else {
                Slog.e(BluetoothManagerService.TAG, "Unknown service connected: " + name);
                return;
            }
            msg.obj = service;
            BluetoothManagerService.this.mHandler.sendMessage(msg);
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            String name = componentName.getClassName();
            Slog.d(BluetoothManagerService.TAG, "BluetoothServiceConnection, disconnected: " + name);
            Message msg = BluetoothManagerService.this.mHandler.obtainMessage(41);
            if (name.equals("com.android.bluetooth.btservice.AdapterService")) {
                msg.arg1 = 1;
            } else if (name.equals("com.android.bluetooth.gatt.GattService")) {
                msg.arg1 = 2;
            } else {
                Slog.e(BluetoothManagerService.TAG, "Unknown service disconnected: " + name);
                return;
            }
            BluetoothManagerService.this.mHandler.sendMessage(msg);
        }
    }

    private final class ProfileServiceConnections
    implements ServiceConnection,
    IBinder.DeathRecipient {
        final RemoteCallbackList<IBluetoothProfileServiceConnection> mProxies = new RemoteCallbackList();
        IBinder mService = null;
        ComponentName mClassName = null;
        Intent mIntent;
        boolean mInvokingProxyCallbacks = false;

        ProfileServiceConnections(Intent intent) {
            this.mIntent = intent;
        }

        private boolean bindService() {
            if (this.mIntent != null && this.mService == null && BluetoothManagerService.this.doBind(this.mIntent, this, 0, UserHandle.CURRENT_OR_SELF)) {
                Message msg = BluetoothManagerService.this.mHandler.obtainMessage(401);
                msg.obj = this;
                BluetoothManagerService.this.mHandler.sendMessageDelayed(msg, 3000L);
                return true;
            }
            Slog.w(BluetoothManagerService.TAG, "Unable to bind with intent: " + this.mIntent);
            return false;
        }

        private void addProxy(IBluetoothProfileServiceConnection proxy) {
            this.mProxies.register(proxy);
            if (this.mService != null) {
                try {
                    proxy.onServiceConnected(this.mClassName, this.mService);
                }
                catch (RemoteException e) {
                    Slog.e(BluetoothManagerService.TAG, "Unable to connect to proxy", e);
                }
            } else if (!BluetoothManagerService.this.mHandler.hasMessages(401, this)) {
                Message msg = BluetoothManagerService.this.mHandler.obtainMessage(401);
                msg.obj = this;
                BluetoothManagerService.this.mHandler.sendMessage(msg);
            }
        }

        private void removeProxy(IBluetoothProfileServiceConnection proxy) {
            if (proxy != null) {
                if (this.mProxies.unregister(proxy)) {
                    try {
                        proxy.onServiceDisconnected(this.mClassName);
                    }
                    catch (RemoteException e) {
                        Slog.e(BluetoothManagerService.TAG, "Unable to disconnect proxy", e);
                    }
                }
            } else {
                Slog.w(BluetoothManagerService.TAG, "Trying to remove a null proxy");
            }
        }

        private void removeAllProxies() {
            this.onServiceDisconnected(this.mClassName);
            this.mProxies.kill();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName className, IBinder service) {
            BluetoothManagerService.this.mHandler.removeMessages(401, this);
            this.mService = service;
            this.mClassName = className;
            try {
                this.mService.linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                Slog.e(BluetoothManagerService.TAG, "Unable to linkToDeath", e);
            }
            if (this.mInvokingProxyCallbacks) {
                Slog.e(BluetoothManagerService.TAG, "Proxy callbacks already in progress.");
                return;
            }
            this.mInvokingProxyCallbacks = true;
            int n = this.mProxies.beginBroadcast();
            try {
                for (int i = 0; i < n; ++i) {
                    try {
                        this.mProxies.getBroadcastItem(i).onServiceConnected(className, service);
                        continue;
                    }
                    catch (RemoteException e) {
                        Slog.e(BluetoothManagerService.TAG, "Unable to connect to proxy", e);
                    }
                }
            }
            finally {
                this.mProxies.finishBroadcast();
                this.mInvokingProxyCallbacks = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceDisconnected(ComponentName className) {
            if (this.mService == null) {
                return;
            }
            this.mService.unlinkToDeath(this, 0);
            this.mService = null;
            this.mClassName = null;
            if (this.mInvokingProxyCallbacks) {
                Slog.e(BluetoothManagerService.TAG, "Proxy callbacks already in progress.");
                return;
            }
            this.mInvokingProxyCallbacks = true;
            int n = this.mProxies.beginBroadcast();
            try {
                for (int i = 0; i < n; ++i) {
                    try {
                        this.mProxies.getBroadcastItem(i).onServiceDisconnected(className);
                        continue;
                    }
                    catch (RemoteException e) {
                        Slog.e(BluetoothManagerService.TAG, "Unable to disconnect from proxy", e);
                    }
                }
            }
            finally {
                this.mProxies.finishBroadcast();
                this.mInvokingProxyCallbacks = false;
            }
        }

        @Override
        public void binderDied() {
            Slog.w(BluetoothManagerService.TAG, "Profile service for profile: " + this.mClassName + " died.");
            this.onServiceDisconnected(this.mClassName);
            Message msg = BluetoothManagerService.this.mHandler.obtainMessage(401);
            msg.obj = this;
            BluetoothManagerService.this.mHandler.sendMessageDelayed(msg, 3000L);
        }

        static /* synthetic */ void access$3300(ProfileServiceConnections x0, IBluetoothProfileServiceConnection x1) {
            x0.addProxy(x1);
        }
    }

    class ClientDeathRecipient
    implements IBinder.DeathRecipient {
        private String mPackageName;

        ClientDeathRecipient(String packageName) {
            this.mPackageName = packageName;
        }

        @Override
        public void binderDied() {
            Slog.d(BluetoothManagerService.TAG, "Binder is dead - unregister " + this.mPackageName);
            for (Map.Entry entry : BluetoothManagerService.this.mBleApps.entrySet()) {
                IBinder token = (IBinder)entry.getKey();
                ClientDeathRecipient deathRec = (ClientDeathRecipient)entry.getValue();
                if (!deathRec.equals(this)) continue;
                BluetoothManagerService.this.updateBleAppCount(token, false, this.mPackageName);
                break;
            }
        }

        public String getPackageName() {
            return this.mPackageName;
        }
    }

    private class ActiveLog {
        private int mReason;
        private String mPackageName;
        private boolean mEnable;
        private long mTimestamp;

        ActiveLog(int reason, String packageName, boolean enable, long timestamp) {
            this.mReason = reason;
            this.mPackageName = packageName;
            this.mEnable = enable;
            this.mTimestamp = timestamp;
        }

        public String toString() {
            return BluetoothManagerService.timeToLog(this.mTimestamp) + (this.mEnable ? "  Enabled " : " Disabled ") + " due to " + BluetoothManagerService.getEnableDisableReasonString(this.mReason) + " by " + this.mPackageName;
        }
    }
}

