/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.util.LocalLog;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import com.android.server.FgThread;
import com.android.server.INativeDaemonConnectorCallbacks;
import com.android.server.NativeDaemonConnectorException;
import com.android.server.NativeDaemonEvent;
import com.android.server.NativeDaemonTimeoutException;
import com.android.server.Watchdog;
import com.google.android.collect.Lists;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

final class NativeDaemonConnector
implements Runnable,
Handler.Callback,
Watchdog.Monitor {
    private static final boolean VDBG = false;
    private final String TAG;
    private String mSocket;
    private OutputStream mOutputStream;
    private LocalLog mLocalLog;
    private volatile boolean mDebug = false;
    private volatile Object mWarnIfHeld;
    private final ResponseQueue mResponseQueue;
    private final PowerManager.WakeLock mWakeLock;
    private final Looper mLooper;
    private INativeDaemonConnectorCallbacks mCallbacks;
    private Handler mCallbackHandler;
    private AtomicInteger mSequenceNumber;
    private static final long DEFAULT_TIMEOUT = 60000L;
    private static final long WARN_EXECUTE_DELAY_MS = 500L;
    private final Object mDaemonLock = new Object();
    private final int BUFFER_SIZE = 4096;

    NativeDaemonConnector(INativeDaemonConnectorCallbacks callbacks, String socket, int responseQueueSize, String logTag, int maxLogSize, PowerManager.WakeLock wl) {
        this(callbacks, socket, responseQueueSize, logTag, maxLogSize, wl, FgThread.get().getLooper());
    }

    NativeDaemonConnector(INativeDaemonConnectorCallbacks callbacks, String socket, int responseQueueSize, String logTag, int maxLogSize, PowerManager.WakeLock wl, Looper looper) {
        this.mCallbacks = callbacks;
        this.mSocket = socket;
        this.mResponseQueue = new ResponseQueue(responseQueueSize);
        this.mWakeLock = wl;
        if (this.mWakeLock != null) {
            this.mWakeLock.setReferenceCounted(true);
        }
        this.mLooper = looper;
        this.mSequenceNumber = new AtomicInteger(0);
        this.TAG = logTag != null ? logTag : "NativeDaemonConnector";
        this.mLocalLog = new LocalLog(maxLogSize);
    }

    public void setDebug(boolean debug) {
        this.mDebug = debug;
    }

    private int uptimeMillisInt() {
        return (int)SystemClock.uptimeMillis() & Integer.MAX_VALUE;
    }

    public void setWarnIfHeld(Object warnIfHeld) {
        Preconditions.checkState(this.mWarnIfHeld == null);
        this.mWarnIfHeld = Preconditions.checkNotNull(warnIfHeld);
    }

    @Override
    public void run() {
        this.mCallbackHandler = new Handler(this.mLooper, this);
        while (!NativeDaemonConnector.isShuttingDown()) {
            try {
                this.listenToSocket();
            }
            catch (Exception e) {
                this.loge("Error in NativeDaemonConnector: " + e);
                if (NativeDaemonConnector.isShuttingDown()) break;
                SystemClock.sleep(5000L);
            }
        }
    }

    private static boolean isShuttingDown() {
        String shutdownAct = SystemProperties.get("sys.shutdown.requested", "");
        return shutdownAct != null && shutdownAct.length() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleMessage(Message msg) {
        int end;
        String event = (String)msg.obj;
        int start = this.uptimeMillisInt();
        int sent = msg.arg1;
        try {
            if (!this.mCallbacks.onEvent(msg.what, event, NativeDaemonEvent.unescapeArgs(event))) {
                this.log(String.format("Unhandled event '%s'", event));
            }
            if (this.mCallbacks.onCheckHoldWakeLock(msg.what) && this.mWakeLock != null) {
                this.mWakeLock.release();
            }
            end = this.uptimeMillisInt();
        }
        catch (Exception e) {
            int end2;
            try {
                this.loge("Error handling '" + event + "': " + e);
                if (this.mCallbacks.onCheckHoldWakeLock(msg.what) && this.mWakeLock != null) {
                    this.mWakeLock.release();
                }
                end2 = this.uptimeMillisInt();
            }
            catch (Throwable throwable) {
                if (this.mCallbacks.onCheckHoldWakeLock(msg.what) && this.mWakeLock != null) {
                    this.mWakeLock.release();
                }
                int end3 = this.uptimeMillisInt();
                if (start > sent && (long)(start - sent) > 500L) {
                    this.loge(String.format("NDC event {%s} processed too late: %dms", event, start - sent));
                }
                if (end3 > start && (long)(end3 - start) > 500L) {
                    this.loge(String.format("NDC event {%s} took too long: %dms", event, end3 - start));
                }
                throw throwable;
            }
            if (start > sent && (long)(start - sent) > 500L) {
                this.loge(String.format("NDC event {%s} processed too late: %dms", event, start - sent));
            }
            if (end2 > start && (long)(end2 - start) > 500L) {
                this.loge(String.format("NDC event {%s} took too long: %dms", event, end2 - start));
            }
        }
        if (start > sent && (long)(start - sent) > 500L) {
            this.loge(String.format("NDC event {%s} processed too late: %dms", event, start - sent));
        }
        if (end > start && (long)(end - start) > 500L) {
            this.loge(String.format("NDC event {%s} took too long: %dms", event, end - start));
        }
        return true;
    }

    private LocalSocketAddress determineSocketAddress() {
        if (this.mSocket.startsWith("__test__") && Build.IS_DEBUGGABLE) {
            return new LocalSocketAddress(this.mSocket);
        }
        return new LocalSocketAddress(this.mSocket, LocalSocketAddress.Namespace.RESERVED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listenToSocket() throws IOException {
        LocalSocket socket = null;
        try {
            socket = new LocalSocket();
            LocalSocketAddress address = this.determineSocketAddress();
            socket.connect(address);
            InputStream inputStream = socket.getInputStream();
            Object object = this.mDaemonLock;
            synchronized (object) {
                this.mOutputStream = socket.getOutputStream();
            }
            this.mCallbacks.onDaemonConnected();
            FileDescriptor[] fdList = null;
            byte[] buffer = new byte[4096];
            int start = 0;
            while (true) {
                int count;
                if ((count = inputStream.read(buffer, start, 4096 - start)) < 0) {
                    this.loge("got " + count + " reading with start = " + start);
                    break;
                }
                fdList = socket.getAncillaryFileDescriptors();
                count += start;
                start = 0;
                for (int i = 0; i < count; ++i) {
                    if (buffer[i] != 0) continue;
                    String rawEvent = new String(buffer, start, i - start, StandardCharsets.UTF_8);
                    boolean releaseWl = false;
                    try {
                        NativeDaemonEvent event = NativeDaemonEvent.parseRawEvent(rawEvent, fdList);
                        this.log("RCV <- {" + event + "}");
                        if (event.isClassUnsolicited()) {
                            Message msg;
                            if (this.mCallbacks.onCheckHoldWakeLock(event.getCode()) && this.mWakeLock != null) {
                                this.mWakeLock.acquire();
                                releaseWl = true;
                            }
                            if (this.mCallbackHandler.sendMessage(msg = this.mCallbackHandler.obtainMessage(event.getCode(), this.uptimeMillisInt(), 0, event.getRawEvent()))) {
                                releaseWl = false;
                            }
                        } else {
                            this.mResponseQueue.add(event.getCmdNumber(), event);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        this.log("Problem parsing message " + e);
                    }
                    finally {
                        if (releaseWl) {
                            this.mWakeLock.release();
                        }
                    }
                    start = i + 1;
                }
                if (start == 0) {
                    this.log("RCV incomplete");
                }
                if (start != count) {
                    int remaining = 4096 - start;
                    System.arraycopy((byte[])buffer, (int)start, (byte[])buffer, (int)0, (int)remaining);
                    start = remaining;
                    continue;
                }
                start = 0;
            }
        }
        catch (IOException ex) {
            this.loge("Communications error: " + ex);
            throw ex;
        }
        finally {
            Object object = this.mDaemonLock;
            synchronized (object) {
                if (this.mOutputStream != null) {
                    try {
                        this.loge("closing stream for " + this.mSocket);
                        this.mOutputStream.close();
                    }
                    catch (IOException e) {
                        this.loge("Failed closing output stream: " + e);
                    }
                    this.mOutputStream = null;
                }
            }
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException ex) {
                this.loge("Failed closing socket: " + ex);
            }
        }
    }

    @VisibleForTesting
    static void makeCommand(StringBuilder rawBuilder, StringBuilder logBuilder, int sequenceNumber, String cmd, Object ... args) {
        if (cmd.indexOf(0) >= 0) {
            throw new IllegalArgumentException("Unexpected command: " + cmd);
        }
        if (cmd.indexOf(32) >= 0) {
            throw new IllegalArgumentException("Arguments must be separate from command");
        }
        rawBuilder.append(sequenceNumber).append(' ').append(cmd);
        logBuilder.append(sequenceNumber).append(' ').append(cmd);
        for (Object arg : args) {
            String argString = String.valueOf(arg);
            if (argString.indexOf(0) >= 0) {
                throw new IllegalArgumentException("Unexpected argument: " + arg);
            }
            rawBuilder.append(' ');
            logBuilder.append(' ');
            NativeDaemonConnector.appendEscaped(rawBuilder, argString);
            if (arg instanceof SensitiveArg) {
                logBuilder.append("[scrubbed]");
                continue;
            }
            NativeDaemonConnector.appendEscaped(logBuilder, argString);
        }
        rawBuilder.append('\u0000');
    }

    public void waitForCallbacks() {
        if (Thread.currentThread() == this.mLooper.getThread()) {
            throw new IllegalStateException("Must not call this method on callback thread");
        }
        final CountDownLatch latch = new CountDownLatch(1);
        this.mCallbackHandler.post(new Runnable(){

            @Override
            public void run() {
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Slog.wtf(this.TAG, "Interrupted while waiting for unsolicited response handling", e);
        }
    }

    public NativeDaemonEvent execute(Command cmd) throws NativeDaemonConnectorException {
        return this.execute(cmd.mCmd, cmd.mArguments.toArray());
    }

    public NativeDaemonEvent execute(String cmd, Object ... args) throws NativeDaemonConnectorException {
        return this.execute(60000L, cmd, args);
    }

    public NativeDaemonEvent execute(long timeoutMs, String cmd, Object ... args) throws NativeDaemonConnectorException {
        NativeDaemonEvent[] events = this.executeForList(timeoutMs, cmd, args);
        if (events.length != 1) {
            throw new NativeDaemonConnectorException("Expected exactly one response, but received " + events.length);
        }
        return events[0];
    }

    public NativeDaemonEvent[] executeForList(Command cmd) throws NativeDaemonConnectorException {
        return this.executeForList(cmd.mCmd, cmd.mArguments.toArray());
    }

    public NativeDaemonEvent[] executeForList(String cmd, Object ... args) throws NativeDaemonConnectorException {
        return this.executeForList(60000L, cmd, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NativeDaemonEvent[] executeForList(long timeoutMs, String cmd, Object ... args) throws NativeDaemonConnectorException {
        if (this.mWarnIfHeld != null && Thread.holdsLock(this.mWarnIfHeld)) {
            Slog.wtf(this.TAG, "Calling thread " + Thread.currentThread().getName() + " is holding 0x" + Integer.toHexString(System.identityHashCode(this.mWarnIfHeld)), new Throwable());
        }
        long startTime = SystemClock.elapsedRealtime();
        ArrayList<NativeDaemonEvent> events = Lists.newArrayList();
        StringBuilder rawBuilder = new StringBuilder();
        StringBuilder logBuilder = new StringBuilder();
        int sequenceNumber = this.mSequenceNumber.incrementAndGet();
        NativeDaemonConnector.makeCommand(rawBuilder, logBuilder, sequenceNumber, cmd, args);
        String rawCmd = rawBuilder.toString();
        String logCmd = logBuilder.toString();
        this.log("SND -> {" + logCmd + "}");
        Object object = this.mDaemonLock;
        synchronized (object) {
            if (this.mOutputStream == null) {
                throw new NativeDaemonConnectorException("missing output stream");
            }
            try {
                this.mOutputStream.write(rawCmd.getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new NativeDaemonConnectorException("problem sending command", e);
            }
        }
        NativeDaemonEvent event = null;
        do {
            if ((event = this.mResponseQueue.remove(sequenceNumber, timeoutMs, logCmd)) == null) {
                this.loge("timed-out waiting for response to " + logCmd);
                throw new NativeDaemonTimeoutException(logCmd, event);
            }
            events.add(event);
        } while (event.isClassContinue());
        long endTime = SystemClock.elapsedRealtime();
        if (endTime - startTime > 500L) {
            this.loge("NDC Command {" + logCmd + "} took too long (" + (endTime - startTime) + "ms)");
        }
        if (event.isClassClientError()) {
            throw new NativeDaemonArgumentException(logCmd, event);
        }
        if (event.isClassServerError()) {
            throw new NativeDaemonFailureException(logCmd, event);
        }
        return events.toArray(new NativeDaemonEvent[events.size()]);
    }

    @VisibleForTesting
    static void appendEscaped(StringBuilder builder, String arg) {
        boolean hasSpaces;
        boolean bl = hasSpaces = arg.indexOf(32) >= 0;
        if (hasSpaces) {
            builder.append('\"');
        }
        int length = arg.length();
        for (int i = 0; i < length; ++i) {
            char c = arg.charAt(i);
            if (c == '\"') {
                builder.append("\\\"");
                continue;
            }
            if (c == '\\') {
                builder.append("\\\\");
                continue;
            }
            builder.append(c);
        }
        if (hasSpaces) {
            builder.append('\"');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void monitor() {
        Object object = this.mDaemonLock;
        synchronized (object) {
        }
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.mLocalLog.dump(fd, pw, args);
        pw.println();
        this.mResponseQueue.dump(fd, pw, args);
    }

    private void log(String logstring) {
        if (this.mDebug) {
            Slog.d(this.TAG, logstring);
        }
        this.mLocalLog.log(logstring);
    }

    private void loge(String logstring) {
        Slog.e(this.TAG, logstring);
        this.mLocalLog.log(logstring);
    }

    private static class ResponseQueue {
        private final LinkedList<PendingCmd> mPendingCmds = new LinkedList();
        private int mMaxCount;

        ResponseQueue(int maxCount) {
            this.mMaxCount = maxCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int cmdNum, NativeDaemonEvent response) {
            PendingCmd found = null;
            LinkedList<PendingCmd> linkedList = this.mPendingCmds;
            synchronized (linkedList) {
                for (PendingCmd pendingCmd : this.mPendingCmds) {
                    if (pendingCmd.cmdNum != cmdNum) continue;
                    found = pendingCmd;
                    break;
                }
                if (found == null) {
                    while (this.mPendingCmds.size() >= this.mMaxCount) {
                        Slog.e("NativeDaemonConnector.ResponseQueue", "more buffered than allowed: " + this.mPendingCmds.size() + " >= " + this.mMaxCount);
                        PendingCmd pendingCmd = this.mPendingCmds.remove();
                        Slog.e("NativeDaemonConnector.ResponseQueue", "Removing request: " + pendingCmd.logCmd + " (" + pendingCmd.cmdNum + ")");
                    }
                    found = new PendingCmd(cmdNum, null);
                    this.mPendingCmds.add(found);
                }
                ++found.availableResponseCount;
                if (found.availableResponseCount == 0) {
                    this.mPendingCmds.remove(found);
                }
            }
            try {
                found.responses.put(response);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NativeDaemonEvent remove(int cmdNum, long timeoutMs, String logCmd) {
            PendingCmd found = null;
            LinkedList<PendingCmd> linkedList = this.mPendingCmds;
            synchronized (linkedList) {
                for (PendingCmd pendingCmd : this.mPendingCmds) {
                    if (pendingCmd.cmdNum != cmdNum) continue;
                    found = pendingCmd;
                    break;
                }
                if (found == null) {
                    found = new PendingCmd(cmdNum, logCmd);
                    this.mPendingCmds.add(found);
                }
                --found.availableResponseCount;
                if (found.availableResponseCount == 0) {
                    this.mPendingCmds.remove(found);
                }
            }
            NativeDaemonEvent result = null;
            try {
                result = found.responses.poll(timeoutMs, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (result == null) {
                Slog.e("NativeDaemonConnector.ResponseQueue", "Timeout waiting for response");
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            pw.println("Pending requests:");
            LinkedList<PendingCmd> linkedList = this.mPendingCmds;
            synchronized (linkedList) {
                for (PendingCmd pendingCmd : this.mPendingCmds) {
                    pw.println("  Cmd " + pendingCmd.cmdNum + " - " + pendingCmd.logCmd);
                }
            }
        }

        private static class PendingCmd {
            public final int cmdNum;
            public final String logCmd;
            public BlockingQueue<NativeDaemonEvent> responses = new ArrayBlockingQueue<NativeDaemonEvent>(10);
            public int availableResponseCount;

            public PendingCmd(int cmdNum, String logCmd) {
                this.cmdNum = cmdNum;
                this.logCmd = logCmd;
            }
        }
    }

    public static class Command {
        private String mCmd;
        private ArrayList<Object> mArguments = Lists.newArrayList();

        public Command(String cmd, Object ... args) {
            this.mCmd = cmd;
            for (Object arg : args) {
                this.appendArg(arg);
            }
        }

        public Command appendArg(Object arg) {
            this.mArguments.add(arg);
            return this;
        }
    }

    private static class NativeDaemonFailureException
    extends NativeDaemonConnectorException {
        public NativeDaemonFailureException(String command, NativeDaemonEvent event) {
            super(command, event);
        }
    }

    private static class NativeDaemonArgumentException
    extends NativeDaemonConnectorException {
        public NativeDaemonArgumentException(String command, NativeDaemonEvent event) {
            super(command, event);
        }

        @Override
        public IllegalArgumentException rethrowAsParcelableException() {
            throw new IllegalArgumentException(this.getMessage(), this);
        }
    }

    public static class SensitiveArg {
        private final Object mArg;

        public SensitiveArg(Object arg) {
            this.mArg = arg;
        }

        public String toString() {
            return String.valueOf(this.mArg);
        }
    }
}

