/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.ContentObserver;
import android.net.Uri;
import android.net.nsd.DnsSdTxtRecord;
import android.net.nsd.INsdManager;
import android.net.nsd.NsdManager;
import android.net.nsd.NsdServiceInfo;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.Messenger;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.Base64;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.AsyncChannel;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import com.android.server.INativeDaemonConnectorCallbacks;
import com.android.server.NativeDaemonConnector;
import com.android.server.NativeDaemonConnectorException;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;

public class NsdService
extends INsdManager.Stub {
    private static final String TAG = "NsdService";
    private static final String MDNS_TAG = "mDnsConnector";
    private static final boolean DBG = true;
    private final Context mContext;
    private final NsdSettings mNsdSettings;
    private final NsdStateMachine mNsdStateMachine;
    private final DaemonConnection mDaemon;
    private final NativeCallbackReceiver mDaemonCallback;
    private final HashMap<Messenger, ClientInfo> mClients = new HashMap();
    private final SparseArray<ClientInfo> mIdToClientInfoMap = new SparseArray();
    private final AsyncChannel mReplyChannel = new AsyncChannel();
    private static final int INVALID_ID = 0;
    private int mUniqueId = 1;

    private String unescape(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                if (++i >= s.length()) {
                    Slog.e(TAG, "Unexpected end of escape sequence in: " + s);
                    break;
                }
                c = s.charAt(i);
                if (c != '.' && c != '\\') {
                    if (i + 2 >= s.length()) {
                        Slog.e(TAG, "Unexpected end of escape sequence in: " + s);
                        break;
                    }
                    c = (char)((c - 48) * 100 + (s.charAt(i + 1) - 48) * 10 + (s.charAt(i + 2) - 48));
                    i += 2;
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @VisibleForTesting
    NsdService(Context ctx, NsdSettings settings, Handler handler, DaemonConnectionSupplier fn) {
        this.mContext = ctx;
        this.mNsdSettings = settings;
        this.mNsdStateMachine = new NsdStateMachine(TAG, handler);
        this.mNsdStateMachine.start();
        this.mDaemonCallback = new NativeCallbackReceiver();
        this.mDaemon = fn.get(this.mDaemonCallback);
    }

    public static NsdService create(Context context) throws InterruptedException {
        NsdSettings settings = NsdSettings.makeDefault(context);
        HandlerThread thread = new HandlerThread(TAG);
        thread.start();
        Handler handler = new Handler(thread.getLooper());
        NsdService service = new NsdService(context, settings, handler, DaemonConnection::new);
        service.mDaemonCallback.awaitConnection();
        return service;
    }

    @Override
    public Messenger getMessenger() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.INTERNET", TAG);
        return new Messenger(this.mNsdStateMachine.getHandler());
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        this.mNsdSettings.putEnabledStatus(isEnabled);
        this.notifyEnabled(isEnabled);
    }

    private void notifyEnabled(boolean isEnabled) {
        this.mNsdStateMachine.sendMessage(isEnabled ? 393240 : 393241);
    }

    private void sendNsdStateChangeBroadcast(boolean isEnabled) {
        Intent intent = new Intent("android.net.nsd.STATE_CHANGED");
        intent.addFlags(0x4000000);
        int nsdState = isEnabled ? 2 : 1;
        intent.putExtra("nsd_state", nsdState);
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    private boolean isNsdEnabled() {
        boolean ret = this.mNsdSettings.isEnabled();
        Slog.d(TAG, "Network service discovery is " + (ret ? "enabled" : "disabled"));
        return ret;
    }

    private int getUniqueId() {
        if (++this.mUniqueId == 0) {
            return ++this.mUniqueId;
        }
        return this.mUniqueId;
    }

    private boolean registerService(int regId, NsdServiceInfo service) {
        Slog.d(TAG, "registerService: " + regId + " " + service);
        String name = service.getServiceName();
        String type = service.getServiceType();
        int port = service.getPort();
        byte[] textRecord = service.getTxtRecord();
        String record = Base64.encodeToString(textRecord, 0).replace("\n", "");
        return this.mDaemon.execute("register", regId, name, type, port, record);
    }

    private boolean unregisterService(int regId) {
        return this.mDaemon.execute("stop-register", regId);
    }

    private boolean updateService(int regId, DnsSdTxtRecord t) {
        if (t == null) {
            return false;
        }
        return this.mDaemon.execute("update", regId, t.size(), t.getRawData());
    }

    private boolean discoverServices(int discoveryId, String serviceType) {
        return this.mDaemon.execute("discover", discoveryId, serviceType);
    }

    private boolean stopServiceDiscovery(int discoveryId) {
        return this.mDaemon.execute("stop-discover", discoveryId);
    }

    private boolean resolveService(int resolveId, NsdServiceInfo service) {
        String name = service.getServiceName();
        String type = service.getServiceType();
        return this.mDaemon.execute("resolve", resolveId, name, type, "local.");
    }

    private boolean stopResolveService(int resolveId) {
        return this.mDaemon.execute("stop-resolve", resolveId);
    }

    private boolean getAddrInfo(int resolveId, String hostname) {
        return this.mDaemon.execute("getaddrinfo", resolveId, hostname);
    }

    private boolean stopGetAddrInfo(int resolveId) {
        return this.mDaemon.execute("stop-getaddrinfo", resolveId);
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, pw)) {
            return;
        }
        for (ClientInfo client : this.mClients.values()) {
            pw.println("Client Info");
            pw.println(client);
        }
        this.mNsdStateMachine.dump(fd, pw, args);
    }

    private Message obtainMessage(Message srcMsg) {
        Message msg = Message.obtain();
        msg.arg2 = srcMsg.arg2;
        return msg;
    }

    private void replyToMessage(Message msg, int what) {
        if (msg.replyTo == null) {
            return;
        }
        Message dstMsg = this.obtainMessage(msg);
        dstMsg.what = what;
        this.mReplyChannel.replyToMessage(msg, dstMsg);
    }

    private void replyToMessage(Message msg, int what, int arg1) {
        if (msg.replyTo == null) {
            return;
        }
        Message dstMsg = this.obtainMessage(msg);
        dstMsg.what = what;
        dstMsg.arg1 = arg1;
        this.mReplyChannel.replyToMessage(msg, dstMsg);
    }

    private void replyToMessage(Message msg, int what, Object obj) {
        if (msg.replyTo == null) {
            return;
        }
        Message dstMsg = this.obtainMessage(msg);
        dstMsg.what = what;
        dstMsg.obj = obj;
        this.mReplyChannel.replyToMessage(msg, dstMsg);
    }

    @VisibleForTesting
    public static interface NsdSettings {
        public boolean isEnabled();

        public void putEnabledStatus(boolean var1);

        public void registerContentObserver(Uri var1, ContentObserver var2);

        public static NsdSettings makeDefault(Context context) {
            final ContentResolver resolver = context.getContentResolver();
            return new NsdSettings(){

                @Override
                public boolean isEnabled() {
                    return Settings.Global.getInt(resolver, "nsd_on", 1) == 1;
                }

                @Override
                public void putEnabledStatus(boolean isEnabled) {
                    Settings.Global.putInt(resolver, "nsd_on", isEnabled ? 1 : 0);
                }

                @Override
                public void registerContentObserver(Uri uri, ContentObserver observer) {
                    resolver.registerContentObserver(uri, false, observer);
                }
            };
        }
    }

    private class ClientInfo {
        private static final int MAX_LIMIT = 10;
        private final AsyncChannel mChannel;
        private final Messenger mMessenger;
        private NsdServiceInfo mResolvedService;
        private final SparseIntArray mClientIds = new SparseIntArray();
        private final SparseIntArray mClientRequests = new SparseIntArray();

        private ClientInfo(AsyncChannel c, Messenger m) {
            this.mChannel = c;
            this.mMessenger = m;
            Slog.d(NsdService.TAG, "New client, channel: " + c + " messenger: " + m);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("mChannel ").append(this.mChannel).append("\n");
            sb.append("mMessenger ").append(this.mMessenger).append("\n");
            sb.append("mResolvedService ").append(this.mResolvedService).append("\n");
            for (int i = 0; i < this.mClientIds.size(); ++i) {
                int clientID = this.mClientIds.keyAt(i);
                sb.append("clientId ").append(clientID).append(" mDnsId ").append(this.mClientIds.valueAt(i)).append(" type ").append(this.mClientRequests.get(clientID)).append("\n");
            }
            return sb.toString();
        }

        private void expungeAllRequests() {
            block5: for (int i = 0; i < this.mClientIds.size(); ++i) {
                int clientId = this.mClientIds.keyAt(i);
                int globalId = this.mClientIds.valueAt(i);
                NsdService.this.mIdToClientInfoMap.remove(globalId);
                Slog.d(NsdService.TAG, "Terminating client-ID " + clientId + " global-ID " + globalId + " type " + this.mClientRequests.get(clientId));
                switch (this.mClientRequests.get(clientId)) {
                    case 393217: {
                        NsdService.this.stopServiceDiscovery(globalId);
                        continue block5;
                    }
                    case 393234: {
                        NsdService.this.stopResolveService(globalId);
                        continue block5;
                    }
                    case 393225: {
                        NsdService.this.unregisterService(globalId);
                        continue block5;
                    }
                }
            }
            this.mClientIds.clear();
            this.mClientRequests.clear();
        }

        private int getClientId(int globalId) {
            int idx = this.mClientIds.indexOfValue(globalId);
            if (idx < 0) {
                return idx;
            }
            return this.mClientIds.keyAt(idx);
        }
    }

    @VisibleForTesting
    public static class DaemonConnection {
        final NativeDaemonConnector mNativeConnector;

        DaemonConnection(NativeCallbackReceiver callback) {
            this.mNativeConnector = new NativeDaemonConnector(callback, "mdns", 10, NsdService.MDNS_TAG, 25, null);
            new Thread((Runnable)this.mNativeConnector, NsdService.MDNS_TAG).start();
        }

        public boolean execute(Object ... args) {
            Slog.d(NsdService.TAG, "mdnssd " + Arrays.toString(args));
            try {
                this.mNativeConnector.execute("mdnssd", args);
            }
            catch (NativeDaemonConnectorException e) {
                Slog.e(NsdService.TAG, "Failed to execute mdnssd " + Arrays.toString(args), e);
                return false;
            }
            return true;
        }

        public void start() {
            this.execute("start-service");
        }

        public void stop() {
            this.execute("stop-service");
        }
    }

    static interface DaemonConnectionSupplier {
        public DaemonConnection get(NativeCallbackReceiver var1);
    }

    class NativeCallbackReceiver
    implements INativeDaemonConnectorCallbacks {
        private final CountDownLatch connected = new CountDownLatch(1);

        NativeCallbackReceiver() {
        }

        public void awaitConnection() throws InterruptedException {
            this.connected.await();
        }

        @Override
        public void onDaemonConnected() {
            this.connected.countDown();
        }

        @Override
        public boolean onCheckHoldWakeLock(int code) {
            return false;
        }

        @Override
        public boolean onEvent(int code, String raw2, String[] cooked) {
            NativeEvent event = new NativeEvent(code, raw2, cooked);
            NsdService.this.mNsdStateMachine.sendMessage(393242, event);
            return true;
        }
    }

    private class NativeEvent {
        final int code;
        final String raw;
        final String[] cooked;

        NativeEvent(int code, String raw2, String[] cooked) {
            this.code = code;
            this.raw = raw2;
            this.cooked = cooked;
        }
    }

    static final class NativeResponseCode {
        public static final int SERVICE_DISCOVERY_FAILED = 602;
        public static final int SERVICE_FOUND = 603;
        public static final int SERVICE_LOST = 604;
        public static final int SERVICE_REGISTRATION_FAILED = 605;
        public static final int SERVICE_REGISTERED = 606;
        public static final int SERVICE_RESOLUTION_FAILED = 607;
        public static final int SERVICE_RESOLVED = 608;
        public static final int SERVICE_UPDATED = 609;
        public static final int SERVICE_UPDATE_FAILED = 610;
        public static final int SERVICE_GET_ADDR_FAILED = 611;
        public static final int SERVICE_GET_ADDR_SUCCESS = 612;
        private static final SparseArray<String> CODE_NAMES = new SparseArray();

        NativeResponseCode() {
        }

        static String nameOf(int code) {
            String name = CODE_NAMES.get(code);
            if (name == null) {
                return Integer.toString(code);
            }
            return name;
        }

        static {
            CODE_NAMES.put(602, "SERVICE_DISCOVERY_FAILED");
            CODE_NAMES.put(603, "SERVICE_FOUND");
            CODE_NAMES.put(604, "SERVICE_LOST");
            CODE_NAMES.put(605, "SERVICE_REGISTRATION_FAILED");
            CODE_NAMES.put(606, "SERVICE_REGISTERED");
            CODE_NAMES.put(607, "SERVICE_RESOLUTION_FAILED");
            CODE_NAMES.put(608, "SERVICE_RESOLVED");
            CODE_NAMES.put(609, "SERVICE_UPDATED");
            CODE_NAMES.put(610, "SERVICE_UPDATE_FAILED");
            CODE_NAMES.put(611, "SERVICE_GET_ADDR_FAILED");
            CODE_NAMES.put(612, "SERVICE_GET_ADDR_SUCCESS");
        }
    }

    private class NsdStateMachine
    extends StateMachine {
        private final DefaultState mDefaultState;
        private final DisabledState mDisabledState;
        private final EnabledState mEnabledState;

        @Override
        protected String getWhatToString(int what) {
            return NsdManager.nameOf(what);
        }

        private void registerForNsdSetting() {
            ContentObserver contentObserver = new ContentObserver(this.getHandler()){

                @Override
                public void onChange(boolean selfChange) {
                    NsdService.this.notifyEnabled(NsdService.this.isNsdEnabled());
                }
            };
            Uri uri = Settings.Global.getUriFor("nsd_on");
            NsdService.this.mNsdSettings.registerContentObserver(uri, contentObserver);
        }

        NsdStateMachine(String name, Handler handler) {
            super(name, handler);
            this.mDefaultState = new DefaultState();
            this.mDisabledState = new DisabledState();
            this.mEnabledState = new EnabledState();
            this.addState(this.mDefaultState);
            this.addState(this.mDisabledState, this.mDefaultState);
            this.addState(this.mEnabledState, this.mDefaultState);
            State initialState = NsdService.this.isNsdEnabled() ? this.mEnabledState : this.mDisabledState;
            this.setInitialState(initialState);
            this.setLogRecSize(25);
            this.registerForNsdSetting();
        }

        class EnabledState
        extends State {
            EnabledState() {
            }

            @Override
            public void enter() {
                NsdService.this.sendNsdStateChangeBroadcast(true);
                if (NsdService.this.mClients.size() > 0) {
                    NsdService.this.mDaemon.start();
                }
            }

            @Override
            public void exit() {
                if (NsdService.this.mClients.size() > 0) {
                    NsdService.this.mDaemon.stop();
                }
            }

            private boolean requestLimitReached(ClientInfo clientInfo) {
                if (clientInfo.mClientIds.size() >= 10) {
                    Slog.d(NsdService.TAG, "Exceeded max outstanding requests " + clientInfo);
                    return true;
                }
                return false;
            }

            private void storeRequestMap(int clientId, int globalId, ClientInfo clientInfo, int what) {
                clientInfo.mClientIds.put(clientId, globalId);
                clientInfo.mClientRequests.put(clientId, what);
                NsdService.this.mIdToClientInfoMap.put(globalId, clientInfo);
            }

            private void removeRequestMap(int clientId, int globalId, ClientInfo clientInfo) {
                clientInfo.mClientIds.delete(clientId);
                clientInfo.mClientRequests.delete(clientId);
                NsdService.this.mIdToClientInfoMap.remove(globalId);
            }

            @Override
            public boolean processMessage(Message msg) {
                switch (msg.what) {
                    case 69632: {
                        if (msg.arg1 == 0 && NsdService.this.mClients.size() == 0) {
                            NsdService.this.mDaemon.start();
                        }
                        return false;
                    }
                    case 69636: {
                        return false;
                    }
                    case 393241: {
                        NsdStateMachine.this.transitionTo(NsdStateMachine.this.mDisabledState);
                        break;
                    }
                    case 393217: {
                        Slog.d(NsdService.TAG, "Discover services");
                        NsdServiceInfo servInfo = (NsdServiceInfo)msg.obj;
                        ClientInfo clientInfo = (ClientInfo)NsdService.this.mClients.get(msg.replyTo);
                        if (this.requestLimitReached(clientInfo)) {
                            NsdService.this.replyToMessage(msg, 393219, 4);
                            break;
                        }
                        int id2 = NsdService.this.getUniqueId();
                        if (NsdService.this.discoverServices(id2, servInfo.getServiceType())) {
                            Slog.d(NsdService.TAG, "Discover " + msg.arg2 + " " + id2 + servInfo.getServiceType());
                            this.storeRequestMap(msg.arg2, id2, clientInfo, msg.what);
                            NsdService.this.replyToMessage(msg, 393218, servInfo);
                            break;
                        }
                        NsdService.this.stopServiceDiscovery(id2);
                        NsdService.this.replyToMessage(msg, 393219, 0);
                        break;
                    }
                    case 393222: {
                        int id3;
                        Slog.d(NsdService.TAG, "Stop service discovery");
                        ClientInfo clientInfo = (ClientInfo)NsdService.this.mClients.get(msg.replyTo);
                        try {
                            id3 = clientInfo.mClientIds.get(msg.arg2);
                        }
                        catch (NullPointerException e) {
                            NsdService.this.replyToMessage(msg, 393223, 0);
                            break;
                        }
                        this.removeRequestMap(msg.arg2, id3, clientInfo);
                        if (NsdService.this.stopServiceDiscovery(id3)) {
                            NsdService.this.replyToMessage(msg, 393224);
                            break;
                        }
                        NsdService.this.replyToMessage(msg, 393223, 0);
                        break;
                    }
                    case 393225: {
                        Slog.d(NsdService.TAG, "Register service");
                        ClientInfo clientInfo = (ClientInfo)NsdService.this.mClients.get(msg.replyTo);
                        if (this.requestLimitReached(clientInfo)) {
                            NsdService.this.replyToMessage(msg, 393226, 4);
                            break;
                        }
                        int id4 = NsdService.this.getUniqueId();
                        if (NsdService.this.registerService(id4, (NsdServiceInfo)msg.obj)) {
                            Slog.d(NsdService.TAG, "Register " + msg.arg2 + " " + id4);
                            this.storeRequestMap(msg.arg2, id4, clientInfo, msg.what);
                            break;
                        }
                        NsdService.this.unregisterService(id4);
                        NsdService.this.replyToMessage(msg, 393226, 0);
                        break;
                    }
                    case 393228: {
                        int id5;
                        Slog.d(NsdService.TAG, "unregister service");
                        ClientInfo clientInfo = (ClientInfo)NsdService.this.mClients.get(msg.replyTo);
                        try {
                            id5 = clientInfo.mClientIds.get(msg.arg2);
                        }
                        catch (NullPointerException e) {
                            NsdService.this.replyToMessage(msg, 393229, 0);
                            break;
                        }
                        this.removeRequestMap(msg.arg2, id5, clientInfo);
                        if (NsdService.this.unregisterService(id5)) {
                            NsdService.this.replyToMessage(msg, 393230);
                            break;
                        }
                        NsdService.this.replyToMessage(msg, 393229, 0);
                        break;
                    }
                    case 393234: {
                        Slog.d(NsdService.TAG, "Resolve service");
                        NsdServiceInfo servInfo = (NsdServiceInfo)msg.obj;
                        ClientInfo clientInfo = (ClientInfo)NsdService.this.mClients.get(msg.replyTo);
                        if (clientInfo.mResolvedService != null) {
                            NsdService.this.replyToMessage(msg, 393235, 3);
                            break;
                        }
                        int id6 = NsdService.this.getUniqueId();
                        if (NsdService.this.resolveService(id6, servInfo)) {
                            clientInfo.mResolvedService = new NsdServiceInfo();
                            this.storeRequestMap(msg.arg2, id6, clientInfo, msg.what);
                            break;
                        }
                        NsdService.this.replyToMessage(msg, 393235, 0);
                        break;
                    }
                    case 393242: {
                        NativeEvent event = (NativeEvent)msg.obj;
                        if (this.handleNativeEvent(event.code, event.raw, event.cooked)) break;
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }

            private boolean handleNativeEvent(int code, String raw2, String[] cooked) {
                int id2 = Integer.parseInt(cooked[1]);
                ClientInfo clientInfo = (ClientInfo)NsdService.this.mIdToClientInfoMap.get(id2);
                if (clientInfo == null) {
                    String name = NativeResponseCode.nameOf(code);
                    Slog.e(NsdService.TAG, String.format("id %d for %s has no client mapping", id2, name));
                    return false;
                }
                int clientId = clientInfo.getClientId(id2);
                if (clientId < 0) {
                    String name = NativeResponseCode.nameOf(code);
                    Slog.d(NsdService.TAG, String.format("Notification %s for listener id %d that is no longer active", name, id2));
                    return false;
                }
                String name = NativeResponseCode.nameOf(code);
                Slog.d(NsdService.TAG, String.format("Native daemon message %s: %s", name, raw2));
                switch (code) {
                    case 603: {
                        NsdServiceInfo servInfo = new NsdServiceInfo(cooked[2], cooked[3]);
                        clientInfo.mChannel.sendMessage(393220, 0, clientId, servInfo);
                        break;
                    }
                    case 604: {
                        NsdServiceInfo servInfo = new NsdServiceInfo(cooked[2], cooked[3]);
                        clientInfo.mChannel.sendMessage(393221, 0, clientId, servInfo);
                        break;
                    }
                    case 602: {
                        clientInfo.mChannel.sendMessage(393219, 0, clientId);
                        break;
                    }
                    case 606: {
                        NsdServiceInfo servInfo = new NsdServiceInfo(cooked[2], null);
                        clientInfo.mChannel.sendMessage(393227, id2, clientId, servInfo);
                        break;
                    }
                    case 605: {
                        clientInfo.mChannel.sendMessage(393226, 0, clientId);
                        break;
                    }
                    case 609: {
                        break;
                    }
                    case 610: {
                        break;
                    }
                    case 608: {
                        int index;
                        for (index = 0; index < cooked[2].length() && cooked[2].charAt(index) != '.'; ++index) {
                            if (cooked[2].charAt(index) != '\\') continue;
                            ++index;
                        }
                        if (index >= cooked[2].length()) {
                            Slog.e(NsdService.TAG, "Invalid service found " + raw2);
                            break;
                        }
                        String name2 = cooked[2].substring(0, index);
                        String rest = cooked[2].substring(index);
                        String type = rest.replace(".local.", "");
                        name2 = NsdService.this.unescape(name2);
                        clientInfo.mResolvedService.setServiceName(name2);
                        clientInfo.mResolvedService.setServiceType(type);
                        clientInfo.mResolvedService.setPort(Integer.parseInt(cooked[4]));
                        clientInfo.mResolvedService.setTxtRecords(cooked[6]);
                        NsdService.this.stopResolveService(id2);
                        this.removeRequestMap(clientId, id2, clientInfo);
                        int id22 = NsdService.this.getUniqueId();
                        if (NsdService.this.getAddrInfo(id22, cooked[3])) {
                            this.storeRequestMap(clientId, id22, clientInfo, 393234);
                            break;
                        }
                        clientInfo.mChannel.sendMessage(393235, 0, clientId);
                        clientInfo.mResolvedService = null;
                        break;
                    }
                    case 607: {
                        NsdService.this.stopResolveService(id2);
                        this.removeRequestMap(clientId, id2, clientInfo);
                        clientInfo.mResolvedService = null;
                        clientInfo.mChannel.sendMessage(393235, 0, clientId);
                        break;
                    }
                    case 611: {
                        NsdService.this.stopGetAddrInfo(id2);
                        this.removeRequestMap(clientId, id2, clientInfo);
                        clientInfo.mResolvedService = null;
                        clientInfo.mChannel.sendMessage(393235, 0, clientId);
                        break;
                    }
                    case 612: {
                        try {
                            clientInfo.mResolvedService.setHost(InetAddress.getByName(cooked[4]));
                            clientInfo.mChannel.sendMessage(393236, 0, clientId, clientInfo.mResolvedService);
                        }
                        catch (UnknownHostException e) {
                            clientInfo.mChannel.sendMessage(393235, 0, clientId);
                        }
                        NsdService.this.stopGetAddrInfo(id2);
                        this.removeRequestMap(clientId, id2, clientInfo);
                        clientInfo.mResolvedService = null;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
        }

        class DisabledState
        extends State {
            DisabledState() {
            }

            @Override
            public void enter() {
                NsdService.this.sendNsdStateChangeBroadcast(false);
            }

            @Override
            public boolean processMessage(Message msg) {
                switch (msg.what) {
                    case 393240: {
                        NsdStateMachine.this.transitionTo(NsdStateMachine.this.mEnabledState);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
        }

        class DefaultState
        extends State {
            DefaultState() {
            }

            @Override
            public boolean processMessage(Message msg) {
                ClientInfo cInfo = null;
                switch (msg.what) {
                    case 69632: {
                        if (msg.arg1 == 0) {
                            AsyncChannel c = (AsyncChannel)msg.obj;
                            Slog.d(NsdService.TAG, "New client listening to asynchronous messages");
                            c.sendMessage(69634);
                            cInfo = new ClientInfo(c, msg.replyTo);
                            NsdService.this.mClients.put(msg.replyTo, cInfo);
                            break;
                        }
                        Slog.e(NsdService.TAG, "Client connection failure, error=" + msg.arg1);
                        break;
                    }
                    case 69636: {
                        switch (msg.arg1) {
                            case 2: {
                                Slog.e(NsdService.TAG, "Send failed, client connection lost");
                                break;
                            }
                            case 4: {
                                Slog.d(NsdService.TAG, "Client disconnected");
                                break;
                            }
                            default: {
                                Slog.d(NsdService.TAG, "Client connection lost with reason: " + msg.arg1);
                            }
                        }
                        cInfo = (ClientInfo)NsdService.this.mClients.get(msg.replyTo);
                        if (cInfo != null) {
                            cInfo.expungeAllRequests();
                            NsdService.this.mClients.remove(msg.replyTo);
                        }
                        if (NsdService.this.mClients.size() != 0) break;
                        NsdService.this.mDaemon.stop();
                        break;
                    }
                    case 69633: {
                        AsyncChannel ac = new AsyncChannel();
                        ac.connect(NsdService.this.mContext, NsdStateMachine.this.getHandler(), msg.replyTo);
                        break;
                    }
                    case 393217: {
                        NsdService.this.replyToMessage(msg, 393219, 0);
                        break;
                    }
                    case 393222: {
                        NsdService.this.replyToMessage(msg, 393223, 0);
                        break;
                    }
                    case 393225: {
                        NsdService.this.replyToMessage(msg, 393226, 0);
                        break;
                    }
                    case 393228: {
                        NsdService.this.replyToMessage(msg, 393229, 0);
                        break;
                    }
                    case 393234: {
                        NsdService.this.replyToMessage(msg, 393235, 0);
                        break;
                    }
                    default: {
                        Slog.e(NsdService.TAG, "Unhandled " + msg);
                        return false;
                    }
                }
                return true;
            }
        }
    }
}

