/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityThread;
import android.app.ContextImpl;
import android.app.INotificationManager;
import android.app.usage.UsageStatsManagerInternal;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.sqlite.SQLiteCompatibilityWalFlags;
import android.os.BaseBundle;
import android.os.Binder;
import android.os.Build;
import android.os.Environment;
import android.os.FactoryTest;
import android.os.FileUtils;
import android.os.IIncidentManager;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.Process;
import android.os.ServiceManager;
import android.os.StrictMode;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.storage.IStorageManager;
import android.util.DisplayMetrics;
import android.util.EventLog;
import android.util.Slog;
import android.util.TimingsTraceLog;
import android.view.WindowManager;
import com.android.internal.app.ColorDisplayController;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.notification.SystemNotificationChannels;
import com.android.internal.os.BinderInternal;
import com.android.internal.util.ConcurrentUtils;
import com.android.internal.widget.ILockSettings;
import com.android.server.AlarmManagerService;
import com.android.server.AttributeCache;
import com.android.server.BatteryService;
import com.android.server.BinderCallsStatsService;
import com.android.server.BluetoothService;
import com.android.server.CertBlacklister;
import com.android.server.CommonTimeManagementService;
import com.android.server.ConnectivityService;
import com.android.server.ConsumerIrService;
import com.android.server.ContextHubSystemService;
import com.android.server.CountryDetectorService;
import com.android.server.DeviceIdleController;
import com.android.server.DiskStatsService;
import com.android.server.DockObserver;
import com.android.server.DropBoxManagerService;
import com.android.server.EntropyMixer;
import com.android.server.GestureLauncherService;
import com.android.server.GraphicsStatsService;
import com.android.server.HardwarePropertiesManagerService;
import com.android.server.InputMethodManagerService;
import com.android.server.IpSecService;
import com.android.server.LocalServices;
import com.android.server.LocationManagerService;
import com.android.server.MmsServiceBroker;
import com.android.server.NetworkManagementService;
import com.android.server.NetworkScoreService;
import com.android.server.NetworkTimeUpdateService;
import com.android.server.NsdService;
import com.android.server.PersistentDataBlockService;
import com.android.server.PinnerService;
import com.android.server.PruneInstantAppsJobService;
import com.android.server.RecoverySystemService;
import com.android.server.RescueParty;
import com.android.server.SensorNotificationService;
import com.android.server.SerialService;
import com.android.server.SystemConfig;
import com.android.server.SystemServerInitThreadPool;
import com.android.server.SystemServiceManager;
import com.android.server.SystemUpdateManagerService;
import com.android.server.TelephonyRegistry;
import com.android.server.TextServicesManagerService;
import com.android.server.UiModeManagerService;
import com.android.server.UiThread;
import com.android.server.UpdateLockService;
import com.android.server.VibratorService;
import com.android.server.Watchdog;
import com.android.server.WiredAccessoryManager;
import com.android.server.accessibility.AccessibilityManagerService;
import com.android.server.am.ActivityManagerService;
import com.android.server.audio.AudioService;
import com.android.server.broadcastradio.BroadcastRadioService;
import com.android.server.camera.CameraServiceProxy;
import com.android.server.clipboard.ClipboardService;
import com.android.server.connectivity.IpConnectivityMetrics;
import com.android.server.coverage.CoverageService;
import com.android.server.devicepolicy.DevicePolicyManagerService;
import com.android.server.display.ColorDisplayService;
import com.android.server.display.DisplayManagerService;
import com.android.server.dreams.DreamManagerService;
import com.android.server.emergency.EmergencyAffordanceService;
import com.android.server.fingerprint.FingerprintService;
import com.android.server.hdmi.HdmiControlService;
import com.android.server.input.InputManagerService;
import com.android.server.job.JobSchedulerService;
import com.android.server.lights.LightsService;
import com.android.server.media.MediaResourceMonitorService;
import com.android.server.media.MediaRouterService;
import com.android.server.media.MediaSessionService;
import com.android.server.media.MediaUpdateService;
import com.android.server.media.projection.MediaProjectionManagerService;
import com.android.server.net.NetworkPolicyManagerService;
import com.android.server.net.NetworkStatsService;
import com.android.server.net.watchlist.NetworkWatchlistService;
import com.android.server.notification.NotificationManagerService;
import com.android.server.oemlock.OemLockService;
import com.android.server.om.OverlayManagerService;
import com.android.server.os.DeviceIdentifiersPolicyService;
import com.android.server.os.SchedulingPolicyService;
import com.android.server.pm.BackgroundDexOptService;
import com.android.server.pm.CrossProfileAppsService;
import com.android.server.pm.Installer;
import com.android.server.pm.LauncherAppsService;
import com.android.server.pm.OtaDexoptService;
import com.android.server.pm.PackageManagerService;
import com.android.server.pm.ShortcutService;
import com.android.server.pm.UserManagerService;
import com.android.server.policy.PhoneWindowManager;
import com.android.server.power.PowerManagerService;
import com.android.server.power.ShutdownThread;
import com.android.server.restrictions.RestrictionsManagerService;
import com.android.server.security.KeyAttestationApplicationIdProviderService;
import com.android.server.security.KeyChainSystemService;
import com.android.server.soundtrigger.SoundTriggerService;
import com.android.server.stats.StatsCompanionService;
import com.android.server.statusbar.StatusBarManagerService;
import com.android.server.storage.DeviceStorageMonitorService;
import com.android.server.telecom.TelecomLoaderService;
import com.android.server.textclassifier.TextClassificationManagerService;
import com.android.server.trust.TrustManagerService;
import com.android.server.tv.TvInputManagerService;
import com.android.server.tv.TvRemoteService;
import com.android.server.twilight.TwilightService;
import com.android.server.usage.UsageStatsService;
import com.android.server.vr.VrManagerService;
import com.android.server.webkit.WebViewUpdateService;
import com.android.server.wm.WindowManagerService;
import dalvik.system.VMRuntime;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Timer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;

public final class SystemServer {
    private static final String TAG = "SystemServer";
    private static final String SYSTEM_SERVER_TIMING_TAG = "SystemServerTiming";
    private static final String SYSTEM_SERVER_TIMING_ASYNC_TAG = "SystemServerTimingAsync";
    private static final TimingsTraceLog BOOT_TIMINGS_TRACE_LOG = new TimingsTraceLog("SystemServerTiming", 524288L);
    private static final String ENCRYPTING_STATE = "trigger_restart_min_framework";
    private static final String ENCRYPTED_STATE = "1";
    private static final long SNAPSHOT_INTERVAL = 3600000L;
    private static final long EARLIEST_SUPPORTED_TIME = 86400000L;
    private static final long SLOW_DISPATCH_THRESHOLD_MS = 100L;
    private static final long SLOW_DELIVERY_THRESHOLD_MS = 200L;
    private static final String BACKUP_MANAGER_SERVICE_CLASS = "com.android.server.backup.BackupManagerService$Lifecycle";
    private static final String APPWIDGET_SERVICE_CLASS = "com.android.server.appwidget.AppWidgetService";
    private static final String VOICE_RECOGNITION_MANAGER_SERVICE_CLASS = "com.android.server.voiceinteraction.VoiceInteractionManagerService";
    private static final String PRINT_MANAGER_SERVICE_CLASS = "com.android.server.print.PrintManagerService";
    private static final String COMPANION_DEVICE_MANAGER_SERVICE_CLASS = "com.android.server.companion.CompanionDeviceManagerService";
    private static final String USB_SERVICE_CLASS = "com.android.server.usb.UsbService$Lifecycle";
    private static final String MIDI_SERVICE_CLASS = "com.android.server.midi.MidiService$Lifecycle";
    private static final String WIFI_SERVICE_CLASS = "com.android.server.wifi.WifiService";
    private static final String WIFI_AWARE_SERVICE_CLASS = "com.android.server.wifi.aware.WifiAwareService";
    private static final String WIFI_P2P_SERVICE_CLASS = "com.android.server.wifi.p2p.WifiP2pService";
    private static final String LOWPAN_SERVICE_CLASS = "com.android.server.lowpan.LowpanService";
    private static final String ETHERNET_SERVICE_CLASS = "com.android.server.ethernet.EthernetService";
    private static final String JOB_SCHEDULER_SERVICE_CLASS = "com.android.server.job.JobSchedulerService";
    private static final String LOCK_SETTINGS_SERVICE_CLASS = "com.android.server.locksettings.LockSettingsService$Lifecycle";
    private static final String STORAGE_MANAGER_SERVICE_CLASS = "com.android.server.StorageManagerService$Lifecycle";
    private static final String STORAGE_STATS_SERVICE_CLASS = "com.android.server.usage.StorageStatsService$Lifecycle";
    private static final String SEARCH_MANAGER_SERVICE_CLASS = "com.android.server.search.SearchManagerService$Lifecycle";
    private static final String THERMAL_OBSERVER_CLASS = "com.google.android.clockwork.ThermalObserver";
    private static final String WEAR_CONFIG_SERVICE_CLASS = "com.google.android.clockwork.WearConfigManagerService";
    private static final String WEAR_CONNECTIVITY_SERVICE_CLASS = "com.android.clockwork.connectivity.WearConnectivityService";
    private static final String WEAR_SIDEKICK_SERVICE_CLASS = "com.google.android.clockwork.sidekick.SidekickService";
    private static final String WEAR_DISPLAY_SERVICE_CLASS = "com.google.android.clockwork.display.WearDisplayService";
    private static final String WEAR_LEFTY_SERVICE_CLASS = "com.google.android.clockwork.lefty.WearLeftyService";
    private static final String WEAR_TIME_SERVICE_CLASS = "com.google.android.clockwork.time.WearTimeService";
    private static final String WEAR_GLOBAL_ACTIONS_SERVICE_CLASS = "com.android.clockwork.globalactions.GlobalActionsService";
    private static final String ACCOUNT_SERVICE_CLASS = "com.android.server.accounts.AccountManagerService$Lifecycle";
    private static final String CONTENT_SERVICE_CLASS = "com.android.server.content.ContentService$Lifecycle";
    private static final String WALLPAPER_SERVICE_CLASS = "com.android.server.wallpaper.WallpaperManagerService$Lifecycle";
    private static final String AUTO_FILL_MANAGER_SERVICE_CLASS = "com.android.server.autofill.AutofillManagerService";
    private static final String TIME_ZONE_RULES_MANAGER_SERVICE_CLASS = "com.android.server.timezone.RulesManagerService$Lifecycle";
    private static final String IOT_SERVICE_CLASS = "com.google.android.things.services.IoTSystemService";
    private static final String SLICE_MANAGER_SERVICE_CLASS = "com.android.server.slice.SliceManagerService$Lifecycle";
    private static final String CAR_SERVICE_HELPER_SERVICE_CLASS = "com.android.internal.car.CarServiceHelperService";
    private static final String PERSISTENT_DATA_BLOCK_PROP = "ro.frp.pst";
    private static final String UNCRYPT_PACKAGE_FILE = "/cache/recovery/uncrypt_file";
    private static final String BLOCK_MAP_FILE = "/cache/recovery/block.map";
    private static final int sMaxBinderThreads = 31;
    private static final int DEFAULT_SYSTEM_THEME = 16974803;
    private final int mFactoryTestMode = FactoryTest.getMode();
    private Timer mProfilerSnapshotTimer;
    private Context mSystemContext;
    private SystemServiceManager mSystemServiceManager;
    private PowerManagerService mPowerManagerService;
    private ActivityManagerService mActivityManagerService;
    private WebViewUpdateService mWebViewUpdateService;
    private DisplayManagerService mDisplayManagerService;
    private PackageManagerService mPackageManagerService;
    private PackageManager mPackageManager;
    private ContentResolver mContentResolver;
    private EntropyMixer mEntropyMixer;
    private boolean mOnlyCore;
    private boolean mFirstBoot;
    private final boolean mRuntimeRestart = "1".equals(SystemProperties.get("sys.boot_completed"));
    private final long mRuntimeStartElapsedTime = SystemClock.elapsedRealtime();
    private final long mRuntimeStartUptime = SystemClock.uptimeMillis();
    private static final String START_SENSOR_SERVICE = "StartSensorService";
    private static final String START_HIDL_SERVICES = "StartHidlServices";
    private Future<?> mSensorServiceStart;
    private Future<?> mZygotePreload;

    private static native void startSensorService();

    private static native void startHidlServices();

    public static void main(String[] args) {
        new SystemServer().run();
    }

    private void run() {
        try {
            String timezoneProperty;
            SystemServer.traceBeginAndSlog("InitBeforeStartServices");
            if (System.currentTimeMillis() < 86400000L) {
                Slog.w(TAG, "System clock is before 1970; setting to 1970.");
                SystemClock.setCurrentTimeMillis(86400000L);
            }
            if ((timezoneProperty = SystemProperties.get("persist.sys.timezone")) == null || timezoneProperty.isEmpty()) {
                Slog.w(TAG, "Timezone not set; setting to GMT.");
                SystemProperties.set("persist.sys.timezone", "GMT");
            }
            if (!SystemProperties.get("persist.sys.language").isEmpty()) {
                String languageTag = Locale.getDefault().toLanguageTag();
                SystemProperties.set("persist.sys.locale", languageTag);
                SystemProperties.set("persist.sys.language", "");
                SystemProperties.set("persist.sys.country", "");
                SystemProperties.set("persist.sys.localevar", "");
            }
            Binder.setWarnOnBlocking(true);
            PackageItemInfo.setForceSafeLabels(true);
            SQLiteCompatibilityWalFlags.init(null);
            Slog.i(TAG, "Entered the Android system server!");
            int uptimeMillis = (int)SystemClock.elapsedRealtime();
            EventLog.writeEvent(3010, uptimeMillis);
            if (!this.mRuntimeRestart) {
                MetricsLogger.histogram(null, "boot_system_server_init", uptimeMillis);
            }
            SystemProperties.set("persist.sys.dalvik.vm.lib.2", VMRuntime.getRuntime().vmLibrary());
            VMRuntime.getRuntime().clearGrowthLimit();
            VMRuntime.getRuntime().setTargetHeapUtilization(0.8f);
            Build.ensureFingerprintProperty();
            Environment.setUserRequired(true);
            BaseBundle.setShouldDefuse(true);
            Parcel.setStackTraceParceling(true);
            BinderInternal.disableBackgroundScheduling(true);
            BinderInternal.setMaxThreads(31);
            Process.setThreadPriority(-2);
            Process.setCanSelfBackground(false);
            Looper.prepareMainLooper();
            Looper.getMainLooper().setSlowLogThresholdMs(100L, 200L);
            System.loadLibrary("android_servers");
            this.performPendingShutdown();
            this.createSystemContext();
            this.mSystemServiceManager = new SystemServiceManager(this.mSystemContext);
            this.mSystemServiceManager.setStartInfo(this.mRuntimeRestart, this.mRuntimeStartElapsedTime, this.mRuntimeStartUptime);
            LocalServices.addService(SystemServiceManager.class, this.mSystemServiceManager);
            SystemServerInitThreadPool.get();
        }
        finally {
            SystemServer.traceEnd();
        }
        try {
            SystemServer.traceBeginAndSlog("StartServices");
            this.startBootstrapServices();
            this.startCoreServices();
            this.startOtherServices();
            SystemServerInitThreadPool.shutdown();
        }
        catch (Throwable ex) {
            Slog.e("System", "******************************************");
            Slog.e("System", "************ Failure starting system services", ex);
            throw ex;
        }
        finally {
            SystemServer.traceEnd();
        }
        StrictMode.initVmDefaults(null);
        if (!this.mRuntimeRestart && !this.isFirstBootOrUpgrade()) {
            int uptimeMillis = (int)SystemClock.elapsedRealtime();
            MetricsLogger.histogram(null, "boot_system_server_ready", uptimeMillis);
            int MAX_UPTIME_MILLIS = 60000;
            if (uptimeMillis > 60000) {
                Slog.wtf(SYSTEM_SERVER_TIMING_TAG, "SystemServer init took too long. uptimeMillis=" + uptimeMillis);
            }
        }
        Looper.loop();
        throw new RuntimeException("Main thread loop unexpectedly exited");
    }

    private boolean isFirstBootOrUpgrade() {
        return this.mPackageManagerService.isFirstBoot() || this.mPackageManagerService.isUpgrade();
    }

    private void reportWtf(String msg, Throwable e) {
        Slog.w(TAG, "***********************************************");
        Slog.wtf(TAG, "BOOT FAILURE " + msg, e);
    }

    private void performPendingShutdown() {
        String shutdownAction = SystemProperties.get("sys.shutdown.requested", "");
        if (shutdownAction != null && shutdownAction.length() > 0) {
            File packageFile;
            final boolean reboot = shutdownAction.charAt(0) == '1';
            final String reason = shutdownAction.length() > 1 ? shutdownAction.substring(1, shutdownAction.length()) : null;
            if (reason != null && reason.startsWith("recovery-update") && (packageFile = new File(UNCRYPT_PACKAGE_FILE)).exists()) {
                String filename = null;
                try {
                    filename = FileUtils.readTextFile(packageFile, 0, null);
                }
                catch (IOException e) {
                    Slog.e(TAG, "Error reading uncrypt package file", e);
                }
                if (filename != null && filename.startsWith("/data") && !new File(BLOCK_MAP_FILE).exists()) {
                    Slog.e(TAG, "Can't find block map file, uncrypt failed or unexpected runtime restart?");
                    return;
                }
            }
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        ShutdownThread.rebootOrShutdown(null, reboot, reason);
                    }
                }
            };
            Message msg = Message.obtain(UiThread.getHandler(), runnable);
            msg.setAsynchronous(true);
            UiThread.getHandler().sendMessage(msg);
        }
    }

    private void createSystemContext() {
        ActivityThread activityThread = ActivityThread.systemMain();
        this.mSystemContext = activityThread.getSystemContext();
        this.mSystemContext.setTheme(16974803);
        ContextImpl systemUiContext = activityThread.getSystemUiContext();
        ((Context)systemUiContext).setTheme(16974803);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startBootstrapServices() {
        boolean disableOtaDexopt;
        Slog.i(TAG, "Reading configuration...");
        String TAG_SYSTEM_CONFIG = "ReadingSystemConfig";
        SystemServer.traceBeginAndSlog("ReadingSystemConfig");
        SystemServerInitThreadPool.get().submit(SystemConfig::getInstance, "ReadingSystemConfig");
        SystemServer.traceEnd();
        SystemServer.traceBeginAndSlog("StartInstaller");
        Installer installer = this.mSystemServiceManager.startService(Installer.class);
        SystemServer.traceEnd();
        SystemServer.traceBeginAndSlog("DeviceIdentifiersPolicyService");
        this.mSystemServiceManager.startService(DeviceIdentifiersPolicyService.class);
        SystemServer.traceEnd();
        SystemServer.traceBeginAndSlog("StartActivityManager");
        this.mActivityManagerService = this.mSystemServiceManager.startService(ActivityManagerService.Lifecycle.class).getService();
        this.mActivityManagerService.setSystemServiceManager(this.mSystemServiceManager);
        this.mActivityManagerService.setInstaller(installer);
        SystemServer.traceEnd();
        SystemServer.traceBeginAndSlog("StartPowerManager");
        this.mPowerManagerService = this.mSystemServiceManager.startService(PowerManagerService.class);
        SystemServer.traceEnd();
        SystemServer.traceBeginAndSlog("InitPowerManagement");
        this.mActivityManagerService.initPowerManagement();
        SystemServer.traceEnd();
        SystemServer.traceBeginAndSlog("StartRecoverySystemService");
        this.mSystemServiceManager.startService(RecoverySystemService.class);
        SystemServer.traceEnd();
        RescueParty.noteBoot(this.mSystemContext);
        SystemServer.traceBeginAndSlog("StartLightsService");
        this.mSystemServiceManager.startService(LightsService.class);
        SystemServer.traceEnd();
        SystemServer.traceBeginAndSlog("StartSidekickService");
        if (SystemProperties.getBoolean("config.enable_sidekick_graphics", false)) {
            this.mSystemServiceManager.startService(WEAR_SIDEKICK_SERVICE_CLASS);
        }
        SystemServer.traceEnd();
        SystemServer.traceBeginAndSlog("StartDisplayManager");
        this.mDisplayManagerService = this.mSystemServiceManager.startService(DisplayManagerService.class);
        SystemServer.traceEnd();
        SystemServer.traceBeginAndSlog("WaitForDisplay");
        this.mSystemServiceManager.startBootPhase(100);
        SystemServer.traceEnd();
        String cryptState = SystemProperties.get("vold.decrypt");
        if (ENCRYPTING_STATE.equals(cryptState)) {
            Slog.w(TAG, "Detected encryption in progress - only parsing core apps");
            this.mOnlyCore = true;
        } else if (ENCRYPTED_STATE.equals(cryptState)) {
            Slog.w(TAG, "Device encrypted - only parsing core apps");
            this.mOnlyCore = true;
        }
        if (!this.mRuntimeRestart) {
            MetricsLogger.histogram(null, "boot_package_manager_init_start", (int)SystemClock.elapsedRealtime());
        }
        SystemServer.traceBeginAndSlog("StartPackageManagerService");
        this.mPackageManagerService = PackageManagerService.main(this.mSystemContext, installer, this.mFactoryTestMode != 0, this.mOnlyCore);
        this.mFirstBoot = this.mPackageManagerService.isFirstBoot();
        this.mPackageManager = this.mSystemContext.getPackageManager();
        SystemServer.traceEnd();
        if (!this.mRuntimeRestart && !this.isFirstBootOrUpgrade()) {
            MetricsLogger.histogram(null, "boot_package_manager_init_ready", (int)SystemClock.elapsedRealtime());
        }
        if (!this.mOnlyCore && !(disableOtaDexopt = SystemProperties.getBoolean("config.disable_otadexopt", false))) {
            SystemServer.traceBeginAndSlog("StartOtaDexOptService");
            try {
                OtaDexoptService.main(this.mSystemContext, this.mPackageManagerService);
            }
            catch (Throwable e) {
                this.reportWtf("starting OtaDexOptService", e);
            }
            finally {
                SystemServer.traceEnd();
            }
        }
        SystemServer.traceBeginAndSlog("StartUserManagerService");
        this.mSystemServiceManager.startService(UserManagerService.LifeCycle.class);
        SystemServer.traceEnd();
        SystemServer.traceBeginAndSlog("InitAttributerCache");
        AttributeCache.init(this.mSystemContext);
        SystemServer.traceEnd();
        SystemServer.traceBeginAndSlog("SetSystemProcess");
        this.mActivityManagerService.setSystemProcess();
        SystemServer.traceEnd();
        this.mDisplayManagerService.setupSchedulerPolicies();
        SystemServer.traceBeginAndSlog("StartOverlayManagerService");
        this.mSystemServiceManager.startService(new OverlayManagerService(this.mSystemContext, installer));
        SystemServer.traceEnd();
        this.mSensorServiceStart = SystemServerInitThreadPool.get().submit(() -> {
            TimingsTraceLog traceLog = new TimingsTraceLog(SYSTEM_SERVER_TIMING_ASYNC_TAG, 524288L);
            traceLog.traceBegin(START_SENSOR_SERVICE);
            SystemServer.startSensorService();
            traceLog.traceEnd();
        }, START_SENSOR_SERVICE);
    }

    private void startCoreServices() {
        SystemServer.traceBeginAndSlog("StartBatteryService");
        this.mSystemServiceManager.startService(BatteryService.class);
        SystemServer.traceEnd();
        SystemServer.traceBeginAndSlog("StartUsageService");
        this.mSystemServiceManager.startService(UsageStatsService.class);
        this.mActivityManagerService.setUsageStatsManager(LocalServices.getService(UsageStatsManagerInternal.class));
        SystemServer.traceEnd();
        if (this.mPackageManager.hasSystemFeature("android.software.webview")) {
            SystemServer.traceBeginAndSlog("StartWebViewUpdateService");
            this.mWebViewUpdateService = this.mSystemServiceManager.startService(WebViewUpdateService.class);
            SystemServer.traceEnd();
        }
        SystemServer.traceBeginAndSlog("StartBinderCallsStatsService");
        BinderCallsStatsService.start();
        SystemServer.traceEnd();
    }

    private void startOtherServices() {
        String[] classes;
        Context context = this.mSystemContext;
        VibratorService vibrator = null;
        IStorageManager storageManager = null;
        NetworkManagementService networkManagement = null;
        IpSecService ipSecService = null;
        NetworkStatsService networkStats = null;
        NetworkPolicyManagerService networkPolicy = null;
        ConnectivityService connectivity = null;
        NsdService serviceDiscovery = null;
        WindowManagerService wm = null;
        SerialService serial = null;
        NetworkTimeUpdateService networkTimeUpdater = null;
        CommonTimeManagementService commonTimeMgmtService = null;
        InputManagerService inputManager = null;
        TelephonyRegistry telephonyRegistry = null;
        ConsumerIrService consumerIr = null;
        MmsServiceBroker mmsService = null;
        HardwarePropertiesManagerService hardwarePropertiesService = null;
        boolean disableSystemTextClassifier = SystemProperties.getBoolean("config.disable_systemtextclassifier", false);
        boolean disableCameraService = SystemProperties.getBoolean("config.disable_cameraservice", false);
        boolean disableSlices = SystemProperties.getBoolean("config.disable_slices", false);
        boolean enableLeftyService = SystemProperties.getBoolean("config.enable_lefty", false);
        boolean isEmulator = SystemProperties.get("ro.kernel.qemu").equals(ENCRYPTED_STATE);
        boolean isWatch = context.getPackageManager().hasSystemFeature("android.hardware.type.watch");
        if (Build.IS_DEBUGGABLE && SystemProperties.getBoolean("debug.crash_system", false)) {
            throw new RuntimeException();
        }
        try {
            String SECONDARY_ZYGOTE_PRELOAD = "SecondaryZygotePreload";
            this.mZygotePreload = SystemServerInitThreadPool.get().submit(() -> {
                try {
                    Slog.i(TAG, "SecondaryZygotePreload");
                    TimingsTraceLog traceLog = new TimingsTraceLog(SYSTEM_SERVER_TIMING_ASYNC_TAG, 524288L);
                    traceLog.traceBegin("SecondaryZygotePreload");
                    if (!Process.zygoteProcess.preloadDefault(Build.SUPPORTED_32_BIT_ABIS[0])) {
                        Slog.e(TAG, "Unable to preload default resources");
                    }
                    traceLog.traceEnd();
                }
                catch (Exception ex) {
                    Slog.e(TAG, "Exception preloading default resources", ex);
                }
            }, "SecondaryZygotePreload");
            SystemServer.traceBeginAndSlog("StartKeyAttestationApplicationIdProviderService");
            ServiceManager.addService("sec_key_att_app_id_provider", new KeyAttestationApplicationIdProviderService(context));
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartKeyChainSystemService");
            this.mSystemServiceManager.startService(KeyChainSystemService.class);
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartSchedulingPolicyService");
            ServiceManager.addService("scheduling_policy", new SchedulingPolicyService());
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartTelecomLoaderService");
            this.mSystemServiceManager.startService(TelecomLoaderService.class);
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartTelephonyRegistry");
            telephonyRegistry = new TelephonyRegistry(context);
            ServiceManager.addService("telephony.registry", telephonyRegistry);
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartEntropyMixer");
            this.mEntropyMixer = new EntropyMixer(context);
            SystemServer.traceEnd();
            this.mContentResolver = context.getContentResolver();
            SystemServer.traceBeginAndSlog("StartAccountManagerService");
            this.mSystemServiceManager.startService(ACCOUNT_SERVICE_CLASS);
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartContentService");
            this.mSystemServiceManager.startService(CONTENT_SERVICE_CLASS);
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("InstallSystemProviders");
            this.mActivityManagerService.installSystemProviders();
            SQLiteCompatibilityWalFlags.reset();
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartDropBoxManager");
            this.mSystemServiceManager.startService(DropBoxManagerService.class);
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartVibratorService");
            vibrator = new VibratorService(context);
            ServiceManager.addService("vibrator", vibrator);
            SystemServer.traceEnd();
            if (!isWatch) {
                SystemServer.traceBeginAndSlog("StartConsumerIrService");
                consumerIr = new ConsumerIrService(context);
                ServiceManager.addService("consumer_ir", consumerIr);
                SystemServer.traceEnd();
            }
            SystemServer.traceBeginAndSlog("StartAlarmManagerService");
            this.mSystemServiceManager.startService(AlarmManagerService.class);
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("InitWatchdog");
            Watchdog watchdog = Watchdog.getInstance();
            watchdog.init(context, this.mActivityManagerService);
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartInputManagerService");
            inputManager = new InputManagerService(context);
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartWindowManagerService");
            ConcurrentUtils.waitForFutureNoInterrupt(this.mSensorServiceStart, START_SENSOR_SERVICE);
            this.mSensorServiceStart = null;
            wm = WindowManagerService.main(context, inputManager, this.mFactoryTestMode != 1, !this.mFirstBoot, this.mOnlyCore, new PhoneWindowManager());
            ServiceManager.addService("window", wm, false, 17);
            ServiceManager.addService("input", inputManager, false, 1);
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("SetWindowManagerService");
            this.mActivityManagerService.setWindowManager(wm);
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("WindowManagerServiceOnInitReady");
            wm.onInitReady();
            SystemServer.traceEnd();
            SystemServerInitThreadPool.get().submit(() -> {
                TimingsTraceLog traceLog = new TimingsTraceLog(SYSTEM_SERVER_TIMING_ASYNC_TAG, 524288L);
                traceLog.traceBegin(START_HIDL_SERVICES);
                SystemServer.startHidlServices();
                traceLog.traceEnd();
            }, START_HIDL_SERVICES);
            if (!isWatch) {
                SystemServer.traceBeginAndSlog("StartVrManagerService");
                this.mSystemServiceManager.startService(VrManagerService.class);
                SystemServer.traceEnd();
            }
            SystemServer.traceBeginAndSlog("StartInputManager");
            inputManager.setWindowManagerCallbacks(wm.getInputMonitor());
            inputManager.start();
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("DisplayManagerWindowManagerAndInputReady");
            this.mDisplayManagerService.windowManagerAndInputReady();
            SystemServer.traceEnd();
            if (isEmulator) {
                Slog.i(TAG, "No Bluetooth Service (emulator)");
            } else if (this.mFactoryTestMode == 1) {
                Slog.i(TAG, "No Bluetooth Service (factory test)");
            } else if (!context.getPackageManager().hasSystemFeature("android.hardware.bluetooth")) {
                Slog.i(TAG, "No Bluetooth Service (Bluetooth Hardware Not Present)");
            } else {
                SystemServer.traceBeginAndSlog("StartBluetoothService");
                this.mSystemServiceManager.startService(BluetoothService.class);
                SystemServer.traceEnd();
            }
            SystemServer.traceBeginAndSlog("IpConnectivityMetrics");
            this.mSystemServiceManager.startService(IpConnectivityMetrics.class);
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("NetworkWatchlistService");
            this.mSystemServiceManager.startService(NetworkWatchlistService.Lifecycle.class);
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("PinnerService");
            this.mSystemServiceManager.startService(PinnerService.class);
            SystemServer.traceEnd();
        }
        catch (RuntimeException e) {
            Slog.e("System", "******************************************");
            Slog.e("System", "************ Failure starting core service", e);
        }
        StatusBarManagerService statusBar = null;
        INotificationManager notification = null;
        LocationManagerService location = null;
        CountryDetectorService countryDetector = null;
        ILockSettings lockSettings = null;
        MediaRouterService mediaRouter = null;
        if (this.mFactoryTestMode != 1) {
            SystemServer.traceBeginAndSlog("StartInputMethodManagerLifecycle");
            this.mSystemServiceManager.startService(InputMethodManagerService.Lifecycle.class);
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartAccessibilityManagerService");
            try {
                ServiceManager.addService("accessibility", new AccessibilityManagerService(context));
            }
            catch (Throwable e) {
                this.reportWtf("starting Accessibility Manager", e);
            }
            SystemServer.traceEnd();
        }
        SystemServer.traceBeginAndSlog("MakeDisplayReady");
        try {
            wm.displayReady();
        }
        catch (Throwable e) {
            this.reportWtf("making display ready", e);
        }
        SystemServer.traceEnd();
        if (this.mFactoryTestMode != 1 && !"0".equals(SystemProperties.get("system_init.startmountservice"))) {
            SystemServer.traceBeginAndSlog("StartStorageManagerService");
            try {
                this.mSystemServiceManager.startService(STORAGE_MANAGER_SERVICE_CLASS);
                storageManager = IStorageManager.Stub.asInterface(ServiceManager.getService("mount"));
            }
            catch (Throwable e) {
                this.reportWtf("starting StorageManagerService", e);
            }
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartStorageStatsService");
            try {
                this.mSystemServiceManager.startService(STORAGE_STATS_SERVICE_CLASS);
            }
            catch (Throwable e) {
                this.reportWtf("starting StorageStatsService", e);
            }
            SystemServer.traceEnd();
        }
        SystemServer.traceBeginAndSlog("StartUiModeManager");
        this.mSystemServiceManager.startService(UiModeManagerService.class);
        SystemServer.traceEnd();
        if (!this.mOnlyCore) {
            SystemServer.traceBeginAndSlog("UpdatePackagesIfNeeded");
            try {
                this.mPackageManagerService.updatePackagesIfNeeded();
            }
            catch (Throwable e) {
                this.reportWtf("update packages", e);
            }
            SystemServer.traceEnd();
        }
        SystemServer.traceBeginAndSlog("PerformFstrimIfNeeded");
        try {
            this.mPackageManagerService.performFstrimIfNeeded();
        }
        catch (Throwable e) {
            this.reportWtf("performing fstrim", e);
        }
        SystemServer.traceEnd();
        if (this.mFactoryTestMode != 1) {
            boolean startRulesManagerService;
            boolean hasPdb;
            SystemServer.traceBeginAndSlog("StartLockSettingsService");
            try {
                this.mSystemServiceManager.startService(LOCK_SETTINGS_SERVICE_CLASS);
                lockSettings = ILockSettings.Stub.asInterface(ServiceManager.getService("lock_settings"));
            }
            catch (Throwable e) {
                this.reportWtf("starting LockSettingsService service", e);
            }
            SystemServer.traceEnd();
            boolean bl = hasPdb = !SystemProperties.get(PERSISTENT_DATA_BLOCK_PROP).equals("");
            if (hasPdb) {
                SystemServer.traceBeginAndSlog("StartPersistentDataBlock");
                this.mSystemServiceManager.startService(PersistentDataBlockService.class);
                SystemServer.traceEnd();
            }
            if (hasPdb || OemLockService.isHalPresent()) {
                SystemServer.traceBeginAndSlog("StartOemLockService");
                this.mSystemServiceManager.startService(OemLockService.class);
                SystemServer.traceEnd();
            }
            SystemServer.traceBeginAndSlog("StartDeviceIdleController");
            this.mSystemServiceManager.startService(DeviceIdleController.class);
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartDevicePolicyManager");
            this.mSystemServiceManager.startService(DevicePolicyManagerService.Lifecycle.class);
            SystemServer.traceEnd();
            if (!isWatch) {
                SystemServer.traceBeginAndSlog("StartStatusBarManagerService");
                try {
                    statusBar = new StatusBarManagerService(context, wm);
                    ServiceManager.addService("statusbar", statusBar);
                }
                catch (Throwable e) {
                    this.reportWtf("starting StatusBarManagerService", e);
                }
                SystemServer.traceEnd();
            }
            SystemServer.traceBeginAndSlog("StartClipboardService");
            this.mSystemServiceManager.startService(ClipboardService.class);
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartNetworkManagementService");
            try {
                networkManagement = NetworkManagementService.create(context);
                ServiceManager.addService("network_management", networkManagement);
            }
            catch (Throwable e) {
                this.reportWtf("starting NetworkManagement Service", e);
            }
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartIpSecService");
            try {
                ipSecService = IpSecService.create(context);
                ServiceManager.addService("ipsec", ipSecService);
            }
            catch (Throwable e) {
                this.reportWtf("starting IpSec Service", e);
            }
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartTextServicesManager");
            this.mSystemServiceManager.startService(TextServicesManagerService.Lifecycle.class);
            SystemServer.traceEnd();
            if (!disableSystemTextClassifier) {
                SystemServer.traceBeginAndSlog("StartTextClassificationManagerService");
                this.mSystemServiceManager.startService(TextClassificationManagerService.Lifecycle.class);
                SystemServer.traceEnd();
            }
            SystemServer.traceBeginAndSlog("StartNetworkScoreService");
            this.mSystemServiceManager.startService(NetworkScoreService.Lifecycle.class);
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartNetworkStatsService");
            try {
                networkStats = NetworkStatsService.create(context, networkManagement);
                ServiceManager.addService("netstats", networkStats);
            }
            catch (Throwable e) {
                this.reportWtf("starting NetworkStats Service", e);
            }
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartNetworkPolicyManagerService");
            try {
                networkPolicy = new NetworkPolicyManagerService(context, this.mActivityManagerService, networkManagement);
                ServiceManager.addService("netpolicy", networkPolicy);
            }
            catch (Throwable e) {
                this.reportWtf("starting NetworkPolicy Service", e);
            }
            SystemServer.traceEnd();
            if (!this.mOnlyCore) {
                if (context.getPackageManager().hasSystemFeature("android.hardware.wifi")) {
                    SystemServer.traceBeginAndSlog("StartWifi");
                    this.mSystemServiceManager.startService(WIFI_SERVICE_CLASS);
                    SystemServer.traceEnd();
                    SystemServer.traceBeginAndSlog("StartWifiScanning");
                    this.mSystemServiceManager.startService("com.android.server.wifi.scanner.WifiScanningService");
                    SystemServer.traceEnd();
                }
                if (context.getPackageManager().hasSystemFeature("android.hardware.wifi.rtt")) {
                    SystemServer.traceBeginAndSlog("StartRttService");
                    this.mSystemServiceManager.startService("com.android.server.wifi.rtt.RttService");
                    SystemServer.traceEnd();
                }
                if (context.getPackageManager().hasSystemFeature("android.hardware.wifi.aware")) {
                    SystemServer.traceBeginAndSlog("StartWifiAware");
                    this.mSystemServiceManager.startService(WIFI_AWARE_SERVICE_CLASS);
                    SystemServer.traceEnd();
                }
                if (context.getPackageManager().hasSystemFeature("android.hardware.wifi.direct")) {
                    SystemServer.traceBeginAndSlog("StartWifiP2P");
                    this.mSystemServiceManager.startService(WIFI_P2P_SERVICE_CLASS);
                    SystemServer.traceEnd();
                }
                if (context.getPackageManager().hasSystemFeature("android.hardware.lowpan")) {
                    SystemServer.traceBeginAndSlog("StartLowpan");
                    this.mSystemServiceManager.startService(LOWPAN_SERVICE_CLASS);
                    SystemServer.traceEnd();
                }
            }
            if (this.mPackageManager.hasSystemFeature("android.hardware.ethernet") || this.mPackageManager.hasSystemFeature("android.hardware.usb.host")) {
                SystemServer.traceBeginAndSlog("StartEthernet");
                this.mSystemServiceManager.startService(ETHERNET_SERVICE_CLASS);
                SystemServer.traceEnd();
            }
            SystemServer.traceBeginAndSlog("StartConnectivityService");
            try {
                connectivity = new ConnectivityService(context, networkManagement, networkStats, networkPolicy);
                ServiceManager.addService("connectivity", connectivity, false, 6);
                networkStats.bindConnectivityManager(connectivity);
                networkPolicy.bindConnectivityManager(connectivity);
            }
            catch (Throwable e) {
                this.reportWtf("starting Connectivity Service", e);
            }
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartNsdService");
            try {
                serviceDiscovery = NsdService.create(context);
                ServiceManager.addService("servicediscovery", serviceDiscovery);
            }
            catch (Throwable e) {
                this.reportWtf("starting Service Discovery Service", e);
            }
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartSystemUpdateManagerService");
            try {
                ServiceManager.addService("system_update", new SystemUpdateManagerService(context));
            }
            catch (Throwable e) {
                this.reportWtf("starting SystemUpdateManagerService", e);
            }
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartUpdateLockService");
            try {
                ServiceManager.addService("updatelock", new UpdateLockService(context));
            }
            catch (Throwable e) {
                this.reportWtf("starting UpdateLockService", e);
            }
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartNotificationManager");
            this.mSystemServiceManager.startService(NotificationManagerService.class);
            SystemNotificationChannels.createAll(context);
            notification = INotificationManager.Stub.asInterface(ServiceManager.getService("notification"));
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartDeviceMonitor");
            this.mSystemServiceManager.startService(DeviceStorageMonitorService.class);
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartLocationManagerService");
            try {
                location = new LocationManagerService(context);
                ServiceManager.addService("location", location);
            }
            catch (Throwable e) {
                this.reportWtf("starting Location Manager", e);
            }
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartCountryDetectorService");
            try {
                countryDetector = new CountryDetectorService(context);
                ServiceManager.addService("country_detector", countryDetector);
            }
            catch (Throwable e) {
                this.reportWtf("starting Country Detector", e);
            }
            SystemServer.traceEnd();
            if (!isWatch) {
                SystemServer.traceBeginAndSlog("StartSearchManagerService");
                try {
                    this.mSystemServiceManager.startService(SEARCH_MANAGER_SERVICE_CLASS);
                }
                catch (Throwable e) {
                    this.reportWtf("starting Search Service", e);
                }
                SystemServer.traceEnd();
            }
            if (context.getResources().getBoolean(17956970)) {
                SystemServer.traceBeginAndSlog("StartWallpaperManagerService");
                this.mSystemServiceManager.startService(WALLPAPER_SERVICE_CLASS);
                SystemServer.traceEnd();
            }
            SystemServer.traceBeginAndSlog("StartAudioService");
            this.mSystemServiceManager.startService(AudioService.Lifecycle.class);
            SystemServer.traceEnd();
            if (this.mPackageManager.hasSystemFeature("android.hardware.broadcastradio")) {
                SystemServer.traceBeginAndSlog("StartBroadcastRadioService");
                this.mSystemServiceManager.startService(BroadcastRadioService.class);
                SystemServer.traceEnd();
            }
            SystemServer.traceBeginAndSlog("StartDockObserver");
            this.mSystemServiceManager.startService(DockObserver.class);
            SystemServer.traceEnd();
            if (isWatch) {
                SystemServer.traceBeginAndSlog("StartThermalObserver");
                this.mSystemServiceManager.startService(THERMAL_OBSERVER_CLASS);
                SystemServer.traceEnd();
            }
            SystemServer.traceBeginAndSlog("StartWiredAccessoryManager");
            try {
                inputManager.setWiredAccessoryCallbacks(new WiredAccessoryManager(context, inputManager));
            }
            catch (Throwable e) {
                this.reportWtf("starting WiredAccessoryManager", e);
            }
            SystemServer.traceEnd();
            if (this.mPackageManager.hasSystemFeature("android.software.midi")) {
                SystemServer.traceBeginAndSlog("StartMidiManager");
                this.mSystemServiceManager.startService(MIDI_SERVICE_CLASS);
                SystemServer.traceEnd();
            }
            if (this.mPackageManager.hasSystemFeature("android.hardware.usb.host") || this.mPackageManager.hasSystemFeature("android.hardware.usb.accessory") || isEmulator) {
                SystemServer.traceBeginAndSlog("StartUsbService");
                this.mSystemServiceManager.startService(USB_SERVICE_CLASS);
                SystemServer.traceEnd();
            }
            if (!isWatch) {
                SystemServer.traceBeginAndSlog("StartSerialService");
                try {
                    serial = new SerialService(context);
                    ServiceManager.addService("serial", serial);
                }
                catch (Throwable e) {
                    Slog.e(TAG, "Failure starting SerialService", e);
                }
                SystemServer.traceEnd();
            }
            SystemServer.traceBeginAndSlog("StartHardwarePropertiesManagerService");
            try {
                hardwarePropertiesService = new HardwarePropertiesManagerService(context);
                ServiceManager.addService("hardware_properties", hardwarePropertiesService);
            }
            catch (Throwable e) {
                Slog.e(TAG, "Failure starting HardwarePropertiesManagerService", e);
            }
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartTwilightService");
            this.mSystemServiceManager.startService(TwilightService.class);
            SystemServer.traceEnd();
            if (ColorDisplayController.isAvailable(context)) {
                SystemServer.traceBeginAndSlog("StartNightDisplay");
                this.mSystemServiceManager.startService(ColorDisplayService.class);
                SystemServer.traceEnd();
            }
            SystemServer.traceBeginAndSlog("StartJobScheduler");
            this.mSystemServiceManager.startService(JobSchedulerService.class);
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartSoundTrigger");
            this.mSystemServiceManager.startService(SoundTriggerService.class);
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartTrustManager");
            this.mSystemServiceManager.startService(TrustManagerService.class);
            SystemServer.traceEnd();
            if (this.mPackageManager.hasSystemFeature("android.software.backup")) {
                SystemServer.traceBeginAndSlog("StartBackupManager");
                this.mSystemServiceManager.startService(BACKUP_MANAGER_SERVICE_CLASS);
                SystemServer.traceEnd();
            }
            if (this.mPackageManager.hasSystemFeature("android.software.app_widgets") || context.getResources().getBoolean(17956950)) {
                SystemServer.traceBeginAndSlog("StartAppWidgerService");
                this.mSystemServiceManager.startService(APPWIDGET_SERVICE_CLASS);
                SystemServer.traceEnd();
            }
            SystemServer.traceBeginAndSlog("StartVoiceRecognitionManager");
            this.mSystemServiceManager.startService(VOICE_RECOGNITION_MANAGER_SERVICE_CLASS);
            SystemServer.traceEnd();
            if (GestureLauncherService.isGestureLauncherEnabled(context.getResources())) {
                SystemServer.traceBeginAndSlog("StartGestureLauncher");
                this.mSystemServiceManager.startService(GestureLauncherService.class);
                SystemServer.traceEnd();
            }
            SystemServer.traceBeginAndSlog("StartSensorNotification");
            this.mSystemServiceManager.startService(SensorNotificationService.class);
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartContextHubSystemService");
            this.mSystemServiceManager.startService(ContextHubSystemService.class);
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartDiskStatsService");
            try {
                ServiceManager.addService("diskstats", new DiskStatsService(context));
            }
            catch (Throwable e) {
                this.reportWtf("starting DiskStats Service", e);
            }
            SystemServer.traceEnd();
            boolean bl2 = startRulesManagerService = !this.mOnlyCore && context.getResources().getBoolean(17956969);
            if (startRulesManagerService) {
                SystemServer.traceBeginAndSlog("StartTimeZoneRulesManagerService");
                this.mSystemServiceManager.startService(TIME_ZONE_RULES_MANAGER_SERVICE_CLASS);
                SystemServer.traceEnd();
            }
            if (!isWatch) {
                SystemServer.traceBeginAndSlog("StartNetworkTimeUpdateService");
                try {
                    networkTimeUpdater = new NetworkTimeUpdateService(context);
                    ServiceManager.addService("network_time_update_service", networkTimeUpdater);
                }
                catch (Throwable e) {
                    this.reportWtf("starting NetworkTimeUpdate service", e);
                }
                SystemServer.traceEnd();
            }
            SystemServer.traceBeginAndSlog("StartCommonTimeManagementService");
            try {
                commonTimeMgmtService = new CommonTimeManagementService(context);
                ServiceManager.addService("commontime_management", commonTimeMgmtService);
            }
            catch (Throwable e) {
                this.reportWtf("starting CommonTimeManagementService service", e);
            }
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("CertBlacklister");
            try {
                CertBlacklister e = new CertBlacklister(context);
            }
            catch (Throwable e) {
                this.reportWtf("starting CertBlacklister", e);
            }
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartEmergencyAffordanceService");
            this.mSystemServiceManager.startService(EmergencyAffordanceService.class);
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartDreamManager");
            this.mSystemServiceManager.startService(DreamManagerService.class);
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("AddGraphicsStatsService");
            ServiceManager.addService("graphicsstats", new GraphicsStatsService(context));
            SystemServer.traceEnd();
            if (CoverageService.ENABLED) {
                SystemServer.traceBeginAndSlog("AddCoverageService");
                ServiceManager.addService("coverage", new CoverageService());
                SystemServer.traceEnd();
            }
            if (this.mPackageManager.hasSystemFeature("android.software.print")) {
                SystemServer.traceBeginAndSlog("StartPrintManager");
                this.mSystemServiceManager.startService(PRINT_MANAGER_SERVICE_CLASS);
                SystemServer.traceEnd();
            }
            if (this.mPackageManager.hasSystemFeature("android.software.companion_device_setup")) {
                SystemServer.traceBeginAndSlog("StartCompanionDeviceManager");
                this.mSystemServiceManager.startService(COMPANION_DEVICE_MANAGER_SERVICE_CLASS);
                SystemServer.traceEnd();
            }
            SystemServer.traceBeginAndSlog("StartRestrictionManager");
            this.mSystemServiceManager.startService(RestrictionsManagerService.class);
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartMediaSessionService");
            this.mSystemServiceManager.startService(MediaSessionService.class);
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartMediaUpdateService");
            this.mSystemServiceManager.startService(MediaUpdateService.class);
            SystemServer.traceEnd();
            if (this.mPackageManager.hasSystemFeature("android.hardware.hdmi.cec")) {
                SystemServer.traceBeginAndSlog("StartHdmiControlService");
                this.mSystemServiceManager.startService(HdmiControlService.class);
                SystemServer.traceEnd();
            }
            if (this.mPackageManager.hasSystemFeature("android.software.live_tv") || this.mPackageManager.hasSystemFeature("android.software.leanback")) {
                SystemServer.traceBeginAndSlog("StartTvInputManager");
                this.mSystemServiceManager.startService(TvInputManagerService.class);
                SystemServer.traceEnd();
            }
            if (this.mPackageManager.hasSystemFeature("android.software.picture_in_picture")) {
                SystemServer.traceBeginAndSlog("StartMediaResourceMonitor");
                this.mSystemServiceManager.startService(MediaResourceMonitorService.class);
                SystemServer.traceEnd();
            }
            if (this.mPackageManager.hasSystemFeature("android.software.leanback")) {
                SystemServer.traceBeginAndSlog("StartTvRemoteService");
                this.mSystemServiceManager.startService(TvRemoteService.class);
                SystemServer.traceEnd();
            }
            SystemServer.traceBeginAndSlog("StartMediaRouterService");
            try {
                mediaRouter = new MediaRouterService(context);
                ServiceManager.addService("media_router", mediaRouter);
            }
            catch (Throwable e) {
                this.reportWtf("starting MediaRouterService", e);
            }
            SystemServer.traceEnd();
            if (this.mPackageManager.hasSystemFeature("android.hardware.fingerprint")) {
                SystemServer.traceBeginAndSlog("StartFingerprintSensor");
                this.mSystemServiceManager.startService(FingerprintService.class);
                SystemServer.traceEnd();
            }
            SystemServer.traceBeginAndSlog("StartBackgroundDexOptService");
            try {
                BackgroundDexOptService.schedule(context);
            }
            catch (Throwable e) {
                this.reportWtf("starting StartBackgroundDexOptService", e);
            }
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartPruneInstantAppsJobService");
            try {
                PruneInstantAppsJobService.schedule(context);
            }
            catch (Throwable e) {
                this.reportWtf("StartPruneInstantAppsJobService", e);
            }
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartShortcutServiceLifecycle");
            this.mSystemServiceManager.startService(ShortcutService.Lifecycle.class);
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartLauncherAppsService");
            this.mSystemServiceManager.startService(LauncherAppsService.class);
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartCrossProfileAppsService");
            this.mSystemServiceManager.startService(CrossProfileAppsService.class);
            SystemServer.traceEnd();
        }
        if (!isWatch) {
            SystemServer.traceBeginAndSlog("StartMediaProjectionManager");
            this.mSystemServiceManager.startService(MediaProjectionManagerService.class);
            SystemServer.traceEnd();
        }
        if (isWatch) {
            SystemServer.traceBeginAndSlog("StartWearConfigService");
            this.mSystemServiceManager.startService(WEAR_CONFIG_SERVICE_CLASS);
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartWearConnectivityService");
            this.mSystemServiceManager.startService(WEAR_CONNECTIVITY_SERVICE_CLASS);
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartWearTimeService");
            this.mSystemServiceManager.startService(WEAR_DISPLAY_SERVICE_CLASS);
            this.mSystemServiceManager.startService(WEAR_TIME_SERVICE_CLASS);
            SystemServer.traceEnd();
            if (enableLeftyService) {
                SystemServer.traceBeginAndSlog("StartWearLeftyService");
                this.mSystemServiceManager.startService(WEAR_LEFTY_SERVICE_CLASS);
                SystemServer.traceEnd();
            }
            SystemServer.traceBeginAndSlog("StartWearGlobalActionsService");
            this.mSystemServiceManager.startService(WEAR_GLOBAL_ACTIONS_SERVICE_CLASS);
            SystemServer.traceEnd();
        }
        if (!disableSlices) {
            SystemServer.traceBeginAndSlog("StartSliceManagerService");
            this.mSystemServiceManager.startService(SLICE_MANAGER_SERVICE_CLASS);
            SystemServer.traceEnd();
        }
        if (!disableCameraService) {
            SystemServer.traceBeginAndSlog("StartCameraServiceProxy");
            this.mSystemServiceManager.startService(CameraServiceProxy.class);
            SystemServer.traceEnd();
        }
        if (context.getPackageManager().hasSystemFeature("android.hardware.type.embedded")) {
            SystemServer.traceBeginAndSlog("StartIoTSystemService");
            this.mSystemServiceManager.startService(IOT_SERVICE_CLASS);
            SystemServer.traceEnd();
        }
        SystemServer.traceBeginAndSlog("StartStatsCompanionService");
        this.mSystemServiceManager.startService(StatsCompanionService.Lifecycle.class);
        SystemServer.traceEnd();
        boolean safeMode = wm.detectSafeMode();
        if (safeMode) {
            SystemServer.traceBeginAndSlog("EnterSafeModeAndDisableJitCompilation");
            this.mActivityManagerService.enterSafeMode();
            VMRuntime.getRuntime().disableJitCompilation();
            SystemServer.traceEnd();
        } else {
            SystemServer.traceBeginAndSlog("StartJitCompilation");
            VMRuntime.getRuntime().startJitCompilation();
            SystemServer.traceEnd();
        }
        SystemServer.traceBeginAndSlog("StartMmsService");
        mmsService = this.mSystemServiceManager.startService(MmsServiceBroker.class);
        SystemServer.traceEnd();
        if (this.mPackageManager.hasSystemFeature("android.software.autofill")) {
            SystemServer.traceBeginAndSlog("StartAutoFillService");
            this.mSystemServiceManager.startService(AUTO_FILL_MANAGER_SERVICE_CLASS);
            SystemServer.traceEnd();
        }
        SystemServer.traceBeginAndSlog("MakeVibratorServiceReady");
        try {
            vibrator.systemReady();
        }
        catch (Throwable e) {
            this.reportWtf("making Vibrator Service ready", e);
        }
        SystemServer.traceEnd();
        SystemServer.traceBeginAndSlog("MakeLockSettingsServiceReady");
        if (lockSettings != null) {
            try {
                lockSettings.systemReady();
            }
            catch (Throwable e) {
                this.reportWtf("making Lock Settings Service ready", e);
            }
        }
        SystemServer.traceEnd();
        SystemServer.traceBeginAndSlog("StartBootPhaseLockSettingsReady");
        this.mSystemServiceManager.startBootPhase(480);
        SystemServer.traceEnd();
        SystemServer.traceBeginAndSlog("StartBootPhaseSystemServicesReady");
        this.mSystemServiceManager.startBootPhase(500);
        SystemServer.traceEnd();
        SystemServer.traceBeginAndSlog("MakeWindowManagerServiceReady");
        try {
            wm.systemReady();
        }
        catch (Throwable e) {
            this.reportWtf("making Window Manager Service ready", e);
        }
        SystemServer.traceEnd();
        if (safeMode) {
            this.mActivityManagerService.showSafeModeOverlay();
        }
        Configuration config = wm.computeNewConfiguration(0);
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager w = (WindowManager)context.getSystemService("window");
        w.getDefaultDisplay().getMetrics(metrics);
        context.getResources().updateConfiguration(config, metrics);
        Resources.Theme systemTheme = context.getTheme();
        if (systemTheme.getChangingConfigurations() != 0) {
            systemTheme.rebase();
        }
        SystemServer.traceBeginAndSlog("MakePowerManagerServiceReady");
        try {
            this.mPowerManagerService.systemReady(this.mActivityManagerService.getAppOpsService());
        }
        catch (Throwable e) {
            this.reportWtf("making Power Manager Service ready", e);
        }
        SystemServer.traceEnd();
        SystemServer.traceBeginAndSlog("MakePackageManagerServiceReady");
        this.mPackageManagerService.systemReady();
        SystemServer.traceEnd();
        SystemServer.traceBeginAndSlog("MakeDisplayManagerServiceReady");
        try {
            this.mDisplayManagerService.systemReady(safeMode, this.mOnlyCore);
        }
        catch (Throwable e) {
            this.reportWtf("making Display Manager Service ready", e);
        }
        SystemServer.traceEnd();
        this.mSystemServiceManager.setSafeMode(safeMode);
        SystemServer.traceBeginAndSlog("StartDeviceSpecificServices");
        for (String className : classes = this.mSystemContext.getResources().getStringArray(17236002)) {
            SystemServer.traceBeginAndSlog("StartDeviceSpecificServices " + className);
            try {
                this.mSystemServiceManager.startService(className);
            }
            catch (Throwable e) {
                this.reportWtf("starting " + className, e);
            }
            SystemServer.traceEnd();
        }
        SystemServer.traceEnd();
        SystemServer.traceBeginAndSlog("StartBootPhaseDeviceSpecificServicesReady");
        this.mSystemServiceManager.startBootPhase(520);
        SystemServer.traceEnd();
        NetworkManagementService networkManagementF = networkManagement;
        NetworkStatsService networkStatsF = networkStats;
        NetworkPolicyManagerService networkPolicyF = networkPolicy;
        ConnectivityService connectivityF = connectivity;
        LocationManagerService locationF = location;
        CountryDetectorService countryDetectorF = countryDetector;
        NetworkTimeUpdateService networkTimeUpdaterF = networkTimeUpdater;
        CommonTimeManagementService commonTimeMgmtServiceF = commonTimeMgmtService;
        InputManagerService inputManagerF = inputManager;
        TelephonyRegistry telephonyRegistryF = telephonyRegistry;
        MediaRouterService mediaRouterF = mediaRouter;
        MmsServiceBroker mmsServiceF = mmsService;
        IpSecService ipSecServiceF = ipSecService;
        WindowManagerService windowManagerF = wm;
        this.mActivityManagerService.systemReady(() -> {
            Slog.i(TAG, "Making services ready");
            SystemServer.traceBeginAndSlog("StartActivityManagerReadyPhase");
            this.mSystemServiceManager.startBootPhase(550);
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartObservingNativeCrashes");
            try {
                this.mActivityManagerService.startObservingNativeCrashes();
            }
            catch (Throwable e) {
                this.reportWtf("observing native crashes", e);
            }
            SystemServer.traceEnd();
            String WEBVIEW_PREPARATION = "WebViewFactoryPreparation";
            Future<?> webviewPrep = null;
            if (!this.mOnlyCore && this.mWebViewUpdateService != null) {
                webviewPrep = SystemServerInitThreadPool.get().submit(() -> {
                    Slog.i(TAG, "WebViewFactoryPreparation");
                    TimingsTraceLog traceLog = new TimingsTraceLog(SYSTEM_SERVER_TIMING_ASYNC_TAG, 524288L);
                    traceLog.traceBegin("WebViewFactoryPreparation");
                    ConcurrentUtils.waitForFutureNoInterrupt(this.mZygotePreload, "Zygote preload");
                    this.mZygotePreload = null;
                    this.mWebViewUpdateService.prepareWebViewInSystemServer();
                    traceLog.traceEnd();
                }, "WebViewFactoryPreparation");
            }
            if (this.mPackageManager.hasSystemFeature("android.hardware.type.automotive")) {
                SystemServer.traceBeginAndSlog("StartCarServiceHelperService");
                this.mSystemServiceManager.startService(CAR_SERVICE_HELPER_SERVICE_CLASS);
                SystemServer.traceEnd();
            }
            SystemServer.traceBeginAndSlog("StartSystemUI");
            try {
                SystemServer.startSystemUi(context, windowManagerF);
            }
            catch (Throwable e) {
                this.reportWtf("starting System UI", e);
            }
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("MakeNetworkManagementServiceReady");
            try {
                if (networkManagementF != null) {
                    networkManagementF.systemReady();
                }
            }
            catch (Throwable e) {
                this.reportWtf("making Network Managment Service ready", e);
            }
            CountDownLatch networkPolicyInitReadySignal = null;
            if (networkPolicyF != null) {
                networkPolicyInitReadySignal = networkPolicyF.networkScoreAndNetworkManagementServiceReady();
            }
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("MakeIpSecServiceReady");
            try {
                if (ipSecServiceF != null) {
                    ipSecServiceF.systemReady();
                }
            }
            catch (Throwable e) {
                this.reportWtf("making IpSec Service ready", e);
            }
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("MakeNetworkStatsServiceReady");
            try {
                if (networkStatsF != null) {
                    networkStatsF.systemReady();
                }
            }
            catch (Throwable e) {
                this.reportWtf("making Network Stats Service ready", e);
            }
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("MakeConnectivityServiceReady");
            try {
                if (connectivityF != null) {
                    connectivityF.systemReady();
                }
            }
            catch (Throwable e) {
                this.reportWtf("making Connectivity Service ready", e);
            }
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("MakeNetworkPolicyServiceReady");
            try {
                if (networkPolicyF != null) {
                    networkPolicyF.systemReady(networkPolicyInitReadySignal);
                }
            }
            catch (Throwable e) {
                this.reportWtf("making Network Policy Service ready", e);
            }
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("StartWatchdog");
            Watchdog.getInstance().start();
            SystemServer.traceEnd();
            this.mPackageManagerService.waitForAppDataPrepared();
            SystemServer.traceBeginAndSlog("PhaseThirdPartyAppsCanStart");
            if (webviewPrep != null) {
                ConcurrentUtils.waitForFutureNoInterrupt(webviewPrep, "WebViewFactoryPreparation");
            }
            this.mSystemServiceManager.startBootPhase(600);
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("MakeLocationServiceReady");
            try {
                if (locationF != null) {
                    locationF.systemRunning();
                }
            }
            catch (Throwable e) {
                this.reportWtf("Notifying Location Service running", e);
            }
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("MakeCountryDetectionServiceReady");
            try {
                if (countryDetectorF != null) {
                    countryDetectorF.systemRunning();
                }
            }
            catch (Throwable e) {
                this.reportWtf("Notifying CountryDetectorService running", e);
            }
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("MakeNetworkTimeUpdateReady");
            try {
                if (networkTimeUpdaterF != null) {
                    networkTimeUpdaterF.systemRunning();
                }
            }
            catch (Throwable e) {
                this.reportWtf("Notifying NetworkTimeService running", e);
            }
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("MakeCommonTimeManagementServiceReady");
            try {
                if (commonTimeMgmtServiceF != null) {
                    commonTimeMgmtServiceF.systemRunning();
                }
            }
            catch (Throwable e) {
                this.reportWtf("Notifying CommonTimeManagementService running", e);
            }
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("MakeInputManagerServiceReady");
            try {
                if (inputManagerF != null) {
                    inputManagerF.systemRunning();
                }
            }
            catch (Throwable e) {
                this.reportWtf("Notifying InputManagerService running", e);
            }
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("MakeTelephonyRegistryReady");
            try {
                if (telephonyRegistryF != null) {
                    telephonyRegistryF.systemRunning();
                }
            }
            catch (Throwable e) {
                this.reportWtf("Notifying TelephonyRegistry running", e);
            }
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("MakeMediaRouterServiceReady");
            try {
                if (mediaRouterF != null) {
                    mediaRouterF.systemRunning();
                }
            }
            catch (Throwable e) {
                this.reportWtf("Notifying MediaRouterService running", e);
            }
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("MakeMmsServiceReady");
            try {
                if (mmsServiceF != null) {
                    mmsServiceF.systemRunning();
                }
            }
            catch (Throwable e) {
                this.reportWtf("Notifying MmsService running", e);
            }
            SystemServer.traceEnd();
            SystemServer.traceBeginAndSlog("IncidentDaemonReady");
            try {
                IIncidentManager incident = IIncidentManager.Stub.asInterface(ServiceManager.getService("incident"));
                if (incident != null) {
                    incident.systemRunning();
                }
            }
            catch (Throwable e) {
                this.reportWtf("Notifying incident daemon running", e);
            }
            SystemServer.traceEnd();
        }, BOOT_TIMINGS_TRACE_LOG);
    }

    static final void startSystemUi(Context context, WindowManagerService windowManager) {
        Intent intent = new Intent();
        intent.setComponent(new ComponentName("com.android.systemui", "com.android.systemui.SystemUIService"));
        intent.addFlags(256);
        context.startServiceAsUser(intent, UserHandle.SYSTEM);
        windowManager.onSystemUiStarted();
    }

    private static void traceBeginAndSlog(String name) {
        Slog.i(TAG, name);
        BOOT_TIMINGS_TRACE_LOG.traceBegin(name);
    }

    private static void traceEnd() {
        BOOT_TIMINGS_TRACE_LOG.traceEnd();
    }
}

