/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.UserInfo;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Slog;
import android.util.SparseArray;
import android.view.inputmethod.InputMethodManager;
import android.view.inputmethod.InputMethodSubtype;
import android.view.textservice.SpellCheckerInfo;
import android.view.textservice.SpellCheckerSubtype;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.content.PackageMonitor;
import com.android.internal.inputmethod.InputMethodUtils;
import com.android.internal.textservice.ISpellCheckerService;
import com.android.internal.textservice.ISpellCheckerServiceCallback;
import com.android.internal.textservice.ISpellCheckerSession;
import com.android.internal.textservice.ISpellCheckerSessionListener;
import com.android.internal.textservice.ITextServicesManager;
import com.android.internal.textservice.ITextServicesSessionListener;
import com.android.internal.textservice.LazyIntToIntMap;
import com.android.internal.util.DumpUtils;
import com.android.server.SystemService;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import org.xmlpull.v1.XmlPullParserException;

public class TextServicesManagerService
extends ITextServicesManager.Stub {
    private static final String TAG = TextServicesManagerService.class.getSimpleName();
    private static final boolean DBG = false;
    private final Context mContext;
    private final TextServicesMonitor mMonitor;
    private final SparseArray<TextServicesData> mUserData = new SparseArray();
    private final UserManager mUserManager;
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private final LazyIntToIntMap mSpellCheckerOwnerUserIdMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onStopUser(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.mSpellCheckerOwnerUserIdMap.delete(userId);
            TextServicesData tsd = this.mUserData.get(userId);
            if (tsd == null) {
                return;
            }
            this.unbindServiceLocked(tsd);
            this.mUserData.remove(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onUnlockUser(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.initializeInternalStateLocked(userId);
        }
    }

    public TextServicesManagerService(Context context) {
        this.mContext = context;
        this.mUserManager = this.mContext.getSystemService(UserManager.class);
        this.mSpellCheckerOwnerUserIdMap = new LazyIntToIntMap(callingUserId -> {
            long token = Binder.clearCallingIdentity();
            try {
                UserInfo parent = this.mUserManager.getProfileParent(callingUserId);
                int n = parent != null ? parent.id : callingUserId;
                return n;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        });
        this.mMonitor = new TextServicesMonitor();
        this.mMonitor.register(context, null, UserHandle.ALL, true);
    }

    private void initializeInternalStateLocked(int userId) {
        if (userId != this.mSpellCheckerOwnerUserIdMap.get(userId)) {
            return;
        }
        TextServicesData tsd = this.mUserData.get(userId);
        if (tsd == null) {
            tsd = new TextServicesData(userId, this.mContext);
            this.mUserData.put(userId, tsd);
        }
        tsd.initializeTextServicesData();
        SpellCheckerInfo sci = tsd.getCurrentSpellChecker();
        if (sci == null) {
            sci = this.findAvailSystemSpellCheckerLocked(null, tsd);
            this.setCurrentSpellCheckerLocked(sci, tsd);
        }
    }

    private boolean bindCurrentSpellCheckerService(Intent service, ServiceConnection conn, int flags, int userId) {
        if (service == null || conn == null) {
            Slog.e(TAG, "--- bind failed: service = " + service + ", conn = " + conn + ", userId =" + userId);
            return false;
        }
        return this.mContext.bindServiceAsUser(service, conn, flags, UserHandle.of(userId));
    }

    private void unbindServiceLocked(TextServicesData tsd) {
        HashMap spellCheckerBindGroups = tsd.mSpellCheckerBindGroups;
        for (SpellCheckerBindGroup scbg : spellCheckerBindGroups.values()) {
            scbg.removeAllLocked();
        }
        spellCheckerBindGroups.clear();
    }

    private SpellCheckerInfo findAvailSystemSpellCheckerLocked(String prefPackage, TextServicesData tsd) {
        ArrayList<SpellCheckerInfo> spellCheckerList = new ArrayList<SpellCheckerInfo>();
        for (SpellCheckerInfo sci : tsd.mSpellCheckerList) {
            if ((sci.getServiceInfo().applicationInfo.flags & 1) == 0) continue;
            spellCheckerList.add(sci);
        }
        int spellCheckersCount = spellCheckerList.size();
        if (spellCheckersCount == 0) {
            Slog.w(TAG, "no available spell checker services found");
            return null;
        }
        if (prefPackage != null) {
            for (int i = 0; i < spellCheckersCount; ++i) {
                SpellCheckerInfo sci = (SpellCheckerInfo)spellCheckerList.get(i);
                if (!prefPackage.equals(sci.getPackageName())) continue;
                return sci;
            }
        }
        Locale systemLocal = this.mContext.getResources().getConfiguration().locale;
        ArrayList<Locale> suitableLocales = InputMethodUtils.getSuitableLocalesForSpellChecker(systemLocal);
        int localeCount = suitableLocales.size();
        for (int localeIndex = 0; localeIndex < localeCount; ++localeIndex) {
            Locale locale = suitableLocales.get(localeIndex);
            for (int spellCheckersIndex = 0; spellCheckersIndex < spellCheckersCount; ++spellCheckersIndex) {
                SpellCheckerInfo info = (SpellCheckerInfo)spellCheckerList.get(spellCheckersIndex);
                int subtypeCount = info.getSubtypeCount();
                for (int subtypeIndex = 0; subtypeIndex < subtypeCount; ++subtypeIndex) {
                    SpellCheckerSubtype subtype = info.getSubtypeAt(subtypeIndex);
                    Locale subtypeLocale = InputMethodUtils.constructLocaleFromString(subtype.getLocale());
                    if (!locale.equals(subtypeLocale)) continue;
                    return info;
                }
            }
        }
        if (spellCheckersCount > 1) {
            Slog.w(TAG, "more than one spell checker service found, picking first");
        }
        return (SpellCheckerInfo)spellCheckerList.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpellCheckerInfo getCurrentSpellChecker(String locale) {
        int userId = UserHandle.getCallingUserId();
        Object object = this.mLock;
        synchronized (object) {
            TextServicesData tsd = this.getDataFromCallingUserIdLocked(userId);
            if (tsd == null) {
                return null;
            }
            return tsd.getCurrentSpellChecker();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpellCheckerSubtype getCurrentSpellCheckerSubtype(String locale, boolean allowImplicitlySelectedSubtype) {
        Locale systemLocale;
        SpellCheckerInfo sci;
        int subtypeHashCode;
        int userId = UserHandle.getCallingUserId();
        Object object = this.mLock;
        synchronized (object) {
            TextServicesData tsd = this.getDataFromCallingUserIdLocked(userId);
            if (tsd == null) {
                return null;
            }
            subtypeHashCode = tsd.getSelectedSpellCheckerSubtype(0);
            sci = tsd.getCurrentSpellChecker();
            systemLocale = this.mContext.getResources().getConfiguration().locale;
        }
        if (sci == null || sci.getSubtypeCount() == 0) {
            return null;
        }
        if (subtypeHashCode == 0 && !allowImplicitlySelectedSubtype) {
            return null;
        }
        String candidateLocale = null;
        if (subtypeHashCode == 0) {
            String localeString;
            InputMethodSubtype currentInputMethodSubtype;
            InputMethodManager imm = this.mContext.getSystemService(InputMethodManager.class);
            if (imm != null && (currentInputMethodSubtype = imm.getCurrentInputMethodSubtype()) != null && !TextUtils.isEmpty(localeString = currentInputMethodSubtype.getLocale())) {
                candidateLocale = localeString;
            }
            if (candidateLocale == null) {
                candidateLocale = systemLocale.toString();
            }
        }
        SpellCheckerSubtype candidate = null;
        for (int i = 0; i < sci.getSubtypeCount(); ++i) {
            SpellCheckerSubtype scs = sci.getSubtypeAt(i);
            if (subtypeHashCode == 0) {
                String scsLocale = scs.getLocale();
                if (candidateLocale.equals(scsLocale)) {
                    return scs;
                }
                if (candidate != null || candidateLocale.length() < 2 || scsLocale.length() < 2 || !candidateLocale.startsWith(scsLocale)) continue;
                candidate = scs;
                continue;
            }
            if (scs.hashCode() != subtypeHashCode) continue;
            return scs;
        }
        return candidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getSpellCheckerService(String sciId, String locale, ITextServicesSessionListener tsListener, ISpellCheckerSessionListener scListener, Bundle bundle) {
        if (TextUtils.isEmpty(sciId) || tsListener == null || scListener == null) {
            Slog.e(TAG, "getSpellCheckerService: Invalid input.");
            return;
        }
        int callingUserId = UserHandle.getCallingUserId();
        Object object = this.mLock;
        synchronized (object) {
            TextServicesData tsd = this.getDataFromCallingUserIdLocked(callingUserId);
            if (tsd == null) {
                return;
            }
            HashMap spellCheckerMap = tsd.mSpellCheckerMap;
            if (!spellCheckerMap.containsKey(sciId)) {
                return;
            }
            SpellCheckerInfo sci = (SpellCheckerInfo)spellCheckerMap.get(sciId);
            HashMap spellCheckerBindGroups = tsd.mSpellCheckerBindGroups;
            SpellCheckerBindGroup bindGroup = (SpellCheckerBindGroup)spellCheckerBindGroups.get(sciId);
            int uid = Binder.getCallingUid();
            if (bindGroup == null) {
                long ident = Binder.clearCallingIdentity();
                try {
                    bindGroup = this.startSpellCheckerServiceInnerLocked(sci, tsd);
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
                if (bindGroup == null) {
                    return;
                }
            }
            bindGroup.getISpellCheckerSessionOrQueueLocked(new SessionRequest(uid, locale, tsListener, scListener, bundle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSpellCheckerEnabled() {
        int userId = UserHandle.getCallingUserId();
        Object object = this.mLock;
        synchronized (object) {
            TextServicesData tsd = this.getDataFromCallingUserIdLocked(userId);
            if (tsd == null) {
                return false;
            }
            return tsd.isSpellCheckerEnabled();
        }
    }

    private SpellCheckerBindGroup startSpellCheckerServiceInnerLocked(SpellCheckerInfo info, TextServicesData tsd) {
        String sciId = info.getId();
        InternalServiceConnection connection = new InternalServiceConnection(sciId, tsd.mSpellCheckerBindGroups);
        Intent serviceIntent = new Intent("android.service.textservice.SpellCheckerService");
        serviceIntent.setComponent(info.getComponent());
        if (!this.bindCurrentSpellCheckerService(serviceIntent, connection, 0x800001, tsd.mUserId)) {
            Slog.e(TAG, "Failed to get a spell checker service.");
            return null;
        }
        SpellCheckerBindGroup group = new SpellCheckerBindGroup(connection);
        tsd.mSpellCheckerBindGroups.put(sciId, group);
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpellCheckerInfo[] getEnabledSpellCheckers() {
        int callingUserId = UserHandle.getCallingUserId();
        Object object = this.mLock;
        synchronized (object) {
            TextServicesData tsd = this.getDataFromCallingUserIdLocked(callingUserId);
            if (tsd == null) {
                return null;
            }
            ArrayList spellCheckerList = tsd.mSpellCheckerList;
            return spellCheckerList.toArray(new SpellCheckerInfo[spellCheckerList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishSpellCheckerService(ISpellCheckerSessionListener listener) {
        int userId = UserHandle.getCallingUserId();
        Object object = this.mLock;
        synchronized (object) {
            TextServicesData tsd = this.getDataFromCallingUserIdLocked(userId);
            if (tsd == null) {
                return;
            }
            ArrayList<SpellCheckerBindGroup> removeList = new ArrayList<SpellCheckerBindGroup>();
            HashMap spellCheckerBindGroups = tsd.mSpellCheckerBindGroups;
            for (SpellCheckerBindGroup group : spellCheckerBindGroups.values()) {
                if (group == null) continue;
                removeList.add(group);
            }
            int removeSize = removeList.size();
            for (int i = 0; i < removeSize; ++i) {
                ((SpellCheckerBindGroup)removeList.get(i)).removeListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrentSpellCheckerLocked(SpellCheckerInfo sci, TextServicesData tsd) {
        String sciId = sci != null ? sci.getId() : "";
        long ident = Binder.clearCallingIdentity();
        try {
            tsd.setCurrentSpellChecker(sci);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, pw)) {
            return;
        }
        if (args.length == 0 || args.length == 1 && args[0].equals("-a")) {
            Object object = this.mLock;
            synchronized (object) {
                pw.println("Current Text Services Manager state:");
                pw.println("  Users:");
                int numOfUsers = this.mUserData.size();
                for (int i = 0; i < numOfUsers; ++i) {
                    TextServicesData tsd = this.mUserData.valueAt(i);
                    tsd.dump(pw);
                }
            }
        }
        if (args.length != 2 || !args[0].equals("--user")) {
            pw.println("Invalid arguments to text services.");
            return;
        }
        int userId = Integer.parseInt(args[1]);
        UserInfo userInfo = this.mUserManager.getUserInfo(userId);
        if (userInfo == null) {
            pw.println("Non-existent user.");
            return;
        }
        TextServicesData tsd = this.mUserData.get(userId);
        if (tsd == null) {
            pw.println("User needs to unlock first.");
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            pw.println("Current Text Services Manager state:");
            pw.println("  User " + userId + ":");
            tsd.dump(pw);
        }
    }

    private TextServicesData getDataFromCallingUserIdLocked(int callingUserId) {
        int spellCheckerOwnerUserId = this.mSpellCheckerOwnerUserIdMap.get(callingUserId);
        TextServicesData data = this.mUserData.get(spellCheckerOwnerUserId);
        if (spellCheckerOwnerUserId != callingUserId) {
            if (data == null) {
                return null;
            }
            SpellCheckerInfo info = data.getCurrentSpellChecker();
            if (info == null) {
                return null;
            }
            ServiceInfo serviceInfo = info.getServiceInfo();
            if ((serviceInfo.applicationInfo.flags & 1) == 0) {
                return null;
            }
        }
        return data;
    }

    private static final class ISpellCheckerServiceCallbackBinder
    extends ISpellCheckerServiceCallback.Stub {
        private final SpellCheckerBindGroup mBindGroup;
        private final SessionRequest mRequest;

        ISpellCheckerServiceCallbackBinder(SpellCheckerBindGroup bindGroup, SessionRequest request) {
            this.mBindGroup = bindGroup;
            this.mRequest = request;
        }

        @Override
        public void onSessionCreated(ISpellCheckerSession newSession) {
            this.mBindGroup.onSessionCreated(newSession, this.mRequest);
        }
    }

    private static final class InternalDeathRecipients
    extends RemoteCallbackList<ISpellCheckerSessionListener> {
        private final SpellCheckerBindGroup mGroup;

        public InternalDeathRecipients(SpellCheckerBindGroup group) {
            this.mGroup = group;
        }

        @Override
        public void onCallbackDied(ISpellCheckerSessionListener listener) {
            this.mGroup.removeListener(listener);
        }
    }

    private final class InternalServiceConnection
    implements ServiceConnection {
        private final String mSciId;
        private final HashMap<String, SpellCheckerBindGroup> mSpellCheckerBindGroups;

        public InternalServiceConnection(String id2, HashMap<String, SpellCheckerBindGroup> spellCheckerBindGroups) {
            this.mSciId = id2;
            this.mSpellCheckerBindGroups = spellCheckerBindGroups;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            Object object = TextServicesManagerService.this.mLock;
            synchronized (object) {
                this.onServiceConnectedInnerLocked(name, service);
            }
        }

        private void onServiceConnectedInnerLocked(ComponentName name, IBinder service) {
            ISpellCheckerService spellChecker = ISpellCheckerService.Stub.asInterface(service);
            SpellCheckerBindGroup group = this.mSpellCheckerBindGroups.get(this.mSciId);
            if (group != null && this == group.mInternalConnection) {
                group.onServiceConnectedLocked(spellChecker);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceDisconnected(ComponentName name) {
            Object object = TextServicesManagerService.this.mLock;
            synchronized (object) {
                this.onServiceDisconnectedInnerLocked(name);
            }
        }

        private void onServiceDisconnectedInnerLocked(ComponentName name) {
            SpellCheckerBindGroup group = this.mSpellCheckerBindGroups.get(this.mSciId);
            if (group != null && this == group.mInternalConnection) {
                group.onServiceDisconnectedLocked();
            }
        }
    }

    private final class SpellCheckerBindGroup {
        private final String TAG = SpellCheckerBindGroup.class.getSimpleName();
        private final InternalServiceConnection mInternalConnection;
        private final InternalDeathRecipients mListeners;
        private boolean mUnbindCalled;
        private ISpellCheckerService mSpellChecker;
        private boolean mConnected;
        private final ArrayList<SessionRequest> mPendingSessionRequests = new ArrayList();
        private final ArrayList<SessionRequest> mOnGoingSessionRequests = new ArrayList();
        HashMap<String, SpellCheckerBindGroup> mSpellCheckerBindGroups;

        public SpellCheckerBindGroup(InternalServiceConnection connection) {
            this.mInternalConnection = connection;
            this.mListeners = new InternalDeathRecipients(this);
            this.mSpellCheckerBindGroups = connection.mSpellCheckerBindGroups;
        }

        public void onServiceConnectedLocked(ISpellCheckerService spellChecker) {
            if (this.mUnbindCalled) {
                return;
            }
            this.mSpellChecker = spellChecker;
            this.mConnected = true;
            try {
                int size = this.mPendingSessionRequests.size();
                for (int i = 0; i < size; ++i) {
                    SessionRequest request = this.mPendingSessionRequests.get(i);
                    this.mSpellChecker.getISpellCheckerSession(request.mLocale, request.mScListener, request.mBundle, new ISpellCheckerServiceCallbackBinder(this, request));
                    this.mOnGoingSessionRequests.add(request);
                }
                this.mPendingSessionRequests.clear();
            }
            catch (RemoteException e) {
                this.removeAllLocked();
            }
            this.cleanLocked();
        }

        public void onServiceDisconnectedLocked() {
            this.mSpellChecker = null;
            this.mConnected = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeListener(ISpellCheckerSessionListener listener) {
            Object object = TextServicesManagerService.this.mLock;
            synchronized (object) {
                this.mListeners.unregister(listener);
                IBinder scListenerBinder = listener.asBinder();
                Predicate<SessionRequest> removeCondition = request -> request.mScListener.asBinder() == scListenerBinder;
                this.mPendingSessionRequests.removeIf(removeCondition);
                this.mOnGoingSessionRequests.removeIf(removeCondition);
                this.cleanLocked();
            }
        }

        private void cleanLocked() {
            if (this.mUnbindCalled) {
                return;
            }
            if (this.mListeners.getRegisteredCallbackCount() > 0) {
                return;
            }
            if (!this.mPendingSessionRequests.isEmpty()) {
                return;
            }
            if (!this.mOnGoingSessionRequests.isEmpty()) {
                return;
            }
            String sciId = this.mInternalConnection.mSciId;
            SpellCheckerBindGroup cur = this.mSpellCheckerBindGroups.get(sciId);
            if (cur == this) {
                this.mSpellCheckerBindGroups.remove(sciId);
            }
            TextServicesManagerService.this.mContext.unbindService(this.mInternalConnection);
            this.mUnbindCalled = true;
        }

        public void removeAllLocked() {
            Slog.e(this.TAG, "Remove the spell checker bind unexpectedly.");
            int size = this.mListeners.getRegisteredCallbackCount();
            for (int i = size - 1; i >= 0; --i) {
                this.mListeners.unregister((ISpellCheckerSessionListener)this.mListeners.getRegisteredCallbackItem(i));
            }
            this.mPendingSessionRequests.clear();
            this.mOnGoingSessionRequests.clear();
            this.cleanLocked();
        }

        public void getISpellCheckerSessionOrQueueLocked(SessionRequest request) {
            if (this.mUnbindCalled) {
                return;
            }
            this.mListeners.register(request.mScListener);
            if (!this.mConnected) {
                this.mPendingSessionRequests.add(request);
                return;
            }
            try {
                this.mSpellChecker.getISpellCheckerSession(request.mLocale, request.mScListener, request.mBundle, new ISpellCheckerServiceCallbackBinder(this, request));
                this.mOnGoingSessionRequests.add(request);
            }
            catch (RemoteException e) {
                this.removeAllLocked();
            }
            this.cleanLocked();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onSessionCreated(ISpellCheckerSession newSession, SessionRequest request) {
            Object object = TextServicesManagerService.this.mLock;
            synchronized (object) {
                if (this.mUnbindCalled) {
                    return;
                }
                if (this.mOnGoingSessionRequests.remove(request)) {
                    try {
                        request.mTsListener.onServiceConnected(newSession);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                this.cleanLocked();
            }
        }
    }

    private static final class SessionRequest {
        public final int mUid;
        public final String mLocale;
        public final ITextServicesSessionListener mTsListener;
        public final ISpellCheckerSessionListener mScListener;
        public final Bundle mBundle;

        SessionRequest(int uid, String locale, ITextServicesSessionListener tsListener, ISpellCheckerSessionListener scListener, Bundle bundle) {
            this.mUid = uid;
            this.mLocale = locale;
            this.mTsListener = tsListener;
            this.mScListener = scListener;
            this.mBundle = bundle;
        }
    }

    private final class TextServicesMonitor
    extends PackageMonitor {
        private TextServicesMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSomePackagesChanged() {
            int userId = this.getChangingUserId();
            Object object = TextServicesManagerService.this.mLock;
            synchronized (object) {
                TextServicesData tsd = (TextServicesData)TextServicesManagerService.this.mUserData.get(userId);
                if (tsd == null) {
                    return;
                }
                SpellCheckerInfo sci = tsd.getCurrentSpellChecker();
                tsd.initializeTextServicesData();
                if (!tsd.isSpellCheckerEnabled()) {
                    return;
                }
                if (sci == null) {
                    sci = TextServicesManagerService.this.findAvailSystemSpellCheckerLocked(null, tsd);
                    TextServicesManagerService.this.setCurrentSpellCheckerLocked(sci, tsd);
                } else {
                    SpellCheckerInfo availSci;
                    String packageName = sci.getPackageName();
                    int change = this.isPackageDisappearing(packageName);
                    if (!(change != 3 && change != 2 || (availSci = TextServicesManagerService.this.findAvailSystemSpellCheckerLocked(packageName, tsd)) != null && (availSci == null || availSci.getId().equals(sci.getId())))) {
                        TextServicesManagerService.this.setCurrentSpellCheckerLocked(availSci, tsd);
                    }
                }
            }
        }
    }

    public static final class Lifecycle
    extends SystemService {
        private TextServicesManagerService mService;

        public Lifecycle(Context context) {
            super(context);
            this.mService = new TextServicesManagerService(context);
        }

        @Override
        public void onStart() {
            this.publishBinderService("textservices", this.mService);
        }

        @Override
        public void onStopUser(int userHandle) {
            this.mService.onStopUser(userHandle);
        }

        @Override
        public void onUnlockUser(int userHandle) {
            this.mService.onUnlockUser(userHandle);
        }
    }

    private static class TextServicesData {
        private final int mUserId;
        private final HashMap<String, SpellCheckerInfo> mSpellCheckerMap;
        private final ArrayList<SpellCheckerInfo> mSpellCheckerList;
        private final HashMap<String, SpellCheckerBindGroup> mSpellCheckerBindGroups;
        private final Context mContext;
        private final ContentResolver mResolver;
        public int mUpdateCount = 0;

        public TextServicesData(int userId, Context context) {
            this.mUserId = userId;
            this.mSpellCheckerMap = new HashMap();
            this.mSpellCheckerList = new ArrayList();
            this.mSpellCheckerBindGroups = new HashMap();
            this.mContext = context;
            this.mResolver = context.getContentResolver();
        }

        private void putString(String key, String str) {
            Settings.Secure.putStringForUser(this.mResolver, key, str, this.mUserId);
        }

        private String getString(String key, String defaultValue) {
            String result = Settings.Secure.getStringForUser(this.mResolver, key, this.mUserId);
            return result != null ? result : defaultValue;
        }

        private void putInt(String key, int value) {
            Settings.Secure.putIntForUser(this.mResolver, key, value, this.mUserId);
        }

        private int getInt(String key, int defaultValue) {
            return Settings.Secure.getIntForUser(this.mResolver, key, defaultValue, this.mUserId);
        }

        private boolean getBoolean(String key, boolean defaultValue) {
            return this.getInt(key, defaultValue ? 1 : 0) == 1;
        }

        private void putSelectedSpellChecker(String sciId) {
            this.putString("selected_spell_checker", sciId);
        }

        private void putSelectedSpellCheckerSubtype(int hashCode) {
            this.putInt("selected_spell_checker_subtype", hashCode);
        }

        private String getSelectedSpellChecker() {
            return this.getString("selected_spell_checker", "");
        }

        public int getSelectedSpellCheckerSubtype(int defaultValue) {
            return this.getInt("selected_spell_checker_subtype", defaultValue);
        }

        public boolean isSpellCheckerEnabled() {
            return this.getBoolean("spell_checker_enabled", true);
        }

        public SpellCheckerInfo getCurrentSpellChecker() {
            String curSpellCheckerId = this.getSelectedSpellChecker();
            if (TextUtils.isEmpty(curSpellCheckerId)) {
                return null;
            }
            return this.mSpellCheckerMap.get(curSpellCheckerId);
        }

        public void setCurrentSpellChecker(SpellCheckerInfo sci) {
            if (sci != null) {
                this.putSelectedSpellChecker(sci.getId());
            } else {
                this.putSelectedSpellChecker("");
            }
            this.putSelectedSpellCheckerSubtype(0);
        }

        private void initializeTextServicesData() {
            this.mSpellCheckerList.clear();
            this.mSpellCheckerMap.clear();
            ++this.mUpdateCount;
            PackageManager pm = this.mContext.getPackageManager();
            List<ResolveInfo> services = pm.queryIntentServicesAsUser(new Intent("android.service.textservice.SpellCheckerService"), 128, this.mUserId);
            int N = services.size();
            for (int i = 0; i < N; ++i) {
                ResolveInfo ri = services.get(i);
                ServiceInfo si = ri.serviceInfo;
                ComponentName compName = new ComponentName(si.packageName, si.name);
                if (!"android.permission.BIND_TEXT_SERVICE".equals(si.permission)) {
                    Slog.w(TAG, "Skipping text service " + compName + ": it does not require the permission " + "android.permission.BIND_TEXT_SERVICE");
                    continue;
                }
                try {
                    SpellCheckerInfo sci = new SpellCheckerInfo(this.mContext, ri);
                    if (sci.getSubtypeCount() <= 0) {
                        Slog.w(TAG, "Skipping text service " + compName + ": it does not contain subtypes.");
                        continue;
                    }
                    this.mSpellCheckerList.add(sci);
                    this.mSpellCheckerMap.put(sci.getId(), sci);
                    continue;
                }
                catch (XmlPullParserException e) {
                    Slog.w(TAG, "Unable to load the spell checker " + compName, e);
                    continue;
                }
                catch (IOException e) {
                    Slog.w(TAG, "Unable to load the spell checker " + compName, e);
                }
            }
        }

        private void dump(PrintWriter pw) {
            int spellCheckerIndex = 0;
            pw.println("  User #" + this.mUserId);
            pw.println("  Spell Checkers:");
            pw.println("  Spell Checkers: mUpdateCount=" + this.mUpdateCount);
            for (SpellCheckerInfo info : this.mSpellCheckerMap.values()) {
                pw.println("  Spell Checker #" + spellCheckerIndex);
                info.dump(pw, "    ");
                ++spellCheckerIndex;
            }
            pw.println("");
            pw.println("  Spell Checker Bind Groups:");
            HashMap<String, SpellCheckerBindGroup> spellCheckerBindGroups = this.mSpellCheckerBindGroups;
            for (Map.Entry<String, SpellCheckerBindGroup> ent : spellCheckerBindGroups.entrySet()) {
                SpellCheckerBindGroup grp = ent.getValue();
                pw.println("    " + ent.getKey() + " " + grp + ":");
                pw.println("      mInternalConnection=" + grp.mInternalConnection);
                pw.println("      mSpellChecker=" + grp.mSpellChecker);
                pw.println("      mUnbindCalled=" + grp.mUnbindCalled);
                pw.println("      mConnected=" + grp.mConnected);
                int numPendingSessionRequests = grp.mPendingSessionRequests.size();
                for (int j = 0; j < numPendingSessionRequests; ++j) {
                    SessionRequest req = (SessionRequest)grp.mPendingSessionRequests.get(j);
                    pw.println("      Pending Request #" + j + ":");
                    pw.println("        mTsListener=" + req.mTsListener);
                    pw.println("        mScListener=" + req.mScListener);
                    pw.println("        mScLocale=" + req.mLocale + " mUid=" + req.mUid);
                }
                int numOnGoingSessionRequests = grp.mOnGoingSessionRequests.size();
                for (int j = 0; j < numOnGoingSessionRequests; ++j) {
                    SessionRequest req = (SessionRequest)grp.mOnGoingSessionRequests.get(j);
                    pw.println("      On going Request #" + j + ":");
                    ++j;
                    pw.println("        mTsListener=" + req.mTsListener);
                    pw.println("        mScListener=" + req.mScListener);
                    pw.println("        mScLocale=" + req.mLocale + " mUid=" + req.mUid);
                }
                int N = grp.mListeners.getRegisteredCallbackCount();
                for (int j = 0; j < N; ++j) {
                    ISpellCheckerSessionListener mScListener = (ISpellCheckerSessionListener)grp.mListeners.getRegisteredCallbackItem(j);
                    pw.println("      Listener #" + j + ":");
                    pw.println("        mScListener=" + mScListener);
                    pw.println("        mGroup=" + grp);
                }
            }
        }
    }
}

