/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.AppOpsManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.hardware.input.InputManager;
import android.icu.text.DateFormat;
import android.media.AudioAttributes;
import android.media.AudioManager;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.IVibratorService;
import android.os.PowerManager;
import android.os.PowerManagerInternal;
import android.os.PowerSaveState;
import android.os.Process;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.ShellCallback;
import android.os.ShellCommand;
import android.os.SystemClock;
import android.os.Trace;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.os.WorkSource;
import android.provider.Settings;
import android.util.Slog;
import android.util.SparseArray;
import android.view.InputDevice;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.app.IBatteryStats;
import com.android.internal.util.DumpUtils;
import com.android.server.LocalServices;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;

public class VibratorService
extends IVibratorService.Stub
implements InputManager.InputDeviceListener {
    private static final String TAG = "VibratorService";
    private static final boolean DEBUG = false;
    private static final String SYSTEM_UI_PACKAGE = "com.android.systemui";
    private static final long[] DOUBLE_CLICK_EFFECT_FALLBACK_TIMINGS = new long[]{0L, 30L, 100L, 30L};
    private static final int SCALE_VERY_LOW = -2;
    private static final int SCALE_LOW = -1;
    private static final int SCALE_NONE = 0;
    private static final int SCALE_HIGH = 1;
    private static final int SCALE_VERY_HIGH = 2;
    private static final float SCALE_VERY_LOW_GAMMA = 2.0f;
    private static final float SCALE_LOW_GAMMA = 1.5f;
    private static final float SCALE_NONE_GAMMA = 1.0f;
    private static final float SCALE_HIGH_GAMMA = 0.5f;
    private static final float SCALE_VERY_HIGH_GAMMA = 0.25f;
    private static final int SCALE_VERY_LOW_MAX_AMPLITUDE = 168;
    private static final int SCALE_LOW_MAX_AMPLITUDE = 192;
    private static final long MAX_HAPTIC_FEEDBACK_DURATION = 5000L;
    private final SparseArray<ScaleLevel> mScaleLevels;
    private final LinkedList<VibrationInfo> mPreviousVibrations;
    private final int mPreviousVibrationsLimit;
    private final boolean mAllowPriorityVibrationsInLowPowerMode;
    private final boolean mSupportsAmplitudeControl;
    private final int mDefaultVibrationAmplitude;
    private final SparseArray<VibrationEffect> mFallbackEffects;
    private final WorkSource mTmpWorkSource = new WorkSource();
    private final Handler mH = new Handler();
    private final Object mLock = new Object();
    private final Context mContext;
    private final PowerManager.WakeLock mWakeLock;
    private final AppOpsManager mAppOps;
    private final IBatteryStats mBatteryStatsService;
    private PowerManagerInternal mPowerManagerInternal;
    private InputManager mIm;
    private Vibrator mVibrator;
    private SettingsObserver mSettingObserver;
    private volatile VibrateThread mThread;
    private final ArrayList<Vibrator> mInputDeviceVibrators = new ArrayList();
    private boolean mVibrateInputDevicesSetting;
    private boolean mInputDeviceListenerRegistered;
    @GuardedBy(value="mLock")
    private Vibration mCurrentVibration;
    private int mCurVibUid = -1;
    private boolean mLowPowerMode;
    private int mHapticFeedbackIntensity;
    private int mNotificationIntensity;
    private final Runnable mVibrationEndRunnable = new Runnable(){

        @Override
        public void run() {
            VibratorService.this.onVibrationFinished();
        }
    };
    BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.SCREEN_OFF")) {
                Object object = VibratorService.this.mLock;
                synchronized (object) {
                    if (!(VibratorService.this.mCurrentVibration == null || VibratorService.this.mCurrentVibration.isHapticFeedback() && VibratorService.this.mCurrentVibration.isFromSystem())) {
                        VibratorService.this.doCancelVibrateLocked();
                    }
                }
            }
        }
    };

    static native boolean vibratorExists();

    static native void vibratorInit();

    static native void vibratorOn(long var0);

    static native void vibratorOff();

    static native boolean vibratorSupportsAmplitudeControl();

    static native void vibratorSetAmplitude(int var0);

    static native long vibratorPerformEffect(long var0, long var2);

    VibratorService(Context context) {
        VibratorService.vibratorInit();
        VibratorService.vibratorOff();
        this.mSupportsAmplitudeControl = VibratorService.vibratorSupportsAmplitudeControl();
        this.mContext = context;
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, "*vibrator*");
        this.mWakeLock.setReferenceCounted(true);
        this.mAppOps = this.mContext.getSystemService(AppOpsManager.class);
        this.mBatteryStatsService = IBatteryStats.Stub.asInterface(ServiceManager.getService("batterystats"));
        this.mPreviousVibrationsLimit = this.mContext.getResources().getInteger(17694850);
        this.mDefaultVibrationAmplitude = this.mContext.getResources().getInteger(17694774);
        this.mAllowPriorityVibrationsInLowPowerMode = this.mContext.getResources().getBoolean(17956875);
        this.mPreviousVibrations = new LinkedList();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SCREEN_OFF");
        context.registerReceiver(this.mIntentReceiver, filter);
        VibrationEffect clickEffect = this.createEffectFromResource(17236053);
        VibrationEffect doubleClickEffect = VibrationEffect.createWaveform(DOUBLE_CLICK_EFFECT_FALLBACK_TIMINGS, -1);
        VibrationEffect heavyClickEffect = this.createEffectFromResource(17236017);
        VibrationEffect tickEffect = this.createEffectFromResource(17235996);
        this.mFallbackEffects = new SparseArray();
        this.mFallbackEffects.put(0, clickEffect);
        this.mFallbackEffects.put(1, doubleClickEffect);
        this.mFallbackEffects.put(2, tickEffect);
        this.mFallbackEffects.put(5, heavyClickEffect);
        this.mScaleLevels = new SparseArray();
        this.mScaleLevels.put(-2, new ScaleLevel(2.0f, 168));
        this.mScaleLevels.put(-1, new ScaleLevel(1.5f, 192));
        this.mScaleLevels.put(0, new ScaleLevel(1.0f));
        this.mScaleLevels.put(1, new ScaleLevel(0.5f));
        this.mScaleLevels.put(2, new ScaleLevel(0.25f));
    }

    private VibrationEffect createEffectFromResource(int resId) {
        long[] timings = VibratorService.getLongIntArray(this.mContext.getResources(), resId);
        return VibratorService.createEffectFromTimings(timings);
    }

    private static VibrationEffect createEffectFromTimings(long[] timings) {
        if (timings == null || timings.length == 0) {
            return null;
        }
        if (timings.length == 1) {
            return VibrationEffect.createOneShot(timings[0], -1);
        }
        return VibrationEffect.createWaveform(timings, -1);
    }

    public void systemReady() {
        Trace.traceBegin(0x800000L, "VibratorService#systemReady");
        try {
            this.mIm = this.mContext.getSystemService(InputManager.class);
            this.mVibrator = this.mContext.getSystemService(Vibrator.class);
            this.mSettingObserver = new SettingsObserver(this.mH);
            this.mPowerManagerInternal = LocalServices.getService(PowerManagerInternal.class);
            this.mPowerManagerInternal.registerLowPowerModeObserver(new PowerManagerInternal.LowPowerModeListener(){

                @Override
                public int getServiceType() {
                    return 2;
                }

                @Override
                public void onLowPowerModeChanged(PowerSaveState result) {
                    VibratorService.this.updateVibrators();
                }
            });
            this.mContext.getContentResolver().registerContentObserver(Settings.System.getUriFor("vibrate_input_devices"), true, this.mSettingObserver, -1);
            this.mContext.getContentResolver().registerContentObserver(Settings.System.getUriFor("haptic_feedback_intensity"), true, this.mSettingObserver, -1);
            this.mContext.getContentResolver().registerContentObserver(Settings.System.getUriFor("notification_vibration_intensity"), true, this.mSettingObserver, -1);
            this.mContext.registerReceiver(new BroadcastReceiver(){

                @Override
                public void onReceive(Context context, Intent intent) {
                    VibratorService.this.updateVibrators();
                }
            }, new IntentFilter("android.intent.action.USER_SWITCHED"), null, this.mH);
            this.updateVibrators();
        }
        finally {
            Trace.traceEnd(0x800000L);
        }
    }

    @Override
    public boolean hasVibrator() {
        return this.doVibratorExists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAmplitudeControl() {
        ArrayList<Vibrator> arrayList = this.mInputDeviceVibrators;
        synchronized (arrayList) {
            return this.mSupportsAmplitudeControl && this.mInputDeviceVibrators.isEmpty();
        }
    }

    private void verifyIncomingUid(int uid) {
        if (uid == Binder.getCallingUid()) {
            return;
        }
        if (Binder.getCallingPid() == Process.myPid()) {
            return;
        }
        this.mContext.enforcePermission("android.permission.UPDATE_APP_OPS_STATS", Binder.getCallingPid(), Binder.getCallingUid(), null);
    }

    private static boolean verifyVibrationEffect(VibrationEffect effect) {
        if (effect == null) {
            Slog.wtf(TAG, "effect must not be null");
            return false;
        }
        try {
            effect.validate();
        }
        catch (Exception e) {
            Slog.wtf(TAG, "Encountered issue when verifying VibrationEffect.", e);
            return false;
        }
        return true;
    }

    private static long[] getLongIntArray(Resources r, int resid) {
        int[] ar = r.getIntArray(resid);
        if (ar == null) {
            return null;
        }
        long[] out = new long[ar.length];
        for (int i = 0; i < ar.length; ++i) {
            out[i] = ar[i];
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void vibrate(int uid, String opPkg, VibrationEffect effect, int usageHint, IBinder token) {
        block17: {
            block16: {
                block15: {
                    Trace.traceBegin(0x800000L, "vibrate");
                    if (this.mContext.checkCallingOrSelfPermission("android.permission.VIBRATE") != 0) {
                        throw new SecurityException("Requires VIBRATE permission");
                    }
                    if (token != null) break block15;
                    Slog.e(TAG, "token must not be null");
                    Trace.traceEnd(0x800000L);
                    return;
                }
                this.verifyIncomingUid(uid);
                if (VibratorService.verifyVibrationEffect(effect)) break block16;
                Trace.traceEnd(0x800000L);
                return;
            }
            Object object = this.mLock;
            // MONITORENTER : object
            if (!(effect instanceof VibrationEffect.OneShot) || this.mCurrentVibration == null || !(this.mCurrentVibration.effect instanceof VibrationEffect.OneShot)) break block17;
            VibrationEffect.OneShot newOneShot = (VibrationEffect.OneShot)effect;
            VibrationEffect.OneShot currentOneShot = (VibrationEffect.OneShot)this.mCurrentVibration.effect;
            if (!this.mCurrentVibration.hasTimeoutLongerThan(newOneShot.getDuration()) || newOneShot.getAmplitude() != currentOneShot.getAmplitude()) break block17;
            // MONITOREXIT : object
            Trace.traceEnd(0x800000L);
            return;
        }
        if (!VibratorService.isRepeatingVibration(effect) && this.mCurrentVibration != null && VibratorService.isRepeatingVibration(this.mCurrentVibration.effect)) {
            // MONITOREXIT : object
            Trace.traceEnd(0x800000L);
            return;
        }
        try {
            Vibration vib = new Vibration(token, effect, usageHint, uid, opPkg);
            this.linkVibration(vib);
            long ident = Binder.clearCallingIdentity();
            try {
                this.doCancelVibrateLocked();
                this.startVibrationLocked(vib);
                this.addToPreviousVibrationsLocked(vib);
                return;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
        finally {
            Trace.traceEnd(0x800000L);
        }
    }

    private static boolean isRepeatingVibration(VibrationEffect effect) {
        return effect.getDuration() == Long.MAX_VALUE;
    }

    private void addToPreviousVibrationsLocked(Vibration vib) {
        if (this.mPreviousVibrations.size() > this.mPreviousVibrationsLimit) {
            this.mPreviousVibrations.removeFirst();
        }
        this.mPreviousVibrations.addLast(vib.toInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelVibrate(IBinder token) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.VIBRATE", "cancelVibrate");
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCurrentVibration != null && this.mCurrentVibration.token == token) {
                long ident = Binder.clearCallingIdentity();
                try {
                    this.doCancelVibrateLocked();
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
        }
    }

    @GuardedBy(value="mLock")
    private void doCancelVibrateLocked() {
        Trace.asyncTraceEnd(0x800000L, "vibration", 0);
        Trace.traceBegin(0x800000L, "doCancelVibrateLocked");
        try {
            this.mH.removeCallbacks(this.mVibrationEndRunnable);
            if (this.mThread != null) {
                this.mThread.cancel();
                this.mThread = null;
            }
            this.doVibratorOff();
            this.reportFinishVibrationLocked();
        }
        finally {
            Trace.traceEnd(0x800000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onVibrationFinished() {
        Object object = this.mLock;
        synchronized (object) {
            this.doCancelVibrateLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="mLock")
    private void startVibrationLocked(Vibration vib) {
        Trace.traceBegin(0x800000L, "startVibrationLocked");
        try {
            if (!this.isAllowedToVibrateLocked(vib)) {
                return;
            }
            int intensity = this.getCurrentIntensityLocked(vib);
            if (intensity == 0) {
                return;
            }
            if (vib.isRingtone() && !this.shouldVibrateForRingtone()) {
                return;
            }
            int mode = this.getAppOpMode(vib);
            if (mode != 0) {
                if (mode == 2) {
                    Slog.w(TAG, "Would be an error: vibrate from uid " + vib.uid);
                }
                return;
            }
            this.applyVibrationIntensityScalingLocked(vib, intensity);
            this.startVibrationInnerLocked(vib);
        }
        finally {
            Trace.traceEnd(0x800000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="mLock")
    private void startVibrationInnerLocked(Vibration vib) {
        Trace.traceBegin(0x800000L, "startVibrationInnerLocked");
        try {
            this.mCurrentVibration = vib;
            if (vib.effect instanceof VibrationEffect.OneShot) {
                Trace.asyncTraceBegin(0x800000L, "vibration", 0);
                VibrationEffect.OneShot oneShot = (VibrationEffect.OneShot)vib.effect;
                this.doVibratorOn(oneShot.getDuration(), oneShot.getAmplitude(), vib.uid, vib.usageHint);
                this.mH.postDelayed(this.mVibrationEndRunnable, oneShot.getDuration());
            } else if (vib.effect instanceof VibrationEffect.Waveform) {
                Trace.asyncTraceBegin(0x800000L, "vibration", 0);
                VibrationEffect.Waveform waveform = (VibrationEffect.Waveform)vib.effect;
                this.mThread = new VibrateThread(waveform, vib.uid, vib.usageHint);
                this.mThread.start();
            } else if (vib.effect instanceof VibrationEffect.Prebaked) {
                Trace.asyncTraceBegin(0x800000L, "vibration", 0);
                long timeout = this.doVibratorPrebakedEffectLocked(vib);
                if (timeout > 0L) {
                    this.mH.postDelayed(this.mVibrationEndRunnable, timeout);
                }
            } else {
                Slog.e(TAG, "Unknown vibration type, ignoring");
            }
        }
        finally {
            Trace.traceEnd(0x800000L);
        }
    }

    private boolean isAllowedToVibrateLocked(Vibration vib) {
        if (!this.mLowPowerMode) {
            return true;
        }
        if (vib.usageHint == 6) {
            return true;
        }
        return vib.usageHint == 4 || vib.usageHint == 11 || vib.usageHint == 7;
    }

    private int getCurrentIntensityLocked(Vibration vib) {
        if (vib.isNotification() || vib.isRingtone()) {
            return this.mNotificationIntensity;
        }
        if (vib.isHapticFeedback()) {
            return this.mHapticFeedbackIntensity;
        }
        return 2;
    }

    private void applyVibrationIntensityScalingLocked(Vibration vib, int intensity) {
        int defaultIntensity;
        if (vib.effect instanceof VibrationEffect.Prebaked) {
            VibrationEffect.Prebaked prebaked = (VibrationEffect.Prebaked)vib.effect;
            prebaked.setEffectStrength(VibratorService.intensityToEffectStrength(intensity));
            return;
        }
        if (vib.isNotification() || vib.isRingtone()) {
            defaultIntensity = this.mVibrator.getDefaultNotificationVibrationIntensity();
        } else if (vib.isHapticFeedback()) {
            defaultIntensity = this.mVibrator.getDefaultHapticFeedbackIntensity();
        } else {
            return;
        }
        ScaleLevel scale = this.mScaleLevels.get(intensity - defaultIntensity);
        if (scale == null) {
            Slog.e(TAG, "No configured scaling level! (current=" + intensity + ", default= " + defaultIntensity + ")");
            return;
        }
        VibrationEffect scaledEffect = null;
        if (vib.effect instanceof VibrationEffect.OneShot) {
            VibrationEffect.OneShot oneShot = (VibrationEffect.OneShot)vib.effect;
            oneShot = oneShot.resolve(this.mDefaultVibrationAmplitude);
            scaledEffect = oneShot.scale(scale.gamma, scale.maxAmplitude);
        } else if (vib.effect instanceof VibrationEffect.Waveform) {
            VibrationEffect.Waveform waveform = (VibrationEffect.Waveform)vib.effect;
            waveform = waveform.resolve(this.mDefaultVibrationAmplitude);
            scaledEffect = waveform.scale(scale.gamma, scale.maxAmplitude);
        } else {
            Slog.w(TAG, "Unable to apply intensity scaling, unknown VibrationEffect type");
        }
        if (scaledEffect != null) {
            vib.originalEffect = vib.effect;
            vib.effect = scaledEffect;
        }
    }

    private boolean shouldVibrateForRingtone() {
        AudioManager audioManager = this.mContext.getSystemService(AudioManager.class);
        int ringerMode = audioManager.getRingerModeInternal();
        if (Settings.System.getInt(this.mContext.getContentResolver(), "vibrate_when_ringing", 0) != 0) {
            return ringerMode != 0;
        }
        return ringerMode == 1;
    }

    private int getAppOpMode(Vibration vib) {
        int mode = this.mAppOps.checkAudioOpNoThrow(3, vib.usageHint, vib.uid, vib.opPkg);
        if (mode == 0) {
            mode = this.mAppOps.startOpNoThrow(3, vib.uid, vib.opPkg);
        }
        return mode;
    }

    @GuardedBy(value="mLock")
    private void reportFinishVibrationLocked() {
        Trace.traceBegin(0x800000L, "reportFinishVibrationLocked");
        try {
            if (this.mCurrentVibration != null) {
                this.mAppOps.finishOp(3, this.mCurrentVibration.uid, this.mCurrentVibration.opPkg);
                this.unlinkVibration(this.mCurrentVibration);
                this.mCurrentVibration = null;
            }
        }
        finally {
            Trace.traceEnd(0x800000L);
        }
    }

    private void linkVibration(Vibration vib) {
        if (vib.effect instanceof VibrationEffect.Waveform) {
            try {
                vib.token.linkToDeath(vib, 0);
            }
            catch (RemoteException e) {
                return;
            }
        }
    }

    private void unlinkVibration(Vibration vib) {
        if (vib.effect instanceof VibrationEffect.Waveform) {
            vib.token.unlinkToDeath(vib, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVibrators() {
        Object object = this.mLock;
        synchronized (object) {
            boolean devicesUpdated = this.updateInputDeviceVibratorsLocked();
            boolean lowPowerModeUpdated = this.updateLowPowerModeLocked();
            this.updateVibrationIntensityLocked();
            if (devicesUpdated || lowPowerModeUpdated) {
                this.doCancelVibrateLocked();
            }
        }
    }

    private boolean updateInputDeviceVibratorsLocked() {
        boolean changed = false;
        boolean vibrateInputDevices = false;
        try {
            vibrateInputDevices = Settings.System.getIntForUser(this.mContext.getContentResolver(), "vibrate_input_devices", -2) > 0;
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            // empty catch block
        }
        if (vibrateInputDevices != this.mVibrateInputDevicesSetting) {
            changed = true;
            this.mVibrateInputDevicesSetting = vibrateInputDevices;
        }
        if (this.mVibrateInputDevicesSetting) {
            if (!this.mInputDeviceListenerRegistered) {
                this.mInputDeviceListenerRegistered = true;
                this.mIm.registerInputDeviceListener(this, this.mH);
            }
        } else if (this.mInputDeviceListenerRegistered) {
            this.mInputDeviceListenerRegistered = false;
            this.mIm.unregisterInputDeviceListener(this);
        }
        this.mInputDeviceVibrators.clear();
        if (this.mVibrateInputDevicesSetting) {
            int[] ids = this.mIm.getInputDeviceIds();
            for (int i = 0; i < ids.length; ++i) {
                InputDevice device = this.mIm.getInputDevice(ids[i]);
                Vibrator vibrator = device.getVibrator();
                if (!vibrator.hasVibrator()) continue;
                this.mInputDeviceVibrators.add(vibrator);
            }
            return true;
        }
        return changed;
    }

    private boolean updateLowPowerModeLocked() {
        boolean lowPowerMode = this.mPowerManagerInternal.getLowPowerState((int)2).batterySaverEnabled;
        if (lowPowerMode != this.mLowPowerMode) {
            this.mLowPowerMode = lowPowerMode;
            return true;
        }
        return false;
    }

    private void updateVibrationIntensityLocked() {
        this.mHapticFeedbackIntensity = Settings.System.getIntForUser(this.mContext.getContentResolver(), "haptic_feedback_intensity", this.mVibrator.getDefaultHapticFeedbackIntensity(), -2);
        this.mNotificationIntensity = Settings.System.getIntForUser(this.mContext.getContentResolver(), "notification_vibration_intensity", this.mVibrator.getDefaultNotificationVibrationIntensity(), -2);
    }

    @Override
    public void onInputDeviceAdded(int deviceId) {
        this.updateVibrators();
    }

    @Override
    public void onInputDeviceChanged(int deviceId) {
        this.updateVibrators();
    }

    @Override
    public void onInputDeviceRemoved(int deviceId) {
        this.updateVibrators();
    }

    private boolean doVibratorExists() {
        return VibratorService.vibratorExists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doVibratorOn(long millis, int amplitude, int uid, int usageHint) {
        Trace.traceBegin(0x800000L, "doVibratorOn");
        try {
            ArrayList<Vibrator> arrayList = this.mInputDeviceVibrators;
            synchronized (arrayList) {
                if (amplitude == -1) {
                    amplitude = this.mDefaultVibrationAmplitude;
                }
                this.noteVibratorOnLocked(uid, millis);
                int vibratorCount = this.mInputDeviceVibrators.size();
                if (vibratorCount != 0) {
                    AudioAttributes attributes = new AudioAttributes.Builder().setUsage(usageHint).build();
                    for (int i = 0; i < vibratorCount; ++i) {
                        this.mInputDeviceVibrators.get(i).vibrate(millis, attributes);
                    }
                } else {
                    VibratorService.vibratorOn(millis);
                    this.doVibratorSetAmplitude(amplitude);
                }
            }
        }
        finally {
            Trace.traceEnd(0x800000L);
        }
    }

    private void doVibratorSetAmplitude(int amplitude) {
        if (this.mSupportsAmplitudeControl) {
            VibratorService.vibratorSetAmplitude(amplitude);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doVibratorOff() {
        Trace.traceBegin(0x800000L, "doVibratorOff");
        try {
            ArrayList<Vibrator> arrayList = this.mInputDeviceVibrators;
            synchronized (arrayList) {
                this.noteVibratorOffLocked();
                int vibratorCount = this.mInputDeviceVibrators.size();
                if (vibratorCount != 0) {
                    for (int i = 0; i < vibratorCount; ++i) {
                        this.mInputDeviceVibrators.get(i).cancel();
                    }
                } else {
                    VibratorService.vibratorOff();
                }
            }
        }
        finally {
            Trace.traceEnd(0x800000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="mLock")
    private long doVibratorPrebakedEffectLocked(Vibration vib) {
        Trace.traceBegin(0x800000L, "doVibratorPrebakedEffectLocked");
        try {
            long timeout;
            boolean usingInputDeviceVibrators;
            VibrationEffect.Prebaked prebaked = (VibrationEffect.Prebaked)vib.effect;
            ArrayList<Vibrator> arrayList = this.mInputDeviceVibrators;
            synchronized (arrayList) {
                usingInputDeviceVibrators = !this.mInputDeviceVibrators.isEmpty();
            }
            if (!usingInputDeviceVibrators && (timeout = VibratorService.vibratorPerformEffect(prebaked.getId(), prebaked.getEffectStrength())) > 0L) {
                this.noteVibratorOnLocked(vib.uid, timeout);
                long l = timeout;
                return l;
            }
            if (!prebaked.shouldFallback()) {
                timeout = 0L;
                return timeout;
            }
            VibrationEffect effect = this.getFallbackEffect(prebaked.getId());
            if (effect == null) {
                Slog.w(TAG, "Failed to play prebaked effect, no fallback");
                long l = 0L;
                return l;
            }
            Vibration fallbackVib = new Vibration(vib.token, effect, vib.usageHint, vib.uid, vib.opPkg);
            int intensity = this.getCurrentIntensityLocked(fallbackVib);
            this.linkVibration(fallbackVib);
            this.applyVibrationIntensityScalingLocked(fallbackVib, intensity);
            this.startVibrationInnerLocked(fallbackVib);
            long l = 0L;
            return l;
        }
        finally {
            Trace.traceEnd(0x800000L);
        }
    }

    private VibrationEffect getFallbackEffect(int effectId) {
        return this.mFallbackEffects.get(effectId);
    }

    private static int intensityToEffectStrength(int intensity) {
        switch (intensity) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        Slog.w(TAG, "Got unexpected vibration intensity: " + intensity);
        return 2;
    }

    private void noteVibratorOnLocked(int uid, long millis) {
        try {
            this.mBatteryStatsService.noteVibratorOn(uid, millis);
            this.mCurVibUid = uid;
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void noteVibratorOffLocked() {
        if (this.mCurVibUid >= 0) {
            try {
                this.mBatteryStatsService.noteVibratorOff(this.mCurVibUid);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.mCurVibUid = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, pw)) {
            return;
        }
        pw.println("Vibrator Service:");
        Object object = this.mLock;
        synchronized (object) {
            pw.print("  mCurrentVibration=");
            if (this.mCurrentVibration != null) {
                pw.println(this.mCurrentVibration.toInfo().toString());
            } else {
                pw.println("null");
            }
            pw.println("  mLowPowerMode=" + this.mLowPowerMode);
            pw.println("  mHapticFeedbackIntensity=" + this.mHapticFeedbackIntensity);
            pw.println("  mNotificationIntensity=" + this.mNotificationIntensity);
            pw.println("");
            pw.println("  Previous vibrations:");
            for (VibrationInfo info : this.mPreviousVibrations) {
                pw.print("    ");
                pw.println(info.toString());
            }
        }
    }

    @Override
    public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) throws RemoteException {
        new VibratorShellCommand(this).exec(this, in, out, err, args, callback, resultReceiver);
    }

    static /* synthetic */ Context access$1100(VibratorService x0) {
        return x0.mContext;
    }

    private final class VibratorShellCommand
    extends ShellCommand {
        private static final long MAX_VIBRATION_MS = 200L;
        private final IBinder mToken;

        private VibratorShellCommand(IBinder token) {
            this.mToken = token;
        }

        @Override
        public int onCommand(String cmd) {
            if ("vibrate".equals(cmd)) {
                return this.runVibrate();
            }
            return this.handleDefaultCommands(cmd);
        }

        /*
         * Exception decompiling
         */
        private int runVibrate() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void onHelp() {
            try (PrintWriter pw = this.getOutPrintWriter();){
                pw.println("Vibrator commands:");
                pw.println("  help");
                pw.println("    Prints this help text.");
                pw.println("");
                pw.println("  vibrate duration [description]");
                pw.println("    Vibrates for duration milliseconds; ignored when device is on DND ");
                pw.println("    (Do Not Disturb) mode.");
                pw.println("");
            }
        }
    }

    private class VibrateThread
    extends Thread {
        private final VibrationEffect.Waveform mWaveform;
        private final int mUid;
        private final int mUsageHint;
        private boolean mForceStop;

        VibrateThread(VibrationEffect.Waveform waveform, int uid, int usageHint) {
            this.mWaveform = waveform;
            this.mUid = uid;
            this.mUsageHint = usageHint;
            VibratorService.this.mTmpWorkSource.set(uid);
            VibratorService.this.mWakeLock.setWorkSource(VibratorService.this.mTmpWorkSource);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long delayLocked(long duration) {
            Trace.traceBegin(0x800000L, "delayLocked");
            try {
                long durationRemaining = duration;
                if (duration > 0L) {
                    long bedtime = duration + SystemClock.uptimeMillis();
                    do {
                        try {
                            this.wait(durationRemaining);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (!this.mForceStop && (durationRemaining = bedtime - SystemClock.uptimeMillis()) > 0L);
                    long l = duration - durationRemaining;
                    return l;
                }
                long l = 0L;
                return l;
            }
            finally {
                Trace.traceEnd(0x800000L);
            }
        }

        @Override
        public void run() {
            Process.setThreadPriority(-8);
            VibratorService.this.mWakeLock.acquire();
            try {
                boolean finished = this.playWaveform();
                if (finished) {
                    VibratorService.this.onVibrationFinished();
                }
            }
            finally {
                VibratorService.this.mWakeLock.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean playWaveform() {
            Trace.traceBegin(0x800000L, "playWaveform");
            try {
                VibrateThread vibrateThread = this;
                synchronized (vibrateThread) {
                    long[] timings = this.mWaveform.getTimings();
                    int[] amplitudes = this.mWaveform.getAmplitudes();
                    int len = timings.length;
                    int repeat = this.mWaveform.getRepeatIndex();
                    int index = 0;
                    long onDuration = 0L;
                    while (!this.mForceStop) {
                        if (index < len) {
                            long duration;
                            int amplitude = amplitudes[index];
                            if ((duration = timings[index++]) <= 0L) continue;
                            if (amplitude != 0) {
                                if (onDuration <= 0L) {
                                    onDuration = this.getTotalOnDuration(timings, amplitudes, index - 1, repeat);
                                    VibratorService.this.doVibratorOn(onDuration, amplitude, this.mUid, this.mUsageHint);
                                } else {
                                    VibratorService.this.doVibratorSetAmplitude(amplitude);
                                }
                            }
                            long waitTime = this.delayLocked(duration);
                            if (amplitude == 0) continue;
                            onDuration -= waitTime;
                            continue;
                        }
                        if (repeat < 0) break;
                        index = repeat;
                    }
                    boolean bl = !this.mForceStop;
                    return bl;
                }
            }
            finally {
                Trace.traceEnd(0x800000L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            VibrateThread vibrateThread = this;
            synchronized (vibrateThread) {
                ((VibratorService)VibratorService.this).mThread.mForceStop = true;
                VibratorService.this.mThread.notify();
            }
        }

        private long getTotalOnDuration(long[] timings, int[] amplitudes, int startIndex, int repeatIndex) {
            int i = startIndex;
            long timing = 0L;
            while (amplitudes[i] != 0) {
                timing += timings[i++];
                if (i >= timings.length) {
                    if (repeatIndex < 0) break;
                    i = repeatIndex;
                }
                if (i != startIndex) continue;
                return 1000L;
            }
            return timing;
        }
    }

    private final class SettingsObserver
    extends ContentObserver {
        public SettingsObserver(Handler handler) {
            super(handler);
        }

        @Override
        public void onChange(boolean SelfChange) {
            VibratorService.this.updateVibrators();
        }
    }

    private static final class ScaleLevel {
        public final float gamma;
        public final int maxAmplitude;

        public ScaleLevel(float gamma) {
            this(gamma, 255);
        }

        public ScaleLevel(float gamma, int maxAmplitude) {
            this.gamma = gamma;
            this.maxAmplitude = maxAmplitude;
        }

        public String toString() {
            return "ScaleLevel{gamma=" + this.gamma + ", maxAmplitude=" + this.maxAmplitude + "}";
        }
    }

    private static class VibrationInfo {
        private final long mStartTimeDebug;
        private final VibrationEffect mEffect;
        private final VibrationEffect mOriginalEffect;
        private final int mUsageHint;
        private final int mUid;
        private final String mOpPkg;

        public VibrationInfo(long startTimeDebug, VibrationEffect effect, VibrationEffect originalEffect, int usageHint, int uid, String opPkg) {
            this.mStartTimeDebug = startTimeDebug;
            this.mEffect = effect;
            this.mOriginalEffect = originalEffect;
            this.mUsageHint = usageHint;
            this.mUid = uid;
            this.mOpPkg = opPkg;
        }

        public String toString() {
            return "startTime: " + DateFormat.getDateTimeInstance().format(new Date(this.mStartTimeDebug)) + ", effect: " + this.mEffect + ", originalEffect: " + this.mOriginalEffect + ", usageHint: " + this.mUsageHint + ", uid: " + this.mUid + ", opPkg: " + this.mOpPkg;
        }
    }

    private class Vibration
    implements IBinder.DeathRecipient {
        public final IBinder token;
        public final long startTime;
        public final long startTimeDebug;
        public final int usageHint;
        public final int uid;
        public final String opPkg;
        public VibrationEffect effect;
        public VibrationEffect originalEffect;

        private Vibration(IBinder token, VibrationEffect effect, int usageHint, int uid, String opPkg) {
            this.token = token;
            this.effect = effect;
            this.startTime = SystemClock.elapsedRealtime();
            this.startTimeDebug = System.currentTimeMillis();
            this.usageHint = usageHint;
            this.uid = uid;
            this.opPkg = opPkg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Object object = VibratorService.this.mLock;
            synchronized (object) {
                if (this == VibratorService.this.mCurrentVibration) {
                    VibratorService.this.doCancelVibrateLocked();
                }
            }
        }

        public boolean hasTimeoutLongerThan(long millis) {
            long duration = this.effect.getDuration();
            return duration >= 0L && duration > millis;
        }

        public boolean isHapticFeedback() {
            if (this.effect instanceof VibrationEffect.Prebaked) {
                VibrationEffect.Prebaked prebaked = (VibrationEffect.Prebaked)this.effect;
                switch (prebaked.getId()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        return true;
                    }
                }
                Slog.w(VibratorService.TAG, "Unknown prebaked vibration effect, assuming it isn't haptic feedback.");
                return false;
            }
            long duration = this.effect.getDuration();
            return duration >= 0L && duration < 5000L;
        }

        public boolean isNotification() {
            switch (this.usageHint) {
                case 5: 
                case 7: 
                case 8: 
                case 9: {
                    return true;
                }
            }
            return false;
        }

        public boolean isRingtone() {
            return this.usageHint == 6;
        }

        public boolean isFromSystem() {
            return this.uid == 1000 || this.uid == 0 || VibratorService.SYSTEM_UI_PACKAGE.equals(this.opPkg);
        }

        public VibrationInfo toInfo() {
            return new VibrationInfo(this.startTimeDebug, this.effect, this.originalEffect, this.usageHint, this.uid, this.opPkg);
        }
    }
}

