/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.accessibility;

import android.content.res.Resources;
import android.hardware.fingerprint.IFingerprintClientActiveCallback;
import android.hardware.fingerprint.IFingerprintService;
import android.os.Binder;
import android.os.Handler;
import android.os.Message;
import android.os.RemoteException;
import android.util.Slog;
import java.util.ArrayList;
import java.util.List;

public class FingerprintGestureDispatcher
extends IFingerprintClientActiveCallback.Stub
implements Handler.Callback {
    private static final int MSG_REGISTER = 1;
    private static final int MSG_UNREGISTER = 2;
    private static final String LOG_TAG = "FingerprintGestureDispatcher";
    private final List<FingerprintGestureClient> mCapturingClients = new ArrayList<FingerprintGestureClient>(0);
    private final Object mLock;
    private final IFingerprintService mFingerprintService;
    private final Handler mHandler;
    private final boolean mHardwareSupportsGestures;
    private boolean mRegisteredReadOnlyExceptInHandler;

    public FingerprintGestureDispatcher(IFingerprintService fingerprintService, Resources resources, Object lock) {
        this.mFingerprintService = fingerprintService;
        this.mHardwareSupportsGestures = resources.getBoolean(17956975);
        this.mLock = lock;
        this.mHandler = new Handler(this);
    }

    public FingerprintGestureDispatcher(IFingerprintService fingerprintService, Resources resources, Object lock, Handler handler) {
        this.mFingerprintService = fingerprintService;
        this.mHardwareSupportsGestures = resources.getBoolean(17956975);
        this.mLock = lock;
        this.mHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClientList(List<? extends FingerprintGestureClient> clientList) {
        if (!this.mHardwareSupportsGestures) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mCapturingClients.clear();
            for (int i = 0; i < clientList.size(); ++i) {
                FingerprintGestureClient client = clientList.get(i);
                if (!client.isCapturingFingerprintGestures()) continue;
                this.mCapturingClients.add(client);
            }
            if (this.mCapturingClients.isEmpty()) {
                if (this.mRegisteredReadOnlyExceptInHandler) {
                    this.mHandler.obtainMessage(2).sendToTarget();
                }
            } else if (!this.mRegisteredReadOnlyExceptInHandler) {
                this.mHandler.obtainMessage(1).sendToTarget();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onClientActiveChanged(boolean nonGestureFingerprintClientActive) {
        if (!this.mHardwareSupportsGestures) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < this.mCapturingClients.size(); ++i) {
                this.mCapturingClients.get(i).onFingerprintGestureDetectionActiveChanged(!nonGestureFingerprintClientActive);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFingerprintGestureDetectionAvailable() {
        if (!this.mHardwareSupportsGestures) {
            return false;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            boolean bl = !this.mFingerprintService.isClientActive();
            return bl;
        }
        catch (RemoteException re) {
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onFingerprintGesture(int fingerprintKeyCode) {
        ArrayList<FingerprintGestureClient> clientList;
        int idForFingerprintGestureManager;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCapturingClients.isEmpty()) {
                return false;
            }
            switch (fingerprintKeyCode) {
                case 280: {
                    idForFingerprintGestureManager = 4;
                    break;
                }
                case 281: {
                    idForFingerprintGestureManager = 8;
                    break;
                }
                case 283: {
                    idForFingerprintGestureManager = 1;
                    break;
                }
                case 282: {
                    idForFingerprintGestureManager = 2;
                    break;
                }
                default: {
                    return false;
                }
            }
            clientList = new ArrayList<FingerprintGestureClient>(this.mCapturingClients);
        }
        for (int i = 0; i < clientList.size(); ++i) {
            ((FingerprintGestureClient)clientList.get(i)).onFingerprintGesture(idForFingerprintGestureManager);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleMessage(Message message) {
        if (message.what == 1) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mFingerprintService.addClientActiveCallback(this);
                this.mRegisteredReadOnlyExceptInHandler = true;
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Failed to register for fingerprint activity callbacks");
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
            return false;
        }
        if (message.what == 2) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mFingerprintService.removeClientActiveCallback(this);
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Failed to unregister for fingerprint activity callbacks");
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        } else {
            Slog.e(LOG_TAG, "Unknown message: " + message.what);
            return false;
        }
        this.mRegisteredReadOnlyExceptInHandler = false;
        return true;
    }

    public static interface FingerprintGestureClient {
        public boolean isCapturingFingerprintGestures();

        public void onFingerprintGestureDetectionActiveChanged(boolean var1);

        public void onFingerprintGesture(int var1);
    }
}

