/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.accessibility;

import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.util.Pools;
import android.util.Slog;
import android.view.KeyEvent;
import com.android.server.accessibility.AccessibilityManagerService;
import com.android.server.accessibility.BaseEventStreamTransformation;
import com.android.server.policy.WindowManagerPolicy;

public class KeyboardInterceptor
extends BaseEventStreamTransformation
implements Handler.Callback {
    private static final int MESSAGE_PROCESS_QUEUED_EVENTS = 1;
    private static final String LOG_TAG = "KeyboardInterceptor";
    private final AccessibilityManagerService mAms;
    private final WindowManagerPolicy mPolicy;
    private final Handler mHandler;
    private KeyEventHolder mEventQueueStart;
    private KeyEventHolder mEventQueueEnd;

    public KeyboardInterceptor(AccessibilityManagerService service, WindowManagerPolicy policy) {
        this.mAms = service;
        this.mPolicy = policy;
        this.mHandler = new Handler(this);
    }

    public KeyboardInterceptor(AccessibilityManagerService service, WindowManagerPolicy policy, Handler handler) {
        this.mAms = service;
        this.mPolicy = policy;
        this.mHandler = handler;
    }

    @Override
    public void onKeyEvent(KeyEvent event, int policyFlags) {
        long eventDelay = this.getEventDelay(event, policyFlags);
        if (eventDelay < 0L) {
            return;
        }
        if (eventDelay > 0L || this.mEventQueueStart != null) {
            this.addEventToQueue(event, policyFlags, eventDelay);
            return;
        }
        this.mAms.notifyKeyEvent(event, policyFlags);
    }

    @Override
    public boolean handleMessage(Message msg) {
        if (msg.what != 1) {
            Slog.e(LOG_TAG, "Unexpected message type");
            return false;
        }
        this.processQueuedEvents();
        if (this.mEventQueueStart != null) {
            this.scheduleProcessQueuedEvents();
        }
        return true;
    }

    private void addEventToQueue(KeyEvent event, int policyFlags, long delay) {
        long dispatchTime = SystemClock.uptimeMillis() + delay;
        if (this.mEventQueueStart == null) {
            this.mEventQueueEnd = this.mEventQueueStart = KeyEventHolder.obtain(event, policyFlags, dispatchTime);
            this.scheduleProcessQueuedEvents();
            return;
        }
        KeyEventHolder holder = KeyEventHolder.obtain(event, policyFlags, dispatchTime);
        holder.next = this.mEventQueueStart;
        this.mEventQueueStart.previous = holder;
        this.mEventQueueStart = holder;
    }

    private void scheduleProcessQueuedEvents() {
        if (!this.mHandler.sendEmptyMessageAtTime(1, this.mEventQueueEnd.dispatchTime)) {
            Slog.e(LOG_TAG, "Failed to schedule key event");
        }
    }

    private void processQueuedEvents() {
        long currentTime = SystemClock.uptimeMillis();
        while (this.mEventQueueEnd != null && this.mEventQueueEnd.dispatchTime <= currentTime) {
            long eventDelay = this.getEventDelay(this.mEventQueueEnd.event, this.mEventQueueEnd.policyFlags);
            if (eventDelay > 0L) {
                this.mEventQueueEnd.dispatchTime = currentTime + eventDelay;
                return;
            }
            if (eventDelay == 0L) {
                this.mAms.notifyKeyEvent(this.mEventQueueEnd.event, this.mEventQueueEnd.policyFlags);
            }
            KeyEventHolder eventToBeRecycled = this.mEventQueueEnd;
            this.mEventQueueEnd = this.mEventQueueEnd.previous;
            if (this.mEventQueueEnd != null) {
                this.mEventQueueEnd.next = null;
            }
            eventToBeRecycled.recycle();
            if (this.mEventQueueEnd != null) continue;
            this.mEventQueueStart = null;
        }
    }

    private long getEventDelay(KeyEvent event, int policyFlags) {
        int keyCode = event.getKeyCode();
        if (keyCode == 25 || keyCode == 24) {
            return this.mPolicy.interceptKeyBeforeDispatching(null, event, policyFlags);
        }
        return 0L;
    }

    private static class KeyEventHolder {
        private static final int MAX_POOL_SIZE = 32;
        private static final Pools.SimplePool<KeyEventHolder> sPool = new Pools.SimplePool(32);
        public int policyFlags;
        public long dispatchTime;
        public KeyEvent event;
        public KeyEventHolder next;
        public KeyEventHolder previous;

        private KeyEventHolder() {
        }

        public static KeyEventHolder obtain(KeyEvent event, int policyFlags, long dispatchTime) {
            KeyEventHolder holder = sPool.acquire();
            if (holder == null) {
                holder = new KeyEventHolder();
            }
            holder.event = KeyEvent.obtain(event);
            holder.policyFlags = policyFlags;
            holder.dispatchTime = dispatchTime;
            return holder;
        }

        public void recycle() {
            this.event.recycle();
            this.event = null;
            this.policyFlags = 0;
            this.dispatchTime = 0L;
            this.next = null;
            this.previous = null;
            sPool.release(this);
        }
    }
}

