/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.accounts;

import android.os.ShellCommand;
import android.os.UserHandle;
import com.android.server.accounts.AccountManagerService;
import java.io.PrintWriter;

final class AccountManagerServiceShellCommand
extends ShellCommand {
    final AccountManagerService mService;

    AccountManagerServiceShellCommand(AccountManagerService service) {
        this.mService = service;
    }

    @Override
    public int onCommand(String cmd) {
        if (cmd == null) {
            return this.handleDefaultCommands(cmd);
        }
        switch (cmd) {
            case "get-bind-instant-service-allowed": {
                return this.runGetBindInstantServiceAllowed();
            }
            case "set-bind-instant-service-allowed": {
                return this.runSetBindInstantServiceAllowed();
            }
        }
        return -1;
    }

    private int runGetBindInstantServiceAllowed() {
        Integer userId = this.parseUserId();
        if (userId == null) {
            return -1;
        }
        this.getOutPrintWriter().println(Boolean.toString(this.mService.getBindInstantServiceAllowed(userId)));
        return 0;
    }

    private int runSetBindInstantServiceAllowed() {
        Integer userId = this.parseUserId();
        if (userId == null) {
            return -1;
        }
        String allowed = this.getNextArgRequired();
        if (allowed == null) {
            this.getErrPrintWriter().println("Error: no true/false specified");
            return -1;
        }
        this.mService.setBindInstantServiceAllowed(userId, Boolean.parseBoolean(allowed));
        return 0;
    }

    private Integer parseUserId() {
        String option = this.getNextOption();
        if (option != null) {
            if (option.equals("--user")) {
                return UserHandle.parseUserArg(this.getNextArgRequired());
            }
            this.getErrPrintWriter().println("Unknown option: " + option);
            return null;
        }
        return 0;
    }

    @Override
    public void onHelp() {
        PrintWriter pw = this.getOutPrintWriter();
        pw.println("Account manager service commands:");
        pw.println("  help");
        pw.println("    Print this help text.");
        pw.println("  set-bind-instant-service-allowed [--user <USER_ID>] true|false ");
        pw.println("    Set whether binding to services provided by instant apps is allowed.");
        pw.println("  get-bind-instant-service-allowed [--user <USER_ID>]");
        pw.println("    Get whether binding to services provided by instant apps is allowed.");
    }
}

