/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.app.ActivityManagerInternal;
import android.app.ActivityOptions;
import android.app.AppOpsManager;
import android.app.ProfilerInfo;
import android.app.ResultInfo;
import android.app.WaitResult;
import android.app.WindowConfiguration;
import android.app.servertransaction.ActivityLifecycleItem;
import android.app.servertransaction.ClientTransaction;
import android.app.servertransaction.LaunchActivityItem;
import android.app.servertransaction.PauseActivityItem;
import android.app.servertransaction.ResumeActivityItem;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.hardware.display.DisplayManager;
import android.hardware.display.DisplayManagerInternal;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.Trace;
import android.os.UserManager;
import android.os.WorkSource;
import android.service.voice.IVoiceInteractionSession;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.EventLog;
import android.util.IntArray;
import android.util.MergedConfiguration;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.TimeUtils;
import android.util.proto.ProtoOutputStream;
import android.view.Display;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.content.ReferrerIntent;
import com.android.internal.os.TransferPipe;
import com.android.internal.os.logging.MetricsLoggerWrapper;
import com.android.internal.util.ArrayUtils;
import com.android.server.LocalServices;
import com.android.server.am.ActivityDisplay;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityMetricsLogger;
import com.android.server.am.ActivityRecord;
import com.android.server.am.ActivityStack;
import com.android.server.am.AppTimeTracker;
import com.android.server.am.EventLogTags;
import com.android.server.am.KeyguardController;
import com.android.server.am.LaunchParamsController;
import com.android.server.am.LaunchTimeTracker;
import com.android.server.am.LockTaskController;
import com.android.server.am.PinnedActivityStack;
import com.android.server.am.ProcessRecord;
import com.android.server.am.RecentTasks;
import com.android.server.am.RunningTasks;
import com.android.server.am.SafeActivityOptions;
import com.android.server.am.TaskRecord;
import com.android.server.am.UserState;
import com.android.server.wm.ConfigurationContainer;
import com.android.server.wm.PinnedStackWindowController;
import com.android.server.wm.WindowManagerService;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ActivityStackSupervisor
extends ConfigurationContainer
implements DisplayManager.DisplayListener,
RecentTasks.Callbacks {
    private static final String TAG = "ActivityManager";
    private static final String TAG_FOCUS = "ActivityManager";
    private static final String TAG_IDLE = "ActivityManager";
    private static final String TAG_PAUSE = "ActivityManager";
    private static final String TAG_RECENTS = "ActivityManager";
    private static final String TAG_RELEASE = "ActivityManager";
    private static final String TAG_STACK = "ActivityManager";
    private static final String TAG_STATES = "ActivityManager";
    private static final String TAG_SWITCH = "ActivityManager";
    static final String TAG_TASKS = "ActivityManager";
    static final int IDLE_TIMEOUT = 10000;
    static final int SLEEP_TIMEOUT = 5000;
    static final int LAUNCH_TIMEOUT = 10000;
    static final int IDLE_TIMEOUT_MSG = 100;
    static final int IDLE_NOW_MSG = 101;
    static final int RESUME_TOP_ACTIVITY_MSG = 102;
    static final int SLEEP_TIMEOUT_MSG = 103;
    static final int LAUNCH_TIMEOUT_MSG = 104;
    static final int HANDLE_DISPLAY_ADDED = 105;
    static final int HANDLE_DISPLAY_CHANGED = 106;
    static final int HANDLE_DISPLAY_REMOVED = 107;
    static final int LAUNCH_TASK_BEHIND_COMPLETE = 112;
    static final int REPORT_MULTI_WINDOW_MODE_CHANGED_MSG = 114;
    static final int REPORT_PIP_MODE_CHANGED_MSG = 115;
    private static final String VIRTUAL_DISPLAY_BASE_NAME = "ActivityViewVirtualDisplay";
    static final boolean CREATE_IF_NEEDED = true;
    static final boolean PRESERVE_WINDOWS = true;
    static final boolean ON_TOP = true;
    static final boolean DEFER_RESUME = true;
    static final boolean REMOVE_FROM_RECENTS = true;
    static final boolean PAUSE_IMMEDIATELY = true;
    private boolean mDockedStackResizing;
    private boolean mHasPendingDockedBounds;
    private Rect mPendingDockedBounds;
    private Rect mPendingTempDockedTaskBounds;
    private Rect mPendingTempDockedTaskInsetBounds;
    private Rect mPendingTempOtherTaskBounds;
    private Rect mPendingTempOtherTaskInsetBounds;
    static final int MATCH_TASK_IN_STACKS_ONLY = 0;
    static final int MATCH_TASK_IN_STACKS_OR_RECENT_TASKS = 1;
    static final int MATCH_TASK_IN_STACKS_OR_RECENT_TASKS_AND_RESTORE = 2;
    private static final ArrayMap<String, String> ACTION_TO_RUNTIME_PERMISSION = new ArrayMap();
    private static final int ACTIVITY_RESTRICTION_NONE = 0;
    private static final int ACTIVITY_RESTRICTION_PERMISSION = 1;
    private static final int ACTIVITY_RESTRICTION_APPOP = 2;
    static final boolean VALIDATE_WAKE_LOCK_CALLER = false;
    private static final int MAX_TASK_IDS_PER_USER = 100000;
    final ActivityManagerService mService;
    RecentTasks mRecentTasks;
    private RunningTasks mRunningTasks;
    final ActivityStackSupervisorHandler mHandler;
    final Looper mLooper;
    WindowManagerService mWindowManager;
    DisplayManager mDisplayManager;
    private LaunchParamsController mLaunchParamsController;
    private final SparseIntArray mCurTaskIdForUser = new SparseIntArray(20);
    int mCurrentUser;
    ActivityStack mHomeStack;
    ActivityStack mFocusedStack;
    private ActivityStack mLastFocusedStack;
    final ArrayList<ActivityRecord> mActivitiesWaitingForVisibleActivity = new ArrayList();
    private final ArrayList<WaitInfo> mWaitingForActivityVisible = new ArrayList();
    final ArrayList<WaitResult> mWaitingActivityLaunched = new ArrayList();
    final ArrayList<ActivityRecord> mStoppingActivities = new ArrayList();
    final ArrayList<ActivityRecord> mFinishingActivities = new ArrayList();
    final ArrayList<ActivityRecord> mGoingToSleepActivities = new ArrayList();
    final ArrayList<ActivityRecord> mMultiWindowModeChangedActivities = new ArrayList();
    final ArrayList<ActivityRecord> mPipModeChangedActivities = new ArrayList();
    final ArrayList<ActivityRecord> mNoAnimActivities = new ArrayList();
    Rect mPipModeChangedTargetStackBounds;
    final ArrayList<UserState> mStartingUsers = new ArrayList();
    boolean mUserLeaving = false;
    private boolean mPowerHintSent;
    PowerManager.WakeLock mLaunchingActivity;
    PowerManager.WakeLock mGoingToSleep;
    final ArrayList<ActivityManagerInternal.SleepToken> mSleepTokens = new ArrayList();
    SparseIntArray mUserStackInFront = new SparseIntArray(2);
    private final SparseArray<ActivityDisplay> mActivityDisplays = new SparseArray();
    private final SparseArray<IntArray> mDisplayAccessUIDs = new SparseArray();
    private DisplayManagerInternal mDisplayManagerInternal;
    boolean inResumeTopActivity;
    private final Rect tempRect = new Rect();
    private final ActivityOptions mTmpOptions = ActivityOptions.makeBasic();
    int mDefaultMinSizeOfResizeableTask = -1;
    private boolean mTaskLayersChanged = true;
    private ActivityMetricsLogger mActivityMetricsLogger;
    private LaunchTimeTracker mLaunchTimeTracker = new LaunchTimeTracker();
    private final ArrayList<ActivityRecord> mTmpActivityList = new ArrayList();
    private final FindTaskResult mTmpFindTaskResult = new FindTaskResult();
    private SparseIntArray mTmpOrderedDisplayIds = new SparseIntArray();
    boolean mAppVisibilitiesChangedSinceLastPause;
    private final ArraySet<Integer> mResizingTasksDuringAnimation = new ArraySet();
    private boolean mAllowDockedStackResize = true;
    boolean mIsDockMinimized;
    private KeyguardController mKeyguardController;
    private PowerManager mPowerManager;
    private int mDeferResumeCount;
    private boolean mInitialized;

    @Override
    protected int getChildCount() {
        return this.mActivityDisplays.size();
    }

    protected ActivityDisplay getChildAt(int index) {
        return this.mActivityDisplays.valueAt(index);
    }

    @Override
    protected ConfigurationContainer getParent() {
        return null;
    }

    Configuration getDisplayOverrideConfiguration(int displayId) {
        ActivityDisplay activityDisplay = this.getActivityDisplayOrCreateLocked(displayId);
        if (activityDisplay == null) {
            throw new IllegalArgumentException("No display found with id: " + displayId);
        }
        return activityDisplay.getOverrideConfiguration();
    }

    void setDisplayOverrideConfiguration(Configuration overrideConfiguration, int displayId) {
        ActivityDisplay activityDisplay = this.getActivityDisplayOrCreateLocked(displayId);
        if (activityDisplay == null) {
            throw new IllegalArgumentException("No display found with id: " + displayId);
        }
        activityDisplay.onOverrideConfigurationChanged(overrideConfiguration);
    }

    boolean canPlaceEntityOnDisplay(int displayId, boolean resizeable, int callingPid, int callingUid, ActivityInfo activityInfo) {
        if (displayId == 0) {
            return true;
        }
        if (!this.mService.mSupportsMultiDisplay) {
            return false;
        }
        if (!resizeable && !this.displayConfigMatchesGlobal(displayId)) {
            return false;
        }
        return this.isCallerAllowedToLaunchOnDisplay(callingPid, callingUid, displayId, activityInfo);
    }

    private boolean displayConfigMatchesGlobal(int displayId) {
        if (displayId == 0) {
            return true;
        }
        if (displayId == -1) {
            return false;
        }
        ActivityDisplay targetDisplay = this.getActivityDisplayOrCreateLocked(displayId);
        if (targetDisplay == null) {
            throw new IllegalArgumentException("No display found with id: " + displayId);
        }
        return this.getConfiguration().equals(targetDisplay.getConfiguration());
    }

    public ActivityStackSupervisor(ActivityManagerService service, Looper looper) {
        this.mService = service;
        this.mLooper = looper;
        this.mHandler = new ActivityStackSupervisorHandler(looper);
    }

    public void initialize() {
        if (this.mInitialized) {
            return;
        }
        this.mInitialized = true;
        this.mRunningTasks = this.createRunningTasks();
        this.mActivityMetricsLogger = new ActivityMetricsLogger(this, this.mService.mContext, this.mHandler.getLooper());
        this.mKeyguardController = new KeyguardController(this.mService, this);
        this.mLaunchParamsController = new LaunchParamsController(this.mService);
        this.mLaunchParamsController.registerDefaultModifiers(this);
    }

    public ActivityMetricsLogger getActivityMetricsLogger() {
        return this.mActivityMetricsLogger;
    }

    LaunchTimeTracker getLaunchTimeTracker() {
        return this.mLaunchTimeTracker;
    }

    public KeyguardController getKeyguardController() {
        return this.mKeyguardController;
    }

    void setRecentTasks(RecentTasks recentTasks) {
        this.mRecentTasks = recentTasks;
        this.mRecentTasks.registerCallback(this);
    }

    @VisibleForTesting
    RunningTasks createRunningTasks() {
        return new RunningTasks();
    }

    void initPowerManagement() {
        this.mPowerManager = (PowerManager)this.mService.mContext.getSystemService("power");
        this.mGoingToSleep = this.mPowerManager.newWakeLock(1, "ActivityManager-Sleep");
        this.mLaunchingActivity = this.mPowerManager.newWakeLock(1, "*launch*");
        this.mLaunchingActivity.setReferenceCounted(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWindowManager(WindowManagerService wm) {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.mWindowManager = wm;
                this.getKeyguardController().setWindowManager(wm);
                this.mDisplayManager = (DisplayManager)this.mService.mContext.getSystemService("display");
                this.mDisplayManager.registerDisplayListener(this, null);
                this.mDisplayManagerInternal = LocalServices.getService(DisplayManagerInternal.class);
                Display[] displays = this.mDisplayManager.getDisplays();
                for (int displayNdx = displays.length - 1; displayNdx >= 0; --displayNdx) {
                    Display display = displays[displayNdx];
                    ActivityDisplay activityDisplay = new ActivityDisplay(this, display);
                    this.mActivityDisplays.put(display.getDisplayId(), activityDisplay);
                    this.calculateDefaultMinimalSizeOfResizeableTasks(activityDisplay);
                }
                this.mFocusedStack = this.mLastFocusedStack = this.getDefaultDisplay().getOrCreateStack(1, 2, true);
                this.mHomeStack = this.mLastFocusedStack;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl22 : MonitorExitStatement: MONITOREXIT : var2_2
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    ActivityStack getFocusedStack() {
        return this.mFocusedStack;
    }

    boolean isFocusable(ConfigurationContainer container, boolean alwaysFocusable) {
        if (container.inSplitScreenPrimaryWindowingMode() && this.mIsDockMinimized) {
            return false;
        }
        return container.getWindowConfiguration().canReceiveKeys() || alwaysFocusable;
    }

    ActivityStack getLastStack() {
        return this.mLastFocusedStack;
    }

    boolean isFocusedStack(ActivityStack stack) {
        return stack != null && stack == this.mFocusedStack;
    }

    void setFocusStackUnchecked(String reason, ActivityStack focusCandidate) {
        if (!focusCandidate.isFocusable()) {
            focusCandidate = this.getNextFocusableStackLocked(focusCandidate, false);
        }
        if (focusCandidate != this.mFocusedStack) {
            this.mLastFocusedStack = this.mFocusedStack;
            this.mFocusedStack = focusCandidate;
            EventLogTags.writeAmFocusedStack(this.mCurrentUser, this.mFocusedStack == null ? -1 : this.mFocusedStack.getStackId(), this.mLastFocusedStack == null ? -1 : this.mLastFocusedStack.getStackId(), reason);
        }
        ActivityRecord r = this.topRunningActivityLocked();
        if ((this.mService.mBooting || !this.mService.mBooted) && r != null && r.idle) {
            this.checkFinishBootingLocked();
        }
    }

    void moveHomeStackToFront(String reason) {
        this.mHomeStack.moveToFront(reason);
    }

    void moveRecentsStackToFront(String reason) {
        Object recentsStack = this.getDefaultDisplay().getStack(0, 3);
        if (recentsStack != null) {
            ((ActivityStack)recentsStack).moveToFront(reason);
        }
    }

    boolean moveHomeStackTaskToTop(String reason) {
        this.mHomeStack.moveHomeStackTaskToTop();
        ActivityRecord top = this.getHomeActivity();
        if (top == null) {
            return false;
        }
        this.moveFocusableActivityStackToFrontLocked(top, reason);
        return true;
    }

    boolean resumeHomeStackTask(ActivityRecord prev, String reason) {
        if (!this.mService.mBooting && !this.mService.mBooted) {
            return false;
        }
        this.mHomeStack.moveHomeStackTaskToTop();
        ActivityRecord r = this.getHomeActivity();
        String myReason = reason + " resumeHomeStackTask";
        if (r != null && !r.finishing) {
            this.moveFocusableActivityStackToFrontLocked(r, myReason);
            return this.resumeFocusedStackTopActivityLocked(this.mHomeStack, prev, null);
        }
        return this.mService.startHomeActivityLocked(this.mCurrentUser, myReason);
    }

    TaskRecord anyTaskForIdLocked(int id2) {
        return this.anyTaskForIdLocked(id2, 2);
    }

    TaskRecord anyTaskForIdLocked(int id2, int matchMode) {
        return this.anyTaskForIdLocked(id2, matchMode, null, false);
    }

    TaskRecord anyTaskForIdLocked(int id2, int matchMode, ActivityOptions aOptions, boolean onTop) {
        if (matchMode != 2 && aOptions != null) {
            throw new IllegalArgumentException("Should not specify activity options for non-restore lookup");
        }
        int numDisplays = this.mActivityDisplays.size();
        for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.valueAt(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                Object launchStack;
                ActivityStack stack = display.getChildAt(stackNdx);
                TaskRecord task = stack.taskForIdLocked(id2);
                if (task == null) continue;
                if (aOptions != null && (launchStack = this.getLaunchStack(null, aOptions, task, onTop)) != null && stack != launchStack) {
                    int reparentMode = onTop ? 0 : 2;
                    task.reparent((ActivityStack)launchStack, onTop, reparentMode, true, true, "anyTaskForIdLocked");
                }
                return task;
            }
        }
        if (matchMode == 0) {
            return null;
        }
        TaskRecord task = this.mRecentTasks.getTask(id2);
        if (task == null) {
            return null;
        }
        if (matchMode == 1) {
            return task;
        }
        if (!this.restoreRecentTaskLocked(task, aOptions, onTop)) {
            return null;
        }
        return task;
    }

    ActivityRecord isInAnyStackLocked(IBinder token) {
        int numDisplays = this.mActivityDisplays.size();
        for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.valueAt(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                ActivityRecord r = stack.isInStackLocked(token);
                if (r == null) continue;
                return r;
            }
        }
        return null;
    }

    private boolean taskTopActivityIsUser(TaskRecord task, int userId) {
        ActivityRecord activityRecord = task.getTopActivity();
        ActivityRecord resultTo = activityRecord != null ? activityRecord.resultTo : null;
        return activityRecord != null && activityRecord.userId == userId || resultTo != null && resultTo.userId == userId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lockAllProfileTasks(int userId) {
        this.mWindowManager.deferSurfaceLayout();
        try {
            for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
                ActivityDisplay display = this.mActivityDisplays.valueAt(displayNdx);
                for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                    ActivityStack stack = display.getChildAt(stackNdx);
                    ArrayList<TaskRecord> tasks = stack.getAllTasks();
                    for (int taskNdx = tasks.size() - 1; taskNdx >= 0; --taskNdx) {
                        TaskRecord task = (TaskRecord)tasks.get(taskNdx);
                        if (!this.taskTopActivityIsUser(task, userId)) continue;
                        this.mService.mTaskChangeNotificationController.notifyTaskProfileLocked(task.taskId, userId);
                    }
                }
            }
        }
        finally {
            this.mWindowManager.continueSurfaceLayout();
        }
    }

    void setNextTaskIdForUserLocked(int taskId, int userId) {
        int currentTaskId = this.mCurTaskIdForUser.get(userId, -1);
        if (taskId > currentTaskId) {
            this.mCurTaskIdForUser.put(userId, taskId);
        }
    }

    static int nextTaskIdForUser(int taskId, int userId) {
        int nextTaskId = taskId + 1;
        if (nextTaskId == (userId + 1) * 100000) {
            nextTaskId -= 100000;
        }
        return nextTaskId;
    }

    int getNextTaskIdForUserLocked(int userId) {
        int currentTaskId = this.mCurTaskIdForUser.get(userId, userId * 100000);
        int candidateTaskId = ActivityStackSupervisor.nextTaskIdForUser(currentTaskId, userId);
        while (this.mRecentTasks.containsTaskId(candidateTaskId, userId) || this.anyTaskForIdLocked(candidateTaskId, 1) != null) {
            if ((candidateTaskId = ActivityStackSupervisor.nextTaskIdForUser(candidateTaskId, userId)) != currentTaskId) continue;
            throw new IllegalStateException("Cannot get an available task id. Reached limit of 100000 running tasks per user.");
        }
        this.mCurTaskIdForUser.put(userId, candidateTaskId);
        return candidateTaskId;
    }

    ActivityRecord getResumedActivityLocked() {
        ActivityStack stack = this.mFocusedStack;
        if (stack == null) {
            return null;
        }
        ActivityRecord resumedActivity = stack.getResumedActivity();
        if (!(resumedActivity != null && resumedActivity.app != null || (resumedActivity = stack.mPausingActivity) != null && resumedActivity.app != null)) {
            resumedActivity = stack.topRunningActivityLocked();
        }
        return resumedActivity;
    }

    boolean attachApplicationLocked(ProcessRecord app) throws RemoteException {
        String processName = app.processName;
        boolean didSomething = false;
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.valueAt(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                if (!this.isFocusedStack(stack)) continue;
                stack.getAllRunningVisibleActivitiesLocked(this.mTmpActivityList);
                ActivityRecord top = stack.topRunningActivityLocked();
                int size = this.mTmpActivityList.size();
                for (int i = 0; i < size; ++i) {
                    ActivityRecord activity = this.mTmpActivityList.get(i);
                    if (activity.app != null || app.uid != activity.info.applicationInfo.uid || !processName.equals(activity.processName)) continue;
                    try {
                        if (!this.realStartActivityLocked(activity, app, top == activity, true)) continue;
                        didSomething = true;
                        continue;
                    }
                    catch (RemoteException e) {
                        Slog.w("ActivityManager", "Exception in new application when starting activity " + top.intent.getComponent().flattenToShortString(), e);
                        throw e;
                    }
                }
            }
        }
        if (!didSomething) {
            this.ensureActivitiesVisibleLocked(null, 0, false);
        }
        return didSomething;
    }

    boolean allResumedActivitiesIdle() {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.valueAt(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityRecord resumedActivity;
                ActivityStack stack = display.getChildAt(stackNdx);
                if (!this.isFocusedStack(stack) || stack.numActivities() == 0 || (resumedActivity = stack.getResumedActivity()) != null && resumedActivity.idle) continue;
                return false;
            }
        }
        this.sendPowerHintForLaunchEndIfNeeded();
        return true;
    }

    boolean allResumedActivitiesComplete() {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.valueAt(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityRecord r;
                ActivityStack stack = display.getChildAt(stackNdx);
                if (!this.isFocusedStack(stack) || (r = stack.getResumedActivity()) == null || r.isState(ActivityStack.ActivityState.RESUMED)) continue;
                return false;
            }
        }
        this.mLastFocusedStack = this.mFocusedStack;
        return true;
    }

    private boolean allResumedActivitiesVisible() {
        boolean foundResumed = false;
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.valueAt(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                ActivityRecord r = stack.getResumedActivity();
                if (r == null) continue;
                if (!r.nowVisible || this.mActivitiesWaitingForVisibleActivity.contains(r)) {
                    return false;
                }
                foundResumed = true;
            }
        }
        return foundResumed;
    }

    boolean pauseBackStacks(boolean userLeaving, ActivityRecord resuming, boolean dontWait) {
        boolean someActivityPaused = false;
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.valueAt(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                if (this.isFocusedStack(stack) || stack.getResumedActivity() == null) continue;
                someActivityPaused |= stack.startPausingLocked(userLeaving, false, resuming, dontWait);
            }
        }
        return someActivityPaused;
    }

    boolean allPausedActivitiesComplete() {
        boolean pausing = true;
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.valueAt(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                ActivityRecord r = stack.mPausingActivity;
                if (r == null || r.isState(ActivityStack.ActivityState.PAUSED, ActivityStack.ActivityState.STOPPED, ActivityStack.ActivityState.STOPPING)) continue;
                return false;
            }
        }
        return pausing;
    }

    void cancelInitializingActivities() {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.valueAt(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                stack.cancelInitializingActivities();
            }
        }
    }

    void waitActivityVisible(ComponentName name, WaitResult result) {
        WaitInfo waitInfo = new WaitInfo(name, result);
        this.mWaitingForActivityVisible.add(waitInfo);
    }

    void cleanupActivity(ActivityRecord r) {
        this.mFinishingActivities.remove(r);
        this.mActivitiesWaitingForVisibleActivity.remove(r);
        for (int i = this.mWaitingForActivityVisible.size() - 1; i >= 0; --i) {
            if (!this.mWaitingForActivityVisible.get(i).matches(r.realActivity)) continue;
            this.mWaitingForActivityVisible.remove(i);
        }
    }

    void reportActivityVisibleLocked(ActivityRecord r) {
        this.sendWaitingVisibleReportLocked(r);
    }

    void sendWaitingVisibleReportLocked(ActivityRecord r) {
        boolean changed = false;
        for (int i = this.mWaitingForActivityVisible.size() - 1; i >= 0; --i) {
            WaitInfo w = this.mWaitingForActivityVisible.get(i);
            if (!w.matches(r.realActivity)) continue;
            WaitResult result = w.getResult();
            changed = true;
            result.timeout = false;
            result.who = w.getComponent();
            result.thisTime = result.totalTime = SystemClock.uptimeMillis() - result.thisTime;
            this.mWaitingForActivityVisible.remove(w);
        }
        if (changed) {
            this.mService.notifyAll();
        }
    }

    void reportWaitingActivityLaunchedIfNeeded(ActivityRecord r, int result) {
        if (this.mWaitingActivityLaunched.isEmpty()) {
            return;
        }
        if (result != 3 && result != 2) {
            return;
        }
        boolean changed = false;
        for (int i = this.mWaitingActivityLaunched.size() - 1; i >= 0; --i) {
            WaitResult w = this.mWaitingActivityLaunched.remove(i);
            if (w.who != null) continue;
            changed = true;
            w.result = result;
            if (result != 3) continue;
            w.who = r.realActivity;
        }
        if (changed) {
            this.mService.notifyAll();
        }
    }

    void reportActivityLaunchedLocked(boolean timeout, ActivityRecord r, long thisTime, long totalTime) {
        boolean changed = false;
        for (int i = this.mWaitingActivityLaunched.size() - 1; i >= 0; --i) {
            WaitResult w = this.mWaitingActivityLaunched.remove(i);
            if (w.who != null) continue;
            changed = true;
            w.timeout = timeout;
            if (r != null) {
                w.who = new ComponentName(r.info.packageName, r.info.name);
            }
            w.thisTime = thisTime;
            w.totalTime = totalTime;
        }
        if (changed) {
            this.mService.notifyAll();
        }
    }

    ActivityRecord topRunningActivityLocked() {
        return this.topRunningActivityLocked(false);
    }

    ActivityRecord topRunningActivityLocked(boolean considerKeyguardState) {
        ActivityStack focusedStack = this.mFocusedStack;
        ActivityRecord r = focusedStack.topRunningActivityLocked();
        if (r != null && this.isValidTopRunningActivity(r, considerKeyguardState)) {
            return r;
        }
        this.mWindowManager.getDisplaysInFocusOrder(this.mTmpOrderedDisplayIds);
        for (int i = this.mTmpOrderedDisplayIds.size() - 1; i >= 0; --i) {
            ActivityRecord topActivity;
            ActivityStack topStack;
            int displayId = this.mTmpOrderedDisplayIds.get(i);
            ActivityDisplay display = this.mActivityDisplays.get(displayId);
            if (display == null || (topStack = display.getTopStack()) == null || !topStack.isFocusable() || topStack == focusedStack || (topActivity = topStack.topRunningActivityLocked()) == null || !this.isValidTopRunningActivity(topActivity, considerKeyguardState)) continue;
            return topActivity;
        }
        return null;
    }

    private boolean isValidTopRunningActivity(ActivityRecord record, boolean considerKeyguardState) {
        if (!considerKeyguardState) {
            return true;
        }
        boolean keyguardLocked = this.getKeyguardController().isKeyguardLocked();
        if (!keyguardLocked) {
            return true;
        }
        return record.canShowWhenLocked();
    }

    @VisibleForTesting
    void getRunningTasks(int maxNum, List<ActivityManager.RunningTaskInfo> list, @WindowConfiguration.ActivityType int ignoreActivityType, @WindowConfiguration.WindowingMode int ignoreWindowingMode, int callingUid, boolean allowed) {
        this.mRunningTasks.getTasks(maxNum, list, ignoreActivityType, ignoreWindowingMode, this.mActivityDisplays, callingUid, allowed);
    }

    ActivityInfo resolveActivity(Intent intent, ResolveInfo rInfo, int startFlags, ProfilerInfo profilerInfo) {
        ActivityInfo aInfo;
        ActivityInfo activityInfo = aInfo = rInfo != null ? rInfo.activityInfo : null;
        if (aInfo != null) {
            intent.setComponent(new ComponentName(aInfo.applicationInfo.packageName, aInfo.name));
            if (!aInfo.processName.equals("system")) {
                if ((startFlags & 2) != 0) {
                    this.mService.setDebugApp(aInfo.processName, true, false);
                }
                if ((startFlags & 8) != 0) {
                    this.mService.setNativeDebuggingAppLocked(aInfo.applicationInfo, aInfo.processName);
                }
                if ((startFlags & 4) != 0) {
                    this.mService.setTrackAllocationApp(aInfo.applicationInfo, aInfo.processName);
                }
                if (profilerInfo != null) {
                    this.mService.setProfileApp(aInfo.applicationInfo, aInfo.processName, profilerInfo);
                }
            }
            String intentLaunchToken = intent.getLaunchToken();
            if (aInfo.launchToken == null && intentLaunchToken != null) {
                aInfo.launchToken = intentLaunchToken;
            }
        }
        return aInfo;
    }

    /*
     * Exception decompiling
     */
    ResolveInfo resolveIntent(Intent intent, String resolvedType, int userId, int flags, int filterCallingUid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    ActivityInfo resolveActivity(Intent intent, String resolvedType, int startFlags, ProfilerInfo profilerInfo, int userId, int filterCallingUid) {
        ResolveInfo rInfo = this.resolveIntent(intent, resolvedType, userId, 0, filterCallingUid);
        return this.resolveActivity(intent, rInfo, startFlags, profilerInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean realStartActivityLocked(ActivityRecord r, ProcessRecord app, boolean andResume, boolean checkConfig) throws RemoteException {
        if (!this.allPausedActivitiesComplete()) {
            return false;
        }
        TaskRecord task = r.getTask();
        Object stack = task.getStack();
        this.beginDeferResume();
        try {
            int applicationInfoUid;
            r.startFreezingScreenLocked(app, 0);
            r.startLaunchTickingLocked();
            r.setProcess(app);
            if (this.getKeyguardController().isKeyguardLocked()) {
                r.notifyUnknownVisibilityLaunched();
            }
            if (checkConfig) {
                this.ensureVisibilityAndConfig(r, r.getDisplayId(), false, true);
            }
            if (((ActivityStack)r.getStack()).checkKeyguardVisibility(r, true, true)) {
                r.setVisibility(true);
            }
            int n = applicationInfoUid = r.info.applicationInfo != null ? r.info.applicationInfo.uid : -1;
            if (r.userId != app.userId || r.appInfo.uid != applicationInfoUid) {
                Slog.wtf("ActivityManager", "User ID for activity changing for " + r + " appInfo.uid=" + r.appInfo.uid + " info.ai.uid=" + applicationInfoUid + " old=" + r.app + " new=" + app);
            }
            app.waitingToKill = null;
            ++r.launchCount;
            r.lastLaunchTime = SystemClock.uptimeMillis();
            int idx = app.activities.indexOf(r);
            if (idx < 0) {
                app.activities.add(r);
            }
            this.mService.updateLruProcessLocked(app, true, null);
            this.mService.updateOomAdjLocked();
            LockTaskController lockTaskController = this.mService.getLockTaskController();
            if (task.mLockTaskAuth == 2 || task.mLockTaskAuth == 4 || task.mLockTaskAuth == 3 && lockTaskController.getLockTaskModeState() == 1) {
                lockTaskController.startLockTaskMode(task, false, 0);
            }
            try {
                if (app.thread == null) {
                    throw new RemoteException();
                }
                ArrayList<ResultInfo> results = null;
                ArrayList<ReferrerIntent> newIntents = null;
                if (andResume) {
                    results = r.results;
                    newIntents = r.newIntents;
                }
                EventLog.writeEvent(30006, r.userId, System.identityHashCode(r), task.taskId, r.shortComponentName);
                if (r.isActivityTypeHome()) {
                    this.mService.mHomeProcess = task.mActivities.get((int)0).app;
                }
                this.mService.notifyPackageUse(r.intent.getComponent().getPackageName(), 0);
                r.sleeping = false;
                r.forceNewConfig = false;
                this.mService.getAppWarningsLocked().onStartActivity(r);
                this.mService.showAskCompatModeDialogLocked(r);
                r.compat = this.mService.compatibilityInfoForPackageLocked(r.info.applicationInfo);
                ProfilerInfo profilerInfo = null;
                if (this.mService.mProfileApp != null && this.mService.mProfileApp.equals(app.processName) && (this.mService.mProfileProc == null || this.mService.mProfileProc == app)) {
                    this.mService.mProfileProc = app;
                    ProfilerInfo profilerInfoSvc = this.mService.mProfilerInfo;
                    if (profilerInfoSvc != null && profilerInfoSvc.profileFile != null) {
                        if (profilerInfoSvc.profileFd != null) {
                            try {
                                profilerInfoSvc.profileFd = profilerInfoSvc.profileFd.dup();
                            }
                            catch (IOException e) {
                                profilerInfoSvc.closeFd();
                            }
                        }
                        profilerInfo = new ProfilerInfo(profilerInfoSvc);
                    }
                }
                app.hasShownUi = true;
                app.pendingUiClean = true;
                app.forceProcessStateUpTo(this.mService.mTopProcessState);
                MergedConfiguration mergedConfiguration = new MergedConfiguration(this.mService.getGlobalConfiguration(), r.getMergedOverrideConfiguration());
                r.setLastReportedConfiguration(mergedConfiguration);
                this.logIfTransactionTooLarge(r.intent, r.icicle);
                ClientTransaction clientTransaction = ClientTransaction.obtain(app.thread, r.appToken);
                clientTransaction.addCallback(LaunchActivityItem.obtain(new Intent(r.intent), System.identityHashCode(r), r.info, mergedConfiguration.getGlobalConfiguration(), mergedConfiguration.getOverrideConfiguration(), r.compat, r.launchedFromPackage, task.voiceInteractor, app.repProcState, r.icicle, r.persistentState, results, newIntents, this.mService.isNextTransitionForward(), profilerInfo));
                ActivityLifecycleItem lifecycleItem = andResume ? ResumeActivityItem.obtain(this.mService.isNextTransitionForward()) : PauseActivityItem.obtain();
                clientTransaction.setLifecycleStateRequest(lifecycleItem);
                this.mService.getLifecycleManager().scheduleTransaction(clientTransaction);
                if ((app.info.privateFlags & 2) != 0 && this.mService.mHasHeavyWeightFeature && app.processName.equals(app.info.packageName)) {
                    if (this.mService.mHeavyWeightProcess != null && this.mService.mHeavyWeightProcess != app) {
                        Slog.w("ActivityManager", "Starting new heavy weight process " + app + " when already running " + this.mService.mHeavyWeightProcess);
                    }
                    this.mService.mHeavyWeightProcess = app;
                    Message msg = this.mService.mHandler.obtainMessage(24);
                    msg.obj = r;
                    this.mService.mHandler.sendMessage(msg);
                }
            }
            catch (RemoteException e) {
                if (r.launchFailed) {
                    Slog.e("ActivityManager", "Second failure launching " + r.intent.getComponent().flattenToShortString() + ", giving up", e);
                    this.mService.appDiedLocked(app);
                    ((ActivityStack)stack).requestFinishActivityLocked(r.appToken, 0, null, "2nd-crash", false);
                    boolean bl = false;
                    this.endDeferResume();
                    return bl;
                }
                r.launchFailed = true;
                app.activities.remove(r);
                throw e;
            }
        }
        finally {
            this.endDeferResume();
        }
        r.launchFailed = false;
        if (((ActivityStack)stack).updateLRUListLocked(r)) {
            Slog.w("ActivityManager", "Activity " + r + " being launched, but already in LRU list");
        }
        if (andResume && this.readyToResume()) {
            ((ActivityStack)stack).minimalResumeActivityLocked(r);
        } else {
            r.setState(ActivityStack.ActivityState.PAUSED, "realStartActivityLocked");
        }
        if (this.isFocusedStack((ActivityStack)stack)) {
            this.mService.getActivityStartController().startSetupActivity();
        }
        if (r.app != null) {
            this.mService.mServices.updateServiceConnectionActivitiesLocked(r.app);
        }
        return true;
    }

    boolean ensureVisibilityAndConfig(ActivityRecord starting, int displayId, boolean markFrozenIfConfigChanged, boolean deferResume) {
        this.ensureActivitiesVisibleLocked(null, 0, false, false);
        if (displayId == -1) {
            return true;
        }
        Configuration config = this.mWindowManager.updateOrientationFromAppTokens(this.getDisplayOverrideConfiguration(displayId), starting != null && starting.mayFreezeScreenLocked(starting.app) ? starting.appToken : null, displayId, true);
        if (starting != null && markFrozenIfConfigChanged && config != null) {
            starting.frozenBeforeDestroy = true;
        }
        return this.mService.updateDisplayOverrideConfigurationLocked(config, starting, deferResume, displayId);
    }

    private void logIfTransactionTooLarge(Intent intent, Bundle icicle) {
        int icicleSize;
        Bundle extras;
        int extrasSize = 0;
        if (intent != null && (extras = intent.getExtras()) != null) {
            extrasSize = extras.getSize();
        }
        int n = icicleSize = icicle == null ? 0 : icicle.getSize();
        if (extrasSize + icicleSize > 200000) {
            Slog.e("ActivityManager", "Transaction too large, intent: " + intent + ", extras size: " + extrasSize + ", icicle size: " + icicleSize);
        }
    }

    void startSpecificActivityLocked(ActivityRecord r, boolean andResume, boolean checkConfig) {
        ProcessRecord app = this.mService.getProcessRecordLocked(r.processName, r.info.applicationInfo.uid, true);
        this.getLaunchTimeTracker().setLaunchTime(r);
        if (app != null && app.thread != null) {
            try {
                if ((r.info.flags & 1) == 0 || !"android".equals(r.info.packageName)) {
                    app.addPackage(r.info.packageName, r.info.applicationInfo.longVersionCode, this.mService.mProcessStats);
                }
                this.realStartActivityLocked(r, app, andResume, checkConfig);
                return;
            }
            catch (RemoteException e) {
                Slog.w("ActivityManager", "Exception when starting activity " + r.intent.getComponent().flattenToShortString(), e);
            }
        }
        this.mService.startProcessLocked(r.processName, r.info.applicationInfo, true, 0, "activity", r.intent.getComponent(), false, false, true);
    }

    void sendPowerHintForLaunchStartIfNeeded(boolean forceSend, ActivityRecord targetActivity) {
        boolean sendHint = forceSend;
        if (!sendHint) {
            ActivityRecord resumedActivity = this.getResumedActivityLocked();
            boolean bl = sendHint = resumedActivity == null || resumedActivity.app == null || !resumedActivity.app.equals(targetActivity.app);
        }
        if (sendHint && this.mService.mLocalPowerManager != null) {
            this.mService.mLocalPowerManager.powerHint(8, 1);
            this.mPowerHintSent = true;
        }
    }

    void sendPowerHintForLaunchEndIfNeeded() {
        if (this.mPowerHintSent && this.mService.mLocalPowerManager != null) {
            this.mService.mLocalPowerManager.powerHint(8, 0);
            this.mPowerHintSent = false;
        }
    }

    boolean checkStartAnyActivityPermission(Intent intent, ActivityInfo aInfo, String resultWho, int requestCode, int callingPid, int callingUid, String callingPackage, boolean ignoreTargetSecurity, boolean launchingInTask, ProcessRecord callerApp, ActivityRecord resultRecord, ActivityStack resultStack) {
        boolean isCallerRecents = this.mService.getRecentTasks() != null && this.mService.getRecentTasks().isCallerRecents(callingUid);
        int startAnyPerm = this.mService.checkPermission("android.permission.START_ANY_ACTIVITY", callingPid, callingUid);
        if (startAnyPerm == 0 || isCallerRecents && launchingInTask) {
            return true;
        }
        int componentRestriction = this.getComponentRestrictionForCallingPackage(aInfo, callingPackage, callingPid, callingUid, ignoreTargetSecurity);
        int actionRestriction = this.getActionRestrictionForCallingPackage(intent.getAction(), callingPackage, callingPid, callingUid);
        if (componentRestriction == 1 || actionRestriction == 1) {
            if (resultRecord != null) {
                resultStack.sendActivityResultLocked(-1, resultRecord, resultWho, requestCode, 0, null);
            }
            String msg = actionRestriction == 1 ? "Permission Denial: starting " + intent.toString() + " from " + callerApp + " (pid=" + callingPid + ", uid=" + callingUid + ") with revoked permission " + ACTION_TO_RUNTIME_PERMISSION.get(intent.getAction()) : (!aInfo.exported ? "Permission Denial: starting " + intent.toString() + " from " + callerApp + " (pid=" + callingPid + ", uid=" + callingUid + ") not exported from uid " + aInfo.applicationInfo.uid : "Permission Denial: starting " + intent.toString() + " from " + callerApp + " (pid=" + callingPid + ", uid=" + callingUid + ") requires " + aInfo.permission);
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        if (actionRestriction == 2) {
            String message = "Appop Denial: starting " + intent.toString() + " from " + callerApp + " (pid=" + callingPid + ", uid=" + callingUid + ") requires " + AppOpsManager.permissionToOp(ACTION_TO_RUNTIME_PERMISSION.get(intent.getAction()));
            Slog.w("ActivityManager", message);
            return false;
        }
        if (componentRestriction == 2) {
            String message = "Appop Denial: starting " + intent.toString() + " from " + callerApp + " (pid=" + callingPid + ", uid=" + callingUid + ") requires appop " + AppOpsManager.permissionToOp(aInfo.permission);
            Slog.w("ActivityManager", message);
            return false;
        }
        return true;
    }

    boolean isCallerAllowedToLaunchOnDisplay(int callingPid, int callingUid, int launchDisplayId, ActivityInfo aInfo) {
        if (callingPid == -1 && callingUid == -1) {
            return true;
        }
        ActivityDisplay activityDisplay = this.getActivityDisplayOrCreateLocked(launchDisplayId);
        if (activityDisplay == null) {
            Slog.w("ActivityManager", "Launch on display check: display not found");
            return false;
        }
        int startAnyPerm = this.mService.checkPermission("android.permission.INTERNAL_SYSTEM_WINDOW", callingPid, callingUid);
        if (startAnyPerm == 0) {
            return true;
        }
        boolean uidPresentOnDisplay = activityDisplay.isUidPresent(callingUid);
        int displayOwnerUid = activityDisplay.mDisplay.getOwnerUid();
        if (activityDisplay.mDisplay.getType() == 5 && displayOwnerUid != 1000 && displayOwnerUid != aInfo.applicationInfo.uid) {
            if ((aInfo.flags & Integer.MIN_VALUE) == 0) {
                return false;
            }
            if (this.mService.checkPermission("android.permission.ACTIVITY_EMBEDDING", callingPid, callingUid) == -1 && !uidPresentOnDisplay) {
                return false;
            }
        }
        if (!activityDisplay.isPrivate()) {
            return true;
        }
        if (displayOwnerUid == callingUid) {
            return true;
        }
        if (uidPresentOnDisplay) {
            return true;
        }
        Slog.w("ActivityManager", "Launch on display check: denied");
        return false;
    }

    void updateUIDsPresentOnDisplay() {
        this.mDisplayAccessUIDs.clear();
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay activityDisplay = this.mActivityDisplays.valueAt(displayNdx);
            if (!activityDisplay.isPrivate()) continue;
            this.mDisplayAccessUIDs.append(activityDisplay.mDisplayId, activityDisplay.getPresentUIDs());
        }
        this.mDisplayManagerInternal.setDisplayAccessUIDs(this.mDisplayAccessUIDs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UserInfo getUserInfo(int userId) {
        long identity = Binder.clearCallingIdentity();
        try {
            UserInfo userInfo = UserManager.get(this.mService.mContext).getUserInfo(userId);
            return userInfo;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private int getComponentRestrictionForCallingPackage(ActivityInfo activityInfo, String callingPackage, int callingPid, int callingUid, boolean ignoreTargetSecurity) {
        if (!ignoreTargetSecurity && this.mService.checkComponentPermission(activityInfo.permission, callingPid, callingUid, activityInfo.applicationInfo.uid, activityInfo.exported) == -1) {
            return 1;
        }
        if (activityInfo.permission == null) {
            return 0;
        }
        int opCode = AppOpsManager.permissionToOpCode(activityInfo.permission);
        if (opCode == -1) {
            return 0;
        }
        if (this.mService.mAppOpsService.noteOperation(opCode, callingUid, callingPackage) != 0 && !ignoreTargetSecurity) {
            return 2;
        }
        return 0;
    }

    private int getActionRestrictionForCallingPackage(String action, String callingPackage, int callingPid, int callingUid) {
        PackageInfo packageInfo;
        if (action == null) {
            return 0;
        }
        String permission2 = ACTION_TO_RUNTIME_PERMISSION.get(action);
        if (permission2 == null) {
            return 0;
        }
        try {
            packageInfo = this.mService.mContext.getPackageManager().getPackageInfo(callingPackage, 4096);
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.i("ActivityManager", "Cannot find package info for " + callingPackage);
            return 0;
        }
        if (!ArrayUtils.contains(packageInfo.requestedPermissions, permission2)) {
            return 0;
        }
        if (this.mService.checkPermission(permission2, callingPid, callingUid) == -1) {
            return 1;
        }
        int opCode = AppOpsManager.permissionToOpCode(permission2);
        if (opCode == -1) {
            return 0;
        }
        if (this.mService.mAppOpsService.noteOperation(opCode, callingUid, callingPackage) != 0) {
            return 2;
        }
        return 0;
    }

    void setLaunchSource(int uid) {
        this.mLaunchingActivity.setWorkSource(new WorkSource(uid));
    }

    void acquireLaunchWakelock() {
        this.mLaunchingActivity.acquire();
        if (!this.mHandler.hasMessages(104)) {
            this.mHandler.sendEmptyMessageDelayed(104, 10000L);
        }
    }

    @GuardedBy(value="mService")
    private boolean checkFinishBootingLocked() {
        boolean booting = this.mService.mBooting;
        boolean enableScreen = false;
        this.mService.mBooting = false;
        if (!this.mService.mBooted) {
            this.mService.mBooted = true;
            enableScreen = true;
        }
        if (booting || enableScreen) {
            this.mService.postFinishBooting(booting, enableScreen);
        }
        return booting;
    }

    @GuardedBy(value="mService")
    final ActivityRecord activityIdleInternalLocked(IBinder token, boolean fromTimeout, boolean processPausingActivities, Configuration config) {
        Object stack;
        int i;
        ArrayList<ActivityRecord> stops;
        ArrayList<ActivityRecord> finishes = null;
        ArrayList<UserState> startingUsers = null;
        int NS = 0;
        int NF = 0;
        boolean booting = false;
        boolean activityRemoved = false;
        ActivityRecord r = ActivityRecord.forTokenLocked(token);
        if (r != null) {
            this.mHandler.removeMessages(100, r);
            r.finishLaunchTickingLocked();
            if (fromTimeout) {
                this.reportActivityLaunchedLocked(fromTimeout, r, -1L, -1L);
            }
            if (config != null) {
                r.setLastReportedGlobalConfiguration(config);
            }
            r.idle = true;
            if (this.isFocusedStack((ActivityStack)r.getStack()) || fromTimeout) {
                booting = this.checkFinishBootingLocked();
            }
        }
        if (this.allResumedActivitiesIdle()) {
            if (r != null) {
                this.mService.scheduleAppGcsLocked();
            }
            if (this.mLaunchingActivity.isHeld()) {
                this.mHandler.removeMessages(104);
                this.mLaunchingActivity.release();
            }
            this.ensureActivitiesVisibleLocked(null, 0, false);
        }
        NS = (stops = this.processStoppingActivitiesLocked(r, true, processPausingActivities)) != null ? stops.size() : 0;
        NF = this.mFinishingActivities.size();
        if (NF > 0) {
            finishes = new ArrayList<ActivityRecord>(this.mFinishingActivities);
            this.mFinishingActivities.clear();
        }
        if (this.mStartingUsers.size() > 0) {
            startingUsers = new ArrayList<UserState>(this.mStartingUsers);
            this.mStartingUsers.clear();
        }
        for (i = 0; i < NS; ++i) {
            r = stops.get(i);
            stack = r.getStack();
            if (stack == null) continue;
            if (r.finishing) {
                ((ActivityStack)stack).finishCurrentActivityLocked(r, 0, false, "activityIdleInternalLocked");
                continue;
            }
            ((ActivityStack)stack).stopActivityLocked(r);
        }
        for (i = 0; i < NF; ++i) {
            r = finishes.get(i);
            stack = r.getStack();
            if (stack == null) continue;
            activityRemoved |= ((ActivityStack)stack).destroyActivityLocked(r, true, "finish-idle");
        }
        if (!booting && startingUsers != null) {
            for (i = 0; i < startingUsers.size(); ++i) {
                this.mService.mUserController.finishUserSwitch(startingUsers.get(i));
            }
        }
        this.mService.trimApplications();
        if (activityRemoved) {
            this.resumeFocusedStackTopActivityLocked();
        }
        return r;
    }

    boolean handleAppDiedLocked(ProcessRecord app) {
        boolean hasVisibleActivities = false;
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.valueAt(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                hasVisibleActivities |= stack.handleAppDiedLocked(app);
            }
        }
        return hasVisibleActivities;
    }

    void closeSystemDialogsLocked() {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.valueAt(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                stack.closeSystemDialogsLocked();
            }
        }
    }

    void removeUserLocked(int userId) {
        this.mUserStackInFront.delete(userId);
    }

    void updateUserStackLocked(int userId, ActivityStack stack) {
        if (userId != this.mCurrentUser) {
            this.mUserStackInFront.put(userId, stack != null ? stack.getStackId() : this.mHomeStack.mStackId);
        }
    }

    boolean finishDisabledPackageActivitiesLocked(String packageName, Set<String> filterByClasses, boolean doit, boolean evenPersistent, int userId) {
        boolean didSomething = false;
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.valueAt(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                if (!stack.finishDisabledPackageActivitiesLocked(packageName, filterByClasses, doit, evenPersistent, userId)) continue;
                didSomething = true;
            }
        }
        return didSomething;
    }

    void updatePreviousProcessLocked(ActivityRecord r) {
        ProcessRecord fgApp = null;
        block0: for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.valueAt(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                if (!this.isFocusedStack(stack)) continue;
                ActivityRecord resumedActivity = stack.getResumedActivity();
                if (resumedActivity != null) {
                    fgApp = resumedActivity.app;
                    continue block0;
                }
                if (stack.mPausingActivity == null) continue block0;
                fgApp = stack.mPausingActivity.app;
                continue block0;
            }
        }
        if (r.app != null && fgApp != null && r.app != fgApp && r.lastVisibleTime > this.mService.mPreviousProcessVisibleTime && r.app != this.mService.mHomeProcess) {
            this.mService.mPreviousProcess = r.app;
            this.mService.mPreviousProcessVisibleTime = r.lastVisibleTime;
        }
    }

    boolean resumeFocusedStackTopActivityLocked() {
        return this.resumeFocusedStackTopActivityLocked(null, null, null);
    }

    boolean resumeFocusedStackTopActivityLocked(ActivityStack targetStack, ActivityRecord target, ActivityOptions targetOptions) {
        if (!this.readyToResume()) {
            return false;
        }
        if (targetStack != null && this.isFocusedStack(targetStack)) {
            return targetStack.resumeTopActivityUncheckedLocked(target, targetOptions);
        }
        ActivityRecord r = this.mFocusedStack.topRunningActivityLocked();
        if (r == null || !r.isState(ActivityStack.ActivityState.RESUMED)) {
            this.mFocusedStack.resumeTopActivityUncheckedLocked(null, null);
        } else if (r.isState(ActivityStack.ActivityState.RESUMED)) {
            this.mFocusedStack.executeAppTransition(targetOptions);
        }
        return false;
    }

    void updateActivityApplicationInfoLocked(ApplicationInfo aInfo) {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.valueAt(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                stack.updateActivityApplicationInfoLocked(aInfo);
            }
        }
    }

    TaskRecord finishTopCrashedActivitiesLocked(ProcessRecord app, String reason) {
        TaskRecord finishedTask = null;
        ActivityStack focusedStack = this.getFocusedStack();
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.valueAt(displayNdx);
            for (int stackNdx = 0; stackNdx < display.getChildCount(); ++stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                TaskRecord t = stack.finishTopCrashedActivityLocked(app, reason);
                if (stack != focusedStack && finishedTask != null) continue;
                finishedTask = t;
            }
        }
        return finishedTask;
    }

    void finishVoiceTask(IVoiceInteractionSession session) {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.valueAt(displayNdx);
            int numStacks = display.getChildCount();
            for (int stackNdx = 0; stackNdx < numStacks; ++stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                stack.finishVoiceTask(session);
            }
        }
    }

    void findTaskToMoveToFront(TaskRecord task, int flags, ActivityOptions options, String reason, boolean forceNonResizeable) {
        ActivityRecord r;
        Object currentStack = task.getStack();
        if (currentStack == null) {
            Slog.e("ActivityManager", "findTaskToMoveToFront: can't move task=" + task + " to front. Stack is null");
            return;
        }
        if ((flags & 2) == 0) {
            this.mUserLeaving = true;
        }
        ActivityRecord prev = this.topRunningActivityLocked();
        if ((flags & 1) != 0 || prev != null && prev.isActivityTypeRecents()) {
            this.moveHomeStackToFront("findTaskToMoveToFront");
        }
        if (task.isResizeable() && this.canUseActivityOptionsLaunchBounds(options)) {
            Rect bounds = options.getLaunchBounds();
            task.updateOverrideConfiguration(bounds);
            Object stack = this.getLaunchStack(null, options, task, true);
            if (stack != currentStack) {
                task.reparent((ActivityStack)stack, true, 1, false, true, "findTaskToMoveToFront");
                stack = currentStack;
            }
            if (((ActivityStack)stack).resizeStackWithLaunchBounds()) {
                this.resizeStackLocked((ActivityStack)stack, bounds, null, null, false, true, false);
            } else {
                task.resizeWindowContainer();
            }
        }
        ((ActivityStack)currentStack).moveTaskToFrontLocked(task, false, options, (r = task.getTopActivity()) == null ? null : r.appTimeTracker, reason);
        this.handleNonResizableTaskIfNeeded(task, 0, 0, (ActivityStack)currentStack, forceNonResizeable);
    }

    boolean canUseActivityOptionsLaunchBounds(ActivityOptions options) {
        if (options == null || options.getLaunchBounds() == null) {
            return false;
        }
        return this.mService.mSupportsPictureInPicture && options.getLaunchWindowingMode() == 2 || this.mService.mSupportsFreeformWindowManagement;
    }

    LaunchParamsController getLaunchParamsController() {
        return this.mLaunchParamsController;
    }

    protected <T extends ActivityStack> T getStack(int stackId) {
        for (int i = this.mActivityDisplays.size() - 1; i >= 0; --i) {
            Object stack = this.mActivityDisplays.valueAt(i).getStack(stackId);
            if (stack == null) continue;
            return stack;
        }
        return null;
    }

    private <T extends ActivityStack> T getStack(int windowingMode, int activityType) {
        for (int i = this.mActivityDisplays.size() - 1; i >= 0; --i) {
            Object stack = this.mActivityDisplays.valueAt(i).getStack(windowingMode, activityType);
            if (stack == null) continue;
            return stack;
        }
        return null;
    }

    int resolveActivityType(ActivityRecord r, ActivityOptions options, TaskRecord task) {
        int activityType;
        int n = activityType = r != null ? r.getActivityType() : 0;
        if (activityType == 0 && task != null) {
            activityType = task.getActivityType();
        }
        if (activityType != 0) {
            return activityType;
        }
        if (options != null) {
            activityType = options.getLaunchActivityType();
        }
        return activityType != 0 ? activityType : 1;
    }

    <T extends ActivityStack> T getLaunchStack(ActivityRecord r, ActivityOptions options, TaskRecord candidateTask, boolean onTop) {
        return this.getLaunchStack(r, options, candidateTask, onTop, -1);
    }

    <T extends ActivityStack> T getLaunchStack(ActivityRecord r, ActivityOptions options, TaskRecord candidateTask, boolean onTop, int candidateDisplayId) {
        ActivityDisplay display;
        int taskId = -1;
        int displayId = -1;
        if (options != null) {
            taskId = options.getLaunchTaskId();
            displayId = options.getLaunchDisplayId();
        }
        if (taskId != -1) {
            options.setLaunchTaskId(-1);
            TaskRecord task = this.anyTaskForIdLocked(taskId, 2, options, onTop);
            options.setLaunchTaskId(taskId);
            if (task != null) {
                return task.getStack();
            }
        }
        int activityType = this.resolveActivityType(r, options, candidateTask);
        ActivityStack stack = null;
        if (displayId == -1) {
            displayId = candidateDisplayId;
        }
        if (displayId != -1 && this.canLaunchOnDisplay(r, displayId)) {
            if (r != null && (stack = this.getValidLaunchStackOnDisplay(displayId, r)) != null) {
                return (T)stack;
            }
            display = this.getActivityDisplayOrCreateLocked(displayId);
            if (display != null && (stack = display.getOrCreateStack(r, options, candidateTask, activityType, onTop)) != null) {
                return (T)stack;
            }
        }
        stack = null;
        display = null;
        if (candidateTask != null) {
            stack = (ActivityStack)candidateTask.getStack();
        }
        if (stack == null && r != null) {
            stack = r.getStack();
        }
        if (stack != null && (display = stack.getDisplay()) != null && this.canLaunchOnDisplay(r, display.mDisplayId)) {
            int windowingMode = display.resolveWindowingMode(r, options, candidateTask, activityType);
            if (stack.isCompatible(windowingMode, activityType)) {
                return (T)stack;
            }
            if (windowingMode == 4 && display.getSplitScreenPrimaryStack() == stack && candidateTask == stack.topTask()) {
                return (T)stack;
            }
        }
        if (display == null || !this.canLaunchOnDisplay(r, display.mDisplayId) || activityType != 1 && activityType != 0) {
            display = this.getDefaultDisplay();
        }
        return display.getOrCreateStack(r, options, candidateTask, activityType, onTop);
    }

    private boolean canLaunchOnDisplay(ActivityRecord r, int displayId) {
        if (r == null) {
            return true;
        }
        return r.canBeLaunchedOnDisplay(displayId);
    }

    ActivityStack getValidLaunchStackOnDisplay(int displayId, ActivityRecord r) {
        ActivityDisplay activityDisplay = this.getActivityDisplayOrCreateLocked(displayId);
        if (activityDisplay == null) {
            throw new IllegalArgumentException("Display with displayId=" + displayId + " not found.");
        }
        if (!r.canBeLaunchedOnDisplay(displayId)) {
            return null;
        }
        for (int i = activityDisplay.getChildCount() - 1; i >= 0; --i) {
            ActivityStack stack = activityDisplay.getChildAt(i);
            if (!this.isValidLaunchStack(stack, displayId, r)) continue;
            return stack;
        }
        if (displayId != 0) {
            return activityDisplay.createStack(r.getWindowingMode(), r.getActivityType(), true);
        }
        Slog.w("ActivityManager", "getValidLaunchStackOnDisplay: can't launch on displayId " + displayId);
        return null;
    }

    private boolean isValidLaunchStack(ActivityStack stack, int displayId, ActivityRecord r) {
        switch (stack.getActivityType()) {
            case 2: {
                return r.isActivityTypeHome();
            }
            case 3: {
                return r.isActivityTypeRecents();
            }
            case 4: {
                return r.isActivityTypeAssistant();
            }
        }
        switch (stack.getWindowingMode()) {
            case 1: {
                return true;
            }
            case 5: {
                return r.supportsFreeform();
            }
            case 2: {
                return r.supportsPictureInPicture();
            }
            case 3: {
                return r.supportsSplitScreenWindowingMode();
            }
            case 4: {
                return r.supportsSplitScreenWindowingMode();
            }
        }
        if (!stack.isOnHomeDisplay()) {
            return r.canBeLaunchedOnDisplay(displayId);
        }
        Slog.e("ActivityManager", "isValidLaunchStack: Unexpected stack=" + stack);
        return false;
    }

    ActivityStack getNextFocusableStackLocked(ActivityStack currentFocus, boolean ignoreCurrent) {
        this.mWindowManager.getDisplaysInFocusOrder(this.mTmpOrderedDisplayIds);
        int currentWindowingMode = currentFocus != null ? currentFocus.getWindowingMode() : 0;
        ActivityStack candidate = null;
        for (int i = this.mTmpOrderedDisplayIds.size() - 1; i >= 0; --i) {
            int displayId = this.mTmpOrderedDisplayIds.get(i);
            ActivityDisplay display = this.getActivityDisplayOrCreateLocked(displayId);
            if (display == null) continue;
            for (int j = display.getChildCount() - 1; j >= 0; --j) {
                ActivityStack stack = display.getChildAt(j);
                if (ignoreCurrent && stack == currentFocus || !stack.isFocusable() || !stack.shouldBeVisible(null)) continue;
                if (currentWindowingMode == 4 && candidate == null && stack.inSplitScreenPrimaryWindowingMode()) {
                    candidate = stack;
                    continue;
                }
                if (candidate != null && stack.inSplitScreenSecondaryWindowingMode()) {
                    return candidate;
                }
                return stack;
            }
        }
        return candidate;
    }

    ActivityStack getNextValidLaunchStackLocked(ActivityRecord r, int currentFocus) {
        this.mWindowManager.getDisplaysInFocusOrder(this.mTmpOrderedDisplayIds);
        for (int i = this.mTmpOrderedDisplayIds.size() - 1; i >= 0; --i) {
            ActivityStack stack;
            int displayId = this.mTmpOrderedDisplayIds.get(i);
            if (displayId == currentFocus || (stack = this.getValidLaunchStackOnDisplay(displayId, r)) == null) continue;
            return stack;
        }
        return null;
    }

    ActivityRecord getHomeActivity() {
        return this.getHomeActivityForUser(this.mCurrentUser);
    }

    ActivityRecord getHomeActivityForUser(int userId) {
        ArrayList<TaskRecord> tasks = this.mHomeStack.getAllTasks();
        for (int taskNdx = tasks.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = tasks.get(taskNdx);
            if (!task.isActivityTypeHome()) continue;
            ArrayList<ActivityRecord> activities = task.mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (!r.isActivityTypeHome() || userId != -1 && r.userId != userId) continue;
                return r;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resizeStackLocked(ActivityStack stack, Rect bounds, Rect tempTaskBounds, Rect tempTaskInsetBounds, boolean preserveWindows, boolean allowResizeInDockedMode, boolean deferResume) {
        if (stack.inSplitScreenPrimaryWindowingMode()) {
            this.resizeDockedStackLocked(bounds, tempTaskBounds, tempTaskInsetBounds, null, null, preserveWindows, deferResume);
            return;
        }
        boolean splitScreenActive = this.getDefaultDisplay().hasSplitScreenPrimaryStack();
        if (!allowResizeInDockedMode && !stack.getWindowConfiguration().tasksAreFloating() && splitScreenActive) {
            return;
        }
        Trace.traceBegin(64L, "am.resizeStack_" + stack.mStackId);
        this.mWindowManager.deferSurfaceLayout();
        try {
            if (stack.affectedBySplitScreenResize()) {
                if (bounds == null && stack.inSplitScreenWindowingMode()) {
                    stack.setWindowingMode(1);
                } else if (splitScreenActive) {
                    stack.setWindowingMode(4);
                }
            }
            stack.resize(bounds, tempTaskBounds, tempTaskInsetBounds);
            if (!deferResume) {
                stack.ensureVisibleActivitiesConfigurationLocked(stack.topRunningActivityLocked(), preserveWindows);
            }
        }
        finally {
            this.mWindowManager.continueSurfaceLayout();
            Trace.traceEnd(64L);
        }
    }

    void deferUpdateRecentsHomeStackBounds() {
        this.deferUpdateBounds(3);
        this.deferUpdateBounds(2);
    }

    void deferUpdateBounds(int activityType) {
        Object stack = this.getStack(0, activityType);
        if (stack != null) {
            ((ActivityStack)stack).deferUpdateBounds();
        }
    }

    void continueUpdateRecentsHomeStackBounds() {
        this.continueUpdateBounds(3);
        this.continueUpdateBounds(2);
    }

    void continueUpdateBounds(int activityType) {
        Object stack = this.getStack(0, activityType);
        if (stack != null) {
            ((ActivityStack)stack).continueUpdateBounds();
        }
    }

    void notifyAppTransitionDone() {
        this.continueUpdateRecentsHomeStackBounds();
        for (int i = this.mResizingTasksDuringAnimation.size() - 1; i >= 0; --i) {
            int taskId = this.mResizingTasksDuringAnimation.valueAt(i);
            TaskRecord task = this.anyTaskForIdLocked(taskId, 0);
            if (task == null) continue;
            task.setTaskDockedResizing(false);
        }
        this.mResizingTasksDuringAnimation.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveTasksToFullscreenStackInSurfaceTransaction(ActivityStack fromStack, int toDisplayId, boolean onTop) {
        this.mWindowManager.deferSurfaceLayout();
        try {
            int windowingMode = fromStack.getWindowingMode();
            boolean inPinnedWindowingMode = windowingMode == 2;
            ActivityDisplay toDisplay = this.getActivityDisplay(toDisplayId);
            if (windowingMode == 3) {
                toDisplay.onExitingSplitScreenMode();
                for (int i = toDisplay.getChildCount() - 1; i >= 0; --i) {
                    ActivityStack otherStack = toDisplay.getChildAt(i);
                    if (!otherStack.inSplitScreenSecondaryWindowingMode()) continue;
                    this.resizeStackLocked(otherStack, null, null, null, true, true, true);
                }
                this.mAllowDockedStackResize = false;
            }
            boolean schedulePictureInPictureModeChange = inPinnedWindowingMode;
            ArrayList<TaskRecord> tasks = fromStack.getAllTasks();
            if (!tasks.isEmpty()) {
                this.mTmpOptions.setLaunchWindowingMode(1);
                int size = tasks.size();
                for (int i = 0; i < size; ++i) {
                    TaskRecord task = tasks.get(i);
                    Object toStack = toDisplay.getOrCreateStack(null, this.mTmpOptions, task, task.getActivityType(), onTop);
                    if (onTop) {
                        boolean isTopTask = i == size - 1;
                        task.reparent((ActivityStack)toStack, true, 0, isTopTask, true, schedulePictureInPictureModeChange, "moveTasksToFullscreenStack - onTop");
                        MetricsLoggerWrapper.logPictureInPictureFullScreen(this.mService.mContext, task.effectiveUid, task.realActivity.flattenToString());
                        continue;
                    }
                    task.reparent((ActivityStack)toStack, true, 2, false, true, schedulePictureInPictureModeChange, "moveTasksToFullscreenStack - NOT_onTop");
                }
            }
            this.ensureActivitiesVisibleLocked(null, 0, true);
            this.resumeFocusedStackTopActivityLocked();
        }
        finally {
            this.mAllowDockedStackResize = true;
            this.mWindowManager.continueSurfaceLayout();
        }
    }

    void moveTasksToFullscreenStackLocked(ActivityStack fromStack, boolean onTop) {
        this.moveTasksToFullscreenStackLocked(fromStack, 0, onTop);
    }

    void moveTasksToFullscreenStackLocked(ActivityStack fromStack, int toDisplayId, boolean onTop) {
        this.mWindowManager.inSurfaceTransaction(() -> this.moveTasksToFullscreenStackInSurfaceTransaction(fromStack, toDisplayId, onTop));
    }

    void setSplitScreenResizing(boolean resizing) {
        if (resizing == this.mDockedStackResizing) {
            return;
        }
        this.mDockedStackResizing = resizing;
        this.mWindowManager.setDockedStackResizing(resizing);
        if (!resizing && this.mHasPendingDockedBounds) {
            this.resizeDockedStackLocked(this.mPendingDockedBounds, this.mPendingTempDockedTaskBounds, this.mPendingTempDockedTaskInsetBounds, this.mPendingTempOtherTaskBounds, this.mPendingTempOtherTaskInsetBounds, true);
            this.mHasPendingDockedBounds = false;
            this.mPendingDockedBounds = null;
            this.mPendingTempDockedTaskBounds = null;
            this.mPendingTempDockedTaskInsetBounds = null;
            this.mPendingTempOtherTaskBounds = null;
            this.mPendingTempOtherTaskInsetBounds = null;
        }
    }

    void resizeDockedStackLocked(Rect dockedBounds, Rect tempDockedTaskBounds, Rect tempDockedTaskInsetBounds, Rect tempOtherTaskBounds, Rect tempOtherTaskInsetBounds, boolean preserveWindows) {
        this.resizeDockedStackLocked(dockedBounds, tempDockedTaskBounds, tempDockedTaskInsetBounds, tempOtherTaskBounds, tempOtherTaskInsetBounds, preserveWindows, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resizeDockedStackLocked(Rect dockedBounds, Rect tempDockedTaskBounds, Rect tempDockedTaskInsetBounds, Rect tempOtherTaskBounds, Rect tempOtherTaskInsetBounds, boolean preserveWindows, boolean deferResume) {
        if (!this.mAllowDockedStackResize) {
            return;
        }
        ActivityStack stack = this.getDefaultDisplay().getSplitScreenPrimaryStack();
        if (stack == null) {
            Slog.w("ActivityManager", "resizeDockedStackLocked: docked stack not found");
            return;
        }
        if (this.mDockedStackResizing) {
            this.mHasPendingDockedBounds = true;
            this.mPendingDockedBounds = Rect.copyOrNull(dockedBounds);
            this.mPendingTempDockedTaskBounds = Rect.copyOrNull(tempDockedTaskBounds);
            this.mPendingTempDockedTaskInsetBounds = Rect.copyOrNull(tempDockedTaskInsetBounds);
            this.mPendingTempOtherTaskBounds = Rect.copyOrNull(tempOtherTaskBounds);
            this.mPendingTempOtherTaskInsetBounds = Rect.copyOrNull(tempOtherTaskInsetBounds);
        }
        Trace.traceBegin(64L, "am.resizeDockedStack");
        this.mWindowManager.deferSurfaceLayout();
        try {
            this.mAllowDockedStackResize = false;
            ActivityRecord r = stack.topRunningActivityLocked();
            stack.resize(dockedBounds, tempDockedTaskBounds, tempDockedTaskInsetBounds);
            if (stack.getWindowingMode() == 1 || dockedBounds == null && !stack.isAttached()) {
                this.moveTasksToFullscreenStackLocked(stack, true);
                r = null;
            } else {
                ActivityDisplay display = this.getDefaultDisplay();
                Rect otherTaskRect = new Rect();
                for (int i = display.getChildCount() - 1; i >= 0; --i) {
                    ActivityStack current = display.getChildAt(i);
                    if (current.getWindowingMode() == 3 || !current.affectedBySplitScreenResize() || this.mDockedStackResizing && !current.isTopActivityVisible()) continue;
                    current.setWindowingMode(4);
                    current.getStackDockedModeBounds(tempOtherTaskBounds, this.tempRect, otherTaskRect, true);
                    this.resizeStackLocked(current, !this.tempRect.isEmpty() ? this.tempRect : null, !otherTaskRect.isEmpty() ? otherTaskRect : tempOtherTaskBounds, tempOtherTaskInsetBounds, preserveWindows, true, deferResume);
                }
            }
            if (!deferResume) {
                stack.ensureVisibleActivitiesConfigurationLocked(r, preserveWindows);
            }
        }
        finally {
            this.mAllowDockedStackResize = true;
            this.mWindowManager.continueSurfaceLayout();
            Trace.traceEnd(64L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resizePinnedStackLocked(Rect pinnedBounds, Rect tempPinnedTaskBounds) {
        PinnedActivityStack stack = this.getDefaultDisplay().getPinnedStack();
        if (stack == null) {
            Slog.w("ActivityManager", "resizePinnedStackLocked: pinned stack not found");
            return;
        }
        PinnedStackWindowController stackController = (PinnedStackWindowController)stack.getWindowContainerController();
        if (stackController.pinnedStackResizeDisallowed()) {
            return;
        }
        Trace.traceBegin(64L, "am.resizePinnedStack");
        this.mWindowManager.deferSurfaceLayout();
        try {
            ActivityRecord r = stack.topRunningActivityLocked();
            Rect insetBounds = null;
            if (tempPinnedTaskBounds != null && stack.isAnimatingBoundsToFullscreen()) {
                insetBounds = this.tempRect;
                insetBounds.top = 0;
                insetBounds.left = 0;
                insetBounds.right = tempPinnedTaskBounds.width();
                insetBounds.bottom = tempPinnedTaskBounds.height();
            }
            if (pinnedBounds != null && tempPinnedTaskBounds == null) {
                stack.onPipAnimationEndResize();
            }
            stack.resize(pinnedBounds, tempPinnedTaskBounds, insetBounds);
            stack.ensureVisibleActivitiesConfigurationLocked(r, false);
        }
        finally {
            this.mWindowManager.continueSurfaceLayout();
            Trace.traceEnd(64L);
        }
    }

    private void removeStackInSurfaceTransaction(ActivityStack stack) {
        ArrayList<TaskRecord> tasks = stack.getAllTasks();
        if (stack.getWindowingMode() == 2) {
            PinnedActivityStack pinnedStack = (PinnedActivityStack)stack;
            pinnedStack.mForceHidden = true;
            pinnedStack.ensureActivitiesVisibleLocked(null, 0, true);
            pinnedStack.mForceHidden = false;
            this.activityIdleInternalLocked(null, false, true, null);
            this.moveTasksToFullscreenStackLocked(pinnedStack, false);
        } else {
            for (int i = tasks.size() - 1; i >= 0; --i) {
                this.removeTaskByIdLocked(tasks.get((int)i).taskId, true, true, "remove-stack");
            }
        }
    }

    void removeStack(ActivityStack stack) {
        this.mWindowManager.inSurfaceTransaction(() -> this.removeStackInSurfaceTransaction(stack));
    }

    void removeStacksInWindowingModes(int ... windowingModes) {
        for (int i = this.mActivityDisplays.size() - 1; i >= 0; --i) {
            this.mActivityDisplays.valueAt(i).removeStacksInWindowingModes(windowingModes);
        }
    }

    void removeStacksWithActivityTypes(int ... activityTypes) {
        for (int i = this.mActivityDisplays.size() - 1; i >= 0; --i) {
            this.mActivityDisplays.valueAt(i).removeStacksWithActivityTypes(activityTypes);
        }
    }

    boolean removeTaskByIdLocked(int taskId, boolean killProcess, boolean removeFromRecents, String reason) {
        return this.removeTaskByIdLocked(taskId, killProcess, removeFromRecents, false, reason);
    }

    boolean removeTaskByIdLocked(int taskId, boolean killProcess, boolean removeFromRecents, boolean pauseImmediately, String reason) {
        TaskRecord tr = this.anyTaskForIdLocked(taskId, 1);
        if (tr != null) {
            tr.removeTaskActivitiesLocked(pauseImmediately, reason);
            this.cleanUpRemovedTaskLocked(tr, killProcess, removeFromRecents);
            this.mService.getLockTaskController().clearLockedTask(tr);
            if (tr.isPersistable) {
                this.mService.notifyTaskPersisterLocked(null, true);
            }
            return true;
        }
        Slog.w("ActivityManager", "Request to remove task ignored for non-existent task " + taskId);
        return false;
    }

    void cleanUpRemovedTaskLocked(TaskRecord tr, boolean killProcess, boolean removeFromRecents) {
        int i;
        ComponentName component;
        if (removeFromRecents) {
            this.mRecentTasks.remove(tr);
        }
        if ((component = tr.getBaseIntent().getComponent()) == null) {
            Slog.w("ActivityManager", "No component for base intent of task: " + tr);
            return;
        }
        this.mService.mServices.cleanUpRemovedTaskLocked(tr, component, new Intent(tr.getBaseIntent()));
        if (!killProcess) {
            return;
        }
        String pkg = component.getPackageName();
        ArrayList<ProcessRecord> procsToKill = new ArrayList<ProcessRecord>();
        ArrayMap<String, SparseArray<ProcessRecord>> pmap = this.mService.mProcessNames.getMap();
        for (i = 0; i < pmap.size(); ++i) {
            SparseArray<ProcessRecord> uids = pmap.valueAt(i);
            for (int j = 0; j < uids.size(); ++j) {
                ProcessRecord proc = uids.valueAt(j);
                if (proc.userId != tr.userId || proc == this.mService.mHomeProcess || !proc.pkgList.containsKey(pkg)) continue;
                for (int k = 0; k < proc.activities.size(); ++k) {
                    TaskRecord otherTask = proc.activities.get(k).getTask();
                    if (tr.taskId == otherTask.taskId || !otherTask.inRecents) continue;
                    return;
                }
                if (proc.foregroundServices) {
                    return;
                }
                procsToKill.add(proc);
            }
        }
        for (i = 0; i < procsToKill.size(); ++i) {
            ProcessRecord pr = (ProcessRecord)procsToKill.get(i);
            if (pr.setSchedGroup == 0 && pr.curReceivers.isEmpty()) {
                pr.kill("remove task", true);
                continue;
            }
            pr.waitingToKill = "remove task";
        }
    }

    boolean restoreRecentTaskLocked(TaskRecord task, ActivityOptions aOptions, boolean onTop) {
        Object stack = this.getLaunchStack(null, aOptions, task, onTop);
        Object currentStack = task.getStack();
        if (currentStack != null) {
            if (currentStack == stack) {
                return true;
            }
            ((ActivityStack)currentStack).removeTask(task, "restoreRecentTaskLocked", 1);
        }
        ((ActivityStack)stack).addTask(task, onTop, "restoreRecentTask");
        task.createWindowContainer(onTop, true);
        ArrayList<ActivityRecord> activities = task.mActivities;
        for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
            activities.get(activityNdx).createWindowContainer();
        }
        return true;
    }

    @Override
    public void onRecentTaskAdded(TaskRecord task) {
        task.touchActiveTime();
    }

    @Override
    public void onRecentTaskRemoved(TaskRecord task, boolean wasTrimmed) {
        if (wasTrimmed) {
            this.removeTaskByIdLocked(task.taskId, false, false, false, "recent-task-trimmed");
        }
        task.removedFromRecents();
    }

    void moveStackToDisplayLocked(int stackId, int displayId, boolean onTop) {
        ActivityDisplay activityDisplay = this.getActivityDisplayOrCreateLocked(displayId);
        if (activityDisplay == null) {
            throw new IllegalArgumentException("moveStackToDisplayLocked: Unknown displayId=" + displayId);
        }
        Object stack = this.getStack(stackId);
        if (stack == null) {
            throw new IllegalArgumentException("moveStackToDisplayLocked: Unknown stackId=" + stackId);
        }
        ActivityDisplay currentDisplay = ((ActivityStack)stack).getDisplay();
        if (currentDisplay == null) {
            throw new IllegalStateException("moveStackToDisplayLocked: Stack with stack=" + stack + " is not attached to any display.");
        }
        if (currentDisplay.mDisplayId == displayId) {
            throw new IllegalArgumentException("Trying to move stack=" + stack + " to its current displayId=" + displayId);
        }
        ((ActivityStack)stack).reparent(activityDisplay, onTop);
    }

    ActivityStack getReparentTargetStack(TaskRecord task, ActivityStack stack, boolean toTop) {
        Object prevStack = task.getStack();
        int stackId = stack.mStackId;
        boolean inMultiWindowMode = stack.inMultiWindowMode();
        if (prevStack != null && ((ActivityStack)prevStack).mStackId == stackId) {
            Slog.w("ActivityManager", "Can not reparent to same stack, task=" + task + " already in stackId=" + stackId);
            return prevStack;
        }
        if (inMultiWindowMode && !this.mService.mSupportsMultiWindow) {
            throw new IllegalArgumentException("Device doesn't support multi-window, can not reparent task=" + task + " to stack=" + stack);
        }
        if (stack.mDisplayId != 0 && !this.mService.mSupportsMultiDisplay) {
            throw new IllegalArgumentException("Device doesn't support multi-display, can not reparent task=" + task + " to stackId=" + stackId);
        }
        if (stack.getWindowingMode() == 5 && !this.mService.mSupportsFreeformWindowManagement) {
            throw new IllegalArgumentException("Device doesn't support freeform, can not reparent task=" + task);
        }
        if (inMultiWindowMode && !task.isResizeable()) {
            Slog.w("ActivityManager", "Can not move unresizeable task=" + task + " to multi-window stack=" + stack + " Moving to a fullscreen stack instead.");
            if (prevStack != null) {
                return prevStack;
            }
            stack = stack.getDisplay().createStack(1, stack.getActivityType(), toTop);
        }
        return stack;
    }

    boolean moveTopStackActivityToPinnedStackLocked(int stackId, Rect destBounds) {
        Object stack = this.getStack(stackId);
        if (stack == null) {
            throw new IllegalArgumentException("moveTopStackActivityToPinnedStackLocked: Unknown stackId=" + stackId);
        }
        ActivityRecord r = ((ActivityStack)stack).topRunningActivityLocked();
        if (r == null) {
            Slog.w("ActivityManager", "moveTopStackActivityToPinnedStackLocked: No top running activity in stack=" + stack);
            return false;
        }
        if (!this.mService.mForceResizableActivities && !r.supportsPictureInPicture()) {
            Slog.w("ActivityManager", "moveTopStackActivityToPinnedStackLocked: Picture-In-Picture not supported for  r=" + r);
            return false;
        }
        this.moveActivityToPinnedStackLocked(r, null, 0.0f, "moveTopActivityToPinnedStack");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveActivityToPinnedStackLocked(ActivityRecord r, Rect sourceHintBounds, float aspectRatio, String reason) {
        this.mWindowManager.deferSurfaceLayout();
        ActivityDisplay display = ((ActivityStack)r.getStack()).getDisplay();
        PinnedActivityStack stack = display.getPinnedStack();
        if (stack != null) {
            this.moveTasksToFullscreenStackLocked(stack, false);
        }
        stack = (PinnedActivityStack)display.getOrCreateStack(2, r.getActivityType(), true);
        Rect destBounds = stack.getDefaultPictureInPictureBounds(aspectRatio);
        try {
            TaskRecord task = r.getTask();
            this.resizeStackLocked(stack, task.getOverrideBounds(), null, null, false, true, false);
            if (task.mActivities.size() == 1) {
                task.reparent((ActivityStack)stack, true, 0, false, true, false, reason);
            } else {
                TaskRecord newTask = ((ActivityStack)task.getStack()).createTaskRecord(this.getNextTaskIdForUserLocked(r.userId), r.info, r.intent, null, null, true);
                r.reparent(newTask, Integer.MAX_VALUE, "moveActivityToStack");
                newTask.reparent((ActivityStack)stack, true, 0, false, true, false, reason);
            }
            r.supportsEnterPipOnTaskSwitch = false;
        }
        finally {
            this.mWindowManager.continueSurfaceLayout();
        }
        stack.animateResizePinnedStack(sourceHintBounds, destBounds, -1, true);
        this.ensureActivitiesVisibleLocked(null, 0, false);
        this.resumeFocusedStackTopActivityLocked();
        this.mService.mTaskChangeNotificationController.notifyActivityPinned(r);
    }

    boolean moveFocusableActivityStackToFrontLocked(ActivityRecord r, String reason) {
        if (r == null || !r.isFocusable()) {
            return false;
        }
        TaskRecord task = r.getTask();
        Object stack = r.getStack();
        if (stack == null) {
            Slog.w("ActivityManager", "moveActivityStackToFront: invalid task or stack: r=" + r + " task=" + task);
            return false;
        }
        if (stack == this.mFocusedStack && ((ActivityStack)stack).topRunningActivityLocked() == r) {
            return false;
        }
        ((ActivityStack)stack).moveToFront(reason, task);
        return true;
    }

    ActivityRecord findTaskLocked(ActivityRecord r, int displayId) {
        this.mTmpFindTaskResult.r = null;
        this.mTmpFindTaskResult.matchedByRootAffinity = false;
        ActivityRecord affinityMatch = null;
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.valueAt(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                if (!r.hasCompatibleActivityType(stack)) continue;
                stack.findTaskLocked(r, this.mTmpFindTaskResult);
                if (this.mTmpFindTaskResult.r == null) continue;
                if (!this.mTmpFindTaskResult.matchedByRootAffinity) {
                    return this.mTmpFindTaskResult.r;
                }
                if (this.mTmpFindTaskResult.r.getDisplayId() != displayId) continue;
                affinityMatch = this.mTmpFindTaskResult.r;
            }
        }
        return affinityMatch;
    }

    ActivityRecord findActivityLocked(Intent intent, ActivityInfo info, boolean compareIntentFilters) {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.valueAt(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                ActivityRecord ar = stack.findActivityLocked(intent, info, compareIntentFilters);
                if (ar == null) continue;
                return ar;
            }
        }
        return null;
    }

    boolean hasAwakeDisplay() {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.valueAt(displayNdx);
            if (display.shouldSleep()) continue;
            return true;
        }
        return false;
    }

    void goingToSleepLocked() {
        this.scheduleSleepTimeout();
        if (!this.mGoingToSleep.isHeld()) {
            this.mGoingToSleep.acquire();
            if (this.mLaunchingActivity.isHeld()) {
                this.mLaunchingActivity.release();
                this.mService.mHandler.removeMessages(104);
            }
        }
        this.applySleepTokensLocked(false);
        this.checkReadyForSleepLocked(true);
    }

    void prepareForShutdownLocked() {
        for (int i = 0; i < this.mActivityDisplays.size(); ++i) {
            this.createSleepTokenLocked("shutdown", this.mActivityDisplays.keyAt(i));
        }
    }

    boolean shutdownLocked(int timeout) {
        this.goingToSleepLocked();
        boolean timedout = false;
        long endTime = System.currentTimeMillis() + (long)timeout;
        while (!this.putStacksToSleepLocked(true, true)) {
            long timeRemaining = endTime - System.currentTimeMillis();
            if (timeRemaining > 0L) {
                try {
                    this.mService.wait(timeRemaining);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            Slog.w("ActivityManager", "Activity manager shutdown timed out");
            timedout = true;
            break;
        }
        this.checkReadyForSleepLocked(false);
        return timedout;
    }

    void comeOutOfSleepIfNeededLocked() {
        this.removeSleepTimeouts();
        if (this.mGoingToSleep.isHeld()) {
            this.mGoingToSleep.release();
        }
    }

    void applySleepTokensLocked(boolean applyToStacks) {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.valueAt(displayNdx);
            boolean displayShouldSleep = display.shouldSleep();
            if (displayShouldSleep == display.isSleeping()) continue;
            display.setIsSleeping(displayShouldSleep);
            if (!applyToStacks) continue;
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                if (displayShouldSleep) {
                    stack.goToSleepIfPossible(false);
                    continue;
                }
                stack.awakeFromSleepingLocked();
                if (!this.isFocusedStack(stack) || this.getKeyguardController().isKeyguardOrAodShowing(display.mDisplayId)) continue;
                this.resumeFocusedStackTopActivityLocked();
            }
            if (displayShouldSleep || this.mGoingToSleepActivities.isEmpty()) continue;
            Iterator<ActivityRecord> it = this.mGoingToSleepActivities.iterator();
            while (it.hasNext()) {
                ActivityRecord r = it.next();
                if (r.getDisplayId() != display.mDisplayId) continue;
                it.remove();
            }
        }
    }

    void activitySleptLocked(ActivityRecord r) {
        this.mGoingToSleepActivities.remove(r);
        Object s = r.getStack();
        if (s != null) {
            ((ActivityStack)s).checkReadyForSleep();
        } else {
            this.checkReadyForSleepLocked(true);
        }
    }

    void checkReadyForSleepLocked(boolean allowDelay) {
        if (!this.mService.isSleepingOrShuttingDownLocked()) {
            return;
        }
        if (!this.putStacksToSleepLocked(allowDelay, false)) {
            return;
        }
        this.sendPowerHintForLaunchEndIfNeeded();
        this.removeSleepTimeouts();
        if (this.mGoingToSleep.isHeld()) {
            this.mGoingToSleep.release();
        }
        if (this.mService.mShuttingDown) {
            this.mService.notifyAll();
        }
    }

    private boolean putStacksToSleepLocked(boolean allowDelay, boolean shuttingDown) {
        boolean allSleep = true;
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.valueAt(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                if (allowDelay) {
                    allSleep &= stack.goToSleepIfPossible(shuttingDown);
                    continue;
                }
                stack.goToSleep();
            }
        }
        return allSleep;
    }

    boolean reportResumedActivityLocked(ActivityRecord r) {
        this.mStoppingActivities.remove(r);
        Object stack = r.getStack();
        if (this.isFocusedStack((ActivityStack)stack)) {
            this.mService.updateUsageStats(r, true);
        }
        if (this.allResumedActivitiesComplete()) {
            this.ensureActivitiesVisibleLocked(null, 0, false);
            this.mWindowManager.executeAppTransition();
            return true;
        }
        return false;
    }

    void handleAppCrashLocked(ProcessRecord app) {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.valueAt(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                stack.handleAppCrashLocked(app);
            }
        }
    }

    private void handleLaunchTaskBehindCompleteLocked(ActivityRecord r) {
        TaskRecord task = r.getTask();
        Object stack = task.getStack();
        r.mLaunchTaskBehind = false;
        this.mRecentTasks.add(task);
        this.mService.mTaskChangeNotificationController.notifyTaskStackChanged();
        r.setVisibility(false);
        ActivityRecord top = ((ActivityStack)stack).getTopActivity();
        if (top != null) {
            top.getTask().touchActiveTime();
        }
    }

    void scheduleLaunchTaskBehindComplete(IBinder token) {
        this.mHandler.obtainMessage(112, token).sendToTarget();
    }

    void ensureActivitiesVisibleLocked(ActivityRecord starting, int configChanges, boolean preserveWindows) {
        this.ensureActivitiesVisibleLocked(starting, configChanges, preserveWindows, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureActivitiesVisibleLocked(ActivityRecord starting, int configChanges, boolean preserveWindows, boolean notifyClients) {
        this.getKeyguardController().beginActivityVisibilityUpdate();
        try {
            for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
                ActivityDisplay display = this.mActivityDisplays.valueAt(displayNdx);
                for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                    ActivityStack stack = display.getChildAt(stackNdx);
                    stack.ensureActivitiesVisibleLocked(starting, configChanges, preserveWindows, notifyClients);
                }
            }
        }
        finally {
            this.getKeyguardController().endActivityVisibilityUpdate();
        }
    }

    void addStartingWindowsForVisibleActivities(boolean taskSwitch) {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.valueAt(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                stack.addStartingWindowsForVisibleActivities(taskSwitch);
            }
        }
    }

    void invalidateTaskLayers() {
        this.mTaskLayersChanged = true;
    }

    void rankTaskLayersIfNeeded() {
        if (!this.mTaskLayersChanged) {
            return;
        }
        this.mTaskLayersChanged = false;
        for (int displayNdx = 0; displayNdx < this.mActivityDisplays.size(); ++displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.valueAt(displayNdx);
            int baseLayer = 0;
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                baseLayer += stack.rankTaskLayers(baseLayer);
            }
        }
    }

    void clearOtherAppTimeTrackers(AppTimeTracker except) {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.valueAt(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                stack.clearOtherAppTimeTrackers(except);
            }
        }
    }

    void scheduleDestroyAllActivities(ProcessRecord app, String reason) {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.valueAt(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                stack.scheduleDestroyActivities(app, reason);
            }
        }
    }

    void releaseSomeActivitiesLocked(ProcessRecord app, String reason) {
        TaskRecord firstTask = null;
        ArraySet<TaskRecord> tasks = null;
        for (int i = 0; i < app.activities.size(); ++i) {
            TaskRecord task;
            ActivityRecord r = app.activities.get(i);
            if (r.finishing || r.isState(ActivityStack.ActivityState.DESTROYING, ActivityStack.ActivityState.DESTROYED)) {
                return;
            }
            if (r.visible || !r.stopped || !r.haveState || r.isState(ActivityStack.ActivityState.RESUMED, ActivityStack.ActivityState.PAUSING, ActivityStack.ActivityState.PAUSED, ActivityStack.ActivityState.STOPPING) || (task = r.getTask()) == null) continue;
            if (firstTask == null) {
                firstTask = task;
                continue;
            }
            if (firstTask == task) continue;
            if (tasks == null) {
                tasks = new ArraySet<TaskRecord>();
                tasks.add(firstTask);
            }
            tasks.add(task);
        }
        if (tasks == null) {
            return;
        }
        int numDisplays = this.mActivityDisplays.size();
        for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.valueAt(displayNdx);
            int stackCount = display.getChildCount();
            for (int stackNdx = 0; stackNdx < stackCount; ++stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                if (stack.releaseSomeActivitiesLocked(app, tasks, reason) <= 0) continue;
                return;
            }
        }
    }

    boolean switchUserLocked(int userId, UserState uss) {
        int focusStackId = this.mFocusedStack.getStackId();
        ActivityStack dockedStack = this.getDefaultDisplay().getSplitScreenPrimaryStack();
        if (dockedStack != null) {
            this.moveTasksToFullscreenStackLocked(dockedStack, this.mFocusedStack == dockedStack);
        }
        this.removeStacksInWindowingModes(2);
        this.mUserStackInFront.put(this.mCurrentUser, focusStackId);
        int restoreStackId = this.mUserStackInFront.get(userId, this.mHomeStack.mStackId);
        this.mCurrentUser = userId;
        this.mStartingUsers.add(uss);
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.valueAt(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                stack.switchUserLocked(userId);
                TaskRecord task = stack.topTask();
                if (task == null) continue;
                stack.positionChildWindowContainerAtTop(task);
            }
        }
        Object stack = this.getStack(restoreStackId);
        if (stack == null) {
            stack = this.mHomeStack;
        }
        boolean homeInFront = ((ConfigurationContainer)stack).isActivityTypeHome();
        if (((ActivityStack)stack).isOnHomeDisplay()) {
            ((ActivityStack)stack).moveToFront("switchUserOnHomeDisplay");
        } else {
            this.resumeHomeStackTask(null, "switchUserOnOtherDisplay");
        }
        return homeInFront;
    }

    boolean isCurrentProfileLocked(int userId) {
        if (userId == this.mCurrentUser) {
            return true;
        }
        return this.mService.mUserController.isCurrentProfile(userId);
    }

    boolean isStoppingNoHistoryActivity() {
        for (ActivityRecord record : this.mStoppingActivities) {
            if (!record.isNoHistory()) continue;
            return true;
        }
        return false;
    }

    final ArrayList<ActivityRecord> processStoppingActivitiesLocked(ActivityRecord idleActivity, boolean remove, boolean processPausingActivities) {
        ArrayList<ActivityRecord> stops = null;
        boolean nowVisible = this.allResumedActivitiesVisible();
        for (int activityNdx = this.mStoppingActivities.size() - 1; activityNdx >= 0; --activityNdx) {
            boolean shouldSleepOrShutDown;
            ActivityRecord s = this.mStoppingActivities.get(activityNdx);
            boolean waitingVisible = this.mActivitiesWaitingForVisibleActivity.contains(s);
            if (waitingVisible && nowVisible) {
                this.mActivitiesWaitingForVisibleActivity.remove(s);
                waitingVisible = false;
                if (s.finishing) {
                    s.setVisibility(false);
                }
            }
            if (!remove) continue;
            Object stack = s.getStack();
            boolean bl = shouldSleepOrShutDown = stack != null ? ((ActivityStack)stack).shouldSleepOrShutDownActivities() : this.mService.isSleepingOrShuttingDownLocked();
            if (waitingVisible && !shouldSleepOrShutDown) continue;
            if (!processPausingActivities && s.isState(ActivityStack.ActivityState.PAUSING)) {
                this.removeTimeoutsForActivityLocked(idleActivity);
                this.scheduleIdleTimeoutLocked(idleActivity);
                continue;
            }
            if (stops == null) {
                stops = new ArrayList<ActivityRecord>();
            }
            stops.add(s);
            this.mActivitiesWaitingForVisibleActivity.remove(s);
            this.mStoppingActivities.remove(activityNdx);
        }
        return stops;
    }

    void validateTopActivitiesLocked() {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.valueAt(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack.ActivityState state;
                ActivityStack stack = display.getChildAt(stackNdx);
                ActivityRecord r = stack.topRunningActivityLocked();
                ActivityStack.ActivityState activityState = state = r == null ? ActivityStack.ActivityState.DESTROYED : r.getState();
                if (this.isFocusedStack(stack)) {
                    if (r == null) {
                        Slog.e("ActivityManager", "validateTop...: null top activity, stack=" + stack);
                        continue;
                    }
                    ActivityRecord pausing = stack.mPausingActivity;
                    if (pausing != null && pausing == r) {
                        Slog.e("ActivityManager", "validateTop...: top stack has pausing activity r=" + r + " state=" + (Object)((Object)state));
                    }
                    if (state == ActivityStack.ActivityState.INITIALIZING || state == ActivityStack.ActivityState.RESUMED) continue;
                    Slog.e("ActivityManager", "validateTop...: activity in front not resumed r=" + r + " state=" + (Object)((Object)state));
                    continue;
                }
                ActivityRecord resumed = stack.getResumedActivity();
                if (resumed != null && resumed == r) {
                    Slog.e("ActivityManager", "validateTop...: back stack has resumed activity r=" + r + " state=" + (Object)((Object)state));
                }
                if (r == null || state != ActivityStack.ActivityState.INITIALIZING && state != ActivityStack.ActivityState.RESUMED) continue;
                Slog.e("ActivityManager", "validateTop...: activity in back resumed r=" + r + " state=" + (Object)((Object)state));
            }
        }
    }

    public void dumpDisplays(PrintWriter pw) {
        for (int i = this.mActivityDisplays.size() - 1; i >= 0; --i) {
            ActivityDisplay display = this.mActivityDisplays.valueAt(i);
            pw.print("[id:" + display.mDisplayId + " stacks:");
            display.dumpStacks(pw);
            pw.print("]");
        }
    }

    public void dump(PrintWriter pw, String prefix) {
        int i;
        pw.print(prefix);
        pw.print("mFocusedStack=" + this.mFocusedStack);
        pw.print(" mLastFocusedStack=");
        pw.println(this.mLastFocusedStack);
        pw.print(prefix);
        pw.println("mCurTaskIdForUser=" + this.mCurTaskIdForUser);
        pw.print(prefix);
        pw.println("mUserStackInFront=" + this.mUserStackInFront);
        for (i = this.mActivityDisplays.size() - 1; i >= 0; --i) {
            ActivityDisplay display = this.mActivityDisplays.valueAt(i);
            display.dump(pw, prefix);
        }
        if (!this.mWaitingForActivityVisible.isEmpty()) {
            pw.print(prefix);
            pw.println("mWaitingForActivityVisible=");
            for (i = 0; i < this.mWaitingForActivityVisible.size(); ++i) {
                pw.print(prefix);
                pw.print(prefix);
                this.mWaitingForActivityVisible.get(i).dump(pw, prefix);
            }
        }
        pw.print(prefix);
        pw.print("isHomeRecentsComponent=");
        pw.print(this.mRecentTasks.isRecentsComponentHomeActivity(this.mCurrentUser));
        this.getKeyguardController().dump(pw, prefix);
        this.mService.getLockTaskController().dump(pw, prefix);
    }

    public void writeToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        super.writeToProto(proto, 0x10B00000001L, false);
        for (int displayNdx = 0; displayNdx < this.mActivityDisplays.size(); ++displayNdx) {
            ActivityDisplay activityDisplay = this.mActivityDisplays.valueAt(displayNdx);
            activityDisplay.writeToProto(proto, 0x20B00000002L);
        }
        this.getKeyguardController().writeToProto(proto, 1146756268035L);
        if (this.mFocusedStack != null) {
            proto.write(1120986464260L, this.mFocusedStack.mStackId);
            ActivityRecord focusedActivity = this.getResumedActivityLocked();
            if (focusedActivity != null) {
                focusedActivity.writeIdentifierToProto(proto, 1146756268037L);
            }
        } else {
            proto.write(1120986464260L, -1);
        }
        proto.write(1133871366150L, this.mRecentTasks.isRecentsComponentHomeActivity(this.mCurrentUser));
        proto.end(token);
    }

    void dumpDisplayConfigs(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.println("Display override configurations:");
        int displayCount = this.mActivityDisplays.size();
        for (int i = 0; i < displayCount; ++i) {
            ActivityDisplay activityDisplay = this.mActivityDisplays.valueAt(i);
            pw.print(prefix);
            pw.print("  ");
            pw.print(activityDisplay.mDisplayId);
            pw.print(": ");
            pw.println(activityDisplay.getOverrideConfiguration());
        }
    }

    ArrayList<ActivityRecord> getDumpActivitiesLocked(String name, boolean dumpVisibleStacksOnly, boolean dumpFocusedStackOnly) {
        if (dumpFocusedStackOnly) {
            return this.mFocusedStack.getDumpActivitiesLocked(name);
        }
        ArrayList<ActivityRecord> activities = new ArrayList<ActivityRecord>();
        int numDisplays = this.mActivityDisplays.size();
        for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.valueAt(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                if (dumpVisibleStacksOnly && !stack.shouldBeVisible(null)) continue;
                activities.addAll(stack.getDumpActivitiesLocked(name));
            }
        }
        return activities;
    }

    static boolean printThisActivity(PrintWriter pw, ActivityRecord activity, String dumpPackage, boolean needSep, String prefix) {
        if (activity != null && (dumpPackage == null || dumpPackage.equals(activity.packageName))) {
            if (needSep) {
                pw.println();
            }
            pw.print(prefix);
            pw.println(activity);
            return true;
        }
        return false;
    }

    boolean dumpActivitiesLocked(FileDescriptor fd, PrintWriter pw, boolean dumpAll, boolean dumpClient, String dumpPackage) {
        boolean printed = false;
        boolean needSep = false;
        for (int displayNdx = 0; displayNdx < this.mActivityDisplays.size(); ++displayNdx) {
            ActivityDisplay activityDisplay = this.mActivityDisplays.valueAt(displayNdx);
            pw.print("Display #");
            pw.print(activityDisplay.mDisplayId);
            pw.println(" (activities from top to bottom):");
            ActivityDisplay display = this.mActivityDisplays.valueAt(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                pw.println();
                pw.println("  Stack #" + stack.mStackId + ": type=" + WindowConfiguration.activityTypeToString(stack.getActivityType()) + " mode=" + WindowConfiguration.windowingModeToString(stack.getWindowingMode()));
                pw.println("  isSleeping=" + stack.shouldSleepActivities());
                pw.println("  mBounds=" + stack.getOverrideBounds());
                printed |= stack.dumpActivitiesLocked(fd, pw, dumpAll, dumpClient, dumpPackage, needSep);
                needSep = printed |= ActivityStackSupervisor.dumpHistoryList(fd, pw, stack.mLRUActivities, "    ", "Run", false, !dumpAll, false, dumpPackage, true, "    Running activities (most recent first):", null);
                boolean pr = ActivityStackSupervisor.printThisActivity(pw, stack.mPausingActivity, dumpPackage, needSep, "    mPausingActivity: ");
                if (pr) {
                    printed = true;
                    needSep = false;
                }
                if (pr = ActivityStackSupervisor.printThisActivity(pw, stack.getResumedActivity(), dumpPackage, needSep, "    mResumedActivity: ")) {
                    printed = true;
                    needSep = false;
                }
                if (dumpAll) {
                    pr = ActivityStackSupervisor.printThisActivity(pw, stack.mLastPausedActivity, dumpPackage, needSep, "    mLastPausedActivity: ");
                    if (pr) {
                        printed = true;
                        needSep = true;
                    }
                    printed |= ActivityStackSupervisor.printThisActivity(pw, stack.mLastNoHistoryActivity, dumpPackage, needSep, "    mLastNoHistoryActivity: ");
                }
                needSep = printed;
            }
        }
        printed |= ActivityStackSupervisor.dumpHistoryList(fd, pw, this.mFinishingActivities, "  ", "Fin", false, !dumpAll, false, dumpPackage, true, "  Activities waiting to finish:", null);
        printed |= ActivityStackSupervisor.dumpHistoryList(fd, pw, this.mStoppingActivities, "  ", "Stop", false, !dumpAll, false, dumpPackage, true, "  Activities waiting to stop:", null);
        printed |= ActivityStackSupervisor.dumpHistoryList(fd, pw, this.mActivitiesWaitingForVisibleActivity, "  ", "Wait", false, !dumpAll, false, dumpPackage, true, "  Activities waiting for another to become visible:", null);
        return printed |= ActivityStackSupervisor.dumpHistoryList(fd, pw, this.mGoingToSleepActivities, "  ", "Sleep", false, !dumpAll, false, dumpPackage, true, "  Activities waiting to sleep:", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean dumpHistoryList(FileDescriptor fd, PrintWriter pw, List<ActivityRecord> list, String prefix, String label, boolean complete, boolean brief, boolean client, String dumpPackage, boolean needNL, String header, TaskRecord lastTask) {
        String innerPrefix = null;
        String[] args = null;
        boolean printed = false;
        for (int i = list.size() - 1; i >= 0; --i) {
            boolean full;
            ActivityRecord r = list.get(i);
            if (dumpPackage != null && !dumpPackage.equals(r.packageName)) continue;
            if (innerPrefix == null) {
                innerPrefix = prefix + "      ";
                args = new String[]{};
            }
            printed = true;
            boolean bl = full = !brief && (complete || !r.isInHistory());
            if (needNL) {
                pw.println("");
                needNL = false;
            }
            if (header != null) {
                pw.println(header);
                header = null;
            }
            if (lastTask != r.getTask()) {
                lastTask = r.getTask();
                pw.print(prefix);
                pw.print(full ? "* " : "  ");
                pw.println(lastTask);
                if (full) {
                    lastTask.dump(pw, prefix + "  ");
                } else if (complete && lastTask.intent != null) {
                    pw.print(prefix);
                    pw.print("  ");
                    pw.println(lastTask.intent.toInsecureStringWithClip());
                }
            }
            pw.print(prefix);
            pw.print(full ? "  * " : "    ");
            pw.print(label);
            pw.print(" #");
            pw.print(i);
            pw.print(": ");
            pw.println(r);
            if (full) {
                r.dump(pw, innerPrefix);
            } else if (complete) {
                pw.print(innerPrefix);
                pw.println(r.intent.toInsecureString());
                if (r.app != null) {
                    pw.print(innerPrefix);
                    pw.println(r.app);
                }
            }
            if (!client || r.app == null || r.app.thread == null) continue;
            pw.flush();
            try {
                TransferPipe tp = new TransferPipe();
                try {
                    r.app.thread.dumpActivity(tp.getWriteFd(), r.appToken, innerPrefix, args);
                    tp.go(fd, 2000L);
                }
                finally {
                    tp.kill();
                }
            }
            catch (IOException e) {
                pw.println(innerPrefix + "Failure while dumping the activity: " + e);
            }
            catch (RemoteException e) {
                pw.println(innerPrefix + "Got a RemoteException while dumping the activity");
            }
            needNL = true;
        }
        return printed;
    }

    void scheduleIdleTimeoutLocked(ActivityRecord next) {
        Message msg = this.mHandler.obtainMessage(100, next);
        this.mHandler.sendMessageDelayed(msg, 10000L);
    }

    final void scheduleIdleLocked() {
        this.mHandler.sendEmptyMessage(101);
    }

    void removeTimeoutsForActivityLocked(ActivityRecord r) {
        this.mHandler.removeMessages(100, r);
    }

    final void scheduleResumeTopActivities() {
        if (!this.mHandler.hasMessages(102)) {
            this.mHandler.sendEmptyMessage(102);
        }
    }

    void removeSleepTimeouts() {
        this.mHandler.removeMessages(103);
    }

    final void scheduleSleepTimeout() {
        this.removeSleepTimeouts();
        this.mHandler.sendEmptyMessageDelayed(103, 5000L);
    }

    @Override
    public void onDisplayAdded(int displayId) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(105, displayId, 0));
    }

    @Override
    public void onDisplayRemoved(int displayId) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(107, displayId, 0));
    }

    @Override
    public void onDisplayChanged(int displayId) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(106, displayId, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDisplayAdded(int displayId) {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.getActivityDisplayOrCreateLocked(displayId);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    boolean isDisplayAdded(int displayId) {
        return this.getActivityDisplayOrCreateLocked(displayId) != null;
    }

    ActivityDisplay getActivityDisplay(int displayId) {
        return this.mActivityDisplays.get(displayId);
    }

    ActivityDisplay getDefaultDisplay() {
        return this.mActivityDisplays.get(0);
    }

    ActivityDisplay getActivityDisplayOrCreateLocked(int displayId) {
        ActivityDisplay activityDisplay = this.mActivityDisplays.get(displayId);
        if (activityDisplay != null) {
            return activityDisplay;
        }
        if (this.mDisplayManager == null) {
            return null;
        }
        Display display = this.mDisplayManager.getDisplay(displayId);
        if (display == null) {
            return null;
        }
        activityDisplay = new ActivityDisplay(this, display);
        this.attachDisplay(activityDisplay);
        this.calculateDefaultMinimalSizeOfResizeableTasks(activityDisplay);
        this.mWindowManager.onDisplayAdded(displayId);
        return activityDisplay;
    }

    @VisibleForTesting
    void attachDisplay(ActivityDisplay display) {
        this.mActivityDisplays.put(display.mDisplayId, display);
    }

    private void calculateDefaultMinimalSizeOfResizeableTasks(ActivityDisplay display) {
        this.mDefaultMinSizeOfResizeableTask = this.mService.mContext.getResources().getDimensionPixelSize(17105017);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void handleDisplayRemoved(int displayId) {
        ActivityDisplay activityDisplay;
        block5: {
            if (displayId == 0) {
                throw new IllegalArgumentException("Can't remove the primary display.");
            }
            ActivityManagerService activityManagerService = this.mService;
            // MONITORENTER : activityManagerService
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                activityDisplay = this.mActivityDisplays.get(displayId);
                if (activityDisplay != null) break block5;
                // MONITOREXIT : activityManagerService
            }
            catch (Throwable throwable) {
                // MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return;
        }
        activityDisplay.remove();
        this.releaseSleepTokens(activityDisplay);
        this.mActivityDisplays.remove(displayId);
        // MONITOREXIT : activityManagerService
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDisplayChanged(int displayId) {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                ActivityDisplay activityDisplay = this.mActivityDisplays.get(displayId);
                if (activityDisplay != null) {
                    if (displayId != 0) {
                        int displayState = activityDisplay.mDisplay.getState();
                        if (displayState == 1 && activityDisplay.mOffToken == null) {
                            activityDisplay.mOffToken = this.mService.acquireSleepToken("Display-off", displayId);
                        } else if (displayState == 2 && activityDisplay.mOffToken != null) {
                            activityDisplay.mOffToken.release();
                            activityDisplay.mOffToken = null;
                        }
                    }
                    activityDisplay.updateBounds();
                }
                this.mWindowManager.onDisplayChanged(displayId);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl20 : MonitorExitStatement: MONITOREXIT : var2_2
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    ActivityManagerInternal.SleepToken createSleepTokenLocked(String tag, int displayId) {
        ActivityDisplay display = this.mActivityDisplays.get(displayId);
        if (display == null) {
            throw new IllegalArgumentException("Invalid display: " + displayId);
        }
        SleepTokenImpl token = new SleepTokenImpl(tag, displayId);
        this.mSleepTokens.add(token);
        display.mAllSleepTokens.add(token);
        return token;
    }

    private void removeSleepTokenLocked(SleepTokenImpl token) {
        this.mSleepTokens.remove(token);
        ActivityDisplay display = this.mActivityDisplays.get(token.mDisplayId);
        if (display != null) {
            display.mAllSleepTokens.remove(token);
            if (display.mAllSleepTokens.isEmpty()) {
                this.mService.updateSleepIfNeededLocked();
            }
        }
    }

    private void releaseSleepTokens(ActivityDisplay display) {
        if (display.mAllSleepTokens.isEmpty()) {
            return;
        }
        for (ActivityManagerInternal.SleepToken token : display.mAllSleepTokens) {
            this.mSleepTokens.remove(token);
        }
        display.mAllSleepTokens.clear();
        this.mService.updateSleepIfNeededLocked();
    }

    private ActivityManager.StackInfo getStackInfo(ActivityStack stack) {
        int displayId = stack.mDisplayId;
        ActivityDisplay display = this.mActivityDisplays.get(displayId);
        ActivityManager.StackInfo info = new ActivityManager.StackInfo();
        stack.getWindowContainerBounds(info.bounds);
        info.displayId = displayId;
        info.stackId = stack.mStackId;
        info.userId = stack.mCurrentUser;
        info.visible = stack.shouldBeVisible(null);
        info.position = display != null ? display.getIndexOf(stack) : 0;
        info.configuration.setTo(stack.getConfiguration());
        ArrayList<TaskRecord> tasks = stack.getAllTasks();
        int numTasks = tasks.size();
        int[] taskIds = new int[numTasks];
        String[] taskNames = new String[numTasks];
        Rect[] taskBounds = new Rect[numTasks];
        int[] taskUserIds = new int[numTasks];
        for (int i = 0; i < numTasks; ++i) {
            TaskRecord task = tasks.get(i);
            taskIds[i] = task.taskId;
            taskNames[i] = task.origActivity != null ? task.origActivity.flattenToString() : (task.realActivity != null ? task.realActivity.flattenToString() : (task.getTopActivity() != null ? task.getTopActivity().packageName : "unknown"));
            taskBounds[i] = new Rect();
            task.getWindowContainerBounds(taskBounds[i]);
            taskUserIds[i] = task.userId;
        }
        info.taskIds = taskIds;
        info.taskNames = taskNames;
        info.taskBounds = taskBounds;
        info.taskUserIds = taskUserIds;
        ActivityRecord top = stack.topRunningActivityLocked();
        info.topActivity = top != null ? top.intent.getComponent() : null;
        return info;
    }

    ActivityManager.StackInfo getStackInfo(int stackId) {
        Object stack = this.getStack(stackId);
        if (stack != null) {
            return this.getStackInfo((ActivityStack)stack);
        }
        return null;
    }

    ActivityManager.StackInfo getStackInfo(int windowingMode, int activityType) {
        Object stack = this.getStack(windowingMode, activityType);
        return stack != null ? this.getStackInfo((ActivityStack)stack) : null;
    }

    ArrayList<ActivityManager.StackInfo> getAllStackInfosLocked() {
        ArrayList<ActivityManager.StackInfo> list = new ArrayList<ActivityManager.StackInfo>();
        for (int displayNdx = 0; displayNdx < this.mActivityDisplays.size(); ++displayNdx) {
            ActivityDisplay display = this.mActivityDisplays.valueAt(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                list.add(this.getStackInfo(stack));
            }
        }
        return list;
    }

    void handleNonResizableTaskIfNeeded(TaskRecord task, int preferredWindowingMode, int preferredDisplayId, ActivityStack actualStack) {
        this.handleNonResizableTaskIfNeeded(task, preferredWindowingMode, preferredDisplayId, actualStack, false);
    }

    void handleNonResizableTaskIfNeeded(TaskRecord task, int preferredWindowingMode, int preferredDisplayId, ActivityStack actualStack, boolean forceNonResizable) {
        boolean inSplitScreenMode;
        boolean isSecondaryDisplayPreferred = preferredDisplayId != 0 && preferredDisplayId != -1;
        boolean bl = inSplitScreenMode = actualStack != null && actualStack.getDisplay().hasSplitScreenPrimaryStack();
        if (!inSplitScreenMode && preferredWindowingMode != 3 && !isSecondaryDisplayPreferred || !task.isActivityTypeStandardOrUndefined()) {
            return;
        }
        if (isSecondaryDisplayPreferred) {
            int actualDisplayId = ((ActivityStack)task.getStack()).mDisplayId;
            if (!task.canBeLaunchedOnDisplay(actualDisplayId)) {
                throw new IllegalStateException("Task resolved to incompatible display");
            }
            this.mService.setTaskWindowingMode(task.taskId, 4, true);
            if (preferredDisplayId != actualDisplayId) {
                this.mService.mTaskChangeNotificationController.notifyActivityLaunchOnSecondaryDisplayFailed();
                return;
            }
        }
        if (!task.supportsSplitScreenWindowingMode() || forceNonResizable) {
            this.mService.mTaskChangeNotificationController.notifyActivityDismissingDockedStack();
            ActivityStack dockedStack = ((ActivityStack)task.getStack()).getDisplay().getSplitScreenPrimaryStack();
            if (dockedStack != null) {
                this.moveTasksToFullscreenStackLocked(dockedStack, actualStack == dockedStack);
            }
            return;
        }
        ActivityRecord topActivity = task.getTopActivity();
        if (topActivity != null && topActivity.isNonResizableOrForcedResizable() && !topActivity.noDisplay) {
            String packageName = topActivity.appInfo.packageName;
            int reason = isSecondaryDisplayPreferred ? 2 : 1;
            this.mService.mTaskChangeNotificationController.notifyActivityForcedResizable(task.taskId, reason, packageName);
        }
    }

    void activityRelaunchedLocked(IBinder token) {
        this.mWindowManager.notifyAppRelaunchingFinished(token);
        ActivityRecord r = ActivityRecord.isInStackLocked(token);
        if (r != null && ((ActivityStack)r.getStack()).shouldSleepOrShutDownActivities()) {
            r.setSleeping(true, true);
        }
    }

    void activityRelaunchingLocked(ActivityRecord r) {
        this.mWindowManager.notifyAppRelaunching(r.appToken);
    }

    void logStackState() {
        this.mActivityMetricsLogger.logWindowState();
    }

    void scheduleUpdateMultiWindowMode(TaskRecord task) {
        if (((ActivityStack)task.getStack()).deferScheduleMultiWindowModeChanged()) {
            return;
        }
        for (int i = task.mActivities.size() - 1; i >= 0; --i) {
            ActivityRecord r = task.mActivities.get(i);
            if (r.app == null || r.app.thread == null) continue;
            this.mMultiWindowModeChangedActivities.add(r);
        }
        if (!this.mHandler.hasMessages(114)) {
            this.mHandler.sendEmptyMessage(114);
        }
    }

    void scheduleUpdatePictureInPictureModeIfNeeded(TaskRecord task, ActivityStack prevStack) {
        Object stack = task.getStack();
        if (prevStack == null || prevStack == stack || !prevStack.inPinnedWindowingMode() && !((ConfigurationContainer)stack).inPinnedWindowingMode()) {
            return;
        }
        this.scheduleUpdatePictureInPictureModeIfNeeded(task, ((ConfigurationContainer)stack).getOverrideBounds());
    }

    void scheduleUpdatePictureInPictureModeIfNeeded(TaskRecord task, Rect targetStackBounds) {
        for (int i = task.mActivities.size() - 1; i >= 0; --i) {
            ActivityRecord r = task.mActivities.get(i);
            if (r.app == null || r.app.thread == null) continue;
            this.mPipModeChangedActivities.add(r);
            this.mMultiWindowModeChangedActivities.remove(r);
        }
        this.mPipModeChangedTargetStackBounds = targetStackBounds;
        if (!this.mHandler.hasMessages(115)) {
            this.mHandler.sendEmptyMessage(115);
        }
    }

    void updatePictureInPictureMode(TaskRecord task, Rect targetStackBounds, boolean forceUpdate) {
        this.mHandler.removeMessages(115);
        for (int i = task.mActivities.size() - 1; i >= 0; --i) {
            ActivityRecord r = task.mActivities.get(i);
            if (r.app == null || r.app.thread == null) continue;
            r.updatePictureInPictureMode(targetStackBounds, forceUpdate);
        }
    }

    void setDockedStackMinimized(boolean minimized) {
        ActivityStack current;
        this.mIsDockMinimized = minimized;
        if (this.mIsDockMinimized && (current = this.getFocusedStack()).inSplitScreenPrimaryWindowingMode()) {
            current.adjustFocusToNextFocusableStack("setDockedStackMinimized");
        }
    }

    void wakeUp(String reason) {
        this.mPowerManager.wakeUp(SystemClock.uptimeMillis(), "android.server.am:TURN_ON:" + reason);
    }

    private void beginDeferResume() {
        ++this.mDeferResumeCount;
    }

    private void endDeferResume() {
        --this.mDeferResumeCount;
    }

    private boolean readyToResume() {
        return this.mDeferResumeCount == 0;
    }

    ActivityStack findStackBehind(ActivityStack stack) {
        ActivityDisplay display = this.mActivityDisplays.get(0);
        if (display == null) {
            return null;
        }
        for (int i = display.getChildCount() - 1; i >= 0; --i) {
            if (display.getChildAt(i) != stack || i <= 0) continue;
            return display.getChildAt(i - 1);
        }
        throw new IllegalStateException("Failed to find a stack behind stack=" + stack + " in=" + display);
    }

    void setResizingDuringAnimation(TaskRecord task) {
        this.mResizingTasksDuringAnimation.add(task.taskId);
        task.setTaskDockedResizing(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int startActivityFromRecents(int callingPid, int callingUid, int taskId, SafeActivityOptions options) {
        ActivityOptions activityOptions;
        TaskRecord task = null;
        int activityType = 0;
        int windowingMode = 0;
        ActivityOptions activityOptions2 = activityOptions = options != null ? options.getOptions(this) : null;
        if (activityOptions != null) {
            activityType = activityOptions.getLaunchActivityType();
            windowingMode = activityOptions.getLaunchWindowingMode();
        }
        if (activityType == 2 || activityType == 3) {
            throw new IllegalArgumentException("startActivityFromRecents: Task " + taskId + " can't be launch in the home/recents stack.");
        }
        this.mWindowManager.deferSurfaceLayout();
        try {
            if (windowingMode == 3) {
                this.mWindowManager.setDockedStackCreateState(activityOptions.getSplitScreenCreateMode(), null);
                this.deferUpdateRecentsHomeStackBounds();
                this.mWindowManager.prepareAppTransition(19, false);
            }
            if ((task = this.anyTaskForIdLocked(taskId, 2, activityOptions, true)) == null) {
                this.continueUpdateRecentsHomeStackBounds();
                this.mWindowManager.executeAppTransition();
                throw new IllegalArgumentException("startActivityFromRecents: Task " + taskId + " not found.");
            }
            if (windowingMode != 3) {
                this.moveHomeStackToFront("startActivityFromRecents");
            }
            if (!this.mService.mUserController.shouldConfirmCredentials(task.userId) && task.getRootActivity() != null) {
                ActivityRecord targetActivity = task.getTopActivity();
                this.sendPowerHintForLaunchStartIfNeeded(true, targetActivity);
                this.mActivityMetricsLogger.notifyActivityLaunching();
                try {
                    this.mService.moveTaskToFrontLocked(task.taskId, 0, options, true);
                }
                finally {
                    this.mActivityMetricsLogger.notifyActivityLaunched(2, targetActivity);
                }
                this.mService.getActivityStartController().postStartActivityProcessingForLastStarter(task.getTopActivity(), 2, (ActivityStack)task.getStack());
                int n = 2;
                return n;
            }
            String callingPackage = task.mCallingPackage;
            Intent intent = task.intent;
            intent.addFlags(0x100000);
            int userId = task.userId;
            int n = this.mService.getActivityStartController().startActivityInPackage(task.mCallingUid, callingPid, callingUid, callingPackage, intent, null, null, null, 0, 0, options, userId, task, "startActivityFromRecents", false);
            return n;
        }
        finally {
            if (windowingMode == 3 && task != null) {
                this.setResizingDuringAnimation(task);
                ActivityDisplay display = ((ActivityStack)task.getStack()).getDisplay();
                ActivityStack topSecondaryStack = display.getTopStackInWindowingMode(4);
                if (topSecondaryStack.isActivityTypeHome()) {
                    this.moveHomeStackToFront("startActivityFromRecents: homeVisibleInSplitScreen");
                    this.mWindowManager.checkSplitScreenMinimizedChanged(false);
                }
            }
            this.mWindowManager.continueSurfaceLayout();
        }
    }

    List<IBinder> getTopVisibleActivities() {
        ArrayList<IBinder> topActivityTokens = new ArrayList<IBinder>();
        for (int i = this.mActivityDisplays.size() - 1; i >= 0; --i) {
            ActivityDisplay display = this.mActivityDisplays.valueAt(i);
            for (int j = display.getChildCount() - 1; j >= 0; --j) {
                ActivityRecord top;
                ActivityStack stack = display.getChildAt(j);
                if (!stack.shouldBeVisible(null) || (top = stack.getTopActivity()) == null) continue;
                if (stack == this.mFocusedStack) {
                    topActivityTokens.add(0, top.appToken);
                    continue;
                }
                topActivityTokens.add(top.appToken);
            }
        }
        return topActivityTokens;
    }

    static {
        ACTION_TO_RUNTIME_PERMISSION.put("android.media.action.IMAGE_CAPTURE", "android.permission.CAMERA");
        ACTION_TO_RUNTIME_PERMISSION.put("android.media.action.VIDEO_CAPTURE", "android.permission.CAMERA");
        ACTION_TO_RUNTIME_PERMISSION.put("android.intent.action.CALL", "android.permission.CALL_PHONE");
    }

    private final class SleepTokenImpl
    extends ActivityManagerInternal.SleepToken {
        private final String mTag;
        private final long mAcquireTime;
        private final int mDisplayId;

        public SleepTokenImpl(String tag, int displayId) {
            this.mTag = tag;
            this.mDisplayId = displayId;
            this.mAcquireTime = SystemClock.uptimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            ActivityManagerService activityManagerService = ActivityStackSupervisor.this.mService;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    ActivityStackSupervisor.this.removeSleepTokenLocked(this);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }

        public String toString() {
            return "{\"" + this.mTag + "\", display " + this.mDisplayId + ", acquire at " + TimeUtils.formatUptime(this.mAcquireTime) + "}";
        }
    }

    static class WaitInfo {
        private final ComponentName mTargetComponent;
        private final WaitResult mResult;

        public WaitInfo(ComponentName targetComponent, WaitResult result) {
            this.mTargetComponent = targetComponent;
            this.mResult = result;
        }

        public boolean matches(ComponentName targetComponent) {
            return this.mTargetComponent == null || this.mTargetComponent.equals(targetComponent);
        }

        public WaitResult getResult() {
            return this.mResult;
        }

        public ComponentName getComponent() {
            return this.mTargetComponent;
        }

        public void dump(PrintWriter pw, String prefix) {
            pw.println(prefix + "WaitInfo:");
            pw.println(prefix + "  mTargetComponent=" + this.mTargetComponent);
            pw.println(prefix + "  mResult=");
            this.mResult.dump(pw, prefix);
        }
    }

    private final class ActivityStackSupervisorHandler
    extends Handler {
        public ActivityStackSupervisorHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void activityIdleInternal(ActivityRecord r, boolean processPausingActivities) {
            ActivityManagerService activityManagerService = ActivityStackSupervisor.this.mService;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    ActivityStackSupervisor.this.activityIdleInternalLocked(r != null ? r.appToken : null, true, processPausingActivities, null);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var3_3
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 114: {
                    ActivityManagerService activityManagerService = ActivityStackSupervisor.this.mService;
                    synchronized (activityManagerService) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            for (int i = ActivityStackSupervisor.this.mMultiWindowModeChangedActivities.size() - 1; i >= 0; --i) {
                                ActivityRecord r = ActivityStackSupervisor.this.mMultiWindowModeChangedActivities.remove(i);
                                r.updateMultiWindowMode();
                            }
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[6, 25, 12, 13] lbl14 : MonitorExitStatement: MONITOREXIT : activityManagerService
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                case 115: {
                    ActivityManagerService activityManagerService = ActivityStackSupervisor.this.mService;
                    synchronized (activityManagerService) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            for (int i = ActivityStackSupervisor.this.mPipModeChangedActivities.size() - 1; i >= 0; --i) {
                                ActivityRecord r = ActivityStackSupervisor.this.mPipModeChangedActivities.remove(i);
                                r.updatePictureInPictureMode(ActivityStackSupervisor.this.mPipModeChangedTargetStackBounds, false);
                            }
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[7, 26, 12, 14] lbl31 : MonitorExitStatement: MONITOREXIT : activityManagerService
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                case 100: {
                    this.activityIdleInternal((ActivityRecord)msg.obj, true);
                    return;
                }
                case 101: {
                    this.activityIdleInternal((ActivityRecord)msg.obj, false);
                    return;
                }
                case 102: {
                    ActivityManagerService activityManagerService = ActivityStackSupervisor.this.mService;
                    synchronized (activityManagerService) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            ActivityStackSupervisor.this.resumeFocusedStackTopActivityLocked();
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[17, 8, 27, 12] lbl52 : MonitorExitStatement: MONITOREXIT : activityManagerService
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                case 103: {
                    ActivityManagerService activityManagerService = ActivityStackSupervisor.this.mService;
                    synchronized (activityManagerService) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            if (ActivityStackSupervisor.this.mService.isSleepingOrShuttingDownLocked()) {
                                Slog.w("ActivityManager", "Sleep timeout!  Sleeping now.");
                                ActivityStackSupervisor.this.checkReadyForSleepLocked(false);
                            }
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[18, 9, 28, 12] lbl69 : MonitorExitStatement: MONITOREXIT : activityManagerService
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                case 104: {
                    ActivityManagerService activityManagerService = ActivityStackSupervisor.this.mService;
                    synchronized (activityManagerService) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            if (ActivityStackSupervisor.this.mLaunchingActivity.isHeld()) {
                                Slog.w("ActivityManager", "Launch timeout has expired, giving up wake lock!");
                                ActivityStackSupervisor.this.mLaunchingActivity.release();
                            }
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[19, 10, 12, 29] lbl86 : MonitorExitStatement: MONITOREXIT : activityManagerService
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                case 105: {
                    ActivityStackSupervisor.this.handleDisplayAdded(msg.arg1);
                    return;
                }
                case 106: {
                    ActivityStackSupervisor.this.handleDisplayChanged(msg.arg1);
                    return;
                }
                case 107: {
                    ActivityStackSupervisor.this.handleDisplayRemoved(msg.arg1);
                    return;
                }
                case 112: {
                    ActivityManagerService activityManagerService = ActivityStackSupervisor.this.mService;
                    synchronized (activityManagerService) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            ActivityRecord r = ActivityRecord.forTokenLocked((IBinder)msg.obj);
                            if (r != null) {
                                ActivityStackSupervisor.this.handleLaunchTaskBehindCompleteLocked(r);
                            }
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[23, 11, 12, 30] lbl111 : MonitorExitStatement: MONITOREXIT : activityManagerService
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
            }
        }
    }

    static class PendingActivityLaunch {
        final ActivityRecord r;
        final ActivityRecord sourceRecord;
        final int startFlags;
        final ActivityStack stack;
        final ProcessRecord callerApp;

        PendingActivityLaunch(ActivityRecord _r, ActivityRecord _sourceRecord, int _startFlags, ActivityStack _stack, ProcessRecord _callerApp) {
            this.r = _r;
            this.sourceRecord = _sourceRecord;
            this.startFlags = _startFlags;
            this.stack = _stack;
            this.callerApp = _callerApp;
        }

        void sendErrorResult(String message) {
            try {
                if (this.callerApp.thread != null) {
                    this.callerApp.thread.scheduleCrash(message);
                }
            }
            catch (RemoteException e) {
                Slog.e("ActivityManager", "Exception scheduling crash of failed activity launcher sourceRecord=" + this.sourceRecord, e);
            }
        }
    }

    static class FindTaskResult {
        ActivityRecord r;
        boolean matchedByRootAffinity;

        FindTaskResult() {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AnyTaskForIdMatchTaskMode {
    }
}

