/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.app.ActivityThread;
import android.app.ApplicationErrorReport;
import android.app.Dialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.EventLog;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.StatsLog;
import android.util.TimeUtils;
import android.util.proto.ProtoOutputStream;
import com.android.internal.app.ProcessMap;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.os.ProcessCpuTracker;
import com.android.server.RescueParty;
import com.android.server.Watchdog;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityRecord;
import com.android.server.am.AppErrorDialog;
import com.android.server.am.AppErrorResult;
import com.android.server.am.AppNotRespondingDialog;
import com.android.server.am.ProcessRecord;
import com.android.server.am.SafeActivityOptions;
import com.android.server.am.ServiceRecord;
import com.android.server.am.TaskRecord;
import java.io.File;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;

class AppErrors {
    private static final String TAG = "ActivityManager";
    private final ActivityManagerService mService;
    private final Context mContext;
    private ArraySet<String> mAppsNotReportingCrashes;
    private final ProcessMap<Long> mProcessCrashTimes = new ProcessMap();
    private final ProcessMap<Long> mProcessCrashTimesPersistent = new ProcessMap();
    private final ProcessMap<BadProcessInfo> mBadProcesses = new ProcessMap();

    AppErrors(Context context, ActivityManagerService service) {
        context.assertRuntimeOverlayThemable();
        this.mService = service;
        this.mContext = context;
    }

    void writeToProto(ProtoOutputStream proto, long fieldId, String dumpPackage) {
        ProcessRecord r;
        int puid;
        int i;
        int uidCount;
        SparseArray<Object> uids;
        String pname;
        int ip;
        ArrayMap<String, SparseArray<Object>> pmap;
        if (this.mProcessCrashTimes.getMap().isEmpty() && this.mBadProcesses.getMap().isEmpty()) {
            return;
        }
        long token = proto.start(fieldId);
        long now = SystemClock.uptimeMillis();
        proto.write(0x10300000001L, now);
        if (!this.mProcessCrashTimes.getMap().isEmpty()) {
            pmap = this.mProcessCrashTimes.getMap();
            int procCount = pmap.size();
            for (ip = 0; ip < procCount; ++ip) {
                long ctoken = proto.start(0x20B00000002L);
                pname = pmap.keyAt(ip);
                uids = pmap.valueAt(ip);
                uidCount = uids.size();
                proto.write(0x10900000001L, pname);
                for (i = 0; i < uidCount; ++i) {
                    puid = uids.keyAt(i);
                    r = this.mService.mProcessNames.get(pname, puid);
                    if (dumpPackage != null && (r == null || !r.pkgList.containsKey(dumpPackage))) continue;
                    long etoken = proto.start(0x20B00000002L);
                    proto.write(0x10500000001L, puid);
                    proto.write(1112396529666L, (Long)uids.valueAt(i));
                    proto.end(etoken);
                }
                proto.end(ctoken);
            }
        }
        if (!this.mBadProcesses.getMap().isEmpty()) {
            pmap = this.mBadProcesses.getMap();
            int processCount = pmap.size();
            for (ip = 0; ip < processCount; ++ip) {
                long btoken = proto.start(2246267895811L);
                pname = pmap.keyAt(ip);
                uids = pmap.valueAt(ip);
                uidCount = uids.size();
                proto.write(0x10900000001L, pname);
                for (i = 0; i < uidCount; ++i) {
                    puid = uids.keyAt(i);
                    r = this.mService.mProcessNames.get(pname, puid);
                    if (dumpPackage != null && (r == null || !r.pkgList.containsKey(dumpPackage))) continue;
                    BadProcessInfo info = (BadProcessInfo)uids.valueAt(i);
                    long etoken = proto.start(0x20B00000002L);
                    proto.write(0x10500000001L, puid);
                    proto.write(1112396529666L, info.time);
                    proto.write(1138166333443L, info.shortMsg);
                    proto.write(1138166333444L, info.longMsg);
                    proto.write(1138166333445L, info.stack);
                    proto.end(etoken);
                }
                proto.end(btoken);
            }
        }
        proto.end(token);
    }

    boolean dumpLocked(FileDescriptor fd, PrintWriter pw, boolean needSep, String dumpPackage) {
        boolean printed;
        if (!this.mProcessCrashTimes.getMap().isEmpty()) {
            printed = false;
            long now = SystemClock.uptimeMillis();
            ArrayMap<String, SparseArray<Long>> pmap = this.mProcessCrashTimes.getMap();
            int processCount = pmap.size();
            for (int ip = 0; ip < processCount; ++ip) {
                String pname = pmap.keyAt(ip);
                SparseArray<Long> uids = pmap.valueAt(ip);
                int uidCount = uids.size();
                for (int i = 0; i < uidCount; ++i) {
                    int puid = uids.keyAt(i);
                    ProcessRecord r = this.mService.mProcessNames.get(pname, puid);
                    if (dumpPackage != null && (r == null || !r.pkgList.containsKey(dumpPackage))) continue;
                    if (!printed) {
                        if (needSep) {
                            pw.println();
                        }
                        needSep = true;
                        pw.println("  Time since processes crashed:");
                        printed = true;
                    }
                    pw.print("    Process ");
                    pw.print(pname);
                    pw.print(" uid ");
                    pw.print(puid);
                    pw.print(": last crashed ");
                    TimeUtils.formatDuration(now - uids.valueAt(i), pw);
                    pw.println(" ago");
                }
            }
        }
        if (!this.mBadProcesses.getMap().isEmpty()) {
            printed = false;
            ArrayMap<String, SparseArray<BadProcessInfo>> pmap = this.mBadProcesses.getMap();
            int processCount = pmap.size();
            for (int ip = 0; ip < processCount; ++ip) {
                String pname = pmap.keyAt(ip);
                SparseArray<BadProcessInfo> uids = pmap.valueAt(ip);
                int uidCount = uids.size();
                for (int i = 0; i < uidCount; ++i) {
                    int puid = uids.keyAt(i);
                    ProcessRecord r = this.mService.mProcessNames.get(pname, puid);
                    if (dumpPackage != null && (r == null || !r.pkgList.containsKey(dumpPackage))) continue;
                    if (!printed) {
                        if (needSep) {
                            pw.println();
                        }
                        needSep = true;
                        pw.println("  Bad processes:");
                        printed = true;
                    }
                    BadProcessInfo info = uids.valueAt(i);
                    pw.print("    Bad process ");
                    pw.print(pname);
                    pw.print(" uid ");
                    pw.print(puid);
                    pw.print(": crashed at time ");
                    pw.println(info.time);
                    if (info.shortMsg != null) {
                        pw.print("      Short msg: ");
                        pw.println(info.shortMsg);
                    }
                    if (info.longMsg != null) {
                        pw.print("      Long msg: ");
                        pw.println(info.longMsg);
                    }
                    if (info.stack == null) continue;
                    pw.println("      Stack:");
                    int lastPos = 0;
                    for (int pos = 0; pos < info.stack.length(); ++pos) {
                        if (info.stack.charAt(pos) != '\n') continue;
                        pw.print("        ");
                        pw.write(info.stack, lastPos, pos - lastPos);
                        pw.println();
                        lastPos = pos + 1;
                    }
                    if (lastPos >= info.stack.length()) continue;
                    pw.print("        ");
                    pw.write(info.stack, lastPos, info.stack.length() - lastPos);
                    pw.println();
                }
            }
        }
        return needSep;
    }

    boolean isBadProcessLocked(ApplicationInfo info) {
        return this.mBadProcesses.get(info.processName, info.uid) != null;
    }

    void clearBadProcessLocked(ApplicationInfo info) {
        this.mBadProcesses.remove(info.processName, info.uid);
    }

    void resetProcessCrashTimeLocked(ApplicationInfo info) {
        this.mProcessCrashTimes.remove(info.processName, info.uid);
    }

    void resetProcessCrashTimeLocked(boolean resetEntireUser, int appId, int userId) {
        ArrayMap<String, SparseArray<Long>> pmap = this.mProcessCrashTimes.getMap();
        for (int ip = pmap.size() - 1; ip >= 0; --ip) {
            SparseArray<Long> ba = pmap.valueAt(ip);
            for (int i = ba.size() - 1; i >= 0; --i) {
                boolean remove = false;
                int entUid = ba.keyAt(i);
                if (!resetEntireUser) {
                    if (userId == -1) {
                        if (UserHandle.getAppId(entUid) == appId) {
                            remove = true;
                        }
                    } else if (entUid == UserHandle.getUid(userId, appId)) {
                        remove = true;
                    }
                } else if (UserHandle.getUserId(entUid) == userId) {
                    remove = true;
                }
                if (!remove) continue;
                ba.removeAt(i);
            }
            if (ba.size() != 0) continue;
            pmap.removeAt(ip);
        }
    }

    void loadAppsNotReportingCrashesFromConfigLocked(String appsNotReportingCrashesConfig) {
        String[] split;
        if (appsNotReportingCrashesConfig != null && (split = appsNotReportingCrashesConfig.split(",")).length > 0) {
            this.mAppsNotReportingCrashes = new ArraySet();
            Collections.addAll(this.mAppsNotReportingCrashes, split);
        }
    }

    void killAppAtUserRequestLocked(ProcessRecord app, Dialog fromDialog) {
        app.crashing = false;
        app.crashingReport = null;
        app.notResponding = false;
        app.notRespondingReport = null;
        if (app.anrDialog == fromDialog) {
            app.anrDialog = null;
        }
        if (app.waitDialog == fromDialog) {
            app.waitDialog = null;
        }
        if (app.pid > 0 && app.pid != ActivityManagerService.MY_PID) {
            this.handleAppCrashLocked(app, "user-terminated", null, null, null, null);
            app.kill("user request after error", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleAppCrashLocked(int uid, int initialPid, String packageName, int userId, String message) {
        ProcessRecord proc = null;
        SparseArray<ProcessRecord> sparseArray = this.mService.mPidsSelfLocked;
        synchronized (sparseArray) {
            for (int i = 0; i < this.mService.mPidsSelfLocked.size(); ++i) {
                ProcessRecord p = this.mService.mPidsSelfLocked.valueAt(i);
                if (uid >= 0 && p.uid != uid) continue;
                if (p.pid == initialPid) {
                    proc = p;
                    break;
                }
                if (!p.pkgList.containsKey(packageName) || userId >= 0 && p.userId != userId) continue;
                proc = p;
            }
        }
        if (proc == null) {
            Slog.w(TAG, "crashApplication: nothing for uid=" + uid + " initialPid=" + initialPid + " packageName=" + packageName + " userId=" + userId);
            return;
        }
        proc.scheduleCrash(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void crashApplication(ProcessRecord r, ApplicationErrorReport.CrashInfo crashInfo) {
        int callingPid = Binder.getCallingPid();
        int callingUid = Binder.getCallingUid();
        long origId = Binder.clearCallingIdentity();
        try {
            this.crashApplicationInner(r, crashInfo, callingPid, callingUid);
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    void crashApplicationInner(ProcessRecord r, ApplicationErrorReport.CrashInfo crashInfo, int callingPid, int callingUid) {
        timeMillis = System.currentTimeMillis();
        shortMsg = crashInfo.exceptionClassName;
        longMsg = crashInfo.exceptionMessage;
        stackTrace = crashInfo.stackTrace;
        if (shortMsg != null && longMsg != null) {
            longMsg = shortMsg + ": " + longMsg;
        } else if (shortMsg != null) {
            longMsg = shortMsg;
        }
        if (r != null && r.persistent) {
            RescueParty.notePersistentAppCrash(this.mContext, r.uid);
        }
        result = new AppErrorResult();
        var12_10 = this.mService;
        synchronized (var12_10) {
            ActivityManagerService.boostPriorityForLockedSection();
            if (!this.handleAppCrashInActivityController(r, crashInfo, shortMsg, longMsg, stackTrace, timeMillis, callingPid, callingUid)) ** break block31
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return;
        {
            if (r == null || r.instr == null) ** break block32
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return;
        {
            if (r != null) {
                this.mService.mBatteryStatsService.noteProcessCrash(r.processName, r.uid);
            }
            data = new AppErrorDialog.Data();
            data.result = result;
            data.proc = r;
            if (r != null && this.makeAppCrashingLocked(r, shortMsg, longMsg, stackTrace, data)) ** break block33
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return;
        {
            try {
                msg /* !! */  = Message.obtain();
                msg /* !! */ .what = 1;
                task = data.task;
                msg /* !! */ .obj = data;
                this.mService.mUiHandler.sendMessage(msg /* !! */ );
            }
            catch (Throwable var15_16) {
                // MONITOREXIT @DISABLED, blocks:[8, 10] lbl46 : MonitorExitStatement: MONITOREXIT : var12_10
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw var15_16;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        res = result.get();
        appErrorIntent = null;
        MetricsLogger.action(this.mContext, 316, res);
        if (res == 6 || res == 7) {
            res = 1;
        }
        msg /* !! */  = this.mService;
        synchronized (msg /* !! */ ) {
            try {
                block34: {
                    ActivityManagerService.boostPriorityForLockedSection();
                    if (res == 5) {
                        this.stopReportingCrashesLocked(r);
                    }
                    if (res == 3) {
                        this.mService.removeProcessLocked(r, false, true, "crash");
                        if (task != null) {
                            try {
                                this.mService.startActivityFromRecents(task.taskId, ActivityOptions.makeBasic().toBundle());
                            }
                            catch (IllegalArgumentException e) {
                                v0 = cats = task.intent != null ? task.intent.getCategories() : null;
                                if (cats == null || !cats.contains("android.intent.category.LAUNCHER")) break block34;
                                this.mService.getActivityStartController().startActivityInPackage(task.mCallingUid, callingPid, callingUid, task.mCallingPackage, task.intent, null, null, null, 0, 0, new SafeActivityOptions(ActivityOptions.makeBasic()), task.userId, null, "AppErrors", false);
                            }
                        }
                    }
                }
                if (res == 1) {
                    orig = Binder.clearCallingIdentity();
                    try {
                        this.mService.mStackSupervisor.handleAppCrashLocked(r);
                        if (!r.persistent) {
                            this.mService.removeProcessLocked(r, false, false, "crash");
                            this.mService.mStackSupervisor.resumeFocusedStackTopActivityLocked();
                        }
                    }
                    finally {
                        Binder.restoreCallingIdentity(orig);
                    }
                }
                if (res == 8) {
                    appErrorIntent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
                    appErrorIntent.setData(Uri.parse("package:" + r.info.packageName));
                    appErrorIntent.addFlags(0x10000000);
                }
                if (res == 2) {
                    appErrorIntent = this.createAppErrorIntentLocked(r, timeMillis, crashInfo);
                }
                if (r != null && !r.isolated && res != 3) {
                    this.mProcessCrashTimes.put(r.info.processName, r.uid, SystemClock.uptimeMillis());
                }
            }
            catch (Throwable var18_21) {
                // MONITOREXIT @DISABLED, blocks:[9, 13] lbl102 : MonitorExitStatement: MONITOREXIT : msg /* !! */ 
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw var18_21;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        if (appErrorIntent != null) {
            try {
                this.mContext.startActivityAsUser(appErrorIntent, new UserHandle(r.userId));
            }
            catch (ActivityNotFoundException e) {
                Slog.w("ActivityManager", "bug report receiver dissappeared", e);
            }
        }
    }

    private boolean handleAppCrashInActivityController(ProcessRecord r, ApplicationErrorReport.CrashInfo crashInfo, String shortMsg, String longMsg, String stackTrace, long timeMillis, int callingPid, int callingUid) {
        if (this.mService.mController == null) {
            return false;
        }
        try {
            int uid;
            String name = r != null ? r.processName : null;
            int pid = r != null ? r.pid : callingPid;
            int n = uid = r != null ? r.info.uid : callingUid;
            if (!this.mService.mController.appCrashed(name, pid, shortMsg, longMsg, timeMillis, crashInfo.stackTrace)) {
                if ("1".equals(SystemProperties.get("ro.debuggable", "0")) && "Native crash".equals(crashInfo.exceptionClassName)) {
                    Slog.w(TAG, "Skip killing native crashed app " + name + "(" + pid + ") during testing");
                } else {
                    Slog.w(TAG, "Force-killing crashed app " + name + " at watcher's request");
                    if (r != null) {
                        if (!this.makeAppCrashingLocked(r, shortMsg, longMsg, stackTrace, null)) {
                            r.kill("crash", true);
                        }
                    } else {
                        Process.killProcess(pid);
                        ActivityManagerService.killProcessGroup(uid, pid);
                    }
                }
                return true;
            }
        }
        catch (RemoteException e) {
            this.mService.mController = null;
            Watchdog.getInstance().setActivityController(null);
        }
        return false;
    }

    private boolean makeAppCrashingLocked(ProcessRecord app, String shortMsg, String longMsg, String stackTrace, AppErrorDialog.Data data) {
        app.crashing = true;
        app.crashingReport = this.generateProcessError(app, 1, null, shortMsg, longMsg, stackTrace);
        this.startAppProblemLocked(app);
        app.stopFreezingAllLocked();
        return this.handleAppCrashLocked(app, "force-crash", shortMsg, longMsg, stackTrace, data);
    }

    void startAppProblemLocked(ProcessRecord app) {
        app.errorReportReceiver = null;
        for (int userId : this.mService.mUserController.getCurrentProfileIds()) {
            if (app.userId != userId) continue;
            app.errorReportReceiver = ApplicationErrorReport.getErrorReportReceiver(this.mContext, app.info.packageName, app.info.flags);
        }
        this.mService.skipCurrentReceiverLocked(app);
    }

    private ActivityManager.ProcessErrorStateInfo generateProcessError(ProcessRecord app, int condition, String activity, String shortMsg, String longMsg, String stackTrace) {
        ActivityManager.ProcessErrorStateInfo report = new ActivityManager.ProcessErrorStateInfo();
        report.condition = condition;
        report.processName = app.processName;
        report.pid = app.pid;
        report.uid = app.info.uid;
        report.tag = activity;
        report.shortMsg = shortMsg;
        report.longMsg = longMsg;
        report.stackTrace = stackTrace;
        return report;
    }

    Intent createAppErrorIntentLocked(ProcessRecord r, long timeMillis, ApplicationErrorReport.CrashInfo crashInfo) {
        ApplicationErrorReport report = this.createAppErrorReportLocked(r, timeMillis, crashInfo);
        if (report == null) {
            return null;
        }
        Intent result = new Intent("android.intent.action.APP_ERROR");
        result.setComponent(r.errorReportReceiver);
        result.putExtra("android.intent.extra.BUG_REPORT", report);
        result.addFlags(0x10000000);
        return result;
    }

    private ApplicationErrorReport createAppErrorReportLocked(ProcessRecord r, long timeMillis, ApplicationErrorReport.CrashInfo crashInfo) {
        if (r.errorReportReceiver == null) {
            return null;
        }
        if (!(r.crashing || r.notResponding || r.forceCrashReport)) {
            return null;
        }
        ApplicationErrorReport report = new ApplicationErrorReport();
        report.packageName = r.info.packageName;
        report.installerPackageName = r.errorReportReceiver.getPackageName();
        report.processName = r.processName;
        report.time = timeMillis;
        boolean bl = report.systemApp = (r.info.flags & 1) != 0;
        if (r.crashing || r.forceCrashReport) {
            report.type = 1;
            report.crashInfo = crashInfo;
        } else if (r.notResponding) {
            report.type = 2;
            report.anrInfo = new ApplicationErrorReport.AnrInfo();
            report.anrInfo.activity = r.notRespondingReport.tag;
            report.anrInfo.cause = r.notRespondingReport.shortMsg;
            report.anrInfo.info = r.notRespondingReport.longMsg;
        }
        return report;
    }

    boolean handleAppCrashLocked(ProcessRecord app, String reason, String shortMsg, String longMsg, String stackTrace, AppErrorDialog.Data data) {
        Long crashTimePersistent;
        Long crashTime;
        long now = SystemClock.uptimeMillis();
        boolean showBackground = Settings.Secure.getInt(this.mContext.getContentResolver(), "anr_show_background", 0) != 0;
        boolean procIsBoundForeground = app.curProcState == 4;
        boolean tryAgain = false;
        if (!app.isolated) {
            crashTime = this.mProcessCrashTimes.get(app.info.processName, app.uid);
            crashTimePersistent = this.mProcessCrashTimesPersistent.get(app.info.processName, app.uid);
        } else {
            crashTimePersistent = null;
            crashTime = null;
        }
        for (int i = app.services.size() - 1; i >= 0; --i) {
            ServiceRecord sr = app.services.valueAt(i);
            sr.crashCount = now > sr.restartTime + 60000L ? 1 : ++sr.crashCount;
            if ((long)sr.crashCount >= this.mService.mConstants.BOUND_SERVICE_MAX_CRASH_RETRY || !sr.isForeground && !procIsBoundForeground) continue;
            tryAgain = true;
        }
        if (crashTime != null && now < crashTime + 60000L) {
            Slog.w(TAG, "Process " + app.info.processName + " has crashed too many times: killing!");
            EventLog.writeEvent(30032, app.userId, app.info.processName, app.uid);
            this.mService.mStackSupervisor.handleAppCrashLocked(app);
            if (!app.persistent) {
                EventLog.writeEvent(30015, app.userId, app.uid, app.info.processName);
                if (!app.isolated) {
                    this.mBadProcesses.put(app.info.processName, app.uid, new BadProcessInfo(now, shortMsg, longMsg, stackTrace));
                    this.mProcessCrashTimes.remove(app.info.processName, app.uid);
                }
                app.bad = true;
                app.removed = true;
                this.mService.removeProcessLocked(app, false, tryAgain, "crash");
                this.mService.mStackSupervisor.resumeFocusedStackTopActivityLocked();
                if (!showBackground) {
                    return false;
                }
            }
            this.mService.mStackSupervisor.resumeFocusedStackTopActivityLocked();
        } else {
            TaskRecord affectedTask = this.mService.mStackSupervisor.finishTopCrashedActivitiesLocked(app, reason);
            if (data != null) {
                data.task = affectedTask;
            }
            if (data != null && crashTimePersistent != null && now < crashTimePersistent + 60000L) {
                data.repeating = true;
            }
        }
        if (data != null && tryAgain) {
            data.isRestartableForService = true;
        }
        ArrayList<ActivityRecord> activities = app.activities;
        if (app == this.mService.mHomeProcess && activities.size() > 0 && (this.mService.mHomeProcess.info.flags & 1) == 0) {
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (!r.isActivityTypeHome()) continue;
                Log.i(TAG, "Clearing package preferred activities from " + r.packageName);
                try {
                    ActivityThread.getPackageManager().clearPackagePreferredActivities(r.packageName);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        if (!app.isolated) {
            this.mProcessCrashTimes.put(app.info.processName, app.uid, now);
            this.mProcessCrashTimesPersistent.put(app.info.processName, app.uid, now);
        }
        if (app.crashHandler != null) {
            this.mService.mHandler.post(app.crashHandler);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void handleShowAppErrorUi(Message msg) {
        boolean crashSilenced;
        int userId;
        String packageName;
        AppErrorResult res;
        ProcessRecord proc;
        AppErrorDialog dialogToShow;
        boolean showBackground;
        AppErrorDialog.Data data;
        block14: {
            block13: {
                block12: {
                    data = (AppErrorDialog.Data)msg.obj;
                    showBackground = Settings.Secure.getInt(this.mContext.getContentResolver(), "anr_show_background", 0) != 0;
                    dialogToShow = null;
                    ActivityManagerService activityManagerService = this.mService;
                    // MONITORENTER : activityManagerService
                    ActivityManagerService.boostPriorityForLockedSection();
                    proc = data.proc;
                    res = data.result;
                    if (proc != null) break block12;
                    Slog.e(TAG, "handleShowAppErrorUi: proc is null");
                    // MONITOREXIT : activityManagerService
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                packageName = proc.info.packageName;
                userId = proc.userId;
                if (proc.crashDialog == null) break block13;
                Slog.e(TAG, "App already has crash dialog: " + proc);
                if (res != null) {
                    res.set(AppErrorDialog.ALREADY_SHOWING);
                }
                // MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                return;
            }
            try {
                int profileId;
                boolean isBackground = UserHandle.getAppId(proc.uid) >= 10000 && proc.pid != ActivityManagerService.MY_PID;
                int[] nArray = this.mService.mUserController.getCurrentProfileIds();
                int n = nArray.length;
                for (int i = 0; i < n; isBackground &= userId != (profileId = nArray[i]), ++i) {
                }
                if (!isBackground || showBackground) break block14;
                Slog.w(TAG, "Skipping crash dialog of " + proc + ": background");
                if (res != null) {
                    res.set(AppErrorDialog.BACKGROUND_USER);
                }
                // MONITOREXIT : activityManagerService
            }
            catch (Throwable throwable) {
                // MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return;
        }
        boolean showFirstCrash = Settings.Global.getInt(this.mContext.getContentResolver(), "show_first_crash_dialog", 0) != 0;
        boolean showFirstCrashDevOption = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "show_first_crash_dialog_dev_option", 0, this.mService.mUserController.getCurrentUserId()) != 0;
        boolean bl = crashSilenced = this.mAppsNotReportingCrashes != null && this.mAppsNotReportingCrashes.contains(proc.info.packageName);
        if ((this.mService.canShowErrorDialogs() || showBackground) && !crashSilenced && (showFirstCrash || showFirstCrashDevOption || data.repeating)) {
            dialogToShow = new AppErrorDialog(this.mContext, this.mService, data);
            proc.crashDialog = dialogToShow;
        } else if (res != null) {
            res.set(AppErrorDialog.CANT_SHOW);
        }
        // MONITOREXIT : activityManagerService
        ActivityManagerService.resetPriorityAfterLockedSection();
        if (dialogToShow == null) return;
        Slog.i(TAG, "Showing crash dialog for package " + packageName + " u" + userId);
        dialogToShow.show();
    }

    void stopReportingCrashesLocked(ProcessRecord proc) {
        if (this.mAppsNotReportingCrashes == null) {
            this.mAppsNotReportingCrashes = new ArraySet();
        }
        this.mAppsNotReportingCrashes.add(proc.info.packageName);
    }

    static boolean isInterestingForBackgroundTraces(ProcessRecord app) {
        if (app.pid == ActivityManagerService.MY_PID) {
            return true;
        }
        return app.isInterestingToUserLocked() || app.info != null && "com.android.systemui".equals(app.info.packageName) || app.hasTopUi || app.hasOverlayUi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    final void appNotResponding(ProcessRecord app, ActivityRecord activity, ActivityRecord parent, boolean aboveSystem, String annotation) {
        StringBuilder info;
        block47: {
            boolean isSilentANR;
            long anrTime;
            SparseArray<Boolean> lastPids;
            ArrayList<Integer> firstPids;
            block48: {
                boolean showBackground;
                block46: {
                    block45: {
                        block44: {
                            block43: {
                                block42: {
                                    firstPids = new ArrayList<Integer>(5);
                                    lastPids = new SparseArray<Boolean>(20);
                                    if (this.mService.mController != null) {
                                        try {
                                            int res = this.mService.mController.appEarlyNotResponding(app.processName, app.pid, annotation);
                                            if (res < 0 && app.pid != ActivityManagerService.MY_PID) {
                                                app.kill("anr", true);
                                            }
                                        }
                                        catch (RemoteException e) {
                                            this.mService.mController = null;
                                            Watchdog.getInstance().setActivityController(null);
                                        }
                                    }
                                    anrTime = SystemClock.uptimeMillis();
                                    this.mService.updateCpuStatsNow();
                                    showBackground = Settings.Secure.getInt(this.mContext.getContentResolver(), "anr_show_background", 0) != 0;
                                    ActivityManagerService activityManagerService = this.mService;
                                    // MONITORENTER : activityManagerService
                                    ActivityManagerService.boostPriorityForLockedSection();
                                    if (!this.mService.mShuttingDown) break block42;
                                    Slog.i(TAG, "During shutdown skipping ANR: " + app + " " + annotation);
                                    // MONITOREXIT : activityManagerService
                                    ActivityManagerService.resetPriorityAfterLockedSection();
                                    return;
                                }
                                if (!app.notResponding) break block43;
                                Slog.i(TAG, "Skipping duplicate ANR: " + app + " " + annotation);
                                // MONITOREXIT : activityManagerService
                                ActivityManagerService.resetPriorityAfterLockedSection();
                                return;
                            }
                            if (!app.crashing) break block44;
                            Slog.i(TAG, "Crashing app skipping ANR: " + app + " " + annotation);
                            // MONITOREXIT : activityManagerService
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            return;
                        }
                        if (!app.killedByAm) break block45;
                        Slog.i(TAG, "App already killed by AM skipping ANR: " + app + " " + annotation);
                        // MONITOREXIT : activityManagerService
                        ActivityManagerService.resetPriorityAfterLockedSection();
                        return;
                    }
                    if (!app.killed) break block46;
                    Slog.i(TAG, "Skipping died app ANR: " + app + " " + annotation);
                    // MONITOREXIT : activityManagerService
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                try {
                    app.notResponding = true;
                    EventLog.writeEvent(30008, app.userId, app.pid, app.processName, app.info.flags, annotation);
                    firstPids.add(app.pid);
                    boolean bl = isSilentANR = !showBackground && !AppErrors.isInterestingForBackgroundTraces(app);
                    if (!isSilentANR) {
                        int parentPid = app.pid;
                        if (parent != null && parent.app != null && parent.app.pid > 0) {
                            parentPid = parent.app.pid;
                        }
                        if (parentPid != app.pid) {
                            firstPids.add(parentPid);
                        }
                        if (ActivityManagerService.MY_PID != app.pid && ActivityManagerService.MY_PID != parentPid) {
                            firstPids.add(ActivityManagerService.MY_PID);
                        }
                        for (int i = this.mService.mLruProcesses.size() - 1; i >= 0; --i) {
                            int pid;
                            ProcessRecord r = this.mService.mLruProcesses.get(i);
                            if (r == null || r.thread == null || (pid = r.pid) <= 0 || pid == app.pid || pid == parentPid || pid == ActivityManagerService.MY_PID) continue;
                            if (r.persistent) {
                                firstPids.add(pid);
                                continue;
                            }
                            if (r.treatLikeActivity) {
                                firstPids.add(pid);
                                continue;
                            }
                            lastPids.put(pid, Boolean.TRUE);
                        }
                    }
                    // MONITOREXIT : activityManagerService
                }
                catch (Throwable throwable) {
                    // MONITOREXIT : activityManagerService
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
                ActivityManagerService.resetPriorityAfterLockedSection();
                info = new StringBuilder();
                info.setLength(0);
                info.append("ANR in ").append(app.processName);
                if (activity == null) break block48;
                if (activity.shortComponentName != null) {
                    info.append(" (").append(activity.shortComponentName).append(")");
                }
            }
            info.append("\n");
            info.append("PID: ").append(app.pid).append("\n");
            if (annotation != null) {
                info.append("Reason: ").append(annotation).append("\n");
            }
            if (parent != null && parent != activity) {
                info.append("Parent: ").append(parent.shortComponentName).append("\n");
            }
            ProcessCpuTracker processCpuTracker = new ProcessCpuTracker(true);
            String[] nativeProcs = null;
            if (!isSilentANR) {
                nativeProcs = Watchdog.NATIVE_STACKS_OF_INTEREST;
            } else {
                for (int i = 0; i < Watchdog.NATIVE_STACKS_OF_INTEREST.length; ++i) {
                    if (!Watchdog.NATIVE_STACKS_OF_INTEREST[i].equals(app.processName)) continue;
                    nativeProcs = new String[]{app.processName};
                    break;
                }
            }
            int[] pids = nativeProcs == null ? null : Process.getPidsForCommands(nativeProcs);
            ArrayList<Integer> nativePids = null;
            if (pids != null) {
                nativePids = new ArrayList<Integer>(pids.length);
                for (int i : pids) {
                    nativePids.add(i);
                }
            }
            File tracesFile = ActivityManagerService.dumpStackTraces(true, firstPids, isSilentANR ? null : processCpuTracker, isSilentANR ? null : lastPids, nativePids);
            String cpuInfo = null;
            this.mService.updateCpuStatsNow();
            ProcessCpuTracker processCpuTracker2 = this.mService.mProcessCpuTracker;
            // MONITORENTER : processCpuTracker2
            cpuInfo = this.mService.mProcessCpuTracker.printCurrentState(anrTime);
            // MONITOREXIT : processCpuTracker2
            info.append(processCpuTracker.printCurrentLoad());
            info.append(cpuInfo);
            info.append(processCpuTracker.printCurrentState(anrTime));
            Slog.e(TAG, info.toString());
            if (tracesFile == null) {
                Process.sendSignal(app.pid, 3);
            }
            StatsLog.write(79, app.uid, app.processName, activity == null ? "unknown" : activity.shortComponentName, annotation, app.info != null ? (app.info.isInstantApp() ? 2 : 1) : 0, app != null ? (app.isInterestingToUserLocked() ? 2 : 1) : 0);
            this.mService.addErrorToDropBox("anr", app, app.processName, activity, parent, annotation, cpuInfo, tracesFile, null);
            if (this.mService.mController != null) {
                try {
                    int res = this.mService.mController.appNotResponding(app.processName, app.pid, info.toString());
                    if (res != 0) {
                        if (res < 0 && app.pid != ActivityManagerService.MY_PID) {
                            app.kill("anr", true);
                            return;
                        }
                        ActivityManagerService i = this.mService;
                        // MONITORENTER : i
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            this.mService.mServices.scheduleServiceTimeoutLocked(app);
                            // MONITOREXIT : i
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT : i
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                        ActivityManagerService.resetPriorityAfterLockedSection();
                        return;
                    }
                }
                catch (RemoteException e) {
                    this.mService.mController = null;
                    Watchdog.getInstance().setActivityController(null);
                }
            }
            ActivityManagerService activityManagerService = this.mService;
            // MONITORENTER : activityManagerService
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.mService.mBatteryStatsService.noteProcessAnr(app.processName, app.uid);
                if (!isSilentANR) break block47;
                app.kill("bg anr", true);
                // MONITOREXIT : activityManagerService
            }
            catch (Throwable throwable) {
                // MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return;
        }
        this.makeAppNotRespondingLocked(app, activity != null ? activity.shortComponentName : null, annotation != null ? "ANR " + annotation : "ANR", info.toString());
        Message msg = Message.obtain();
        msg.what = 2;
        msg.obj = new AppNotRespondingDialog.Data(app, activity, aboveSystem);
        this.mService.mUiHandler.sendMessage(msg);
        // MONITOREXIT : activityManagerService
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    private void makeAppNotRespondingLocked(ProcessRecord app, String activity, String shortMsg, String longMsg) {
        app.notResponding = true;
        app.notRespondingReport = this.generateProcessError(app, 2, activity, shortMsg, longMsg, null);
        this.startAppProblemLocked(app);
        app.stopFreezingAllLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void handleShowAnrUi(Message msg) {
        boolean showBackground;
        ProcessRecord proc;
        AppNotRespondingDialog.Data data;
        AppNotRespondingDialog dialogToShow;
        block9: {
            block8: {
                dialogToShow = null;
                ActivityManagerService activityManagerService = this.mService;
                // MONITORENTER : activityManagerService
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    data = (AppNotRespondingDialog.Data)msg.obj;
                    proc = data.proc;
                    if (proc != null) break block8;
                    Slog.e(TAG, "handleShowAnrUi: proc is null");
                    // MONITOREXIT : activityManagerService
                }
                catch (Throwable throwable) {
                    // MONITOREXIT : activityManagerService
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
                ActivityManagerService.resetPriorityAfterLockedSection();
                return;
            }
            if (proc.anrDialog == null) break block9;
            Slog.e(TAG, "App already has anr dialog: " + proc);
            MetricsLogger.action(this.mContext, 317, -2);
            // MONITOREXIT : activityManagerService
            ActivityManagerService.resetPriorityAfterLockedSection();
            return;
        }
        Intent intent = new Intent("android.intent.action.ANR");
        if (!this.mService.mProcessesReady) {
            intent.addFlags(0x50000000);
        }
        this.mService.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, null, false, false, ActivityManagerService.MY_PID, 1000, 0);
        boolean bl = showBackground = Settings.Secure.getInt(this.mContext.getContentResolver(), "anr_show_background", 0) != 0;
        if (this.mService.canShowErrorDialogs() || showBackground) {
            dialogToShow = new AppNotRespondingDialog(this.mService, this.mContext, data);
            proc.anrDialog = dialogToShow;
        } else {
            MetricsLogger.action(this.mContext, 317, -1);
            this.mService.killAppAtUsersRequest(proc, null);
        }
        // MONITOREXIT : activityManagerService
        ActivityManagerService.resetPriorityAfterLockedSection();
        if (dialogToShow == null) return;
        dialogToShow.show();
    }

    static final class BadProcessInfo {
        final long time;
        final String shortMsg;
        final String longMsg;
        final String stack;

        BadProcessInfo(long time, String shortMsg, String longMsg, String stack) {
            this.time = time;
            this.shortMsg = shortMsg;
            this.longMsg = longMsg;
            this.stack = stack;
        }
    }
}

