/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.admin.IDevicePolicyManager;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.provider.Settings;
import android.telecom.TelecomManager;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.policy.IKeyguardDismissCallback;
import com.android.internal.statusbar.IStatusBarService;
import com.android.internal.widget.LockPatternUtils;
import com.android.server.LocalServices;
import com.android.server.am.ActivityRecord;
import com.android.server.am.ActivityStack;
import com.android.server.am.ActivityStackSupervisor;
import com.android.server.am.TaskRecord;
import com.android.server.statusbar.StatusBarManagerInternal;
import com.android.server.wm.WindowManagerService;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;

public class LockTaskController {
    private static final String TAG = "ActivityManager";
    private static final String TAG_LOCKTASK = "ActivityManager";
    @VisibleForTesting
    static final int STATUS_BAR_MASK_LOCKED = 61210624;
    @VisibleForTesting
    static final int STATUS_BAR_MASK_PINNED = 43974656;
    private static final SparseArray<Pair<Integer, Integer>> STATUS_BAR_FLAG_MAP_LOCKED = new SparseArray();
    private static final String LOCK_TASK_TAG = "Lock-to-App";
    private final IBinder mToken = new Binder();
    private final ActivityStackSupervisor mSupervisor;
    private final Context mContext;
    @VisibleForTesting
    IStatusBarService mStatusBarService;
    @VisibleForTesting
    IDevicePolicyManager mDevicePolicyManager;
    @VisibleForTesting
    WindowManagerService mWindowManager;
    @VisibleForTesting
    LockPatternUtils mLockPatternUtils;
    @VisibleForTesting
    TelecomManager mTelecomManager;
    private final ArrayList<TaskRecord> mLockTaskModeTasks = new ArrayList();
    private final SparseArray<String[]> mLockTaskPackages = new SparseArray();
    private final SparseIntArray mLockTaskFeatures = new SparseIntArray();
    private int mLockTaskModeState = 0;
    private final Handler mHandler;

    LockTaskController(Context context, ActivityStackSupervisor supervisor, Handler handler) {
        this.mContext = context;
        this.mSupervisor = supervisor;
        this.mHandler = handler;
    }

    void setWindowManager(WindowManagerService windowManager) {
        this.mWindowManager = windowManager;
    }

    int getLockTaskModeState() {
        return this.mLockTaskModeState;
    }

    @VisibleForTesting
    boolean isTaskLocked(TaskRecord task) {
        return this.mLockTaskModeTasks.contains(task);
    }

    private boolean isRootTask(TaskRecord task) {
        return this.mLockTaskModeTasks.indexOf(task) == 0;
    }

    boolean activityBlockedFromFinish(ActivityRecord activity) {
        TaskRecord task = activity.getTask();
        if (activity == task.getRootActivity() && activity == task.getTopActivity() && task.mLockTaskAuth != 4 && this.isRootTask(task)) {
            Slog.i("ActivityManager", "Not finishing task in lock task mode");
            this.showLockTaskToast();
            return true;
        }
        return false;
    }

    boolean canMoveTaskToBack(TaskRecord task) {
        if (this.isRootTask(task)) {
            this.showLockTaskToast();
            return false;
        }
        return true;
    }

    boolean isTaskWhitelisted(TaskRecord task) {
        switch (task.mLockTaskAuth) {
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    boolean isLockTaskModeViolation(TaskRecord task) {
        return this.isLockTaskModeViolation(task, false);
    }

    boolean isLockTaskModeViolation(TaskRecord task, boolean isNewClearTask) {
        if (this.isLockTaskModeViolationInternal(task, isNewClearTask)) {
            this.showLockTaskToast();
            return true;
        }
        return false;
    }

    TaskRecord getRootTask() {
        if (this.mLockTaskModeTasks.isEmpty()) {
            return null;
        }
        return this.mLockTaskModeTasks.get(0);
    }

    private boolean isLockTaskModeViolationInternal(TaskRecord task, boolean isNewClearTask) {
        if (this.isTaskLocked(task) && !isNewClearTask) {
            return false;
        }
        if (task.isActivityTypeRecents() && this.isRecentsAllowed(task.userId)) {
            return false;
        }
        if (this.isKeyguardAllowed(task.userId) && this.isEmergencyCallTask(task)) {
            return false;
        }
        return !this.isTaskWhitelisted(task) && !this.mLockTaskModeTasks.isEmpty();
    }

    private boolean isRecentsAllowed(int userId) {
        return (this.getLockTaskFeaturesForUser(userId) & 8) != 0;
    }

    private boolean isKeyguardAllowed(int userId) {
        return (this.getLockTaskFeaturesForUser(userId) & 0x20) != 0;
    }

    private boolean isEmergencyCallTask(TaskRecord task) {
        String dialerPackage;
        Intent intent = task.intent;
        if (intent == null) {
            return false;
        }
        if (TelecomManager.EMERGENCY_DIALER_COMPONENT.equals(intent.getComponent())) {
            return true;
        }
        if ("android.intent.action.CALL_EMERGENCY".equals(intent.getAction())) {
            return true;
        }
        TelecomManager tm = this.getTelecomManager();
        String string2 = dialerPackage = tm != null ? tm.getSystemDialerPackage() : null;
        return dialerPackage != null && dialerPackage.equals(intent.getComponent().getPackageName());
    }

    void stopLockTaskMode(TaskRecord task, boolean isSystemCaller, int callingUid) {
        if (this.mLockTaskModeState == 0) {
            return;
        }
        if (isSystemCaller) {
            if (this.mLockTaskModeState == 2) {
                this.clearLockedTasks("stopAppPinning");
            } else {
                Slog.e("ActivityManager", "Attempted to stop LockTask with isSystemCaller=true");
                this.showLockTaskToast();
            }
        } else {
            if (task == null) {
                throw new IllegalArgumentException("can't stop LockTask for null task");
            }
            if (callingUid != task.mLockTaskUid && (task.mLockTaskUid != 0 || callingUid != task.effectiveUid)) {
                throw new SecurityException("Invalid uid, expected " + task.mLockTaskUid + " callingUid=" + callingUid + " effectiveUid=" + task.effectiveUid);
            }
            this.clearLockedTask(task);
        }
    }

    void clearLockedTasks(String reason) {
        if (!this.mLockTaskModeTasks.isEmpty()) {
            this.clearLockedTask(this.mLockTaskModeTasks.get(0));
        }
    }

    void clearLockedTask(TaskRecord task) {
        if (task == null || this.mLockTaskModeTasks.isEmpty()) {
            return;
        }
        if (task == this.mLockTaskModeTasks.get(0)) {
            for (int taskNdx = this.mLockTaskModeTasks.size() - 1; taskNdx > 0; --taskNdx) {
                this.clearLockedTask(this.mLockTaskModeTasks.get(taskNdx));
            }
        }
        this.removeLockedTask(task);
        if (this.mLockTaskModeTasks.isEmpty()) {
            return;
        }
        task.performClearTaskLocked();
        this.mSupervisor.resumeFocusedStackTopActivityLocked();
    }

    private void removeLockedTask(TaskRecord task) {
        if (!this.mLockTaskModeTasks.remove(task)) {
            return;
        }
        if (this.mLockTaskModeTasks.isEmpty()) {
            this.mHandler.post(() -> this.performStopLockTask(task.userId));
        }
    }

    private void performStopLockTask(int userId) {
        try {
            this.setStatusBarState(0, userId);
            this.setKeyguardState(0, userId);
            if (this.mLockTaskModeState == 2) {
                this.lockKeyguardIfNeeded();
            }
            if (this.getDevicePolicyManager() != null) {
                this.getDevicePolicyManager().notifyLockTaskModeChanged(false, null, userId);
            }
            if (this.mLockTaskModeState == 2) {
                this.getStatusBarService().showPinningEnterExitToast(false);
            }
            this.mWindowManager.onLockTaskStateChanged(0);
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.mLockTaskModeState = 0;
        }
    }

    void showLockTaskToast() {
        if (this.mLockTaskModeState == 2) {
            try {
                this.getStatusBarService().showPinningEscapeToast();
            }
            catch (RemoteException e) {
                Slog.e("ActivityManager", "Failed to send pinning escape toast", e);
            }
        }
    }

    void startLockTaskMode(TaskRecord task, boolean isSystemCaller, int callingUid) {
        if (!isSystemCaller) {
            task.mLockTaskUid = callingUid;
            if (task.mLockTaskAuth == 1) {
                StatusBarManagerInternal statusBarManager = LocalServices.getService(StatusBarManagerInternal.class);
                if (statusBarManager != null) {
                    statusBarManager.showScreenPinningRequest(task.taskId);
                }
                return;
            }
        }
        this.setLockTaskMode(task, isSystemCaller ? 2 : 1, "startLockTask", true);
    }

    private void setLockTaskMode(TaskRecord task, int lockTaskModeState, String reason, boolean andResume) {
        if (task.mLockTaskAuth == 0) {
            return;
        }
        if (this.isLockTaskModeViolation(task)) {
            Slog.e("ActivityManager", "setLockTaskMode: Attempt to start an unauthorized lock task.");
            return;
        }
        Intent taskIntent = task.intent;
        if (this.mLockTaskModeTasks.isEmpty() && taskIntent != null) {
            this.mSupervisor.mRecentTasks.onLockTaskModeStateChanged(lockTaskModeState, task.userId);
            this.mHandler.post(() -> this.performStartLockTask(taskIntent.getComponent().getPackageName(), task.userId, lockTaskModeState));
        }
        if (!this.mLockTaskModeTasks.contains(task)) {
            this.mLockTaskModeTasks.add(task);
        }
        if (task.mLockTaskUid == -1) {
            task.mLockTaskUid = task.effectiveUid;
        }
        if (andResume) {
            this.mSupervisor.findTaskToMoveToFront(task, 0, null, reason, lockTaskModeState != 0);
            this.mSupervisor.resumeFocusedStackTopActivityLocked();
            this.mWindowManager.executeAppTransition();
        } else if (lockTaskModeState != 0) {
            this.mSupervisor.handleNonResizableTaskIfNeeded(task, 0, 0, (ActivityStack)task.getStack(), true);
        }
    }

    private void performStartLockTask(String packageName, int userId, int lockTaskModeState) {
        try {
            if (lockTaskModeState == 2) {
                this.getStatusBarService().showPinningEnterExitToast(true);
            }
            this.mWindowManager.onLockTaskStateChanged(lockTaskModeState);
            this.mLockTaskModeState = lockTaskModeState;
            this.setStatusBarState(lockTaskModeState, userId);
            this.setKeyguardState(lockTaskModeState, userId);
            if (this.getDevicePolicyManager() != null) {
                this.getDevicePolicyManager().notifyLockTaskModeChanged(true, packageName, userId);
            }
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex);
        }
    }

    void updateLockTaskPackages(int userId, String[] packages) {
        TaskRecord task;
        this.mLockTaskPackages.put(userId, packages);
        boolean taskChanged = false;
        for (int taskNdx = this.mLockTaskModeTasks.size() - 1; taskNdx >= 0; --taskNdx) {
            boolean isWhitelisted;
            TaskRecord lockedTask = this.mLockTaskModeTasks.get(taskNdx);
            boolean wasWhitelisted = lockedTask.mLockTaskAuth == 2 || lockedTask.mLockTaskAuth == 3;
            lockedTask.setLockTaskAuth();
            boolean bl = isWhitelisted = lockedTask.mLockTaskAuth == 2 || lockedTask.mLockTaskAuth == 3;
            if (this.mLockTaskModeState != 1 || lockedTask.userId != userId || !wasWhitelisted || isWhitelisted) continue;
            this.removeLockedTask(lockedTask);
            lockedTask.performClearTaskLocked();
            taskChanged = true;
        }
        for (int displayNdx = this.mSupervisor.getChildCount() - 1; displayNdx >= 0; --displayNdx) {
            this.mSupervisor.getChildAt(displayNdx).onLockTaskPackagesUpdated();
        }
        ActivityRecord r = this.mSupervisor.topRunningActivityLocked();
        TaskRecord taskRecord = task = r != null ? r.getTask() : null;
        if (this.mLockTaskModeTasks.isEmpty() && task != null && task.mLockTaskAuth == 2) {
            this.setLockTaskMode(task, 1, "package updated", false);
            taskChanged = true;
        }
        if (taskChanged) {
            this.mSupervisor.resumeFocusedStackTopActivityLocked();
        }
    }

    boolean isPackageWhitelisted(int userId, String pkg) {
        if (pkg == null) {
            return false;
        }
        String[] whitelist = this.mLockTaskPackages.get(userId);
        if (whitelist == null) {
            return false;
        }
        for (String whitelistedPkg : whitelist) {
            if (!pkg.equals(whitelistedPkg)) continue;
            return true;
        }
        return false;
    }

    void updateLockTaskFeatures(int userId, int flags) {
        int oldFlags = this.getLockTaskFeaturesForUser(userId);
        if (flags == oldFlags) {
            return;
        }
        this.mLockTaskFeatures.put(userId, flags);
        if (!this.mLockTaskModeTasks.isEmpty() && userId == this.mLockTaskModeTasks.get((int)0).userId) {
            this.mHandler.post(() -> {
                if (this.mLockTaskModeState == 1) {
                    this.setStatusBarState(this.mLockTaskModeState, userId);
                    this.setKeyguardState(this.mLockTaskModeState, userId);
                }
            });
        }
    }

    private void setStatusBarState(int lockTaskModeState, int userId) {
        IStatusBarService statusBar = this.getStatusBarService();
        if (statusBar == null) {
            Slog.e("ActivityManager", "Can't find StatusBarService");
            return;
        }
        int flags1 = 0;
        int flags2 = 0;
        if (lockTaskModeState == 2) {
            flags1 = 43974656;
        } else if (lockTaskModeState == 1) {
            int lockTaskFeatures = this.getLockTaskFeaturesForUser(userId);
            Pair<Integer, Integer> statusBarFlags = this.getStatusBarDisableFlags(lockTaskFeatures);
            flags1 = (Integer)statusBarFlags.first;
            flags2 = (Integer)statusBarFlags.second;
        }
        try {
            statusBar.disable(flags1, this.mToken, this.mContext.getPackageName());
            statusBar.disable2(flags2, this.mToken, this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            Slog.e("ActivityManager", "Failed to set status bar flags", e);
        }
    }

    private void setKeyguardState(int lockTaskModeState, int userId) {
        if (lockTaskModeState == 0) {
            this.mWindowManager.reenableKeyguard(this.mToken);
        } else if (lockTaskModeState == 1) {
            if (this.isKeyguardAllowed(userId)) {
                this.mWindowManager.reenableKeyguard(this.mToken);
            } else if (this.mWindowManager.isKeyguardLocked() && !this.mWindowManager.isKeyguardSecure()) {
                this.mWindowManager.dismissKeyguard(new IKeyguardDismissCallback.Stub(){

                    @Override
                    public void onDismissError() throws RemoteException {
                        Slog.i("ActivityManager", "setKeyguardState: failed to dismiss keyguard");
                    }

                    @Override
                    public void onDismissSucceeded() throws RemoteException {
                        LockTaskController.this.mHandler.post(() -> LockTaskController.this.mWindowManager.disableKeyguard(LockTaskController.this.mToken, LockTaskController.LOCK_TASK_TAG));
                    }

                    @Override
                    public void onDismissCancelled() throws RemoteException {
                        Slog.i("ActivityManager", "setKeyguardState: dismiss cancelled");
                    }
                }, null);
            } else {
                this.mWindowManager.disableKeyguard(this.mToken, LOCK_TASK_TAG);
            }
        } else {
            this.mWindowManager.disableKeyguard(this.mToken, LOCK_TASK_TAG);
        }
    }

    private void lockKeyguardIfNeeded() {
        try {
            boolean shouldLockKeyguard;
            boolean bl = shouldLockKeyguard = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "lock_to_app_exit_locked", -2) != 0;
            if (shouldLockKeyguard) {
                this.mWindowManager.lockNow(null);
                this.mWindowManager.dismissKeyguard(null, null);
                this.getLockPatternUtils().requireCredentialEntry(-1);
            }
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            // empty catch block
        }
    }

    @VisibleForTesting
    Pair<Integer, Integer> getStatusBarDisableFlags(int lockTaskFlags) {
        int flags1 = 0x3FF0000;
        int flags2 = 31;
        for (int i = STATUS_BAR_FLAG_MAP_LOCKED.size() - 1; i >= 0; --i) {
            Pair<Integer, Integer> statusBarFlags = STATUS_BAR_FLAG_MAP_LOCKED.valueAt(i);
            if ((STATUS_BAR_FLAG_MAP_LOCKED.keyAt(i) & lockTaskFlags) == 0) continue;
            flags1 &= ~((Integer)statusBarFlags.first).intValue();
            flags2 &= ~((Integer)statusBarFlags.second).intValue();
        }
        return new Pair<Integer, Integer>(flags1 &= 0x3A60000, flags2);
    }

    private int getLockTaskFeaturesForUser(int userId) {
        return this.mLockTaskFeatures.get(userId, 0);
    }

    private IStatusBarService getStatusBarService() {
        if (this.mStatusBarService == null) {
            this.mStatusBarService = IStatusBarService.Stub.asInterface(ServiceManager.checkService("statusbar"));
            if (this.mStatusBarService == null) {
                Slog.w("StatusBarManager", "warning: no STATUS_BAR_SERVICE");
            }
        }
        return this.mStatusBarService;
    }

    private IDevicePolicyManager getDevicePolicyManager() {
        if (this.mDevicePolicyManager == null) {
            this.mDevicePolicyManager = IDevicePolicyManager.Stub.asInterface(ServiceManager.checkService("device_policy"));
            if (this.mDevicePolicyManager == null) {
                Slog.w("ActivityManager", "warning: no DEVICE_POLICY_SERVICE");
            }
        }
        return this.mDevicePolicyManager;
    }

    private LockPatternUtils getLockPatternUtils() {
        if (this.mLockPatternUtils == null) {
            return new LockPatternUtils(this.mContext);
        }
        return this.mLockPatternUtils;
    }

    private TelecomManager getTelecomManager() {
        if (this.mTelecomManager == null) {
            return this.mContext.getSystemService(TelecomManager.class);
        }
        return this.mTelecomManager;
    }

    public void dump(PrintWriter pw, String prefix) {
        int i;
        pw.println(prefix + "LockTaskController");
        prefix = prefix + "  ";
        pw.println(prefix + "mLockTaskModeState=" + this.lockTaskModeToString());
        pw.println(prefix + "mLockTaskModeTasks=");
        for (i = 0; i < this.mLockTaskModeTasks.size(); ++i) {
            pw.println(prefix + "  #" + i + " " + this.mLockTaskModeTasks.get(i));
        }
        pw.println(prefix + "mLockTaskPackages (userId:packages)=");
        for (i = 0; i < this.mLockTaskPackages.size(); ++i) {
            pw.println(prefix + "  u" + this.mLockTaskPackages.keyAt(i) + ":" + Arrays.toString(this.mLockTaskPackages.valueAt(i)));
        }
    }

    private String lockTaskModeToString() {
        switch (this.mLockTaskModeState) {
            case 1: {
                return "LOCKED";
            }
            case 2: {
                return "PINNED";
            }
            case 0: {
                return "NONE";
            }
        }
        return "unknown=" + this.mLockTaskModeState;
    }

    static {
        STATUS_BAR_FLAG_MAP_LOCKED.append(1, new Pair<Integer, Integer>(0x800000, 2));
        STATUS_BAR_FLAG_MAP_LOCKED.append(2, new Pair<Integer, Integer>(393216, 4));
        STATUS_BAR_FLAG_MAP_LOCKED.append(4, new Pair<Integer, Integer>(0x200000, 0));
        STATUS_BAR_FLAG_MAP_LOCKED.append(8, new Pair<Integer, Integer>(0x1000000, 0));
        STATUS_BAR_FLAG_MAP_LOCKED.append(16, new Pair<Integer, Integer>(0, 8));
    }
}

