/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityOptions;
import android.content.pm.ActivityInfo;
import android.graphics.Rect;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.am.ActivityRecord;
import com.android.server.am.ActivityStack;
import com.android.server.am.LaunchParamsController;
import com.android.server.am.TaskRecord;
import java.util.ArrayList;

class TaskLaunchParamsModifier
implements LaunchParamsController.LaunchParamsModifier {
    private static final String TAG = "ActivityManager";
    private static final int BOUNDS_CONFLICT_MIN_DISTANCE = 4;
    private static final int WINDOW_SIZE_DENOMINATOR = 2;
    private static final int MARGIN_SIZE_DENOMINATOR = 4;
    private static final int STEP_DENOMINATOR = 16;
    private static final int MINIMAL_STEP = 1;
    private static final boolean ALLOW_RESTART = true;
    private static final int SHIFT_POLICY_DIAGONAL_DOWN = 1;
    private static final int SHIFT_POLICY_HORIZONTAL_RIGHT = 2;
    private static final int SHIFT_POLICY_HORIZONTAL_LEFT = 3;
    private final Rect mAvailableRect = new Rect();
    private final Rect mTmpProposal = new Rect();
    private final Rect mTmpOriginal = new Rect();

    TaskLaunchParamsModifier() {
    }

    @Override
    public int onCalculate(TaskRecord task, ActivityInfo.WindowLayout layout2, ActivityRecord activity, ActivityRecord source, ActivityOptions options, LaunchParamsController.LaunchParams currentParams, LaunchParamsController.LaunchParams outParams) {
        if (task == null || task.getStack() == null || !task.inFreeformWindowingMode()) {
            return 0;
        }
        ArrayList<TaskRecord> tasks = ((ActivityStack)task.getStack()).getAllTasks();
        this.mAvailableRect.set(task.getParent().getBounds());
        Rect resultBounds = outParams.mBounds;
        if (layout2 == null) {
            this.positionCenter(tasks, this.mAvailableRect, TaskLaunchParamsModifier.getFreeformWidth(this.mAvailableRect), TaskLaunchParamsModifier.getFreeformHeight(this.mAvailableRect), resultBounds);
            return 2;
        }
        int width = this.getFinalWidth(layout2, this.mAvailableRect);
        int height = this.getFinalHeight(layout2, this.mAvailableRect);
        int verticalGravity = layout2.gravity & 0x70;
        int horizontalGravity = layout2.gravity & 7;
        if (verticalGravity == 48) {
            if (horizontalGravity == 5) {
                this.positionTopRight(tasks, this.mAvailableRect, width, height, resultBounds);
            } else {
                this.positionTopLeft(tasks, this.mAvailableRect, width, height, resultBounds);
            }
        } else if (verticalGravity == 80) {
            if (horizontalGravity == 5) {
                this.positionBottomRight(tasks, this.mAvailableRect, width, height, resultBounds);
            } else {
                this.positionBottomLeft(tasks, this.mAvailableRect, width, height, resultBounds);
            }
        } else {
            Slog.w(TAG, "Received unsupported gravity: " + layout2.gravity + ", positioning in the center instead.");
            this.positionCenter(tasks, this.mAvailableRect, width, height, resultBounds);
        }
        return 2;
    }

    @VisibleForTesting
    static int getFreeformStartLeft(Rect bounds) {
        return bounds.left + bounds.width() / 4;
    }

    @VisibleForTesting
    static int getFreeformStartTop(Rect bounds) {
        return bounds.top + bounds.height() / 4;
    }

    @VisibleForTesting
    static int getFreeformWidth(Rect bounds) {
        return bounds.width() / 2;
    }

    @VisibleForTesting
    static int getFreeformHeight(Rect bounds) {
        return bounds.height() / 2;
    }

    @VisibleForTesting
    static int getHorizontalStep(Rect bounds) {
        return Math.max(bounds.width() / 16, 1);
    }

    @VisibleForTesting
    static int getVerticalStep(Rect bounds) {
        return Math.max(bounds.height() / 16, 1);
    }

    private int getFinalWidth(ActivityInfo.WindowLayout windowLayout, Rect availableRect) {
        int width = TaskLaunchParamsModifier.getFreeformWidth(availableRect);
        if (windowLayout.width > 0) {
            width = windowLayout.width;
        }
        if (windowLayout.widthFraction > 0.0f) {
            width = (int)((float)availableRect.width() * windowLayout.widthFraction);
        }
        return width;
    }

    private int getFinalHeight(ActivityInfo.WindowLayout windowLayout, Rect availableRect) {
        int height = TaskLaunchParamsModifier.getFreeformHeight(availableRect);
        if (windowLayout.height > 0) {
            height = windowLayout.height;
        }
        if (windowLayout.heightFraction > 0.0f) {
            height = (int)((float)availableRect.height() * windowLayout.heightFraction);
        }
        return height;
    }

    private void positionBottomLeft(ArrayList<TaskRecord> tasks, Rect availableRect, int width, int height, Rect result) {
        this.mTmpProposal.set(availableRect.left, availableRect.bottom - height, availableRect.left + width, availableRect.bottom);
        this.position(tasks, availableRect, this.mTmpProposal, false, 2, result);
    }

    private void positionBottomRight(ArrayList<TaskRecord> tasks, Rect availableRect, int width, int height, Rect result) {
        this.mTmpProposal.set(availableRect.right - width, availableRect.bottom - height, availableRect.right, availableRect.bottom);
        this.position(tasks, availableRect, this.mTmpProposal, false, 3, result);
    }

    private void positionTopLeft(ArrayList<TaskRecord> tasks, Rect availableRect, int width, int height, Rect result) {
        this.mTmpProposal.set(availableRect.left, availableRect.top, availableRect.left + width, availableRect.top + height);
        this.position(tasks, availableRect, this.mTmpProposal, false, 2, result);
    }

    private void positionTopRight(ArrayList<TaskRecord> tasks, Rect availableRect, int width, int height, Rect result) {
        this.mTmpProposal.set(availableRect.right - width, availableRect.top, availableRect.right, availableRect.top + height);
        this.position(tasks, availableRect, this.mTmpProposal, false, 3, result);
    }

    private void positionCenter(ArrayList<TaskRecord> tasks, Rect availableRect, int width, int height, Rect result) {
        int defaultFreeformLeft = TaskLaunchParamsModifier.getFreeformStartLeft(availableRect);
        int defaultFreeformTop = TaskLaunchParamsModifier.getFreeformStartTop(availableRect);
        this.mTmpProposal.set(defaultFreeformLeft, defaultFreeformTop, defaultFreeformLeft + width, defaultFreeformTop + height);
        this.position(tasks, availableRect, this.mTmpProposal, true, 1, result);
    }

    private void position(ArrayList<TaskRecord> tasks, Rect availableRect, Rect proposal, boolean allowRestart, int shiftPolicy, Rect result) {
        this.mTmpOriginal.set(proposal);
        boolean restarted = false;
        while (TaskLaunchParamsModifier.boundsConflict(proposal, tasks)) {
            this.shiftStartingPoint(proposal, availableRect, shiftPolicy);
            if (this.shiftedTooFar(proposal, availableRect, shiftPolicy)) {
                if (!allowRestart) {
                    proposal.set(this.mTmpOriginal);
                    break;
                }
                proposal.set(availableRect.left, availableRect.top, availableRect.left + proposal.width(), availableRect.top + proposal.height());
                restarted = true;
            }
            if (!restarted || proposal.left <= TaskLaunchParamsModifier.getFreeformStartLeft(availableRect) && proposal.top <= TaskLaunchParamsModifier.getFreeformStartTop(availableRect)) continue;
            proposal.set(this.mTmpOriginal);
            break;
        }
        result.set(proposal);
    }

    private boolean shiftedTooFar(Rect start, Rect availableRect, int shiftPolicy) {
        switch (shiftPolicy) {
            case 3: {
                return start.left < availableRect.left;
            }
            case 2: {
                return start.right > availableRect.right;
            }
        }
        return start.right > availableRect.right || start.bottom > availableRect.bottom;
    }

    private void shiftStartingPoint(Rect posposal, Rect availableRect, int shiftPolicy) {
        int defaultFreeformStepHorizontal = TaskLaunchParamsModifier.getHorizontalStep(availableRect);
        int defaultFreeformStepVertical = TaskLaunchParamsModifier.getVerticalStep(availableRect);
        switch (shiftPolicy) {
            case 3: {
                posposal.offset(-defaultFreeformStepHorizontal, 0);
                break;
            }
            case 2: {
                posposal.offset(defaultFreeformStepHorizontal, 0);
                break;
            }
            default: {
                posposal.offset(defaultFreeformStepHorizontal, defaultFreeformStepVertical);
            }
        }
    }

    private static boolean boundsConflict(Rect proposal, ArrayList<TaskRecord> tasks) {
        for (int i = tasks.size() - 1; i >= 0; --i) {
            Rect bounds;
            TaskRecord task = tasks.get(i);
            if (task.mActivities.isEmpty() || task.matchParentBounds() || !TaskLaunchParamsModifier.closeLeftTopCorner(proposal, bounds = task.getOverrideBounds()) && !TaskLaunchParamsModifier.closeRightTopCorner(proposal, bounds) && !TaskLaunchParamsModifier.closeLeftBottomCorner(proposal, bounds) && !TaskLaunchParamsModifier.closeRightBottomCorner(proposal, bounds)) continue;
            return true;
        }
        return false;
    }

    private static final boolean closeLeftTopCorner(Rect first, Rect second) {
        return Math.abs(first.left - second.left) < 4 && Math.abs(first.top - second.top) < 4;
    }

    private static final boolean closeRightTopCorner(Rect first, Rect second) {
        return Math.abs(first.right - second.right) < 4 && Math.abs(first.top - second.top) < 4;
    }

    private static final boolean closeLeftBottomCorner(Rect first, Rect second) {
        return Math.abs(first.left - second.left) < 4 && Math.abs(first.bottom - second.bottom) < 4;
    }

    private static final boolean closeRightBottomCorner(Rect first, Rect second) {
        return Math.abs(first.right - second.right) < 4 && Math.abs(first.bottom - second.bottom) < 4;
    }
}

