/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup;

import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.os.RemoteException;
import android.util.Slog;
import com.android.server.backup.BackupManagerConstants;
import com.android.server.backup.BackupManagerService;
import com.android.server.backup.Trampoline;
import java.util.Random;

public class KeyValueBackupJob
extends JobService {
    private static final String TAG = "KeyValueBackupJob";
    private static ComponentName sKeyValueJobService = new ComponentName("android", KeyValueBackupJob.class.getName());
    private static final int JOB_ID = 20537;
    private static final long MAX_DEFERRAL = 86400000L;
    private static boolean sScheduled = false;
    private static long sNextScheduled = 0L;

    public static void schedule(Context ctx, BackupManagerConstants constants) {
        KeyValueBackupJob.schedule(ctx, 0L, constants);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void schedule(Context ctx, long delay, BackupManagerConstants constants) {
        Class<KeyValueBackupJob> clazz = KeyValueBackupJob.class;
        synchronized (KeyValueBackupJob.class) {
            boolean needsCharging;
            int networkType;
            long fuzz;
            long interval;
            if (sScheduled) {
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
            BackupManagerConstants backupManagerConstants = constants;
            synchronized (backupManagerConstants) {
                interval = constants.getKeyValueBackupIntervalMilliseconds();
                fuzz = constants.getKeyValueBackupFuzzMilliseconds();
                networkType = constants.getKeyValueBackupRequiredNetworkType();
                needsCharging = constants.getKeyValueBackupRequireCharging();
            }
            if (delay <= 0L) {
                delay = interval + (long)new Random().nextInt((int)fuzz);
            }
            Slog.v(TAG, "Scheduling k/v pass in " + delay / 1000L / 60L + " minutes");
            JobInfo.Builder builder = new JobInfo.Builder(20537, sKeyValueJobService).setMinimumLatency(delay).setRequiredNetworkType(networkType).setRequiresCharging(needsCharging).setOverrideDeadline(86400000L);
            JobScheduler js = (JobScheduler)ctx.getSystemService("jobscheduler");
            js.schedule(builder.build());
            sNextScheduled = System.currentTimeMillis() + delay;
            sScheduled = true;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancel(Context ctx) {
        Class<KeyValueBackupJob> clazz = KeyValueBackupJob.class;
        synchronized (KeyValueBackupJob.class) {
            JobScheduler js = (JobScheduler)ctx.getSystemService("jobscheduler");
            js.cancel(20537);
            sNextScheduled = 0L;
            sScheduled = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long nextScheduled() {
        Class<KeyValueBackupJob> clazz = KeyValueBackupJob.class;
        synchronized (KeyValueBackupJob.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return sNextScheduled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onStartJob(JobParameters params) {
        Class<KeyValueBackupJob> clazz = KeyValueBackupJob.class;
        synchronized (KeyValueBackupJob.class) {
            sNextScheduled = 0L;
            sScheduled = false;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            Trampoline service = BackupManagerService.getInstance();
            try {
                service.backupNow();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return false;
        }
    }

    @Override
    public boolean onStopJob(JobParameters params) {
        return false;
    }
}

