/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup;

import android.app.IWallpaperManager;
import android.app.backup.BackupAgentHelper;
import android.app.backup.BackupDataInput;
import android.app.backup.BackupDataOutput;
import android.app.backup.FullBackup;
import android.app.backup.FullBackupDataOutput;
import android.app.backup.WallpaperBackupHelper;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Slog;
import com.android.server.backup.AccountManagerBackupHelper;
import com.android.server.backup.AccountSyncSettingsBackupHelper;
import com.android.server.backup.NotificationBackupHelper;
import com.android.server.backup.PermissionBackupHelper;
import com.android.server.backup.PreferredActivityBackupHelper;
import com.android.server.backup.ShortcutBackupHelper;
import com.android.server.backup.SliceBackupHelper;
import com.android.server.backup.UsageStatsBackupHelper;
import java.io.File;
import java.io.IOException;

public class SystemBackupAgent
extends BackupAgentHelper {
    private static final String TAG = "SystemBackupAgent";
    private static final String WALLPAPER_HELPER = "wallpaper";
    private static final String SYNC_SETTINGS_HELPER = "account_sync_settings";
    private static final String PREFERRED_HELPER = "preferred_activities";
    private static final String NOTIFICATION_HELPER = "notifications";
    private static final String PERMISSION_HELPER = "permissions";
    private static final String USAGE_STATS_HELPER = "usage_stats";
    private static final String SHORTCUT_MANAGER_HELPER = "shortcut_manager";
    private static final String ACCOUNT_MANAGER_HELPER = "account_manager";
    private static final String SLICES_HELPER = "slices";
    private static final String WALLPAPER_IMAGE_FILENAME = "wallpaper";
    private static final String WALLPAPER_INFO_FILENAME = "wallpaper_info.xml";
    private static final String WALLPAPER_IMAGE_DIR = Environment.getUserSystemDirectory(0).getAbsolutePath();
    public static final String WALLPAPER_IMAGE = new File(Environment.getUserSystemDirectory(0), "wallpaper").getAbsolutePath();
    private static final String WALLPAPER_INFO_DIR = Environment.getUserSystemDirectory(0).getAbsolutePath();
    public static final String WALLPAPER_INFO = new File(Environment.getUserSystemDirectory(0), "wallpaper_info.xml").getAbsolutePath();
    private static final String WALLPAPER_IMAGE_KEY = "/data/data/com.android.settings/files/wallpaper";
    private WallpaperBackupHelper mWallpaperHelper = null;

    @Override
    public void onBackup(ParcelFileDescriptor oldState, BackupDataOutput data, ParcelFileDescriptor newState) throws IOException {
        this.addHelper(SYNC_SETTINGS_HELPER, new AccountSyncSettingsBackupHelper(this));
        this.addHelper(PREFERRED_HELPER, new PreferredActivityBackupHelper());
        this.addHelper(NOTIFICATION_HELPER, new NotificationBackupHelper(this));
        this.addHelper(PERMISSION_HELPER, new PermissionBackupHelper());
        this.addHelper(USAGE_STATS_HELPER, new UsageStatsBackupHelper(this));
        this.addHelper(SHORTCUT_MANAGER_HELPER, new ShortcutBackupHelper());
        this.addHelper(ACCOUNT_MANAGER_HELPER, new AccountManagerBackupHelper());
        this.addHelper(SLICES_HELPER, new SliceBackupHelper(this));
        super.onBackup(oldState, data, newState);
    }

    @Override
    public void onFullBackup(FullBackupDataOutput data) throws IOException {
    }

    @Override
    public void onRestore(BackupDataInput data, int appVersionCode, ParcelFileDescriptor newState) throws IOException {
        this.mWallpaperHelper = new WallpaperBackupHelper(this, new String[]{WALLPAPER_IMAGE_KEY});
        this.addHelper("wallpaper", this.mWallpaperHelper);
        this.addHelper("system_files", new WallpaperBackupHelper(this, new String[]{WALLPAPER_IMAGE_KEY}));
        this.addHelper(SYNC_SETTINGS_HELPER, new AccountSyncSettingsBackupHelper(this));
        this.addHelper(PREFERRED_HELPER, new PreferredActivityBackupHelper());
        this.addHelper(NOTIFICATION_HELPER, new NotificationBackupHelper(this));
        this.addHelper(PERMISSION_HELPER, new PermissionBackupHelper());
        this.addHelper(USAGE_STATS_HELPER, new UsageStatsBackupHelper(this));
        this.addHelper(SHORTCUT_MANAGER_HELPER, new ShortcutBackupHelper());
        this.addHelper(ACCOUNT_MANAGER_HELPER, new AccountManagerBackupHelper());
        this.addHelper(SLICES_HELPER, new SliceBackupHelper(this));
        super.onRestore(data, appVersionCode, newState);
    }

    @Override
    public void onRestoreFile(ParcelFileDescriptor data, long size, int type, String domain, String path, long mode, long mtime) throws IOException {
        block10: {
            Slog.i(TAG, "Restoring file domain=" + domain + " path=" + path);
            boolean restoredWallpaper = false;
            File outFile = null;
            if (domain.equals("r")) {
                if (path.equals(WALLPAPER_INFO_FILENAME)) {
                    outFile = new File(WALLPAPER_INFO);
                    restoredWallpaper = true;
                } else if (path.equals("wallpaper")) {
                    outFile = new File(WALLPAPER_IMAGE);
                    restoredWallpaper = true;
                }
            }
            try {
                IWallpaperManager wallpaper;
                if (outFile == null) {
                    Slog.w(TAG, "Skipping unrecognized system file: [ " + domain + " : " + path + " ]");
                }
                FullBackup.restoreFile(data, size, type, mode, mtime, outFile);
                if (restoredWallpaper && (wallpaper = (IWallpaperManager)((Object)ServiceManager.getService("wallpaper"))) != null) {
                    try {
                        wallpaper.settingsRestored();
                    }
                    catch (RemoteException re) {
                        Slog.e(TAG, "Couldn't restore settings\n" + re);
                    }
                }
            }
            catch (IOException e) {
                if (!restoredWallpaper) break block10;
                new File(WALLPAPER_IMAGE).delete();
                new File(WALLPAPER_INFO).delete();
            }
        }
    }
}

