/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.internal;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Message;
import android.util.Slog;
import com.android.server.backup.BackupManagerService;

public class RunBackupReceiver
extends BroadcastReceiver {
    private BackupManagerService backupManagerService;

    public RunBackupReceiver(BackupManagerService backupManagerService) {
        this.backupManagerService = backupManagerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReceive(Context context, Intent intent) {
        if ("android.app.backup.intent.RUN".equals(intent.getAction())) {
            Object object = this.backupManagerService.getQueueLock();
            synchronized (object) {
                if (this.backupManagerService.getPendingInits().size() > 0) {
                    try {
                        this.backupManagerService.getAlarmManager().cancel(this.backupManagerService.getRunInitIntent());
                        this.backupManagerService.getRunInitIntent().send();
                    }
                    catch (PendingIntent.CanceledException ce) {
                        Slog.e("BackupManagerService", "Run init intent cancelled");
                    }
                } else if (this.backupManagerService.isEnabled() && this.backupManagerService.isProvisioned()) {
                    if (!this.backupManagerService.isBackupRunning()) {
                        Slog.v("BackupManagerService", "Running a backup pass");
                        this.backupManagerService.setBackupRunning(true);
                        this.backupManagerService.getWakelock().acquire();
                        Message msg = this.backupManagerService.getBackupHandler().obtainMessage(1);
                        this.backupManagerService.getBackupHandler().sendMessage(msg);
                    } else {
                        Slog.i("BackupManagerService", "Backup time but one already running");
                    }
                } else {
                    Slog.w("BackupManagerService", "Backup pass but e=" + this.backupManagerService.isEnabled() + " p=" + this.backupManagerService.isProvisioned());
                }
            }
        }
    }
}

