/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.transport;

import android.content.ComponentName;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public class TransportStats {
    private final Object mStatsLock = new Object();
    private final Map<ComponentName, Stats> mTransportStats = new HashMap<ComponentName, Stats>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerConnectionTime(ComponentName transportComponent, long timeMs) {
        Object object = this.mStatsLock;
        synchronized (object) {
            Stats stats = this.mTransportStats.get(transportComponent);
            if (stats == null) {
                stats = new Stats();
                this.mTransportStats.put(transportComponent, stats);
            }
            stats.register(timeMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stats getStatsForTransport(ComponentName transportComponent) {
        Object object = this.mStatsLock;
        synchronized (object) {
            Stats stats = this.mTransportStats.get(transportComponent);
            if (stats == null) {
                return null;
            }
            return new Stats(stats);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw) {
        Object object = this.mStatsLock;
        synchronized (object) {
            Optional<Stats> aggregatedStats = this.mTransportStats.values().stream().reduce(Stats::merge);
            if (aggregatedStats.isPresent()) {
                TransportStats.dumpStats(pw, "", aggregatedStats.get());
            }
            if (!this.mTransportStats.isEmpty()) {
                pw.println("Per transport:");
                for (ComponentName transportComponent : this.mTransportStats.keySet()) {
                    Stats stats = this.mTransportStats.get(transportComponent);
                    pw.println("    " + transportComponent.flattenToShortString());
                    TransportStats.dumpStats(pw, "        ", stats);
                }
            }
        }
    }

    private static void dumpStats(PrintWriter pw, String prefix, Stats stats) {
        pw.println(String.format(Locale.US, "%sAverage connection time: %.2f ms", prefix, stats.average));
        pw.println(String.format(Locale.US, "%sMax connection time: %d ms", prefix, stats.max));
        pw.println(String.format(Locale.US, "%sMin connection time: %d ms", prefix, stats.min));
        pw.println(String.format(Locale.US, "%sNumber of connections: %d ", prefix, stats.n));
    }

    public static final class Stats {
        public int n;
        public double average;
        public long max;
        public long min;

        public static Stats merge(Stats a, Stats b) {
            return new Stats(a.n + b.n, (a.average * (double)a.n + b.average * (double)b.n) / (double)(a.n + b.n), Math.max(a.max, b.max), Math.min(a.min, b.min));
        }

        public Stats() {
            this.n = 0;
            this.average = 0.0;
            this.max = 0L;
            this.min = Long.MAX_VALUE;
        }

        private Stats(int n, double average, long max, long min) {
            this.n = n;
            this.average = average;
            this.max = max;
            this.min = min;
        }

        private Stats(Stats original) {
            this(original.n, original.average, original.max, original.min);
        }

        private void register(long sample) {
            this.average = (this.average * (double)this.n + (double)sample) / (double)(this.n + 1);
            ++this.n;
            this.max = Math.max(this.max, sample);
            this.min = Math.min(this.min, sample);
        }
    }
}

