/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.utils;

import android.app.backup.IFullBackupRestoreObserver;
import android.os.RemoteException;
import android.util.Slog;

public class FullBackupRestoreObserverUtils {
    public static IFullBackupRestoreObserver sendStartRestore(IFullBackupRestoreObserver observer) {
        if (observer != null) {
            try {
                observer.onStartRestore();
            }
            catch (RemoteException e) {
                Slog.w("BackupManagerService", "full restore observer went away: startRestore");
                observer = null;
            }
        }
        return observer;
    }

    public static IFullBackupRestoreObserver sendOnRestorePackage(IFullBackupRestoreObserver observer, String name) {
        if (observer != null) {
            try {
                observer.onRestorePackage(name);
            }
            catch (RemoteException e) {
                Slog.w("BackupManagerService", "full restore observer went away: restorePackage");
                observer = null;
            }
        }
        return observer;
    }

    public static IFullBackupRestoreObserver sendEndRestore(IFullBackupRestoreObserver observer) {
        if (observer != null) {
            try {
                observer.onEndRestore();
            }
            catch (RemoteException e) {
                Slog.w("BackupManagerService", "full restore observer went away: endRestore");
                observer = null;
            }
        }
        return observer;
    }
}

