/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.broadcastradio.hal1;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.hardware.radio.ITuner;
import android.hardware.radio.ITunerCallback;
import android.hardware.radio.ProgramList;
import android.hardware.radio.ProgramSelector;
import android.hardware.radio.RadioManager;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Slog;
import com.android.server.broadcastradio.hal1.TunerCallback;
import java.util.List;
import java.util.Map;

class Tuner
extends ITuner.Stub {
    private static final String TAG = "BroadcastRadioService.Tuner";
    private final long mNativeContext;
    private final Object mLock = new Object();
    private final TunerCallback mTunerCallback;
    private final ITunerCallback mClientCallback;
    private final IBinder.DeathRecipient mDeathRecipient;
    private boolean mIsClosed = false;
    private boolean mIsMuted = false;
    private int mRegion;
    private final boolean mWithAudio;

    Tuner(ITunerCallback clientCallback, int halRev, int region, boolean withAudio, int band) {
        this.mClientCallback = clientCallback;
        this.mTunerCallback = new TunerCallback(this, clientCallback, halRev);
        this.mRegion = region;
        this.mWithAudio = withAudio;
        this.mNativeContext = this.nativeInit(halRev, withAudio, band);
        this.mDeathRecipient = this::close;
        try {
            this.mClientCallback.asBinder().linkToDeath(this.mDeathRecipient, 0);
        }
        catch (RemoteException ex) {
            this.close();
        }
    }

    protected void finalize() throws Throwable {
        this.nativeFinalize(this.mNativeContext);
        super.finalize();
    }

    private native long nativeInit(int var1, boolean var2, int var3);

    private native void nativeFinalize(long var1);

    private native void nativeClose(long var1);

    private native void nativeSetConfiguration(long var1, RadioManager.BandConfig var3);

    private native RadioManager.BandConfig nativeGetConfiguration(long var1, int var3);

    private native void nativeStep(long var1, boolean var3, boolean var4);

    private native void nativeScan(long var1, boolean var3, boolean var4);

    private native void nativeTune(long var1, ProgramSelector var3);

    private native void nativeCancel(long var1);

    private native void nativeCancelAnnouncement(long var1);

    private native boolean nativeStartBackgroundScan(long var1);

    private native List<RadioManager.ProgramInfo> nativeGetProgramList(long var1, Map<String, String> var3);

    private native byte[] nativeGetImage(long var1, int var3);

    private native boolean nativeIsAnalogForced(long var1);

    private native void nativeSetAnalogForced(long var1, boolean var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsClosed) {
                return;
            }
            this.mIsClosed = true;
            this.mTunerCallback.detach();
            this.mClientCallback.asBinder().unlinkToDeath(this.mDeathRecipient, 0);
            this.nativeClose(this.mNativeContext);
        }
    }

    @Override
    public boolean isClosed() {
        return this.mIsClosed;
    }

    private void checkNotClosedLocked() {
        if (this.mIsClosed) {
            throw new IllegalStateException("Tuner is closed, no further operations are allowed");
        }
    }

    private boolean checkConfiguredLocked() {
        if (this.mTunerCallback.isInitialConfigurationDone()) {
            return true;
        }
        Slog.w(TAG, "Initial configuration is still pending, skipping the operation");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConfiguration(RadioManager.BandConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("The argument must not be a null pointer");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotClosedLocked();
            this.nativeSetConfiguration(this.mNativeContext, config);
            this.mRegion = config.getRegion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RadioManager.BandConfig getConfiguration() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotClosedLocked();
            return this.nativeGetConfiguration(this.mNativeContext, this.mRegion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMuted(boolean mute) {
        if (!this.mWithAudio) {
            throw new IllegalStateException("Can't operate on mute - no audio requested");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotClosedLocked();
            if (this.mIsMuted == mute) {
                return;
            }
            this.mIsMuted = mute;
            Slog.w(TAG, "Mute via RadioService is not implemented - please handle it via app");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMuted() {
        if (!this.mWithAudio) {
            Slog.w(TAG, "Tuner did not request audio, pretending it was muted");
            return true;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotClosedLocked();
            return this.mIsMuted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void step(boolean directionDown, boolean skipSubChannel) {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotClosedLocked();
            if (!this.checkConfiguredLocked()) {
                return;
            }
            this.nativeStep(this.mNativeContext, directionDown, skipSubChannel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scan(boolean directionDown, boolean skipSubChannel) {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotClosedLocked();
            if (!this.checkConfiguredLocked()) {
                return;
            }
            this.nativeScan(this.mNativeContext, directionDown, skipSubChannel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tune(ProgramSelector selector) {
        if (selector == null) {
            throw new IllegalArgumentException("The argument must not be a null pointer");
        }
        Slog.i(TAG, "Tuning to " + selector);
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotClosedLocked();
            if (!this.checkConfiguredLocked()) {
                return;
            }
            this.nativeTune(this.mNativeContext, selector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotClosedLocked();
            this.nativeCancel(this.mNativeContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAnnouncement() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotClosedLocked();
            this.nativeCancelAnnouncement(this.mNativeContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitmap getImage(int id2) {
        byte[] rawImage;
        if (id2 == 0) {
            throw new IllegalArgumentException("Image ID is missing");
        }
        Object object = this.mLock;
        synchronized (object) {
            rawImage = this.nativeGetImage(this.mNativeContext, id2);
        }
        if (rawImage == null || rawImage.length == 0) {
            return null;
        }
        return BitmapFactory.decodeByteArray(rawImage, 0, rawImage.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startBackgroundScan() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotClosedLocked();
            return this.nativeStartBackgroundScan(this.mNativeContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<RadioManager.ProgramInfo> getProgramList(Map vendorFilter) {
        Map sFilter = vendorFilter;
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotClosedLocked();
            List<RadioManager.ProgramInfo> list = this.nativeGetProgramList(this.mNativeContext, sFilter);
            if (list == null) {
                throw new IllegalStateException("Program list is not ready");
            }
            return list;
        }
    }

    @Override
    public void startProgramListUpdates(ProgramList.Filter filter) {
        this.mTunerCallback.startProgramListUpdates(filter);
    }

    @Override
    public void stopProgramListUpdates() {
        this.mTunerCallback.stopProgramListUpdates();
    }

    @Override
    public boolean isConfigFlagSupported(int flag) {
        return flag == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConfigFlagSet(int flag) {
        if (flag == 2) {
            Object object = this.mLock;
            synchronized (object) {
                this.checkNotClosedLocked();
                return this.nativeIsAnalogForced(this.mNativeContext);
            }
        }
        throw new UnsupportedOperationException("Not supported by HAL 1.x");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConfigFlag(int flag, boolean value) {
        if (flag == 2) {
            Object object = this.mLock;
            synchronized (object) {
                this.checkNotClosedLocked();
                this.nativeSetAnalogForced(this.mNativeContext, value);
                return;
            }
        }
        throw new UnsupportedOperationException("Not supported by HAL 1.x");
    }

    @Override
    public Map setParameters(Map parameters) {
        throw new UnsupportedOperationException("Not supported by HAL 1.x");
    }

    @Override
    public Map getParameters(List<String> keys) {
        throw new UnsupportedOperationException("Not supported by HAL 1.x");
    }
}

