/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.broadcastradio.hal2;

import android.graphics.Bitmap;
import android.hardware.broadcastradio.V2_0.ConfigFlag;
import android.hardware.broadcastradio.V2_0.ITunerSession;
import android.hardware.radio.ITuner;
import android.hardware.radio.ProgramList;
import android.hardware.radio.ProgramSelector;
import android.hardware.radio.RadioManager;
import android.os.RemoteException;
import android.util.MutableBoolean;
import android.util.MutableInt;
import android.util.Slog;
import com.android.server.broadcastradio.hal2.Convert;
import com.android.server.broadcastradio.hal2.RadioModule;
import com.android.server.broadcastradio.hal2.TunerCallback;
import com.android.server.broadcastradio.hal2.Utils;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class TunerSession
extends ITuner.Stub {
    private static final String TAG = "BcRadio2Srv.session";
    private static final String kAudioDeviceName = "Radio tuner source";
    private final Object mLock = new Object();
    private final RadioModule mModule;
    private final ITunerSession mHwSession;
    private final TunerCallback mCallback;
    private boolean mIsClosed = false;
    private boolean mIsMuted = false;
    private RadioManager.BandConfig mDummyConfig = null;

    TunerSession(RadioModule module, ITunerSession hwSession, TunerCallback callback) {
        this.mModule = Objects.requireNonNull(module);
        this.mHwSession = Objects.requireNonNull(hwSession);
        this.mCallback = Objects.requireNonNull(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsClosed) {
                return;
            }
            this.mIsClosed = true;
        }
    }

    @Override
    public boolean isClosed() {
        return this.mIsClosed;
    }

    private void checkNotClosedLocked() {
        if (this.mIsClosed) {
            throw new IllegalStateException("Tuner is closed, no further operations are allowed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConfiguration(RadioManager.BandConfig config) {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotClosedLocked();
            this.mDummyConfig = Objects.requireNonNull(config);
            Slog.i(TAG, "Ignoring setConfiguration - not applicable for broadcastradio HAL 2.x");
            TunerCallback.dispatch(() -> this.mCallback.mClientCb.onConfigurationChanged(config));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RadioManager.BandConfig getConfiguration() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotClosedLocked();
            return this.mDummyConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMuted(boolean mute) {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotClosedLocked();
            if (this.mIsMuted == mute) {
                return;
            }
            this.mIsMuted = mute;
            Slog.w(TAG, "Mute via RadioService is not implemented - please handle it via app");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMuted() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotClosedLocked();
            return this.mIsMuted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void step(boolean directionDown, boolean skipSubChannel) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotClosedLocked();
            int halResult = this.mHwSession.step(!directionDown);
            Convert.throwOnError("step", halResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scan(boolean directionDown, boolean skipSubChannel) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotClosedLocked();
            int halResult = this.mHwSession.scan(!directionDown, skipSubChannel);
            Convert.throwOnError("step", halResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tune(ProgramSelector selector) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotClosedLocked();
            int halResult = this.mHwSession.tune(Convert.programSelectorToHal(selector));
            Convert.throwOnError("tune", halResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotClosedLocked();
            Utils.maybeRethrow(this.mHwSession::cancel);
        }
    }

    @Override
    public void cancelAnnouncement() {
        Slog.i(TAG, "Announcements control doesn't involve cancelling at the HAL level in 2.x");
    }

    @Override
    public Bitmap getImage(int id2) {
        return this.mModule.getImage(id2);
    }

    @Override
    public boolean startBackgroundScan() {
        Slog.i(TAG, "Explicit background scan trigger is not supported with HAL 2.x");
        TunerCallback.dispatch(() -> this.mCallback.mClientCb.onBackgroundScanComplete());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startProgramListUpdates(ProgramList.Filter filter) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotClosedLocked();
            int halResult = this.mHwSession.startProgramListUpdates(Convert.programFilterToHal(filter));
            Convert.throwOnError("startProgramListUpdates", halResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopProgramListUpdates() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotClosedLocked();
            this.mHwSession.stopProgramListUpdates();
        }
    }

    @Override
    public boolean isConfigFlagSupported(int flag) {
        try {
            this.isConfigFlagSet(flag);
            return true;
        }
        catch (IllegalStateException ex) {
            return true;
        }
        catch (UnsupportedOperationException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConfigFlagSet(int flag) {
        Slog.v(TAG, "isConfigFlagSet " + ConfigFlag.toString(flag));
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotClosedLocked();
            MutableInt halResult = new MutableInt(1);
            MutableBoolean flagState = new MutableBoolean(false);
            try {
                this.mHwSession.isConfigFlagSet(flag, (result, value) -> {
                    halResult.value = result;
                    flagState.value = value;
                });
            }
            catch (RemoteException ex) {
                throw new RuntimeException("Failed to check flag " + ConfigFlag.toString(flag), ex);
            }
            Convert.throwOnError("isConfigFlagSet", halResult.value);
            return flagState.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConfigFlag(int flag, boolean value) throws RemoteException {
        Slog.v(TAG, "setConfigFlag " + ConfigFlag.toString(flag) + " = " + value);
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotClosedLocked();
            int halResult = this.mHwSession.setConfigFlag(flag, value);
            Convert.throwOnError("setConfigFlag", halResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map setParameters(Map parameters) {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotClosedLocked();
            return Convert.vendorInfoFromHal(Utils.maybeRethrow(() -> this.mHwSession.setParameters(Convert.vendorInfoToHal(parameters))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map getParameters(List<String> keys) {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotClosedLocked();
            return Convert.vendorInfoFromHal(Utils.maybeRethrow(() -> this.mHwSession.getParameters(Convert.listToArrayList(keys))));
        }
    }
}

